<?

	/*==================================================================*\
	######################################################################
	#                                                                    #
	# Copyright 2005 Arca Solutions, Inc. All Rights Reserved.           #
	#                                                                    #
	# This file may not be redistributed in whole or part.               #
	# eDirectory is licensed on a per-domain basis.                      #
	#                                                                    #
	# ---------------- eDirectory IS NOT FREE SOFTWARE ----------------- #
	#                                                                    #
	# http://www.edirectory.com | http://www.edirectory.com/license.html #
	######################################################################
	\*==================================================================*/

	# ----------------------------------------------------------------------------------------------------
	# * FILE: /includes/views/view_classified_summary.php
	# ----------------------------------------------------------------------------------------------------

	# ----------------------------------------------------------------------------------------------------
	# DEFINES
	# ----------------------------------------------------------------------------------------------------
    //
    //Get fields according to level
    unset($array_fields);
    $array_fields = system_getFormFields("Classified", $classified->getNumber("level"));

    if (!$isMobileSummary) {
        $classified_icon_navbar = "";
        include(EDIRECTORY_ROOT."/includes/views/icon_classified.php");
        $classified_icon_navbar = $icon_navbar;
        $icon_navbar = "";
    }
    
    if ($isMobileSummary) {
        $detailLink = "".MOBILE_DEFAULT_URL."/".CLASSIFIED_FEATURE_FOLDER."/".$classified->getString("friendly_url").".html";
    } else {
        $detailLink = "".CLASSIFIED_DEFAULT_URL."/".$classified->getString("friendly_url").".html";
    }
    
	$friendly_url = $classified->getString('friendly_url');
	
    if (!$isMobileSummary) {
        if ((string_strpos($_SERVER["REQUEST_URI"], "results.php") !== false || string_strpos($_SERVER["REQUEST_URI"], ALIAS_CLASSIFIED_MODULE."/".ALIAS_CATEGORY_URL_DIVISOR."/") !== false || string_strpos($_SERVER["REQUEST_URI"], ALIAS_CLASSIFIED_MODULE."/".ALIAS_LOCATION_URL_DIVISOR."/") !== false) && GOOGLE_MAPS_ENABLED == "on" && $mapObj->getString("value") == "on") { 
            if ($classified->getString("latitude") && $classified->getString("longitude")) {
                $show_map = true;
            } else {
                $show_map = false;
            }
        }
    }
	
	if (($user) && ($level->getDetail($classified->getNumber("level")) == "y")) { 
		$show_detailLink = true;
	}else{
		$show_detailLink = false;
	}
	
	unset($distance_label);
	if (zipproximity_getDistanceLabel($zip, "classified", $classified->getNumber("id"), $distance_label)) {
		$distance_label = " (".$distance_label.")";
	}
	
	unset($title);
	if ($show_detailLink) {
		$title = "<a href=\"".$detailLink."\">";
		$title .= $classified->getString("title").$distance_label;
		$title .= "</a>";
	} else {
		$title = $classified->getString("title").$distance_label;
	}
	
	if ($tPreview) {
		$complementary_info = system_showText(LANG_IN)." "; 
		$complementary_info .= "<a href=\"javascript:void(0);\" style=\"cursor: default;\">".system_showText(LANG_LABEL_ADVERTISE_CATEGORY)."</a>";
	} else {
		if (CLASSIFIED_SCALABILITY_OPTIMIZATION == "on") {
			$complementary_info = "<a href=\"javascript: void(0);\" ".($user ? "onclick=\"showCategory(".htmlspecialchars($classified->getNumber("id")).", 'classified', ".($user ? true : false).", ".$classified->getNumber("account_id").")\"" : "style=\"cursor: default;\"").">".system_showText(LANG_VIEWCATEGORY)."</a>";
		} else {
			$complementary_info = system_itemRelatedCategories($classified->getNumber("id"), "classified", $user);
		}	
	}
    
    if ($tPreview) {
		$location = system_getLocationStringPreview($classified);
	} else {
		$locationsToshow = system_retrieveLocationsToShow();
		$locationsParam = system_formatLocation($locationsToshow.", z");
		$location = $classified->getLocationString($locationsParam, true);
	}
	
	$address1 = $classified->getString("address");
	$address2 = $classified->getString("address2");
	
	if ($location) {
		$location = "<span>".$location."</span>";
	}
	if ($address1) {
		$address1 = "<span>".$address1."</span>";
	}
	if ($address2) {
		$address2 = "<span>".$address2."</span>";
	}    
	
	unset($imageTag);
    if (is_array($array_fields) && in_array("main_image", $array_fields)){
        if ($tPreview) {
            $imageTag = "<span class=\"no-image\" style=\"cursor: default;\"></span>";
        } else {
            if ($classified->getNumber("thumb_id")) {
                $imageObj = new Image($classified->getNumber((THEME_USE_IMAGE_BIG ? "image_id" : "thumb_id")));
                if ($imageObj->imageExists()) {
                    if ($show_detailLink){
                        $imageTag  = "<a href=\"".$detailLink."\">";
                        $imageTag .= $imageObj->getTag(THEME_RESIZE_IMAGE, IMAGE_CLASSIFIED_THUMB_WIDTH, IMAGE_CLASSIFIED_THUMB_HEIGHT, $classified->getString("title", false), THEME_RESIZE_IMAGE);
                        $imageTag .= "</a>";
                    } else {
                        $imageTag .= "<div class=\"no-link\">";
                        $imageTag .= $imageObj->getTag(THEME_RESIZE_IMAGE, IMAGE_CLASSIFIED_THUMB_WIDTH, IMAGE_CLASSIFIED_THUMB_HEIGHT, $classified->getString("title", false), THEME_RESIZE_IMAGE);
                        $imageTag .= "</div>";
                    }
                } elseif (!$isMobileSummary) {
                    if ($show_detailLink){
                        $imageTag =  "<a href=\"".$detailLink."\" class=\"image\">";
                        $imageTag .=  "<span class=\"no-image\"></span>";
                        $imageTag .=  "</a>";
                    } else {
                        $imageTag = "<span class=\"no-image no-link\"></span>";
                    }
                }
            } elseif (!$isMobileSummary) {
                if ($show_detailLink){
                    $imageTag =  "<a href=\"".$detailLink."\" class=\"image\">";
                    $imageTag .=  "<span class=\"no-image\"></span>";
                    $imageTag .=  "</a>";
                } else {
                    $imageTag = "<span class=\"no-image no-link\"></span>";
                }
            }
        }
    }
		
	unset($summaryDescription);
    if (is_array($array_fields) && in_array("summary_description", $array_fields)){
        $summaryDescription = nl2br($classified->getString("summarydesc", true));
    }
	
	unset($phone);
    if (is_array($array_fields) && in_array("contact_phone", $array_fields)){
        $phone = $classified->getString("phone");
    }
	
	$contact_email_style = "";
    unset($contact_email);
    if (is_array($array_fields) && in_array("contact_email", $array_fields)){
        if ($classified->getString("email")) {
            if ($user){ 
                $contact_email = DEFAULT_URL."/popup/popup.php?pop_type=classified_emailform&amp;id=".$classified->getNumber("id")."&amp;receiver=owner";
            } else { 
                $contact_email = "javascript:void(0);"; 
                $contact_email_style = "cursor:default";  
            }
        }
    }
	
	unset($display_url);
	if ($classified->getString("url") && (is_array($array_fields) && in_array("url", $array_fields))) {
		$display_urlStr = $classified->getString("url", true, 30);
		if ($user){
			$display_url = $classified->getString("url");
			$target = "target=\"_blank\"";
			$style = "";
		} else {
			$display_url = "javascript:void(0);";
			$target = "";
			$style = "style=\"cursor:default\"";
		}
	}
	
	unset($price);
    if (is_array($array_fields) && in_array("price", $array_fields)) {
        if ($classified->getString("classified_price") != "NULL"){
            $price = CURRENCY_SYMBOL." ".($classified->getString("classified_price"));
        }
    }
	
	unset($description);
    if (is_array($array_fields) && in_array("summary_description", $array_fields)) {
        $description = $classified->getString("description", true);
    }
    
    if (!$isMobileSummary) {
        $summaryFileName = INCLUDES_DIR."/views/view_classified_summary_code.php";
        $themeSummaryFileName = INCLUDES_DIR."/views/view_classified_summary_code_".EDIR_THEME.".php";

        if (file_exists($themeSummaryFileName)){
            include($themeSummaryFileName);
        } else {
            include($summaryFileName);
        }
    }
?>