

CREATE TABLE Account (
  id int(11) NOT NULL AUTO_INCREMENT,
  updated datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  entered datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  agree_tou char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  lastlogin datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  facebook_username varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  username varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  foreignaccount char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  foreignaccount_done char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  foreignaccount_redirect varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  foreignaccount_auth text COLLATE utf8_unicode_ci NOT NULL,
  facebook_firstname varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  facebook_lastname varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  faillogin_count int(11) NOT NULL DEFAULT '0',
  faillogin_datetime datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  importID int(11) NOT NULL DEFAULT '0',
  domain_importID int(11) NOT NULL,
  importID_event int(11) NOT NULL DEFAULT '0',
  domain_importID_event int(11) NOT NULL,
  is_sponsor char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  has_profile char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  publish_contact char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  notify_traffic_listing char(1) COLLATE utf8_unicode_ci NOT NULL,
  complementary_info varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  active char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  newsletter char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (id),
  KEY username (username),
  KEY lastlogin (lastlogin)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=335 ;

INSERT INTO Account (id, updated, entered, agree_tou, lastlogin, facebook_username, username, password, foreignaccount, foreignaccount_done, foreignaccount_redirect, foreignaccount_auth, facebook_firstname, facebook_lastname, faillogin_count, faillogin_datetime, importID, domain_importID, importID_event, domain_importID_event, is_sponsor, has_profile, publish_contact, notify_traffic_listing, complementary_info, active, newsletter) VALUES
(1, '2013-03-22 13:56:08', '2005-12-09 10:06:40', '1', '2013-02-28 17:24:52', '', 'john@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '4c54a9af028aa3103173ecc94354bdab', 'y', 'n'),
(2, '2012-11-30 11:02:46', '2005-12-09 12:41:31', '1', '2013-08-20 14:31:13', '', 'amanda@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '4cf80065d48e351b8affb0f10d6cf640', 'y', 'n'),
(3, '2013-05-28 12:59:40', '2005-12-09 12:52:39', '1', '2013-05-30 12:15:15', '', 'charles@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '5ed885b0ef43effc3ef08082d07e8018', 'y', 'n'),
(4, '2011-08-05 15:23:58', '2005-12-12 17:57:24', '0', '2012-11-30 14:44:35', '', 'jane@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'ab1a4a92351fad243d6a2b290fada31b', 'y', 'n'),
(6, '2013-03-22 13:55:40', '2005-12-20 16:53:40', '1', '2013-06-03 09:28:42', '', 'daniel@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '6963475e019879aa444eed9f2559e0fb', 'y', 'n'),
(7, '2013-09-05 17:26:15', '2005-12-20 17:42:50', '1', '2013-09-05 17:03:51', '', 'brandon@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '08515a776fdfb58b6fba1ecbc9a73d95', 'y', 'n'),
(8, '2013-05-28 12:04:26', '2005-12-20 18:14:48', '1', '2013-06-03 09:40:29', '', 'andrew@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '45c3345fe37bdee7f9ec0a49662fd4f8', 'y', 'n'),
(9, '2012-12-03 13:38:48', '2005-12-20 18:47:39', '1', '2013-06-03 09:16:56', '', 'julia@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'b2b8ba9e41e1e43c9f0a2dc834eb04a6', 'y', 'n'),
(10, '2013-07-24 15:41:24', '2005-12-20 19:11:43', '1', '2013-08-20 14:34:25', '', 'tony@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '8e83950e09d56cb7e44a27730bf5542a', 'y', 'n'),
(12, '2012-11-30 10:54:11', '2006-01-06 12:08:07', '0', '2012-11-30 16:02:42', '', 'george@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '79dfcba3fac62bca1e0bdc2236586732', 'y', 'n'),
(13, '2012-11-30 14:42:29', '2006-01-06 12:12:13', '0', '2012-11-30 14:42:29', '', 'beth@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '25949050f3ab3d5973e5dda9bcb1a64c', 'y', 'n'),
(14, '2012-11-30 11:05:20', '2006-01-06 12:15:08', '0', '2013-06-03 09:23:09', '', 'harold@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '8f603b69cd0b2dedac7896fca8539271', 'y', 'n'),
(15, '2013-03-22 13:55:32', '2006-01-06 12:16:50', '0', '2012-11-30 15:01:09', '', 'kath@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '29edd33b881e9bf67810ebc28e8c88c5', 'y', 'n'),
(16, '2012-11-30 14:58:35', '2006-01-06 12:19:05', '0', '2012-11-30 14:58:35', '', 'jake@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'd602aa6ab71dd5924b0e4146619fec4e', 'y', 'n'),
(17, '2013-05-29 12:02:28', '2006-01-06 12:21:00', '0', '2013-08-14 09:46:35', '', 'carl@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '843c1c298923fc7618e96e0ba37c615d', 'y', 'n'),
(18, '2012-11-30 10:55:33', '2006-01-06 12:22:17', '0', '2012-11-30 16:07:11', '', 'david@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '97c724bf4075dce5ca4d81398110e6d5', 'y', 'n'),
(19, '2013-08-20 14:30:53', '2006-01-06 12:24:24', '0', '2013-08-20 14:28:49', '', 'steve@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '35c492ac3f4af6e09eb75eae606a2dce', 'y', 'n'),
(20, '2013-03-12 09:45:33', '2006-01-06 12:26:15', '0', '2012-11-30 14:52:37', '', 'rachel@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '1660eae49fbebf828ddab35ab56e4db0', 'y', 'n'),
(22, '2013-08-22 09:36:22', '2006-01-10 10:41:50', '0', '2013-10-25 05:24:18', '', 'demo@demodirectory.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'y', 'n', '6f5e481b4f7bc8a013c08e62a46da89d', 'y', 'n'),
(252, '2013-07-30 11:30:37', '2004-05-26 10:16:41', '0', '2013-07-31 10:04:06', '', 'sophia@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '4b2f68d9f0a9fc9c3058d96c9388dae7', 'y', 'n'),
(218, '2012-12-03 13:31:46', '2007-04-02 00:00:00', '1', '2013-06-03 09:34:51', '', 'mark@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '80a75f5c98d55a1e65d4bed489ef09fa', 'y', 'n'),
(253, '2012-11-30 11:29:59', '2004-05-26 10:16:41', '0', '2012-11-30 16:27:53', '', 'emma@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '9d7da73aa1db5239c5821a0a9df1bc6c', 'y', 'n'),
(254, '2013-05-28 12:46:14', '2004-05-26 10:16:41', '0', '2013-05-30 14:29:52', '', 'olivia@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'ab2243e09b2290caa1bb07c7527742f7', 'y', 'n'),
(255, '2013-05-29 10:52:33', '2004-05-26 10:16:41', '0', '2013-02-28 17:37:32', '', 'ava@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'f140ffa1240bb6f9ea6991b0d6c0dade', 'y', 'n'),
(256, '2013-03-04 08:55:12', '2004-05-26 10:16:41', '0', '2013-03-04 08:55:28', '', 'emily@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'd17585bd9be5334bbf854052965f6934', 'y', 'n'),
(257, '2012-11-30 11:16:01', '2004-05-26 10:16:41', '0', '2012-11-30 15:40:06', '', 'abigail@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '706c4c49cd9adb8c069802ac125517a0', 'y', 'n'),
(258, '2012-11-30 11:43:16', '2004-05-26 10:16:41', '0', '2012-11-30 11:42:37', '', 'madison@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '07bb0b79efba533c5d6f35ef45ef63e4', 'y', 'n'),
(259, '2012-11-30 16:18:15', '2004-05-26 10:16:41', '0', '2012-11-30 16:18:15', '', 'chloe@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '840f3aec8b8e7a4fe0cb410fa84cb999', 'y', 'n'),
(260, '2012-12-03 09:17:42', '2004-05-26 10:16:41', '0', '2013-08-19 09:26:13', '', 'jacob@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '72a4942b7d43e129c8ab617d89245bab', 'y', 'n'),
(261, '2013-05-29 10:37:26', '2004-05-26 10:16:41', '0', '2013-05-30 12:21:00', '', 'susan@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '4123ae8648d880ce3e23bcd599bcb9af', 'y', 'n'),
(262, '2012-12-03 09:31:04', '2004-05-26 10:16:41', '0', '2012-12-03 09:31:04', '', 'ethan@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '2e586a89667a1a9fbd8791c1ec1e41f9', 'y', 'n'),
(263, '2012-11-30 10:56:49', '2004-05-26 10:16:41', '0', '2012-12-03 14:32:41', '', 'michael@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'b5cab30a5a8e35d1210779276dd4b5f2', 'y', 'n'),
(264, '2013-05-28 12:51:57', '2004-05-26 10:16:41', '0', '2013-05-30 11:27:39', '', 'william@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'fba218ec01ba768f388f9a34400acdcb', 'y', 'n'),
(265, '2012-12-03 16:32:35', '2004-05-26 10:16:41', '0', '2013-05-30 14:19:54', '', 'alexander@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'adede9332fa23297020004695f453e0a', 'y', 'n'),
(266, '2012-11-30 11:46:38', '2004-05-26 10:16:41', '0', '2012-11-30 11:46:00', '', 'noah@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'e4517444013084bf052bca042e7fc0a7', 'y', 'n'),
(267, '2013-02-28 17:40:42', '2004-05-26 10:16:41', '0', '2013-02-28 17:51:29', '', 'aiden@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '09c1d8fc8bd2fe7e65feaf94d1701d9e', 'y', 'n'),
(268, '2012-11-30 11:22:03', '2004-05-26 10:16:41', '0', '2012-11-30 16:13:27', '', 'anthony@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '31daca68d9408bc41928a7ee801f7a57', 'y', 'n'),
(269, '2012-11-30 11:45:46', '2004-05-26 10:16:41', '0', '2012-11-30 11:45:10', '', 'nicholas@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '34a5bbc862d81c84f61f8a324525f9a0', 'y', 'n'),
(270, '2013-05-29 10:42:00', '2004-05-26 10:16:41', '0', '2013-05-30 11:54:56', '', 'henry@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '6bae99e386213e446b20e01dc1dd1552', 'y', 'n'),
(271, '2012-12-03 09:25:15', '2004-05-26 10:16:41', '0', '2012-12-03 09:29:01', '', 'grace@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '19cab8913d67cde39c5b198e4aea8cf2', 'y', 'n'),
(272, '2013-05-29 10:40:32', '2004-05-26 10:16:41', '0', '2013-08-12 08:31:39', '', 'sarah@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'dd4090941b5c738822c1998562dc8b8b', 'y', 'n'),
(273, '2013-05-28 12:33:46', '2004-05-26 10:16:41', '0', '2013-05-30 13:26:32', '', 'layla@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'b2e9bf1637f49c952e45dfecb629b1f7', 'y', 'n'),
(274, '2012-12-03 08:48:36', '2004-05-26 10:16:41', '0', '2013-05-30 14:08:43', '', 'kimberly@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '523de1eb4cf108208fa4b83c2d14c443', 'y', 'n'),
(275, '2012-11-30 11:20:52', '2004-05-26 10:16:41', '0', '2013-06-03 09:35:36', '', 'andrea@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'a617ad3c908a796d2de1c8c3711da937', 'y', 'n'),
(276, '2013-05-28 12:38:55', '2004-05-26 10:16:41', '0', '2013-05-30 14:30:32', '', 'lucy@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'e1cb76fb0e230e07be56abad1c15573a', 'y', 'n'),
(277, '2012-12-03 09:34:17', '2004-05-26 10:16:41', '0', '2013-06-03 09:38:27', '', 'eric@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '0ac155d4f28f9da544311c69e03a60ae', 'y', 'n'),
(278, '2012-11-30 11:24:46', '2004-05-26 10:16:41', '0', '2012-11-30 16:16:15', '', 'chase@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'eb1afa58af256d22f5fae2c92f2b2d62', 'y', 'n'),
(279, '2013-05-28 12:24:32', '2004-05-26 10:16:41', '0', '2013-05-30 12:09:49', '', 'thomas@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 1, '2013-05-30 12:20:41', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '63355638fcadcb62d19a4a72dd91b9f5', 'y', 'n'),
(280, '2012-11-30 14:08:51', '2004-05-26 10:16:41', '0', '2012-11-30 14:08:51', '', 'scott@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'f283f653f984dc3b1d1a697cad0968a7', 'y', 'n'),
(281, '2013-05-29 10:37:49', '2004-05-26 10:16:41', '0', '2013-05-30 12:05:58', '', 'stacy@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'eb2d9d1e572d4a642935ad4d85777da7', 'y', 'n'),
(282, '2012-11-30 11:27:59', '2004-05-26 10:16:41', '0', '2013-05-29 11:52:46', '', 'derrick@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 5, '2013-05-30 11:54:14', 0, 0, 0, 0, 'y', 'y', 'n', 'n', 'c4bd0a9c919c61bdbca4ee6e135a81b0', 'y', 'n'),
(283, '2012-11-30 11:44:44', '2004-05-26 10:16:41', '0', '2012-11-30 11:43:48', '', 'melanie@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'n', 'y', 'n', 'n', '52b0f9b92e6da88fc26cc4feb325aca2', 'y', 'n'),
(284, '2013-07-30 11:33:46', '2004-05-26 10:16:41', '0', '2013-07-30 11:33:46', '', 'philip@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'n', 'y', 'n', 'n', '700859ec86e4d84dac6172d9d01ccb0b', 'y', 'n'),
(286, '2013-07-24 14:12:54', '2004-05-26 10:16:41', '0', '2013-07-24 14:12:54', '', 'amber@sample.com', 'e99a18c428cb38d5f260853678922e03', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'n', 'y', 'n', 'n', '43d1f2e57a731362dac4ffde6bcfebf0', 'y', 'n'),
(331, '2013-10-16 11:15:26', '2013-10-16 11:15:26', '0', '2013-10-16 11:15:41', 'facebook::ymanqidi_696951136', 'facebook::ymanqidi_696951136', 'd41d8cd98f00b204e9800998ecf8427e', 'y', 'y', '', 'uid=696951136 || nickname=Åyman Qàidi || first_name=Åyman || last_name=Qàidi || personal_message= || birthday_date=08/08/1988 || home_town=Irbil, Iraq || location=Wuppertal, Germany || picture=http://graph.facebook.com/696951136/picture?type=large || email=qaidi988@yahoo.de', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'n', 'y', 'n', 'n', '0896dc14d0e843ca0eec0a5310fbbf84', 'y', 'n'),
(332, '2013-10-18 04:02:43', '2013-10-18 04:02:43', '0', '2013-10-19 10:53:20', '', 'google::muchways02@gmail.com', 'd41d8cd98f00b204e9800998ecf8427e', 'y', 'y', '', 'first_name=Mohamed || last_name=Fathi || email=muchways02@gmail.com', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'n', 'y', 'n', 'n', '89732a4b40d2f99488173b62275ec336', 'y', 'n'),
(334, '2013-10-20 01:16:42', '2013-10-20 01:16:42', '1', '2013-10-20 01:16:48', '', 'test12@me.com', '7c6a180b36896a0a8c02787eeafb0e4c', 'n', 'n', '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'y', 'y', 'n', 'n', '3de690d52b715d514d4dbe3e4b8d9653', 'n', 'y');

CREATE TABLE Account_Activation (
  account_id int(11) NOT NULL DEFAULT '0',
  unique_key varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  entered date NOT NULL DEFAULT '0000-00-00',
  KEY account_id (account_id),
  KEY unique_key (unique_key),
  KEY entered (entered)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE Account_Domain (
  id int(11) NOT NULL AUTO_INCREMENT,
  account_id int(11) NOT NULL,
  domain_id int(11) NOT NULL,
  PRIMARY KEY (id),
  KEY account_domain (account_id,domain_id)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=215 ;

INSERT INTO Account_Domain (id, account_id, domain_id) VALUES
(1, 1, 1),
(91, 1, 2),
(64, 1, 3),
(152, 1, 7),
(168, 1, 8),
(2, 2, 1),
(85, 2, 2),
(74, 2, 3),
(194, 2, 6),
(189, 2, 7),
(166, 2, 8),
(3, 3, 1),
(73, 3, 3),
(138, 3, 7),
(4, 4, 1),
(80, 4, 2),
(75, 4, 3),
(177, 4, 8),
(5, 6, 1),
(79, 6, 3),
(127, 6, 7),
(181, 6, 8),
(6, 7, 1),
(82, 7, 2),
(78, 7, 3),
(137, 7, 7),
(165, 7, 8),
(7, 8, 1),
(95, 8, 3),
(150, 8, 7),
(178, 8, 8),
(8, 9, 1),
(93, 9, 2),
(62, 9, 3),
(123, 9, 7),
(9, 10, 1),
(94, 10, 3),
(142, 10, 7),
(174, 10, 8),
(10, 12, 1),
(72, 12, 3),
(146, 12, 7),
(11, 13, 1),
(90, 13, 2),
(76, 13, 3),
(12, 14, 1),
(70, 14, 3),
(129, 14, 7),
(183, 14, 8),
(13, 15, 1),
(87, 15, 2),
(69, 15, 3),
(144, 15, 7),
(163, 15, 8),
(14, 16, 1),
(67, 16, 3),
(124, 16, 7),
(170, 16, 8),
(15, 17, 1),
(63, 17, 3),
(192, 17, 6),
(132, 17, 7),
(162, 17, 8),
(16, 18, 1),
(71, 18, 3),
(122, 18, 7),
(17, 19, 1),
(81, 19, 2),
(66, 19, 3),
(206, 19, 6),
(126, 19, 7),
(175, 19, 8),
(18, 20, 1),
(89, 20, 2),
(68, 20, 3),
(167, 20, 8),
(19, 22, 1),
(61, 22, 3),
(158, 22, 6),
(125, 22, 7),
(184, 22, 8),
(21, 218, 1),
(65, 218, 3),
(134, 218, 7),
(160, 218, 8),
(26, 252, 1),
(118, 252, 3),
(141, 252, 7),
(164, 252, 8),
(27, 253, 1),
(108, 253, 3),
(136, 253, 7),
(173, 253, 8),
(28, 254, 1),
(155, 254, 7),
(29, 255, 1),
(83, 255, 2),
(112, 255, 3),
(30, 256, 1),
(109, 256, 3),
(31, 257, 1),
(116, 257, 3),
(32, 258, 1),
(33, 259, 1),
(111, 259, 3),
(34, 260, 1),
(88, 260, 2),
(103, 260, 3),
(207, 260, 6),
(145, 260, 7),
(169, 260, 8),
(35, 261, 1),
(107, 261, 3),
(149, 261, 7),
(36, 262, 1),
(99, 262, 3),
(37, 263, 1),
(92, 263, 2),
(77, 263, 3),
(38, 264, 1),
(106, 264, 3),
(156, 264, 7),
(39, 265, 1),
(84, 265, 2),
(97, 265, 3),
(133, 265, 7),
(40, 266, 1),
(41, 267, 1),
(115, 267, 3),
(42, 268, 1),
(114, 268, 3),
(143, 268, 7),
(161, 268, 8),
(43, 269, 1),
(151, 269, 7),
(44, 270, 1),
(102, 270, 3),
(148, 270, 7),
(45, 271, 1),
(101, 271, 3),
(46, 272, 1),
(100, 272, 3),
(208, 272, 6),
(128, 272, 7),
(171, 272, 8),
(47, 273, 1),
(120, 273, 3),
(154, 273, 7),
(48, 274, 1),
(104, 274, 3),
(131, 274, 7),
(49, 275, 1),
(96, 275, 3),
(147, 275, 7),
(172, 275, 8),
(50, 276, 1),
(105, 276, 3),
(135, 276, 7),
(180, 276, 8),
(51, 277, 1),
(86, 277, 2),
(98, 277, 3),
(130, 277, 7),
(179, 277, 8),
(52, 278, 1),
(113, 278, 3),
(140, 278, 7),
(53, 279, 1),
(121, 279, 3),
(153, 279, 7),
(176, 279, 8),
(54, 280, 1),
(117, 280, 3),
(55, 281, 1),
(119, 281, 3),
(157, 281, 7),
(56, 282, 1),
(110, 282, 3),
(139, 282, 7),
(57, 283, 1),
(58, 284, 1),
(191, 284, 7),
(60, 286, 1),
(188, 286, 7),
(210, 331, 1),
(211, 332, 1),
(213, 334, 1),
(214, 334, 47);

CREATE TABLE Contact (
  account_id int(11) NOT NULL DEFAULT '0',
  updated datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  entered datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  first_name varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  last_name varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  company varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  address varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  address2 varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  city varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  state varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  zip varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  country varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  phone varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  fax varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  email varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  url varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  importID int(11) NOT NULL DEFAULT '0',
  importID_event int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (account_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO Contact (account_id, updated, entered, first_name, last_name, company, address, address2, city, state, zip, country, phone, fax, email, url, importID, importID_event) VALUES
(1, '2012-11-30 12:01:24', '2005-12-09 10:06:40', 'John', 'Childs', 'Ads, Inc.', '5718 25th St N', '', 'Arlington', 'VA', '22207', '', '111 222 3333', '703 842 8199', 'test_email@edirectory.com', 'http://www.arcasolutions.com', 0, 0),
(2, '2012-11-30 11:02:46', '2005-12-09 12:41:31', 'Amanda', 'Jackson', 'The House', '123 Main Street N', 'Suite 03', 'Vienna', 'VA', '12345', '', '111 222 3333', '444 555 6666', 'test_email@edirectory.com', 'http://www.edirectory.com', 0, 0),
(3, '2013-05-28 12:59:40', '2005-12-09 12:52:39', 'Charles', 'Perkins', 'The View', '123 Main Street N', '', 'San Francisco', 'CA', '12345', '', '111 222 3333', '444 555 6666', 'charles@sample.com', 'http://www.arcasolutions.com', 0, 0),
(4, '2011-08-05 15:23:58', '2005-12-12 17:57:24', 'Jane', 'Lopes', 'Diverse, Inc.', '5656 Main Street N', 'Suite 23', 'Miami', 'FL', '34567', '', '123 123 1235', '123 123 1236', 'test_email@edirectory.com', 'http://www.diversesample.com', 0, 0),
(6, '2012-11-30 11:13:25', '2005-12-20 16:53:40', 'Daniel', 'Willis', 'Restaurants & Co.', '122 Europe Street N', '5th floor', 'New York', 'NY', '34567', '', '012 012 0124', '', 'test_email@edirectory.com', '', 0, 0),
(7, '2013-09-05 17:26:15', '2005-12-20 17:42:50', 'Brandon', 'C', 'Eating Inc.', '888 Center Street N', '', 'Arlington', 'VA', '22123', '', '703 434 3434', '', 'test_email@edirectory.com', '', 0, 0),
(8, '2013-05-28 12:04:26', '2005-12-20 18:14:48', 'Andrew', 'Hunt', 'Airlines Inc.', '090 First Street T', '3rd floor', 'Miami', 'FL', '33434', '', '333 444 4444', '', 'test_email@edirectory.com', '', 0, 0),
(9, '2012-11-30 12:02:40', '2005-12-20 18:47:39', 'Julia', 'Case', 'Your Hotel', '889 Yellow Street', '', 'San Francisco', 'CA', '28980', '', '454 454 4444', '', 'test_email@edirectory.com', '', 0, 0),
(10, '2012-11-30 11:14:41', '2005-12-20 19:11:43', 'Anthony', 'Bill', 'Airlines', 'PO Box 345', '5th floor', 'New York', 'NY', '67677', '', '901 123 1234', '', 'test_email@edirectory.com', '', 0, 0),
(12, '2012-11-30 10:54:11', '2006-01-06 12:08:07', 'George', 'Cage', 'Sports', '127 25th Street', '', 'New York', 'NY', '12345', '', '012 012 0124', '', 'test_email@edirectory.com', '', 0, 0),
(13, '2012-11-30 10:58:07', '2006-01-06 12:12:13', 'Elizabeth', 'Wilson', 'Skin Care', '127 25th Street', '', 'New York', 'NY', '12345', '', '012 123 4576', '', 'test_email@edirectory.com', '', 0, 0),
(14, '2012-11-30 11:05:20', '2006-01-06 12:15:08', 'Harold', 'Brown', 'Cars', '127 25th Street', '', 'Denver', 'Colorado', '', '', '012 012 1234', '', 'test_email@edirectory.com', '', 0, 0),
(15, '2012-11-30 11:06:33', '2006-01-06 12:16:50', 'Kath', 'Smith', 'Gym', '127 Main Street', '', 'Los Angeles', 'CA', '55647', '', '025 223 5547', '', 'test_email@edirectory.com', '', 0, 0),
(16, '2012-11-30 11:07:53', '2006-01-06 12:19:05', 'Jake', 'Roberts', 'Athletic', '225 Ocean Avenue', '', 'San Francisco', 'CA', '25475', '', '225 221 2576', '', 'test_email@edirectory.com', '', 0, 0),
(17, '2013-05-29 12:02:28', '2006-01-06 12:21:00', 'Carl', 'Gilmore', 'Bikes', '154 Main Street', '', 'Miami', 'FL', '35687', '', '012 254 2365', '', 'test_email@edirectory.com', '', 0, 0),
(18, '2012-11-30 10:55:33', '2006-01-06 12:22:17', 'David', 'Adams', 'Photos & Films', '657 Main Street', '', 'Orlando', 'FL', '33524', '', '025 412 2563', '', 'test_email@edirectory.com', '', 0, 0),
(19, '2013-08-20 14:30:53', '2006-01-06 12:24:24', 'Steve', 'Green', 'Garden House', '554 Main Street', '', 'Sacramento', 'CA', '87456', '', '015 254 2256', '', 'test_email@edirectory.com', '', 0, 0),
(20, '2013-03-12 09:45:33', '2006-01-06 12:26:15', 'Rachel', 'Bing', 'Shoes World', '745 Main Street', '', 'New York', 'NY', '12345', '', '012 123 4576', '', 'test_email@edirectory.com', '', 0, 0),
(22, '2011-08-05 15:15:29', '2006-01-10 10:41:50', 'Test Account', 'Demo', 'Arca Solutions', '', '', 'Annandale', 'VA', '22003', 'United States', '703.914.0770', '', 'test_email@edirectory.com', '', 0, 0),
(252, '2013-05-29 10:38:05', '2004-05-26 10:16:41', 'Sophia', 'Martinez', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(218, '2011-08-05 15:17:40', '2007-04-02 00:00:00', 'Mark', 'Wilson', 'HEALTH CARE', '456 Main Street', '', 'Miami', 'FL', '33545', '', '025 145 7789', '', 'test_email@edirectory.com', 'http://www.edirectory.com/directory_ad.php', 0, 0),
(253, '2012-11-30 11:29:59', '2004-05-26 10:16:41', 'Emma', 'Rogers', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(254, '2013-05-28 12:46:14', '2004-05-26 10:16:41', 'Olivia', 'Hayes', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(255, '2012-11-30 11:23:27', '2004-05-26 10:16:41', 'Ava', 'Grant', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(256, '2013-03-04 08:55:12', '2004-05-26 10:16:41', 'Emily', 'Elliott', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(257, '2012-11-30 11:16:01', '2004-05-26 10:16:41', 'Abigail', 'Meyer', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(258, '2012-11-30 11:43:16', '2004-05-26 10:16:41', 'Madison', 'Larson', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(259, '2012-11-30 11:25:42', '2004-05-26 10:16:41', 'Chloe', 'Jensen', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(260, '2012-11-30 11:37:27', '2004-05-26 10:16:41', 'Jacob', 'Hale', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(261, '2013-05-29 10:37:26', '2004-05-26 10:16:41', 'Susan', 'Lewis', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(262, '2012-11-30 11:31:59', '2004-05-26 10:16:41', 'Ethan', 'Reed', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(263, '2012-11-30 10:56:49', '2004-05-26 10:16:41', 'Michael', 'Watson', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(264, '2013-05-28 12:51:57', '2004-05-26 10:16:41', 'William', 'Butler', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(265, '2012-12-03 16:32:35', '2004-05-26 10:16:41', 'Alexander', 'Reynolds', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(266, '2012-11-30 11:46:38', '2004-05-26 10:16:41', 'Noah', 'Gordon', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(267, '2012-11-30 11:17:39', '2004-05-26 10:16:41', 'Aiden', 'Gardner', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(268, '2012-11-30 11:22:03', '2004-05-26 10:16:41', 'Anthony', 'Harper', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(269, '2012-11-30 11:45:46', '2004-05-26 10:16:41', 'Nicholas', 'Lawson', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(270, '2013-05-29 10:42:00', '2004-05-26 10:16:41', 'Henry', 'Burton', '', '', '', '', '', '', '', '', '', 'henry@sample.com', '', 0, 0),
(271, '2012-11-30 11:32:58', '2004-05-26 10:16:41', 'Grace', 'Cantrell', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(272, '2013-05-29 10:40:32', '2004-05-26 10:16:41', 'Sarah', 'Britt', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(273, '2013-05-28 12:33:46', '2004-05-26 10:16:41', 'Layla', 'Donovan', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(274, '2012-11-30 11:39:49', '2004-05-26 10:16:41', 'Kimberly', 'Lancaster', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(275, '2012-11-30 11:20:52', '2004-05-26 10:16:41', 'Andrea', 'Levine', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(276, '2013-05-28 12:38:55', '2004-05-26 10:16:41', 'Lucy', 'Foreman', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(277, '2012-11-30 11:31:07', '2004-05-26 10:16:41', 'Eric', 'Knowles', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(278, '2012-11-30 11:24:46', '2004-05-26 10:16:41', 'Chase', 'Frederick', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(279, '2013-05-28 12:24:32', '2004-05-26 10:16:41', 'Thomas', 'Cotton', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(280, '2012-11-30 11:53:45', '2004-05-26 10:16:41', 'Scott', 'Crane', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(281, '2013-05-29 10:37:49', '2004-05-26 10:16:41', 'Stacy', 'Zimmerman', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(282, '2012-11-30 11:27:59', '2004-05-26 10:16:41', 'Derrick', 'Bass', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(283, '2012-11-30 11:44:44', '2004-05-26 10:16:41', 'Melanie', 'Klein', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(284, '2012-11-30 11:48:54', '2004-05-26 10:16:41', 'Philip', 'Marsh', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(286, '2012-11-30 11:19:50', '2004-05-26 10:16:41', 'Amber', 'Hodges', '', '', '', '', '', '', '', '', '', 'test_email@edirectory.com', '', 0, 0),
(331, '2013-10-16 11:15:26', '2013-10-16 11:15:26', 'Åyman', 'Qàidi', '', '', '', '', '', '', '', '', '', 'qaidi988@yahoo.de', '', 0, 0),
(332, '2013-10-18 04:02:43', '2013-10-18 04:02:43', 'Mohamed', 'Fathi', '', '', '', '', '', '', '', '', '', 'muchways02@gmail.com', '', 0, 0),
(334, '2013-10-20 01:16:42', '2013-10-20 01:16:42', 'tester', 'testing', '', '', '', '', '', '', '', '', '', 'test12@me.com', '', 0, 0);

CREATE TABLE Control_Cron (
  domain_id int(11) NOT NULL,
  running char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  last_run_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY domain_id (domain_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO Control_Cron (domain_id, running, last_run_date, type) VALUES
(1, 'N', '2013-03-07 16:53:18', 'count_article_category'),
(1, 'N', '2013-03-07 16:53:24', 'count_classified_category'),
(1, 'N', '2013-03-07 16:53:28', 'count_event_category'),
(1, 'N', '2013-03-07 16:51:53', 'count_listing_category'),
(1, 'N', '2013-03-07 16:53:13', 'count_post_tag'),
(1, 'N', '2013-10-18 20:05:01', 'daily_maintenance'),
(1, 'N', '2013-10-19 16:15:02', 'randomizer'),
(1, 'N', '2013-10-19 16:15:03', 'renewal_reminder'),
(1, 'N', '2013-10-18 20:05:03', 'report_rollup'),
(1, 'N', '2013-10-18 20:05:22', 'sitemap'),
(1, 'N', '2013-10-18 20:05:23', 'statisticreport'),
(1, 'Y', '2013-06-12 09:33:23', 'location_update'),
(1, 'N', '0000-00-00 00:00:00', 'prepare_import_events'),
(1, 'N', '2013-10-19 16:27:50', 'email_traffic'),
(1, 'N', '2013-10-19 16:37:13', 'rollback_import'),
(1, 'N', '0000-00-00 00:00:00', 'prepare_import'),
(1, 'N', '2013-10-19 16:38:10', 'rollback_import_events'),
(2, 'N', '2012-11-26 08:33:00', 'count_article_category'),
(2, 'N', '2012-11-26 08:36:18', 'count_classified_category'),
(2, 'N', '2012-11-26 08:36:52', 'count_event_category'),
(2, 'N', '2012-11-26 08:37:08', 'count_listing_category'),
(2, 'N', '2012-11-26 08:37:30', 'count_post_tag'),
(2, 'N', '0000-00-00 00:00:00', 'daily_maintenance'),
(2, 'N', '2013-07-30 14:38:30', 'randomizer'),
(2, 'N', '0000-00-00 00:00:00', 'renewal_reminder'),
(2, 'N', '2012-11-26 16:19:13', 'report_rollup'),
(2, 'N', '2013-01-24 08:38:56', 'sitemap'),
(2, 'N', '2012-11-26 16:01:30', 'statisticreport'),
(2, 'N', '0000-00-00 00:00:00', 'location_update'),
(2, 'N', '0000-00-00 00:00:00', 'prepare_import_events'),
(2, 'N', '0000-00-00 00:00:00', 'email_traffic'),
(2, 'N', '0000-00-00 00:00:00', 'rollback_import'),
(2, 'N', '0000-00-00 00:00:00', 'prepare_import'),
(2, 'N', '0000-00-00 00:00:00', 'rollback_import_events'),
(3, 'N', '2012-11-26 08:33:02', 'count_article_category'),
(3, 'N', '2012-11-26 08:36:21', 'count_classified_category'),
(3, 'N', '2012-11-26 08:36:53', 'count_event_category'),
(3, 'N', '2012-11-26 08:37:09', 'count_listing_category'),
(3, 'N', '2012-11-26 08:37:31', 'count_post_tag'),
(3, 'N', '0000-00-00 00:00:00', 'daily_maintenance'),
(3, 'N', '2013-07-30 14:38:33', 'randomizer'),
(3, 'N', '0000-00-00 00:00:00', 'renewal_reminder'),
(3, 'N', '2012-11-26 16:21:04', 'report_rollup'),
(3, 'N', '2013-01-24 08:39:00', 'sitemap'),
(3, 'N', '2012-11-26 16:01:31', 'statisticreport'),
(3, 'N', '0000-00-00 00:00:00', 'location_update'),
(3, 'N', '0000-00-00 00:00:00', 'prepare_import_events'),
(3, 'N', '0000-00-00 00:00:00', 'email_traffic'),
(3, 'N', '0000-00-00 00:00:00', 'rollback_import'),
(3, 'N', '0000-00-00 00:00:00', 'prepare_import'),
(3, 'N', '0000-00-00 00:00:00', 'rollback_import_events'),
(6, 'N', '2013-05-09 17:04:24', 'count_article_category'),
(6, 'N', '2013-05-09 17:04:24', 'count_classified_category'),
(6, 'N', '2013-05-09 17:04:24', 'count_event_category'),
(6, 'N', '2013-05-09 17:04:24', 'count_listing_category'),
(6, 'N', '2013-05-09 17:04:24', 'count_post_tag'),
(6, 'N', '2013-05-09 17:04:24', 'daily_maintenance'),
(6, 'N', '2013-05-09 17:04:24', 'email_traffic'),
(6, 'N', '2013-07-30 14:38:44', 'randomizer'),
(6, 'N', '2013-05-09 17:04:24', 'renewal_reminder'),
(6, 'N', '2013-05-09 17:04:24', 'report_rollup'),
(6, 'N', '2013-05-09 17:04:24', 'sitemap'),
(6, 'N', '2013-05-09 17:04:24', 'statisticreport'),
(6, 'N', '2013-05-09 17:04:24', 'location_update'),
(6, 'N', '2013-05-09 17:04:24', 'prepare_import'),
(6, 'N', '2013-05-09 17:04:24', 'prepare_import_events'),
(6, 'N', '2013-05-09 17:04:24', 'rollback_import'),
(6, 'N', '2013-05-09 17:04:24', 'rollback_import_events'),
(7, 'N', '2013-05-09 17:09:48', 'count_article_category'),
(7, 'N', '2013-05-09 17:09:48', 'count_classified_category'),
(7, 'N', '2013-05-09 17:09:48', 'count_event_category'),
(7, 'N', '2013-05-09 17:09:48', 'count_listing_category'),
(7, 'N', '2013-05-09 17:09:48', 'count_post_tag'),
(7, 'N', '2013-05-09 17:09:48', 'daily_maintenance'),
(7, 'N', '2013-05-09 17:09:48', 'email_traffic'),
(7, 'N', '2013-07-30 14:38:47', 'randomizer'),
(7, 'N', '2013-05-09 17:09:48', 'renewal_reminder'),
(7, 'N', '2013-05-09 17:09:48', 'report_rollup'),
(7, 'N', '2013-05-09 17:09:48', 'sitemap'),
(7, 'N', '2013-05-09 17:09:48', 'statisticreport'),
(7, 'N', '2013-05-09 17:09:48', 'location_update'),
(7, 'N', '2013-05-09 17:09:48', 'prepare_import'),
(7, 'N', '2013-05-09 17:09:48', 'prepare_import_events'),
(7, 'N', '2013-05-09 17:09:48', 'rollback_import'),
(7, 'N', '2013-05-09 17:09:48', 'rollback_import_events'),
(1, 'N', '2013-08-30 11:15:22', 'count_locations'),
(2, 'N', '2013-08-30 11:15:36', 'count_locations'),
(3, 'N', '2013-08-30 11:15:40', 'count_locations'),
(6, 'N', '2013-08-30 11:15:45', 'count_locations'),
(7, 'N', '2013-08-30 11:15:48', 'count_locations'),
(8, 'N', '2013-06-18 14:58:45', 'count_article_category'),
(8, 'N', '2013-06-18 14:58:45', 'count_classified_category'),
(8, 'N', '2013-06-18 14:58:45', 'count_event_category'),
(8, 'N', '2013-06-18 14:58:45', 'count_listing_category'),
(8, 'N', '2013-06-18 14:58:45', 'count_post_tag'),
(8, 'N', '2013-08-30 11:16:07', 'count_locations'),
(8, 'N', '2013-06-18 14:58:45', 'daily_maintenance'),
(8, 'N', '2013-06-18 14:58:45', 'email_traffic'),
(8, 'N', '2013-07-30 14:38:50', 'randomizer'),
(8, 'N', '2013-06-18 14:58:45', 'renewal_reminder'),
(8, 'N', '2013-06-18 14:58:45', 'report_rollup'),
(8, 'N', '2013-06-18 14:58:45', 'sitemap'),
(8, 'N', '2013-06-18 14:58:45', 'statisticreport'),
(8, 'N', '2013-06-18 14:58:45', 'location_update'),
(8, 'N', '2013-06-18 14:58:45', 'prepare_import'),
(8, 'N', '2013-06-18 14:58:45', 'prepare_import_events'),
(8, 'N', '2013-06-18 14:58:45', 'rollback_import'),
(8, 'N', '2013-06-18 14:58:45', 'rollback_import_events'),
(33, 'N', '2013-10-18 19:37:48', 'count_classified_category'),
(33, 'N', '2013-10-18 19:37:48', 'count_article_category'),
(32, 'N', '2013-10-18 19:25:55', 'rollback_import_events'),
(32, 'N', '2013-10-18 19:25:55', 'rollback_import'),
(32, 'N', '2013-10-18 19:25:55', 'prepare_import_events'),
(32, 'N', '2013-10-18 19:25:55', 'prepare_import'),
(32, 'N', '2013-10-18 19:25:55', 'location_update'),
(32, 'N', '2013-10-18 19:25:55', 'statisticreport'),
(32, 'N', '2013-10-18 19:25:55', 'sitemap'),
(32, 'N', '2013-10-18 19:25:55', 'report_rollup'),
(32, 'N', '2013-10-18 19:25:55', 'renewal_reminder'),
(32, 'N', '2013-10-18 19:25:55', 'email_traffic'),
(32, 'N', '2013-10-18 19:25:55', 'randomizer'),
(32, 'N', '2013-10-18 19:25:55', 'daily_maintenance'),
(32, 'N', '2013-10-18 19:25:55', 'count_locations'),
(32, 'N', '2013-10-18 19:25:55', 'count_post_tag'),
(32, 'N', '2013-10-18 19:25:55', 'count_listing_category'),
(32, 'N', '2013-10-18 19:25:55', 'count_event_category'),
(32, 'N', '2013-10-18 19:25:55', 'count_classified_category'),
(32, 'N', '2013-10-18 19:25:55', 'count_article_category'),
(33, 'N', '2013-10-18 19:37:48', 'count_event_category'),
(33, 'N', '2013-10-18 19:37:48', 'count_listing_category'),
(33, 'N', '2013-10-18 19:37:48', 'count_post_tag'),
(33, 'N', '2013-10-18 19:37:48', 'count_locations'),
(33, 'N', '2013-10-18 19:37:48', 'daily_maintenance'),
(33, 'N', '2013-10-18 19:37:48', 'email_traffic'),
(33, 'N', '2013-10-18 19:37:48', 'randomizer'),
(33, 'N', '2013-10-18 19:37:48', 'renewal_reminder'),
(33, 'N', '2013-10-18 19:37:48', 'report_rollup'),
(33, 'N', '2013-10-18 19:37:48', 'sitemap'),
(33, 'N', '2013-10-18 19:37:48', 'statisticreport'),
(33, 'N', '2013-10-18 19:37:48', 'location_update'),
(33, 'N', '2013-10-18 19:37:48', 'prepare_import'),
(33, 'N', '2013-10-18 19:37:48', 'prepare_import_events'),
(33, 'N', '2013-10-18 19:37:48', 'rollback_import'),
(33, 'N', '2013-10-18 19:37:48', 'rollback_import_events'),
(42, 'N', '2013-10-18 19:50:01', 'count_classified_category'),
(42, 'N', '2013-10-18 19:50:01', 'count_article_category'),
(41, 'N', '2013-10-18 19:48:03', 'prepare_import_events'),
(41, 'N', '2013-10-18 19:48:03', 'rollback_import'),
(41, 'N', '2013-10-18 19:48:03', 'rollback_import_events'),
(41, 'N', '2013-10-18 19:48:03', 'prepare_import'),
(41, 'N', '2013-10-18 19:48:03', 'location_update'),
(41, 'N', '2013-10-18 19:48:03', 'statisticreport'),
(41, 'N', '2013-10-18 19:48:03', 'sitemap'),
(41, 'N', '2013-10-18 19:48:03', 'report_rollup'),
(41, 'N', '2013-10-18 19:48:03', 'renewal_reminder'),
(41, 'N', '2013-10-18 19:48:03', 'email_traffic'),
(41, 'N', '2013-10-18 19:48:03', 'randomizer'),
(41, 'N', '2013-10-18 19:48:03', 'daily_maintenance'),
(41, 'N', '2013-10-18 19:48:03', 'count_locations'),
(41, 'N', '2013-10-18 19:48:03', 'count_post_tag'),
(41, 'N', '2013-10-18 19:48:03', 'count_event_category'),
(41, 'N', '2013-10-18 19:48:03', 'count_listing_category'),
(41, 'N', '2013-10-18 19:48:03', 'count_classified_category'),
(41, 'N', '2013-10-18 19:48:03', 'count_article_category'),
(42, 'N', '2013-10-18 19:50:01', 'count_event_category'),
(42, 'N', '2013-10-18 19:50:01', 'count_listing_category'),
(42, 'N', '2013-10-18 19:50:01', 'count_post_tag'),
(42, 'N', '2013-10-18 19:50:01', 'count_locations'),
(42, 'N', '2013-10-18 19:50:01', 'daily_maintenance'),
(42, 'N', '2013-10-18 19:50:01', 'email_traffic'),
(42, 'N', '2013-10-18 19:50:01', 'randomizer'),
(42, 'N', '2013-10-18 19:50:01', 'renewal_reminder'),
(42, 'N', '2013-10-18 19:50:01', 'report_rollup'),
(42, 'N', '2013-10-18 19:50:01', 'sitemap'),
(42, 'N', '2013-10-18 19:50:01', 'statisticreport'),
(42, 'N', '2013-10-18 19:50:01', 'location_update'),
(42, 'N', '2013-10-18 19:50:01', 'prepare_import'),
(42, 'N', '2013-10-18 19:50:01', 'prepare_import_events'),
(42, 'N', '2013-10-18 19:50:01', 'rollback_import'),
(42, 'N', '2013-10-18 19:50:01', 'rollback_import_events'),
(47, 'N', '2013-10-20 01:06:16', 'rollback_import'),
(47, 'N', '2013-10-20 01:06:16', 'prepare_import_events'),
(47, 'N', '2013-10-20 01:06:16', 'prepare_import'),
(47, 'N', '2013-10-20 01:06:16', 'location_update'),
(47, 'N', '2013-10-20 01:06:16', 'statisticreport'),
(47, 'N', '2013-10-20 01:06:16', 'sitemap'),
(47, 'N', '2013-10-20 01:06:16', 'report_rollup'),
(47, 'N', '2013-10-20 01:06:16', 'renewal_reminder'),
(47, 'N', '2013-10-20 01:06:16', 'randomizer'),
(47, 'N', '2013-10-20 01:06:16', 'email_traffic'),
(47, 'N', '2013-10-20 01:06:16', 'daily_maintenance'),
(47, 'N', '2013-10-20 01:06:16', 'count_locations'),
(47, 'N', '2013-10-20 01:06:16', 'count_post_tag'),
(47, 'N', '2013-10-20 01:06:16', 'count_listing_category'),
(47, 'N', '2013-10-20 01:06:16', 'count_event_category'),
(47, 'N', '2013-10-20 01:06:16', 'count_classified_category'),
(47, 'N', '2013-10-20 01:06:16', 'count_article_category'),
(47, 'N', '2013-10-20 01:06:16', 'rollback_import_events');

CREATE TABLE Control_Export_Event (
  id int(11) NOT NULL AUTO_INCREMENT,
  domain_id int(11) NOT NULL DEFAULT '0',
  last_run_date datetime NOT NULL,
  total_event_exported int(11) NOT NULL,
  last_event_id int(11) NOT NULL,
  `block` int(11) NOT NULL,
  finished varchar(1) NOT NULL,
  filename varchar(100) NOT NULL,
  `type` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'csv / csv - data',
  running_cron varchar(1) NOT NULL,
  scheduled varchar(1) NOT NULL,
  PRIMARY KEY (id,domain_id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO Control_Export_Event (id, domain_id, last_run_date, total_event_exported, last_event_id, block, finished, filename, type, running_cron, scheduled) VALUES
(1, 1, '0000-00-00 00:00:00', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 1, '0000-00-00 00:00:00', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 2, '0000-00-00 00:00:00', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 2, '0000-00-00 00:00:00', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 3, '0000-00-00 00:00:00', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 3, '0000-00-00 00:00:00', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 6, '2013-05-09 17:04:24', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 6, '2013-05-09 17:04:24', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 7, '2013-05-09 17:09:48', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 7, '2013-05-09 17:09:48', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 8, '2013-06-18 14:58:45', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 8, '2013-06-18 14:58:45', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 32, '2013-10-18 19:25:55', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 32, '2013-10-18 19:25:55', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 33, '2013-10-18 19:37:48', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 33, '2013-10-18 19:37:48', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 41, '2013-10-18 19:48:03', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 41, '2013-10-18 19:48:03', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 42, '2013-10-18 19:50:01', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 42, '2013-10-18 19:50:01', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 47, '2013-10-20 01:06:16', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 47, '2013-10-20 01:06:16', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N');

CREATE TABLE Control_Export_Listing (
  id int(11) NOT NULL AUTO_INCREMENT,
  domain_id int(11) NOT NULL DEFAULT '0',
  last_run_date datetime NOT NULL,
  total_listing_exported int(11) NOT NULL,
  last_listing_id int(11) NOT NULL,
  `block` int(11) NOT NULL,
  finished varchar(1) NOT NULL,
  filename varchar(100) NOT NULL,
  `type` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'csv / csv - data',
  running_cron varchar(1) NOT NULL,
  scheduled varchar(1) NOT NULL,
  PRIMARY KEY (id,domain_id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=56867 ;

INSERT INTO Control_Export_Listing (id, domain_id, last_run_date, total_listing_exported, last_listing_id, block, finished, filename, type, running_cron, scheduled) VALUES
(1, 1, '0000-00-00 00:00:00', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 1, '0000-00-00 00:00:00', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 2, '0000-00-00 00:00:00', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 2, '0000-00-00 00:00:00', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 3, '0000-00-00 00:00:00', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 3, '0000-00-00 00:00:00', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 6, '2013-05-09 17:04:24', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 6, '2013-05-09 17:04:24', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 7, '2013-05-09 17:09:48', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 7, '2013-05-09 17:09:48', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 8, '2013-06-18 14:58:45', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 8, '2013-06-18 14:58:45', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 32, '2013-10-18 19:25:55', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 32, '2013-10-18 19:25:55', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 33, '2013-10-18 19:37:48', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 33, '2013-10-18 19:37:48', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(2, 41, '2013-10-18 19:48:03', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 41, '2013-10-18 19:48:03', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(1, 42, '2013-10-18 19:50:01', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 42, '2013-10-18 19:50:01', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N'),
(1, 47, '2013-10-20 01:06:16', 0, 0, 50000, 'Y', '', 'csv', 'N', 'N'),
(2, 47, '2013-10-20 01:06:16', 0, 0, 10000, 'Y', '', 'csv - data', 'N', 'N');

CREATE TABLE Control_Export_MailApp (
  domain_id int(11) NOT NULL,
  scheduled char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  running char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  last_run_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  last_exportlog int(11) NOT NULL,
  PRIMARY KEY (domain_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO Control_Export_MailApp (domain_id, scheduled, running, last_run_date, last_exportlog) VALUES
(1, 'N', 'N', '0000-00-00 00:00:00', 0),
(2, 'N', 'N', '0000-00-00 00:00:00', 0),
(3, 'N', 'N', '0000-00-00 00:00:00', 0),
(6, 'N', 'N', '2013-05-09 17:04:24', 0),
(7, 'N', 'N', '2013-05-09 17:09:48', 0),
(8, 'N', 'N', '2013-06-18 14:58:45', 0),
(32, 'N', 'N', '2013-10-18 19:25:55', 0),
(33, 'N', 'N', '2013-10-18 19:37:48', 0),
(41, 'N', 'N', '2013-10-18 19:48:03', 0),
(42, 'N', 'N', '2013-10-18 19:50:01', 0),
(47, 'N', 'N', '2013-10-20 01:06:16', 0);

CREATE TABLE Control_Import_Event (
  domain_id int(11) NOT NULL,
  scheduled char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  running char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  `status` char(2) COLLATE utf8_unicode_ci NOT NULL,
  last_run_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  last_importlog int(11) NOT NULL,
  PRIMARY KEY (domain_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO Control_Import_Event (domain_id, scheduled, running, status, last_run_date, last_importlog) VALUES
(1, 'N', 'N', '', '0000-00-00 00:00:00', 0),
(2, 'N', 'N', '', '0000-00-00 00:00:00', 0),
(3, 'N', 'N', '', '0000-00-00 00:00:00', 0),
(6, 'N', 'N', '', '2013-05-09 17:04:24', 0),
(7, 'N', 'N', '', '2013-05-09 17:09:48', 0),
(8, 'N', 'N', '', '2013-06-18 14:58:45', 0),
(32, 'N', 'N', '', '2013-10-18 19:25:55', 0),
(33, 'N', 'N', '', '2013-10-18 19:37:48', 0),
(41, 'N', 'N', '', '2013-10-18 19:48:03', 0),
(42, 'N', 'N', '', '2013-10-18 19:50:01', 0),
(47, 'N', 'N', '', '2013-10-20 01:06:16', 0);

CREATE TABLE Control_Import_Listing (
  domain_id int(11) NOT NULL,
  scheduled char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  running char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  `status` char(2) COLLATE utf8_unicode_ci NOT NULL,
  last_run_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  last_importlog int(11) NOT NULL,
  PRIMARY KEY (domain_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO Control_Import_Listing (domain_id, scheduled, running, status, last_run_date, last_importlog) VALUES
(1, 'N', 'N', '', '0000-00-00 00:00:00', 0),
(2, 'N', 'N', '', '0000-00-00 00:00:00', 0),
(3, 'N', 'N', '', '0000-00-00 00:00:00', 0),
(6, 'N', 'N', '', '2013-05-09 17:04:24', 0),
(7, 'N', 'N', '', '2013-05-10 11:50:33', 1),
(8, 'N', 'N', '', '2013-06-18 14:58:45', 0),
(32, 'N', 'N', '', '2013-10-18 19:25:55', 0),
(33, 'N', 'N', '', '2013-10-18 19:37:48', 0),
(41, 'N', 'N', '', '2013-10-18 19:48:03', 0),
(42, 'N', 'N', '', '2013-10-18 19:50:01', 0),
(47, 'N', 'N', '', '2013-10-20 01:06:16', 0);

CREATE TABLE Cron_Log (
  id int(11) NOT NULL AUTO_INCREMENT,
  domain_id int(11) NOT NULL,
  cron varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime NOT NULL,
  history text COLLATE utf8_unicode_ci NOT NULL,
  finished char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  `time` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=673 ;

INSERT INTO Cron_Log (id, domain_id, cron, date, history, finished, time) VALUES
(7, 1, 'daily_maintenance', '2013-10-18 20:05:01', 'Starting cron\nUpdate expired listings - LINE: 133\nUpdate expired events - LINE: 145\nUpdate expired banners - LINE: 157\nUpdate expired classifieds - LINE: 169\nUpdate expired articles - LINE: 181\nUpdate expired Promotional Codes - LINE: 193\nUpdate expired invoices - LINE: 200\nUpdate expired notifications - LINE: 207\nUpdate expired adverts - LINE: 219\nDelete old invoices - LINE: 231\nUpdate listing statistic - LINE: 259\nUpdate event statistic - LINE: 342\nUpdate banner statistic - LINE: 425\nUpdate classified statistic - LINE: 495\nUpdate article statistic - LINE: 578\nDelete unused image files - LINE: 661\nDelete old entries from Recent Activity Table - LINE: 683\nDelete pending and deleted domains - LINE: 698\nTurn on scalability if necessary - LINE: 718\nDelete old entries from Cron_Log Table - LINE: 963\nCron finished', 'y', '0.25'),
(8, 1, 'email_traffic', '2013-10-18 20:05:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(9, 1, 'randomizer', '2013-10-18 20:05:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.22'),
(10, 1, 'renewal_reminder', '2013-10-18 20:05:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(11, 1, 'report_rollup', '2013-10-18 20:05:03', 'Starting cron\nArticle Daily Rollup - LINE: 151\nBlog Daily Rollup - LINE: 195\nBanner Daily Rollup - LINE: 239\nClassified Daily Rollup - LINE: 283\nEvent Daily Rollup - LINE: 327\nListing Daily Rollup - LINE: 371\nPromotion Daily Rollup - LINE: 445\nRemove reports from deleted Articles - LINE: 498\nRemove reports from deleted Posts - LINE: 519\nRemove reports from deleted Banners - LINE: 540\nRemove reports from deleted Classifieds - LINE: 561\nRemove reports from deleted Events - LINE: 582\nRemove reports from deleted Listings - LINE: 603\nRemove reports from deleted Promotions - LINE: 624\nRemove old reports from Articles - LINE: 653\nRemove old reports from Blog - LINE: 661\nRemove old reports from Banners - LINE: 669\nRemove old reports from Classifieds - LINE: 677\nRemove old reports from Events - LINE: 685\nRemove old reports from Listings - LINE: 693\nRemove old reports from Promotions - LINE: 701\nMove completed months to Report_[module]_Monthly - Article - LINE: 716\nMove completed months to Report_[module]_Monthly - Blog - LINE: 730\nMove completed months to Report_[module]_Monthly - Banner - LINE: 744\nMove completed months to Report_[module]_Monthly - Classified - LINE: 758\nMove completed months to Report_[module]_Monthly - Event - LINE: 772\nMove completed months to Report_[module]_Monthly - Listing - LINE: 786\nMove completed months to Report_[module]_Monthly - Promotion - LINE: 800\nCron finished', 'y', '19.26'),
(12, 1, 'sitemap', '2013-10-18 20:05:22', 'Starting cron\nCron finished', 'y', '0.31'),
(13, 1, 'statisticreport', '2013-10-18 20:05:23', 'Starting cron\nTop Keywords - LINE: 154\nTop Where - LINE: 171\nTop Category - LINE: 188\nTop Locations - LINE: 256\nClear Old Data - LINE: 305\nCron finished', 'y', '0.47'),
(14, 1, 'rollback_import', '2013-10-18 20:05:24', 'Starting cron\nCron finished', 'y', '0'),
(15, 1, 'rollback_import_events', '2013-10-18 20:05:24', 'Starting cron\nCron finished', 'y', '0'),
(16, 1, 'rollback_import', '2013-10-18 20:10:03', 'Starting cron\nCron finished', 'y', '0'),
(17, 1, 'rollback_import_events', '2013-10-18 20:10:03', 'Starting cron\nCron finished', 'y', '0'),
(18, 1, 'rollback_import', '2013-10-18 20:15:02', 'Starting cron\nCron finished', 'y', '0'),
(19, 1, 'rollback_import_events', '2013-10-18 20:15:03', 'Starting cron\nCron finished', 'y', '0'),
(20, 1, 'rollback_import', '2013-10-18 20:20:03', 'Starting cron\nCron finished', 'y', '0'),
(21, 1, 'rollback_import_events', '2013-10-18 20:20:03', 'Starting cron\nCron finished', 'y', '0'),
(22, 1, 'email_traffic', '2013-10-18 20:25:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.3'),
(23, 1, 'randomizer', '2013-10-18 20:25:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.93'),
(24, 1, 'renewal_reminder', '2013-10-18 20:25:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.2'),
(25, 1, 'rollback_import', '2013-10-18 20:25:04', 'Starting cron\nCron finished', 'y', '0'),
(26, 1, 'rollback_import_events', '2013-10-18 20:25:05', 'Starting cron\nCron finished', 'y', '0'),
(27, 1, 'rollback_import', '2013-10-18 20:30:02', 'Starting cron\nCron finished', 'y', '0'),
(28, 1, 'rollback_import_events', '2013-10-18 20:30:02', 'Starting cron\nCron finished', 'y', '0'),
(29, 1, 'rollback_import', '2013-10-18 20:35:03', 'Starting cron\nCron finished', 'y', '0'),
(30, 1, 'rollback_import_events', '2013-10-18 20:35:03', 'Starting cron\nCron finished', 'y', '0'),
(31, 1, 'rollback_import', '2013-10-18 20:40:02', 'Starting cron\nCron finished', 'y', '0'),
(32, 1, 'rollback_import_events', '2013-10-18 20:40:02', 'Starting cron\nCron finished', 'y', '0'),
(33, 1, 'email_traffic', '2013-10-18 20:45:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(34, 1, 'randomizer', '2013-10-18 20:45:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.21'),
(35, 1, 'renewal_reminder', '2013-10-18 20:45:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.34'),
(36, 1, 'rollback_import', '2013-10-18 20:45:04', 'Starting cron\nCron finished', 'y', '0'),
(37, 1, 'rollback_import_events', '2013-10-18 20:45:04', 'Starting cron\nCron finished', 'y', '0'),
(38, 1, 'rollback_import', '2013-10-18 20:50:03', 'Starting cron\nCron finished', 'y', '0'),
(39, 1, 'rollback_import_events', '2013-10-18 20:50:03', 'Starting cron\nCron finished', 'y', '0'),
(40, 1, 'rollback_import', '2013-10-18 20:55:02', 'Starting cron\nCron finished', 'y', '0'),
(41, 1, 'rollback_import_events', '2013-10-18 20:55:03', 'Starting cron\nCron finished', 'y', '0'),
(42, 1, 'rollback_import', '2013-10-18 21:00:02', 'Starting cron\nCron finished', 'y', '0'),
(43, 1, 'rollback_import_events', '2013-10-18 21:00:02', 'Starting cron\nCron finished', 'y', '0'),
(44, 1, 'email_traffic', '2013-10-18 21:05:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.2'),
(45, 1, 'randomizer', '2013-10-18 21:05:03', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.45'),
(46, 1, 'renewal_reminder', '2013-10-18 21:05:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.17'),
(47, 1, 'rollback_import', '2013-10-18 21:05:04', 'Starting cron\nCron finished', 'y', '0'),
(48, 1, 'rollback_import_events', '2013-10-18 21:05:04', 'Starting cron\nCron finished', 'y', '0'),
(49, 1, 'rollback_import', '2013-10-18 21:10:02', 'Starting cron\nCron finished', 'y', '0'),
(50, 1, 'rollback_import_events', '2013-10-18 21:10:03', 'Starting cron\nCron finished', 'y', '0'),
(51, 1, 'rollback_import', '2013-10-18 21:15:03', 'Starting cron\nCron finished', 'y', '0'),
(52, 1, 'rollback_import_events', '2013-10-18 21:15:03', 'Starting cron\nCron finished', 'y', '0'),
(53, 1, 'rollback_import', '2013-10-18 21:20:03', 'Starting cron\nCron finished', 'y', '0'),
(54, 1, 'rollback_import_events', '2013-10-18 21:20:04', 'Starting cron\nCron finished', 'y', '0'),
(55, 1, 'rollback_import', '2013-10-18 21:25:02', 'Starting cron\nCron finished', 'y', '0'),
(56, 1, 'rollback_import_events', '2013-10-18 21:25:02', 'Starting cron\nCron finished', 'y', '0'),
(57, 1, 'email_traffic', '2013-10-18 21:30:03', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.28'),
(58, 1, 'randomizer', '2013-10-18 21:30:03', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.19'),
(59, 1, 'renewal_reminder', '2013-10-18 21:30:04', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(60, 1, 'rollback_import', '2013-10-18 21:30:05', 'Starting cron\nCron finished', 'y', '0'),
(61, 1, 'rollback_import_events', '2013-10-18 21:30:05', 'Starting cron\nCron finished', 'y', '0'),
(62, 1, 'rollback_import', '2013-10-18 21:35:02', 'Starting cron\nCron finished', 'y', '0'),
(63, 1, 'rollback_import_events', '2013-10-18 21:35:03', 'Starting cron\nCron finished', 'y', '0'),
(64, 1, 'rollback_import', '2013-10-18 21:40:02', 'Starting cron\nCron finished', 'y', '0'),
(65, 1, 'rollback_import_events', '2013-10-18 21:40:03', 'Starting cron\nCron finished', 'y', '0'),
(66, 1, 'rollback_import', '2013-10-18 21:45:03', 'Starting cron\nCron finished', 'y', '0'),
(67, 1, 'rollback_import_events', '2013-10-18 21:45:03', 'Starting cron\nCron finished', 'y', '0'),
(68, 1, 'rollback_import', '2013-10-18 21:50:02', 'Starting cron\nCron finished', 'y', '0'),
(69, 1, 'rollback_import_events', '2013-10-18 21:50:03', 'Starting cron\nCron finished', 'y', '0'),
(70, 1, 'email_traffic', '2013-10-18 21:55:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.8'),
(71, 1, 'randomizer', '2013-10-18 21:55:03', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.25'),
(72, 1, 'renewal_reminder', '2013-10-18 21:55:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(73, 1, 'rollback_import', '2013-10-18 21:55:04', 'Starting cron\nCron finished', 'y', '0'),
(74, 1, 'rollback_import_events', '2013-10-18 21:55:04', 'Starting cron\nCron finished', 'y', '0'),
(75, 1, 'rollback_import', '2013-10-18 22:00:03', 'Starting cron\nCron finished', 'y', '0'),
(76, 1, 'rollback_import_events', '2013-10-18 22:00:03', 'Starting cron\nCron finished', 'y', '0'),
(77, 1, 'rollback_import', '2013-10-18 22:05:03', 'Starting cron\nCron finished', 'y', '0'),
(78, 1, 'rollback_import_events', '2013-10-18 22:05:04', 'Starting cron\nCron finished', 'y', '0'),
(79, 1, 'rollback_import', '2013-10-18 22:10:02', 'Starting cron\nCron finished', 'y', '0'),
(80, 1, 'rollback_import_events', '2013-10-18 22:10:03', 'Starting cron\nCron finished', 'y', '0'),
(81, 1, 'rollback_import', '2013-10-18 22:15:02', 'Starting cron\nCron finished', 'y', '0'),
(82, 1, 'rollback_import_events', '2013-10-18 22:15:03', 'Starting cron\nCron finished', 'y', '0'),
(83, 1, 'email_traffic', '2013-10-18 22:20:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.25'),
(84, 1, 'randomizer', '2013-10-18 22:20:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.21'),
(85, 1, 'renewal_reminder', '2013-10-18 22:20:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.18'),
(86, 1, 'rollback_import', '2013-10-18 22:20:06', 'Starting cron\nCron finished', 'y', '0'),
(87, 1, 'rollback_import_events', '2013-10-18 22:20:11', 'Starting cron\nCron finished', 'y', '0'),
(88, 1, 'rollback_import', '2013-10-18 22:25:03', 'Starting cron\nCron finished', 'y', '0'),
(89, 1, 'rollback_import_events', '2013-10-18 22:25:03', 'Starting cron\nCron finished', 'y', '0'),
(90, 1, 'rollback_import', '2013-10-18 22:30:02', 'Starting cron\nCron finished', 'y', '0'),
(91, 1, 'rollback_import_events', '2013-10-18 22:30:02', 'Starting cron\nCron finished', 'y', '0'),
(92, 1, 'rollback_import', '2013-10-18 22:35:02', 'Starting cron\nCron finished', 'y', '0'),
(93, 1, 'rollback_import_events', '2013-10-18 22:35:02', 'Starting cron\nCron finished', 'y', '0'),
(94, 1, 'email_traffic', '2013-10-18 22:40:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(95, 1, 'randomizer', '2013-10-18 22:40:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(96, 1, 'rollback_import', '2013-10-18 22:40:03', 'Starting cron\nCron finished', 'y', '0'),
(97, 1, 'rollback_import_events', '2013-10-18 22:40:03', 'Starting cron\nCron finished', 'y', '0'),
(98, 1, 'renewal_reminder', '2013-10-18 22:45:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(99, 1, 'rollback_import', '2013-10-18 22:45:03', 'Starting cron\nCron finished', 'y', '0'),
(100, 1, 'rollback_import_events', '2013-10-18 22:45:03', 'Starting cron\nCron finished', 'y', '0'),
(101, 1, 'rollback_import', '2013-10-18 22:50:02', 'Starting cron\nCron finished', 'y', '0'),
(102, 1, 'rollback_import_events', '2013-10-18 22:50:03', 'Starting cron\nCron finished', 'y', '0'),
(103, 1, 'rollback_import', '2013-10-18 22:55:02', 'Starting cron\nCron finished', 'y', '0'),
(104, 1, 'rollback_import_events', '2013-10-18 22:55:02', 'Starting cron\nCron finished', 'y', '0'),
(105, 1, 'email_traffic', '2013-10-18 23:00:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.69'),
(106, 1, 'randomizer', '2013-10-18 23:00:03', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(107, 1, 'rollback_import', '2013-10-18 23:00:04', 'Starting cron\nCron finished', 'y', '0'),
(108, 1, 'rollback_import_events', '2013-10-18 23:00:04', 'Starting cron\nCron finished', 'y', '0'),
(109, 1, 'rollback_import', '2013-10-18 23:05:02', 'Starting cron\nCron finished', 'y', '0'),
(110, 1, 'rollback_import_events', '2013-10-18 23:05:02', 'Starting cron\nCron finished', 'y', '0'),
(111, 1, 'renewal_reminder', '2013-10-18 23:10:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.17'),
(112, 1, 'rollback_import', '2013-10-18 23:10:02', 'Starting cron\nCron finished', 'y', '0'),
(113, 1, 'rollback_import_events', '2013-10-18 23:10:03', 'Starting cron\nCron finished', 'y', '0'),
(114, 1, 'rollback_import', '2013-10-18 23:15:03', 'Starting cron\nCron finished', 'y', '0'),
(115, 1, 'rollback_import_events', '2013-10-18 23:15:03', 'Starting cron\nCron finished', 'y', '0'),
(116, 1, 'email_traffic', '2013-10-18 23:20:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '1.49'),
(117, 1, 'randomizer', '2013-10-18 23:20:04', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.19'),
(118, 1, 'rollback_import', '2013-10-18 23:20:05', 'Starting cron\nCron finished', 'y', '0'),
(119, 1, 'rollback_import_events', '2013-10-18 23:20:05', 'Starting cron\nCron finished', 'y', '0'),
(120, 1, 'rollback_import', '2013-10-18 23:25:02', 'Starting cron\nCron finished', 'y', '0'),
(121, 1, 'rollback_import_events', '2013-10-18 23:25:03', 'Starting cron\nCron finished', 'y', '0'),
(122, 1, 'renewal_reminder', '2013-10-18 23:30:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.19'),
(123, 1, 'rollback_import', '2013-10-18 23:30:03', 'Starting cron\nCron finished', 'y', '0'),
(124, 1, 'rollback_import_events', '2013-10-18 23:30:04', 'Starting cron\nCron finished', 'y', '0'),
(125, 1, 'rollback_import', '2013-10-18 23:35:03', 'Starting cron\nCron finished', 'y', '0'),
(126, 1, 'rollback_import_events', '2013-10-18 23:35:03', 'Starting cron\nCron finished', 'y', '0'),
(127, 1, 'email_traffic', '2013-10-18 23:40:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.76'),
(128, 1, 'rollback_import', '2013-10-18 23:40:04', 'Starting cron\nCron finished', 'y', '0'),
(129, 1, 'rollback_import_events', '2013-10-18 23:40:04', 'Starting cron\nCron finished', 'y', '0'),
(130, 1, 'randomizer', '2013-10-18 23:45:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '1.61'),
(131, 1, 'rollback_import', '2013-10-18 23:45:04', 'Starting cron\nCron finished', 'y', '0'),
(132, 1, 'rollback_import_events', '2013-10-18 23:45:05', 'Starting cron\nCron finished', 'y', '0'),
(133, 1, 'renewal_reminder', '2013-10-18 23:50:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(134, 1, 'rollback_import', '2013-10-18 23:50:03', 'Starting cron\nCron finished', 'y', '0'),
(135, 1, 'rollback_import_events', '2013-10-18 23:50:05', 'Starting cron\nCron finished', 'y', '0'),
(136, 1, 'rollback_import', '2013-10-18 23:55:02', 'Starting cron\nCron finished', 'y', '0'),
(137, 1, 'rollback_import_events', '2013-10-18 23:55:02', 'Starting cron\nCron finished', 'y', '0'),
(138, 1, 'email_traffic', '2013-10-19 00:00:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.18'),
(139, 1, 'rollback_import', '2013-10-19 00:00:03', 'Starting cron\nCron finished', 'y', '0'),
(140, 1, 'rollback_import_events', '2013-10-19 00:00:03', 'Starting cron\nCron finished', 'y', '0'),
(141, 1, 'randomizer', '2013-10-19 00:05:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.2'),
(142, 1, 'rollback_import', '2013-10-19 00:05:04', 'Starting cron\nCron finished', 'y', '0'),
(143, 1, 'rollback_import_events', '2013-10-19 00:05:04', 'Starting cron\nCron finished', 'y', '0'),
(144, 1, 'renewal_reminder', '2013-10-19 00:10:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.23'),
(145, 1, 'rollback_import', '2013-10-19 00:10:04', 'Starting cron\nCron finished', 'y', '0'),
(146, 1, 'rollback_import_events', '2013-10-19 00:10:05', 'Starting cron\nCron finished', 'y', '0'),
(147, 1, 'rollback_import', '2013-10-19 00:15:03', 'Starting cron\nCron finished', 'y', '0'),
(148, 1, 'rollback_import_events', '2013-10-19 00:15:03', 'Starting cron\nCron finished', 'y', '0'),
(149, 1, 'rollback_import', '2013-10-19 00:20:02', 'Starting cron\nCron finished', 'y', '0'),
(150, 1, 'rollback_import_events', '2013-10-19 00:20:02', 'Starting cron\nCron finished', 'y', '0'),
(151, 1, 'email_traffic', '2013-10-19 00:25:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.24'),
(152, 1, 'randomizer', '2013-10-19 00:25:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.18'),
(153, 1, 'rollback_import', '2013-10-19 00:25:03', 'Starting cron\nCron finished', 'y', '0'),
(154, 1, 'rollback_import_events', '2013-10-19 00:25:03', 'Starting cron\nCron finished', 'y', '0'),
(155, 1, 'renewal_reminder', '2013-10-19 00:30:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.31'),
(156, 1, 'rollback_import', '2013-10-19 00:30:07', 'Starting cron\nCron finished', 'y', '0'),
(157, 1, 'rollback_import_events', '2013-10-19 00:30:10', 'Starting cron\nCron finished', 'y', '0'),
(158, 1, 'rollback_import', '2013-10-19 00:35:03', 'Starting cron\nCron finished', 'y', '0'),
(159, 1, 'rollback_import_events', '2013-10-19 00:35:03', 'Starting cron\nCron finished', 'y', '0'),
(160, 1, 'rollback_import', '2013-10-19 00:40:03', 'Starting cron\nCron finished', 'y', '0'),
(161, 1, 'rollback_import_events', '2013-10-19 00:40:03', 'Starting cron\nCron finished', 'y', '0'),
(162, 1, 'email_traffic', '2013-10-19 00:45:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '1.01'),
(163, 1, 'randomizer', '2013-10-19 00:45:03', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.23'),
(164, 1, 'rollback_import', '2013-10-19 00:45:04', 'Starting cron\nCron finished', 'y', '0'),
(165, 1, 'rollback_import_events', '2013-10-19 00:45:04', 'Starting cron\nCron finished', 'y', '0'),
(166, 1, 'rollback_import', '2013-10-19 00:50:03', 'Starting cron\nCron finished', 'y', '0'),
(167, 1, 'rollback_import_events', '2013-10-19 00:50:03', 'Starting cron\nCron finished', 'y', '0'),
(168, 1, 'renewal_reminder', '2013-10-19 00:55:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.19'),
(169, 1, 'rollback_import', '2013-10-19 00:55:03', 'Starting cron\nCron finished', 'y', '0'),
(170, 1, 'rollback_import_events', '2013-10-19 00:55:03', 'Starting cron\nCron finished', 'y', '0'),
(171, 1, 'rollback_import', '2013-10-19 01:00:04', 'Starting cron\nCron finished', 'y', '0'),
(172, 1, 'rollback_import_events', '2013-10-19 01:00:04', 'Starting cron\nCron finished', 'y', '0'),
(173, 1, 'email_traffic', '2013-10-19 01:05:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(174, 1, 'rollback_import', '2013-10-19 01:05:03', 'Starting cron\nCron finished', 'y', '0'),
(175, 1, 'rollback_import_events', '2013-10-19 01:05:03', 'Starting cron\nCron finished', 'y', '0'),
(176, 1, 'randomizer', '2013-10-19 01:10:01', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.18'),
(177, 1, 'rollback_import', '2013-10-19 01:10:02', 'Starting cron\nCron finished', 'y', '0'),
(178, 1, 'rollback_import_events', '2013-10-19 01:10:03', 'Starting cron\nCron finished', 'y', '0'),
(179, 1, 'renewal_reminder', '2013-10-19 01:15:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.22'),
(180, 1, 'rollback_import', '2013-10-19 01:15:04', 'Starting cron\nCron finished', 'y', '0'),
(181, 1, 'rollback_import_events', '2013-10-19 01:15:05', 'Starting cron\nCron finished', 'y', '0'),
(182, 1, 'rollback_import', '2013-10-19 01:20:03', 'Starting cron\nCron finished', 'y', '0'),
(183, 1, 'rollback_import_events', '2013-10-19 01:20:04', 'Starting cron\nCron finished', 'y', '0'),
(184, 1, 'rollback_import', '2013-10-19 01:25:02', 'Starting cron\nCron finished', 'y', '0'),
(185, 1, 'rollback_import_events', '2013-10-19 01:25:03', 'Starting cron\nCron finished', 'y', '0'),
(186, 1, 'email_traffic', '2013-10-19 01:30:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '1.39'),
(187, 1, 'randomizer', '2013-10-19 01:30:04', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '1.84'),
(188, 1, 'rollback_import', '2013-10-19 01:30:06', 'Starting cron\nCron finished', 'y', '0'),
(189, 1, 'rollback_import_events', '2013-10-19 01:30:06', 'Starting cron\nCron finished', 'y', '0'),
(190, 1, 'renewal_reminder', '2013-10-19 01:35:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.26'),
(191, 1, 'rollback_import', '2013-10-19 01:35:03', 'Starting cron\nCron finished', 'y', '0'),
(192, 1, 'rollback_import_events', '2013-10-19 01:35:04', 'Starting cron\nCron finished', 'y', '0'),
(193, 1, 'rollback_import', '2013-10-19 01:40:03', 'Starting cron\nCron finished', 'y', '0'),
(194, 1, 'rollback_import_events', '2013-10-19 01:40:03', 'Starting cron\nCron finished', 'y', '0'),
(195, 1, 'rollback_import', '2013-10-19 01:45:02', 'Starting cron\nCron finished', 'y', '0'),
(196, 1, 'rollback_import_events', '2013-10-19 01:45:03', 'Starting cron\nCron finished', 'y', '0'),
(197, 1, 'email_traffic', '2013-10-19 01:50:07', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '1.97'),
(198, 1, 'randomizer', '2013-10-19 01:50:10', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '2.91'),
(199, 1, 'rollback_import', '2013-10-19 01:50:13', 'Starting cron\nCron finished', 'y', '0'),
(200, 1, 'rollback_import_events', '2013-10-19 01:50:14', 'Starting cron\nCron finished', 'y', '0'),
(201, 1, 'renewal_reminder', '2013-10-19 01:55:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.18'),
(202, 1, 'rollback_import', '2013-10-19 01:55:03', 'Starting cron\nCron finished', 'y', '0'),
(203, 1, 'rollback_import_events', '2013-10-19 01:55:04', 'Starting cron\nCron finished', 'y', '0'),
(204, 1, 'rollback_import', '2013-10-19 02:00:09', 'Starting cron\nCron finished', 'y', '0'),
(205, 1, 'rollback_import_events', '2013-10-19 02:00:10', 'Starting cron\nCron finished', 'y', '0'),
(206, 1, 'rollback_import', '2013-10-19 02:05:03', 'Starting cron\nCron finished', 'y', '0'),
(207, 1, 'rollback_import_events', '2013-10-19 02:05:03', 'Starting cron\nCron finished', 'y', '0'),
(208, 1, 'rollback_import', '2013-10-19 02:10:03', 'Starting cron\nCron finished', 'y', '0'),
(209, 1, 'rollback_import_events', '2013-10-19 02:10:03', 'Starting cron\nCron finished', 'y', '0'),
(210, 1, 'email_traffic', '2013-10-19 02:15:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(211, 1, 'randomizer', '2013-10-19 02:15:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.35'),
(212, 1, 'rollback_import', '2013-10-19 02:15:03', 'Starting cron\nCron finished', 'y', '0'),
(213, 1, 'rollback_import_events', '2013-10-19 02:15:03', 'Starting cron\nCron finished', 'y', '0'),
(214, 1, 'renewal_reminder', '2013-10-19 02:20:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(215, 1, 'rollback_import', '2013-10-19 02:20:03', 'Starting cron\nCron finished', 'y', '0'),
(216, 1, 'rollback_import_events', '2013-10-19 02:20:03', 'Starting cron\nCron finished', 'y', '0'),
(217, 1, 'rollback_import', '2013-10-19 02:25:02', 'Starting cron\nCron finished', 'y', '0'),
(218, 1, 'rollback_import_events', '2013-10-19 02:25:03', 'Starting cron\nCron finished', 'y', '0'),
(219, 1, 'rollback_import', '2013-10-19 02:30:02', 'Starting cron\nCron finished', 'y', '0'),
(220, 1, 'rollback_import_events', '2013-10-19 02:30:02', 'Starting cron\nCron finished', 'y', '0'),
(221, 1, 'email_traffic', '2013-10-19 02:35:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(222, 1, 'randomizer', '2013-10-19 02:35:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(223, 1, 'rollback_import', '2013-10-19 02:35:03', 'Starting cron\nCron finished', 'y', '0'),
(224, 1, 'rollback_import_events', '2013-10-19 02:35:03', 'Starting cron\nCron finished', 'y', '0'),
(225, 1, 'renewal_reminder', '2013-10-19 02:40:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(226, 1, 'rollback_import', '2013-10-19 02:40:02', 'Starting cron\nCron finished', 'y', '0'),
(227, 1, 'rollback_import_events', '2013-10-19 02:40:03', 'Starting cron\nCron finished', 'y', '0'),
(228, 1, 'rollback_import', '2013-10-19 02:45:03', 'Starting cron\nCron finished', 'y', '0'),
(229, 1, 'rollback_import_events', '2013-10-19 02:45:03', 'Starting cron\nCron finished', 'y', '0'),
(230, 1, 'rollback_import', '2013-10-19 02:50:03', 'Starting cron\nCron finished', 'y', '0'),
(231, 1, 'rollback_import_events', '2013-10-19 02:50:05', 'Starting cron\nCron finished', 'y', '0'),
(232, 1, 'email_traffic', '2013-10-19 02:55:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.47'),
(233, 1, 'randomizer', '2013-10-19 02:55:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(234, 1, 'rollback_import', '2013-10-19 02:55:03', 'Starting cron\nCron finished', 'y', '0'),
(235, 1, 'rollback_import_events', '2013-10-19 02:55:04', 'Starting cron\nCron finished', 'y', '0'),
(236, 1, 'rollback_import', '2013-10-19 03:00:02', 'Starting cron\nCron finished', 'y', '0'),
(237, 1, 'rollback_import_events', '2013-10-19 03:00:02', 'Starting cron\nCron finished', 'y', '0'),
(238, 1, 'renewal_reminder', '2013-10-19 03:05:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(239, 1, 'rollback_import', '2013-10-19 03:05:03', 'Starting cron\nCron finished', 'y', '0'),
(240, 1, 'rollback_import_events', '2013-10-19 03:05:03', 'Starting cron\nCron finished', 'y', '0'),
(241, 1, 'rollback_import', '2013-10-19 03:10:03', 'Starting cron\nCron finished', 'y', '0'),
(242, 1, 'rollback_import_events', '2013-10-19 03:10:03', 'Starting cron\nCron finished', 'y', '0'),
(243, 1, 'email_traffic', '2013-10-19 03:15:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.18'),
(244, 1, 'randomizer', '2013-10-19 03:15:03', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '1.82'),
(245, 1, 'rollback_import', '2013-10-19 03:15:05', 'Starting cron\nCron finished', 'y', '0'),
(246, 1, 'rollback_import_events', '2013-10-19 03:15:05', 'Starting cron\nCron finished', 'y', '0'),
(247, 1, 'rollback_import', '2013-10-19 03:20:02', 'Starting cron\nCron finished', 'y', '0'),
(248, 1, 'rollback_import_events', '2013-10-19 03:20:03', 'Starting cron\nCron finished', 'y', '0'),
(249, 1, 'renewal_reminder', '2013-10-19 03:25:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.2'),
(250, 1, 'rollback_import', '2013-10-19 03:25:03', 'Starting cron\nCron finished', 'y', '0'),
(251, 1, 'rollback_import_events', '2013-10-19 03:25:04', 'Starting cron\nCron finished', 'y', '0'),
(252, 1, 'rollback_import', '2013-10-19 03:30:03', 'Starting cron\nCron finished', 'y', '0'),
(253, 1, 'rollback_import_events', '2013-10-19 03:30:03', 'Starting cron\nCron finished', 'y', '0'),
(254, 1, 'email_traffic', '2013-10-19 03:35:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(255, 1, 'randomizer', '2013-10-19 03:35:03', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '1.25'),
(256, 1, 'rollback_import', '2013-10-19 03:35:04', 'Starting cron\nCron finished', 'y', '0'),
(257, 1, 'rollback_import_events', '2013-10-19 03:35:05', 'Starting cron\nCron finished', 'y', '0'),
(258, 1, 'rollback_import', '2013-10-19 03:40:02', 'Starting cron\nCron finished', 'y', '0'),
(259, 1, 'rollback_import_events', '2013-10-19 03:40:02', 'Starting cron\nCron finished', 'y', '0'),
(260, 1, 'rollback_import', '2013-10-19 03:45:02', 'Starting cron\nCron finished', 'y', '0'),
(261, 1, 'rollback_import_events', '2013-10-19 03:45:02', 'Starting cron\nCron finished', 'y', '0'),
(262, 1, 'renewal_reminder', '2013-10-19 03:50:04', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '1.7'),
(263, 1, 'rollback_import', '2013-10-19 03:50:09', 'Starting cron\nCron finished', 'y', '0'),
(264, 1, 'rollback_import_events', '2013-10-19 03:50:09', 'Starting cron\nCron finished', 'y', '0'),
(265, 1, 'rollback_import', '2013-10-19 03:55:02', 'Starting cron\nCron finished', 'y', '0'),
(266, 1, 'rollback_import_events', '2013-10-19 03:55:02', 'Starting cron\nCron finished', 'y', '0'),
(267, 1, 'email_traffic', '2013-10-19 04:00:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(268, 1, 'randomizer', '2013-10-19 04:00:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.27'),
(269, 1, 'rollback_import', '2013-10-19 04:00:03', 'Starting cron\nCron finished', 'y', '0'),
(270, 1, 'rollback_import_events', '2013-10-19 04:00:04', 'Starting cron\nCron finished', 'y', '0'),
(271, 1, 'rollback_import', '2013-10-19 04:05:03', 'Starting cron\nCron finished', 'y', '0'),
(272, 1, 'rollback_import_events', '2013-10-19 04:05:03', 'Starting cron\nCron finished', 'y', '0'),
(273, 1, 'rollback_import', '2013-10-19 04:10:02', 'Starting cron\nCron finished', 'y', '0'),
(274, 1, 'rollback_import_events', '2013-10-19 04:10:02', 'Starting cron\nCron finished', 'y', '0'),
(275, 1, 'renewal_reminder', '2013-10-19 04:15:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(276, 1, 'rollback_import', '2013-10-19 04:15:03', 'Starting cron\nCron finished', 'y', '0'),
(277, 1, 'rollback_import_events', '2013-10-19 04:15:03', 'Starting cron\nCron finished', 'y', '0'),
(278, 1, 'email_traffic', '2013-10-19 04:20:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(279, 1, 'randomizer', '2013-10-19 04:20:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.28'),
(280, 1, 'rollback_import', '2013-10-19 04:20:03', 'Starting cron\nCron finished', 'y', '0'),
(281, 1, 'rollback_import_events', '2013-10-19 04:20:05', 'Starting cron\nCron finished', 'y', '0'),
(282, 1, 'rollback_import', '2013-10-19 04:25:02', 'Starting cron\nCron finished', 'y', '0'),
(283, 1, 'rollback_import_events', '2013-10-19 04:25:03', 'Starting cron\nCron finished', 'y', '0'),
(284, 1, 'rollback_import', '2013-10-19 04:30:03', 'Starting cron\nCron finished', 'y', '0'),
(285, 1, 'rollback_import_events', '2013-10-19 04:30:03', 'Starting cron\nCron finished', 'y', '0'),
(286, 1, 'renewal_reminder', '2013-10-19 04:35:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(287, 1, 'rollback_import', '2013-10-19 04:35:02', 'Starting cron\nCron finished', 'y', '0'),
(288, 1, 'rollback_import_events', '2013-10-19 04:35:03', 'Starting cron\nCron finished', 'y', '0'),
(289, 1, 'email_traffic', '2013-10-19 04:40:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(290, 1, 'randomizer', '2013-10-19 04:40:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.2'),
(291, 1, 'rollback_import', '2013-10-19 04:40:03', 'Starting cron\nCron finished', 'y', '0'),
(292, 1, 'rollback_import_events', '2013-10-19 04:40:03', 'Starting cron\nCron finished', 'y', '0'),
(293, 1, 'rollback_import', '2013-10-19 04:45:02', 'Starting cron\nCron finished', 'y', '0'),
(294, 1, 'rollback_import_events', '2013-10-19 04:45:03', 'Starting cron\nCron finished', 'y', '0'),
(295, 1, 'rollback_import', '2013-10-19 04:50:03', 'Starting cron\nCron finished', 'y', '0'),
(296, 1, 'rollback_import_events', '2013-10-19 04:50:03', 'Starting cron\nCron finished', 'y', '0'),
(297, 1, 'renewal_reminder', '2013-10-19 04:55:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.17'),
(298, 1, 'rollback_import', '2013-10-19 04:55:03', 'Starting cron\nCron finished', 'y', '0'),
(299, 1, 'rollback_import_events', '2013-10-19 04:55:03', 'Starting cron\nCron finished', 'y', '0'),
(300, 1, 'email_traffic', '2013-10-19 05:00:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(301, 1, 'randomizer', '2013-10-19 05:00:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.19'),
(302, 1, 'rollback_import', '2013-10-19 05:00:03', 'Starting cron\nCron finished', 'y', '0'),
(303, 1, 'rollback_import_events', '2013-10-19 05:00:03', 'Starting cron\nCron finished', 'y', '0'),
(304, 1, 'rollback_import', '2013-10-19 05:05:02', 'Starting cron\nCron finished', 'y', '0'),
(305, 1, 'rollback_import_events', '2013-10-19 05:05:02', 'Starting cron\nCron finished', 'y', '0'),
(306, 1, 'rollback_import', '2013-10-19 05:10:02', 'Starting cron\nCron finished', 'y', '0'),
(307, 1, 'rollback_import_events', '2013-10-19 05:10:02', 'Starting cron\nCron finished', 'y', '0'),
(308, 1, 'renewal_reminder', '2013-10-19 05:15:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(309, 1, 'rollback_import', '2013-10-19 05:15:03', 'Starting cron\nCron finished', 'y', '0'),
(310, 1, 'rollback_import_events', '2013-10-19 05:15:03', 'Starting cron\nCron finished', 'y', '0'),
(311, 1, 'email_traffic', '2013-10-19 05:20:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.16'),
(312, 1, 'randomizer', '2013-10-19 05:20:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(313, 1, 'rollback_import', '2013-10-19 05:20:03', 'Starting cron\nCron finished', 'y', '0'),
(314, 1, 'rollback_import_events', '2013-10-19 05:20:04', 'Starting cron\nCron finished', 'y', '0'),
(315, 1, 'rollback_import', '2013-10-19 05:25:02', 'Starting cron\nCron finished', 'y', '0'),
(316, 1, 'rollback_import_events', '2013-10-19 05:25:03', 'Starting cron\nCron finished', 'y', '0'),
(317, 1, 'rollback_import', '2013-10-19 05:30:02', 'Starting cron\nCron finished', 'y', '0'),
(318, 1, 'rollback_import_events', '2013-10-19 05:30:02', 'Starting cron\nCron finished', 'y', '0'),
(319, 1, 'renewal_reminder', '2013-10-19 05:35:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(320, 1, 'rollback_import', '2013-10-19 05:35:02', 'Starting cron\nCron finished', 'y', '0'),
(321, 1, 'rollback_import_events', '2013-10-19 05:35:03', 'Starting cron\nCron finished', 'y', '0'),
(322, 1, 'email_traffic', '2013-10-19 05:40:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(323, 1, 'randomizer', '2013-10-19 05:40:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.93'),
(324, 1, 'rollback_import', '2013-10-19 05:40:04', 'Starting cron\nCron finished', 'y', '0'),
(325, 1, 'rollback_import_events', '2013-10-19 05:40:04', 'Starting cron\nCron finished', 'y', '0'),
(326, 1, 'rollback_import', '2013-10-19 05:45:02', 'Starting cron\nCron finished', 'y', '0'),
(327, 1, 'rollback_import_events', '2013-10-19 05:45:02', 'Starting cron\nCron finished', 'y', '0'),
(328, 1, 'rollback_import', '2013-10-19 05:50:02', 'Starting cron\nCron finished', 'y', '0'),
(329, 1, 'rollback_import_events', '2013-10-19 05:50:02', 'Starting cron\nCron finished', 'y', '0'),
(330, 1, 'renewal_reminder', '2013-10-19 05:55:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.31'),
(331, 1, 'rollback_import', '2013-10-19 05:55:02', 'Starting cron\nCron finished', 'y', '0'),
(332, 1, 'rollback_import_events', '2013-10-19 05:55:03', 'Starting cron\nCron finished', 'y', '0'),
(333, 1, 'email_traffic', '2013-10-19 06:00:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(334, 1, 'randomizer', '2013-10-19 06:00:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.16'),
(335, 1, 'rollback_import', '2013-10-19 06:00:03', 'Starting cron\nCron finished', 'y', '0'),
(336, 1, 'rollback_import_events', '2013-10-19 06:00:03', 'Starting cron\nCron finished', 'y', '0'),
(337, 1, 'rollback_import', '2013-10-19 06:05:03', 'Starting cron\nCron finished', 'y', '0'),
(338, 1, 'rollback_import_events', '2013-10-19 06:05:03', 'Starting cron\nCron finished', 'y', '0'),
(339, 1, 'rollback_import', '2013-10-19 06:10:02', 'Starting cron\nCron finished', 'y', '0'),
(340, 1, 'rollback_import_events', '2013-10-19 06:10:02', 'Starting cron\nCron finished', 'y', '0'),
(341, 1, 'renewal_reminder', '2013-10-19 06:15:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.31'),
(342, 1, 'rollback_import', '2013-10-19 06:15:02', 'Starting cron\nCron finished', 'y', '0'),
(343, 1, 'rollback_import_events', '2013-10-19 06:15:03', 'Starting cron\nCron finished', 'y', '0'),
(344, 1, 'rollback_import', '2013-10-19 06:20:02', 'Starting cron\nCron finished', 'y', '0'),
(345, 1, 'rollback_import_events', '2013-10-19 06:20:02', 'Starting cron\nCron finished', 'y', '0'),
(346, 1, 'email_traffic', '2013-10-19 06:25:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(347, 1, 'randomizer', '2013-10-19 06:25:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.65'),
(348, 1, 'rollback_import', '2013-10-19 06:25:03', 'Starting cron\nCron finished', 'y', '0'),
(349, 1, 'rollback_import_events', '2013-10-19 06:25:03', 'Starting cron\nCron finished', 'y', '0'),
(350, 1, 'rollback_import', '2013-10-19 06:30:02', 'Starting cron\nCron finished', 'y', '0'),
(351, 1, 'rollback_import_events', '2013-10-19 06:30:02', 'Starting cron\nCron finished', 'y', '0'),
(352, 1, 'rollback_import', '2013-10-19 06:35:02', 'Starting cron\nCron finished', 'y', '0'),
(353, 1, 'rollback_import_events', '2013-10-19 06:35:02', 'Starting cron\nCron finished', 'y', '0'),
(354, 1, 'renewal_reminder', '2013-10-19 06:40:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.58'),
(355, 1, 'rollback_import', '2013-10-19 06:40:04', 'Starting cron\nCron finished', 'y', '0'),
(356, 1, 'rollback_import_events', '2013-10-19 06:40:04', 'Starting cron\nCron finished', 'y', '0'),
(357, 1, 'email_traffic', '2013-10-19 06:45:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(358, 1, 'randomizer', '2013-10-19 06:45:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.19'),
(359, 1, 'rollback_import', '2013-10-19 06:45:02', 'Starting cron\nCron finished', 'y', '0'),
(360, 1, 'rollback_import_events', '2013-10-19 06:45:03', 'Starting cron\nCron finished', 'y', '0'),
(361, 1, 'rollback_import', '2013-10-19 06:50:02', 'Starting cron\nCron finished', 'y', '0'),
(362, 1, 'rollback_import_events', '2013-10-19 06:50:02', 'Starting cron\nCron finished', 'y', '0'),
(363, 1, 'rollback_import', '2013-10-19 06:55:02', 'Starting cron\nCron finished', 'y', '0'),
(364, 1, 'rollback_import_events', '2013-10-19 06:55:03', 'Starting cron\nCron finished', 'y', '0'),
(365, 1, 'rollback_import', '2013-10-19 07:00:03', 'Starting cron\nCron finished', 'y', '0'),
(366, 1, 'rollback_import_events', '2013-10-19 07:00:03', 'Starting cron\nCron finished', 'y', '0'),
(367, 1, 'email_traffic', '2013-10-19 07:05:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(368, 1, 'randomizer', '2013-10-19 07:05:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.2'),
(369, 1, 'renewal_reminder', '2013-10-19 07:05:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.46'),
(370, 1, 'rollback_import', '2013-10-19 07:05:03', 'Starting cron\nCron finished', 'y', '0'),
(371, 1, 'rollback_import_events', '2013-10-19 07:05:04', 'Starting cron\nCron finished', 'y', '0'),
(372, 1, 'rollback_import', '2013-10-19 07:10:03', 'Starting cron\nCron finished', 'y', '0'),
(373, 1, 'rollback_import_events', '2013-10-19 07:10:03', 'Starting cron\nCron finished', 'y', '0'),
(374, 1, 'rollback_import', '2013-10-19 07:15:02', 'Starting cron\nCron finished', 'y', '0'),
(375, 1, 'rollback_import_events', '2013-10-19 07:15:02', 'Starting cron\nCron finished', 'y', '0'),
(376, 1, 'rollback_import', '2013-10-19 07:20:02', 'Starting cron\nCron finished', 'y', '0'),
(377, 1, 'rollback_import_events', '2013-10-19 07:20:02', 'Starting cron\nCron finished', 'y', '0'),
(378, 1, 'email_traffic', '2013-10-19 07:25:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.28'),
(379, 1, 'randomizer', '2013-10-19 07:25:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.21');
INSERT INTO Cron_Log (id, domain_id, cron, date, history, finished, time) VALUES
(380, 1, 'renewal_reminder', '2013-10-19 07:25:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(381, 1, 'rollback_import', '2013-10-19 07:25:03', 'Starting cron\nCron finished', 'y', '0'),
(382, 1, 'rollback_import_events', '2013-10-19 07:25:03', 'Starting cron\nCron finished', 'y', '0'),
(383, 1, 'rollback_import', '2013-10-19 07:30:03', 'Starting cron\nCron finished', 'y', '0'),
(384, 1, 'rollback_import_events', '2013-10-19 07:30:03', 'Starting cron\nCron finished', 'y', '0'),
(385, 1, 'rollback_import', '2013-10-19 07:35:02', 'Starting cron\nCron finished', 'y', '0'),
(386, 1, 'rollback_import_events', '2013-10-19 07:35:03', 'Starting cron\nCron finished', 'y', '0'),
(387, 1, 'rollback_import', '2013-10-19 07:40:03', 'Starting cron\nCron finished', 'y', '0'),
(388, 1, 'rollback_import_events', '2013-10-19 07:40:03', 'Starting cron\nCron finished', 'y', '0'),
(389, 1, 'email_traffic', '2013-10-19 07:45:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(390, 1, 'randomizer', '2013-10-19 07:45:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.71'),
(391, 1, 'renewal_reminder', '2013-10-19 07:45:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(392, 1, 'rollback_import', '2013-10-19 07:45:04', 'Starting cron\nCron finished', 'y', '0'),
(393, 1, 'rollback_import_events', '2013-10-19 07:45:04', 'Starting cron\nCron finished', 'y', '0'),
(394, 1, 'rollback_import', '2013-10-19 07:50:02', 'Starting cron\nCron finished', 'y', '0'),
(395, 1, 'rollback_import_events', '2013-10-19 07:50:03', 'Starting cron\nCron finished', 'y', '0'),
(396, 1, 'rollback_import', '2013-10-19 07:55:03', 'Starting cron\nCron finished', 'y', '0'),
(397, 1, 'rollback_import_events', '2013-10-19 07:55:04', 'Starting cron\nCron finished', 'y', '0'),
(398, 1, 'rollback_import', '2013-10-19 08:00:05', 'Starting cron\nCron finished', 'y', '0'),
(399, 1, 'rollback_import_events', '2013-10-19 08:00:05', 'Starting cron\nCron finished', 'y', '0'),
(400, 1, 'rollback_import', '2013-10-19 08:05:02', 'Starting cron\nCron finished', 'y', '0'),
(401, 1, 'rollback_import_events', '2013-10-19 08:05:02', 'Starting cron\nCron finished', 'y', '0'),
(402, 1, 'email_traffic', '2013-10-19 08:10:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.24'),
(403, 1, 'randomizer', '2013-10-19 08:10:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.18'),
(404, 1, 'renewal_reminder', '2013-10-19 08:10:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(405, 1, 'rollback_import', '2013-10-19 08:10:03', 'Starting cron\nCron finished', 'y', '0'),
(406, 1, 'rollback_import_events', '2013-10-19 08:10:03', 'Starting cron\nCron finished', 'y', '0'),
(407, 1, 'rollback_import', '2013-10-19 08:15:02', 'Starting cron\nCron finished', 'y', '0'),
(408, 1, 'rollback_import_events', '2013-10-19 08:15:03', 'Starting cron\nCron finished', 'y', '0'),
(409, 1, 'rollback_import', '2013-10-19 08:20:03', 'Starting cron\nCron finished', 'y', '0'),
(410, 1, 'rollback_import_events', '2013-10-19 08:20:03', 'Starting cron\nCron finished', 'y', '0'),
(411, 1, 'rollback_import', '2013-10-19 08:25:02', 'Starting cron\nCron finished', 'y', '0'),
(412, 1, 'rollback_import_events', '2013-10-19 08:25:02', 'Starting cron\nCron finished', 'y', '0'),
(413, 1, 'email_traffic', '2013-10-19 08:30:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(414, 1, 'randomizer', '2013-10-19 08:30:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.23'),
(415, 1, 'renewal_reminder', '2013-10-19 08:30:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(416, 1, 'rollback_import', '2013-10-19 08:30:03', 'Starting cron\nCron finished', 'y', '0'),
(417, 1, 'rollback_import_events', '2013-10-19 08:30:03', 'Starting cron\nCron finished', 'y', '0'),
(418, 1, 'rollback_import', '2013-10-19 08:35:02', 'Starting cron\nCron finished', 'y', '0'),
(419, 1, 'rollback_import_events', '2013-10-19 08:35:02', 'Starting cron\nCron finished', 'y', '0'),
(420, 1, 'rollback_import', '2013-10-19 08:40:03', 'Starting cron\nCron finished', 'y', '0'),
(421, 1, 'rollback_import_events', '2013-10-19 08:40:03', 'Starting cron\nCron finished', 'y', '0'),
(422, 1, 'rollback_import', '2013-10-19 08:45:03', 'Starting cron\nCron finished', 'y', '0'),
(423, 1, 'rollback_import_events', '2013-10-19 08:45:03', 'Starting cron\nCron finished', 'y', '0'),
(424, 1, 'email_traffic', '2013-10-19 08:50:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.48'),
(425, 1, 'randomizer', '2013-10-19 08:50:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(426, 1, 'renewal_reminder', '2013-10-19 08:50:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(427, 1, 'rollback_import', '2013-10-19 08:50:03', 'Starting cron\nCron finished', 'y', '0'),
(428, 1, 'rollback_import_events', '2013-10-19 08:50:05', 'Starting cron\nCron finished', 'y', '0'),
(429, 1, 'rollback_import', '2013-10-19 08:55:02', 'Starting cron\nCron finished', 'y', '0'),
(430, 1, 'rollback_import_events', '2013-10-19 08:55:03', 'Starting cron\nCron finished', 'y', '0'),
(431, 1, 'rollback_import', '2013-10-19 09:00:03', 'Starting cron\nCron finished', 'y', '0'),
(432, 1, 'rollback_import_events', '2013-10-19 09:00:03', 'Starting cron\nCron finished', 'y', '0'),
(433, 1, 'rollback_import', '2013-10-19 09:05:02', 'Starting cron\nCron finished', 'y', '0'),
(434, 1, 'rollback_import_events', '2013-10-19 09:05:02', 'Starting cron\nCron finished', 'y', '0'),
(435, 1, 'email_traffic', '2013-10-19 09:10:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(436, 1, 'randomizer', '2013-10-19 09:10:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(437, 1, 'rollback_import', '2013-10-19 09:10:03', 'Starting cron\nCron finished', 'y', '0'),
(438, 1, 'rollback_import_events', '2013-10-19 09:10:03', 'Starting cron\nCron finished', 'y', '0'),
(439, 1, 'renewal_reminder', '2013-10-19 09:15:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(440, 1, 'rollback_import', '2013-10-19 09:15:03', 'Starting cron\nCron finished', 'y', '0'),
(441, 1, 'rollback_import_events', '2013-10-19 09:15:03', 'Starting cron\nCron finished', 'y', '0'),
(442, 1, 'rollback_import', '2013-10-19 09:20:02', 'Starting cron\nCron finished', 'y', '0'),
(443, 1, 'rollback_import_events', '2013-10-19 09:20:03', 'Starting cron\nCron finished', 'y', '0'),
(444, 1, 'rollback_import', '2013-10-19 09:25:03', 'Starting cron\nCron finished', 'y', '0'),
(445, 1, 'rollback_import_events', '2013-10-19 09:25:03', 'Starting cron\nCron finished', 'y', '0'),
(446, 1, 'email_traffic', '2013-10-19 09:30:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(447, 1, 'randomizer', '2013-10-19 09:30:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.2'),
(448, 1, 'rollback_import', '2013-10-19 09:30:03', 'Starting cron\nCron finished', 'y', '0'),
(449, 1, 'rollback_import_events', '2013-10-19 09:30:04', 'Starting cron\nCron finished', 'y', '0'),
(450, 1, 'renewal_reminder', '2013-10-19 09:35:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(451, 1, 'rollback_import', '2013-10-19 09:35:02', 'Starting cron\nCron finished', 'y', '0'),
(452, 1, 'rollback_import_events', '2013-10-19 09:35:03', 'Starting cron\nCron finished', 'y', '0'),
(453, 1, 'rollback_import', '2013-10-19 09:40:03', 'Starting cron\nCron finished', 'y', '0'),
(454, 1, 'rollback_import_events', '2013-10-19 09:40:03', 'Starting cron\nCron finished', 'y', '0'),
(455, 1, 'rollback_import', '2013-10-19 09:45:02', 'Starting cron\nCron finished', 'y', '0'),
(456, 1, 'rollback_import_events', '2013-10-19 09:45:02', 'Starting cron\nCron finished', 'y', '0'),
(457, 1, 'randomizer', '2013-10-19 09:50:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.41'),
(458, 1, 'rollback_import', '2013-10-19 09:50:03', 'Starting cron\nCron finished', 'y', '0'),
(459, 1, 'rollback_import_events', '2013-10-19 09:50:03', 'Starting cron\nCron finished', 'y', '0'),
(460, 1, 'email_traffic', '2013-10-19 09:55:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.54'),
(461, 1, 'renewal_reminder', '2013-10-19 09:55:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.65'),
(462, 1, 'rollback_import', '2013-10-19 09:55:03', 'Starting cron\nCron finished', 'y', '0'),
(463, 1, 'rollback_import_events', '2013-10-19 09:55:03', 'Starting cron\nCron finished', 'y', '0'),
(464, 1, 'rollback_import', '2013-10-19 10:00:03', 'Starting cron\nCron finished', 'y', '0'),
(465, 1, 'rollback_import_events', '2013-10-19 10:00:03', 'Starting cron\nCron finished', 'y', '0'),
(466, 1, 'rollback_import', '2013-10-19 10:05:02', 'Starting cron\nCron finished', 'y', '0'),
(467, 1, 'rollback_import_events', '2013-10-19 10:05:03', 'Starting cron\nCron finished', 'y', '0'),
(468, 1, 'randomizer', '2013-10-19 10:10:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(469, 1, 'rollback_import', '2013-10-19 10:10:03', 'Starting cron\nCron finished', 'y', '0'),
(470, 1, 'rollback_import_events', '2013-10-19 10:10:03', 'Starting cron\nCron finished', 'y', '0'),
(471, 1, 'email_traffic', '2013-10-19 10:15:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.18'),
(472, 1, 'renewal_reminder', '2013-10-19 10:15:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(473, 1, 'rollback_import', '2013-10-19 10:15:02', 'Starting cron\nCron finished', 'y', '0'),
(474, 1, 'rollback_import_events', '2013-10-19 10:15:03', 'Starting cron\nCron finished', 'y', '0'),
(475, 1, 'rollback_import', '2013-10-19 10:20:03', 'Starting cron\nCron finished', 'y', '0'),
(476, 1, 'rollback_import_events', '2013-10-19 10:20:03', 'Starting cron\nCron finished', 'y', '0'),
(477, 1, 'rollback_import', '2013-10-19 10:25:02', 'Starting cron\nCron finished', 'y', '0'),
(478, 1, 'rollback_import_events', '2013-10-19 10:25:03', 'Starting cron\nCron finished', 'y', '0'),
(479, 1, 'randomizer', '2013-10-19 10:30:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(480, 1, 'rollback_import', '2013-10-19 10:30:03', 'Starting cron\nCron finished', 'y', '0'),
(481, 1, 'rollback_import_events', '2013-10-19 10:30:03', 'Starting cron\nCron finished', 'y', '0'),
(482, 1, 'email_traffic', '2013-10-19 10:35:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.52'),
(483, 1, 'renewal_reminder', '2013-10-19 10:35:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(484, 1, 'rollback_import', '2013-10-19 10:35:03', 'Starting cron\nCron finished', 'y', '0'),
(485, 1, 'rollback_import_events', '2013-10-19 10:35:03', 'Starting cron\nCron finished', 'y', '0'),
(486, 1, 'rollback_import', '2013-10-19 10:40:02', 'Starting cron\nCron finished', 'y', '0'),
(487, 1, 'rollback_import_events', '2013-10-19 10:40:03', 'Starting cron\nCron finished', 'y', '0'),
(488, 1, 'rollback_import', '2013-10-19 10:45:03', 'Starting cron\nCron finished', 'y', '0'),
(489, 1, 'rollback_import_events', '2013-10-19 10:45:03', 'Starting cron\nCron finished', 'y', '0'),
(490, 1, 'randomizer', '2013-10-19 10:50:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(491, 1, 'rollback_import', '2013-10-19 10:50:03', 'Starting cron\nCron finished', 'y', '0'),
(492, 1, 'rollback_import_events', '2013-10-19 10:50:04', 'Starting cron\nCron finished', 'y', '0'),
(493, 1, 'rollback_import', '2013-10-19 10:55:02', 'Starting cron\nCron finished', 'y', '0'),
(494, 1, 'rollback_import_events', '2013-10-19 10:55:02', 'Starting cron\nCron finished', 'y', '0'),
(495, 1, 'email_traffic', '2013-10-19 11:00:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(496, 1, 'renewal_reminder', '2013-10-19 11:00:07', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.19'),
(497, 1, 'rollback_import', '2013-10-19 11:00:08', 'Starting cron\nCron finished', 'y', '0'),
(498, 1, 'rollback_import_events', '2013-10-19 11:00:08', 'Starting cron\nCron finished', 'y', '0'),
(499, 1, 'rollback_import', '2013-10-19 11:05:03', 'Starting cron\nCron finished', 'y', '0'),
(500, 1, 'rollback_import_events', '2013-10-19 11:05:03', 'Starting cron\nCron finished', 'y', '0'),
(501, 1, 'randomizer', '2013-10-19 11:10:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(502, 1, 'rollback_import', '2013-10-19 11:10:03', 'Starting cron\nCron finished', 'y', '0'),
(503, 1, 'rollback_import_events', '2013-10-19 11:10:03', 'Starting cron\nCron finished', 'y', '0'),
(504, 1, 'rollback_import', '2013-10-19 11:15:03', 'Starting cron\nCron finished', 'y', '0'),
(505, 1, 'rollback_import_events', '2013-10-19 11:15:03', 'Starting cron\nCron finished', 'y', '0'),
(506, 1, 'email_traffic', '2013-10-19 11:20:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.39'),
(507, 1, 'rollback_import', '2013-10-19 11:20:03', 'Starting cron\nCron finished', 'y', '0'),
(508, 1, 'rollback_import_events', '2013-10-19 11:20:03', 'Starting cron\nCron finished', 'y', '0'),
(509, 1, 'renewal_reminder', '2013-10-19 11:25:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.28'),
(510, 1, 'rollback_import', '2013-10-19 11:25:03', 'Starting cron\nCron finished', 'y', '0'),
(511, 1, 'rollback_import_events', '2013-10-19 11:25:03', 'Starting cron\nCron finished', 'y', '0'),
(512, 1, 'rollback_import', '2013-10-19 11:30:02', 'Starting cron\nCron finished', 'y', '0'),
(513, 1, 'rollback_import_events', '2013-10-19 11:30:02', 'Starting cron\nCron finished', 'y', '0'),
(514, 1, 'randomizer', '2013-10-19 11:35:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(515, 1, 'rollback_import', '2013-10-19 11:35:03', 'Starting cron\nCron finished', 'y', '0'),
(516, 1, 'rollback_import_events', '2013-10-19 11:35:03', 'Starting cron\nCron finished', 'y', '0'),
(517, 1, 'email_traffic', '2013-10-19 11:40:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.37'),
(518, 1, 'rollback_import', '2013-10-19 11:40:03', 'Starting cron\nCron finished', 'y', '0'),
(519, 1, 'rollback_import_events', '2013-10-19 11:40:04', 'Starting cron\nCron finished', 'y', '0'),
(520, 1, 'rollback_import', '2013-10-19 11:45:02', 'Starting cron\nCron finished', 'y', '0'),
(521, 1, 'rollback_import_events', '2013-10-19 11:45:03', 'Starting cron\nCron finished', 'y', '0'),
(522, 1, 'renewal_reminder', '2013-10-19 11:50:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(523, 1, 'rollback_import', '2013-10-19 11:50:03', 'Starting cron\nCron finished', 'y', '0'),
(524, 1, 'rollback_import_events', '2013-10-19 11:50:04', 'Starting cron\nCron finished', 'y', '0'),
(525, 1, 'rollback_import', '2013-10-19 11:55:02', 'Starting cron\nCron finished', 'y', '0'),
(526, 1, 'rollback_import_events', '2013-10-19 11:55:02', 'Starting cron\nCron finished', 'y', '0'),
(527, 1, 'email_traffic', '2013-10-19 12:00:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(528, 1, 'randomizer', '2013-10-19 12:00:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.24'),
(529, 1, 'rollback_import', '2013-10-19 12:00:04', 'Starting cron\nCron finished', 'y', '0'),
(530, 1, 'rollback_import_events', '2013-10-19 12:00:04', 'Starting cron\nCron finished', 'y', '0'),
(531, 1, 'rollback_import', '2013-10-19 12:05:02', 'Starting cron\nCron finished', 'y', '0'),
(532, 1, 'rollback_import_events', '2013-10-19 12:05:02', 'Starting cron\nCron finished', 'y', '0'),
(533, 1, 'renewal_reminder', '2013-10-19 12:10:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.16'),
(534, 1, 'rollback_import', '2013-10-19 12:10:03', 'Starting cron\nCron finished', 'y', '0'),
(535, 1, 'rollback_import_events', '2013-10-19 12:10:03', 'Starting cron\nCron finished', 'y', '0'),
(536, 1, 'rollback_import', '2013-10-19 12:15:03', 'Starting cron\nCron finished', 'y', '0'),
(537, 1, 'rollback_import_events', '2013-10-19 12:15:03', 'Starting cron\nCron finished', 'y', '0'),
(538, 1, 'randomizer', '2013-10-19 12:20:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.18'),
(539, 1, 'rollback_import', '2013-10-19 12:20:03', 'Starting cron\nCron finished', 'y', '0'),
(540, 1, 'rollback_import_events', '2013-10-19 12:20:03', 'Starting cron\nCron finished', 'y', '0'),
(541, 1, 'email_traffic', '2013-10-19 12:25:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '3.12'),
(542, 1, 'rollback_import', '2013-10-19 12:25:06', 'Starting cron\nCron finished', 'y', '0'),
(543, 1, 'rollback_import_events', '2013-10-19 12:25:06', 'Starting cron\nCron finished', 'y', '0'),
(544, 1, 'renewal_reminder', '2013-10-19 12:30:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.16'),
(545, 1, 'rollback_import', '2013-10-19 12:30:03', 'Starting cron\nCron finished', 'y', '0'),
(546, 1, 'rollback_import_events', '2013-10-19 12:30:03', 'Starting cron\nCron finished', 'y', '0'),
(547, 1, 'rollback_import', '2013-10-19 12:35:02', 'Starting cron\nCron finished', 'y', '0'),
(548, 1, 'rollback_import_events', '2013-10-19 12:35:02', 'Starting cron\nCron finished', 'y', '0'),
(549, 1, 'randomizer', '2013-10-19 12:40:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.2'),
(550, 1, 'rollback_import', '2013-10-19 12:40:03', 'Starting cron\nCron finished', 'y', '0'),
(551, 1, 'rollback_import_events', '2013-10-19 12:40:03', 'Starting cron\nCron finished', 'y', '0'),
(552, 1, 'email_traffic', '2013-10-19 12:45:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.2'),
(553, 1, 'rollback_import', '2013-10-19 12:45:03', 'Starting cron\nCron finished', 'y', '0'),
(554, 1, 'rollback_import_events', '2013-10-19 12:45:04', 'Starting cron\nCron finished', 'y', '0'),
(555, 1, 'renewal_reminder', '2013-10-19 12:50:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(556, 1, 'rollback_import', '2013-10-19 12:50:03', 'Starting cron\nCron finished', 'y', '0'),
(557, 1, 'rollback_import_events', '2013-10-19 12:50:03', 'Starting cron\nCron finished', 'y', '0'),
(558, 1, 'rollback_import', '2013-10-19 12:55:02', 'Starting cron\nCron finished', 'y', '0'),
(559, 1, 'rollback_import_events', '2013-10-19 12:55:03', 'Starting cron\nCron finished', 'y', '0'),
(560, 1, 'randomizer', '2013-10-19 13:00:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.91'),
(561, 1, 'rollback_import', '2013-10-19 13:00:04', 'Starting cron\nCron finished', 'y', '0'),
(562, 1, 'rollback_import_events', '2013-10-19 13:00:04', 'Starting cron\nCron finished', 'y', '0'),
(563, 1, 'email_traffic', '2013-10-19 13:05:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(564, 1, 'rollback_import', '2013-10-19 13:05:03', 'Starting cron\nCron finished', 'y', '0'),
(565, 1, 'rollback_import_events', '2013-10-19 13:05:03', 'Starting cron\nCron finished', 'y', '0'),
(566, 1, 'renewal_reminder', '2013-10-19 13:10:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(567, 1, 'rollback_import', '2013-10-19 13:10:02', 'Starting cron\nCron finished', 'y', '0'),
(568, 1, 'rollback_import_events', '2013-10-19 13:10:03', 'Starting cron\nCron finished', 'y', '0'),
(569, 1, 'rollback_import', '2013-10-19 13:15:05', 'Starting cron\nCron finished', 'y', '0'),
(570, 1, 'rollback_import_events', '2013-10-19 13:15:05', 'Starting cron\nCron finished', 'y', '0'),
(571, 1, 'rollback_import', '2013-10-19 13:20:02', 'Starting cron\nCron finished', 'y', '0'),
(572, 1, 'rollback_import_events', '2013-10-19 13:20:03', 'Starting cron\nCron finished', 'y', '0'),
(573, 1, 'randomizer', '2013-10-19 13:25:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.34'),
(574, 1, 'rollback_import', '2013-10-19 13:25:03', 'Starting cron\nCron finished', 'y', '0'),
(575, 1, 'rollback_import_events', '2013-10-19 13:25:03', 'Starting cron\nCron finished', 'y', '0'),
(576, 1, 'email_traffic', '2013-10-19 13:30:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.24'),
(577, 1, 'renewal_reminder', '2013-10-19 13:30:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.59'),
(578, 1, 'rollback_import', '2013-10-19 13:30:05', 'Starting cron\nCron finished', 'y', '0'),
(579, 1, 'rollback_import_events', '2013-10-19 13:30:05', 'Starting cron\nCron finished', 'y', '0'),
(580, 1, 'rollback_import', '2013-10-19 13:35:02', 'Starting cron\nCron finished', 'y', '0'),
(581, 1, 'rollback_import_events', '2013-10-19 13:35:03', 'Starting cron\nCron finished', 'y', '0'),
(582, 1, 'rollback_import', '2013-10-19 13:40:03', 'Starting cron\nCron finished', 'y', '0'),
(583, 1, 'rollback_import_events', '2013-10-19 13:40:03', 'Starting cron\nCron finished', 'y', '0'),
(584, 1, 'randomizer', '2013-10-19 13:45:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.36'),
(585, 1, 'rollback_import', '2013-10-19 13:45:03', 'Starting cron\nCron finished', 'y', '0'),
(586, 1, 'rollback_import_events', '2013-10-19 13:45:04', 'Starting cron\nCron finished', 'y', '0'),
(587, 1, 'email_traffic', '2013-10-19 13:50:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(588, 1, 'rollback_import', '2013-10-19 13:50:03', 'Starting cron\nCron finished', 'y', '0'),
(589, 1, 'rollback_import_events', '2013-10-19 13:50:04', 'Starting cron\nCron finished', 'y', '0'),
(590, 1, 'renewal_reminder', '2013-10-19 13:55:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.33'),
(591, 1, 'rollback_import', '2013-10-19 13:55:03', 'Starting cron\nCron finished', 'y', '0'),
(592, 1, 'rollback_import_events', '2013-10-19 13:55:05', 'Starting cron\nCron finished', 'y', '0'),
(593, 1, 'rollback_import', '2013-10-19 14:00:03', 'Starting cron\nCron finished', 'y', '0'),
(594, 1, 'rollback_import_events', '2013-10-19 14:00:03', 'Starting cron\nCron finished', 'y', '0'),
(595, 1, 'randomizer', '2013-10-19 14:05:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.21'),
(596, 1, 'rollback_import', '2013-10-19 14:05:03', 'Starting cron\nCron finished', 'y', '0'),
(597, 1, 'rollback_import_events', '2013-10-19 14:05:03', 'Starting cron\nCron finished', 'y', '0'),
(598, 1, 'email_traffic', '2013-10-19 14:10:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.17'),
(599, 1, 'rollback_import', '2013-10-19 14:10:03', 'Starting cron\nCron finished', 'y', '0'),
(600, 1, 'rollback_import_events', '2013-10-19 14:10:03', 'Starting cron\nCron finished', 'y', '0'),
(601, 1, 'rollback_import', '2013-10-19 14:15:02', 'Starting cron\nCron finished', 'y', '0'),
(602, 1, 'rollback_import_events', '2013-10-19 14:15:02', 'Starting cron\nCron finished', 'y', '0'),
(603, 1, 'renewal_reminder', '2013-10-19 14:20:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.26'),
(604, 1, 'rollback_import', '2013-10-19 14:20:03', 'Starting cron\nCron finished', 'y', '0'),
(605, 1, 'rollback_import_events', '2013-10-19 14:20:04', 'Starting cron\nCron finished', 'y', '0'),
(606, 1, 'randomizer', '2013-10-19 14:25:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.17'),
(607, 1, 'rollback_import', '2013-10-19 14:25:03', 'Starting cron\nCron finished', 'y', '0'),
(608, 1, 'rollback_import_events', '2013-10-19 14:25:03', 'Starting cron\nCron finished', 'y', '0'),
(609, 1, 'rollback_import', '2013-10-19 14:30:07', 'Starting cron\nCron finished', 'y', '0'),
(610, 1, 'rollback_import_events', '2013-10-19 14:30:08', 'Starting cron\nCron finished', 'y', '0'),
(611, 1, 'email_traffic', '2013-10-19 14:35:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.18'),
(612, 1, 'rollback_import', '2013-10-19 14:35:03', 'Starting cron\nCron finished', 'y', '0'),
(613, 1, 'rollback_import_events', '2013-10-19 14:35:03', 'Starting cron\nCron finished', 'y', '0'),
(614, 1, 'renewal_reminder', '2013-10-19 14:40:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.17'),
(615, 1, 'rollback_import', '2013-10-19 14:40:08', 'Starting cron\nCron finished', 'y', '0'),
(616, 1, 'rollback_import_events', '2013-10-19 14:40:09', 'Starting cron\nCron finished', 'y', '0'),
(617, 1, 'randomizer', '2013-10-19 14:45:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.19'),
(618, 1, 'rollback_import', '2013-10-19 14:45:03', 'Starting cron\nCron finished', 'y', '0'),
(619, 1, 'rollback_import_events', '2013-10-19 14:45:03', 'Starting cron\nCron finished', 'y', '0'),
(620, 1, 'rollback_import', '2013-10-19 14:50:03', 'Starting cron\nCron finished', 'y', '0'),
(621, 1, 'rollback_import_events', '2013-10-19 14:50:03', 'Starting cron\nCron finished', 'y', '0'),
(622, 1, 'email_traffic', '2013-10-19 14:55:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.23'),
(623, 1, 'rollback_import', '2013-10-19 14:55:04', 'Starting cron\nCron finished', 'y', '0'),
(624, 1, 'rollback_import_events', '2013-10-19 14:55:04', 'Starting cron\nCron finished', 'y', '0'),
(625, 1, 'renewal_reminder', '2013-10-19 15:00:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(626, 1, 'rollback_import', '2013-10-19 15:00:03', 'Starting cron\nCron finished', 'y', '0'),
(627, 1, 'rollback_import_events', '2013-10-19 15:00:04', 'Starting cron\nCron finished', 'y', '0'),
(628, 1, 'randomizer', '2013-10-19 15:05:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.18'),
(629, 1, 'rollback_import', '2013-10-19 15:05:03', 'Starting cron\nCron finished', 'y', '0'),
(630, 1, 'rollback_import_events', '2013-10-19 15:05:03', 'Starting cron\nCron finished', 'y', '0'),
(631, 1, 'rollback_import', '2013-10-19 15:10:03', 'Starting cron\nCron finished', 'y', '0'),
(632, 1, 'rollback_import_events', '2013-10-19 15:10:03', 'Starting cron\nCron finished', 'y', '0'),
(633, 1, 'email_traffic', '2013-10-19 15:15:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(634, 1, 'rollback_import', '2013-10-19 15:15:03', 'Starting cron\nCron finished', 'y', '0'),
(635, 1, 'rollback_import_events', '2013-10-19 15:15:03', 'Starting cron\nCron finished', 'y', '0'),
(636, 1, 'rollback_import', '2013-10-19 15:20:03', 'Starting cron\nCron finished', 'y', '0'),
(637, 1, 'rollback_import_events', '2013-10-19 15:20:03', 'Starting cron\nCron finished', 'y', '0'),
(638, 1, 'randomizer', '2013-10-19 15:25:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.32'),
(639, 1, 'renewal_reminder', '2013-10-19 15:25:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.26'),
(640, 1, 'rollback_import', '2013-10-19 15:25:03', 'Starting cron\nCron finished', 'y', '0'),
(641, 1, 'rollback_import_events', '2013-10-19 15:25:04', 'Starting cron\nCron finished', 'y', '0'),
(642, 1, 'rollback_import', '2013-10-19 15:30:03', 'Starting cron\nCron finished', 'y', '0'),
(643, 1, 'rollback_import_events', '2013-10-19 15:30:03', 'Starting cron\nCron finished', 'y', '0'),
(644, 1, 'rollback_import', '2013-10-19 15:35:02', 'Starting cron\nCron finished', 'y', '0'),
(645, 1, 'rollback_import_events', '2013-10-19 15:35:02', 'Starting cron\nCron finished', 'y', '0'),
(646, 1, 'email_traffic', '2013-10-19 15:40:01', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.76'),
(647, 1, 'rollback_import', '2013-10-19 15:40:03', 'Starting cron\nCron finished', 'y', '0'),
(648, 1, 'rollback_import_events', '2013-10-19 15:40:04', 'Starting cron\nCron finished', 'y', '0'),
(649, 1, 'rollback_import', '2013-10-19 15:45:02', 'Starting cron\nCron finished', 'y', '0'),
(650, 1, 'rollback_import_events', '2013-10-19 15:45:02', 'Starting cron\nCron finished', 'y', '0'),
(651, 1, 'randomizer', '2013-10-19 15:50:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.4'),
(652, 1, 'renewal_reminder', '2013-10-19 15:50:02', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.15'),
(653, 1, 'rollback_import', '2013-10-19 15:50:03', 'Starting cron\nCron finished', 'y', '0'),
(654, 1, 'rollback_import_events', '2013-10-19 15:50:04', 'Starting cron\nCron finished', 'y', '0'),
(655, 1, 'rollback_import', '2013-10-19 15:55:02', 'Starting cron\nCron finished', 'y', '0'),
(656, 1, 'rollback_import_events', '2013-10-19 15:55:02', 'Starting cron\nCron finished', 'y', '0'),
(657, 1, 'email_traffic', '2013-10-19 16:00:02', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(658, 1, 'rollback_import', '2013-10-19 16:00:03', 'Starting cron\nCron finished', 'y', '0'),
(659, 1, 'rollback_import_events', '2013-10-19 16:00:03', 'Starting cron\nCron finished', 'y', '0'),
(660, 1, 'rollback_import', '2013-10-19 16:05:02', 'Starting cron\nCron finished', 'y', '0'),
(661, 1, 'rollback_import_events', '2013-10-19 16:05:02', 'Starting cron\nCron finished', 'y', '0'),
(662, 1, 'rollback_import', '2013-10-19 16:10:02', 'Starting cron\nCron finished', 'y', '0'),
(663, 1, 'rollback_import_events', '2013-10-19 16:10:02', 'Starting cron\nCron finished', 'y', '0'),
(664, 1, 'randomizer', '2013-10-19 16:15:02', 'Starting cron\nRandomizer Listings - LINE: 145\nRandomizer Promotions - LINE: 209\nRandomizer Events - LINE: 252\nRandomizer Banners - LINE: 297\nRandomizer Classifieds - LINE: 341\nRandomizer Articles - LINE: 386\nCron finished', 'y', '0.19'),
(665, 1, 'renewal_reminder', '2013-10-19 16:15:03', 'Starting cron\nRead Email Notification - LINE: 153\nSelect accounts - LINE: 180\nSend emails - LINE: 207\nCron finished', 'y', '0.17'),
(666, 1, 'rollback_import', '2013-10-19 16:15:04', 'Starting cron\nCron finished', 'y', '0'),
(667, 1, 'rollback_import_events', '2013-10-19 16:15:04', 'Starting cron\nCron finished', 'y', '0'),
(668, 1, 'rollback_import', '2013-10-19 16:20:02', 'Starting cron\nCron finished', 'y', '0'),
(669, 1, 'rollback_import_events', '2013-10-19 16:20:02', 'Starting cron\nCron finished', 'y', '0'),
(670, 1, 'email_traffic', '2013-10-19 16:27:50', 'Starting cron\nRead Email Notification info - LINE: 157\nSelect accounts to send email - LINE: 171\nCron finished', 'y', '0.15'),
(671, 1, 'rollback_import', '2013-10-19 16:37:13', 'Starting cron\nCron finished', 'y', '0'),
(672, 1, 'rollback_import_events', '2013-10-19 16:38:09', 'Starting cron\nCron finished', 'y', '0');

CREATE TABLE Dashboard (
  id int(11) NOT NULL AUTO_INCREMENT,
  domain_id int(11) NOT NULL,
  number_listings int(11) NOT NULL DEFAULT '0',
  number_content int(11) NOT NULL DEFAULT '0',
  revenue decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=48 ;

INSERT INTO Dashboard (id, domain_id, number_listings, number_content, revenue) VALUES
(1, 1, 35781, 123, '5660.00'),
(2, 2, 13, 39, '6010.00'),
(3, 3, 9197, 117, '10902.78'),
(7, 7, 2536, 5, '990.86'),
(6, 6, 4986, 33, '6394.70'),
(8, 8, 92, 9, '1794.00'),
(32, 32, 0, 0, '0.00'),
(33, 33, 0, 0, '0.00'),
(41, 41, 0, 0, '0.00'),
(42, 42, 0, 0, '0.00'),
(47, 47, 0, 0, '0.00');

CREATE TABLE Domain (
  id int(11) NOT NULL AUTO_INCREMENT,
  smaccount_id int(11) NOT NULL,
  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  database_host varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  database_port varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '3306',
  database_username varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  database_password varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  database_name varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  url varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `status` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'P' COMMENT 'A - Active, D - Deleted, P - Pending',
  activation_status char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'P' COMMENT 'A - Active, P - Pending',
  created date NOT NULL DEFAULT '0000-00-00',
  deleted_date date NOT NULL DEFAULT '0000-00-00',
  article_feature varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  banner_feature varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  classified_feature varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  event_feature varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  subfolder varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (id),
  KEY domain_info (url,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;


CREATE TABLE FAQ (
  id int(11) NOT NULL AUTO_INCREMENT,
  sitemgr char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  member char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  frontend char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  question text COLLATE utf8_unicode_ci NOT NULL,
  answer text COLLATE utf8_unicode_ci NOT NULL,
  editable char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=89 ;

INSERT INTO FAQ (id, sitemgr, member, frontend, question, answer, editable) VALUES
(1, 'y', 'n', 'n', 'When is the "Claim this ad" link available?', 'Listings without a sponsor account (No Owner) associated with a listing can use the claim feature ("Claim this ad" link will show up on the front of the directory for listings with no owner).', 'n'),
(2, 'y', 'n', 'n', 'Who can "Claim this ad"?', 'If the "Claim this ad" link is available on the front area, any sponsor, visitor or new user can claim the listing. After a user claims a listing the sitemgr can either deny their claim to the listing or approve it. The sitemgr''s approval gives the user full control over the listing.', 'n'),
(3, 'y', 'n', 'n', 'Can I turn off "Claim this ad" for a listing?', 'If the listing does not have an account and it is not available to claim, you can edit the listing and check the box "Disable claim feature for this listing". The "Claim this ad" link will be turned off for this listing.', 'n'),
(4, 'y', 'n', 'n', 'What is Default Image? And Where is it used?', 'If the sponsor or sitemgr forgets to upload an image to an item, to the gallery or another image field, the Default Image is used.', 'n'),
(5, 'y', 'n', 'n', 'My .csv file must have the same columns as the .csv sample file?', 'Make sure that your data columns match the sample .csv format provided. All fields are required (even if they have no data in them) for the import to function correctly.', 'n'),
(6, 'y', 'n', 'n', 'Can I delete any column on the .csv file import?', 'The same as above, if any columns are missing from the .csv file the import will not function correctly, please leave them all intact.', 'n'),
(7, 'y', 'n', 'n', 'Do I have to put my .csv file on the same order as the import .csv sample file?', 'Yes, you must use the format of the sample .csv. The data fields in the .csv that you upload must be in the same order as the sample template format. If the data is not in the correct order your data will not be imported correctly.', 'n'),
(8, 'y', 'n', 'n', 'Can I make imports with the same account? And different accounts?', 'If you want each item to have its own account then each item (row) in the .csv file will need a different account username entered. If multiple items have the same account associated with them in the .csv file they will be imported to the same account. If you plan on uploading many items into a single account we suggest doing a separate import for those imports and using the import settings to set the import to single account import.', 'n'),
(9, 'y', 'n', 'n', 'What happens if I misspell location on the import?', 'Please be specific when you are spelling text for your location fields. For example, if you import two items for the State of New York, and on a item you write NewYork, and on the other one you write New York, both States will appear in the advanced search dropdowns in the directory and each would need to be updated with your meta information for each location.', 'n'),
(10, 'y', 'n', 'n', 'What happens if I misspell a category on import?', 'Please be specific when you are spelling text for your category fields. If an item has the Arts & Entertainment category and the other one has Arts and Entertainment, both categories will appear in the item search dropdown fields, in the item browse by category area, and in the browse categories area on your item results pages.', 'n'),
(11, 'y', 'n', 'n', 'How many categories can I import?', 'Each item can have up to 5 categories imported. It will not import more than 5 categories.', 'n'),
(12, 'y', 'n', 'n', 'Can I import any username/password?', 'Invalid Usernames/Passwords will not be imported. Usernames need to be a valid e-mail between 4 and 80 characters with no spaces. Passwords need to have a minimum of 4 characters and maximum of 50 characters, we do not allow special character. If you are trying to import multiple items to the same account but are using different passwords for each row in your .csv file the import for the additional items will have problems. You may find it easier to use the Import Settings to upload multiple items to the same account.', 'n'),
(13, 'y', 'n', 'n', 'Do I have to import all items with an account?', 'If the username field is empty, the item will be imported without an account. That means that the item has no owner. If you are importing listings, this is a quick and easy way to use the claim feature on listings.', 'n'),
(14, 'y', 'n', 'n', 'What happens if I import more than one item with the same title?', 'The import will add the new items to database without deleting existing items. The friendly url will be different for each new item. <br />\r\nNOTE: If you want the data to be updated instead of creating new rows, you must check the option "Overwrite matching items" from within the import settings. The field Listing ID (or Event ID) in your CSV file must match with the value in your eDirectory database.', 'n'),
(15, 'y', 'n', 'n', 'What information is required to make the import work?', 'The minimum amount of information that is required is the "Title". All other fields can be blank in your .csv file.', 'n'),
(16, 'y', 'n', 'n', 'How can I import listings to have the "claim this ad" link for the claim feature?', 'To use the claim listing feature, do not assign a listing to a specific account. When doing the .csv import leave the columns related to member account information blank.', 'n'),
(18, 'y', 'n', 'n', 'Can I rollback an import?', 'You can roll back a finished or stopped import. All the accounts and items imported will be removed, but for security reasons the categories and locations imported will remain in the directory database. A task will be scheduled to roll back your data.', 'n'),
(19, 'y', 'n', 'n', 'How can I rollback imported data?', 'To rollback imported data, click on the Rollback button on the Import Log tab and follow the rollback process. <br />\r\nNote: Be sure to click on the Rollback button and not the delete icon (this just removes the import log record, not the data. Once the log file is removed, the data can not be rolled back, so be careful here).', 'n'),
(20, 'y', 'n', 'n', 'Can I delete an imported data log?', 'When using Delete Log button, data will not be removed from the directory. The specific log will be removed, but the data from the import will remain in the directory database.', 'n'),
(21, 'y', 'n', 'n', 'What is "Badge"?', 'Listing Badges allow you to designate listings with certain images of your choice. For example, if you want to mark a listing as "Editor''s Choice", you can upload your own icon, and mark (on the listing form) the listings you want to display the icon. You can also give members access to select the badges themselves by checking the box. For example you may want a "Pet Friendly" option that members can use to add to their listings.', 'n'),
(22, 'y', 'n', 'n', 'What are the listing types?', 'With the listing types you can modify the listings detail styles.<br /> PS: This feature isn''t available for themes Real Estate and Dining Guide.', 'n'),
(71, 'y', 'n', 'n', 'I am using the multi-domain feature, how can I see the items of the sites at the site manager area?', 'At the site manager area you can see the general data (related to all sites) at the top menu. And the data for each specific site you can see at the left menu, by changing the site at the drop-down list.', 'n'),
(23, 'y', 'n', 'n', 'Which type of modifications the listing types support?', 'You can charge an additional price per listing type, select the detail layout,  rename common fields (example: "Restaurant Name" instead of "Listing Title"), add new fields (checkboxes, dropdowns, text fields, short description fields and long descritpion fields) and select which of them will be required.<br /> PS: This feature isn''t available for themes Real Estate and Dining Guide.', 'n'),
(24, 'y', 'y', 'n', 'How can I add videos to my listing/event?', 'Only the diamond listing/event level has the video feature by default. You can enable video for others levels by going to Settings - Manage Levels.<br /> To add video to an item, you need to insert the video embed code in the item form in the Video Snippet Code field.', 'y'),
(25, 'y', 'y', 'n', 'Where can I find videos to my listings/events?', 'There are some sites that host videos. Examples: http://www.youtube.com, http://video.google.com, http://video.yahoo.com, http://www.dailymotion.com', 'y'),
(26, 'y', 'n', 'n', 'How do the Import Settings work?', 'On the "Import Settings" tab in the Settings area of the sitemgr, you can setup some import options:\r\n<br /> \r\n1. Import CSV comes from an Export: If you previously did an export from the import / exporter on your eDirectory installation - please check this box. \r\n<br />\r\n2. Enable all imported items as Active: Rather than having imported item in pending mode (so you can check them over and add data) this check box will make all imported items instantly active on the site. \r\n<br />\r\n3. Overwrite matching items: If you want to update an existing item in your eDirectory you must check this option.  For an item to be considered a match the following field must be identical on the imported .csv file and the database: Listing ID/Event ID.\r\n<br />\r\n4. Update friendly URL''s for matching items: It is strongly recommended that this option be left unchecked. If we find a record in the .csv file with a matching Listing ID/Event ID when compared to an existing record in the database, we will update that item with the new data (as detailed above), but with this option on we will also rewrite the URL based on the item title. If you have content that has been indexed by google, this content will cease to be reachable from the search engines until they update their data - this can take a day or months. Use Carefully. \r\n<br />\r\n5. All new categories set to featured: All categories that are imported will be automatically set to featured. \r\n<br />\r\n6. Default level for items without level specified: For all items with no level specified in the .csv file, you can choose a level here..\r\n<br />\r\n7. Import all items to the same user account: Everything in the .csv file will be attached to a single user account. After ticking this box, a dropdown will appear só that an account can be selected.', 'n'),
(27, 'y', 'n', 'n', 'How can I disable an Email Notification?', 'Go to the Email Notifications section and click on the active icon of the email you want to disable.', 'n'),
(28, 'n', 'y', 'n', 'How can I enable Google Maps?', 'The google maps feature is automatically enabled when you fill out the location fields on all items forms.', 'y'),
(29, 'n', 'y', 'n', 'How does the "Sign me in automatically" work?', 'The "Sign me in automatically" is optional, it saves your username and password on your computer and every time you access the page you will be automatically logged in.', 'y'),
(30, 'y', 'y', 'y', 'What happens if I forget my password?', 'If you forget your password, please click on the ''Forgot your Password?'' link of the front of the directory or on the sponsor login page. The password recovery email will be sent to the email address provided from your Contact Information. The email will contain a link which will redirect the user to the ''Manage Account'' section, where the password can be updated.', 'y'),
(31, 'n', 'y', 'n', 'How can I change my password?', 'After you are logged in, click on ''Manage account'' link, you will see the "Current Password" field, type your current password in this field and your new password on the fields "Password" and "Retype Password", then hit the submit button.', 'y'),
(32, 'n', 'y', 'n', 'Can I change my username?', 'No, you cannot. Only your password and contact information can be updated.', 'y'),
(33, 'n', 'y', 'n', 'Can I change my items status (active, pending or suspended)?', 'Yes, you can. If your item is active you can change it to suspended and vice versa. You cannot change the pending status of any item.', 'y'),
(34, 'n', 'y', 'n', 'Can I change my item level?', 'Yes, you can. After your item is expired you can choose the level (if it is free you can change the level anytime) and pay for it.', 'y'),
(35, 'n', 'y', 'n', 'Can I add categories to my deal?', 'No, you cannot. The deal is related to the listing categories you choose.', 'y'),
(81, 'y', 'n', 'n', 'What is the "Click to Call & Send to Phone" feature and how the Twilio api works?', 'With the "Click to Call & Send to Phone" feature your directory can send text messages to the users with the main information about your listing. Also, the users can contact directly the listing owners just clicking in the "Click to Call" button. You just need to create a Twilio account and upgrade it after you finish your free credits.', 'n'),
(37, 'n', 'n', 'y', 'Am I required to have an account to add items to the site?', 'Yes. In order to add any item, including Free items, to the directory you must have an account.', 'y'),
(38, 'n', 'n', 'y', 'How can I sign up for an account?', 'To sign up as a sponsor go to the ''Advertise With Us'' link at top menu, select an item and level and click in ''SIGN UP'' button. Fill out all fields, write down your username and password for future reference, choose the best payment gateway for you and follow the steps to finish the process.\r\nTo sign up as a visitor go to ''CREATE YOUR PROFILE'' at top of site, fill out all fields and click in ''SUBMIT''.', 'y'),
(39, 'n', 'n', 'y', 'What determines which listings appear as Featured Listings on the Home Page and main Listings page?', 'Only Diamond Listings appear as Featured Listings, and they are then randomly rotated.', 'y'),
(43, 'n', 'n', 'y', 'What do the numbers that appear after Category and Sub-Category names mean?', 'These numbers illustrate the total number of items registered under that category.', 'y'),
(44, 'n', 'n', 'y', 'Is it possible to search for events by date?', 'You can search for events by date by clicking on any specific day/month you choose directly on the calendar.', 'y'),
(45, 'y', 'y', 'y', 'Why am I receiving an ''Account Locked'' message?', 'If you attempt to access your account and type in an incorrect password 5 times the account will lock for 1 hour. This is for security reasons.', 'y'),
(46, 'y', 'n', 'n', 'How can I setup Facebook App ID and Facebook App Secret?', 'If you don''t already have a Facebook App ID and App Secret for your site, create an application with the Facebook Developer application. Note: Even if you have created an application and received an App Secret, you should review steps 4 through 7 and make sure your application settings are appropriate.<br />\r\n1. Go to https://developers.facebook.com/apps and click in + Create New App to create a new application.<br />\r\n2. Enter a name for your application in the App Display Name field.<br />\r\n3. Agree to the Facebook Platform Policies, then click Continue.<br />\r\n4. Enter the Security Check words, then click Submit.<br />\r\n5. On the Settings tab > Basic, take note of the App ID and App Secret, you''ll need this shortly.<br />\r\n6. Still on the Settings tab, click on Website and set Site URL to the top-level directory of the site which will be implementing Facebook Connect (this is usually your domain, e.g. http://www.example.com , but could also be a subdirectory). If your site is going to implement Facebook Connect across a number of subdomains of your site (for example, http://foo.example.com and bar.example.com), you need to enter a App Domain (which would be example.com in this case).<br />\r\n7. You can include a logo that appears on the Facebook Connect dialog. On the Settings tab > Basic, click Edit on the image next your App Name and browse to choose an image file. Your logo must be in JPG, GIF, or PNG format. If the image is larger than 75x75 pixels, it will be resized and converted, then click Save Changes.<br />\r\n8. Copy the App ID and App Secret and paste it on Setting > Sign In Options of your directory.', 'n'),
(86, 'y', 'n', 'n', 'Como habilito o PagSeguro no meu diretório?', 'Para habilitar o PagSeguro no seu diretório, você precisa de uma conta de vendedor ou empresarial no PagSeguro. Siga os passos abaixo para criar e configurar sua conta.<br /><br /> 1. Vá até a página de cadastro do PagSeguro em https://pagseguro.uol.com.br/registration/registration.jhtml;<br /> 2. Digite seu e-mail e senha e escolha um tipo de conta (Vendedor ou Empresarial);<br /> 3. Informe seus dados pessoais/empresariais, verifique os termos de contrato do PagSeguro e clique em ''Continuar'';<br /> 4. Você receberá um e-mail para confirmar sua conta;<br /> 5. Após a confirmação da conta, você precisa configurá-la para integrá-la ao seu diretório. Faça login e clique no menu <b>''Integrações''</b> - <b>''Token de segurança''</b>;<br /> 6. Clique em <b>''Gerar novo Token''</b> e tome nota do código;<br /> 7. Vá até o menu <b>''Integrações''</b> - <b>''Página de redirecionamento''</b>, selecione a opção <b>''Ativado''</b> e ative a URL: http://www.meudiretorio.com.br/<b>members/billing/processpayment.php?payment_method=pagseguro</b> , substituindo www.meudiretorio.com.br para a URL do seu diretório. Essa é a URL onde os usuários serão redirecionados após um pagamento;<br /> 8. Vá até o menu <b>''Integrações''</b> - <b>''Notificação de transações''</b>, selecione a opção <b>''Ativado''</b> e ative a URL: http://www.meudiretorio.com.br/<b>members/billing/pagseguroreturn.php</b> , substituindo www.meudiretorio.com.br para a URL do seu diretório. Certifique-se que a URL foi informada corretamente, caso contrário o PagSeguro não irá retornar os dados das transações para seu diretório;<br /> 9. Volte à interface administrativa do seu diretório e informe sua Conta (seu e-mail cadastrado no PagSeguro) e Token. Lembre-se de atualizar o campo ''Símbolo da moeda'' para <b>R$</b> e ''Moeda de Pagamento'' para <b>BRL</b>.<br /> 10. Clique em ''Enviar'' para habilitar o PagSeguro no seu diretório.<br /><br /> Obs: <br/ > -Lembre-se de atualizar o token de segurança no seu diretório sempre que gerar um novo token no Pagseguro;<br /> -Para que seus usuários possam fazer pagamentos com cartão de crédito, sua conta no PagSeguro precisa ser verificada. Leia mais em https://pagseguro.uol.com.br/account/viewCheck.jhtml ;<br /> -O PagSeguro envia os dados de uma transação para o diretório sempre que o status é alterado. Note que as formas de pagamento (cartão, boleto bancário, etc), possuem diferentes prazos para liberação do pagamento.', 'n'),
(68, 'y', 'n', 'n', 'What happens with the items when I disable a level?', 'In banner level cases, all items already registered of this level will keep showing on the front of the directory until their expiration. Otherwise these items will be treated as the ''default level'', however, the search order priority and the featured area priviliges will be the same as the disabled level.', 'n'),
(54, 'y', 'n', 'n', 'How does the "Featured Categories" work?', 'If you enable featured category on "Setting - Featured categories", only the selected module will show the featured checkbox when adding or editing a category. This box enable the category to be seen in Browse by category and it''s only available for the levels that appear on front - category and subcategory. When adding a category through import all new categories will come checked if this option is turned on in Import Settings.<br />PS: This feature isn''t available for the theme Dining Guide.', 'n'),
(53, 'y', 'n', 'n', 'Can I edit the maintenance page?', 'Yes. There''s a feature on Site Content in the General Section so you can edit how maintenance page will show up when the Maintenance Mode is on. ', 'n'),
(52, 'y', 'n', 'n', 'What happens when I enable maintenance mode?', 'When you turn on maintenance mode, all the front pages are redirected to the maintenance page.', 'n'),
(55, 'y', 'n', 'n', 'What are featured categories?', 'If you enable featured categories, only the selected categories will be show in browse by category.<br />PS: This feature isn''''t available for the theme Dining Guide.', 'n'),
(67, 'y', 'n', 'n', 'Can I change my Locations Options all the time?', 'No. If the directory already has items assigned to a level, it can´t be disabled. You also can´t choose a Default Location if there are items from different locations for that level.  Also, you can´t enable a Location Level if there are child levels enabled and non assigned items to that level you are trying to enable. For example: if the directory is using country, state and city, and there are items registered, you can enable neighborhood, but you can´t enable region because in this case the system will not have regions and states assigned. So, is extremely important decide your locations options before inserting data in directory. ', 'n'),
(66, 'y', 'n', 'n', 'My directory is using a Default Locations but now I want to use other locations. What should I do?', 'In setting locations, choose the option “No Default” in the select box that is holding the Default Location you don´t want anymore.', 'n'),
(65, 'y', 'n', 'n', 'What is the option “Show default” in Setting Locations?', 'When a default location is chosen, the option “show default” becomes available. When you enable it, the default location will be shown in all places that locations are shown, for example, in the summary and detail views for items. Otherwise the default location will be hidden. ', 'n'),
(62, 'y', 'n', 'n', 'What is Setting Locations?', 'This is where you choose the location levels you want to use within the directory. With this form you will also have the option to choose default locations and whether or not they will be illustrated on the front of the directory.', 'n'),
(63, 'y', 'n', 'n', 'How do I choose the locations levels I want to use?', 'There are five Locations Levels available: Country, Region, State, City and Neighborhood. Select which you want to use by checking the “enable” checkboxes for each level.', 'n'),
(64, 'y', 'n', 'n', 'What are Default Locations?', 'The locations chosen as default are automatically assigned to all items that will be registered in the directory. The member will not have the option to choose a different one. Example: select a default location if your directory will always show data in a specific location, e.g selecting United States as a default country will prevent you from adding Canada locations to your directory.', 'n'),
(69, 'y', 'n', 'n', 'What happens if I delete a site?', 'Be sure that the site you are deleting is no longer accessible, because once it been deleted, the home page, members and site manager areas do not work anymore.\r\nAfter delete the site, your data base will be preserved for one week, so you can recover it if you want. After that, all data base and files related to your site will be deleted.', 'n'),
(70, 'y', 'n', 'n', 'What I have to do after I create a new site?', 'After you create a new site an email will be sent to the eDirectory support team. \r\nAfter that the support team will prepare the site to work correctly in the front. \r\nThe new site only will be completed after you buy a new eDirectory licence with a discounted rate and finish the registration process for all these sites. \r\nIn the "Sites Management Page" has a column in the table to indicate the activation status of your sites. \r\nActive means the registration process was finished and the site has been activated. \r\nPending means the registration process is waiting for the licence and activation.', 'n'),
(72, 'y', 'n', 'n', 'I am using the multi-domain feature, can I use different locations levels for each site?', 'Yes, you can configure the location levels for each site, e.g. Country > State > City for the site 1, State > City for the site 2 and just City for the site 3.', 'n'),
(73, 'y', 'n', 'n', 'I am using the multi-domain feature, can I add different locations for each site?', 'Yes, you can add different location for each site (but first you must configure the locations levels for each site).', 'n'),
(77, 'y', 'n', 'n', 'How can I setup a Twitter API to work with users profile and last tweets?', 'Twitter API can be used for the following features: <br /><br />-Last Tweets: Show a Last Tweets feed at the footer of your site, showing your visitors the latest tweets from an account;<br />-User profiles: Users can attach a twitter account to their eDirectory account to show the latest tweets on their profile pages;<br />-Deals: On deals redeem, after clicking on ''Redeem'' button, the deal will be posted on user''s Facebook account. If an user has the Twitter account configured on his profile, it will be posted to user''s Twitter also.<br /><br />To use Last Tweets feed or allow your users to configure their Twitter account into /profile side, you need to configure the API into Site manager Settings > Twitter > API for last Tweets and Deals feature.<br /><br />Note: If you don''t have it, you need to configure in http://dev.twitter.com/apps.<br />Follow the 5 steps and Twitter will show up with the API information to integrate into your eDirectory.<br /><br />1. Go to dev.twitter.com and click in ''Create a new application'';<br />2. Fill all fields correctly. Callback URL must be <strong>youredirectory.com/twitter.php</strong>;<br />3. After save your aplication, click in the tab ''Settings''. Set the Application Type as ''Read and Write'' and save;<br />4. On the tab ''Details'', click in ''Create my access token''. Take note of your Acesss token, Access token secret,  Consumer key and Consumer Secret;<br />5. After you register the application go to your Site Manager Area > Settings > Twitter and set the Twitter API Key, Secret Code, Acesss token and Access token secret and save.', 'n'),
(75, 'y', 'n', 'n', 'I am using the multi-domain feature, how will the import work?', 'You have to import different files for each site. When you make an import, the items and categories will be imported into the selected site; the account will be imported to a general database, which means that the member can login using the account on all sites. The locations will be imported and will appear for the selected site.', 'n'),
(76, 'y', 'n', 'n', 'I want to use the multi-domain feature, how can I enable it?', 'If you want to have different sites you can use the multi-domain feature and create a new site. Click on Sites > Add, fill out the new site information and click on the Submit button.', 'n'),
(78, 'y', 'n', 'n', 'How can I setup a Twitter API to work with Chek In feature?', 'Twitter API works on Check ins feature on eDirectory and users can check in into a specific Listing on their mobile devices. If the user has the Twitter account configured on his profile, the check in will be also posted to user''s twitter.<br />To allow your users to configure their Twitter account into /profile side, you need to configure the API and Secret Key into Site manager Settings > Twitter > API for Check In feature. <br /><br />Note: If you don''t have it, you need to configure in http://dev.twitter.com/.<br />Follow the 3 steps and Twitter will show up with API and Secret key to integrate into your eDirectory.<br /><br />1. Go to dev.twitter.com and click in ''Create an App'';<br />2. Fill all fields correctly. Leave the field Callback URL blank;<br />3. After save your aplication, click in the tab Settings. Set the Application Type as ''Read and Write'' and save;<br />4. After you register the application go to the sitemgr > Twitter Settings and set the Twitter API Key and Secret Code and save.', 'n'),
(79, 'y', 'n', 'n', 'What is the field Listing ID/Event ID?', 'If your CSV file comes from Export Section, this field will be filled with the values in your eDirectory database. Items that match (with the same Listing ID/Event ID) on import can be overwritten / replaced during the import process. This setting can be found on the import settings tab.', 'n'),
(80, 'y', 'n', 'n', 'What is the recommended size of my CSV file?', 'If you want to upload a CSV, we recommend small files with default maximum of 5mb. For bigger files, you must send your file to the import folder by FTP first and use the Select File by FTP option on the import window. Notice that when you use the FTP option, a task will be scheduled to prepare your file before the import, depending on your server configuration this can take some time.', 'n'),
(83, 'y', 'n', 'n', 'What are the fields Start Time Mode and End Time Mode?', 'If you are importing events which have start time or end time, you must fill in these fields. Use "AM" or "PM" if your clock type is 12 hours or just put "24" if you use a 24 hours clock.', 'n'),
(85, 'y', 'n', 'n', 'What is Favicon? And where is it used?', 'A favicon (short for favorites icon) is a file containing one small icon, most commonly 16×16 pixels, associated with a particular Web site. Browsers that provide favicon support typically display a page''s favicon in the browser''s address bar and next to the page''s name in a list of bookmarks. Also, the ones that support a tabbed document interface typically show a page''s favicon next to the page''s title on the tab. By using a favicon your users can identify your directory web site in a list of others web sites.', 'n'),
(82, 'y', 'n', 'n', 'How can I setup my Twilio API?', 'Go to http://www.twilio.com/pricing/ and click in "Get started". In the next page, fill in your First Name, Last Name, Email and Password and click in "Get started". You will be logged in and in the following page you will see your Account SID, Auth Token and Sandbox Number. Just copy these informations to your site manager and click in "Submit".', 'n'),
(87, 'y', 'n', 'n', 'O que significam os status das transações do PagSeguro?', 'O PagSeguro retorna diferentes status de transações para o diretório durante o processo de pagamento. Veja abaixo os detalhes de cada status:<br /><br />\r\n<b>-Aguardando pagamento/aprovação: </b>O comprador iniciou a transação, mas até o momento o PagSeguro não recebeu nenhuma informação sobre o pagamento;<br />\r\n<b>-Em análise: </b>O comprador optou por pagar com um cartão de crédito e o PagSeguro está analisando o risco da transação;<br />\r\n<b>-Pago: </b>A transação foi paga pelo comprador e o PagSeguro já recebeu uma confirmação da instituição financeira responsável pelo processamento;<br />\r\n<b>-Disponível: </b>A transação foi paga e chegou ao final de seu prazo de liberação sem ter sido retornada e sem que haja nenhuma disputa aberta;<br />\r\n<b>-Em disputa: </b>O comprador, dentro do prazo de liberação da transação, abriu uma disputa;<br />\r\n<b>-Devolvido: </b>O valor da transação foi devolvido para o comprador;<br />\r\n<b>-Cancelado: </b>A transação foi cancelada sem ter sido finalizada.<br />', 'n'),
(88, 'y', 'n', 'n', 'How do I signup for a Google Maps API?', 'Follow the steps below to create your API key.<br />\r\n1. Go to https://code.google.com/apis/console/ ;<br />\r\n2. On the Services Tab, enable the Google Maps API v3 option;<br />\r\n3. On the API Access Tab, take note of the API key in the Simple API Access option;<br />\r\n4. You can limit this API to specific domains by informing them in the ''Create new Browser key...'' option;<br />\r\n5. After save your API key on your site manager interface, you can track your API usage on the Reports tab.', 'n');

CREATE TABLE Forgot_Password (
  account_id int(11) NOT NULL DEFAULT '0',
  unique_key varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  entered date NOT NULL DEFAULT '0000-00-00',
  section varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  KEY account_id (account_id),
  KEY unique_key (unique_key),
  KEY entered (entered),
  KEY section (section)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE Frequently_Actions (
  smaccount_id int(11) NOT NULL,
  domain_id int(11) NOT NULL,
  `session` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  rate int(11) NOT NULL DEFAULT '0',
  module varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (smaccount_id,domain_id,`session`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO Frequently_Actions (smaccount_id, domain_id, session, rate, module) VALUES
(0, 1, 'listing_search', 1179, 'listing'),
(0, 1, 'listing_manage', 1126, 'listing'),
(0, 1, 'listingcateg_manage', 62, 'listing'),
(0, 1, 'prefs_emailsendconf', 34, 'prefsemail'),
(0, 1, 'prefs_emailnotific', 58, 'emailnotif'),
(0, 1, 'prefs_systememail', 13, 'prefsemail'),
(0, 1, 'account_manage', 201, 'account'),
(0, 1, 'prefs_twitter', 20, 'prefstwitter'),
(0, 1, 'seocenter_manage', 16, 'seocenter'),
(0, 1, 'prefs_aprovalrequirement', 12, 'settingsapproval'),
(0, 1, 'import_home', 8, 'import'),
(0, 1, 'prefs_invoiceinformation', 8, 'INVOICEPAYMENT_FEATURE'),
(0, 1, 'eventcateg_manage', 19, 'EVENT_FEATURE'),
(0, 1, 'classifiedcateg_manage', 7, 'CLASSIFIED_FEATURE'),
(0, 1, 'articlecateg_manage', 7, 'ARTICLE_FEATURE'),
(0, 1, 'claimlisting_manage', 8, 'CLAIM_FEATURE'),
(0, 1, 'listingtemplate_manage', 14, 'listing'),
(0, 1, 'article_search', 18, 'ARTICLE_FEATURE'),
(0, 1, 'article_manage', 35, 'ARTICLE_FEATURE'),
(0, 1, 'article_add', 10, 'ARTICLE_FEATURE'),
(0, 1, 'prefs_paymentgateway', 39, 'PAYMENTSYSTEM_FEATURE'),
(0, 1, 'transaction_history', 29, 'PAYMENT_FEATURE'),
(0, 1, 'custominvoice_manage', 6, 'CUSTOM_INVOICE_FEATURE'),
(0, 1, 'invoice_history', 21, 'INVOICEPAYMENT_FEATURE'),
(0, 1, 'discountcode_manage', 3, 'PAYMENTSYSTEM_FEATURE'),
(0, 1, 'discountcode_add', 4, 'PAYMENTSYSTEM_FEATURE'),
(0, 1, 'prefs_pricing', 21, 'pricing'),
(0, 1, 'report_system', 7, 'report'),
(0, 1, 'report_statistic', 10, 'report'),
(0, 1, 'prefs_theme', 55, 'prefstheme'),
(0, 1, 'prefs_signinoptions', 25, 'prefssign'),
(0, 1, 'prefs_langcenter', 143, 'MULTILANGUAGE_FEATURE'),
(0, 1, 'prefs_faq', 12, 'faq'),
(0, 1, 'prefs_robotsfilter', 6, 'prefsrobots'),
(0, 1, 'prefs_maintenancemode', 9, 'prefsmaintenance'),
(0, 1, 'prefs_import', 18, 'import'),
(0, 1, 'prefs_featuredcategory', 10, 'prefscategory'),
(0, 1, 'prefs_socialnetwork', 19, 'prefssn'),
(0, 1, 'prefs_designation', 23, 'editorchoice'),
(0, 1, 'prefs_managelevel', 27, 'prefslevels'),
(0, 1, 'prefs_promotion', 25, 'prefspromotion'),
(0, 1, 'prefs_review', 7, 'review'),
(0, 1, 'prefs_claim', 15, 'CLAIM_FEATURE'),
(0, 1, 'banner_manage', 46, 'BANNER_FEATURE'),
(0, 1, 'promotion_manage', 120, 'PROMOTION_FEATURE'),
(0, 1, 'event_manage', 158, 'EVENT_FEATURE'),
(0, 1, 'blog_manage', 89, 'BLOG_FEATURE'),
(0, 1, 'post_add', 22, 'BLOG_FEATURE'),
(0, 1, 'blogcateg_manage', 10, 'BLOG_FEATURE'),
(0, 1, 'blogcateg_add', 8, 'BLOG_FEATURE'),
(0, 1, 'event_search', 36, 'EVENT_FEATURE'),
(0, 1, 'post_search', 7, 'BLOG_FEATURE'),
(0, 1, 'content_header', 17, 'content'),
(0, 1, 'account_add', 126, 'account'),
(0, 1, 'account_search', 9, 'account'),
(0, 1, 'banner_search', 14, 'BANNER_FEATURE'),
(0, 1, 'classified_manage', 94, 'CLASSIFIED_FEATURE'),
(0, 1, 'export_data', 21, 'export'),
(0, 1, 'smaccount_manage', 20, 'smaaccount'),
(0, 1, 'export_paymentrecords', 5, 'PAYMENTSYSTEM_FEATURE'),
(0, 1, 'custominvoice_search', 2, 'CUSTOM_INVOICE_FEATURE'),
(0, 1, 'custominvoice_add', 1, 'CUSTOM_INVOICE_FEATURE'),
(0, 1, 'prefs_googlemaps', 10, 'GOOGLE_MAPS_ENABLED'),
(0, 1, 'prefs_googleads', 9, 'GOOGLE_ADS_ENABLED'),
(0, 1, 'prefs_googleanalytics', 6, 'GOOGLE_ANALYTICS_ENABLED'),
(0, 1, 'locationCountry_manage', 1, 'location'),
(0, 1, 'reviewlisting_manage', 160, 'listing'),
(0, 1, 'location1_manage', 58, 'location'),
(0, 1, 'location1_add', 9, 'location'),
(0, 1, 'prefs_locations', 28, 'prefslocation'),
(0, 1, 'listing_add', 55, 'listing'),
(0, 1, 'reviewarticle_manage', 18, 'ARTICLE_FEATURE'),
(0, 1, 'location3_manage', 35, 'location'),
(0, 1, 'location4_manage', 57, 'location'),
(0, 1, 'event_add', 55, 'EVENT_FEATURE'),
(0, 1, 'content_general', 68, 'content'),
(0, 1, 'content_noimage', 7, 'content'),
(0, 1, 'content_classified', 4, 'CLASSIFIED_FEATURE'),
(0, 1, 'content_article', 2, 'ARTICLE_FEATURE'),
(0, 1, 'content_member', 8, 'content'),
(0, 1, 'smaccount_add', 6, 'smaaccount'),
(0, 1, 'content_advertisement', 74, 'content'),
(0, 1, 'listing_featuredcateg', 7, 'listing'),
(0, 1, 'prefs_blog', 1, 'BLOG_FEATURE'),
(0, 1, 'event_featuredcateg', 2, 'EVENT_FEATURE'),
(0, 1, 'classified_featuredcateg', 2, 'CLASSIFIED_FEATURE'),
(0, 1, 'article_featuredcateg', 2, 'ARTICLE_FEATURE'),
(0, 1, 'location4_add', 19, 'location'),
(0, 1, 'claimlisting_search', 5, 'CLAIM_FEATURE'),
(0, 1, 'promotion_add', 36, 'PROMOTION_FEATURE'),
(0, 1, 'domain_manage', 105, 'domain'),
(0, 1, 'package_manage', 28, 'package builder'),
(0, 1, 'package_add', 11, 'Package Builder'),
(0, 1, 'package_reports', 3, 'package builder'),
(0, 1, 'package_search', 1, 'package_search'),
(0, 1, 'import_log', 3, 'import'),
(0, 1, 'content_custom', 4, 'content'),
(0, 1, 'content_listing', 4, 'content'),
(0, 1, 'content_event', 1, 'EVENT_FEATURE'),
(0, 1, 'domain_add', 115, 'domain'),
(1, 1, 'prefs_theme', 1, 'prefstheme'),
(1, 1, 'prefs_langcenter', 4, 'MULTILANGUAGE_FEATURE'),
(0, 1, 'banner_add', 23, 'BANNER_FEATURE'),
(0, 3, 'classifiedcateg_manage', 1, 'CLASSIFIED_FEATURE'),
(0, 1, 'wordpress', 6, 'wordpress'),
(0, 1, 'content_promotion', 1, 'PROMOTION_FEATURE'),
(0, 3, 'event_search', 1, 'EVENT_FEATURE'),
(0, 3, 'banner_search', 9, 'BANNER_FEATURE'),
(0, 3, 'export_paymentrecords', 1, 'PAYMENTSYSTEM_FEATURE'),
(0, 3, 'mailapp_signup', 7, 'mailapp'),
(0, 3, 'content_article', 2, 'ARTICLE_FEATURE'),
(0, 1, 'listingcateg_add', 4, 'listing'),
(1, 1, 'domain_manage', 12, 'domain'),
(1, 1, 'package_manage', 12, 'package builder'),
(0, 1, 'prefs_backlinks', 3, 'backlinks'),
(0, 1, 'classified_search', 20, 'CLASSIFIED_FEATURE'),
(0, 3, 'content_classified', 2, 'CLASSIFIED_FEATURE'),
(0, 1, 'prefs_twilio', 7, 'prefstwilio'),
(0, 3, 'prefs_faq', 4, 'faq'),
(0, 3, 'prefs_modules', 7, 'modules'),
(0, 3, 'content_blog', 3, 'BLOG_FEATURE'),
(0, 3, 'location3_add', 54, 'location'),
(0, 1, 'prefs_modules', 5, 'modules'),
(0, 1, 'reviewpromotion_manage', 19, 'PROMOTION_FEATURE'),
(0, 1, 'prefs_tax', 14, 'prefstax'),
(0, 1, 'sugar', 8, 'sugar'),
(0, 1, 'prefs_commenting', 14, 'commenting'),
(0, 1, 'classified_add', 17, 'CLASSIFIED_FEATURE'),
(0, 3, 'report_system', 1, 'report'),
(0, 2, 'prefs_paymentgateway', 5, 'PAYMENTSYSTEM_FEATURE'),
(0, 3, 'listingtemplate_manage', 9, 'listing'),
(0, 3, 'listing_featuredcateg', 7, 'listing'),
(0, 3, 'custominvoice_add', 4, 'CUSTOM_INVOICE_FEATURE'),
(0, 3, 'mailapp_export', 17, 'mailapp'),
(0, 3, 'claimlisting_search', 2, 'CLAIM_FEATURE'),
(0, 3, 'custominvoice_search', 1, 'CUSTOM_INVOICE_FEATURE'),
(0, 3, 'package_add', 2, 'Package Builder'),
(0, 3, 'discountcode_add', 3, 'PAYMENTSYSTEM_FEATURE'),
(0, 3, 'discountcode_manage', 2, 'PAYMENTSYSTEM_FEATURE'),
(0, 3, 'location1_add', 1, 'location'),
(0, 3, 'location4_add', 6, 'location'),
(0, 3, 'prefs_designation', 5, 'editorchoice'),
(0, 3, 'mailapp_manage', 16, 'mailapp'),
(0, 3, 'banner_add', 8, 'BANNER_FEATURE'),
(0, 3, 'account_search', 2, 'account'),
(0, 3, 'reviewpromotion_manage', 1, 'PROMOTION_FEATURE'),
(0, 3, 'reviewarticle_manage', 2, 'ARTICLE_FEATURE'),
(0, 3, 'prefs_signinoptions', 5, 'prefssign'),
(0, 3, 'prefs_twitter', 9, 'prefstwitter'),
(0, 3, 'prefs_api', 3, 'prefs_api'),
(0, 3, 'import_log', 6, 'import'),
(0, 3, 'prefs_import', 2, 'import'),
(0, 3, 'post_add', 1, 'BLOG_FEATURE'),
(0, 3, 'prefs_featuredcategory', 3, 'prefscategory'),
(0, 3, 'prefs_socialnetwork', 24, 'prefssn'),
(0, 3, 'promotion_add', 16, 'PROMOTION_FEATURE'),
(0, 3, 'article_add', 9, 'ARTICLE_FEATURE'),
(0, 2, 'prefs_emailnotific', 5, 'emailnotif'),
(0, 3, 'classified_add', 9, 'CLASSIFIED_FEATURE'),
(0, 3, 'classified_manage', 24, 'CLASSIFIED_FEATURE'),
(0, 2, 'banner_manage', 9, 'BANNER_FEATURE'),
(0, 3, 'export_downloadfiles', 33, 'export'),
(0, 1, 'export_downloadfiles', 4, 'export'),
(0, 3, 'smaccount_add', 4, 'smaaccount'),
(0, 2, 'content_general', 10, 'content'),
(0, 2, 'reviewlisting_manage', 1, 'listing'),
(0, 3, 'prefs_googlemaps', 3, 'GOOGLE_MAPS_ENABLED'),
(0, 3, 'prefs_googleads', 5, 'GOOGLE_ADS_ENABLED'),
(0, 3, 'prefs_googleanalytics', 4, 'GOOGLE_ANALYTICS_ENABLED'),
(0, 3, 'prefs_invoiceinformation', 9, 'INVOICEPAYMENT_FEATURE'),
(0, 3, 'prefs_theme', 5, 'prefstheme'),
(0, 3, 'prefs_aprovalrequirement', 4, 'settingsapproval'),
(0, 3, 'prefs_claim', 8, 'CLAIM_FEATURE'),
(0, 3, 'prefs_paymentgateway', 13, 'PAYMENTSYSTEM_FEATURE'),
(0, 3, 'content_navigation', 22, 'content'),
(0, 3, 'prefs_emailsendconf', 9, 'prefsemail'),
(0, 3, 'content_htmleditor', 11, 'content'),
(0, 3, 'content_promotion', 2, 'PROMOTION_FEATURE'),
(0, 3, 'content_listing', 3, 'content'),
(0, 2, 'content_custom', 3, 'content'),
(0, 3, 'content_custom', 5, 'content'),
(0, 3, 'content_member', 10, 'content'),
(0, 3, 'content_advertisement', 19, 'content'),
(0, 3, 'content_footer', 6, 'content'),
(0, 3, 'content_noimage', 4, 'content'),
(0, 3, 'content_icon', 5, 'content'),
(0, 3, 'content_header', 7, 'content'),
(0, 3, 'content_general', 60, 'content'),
(0, 3, 'prefs_emailnotific', 50, 'emailnotif'),
(0, 3, 'prefs_systememail', 7, 'prefsemail'),
(0, 3, 'prefs_commenting', 13, 'commenting'),
(0, 3, 'invoice_history', 5, 'INVOICEPAYMENT_FEATURE'),
(0, 3, 'account_add', 14, 'account'),
(0, 3, 'reviewlisting_manage', 48, 'listing'),
(1, 3, 'event_add', 5, 'EVENT_FEATURE'),
(1, 3, 'event_manage', 1, 'EVENT_FEATURE'),
(0, 3, 'eventcateg_add', 2, 'EVENT_FEATURE'),
(0, 3, 'export_data', 43, 'export'),
(0, 3, 'seocenter_manage', 8, 'seocenter'),
(0, 3, 'smaccount_manage', 3, 'smaaccount'),
(0, 3, 'article_manage', 12, 'ARTICLE_FEATURE'),
(0, 2, 'listingcateg_manage', 2, 'listing'),
(0, 2, 'prefs_langcenter', 18, 'MULTILANGUAGE_FEATURE'),
(0, 3, 'promotion_manage', 22, 'PROMOTION_FEATURE'),
(0, 3, 'account_manage', 63, 'account'),
(0, 3, 'blog_manage', 6, 'BLOG_FEATURE'),
(0, 3, 'package_manage', 23, 'package builder'),
(0, 3, 'import_home', 14, 'import'),
(0, 3, 'event_add', 44, 'EVENT_FEATURE'),
(0, 3, 'listing_add', 9, 'listing'),
(0, 3, 'prefs_langcenter', 29, 'MULTILANGUAGE_FEATURE'),
(0, 3, 'wordpress', 6, 'wordpress'),
(0, 1, 'eventcateg_add', 3, 'EVENT_FEATURE'),
(0, 2, 'prefs_signinoptions', 5, 'prefssign'),
(0, 2, 'prefs_commenting', 7, 'commenting'),
(0, 3, 'articlecateg_manage', 2, 'ARTICLE_FEATURE'),
(0, 3, 'domain_manage', 9, 'domain'),
(0, 3, 'eventcateg_manage', 4, 'EVENT_FEATURE'),
(0, 3, 'banner_manage', 13, 'BANNER_FEATURE'),
(0, 3, 'listingcateg_manage', 16, 'listing'),
(0, 2, 'prefs_share', 4, 'prefsshare'),
(0, 3, 'prefs_share', 3, 'prefsshare'),
(0, 1, 'prefs_share', 8, 'prefsshare'),
(0, 1, 'prefs_api', 7, 'prefs_api'),
(0, 2, 'prefs_theme', 1, 'prefstheme'),
(0, 2, 'domain_manage', 6, 'domain'),
(0, 3, 'prefs_managelevel', 46, 'prefslevels'),
(0, 3, 'listing_search', 900, 'listing'),
(0, 2, 'listing_search', 2, 'listing'),
(0, 1, 'location3_add', 4, 'location'),
(0, 1, 'listingcateg_disabled', 2, 'listing'),
(0, 3, 'listing_manage', 1487, 'listing'),
(0, 3, 'prefs_pricing', 12, 'pricing'),
(0, 3, 'prefs_tax', 11, 'prefstax'),
(0, 3, 'transaction_history', 10, 'PAYMENT_FEATURE'),
(0, 2, 'transaction_history', 4, 'PAYMENT_FEATURE'),
(0, 2, 'listing_manage', 71, 'listing'),
(0, 2, 'prefs_tax', 6, 'prefstax'),
(0, 2, 'prefs_pricing', 8, 'pricing'),
(0, 3, 'event_manage', 55, 'EVENT_FEATURE'),
(0, 1, 'content_navigation', 3, 'content'),
(0, 2, 'prefs_emailsendconf', 7, 'prefsemail'),
(0, 2, 'location1_manage', 3, 'location'),
(0, 2, 'location3_manage', 3, 'location'),
(0, 2, 'location4_manage', 2, 'location'),
(0, 3, 'location1_manage', 17, 'location'),
(0, 3, 'prefs_locations', 12, 'prefslocation'),
(0, 3, 'location3_manage', 23, 'location'),
(0, 3, 'location4_manage', 58, 'location'),
(0, 2, 'blog_manage', 6, 'BLOG_FEATURE'),
(0, 2, 'banner_search', 5, 'BANNER_FEATURE'),
(0, 2, 'blogcateg_manage', 15, 'BLOG_FEATURE'),
(0, 7, 'import_home', 2, 'import'),
(0, 7, 'prefs_langcenter', 7, 'MULTILANGUAGE_FEATURE'),
(0, 7, 'import_log', 5, 'import'),
(0, 7, 'listing_manage', 555, 'listing'),
(0, 7, 'listingcateg_manage', 9, 'listing'),
(0, 7, 'listing_search', 1610, 'listing'),
(0, 7, 'prefs_theme', 7, 'prefstheme'),
(1, 7, 'listing_manage', 4, 'listing'),
(0, 7, 'prefs_managelevel', 24, 'prefslevels'),
(0, 7, 'package_manage', 10, 'package builder'),
(0, 7, 'package_add', 1, 'Package Builder'),
(0, 7, 'banner_manage', 24, 'BANNER_FEATURE'),
(0, 7, 'promotion_manage', 21, 'PROMOTION_FEATURE'),
(0, 7, 'blog_manage', 7, 'BLOG_FEATURE'),
(0, 7, 'domain_manage', 14, 'domain'),
(0, 7, 'prefs_modules', 3, 'modules'),
(0, 7, 'post_add', 25, 'BLOG_FEATURE'),
(0, 7, 'blogcateg_manage', 2, 'BLOG_FEATURE'),
(0, 7, 'blogcateg_add', 3, 'BLOG_FEATURE'),
(0, 7, 'banner_add', 25, 'BANNER_FEATURE'),
(0, 7, 'prefs_commenting', 9, 'commenting'),
(0, 7, 'prefs_pricing', 4, 'pricing'),
(0, 7, 'promotion_add', 21, 'PROMOTION_FEATURE'),
(0, 6, 'prefs_emailsendconf', 8, 'prefsemail'),
(0, 7, 'prefs_emailsendconf', 13, 'prefsemail'),
(0, 7, 'prefs_emailnotific', 7, 'emailnotif'),
(0, 7, 'prefs_systememail', 3, 'prefsemail'),
(0, 7, 'prefs_invoiceinformation', 5, 'INVOICEPAYMENT_FEATURE'),
(0, 7, 'prefs_paymentgateway', 9, 'PAYMENTSYSTEM_FEATURE'),
(0, 7, 'prefs_googleads', 3, 'GOOGLE_ADS_ENABLED'),
(0, 7, 'prefs_googleanalytics', 4, 'GOOGLE_ANALYTICS_ENABLED'),
(0, 7, 'prefs_googlemaps', 3, 'GOOGLE_MAPS_ENABLED'),
(0, 7, 'content_header', 11, 'content'),
(0, 7, 'content_noimage', 5, 'content'),
(0, 7, 'prefs_locations', 8, 'prefslocation'),
(0, 7, 'prefs_aprovalrequirement', 4, 'settingsapproval'),
(0, 7, 'prefs_claim', 4, 'CLAIM_FEATURE'),
(0, 3, 'custominvoice_manage', 5, 'CUSTOM_INVOICE_FEATURE'),
(0, 6, 'domain_manage', 12, 'domain'),
(0, 6, 'prefs_theme', 8, 'prefstheme'),
(0, 6, 'prefs_systememail', 2, 'prefsemail'),
(0, 6, 'prefs_emailnotific', 3, 'emailnotif'),
(0, 6, 'prefs_paymentgateway', 5, 'PAYMENTSYSTEM_FEATURE'),
(0, 7, 'wordpress', 2, 'wordpress'),
(0, 6, 'mailapp_manage', 5, 'mailapp'),
(0, 1, 'mailapp_manage', 11, 'mailapp'),
(0, 6, 'listing_manage', 28, 'listing'),
(0, 6, 'content_navigation', 8, 'content'),
(0, 7, 'content_navigation', 18, 'content'),
(0, 7, 'content_general', 35, 'content'),
(0, 7, 'prefs_twitter', 5, 'prefstwitter'),
(0, 7, 'content_footer', 6, 'content'),
(0, 7, 'prefs_promotion', 6, 'prefspromotion'),
(0, 7, 'location1_manage', 5, 'location'),
(0, 6, 'reviewlisting_manage', 6, 'listing'),
(0, 7, 'account_manage', 22, 'account'),
(0, 7, 'account_add', 21, 'account'),
(0, 7, 'reviewlisting_manage', 137, 'listing'),
(0, 6, 'account_manage', 13, 'account'),
(0, 6, 'prefs_api', 7, 'prefs_api'),
(0, 7, 'reviewpromotion_manage', 57, 'PROMOTION_FEATURE'),
(0, 7, 'prefs_designation', 17, 'editorchoice'),
(0, 6, 'prefs_designation', 8, 'editorchoice'),
(0, 6, 'banner_manage', 5, 'BANNER_FEATURE'),
(0, 1, 'content_icon', 5, 'content'),
(0, 1, 'content_footer', 5, 'content'),
(0, 7, 'content_icon', 8, 'content'),
(0, 7, 'content_advertisement', 12, 'content'),
(0, 7, 'content_member', 10, 'content'),
(0, 7, 'content_custom', 4, 'content'),
(0, 7, 'content_listing', 7, 'content'),
(0, 7, 'content_promotion', 3, 'PROMOTION_FEATURE'),
(0, 7, 'content_blog', 5, 'BLOG_FEATURE'),
(0, 7, 'content_htmleditor', 5, 'content'),
(0, 2, 'content_header', 5, 'content'),
(0, 2, 'content_footer', 3, 'content'),
(0, 2, 'content_icon', 2, 'content'),
(0, 2, 'content_noimage', 2, 'content'),
(0, 2, 'content_advertisement', 7, 'content'),
(0, 2, 'content_member', 3, 'content'),
(0, 2, 'content_listing', 3, 'content'),
(0, 2, 'content_blog', 2, 'BLOG_FEATURE'),
(0, 2, 'content_navigation', 1, 'content'),
(0, 6, 'content_general', 12, 'content'),
(0, 6, 'content_header', 3, 'content'),
(0, 6, 'content_footer', 2, 'content'),
(0, 6, 'content_noimage', 2, 'content'),
(0, 6, 'content_icon', 4, 'content'),
(0, 6, 'content_advertisement', 10, 'content'),
(0, 6, 'content_member', 4, 'content'),
(0, 6, 'content_custom', 1, 'content'),
(0, 6, 'content_listing', 2, 'content'),
(0, 6, 'content_promotion', 1, 'PROMOTION_FEATURE'),
(0, 6, 'content_blog', 1, 'BLOG_FEATURE'),
(0, 6, 'content_htmleditor', 1, 'content'),
(0, 3, 'content_event', 1, 'EVENT_FEATURE'),
(0, 3, 'prefs_promotion', 5, 'prefspromotion'),
(0, 6, 'prefs_promotion', 1, 'prefspromotion'),
(0, 6, 'prefs_claim', 2, 'CLAIM_FEATURE'),
(0, 6, 'prefs_tax', 2, 'prefstax'),
(0, 7, 'prefs_tax', 5, 'prefstax'),
(0, 2, 'prefs_claim', 3, 'CLAIM_FEATURE'),
(0, 2, 'prefs_systememail', 2, 'prefsemail'),
(0, 7, 'mailapp_manage', 2, 'mailapp'),
(0, 2, 'mailapp_manage', 2, 'mailapp'),
(0, 2, 'mobile_screen', 1, 'mobile'),
(0, 2, 'mobile_notif', 1, 'app_notifications'),
(0, 2, 'mobile_advert', 1, 'app_adverts'),
(0, 7, 'mobile_advert', 2, 'app_adverts'),
(0, 7, 'mobile_notif', 1, 'app_notifications'),
(0, 7, 'mobile_screen', 2, 'mobile'),
(0, 6, 'mobile_screen', 6, 'mobile'),
(0, 6, 'mobile_notif', 1, 'app_notifications'),
(0, 6, 'mobile_advert', 1, 'app_adverts'),
(0, 3, 'mobile_advert', 2, 'app_adverts'),
(0, 3, 'mobile_notif', 1, 'app_notifications'),
(0, 3, 'mobile_screen', 2, 'mobile'),
(0, 1, 'mobile_screen', 8, 'mobile'),
(0, 1, 'mobile_notif', 4, 'app_notifications'),
(0, 1, 'mobile_advert', 3, 'app_adverts'),
(0, 6, 'wordpress', 1, 'wordpress'),
(0, 2, 'wordpress', 1, 'wordpress'),
(0, 6, 'prefs_langcenter', 5, 'MULTILANGUAGE_FEATURE'),
(0, 2, 'import_log', 2, 'import'),
(0, 6, 'import_log', 1, 'import'),
(0, 6, 'export_downloadfiles', 1, 'export'),
(0, 7, 'export_downloadfiles', 1, 'export'),
(0, 2, 'export_downloadfiles', 1, 'export'),
(0, 2, 'package_manage', 4, 'package builder'),
(0, 7, 'package_reports', 1, 'package builder'),
(0, 6, 'package_manage', 6, 'package builder'),
(0, 6, 'package_add', 1, 'Package Builder'),
(0, 6, 'prefs_invoiceinformation', 1, 'INVOICEPAYMENT_FEATURE'),
(0, 2, 'prefs_invoiceinformation', 2, 'INVOICEPAYMENT_FEATURE'),
(0, 2, 'prefs_modules', 2, 'modules'),
(0, 2, 'prefs_managelevel', 4, 'prefslevels'),
(0, 6, 'prefs_managelevel', 9, 'prefslevels'),
(0, 2, 'prefs_designation', 4, 'editorchoice'),
(0, 2, 'prefs_googleanalytics', 2, 'GOOGLE_ANALYTICS_ENABLED'),
(0, 6, 'prefs_googleanalytics', 1, 'GOOGLE_ANALYTICS_ENABLED'),
(0, 6, 'prefs_googleads', 1, 'GOOGLE_ADS_ENABLED'),
(0, 2, 'prefs_googleads', 2, 'GOOGLE_ADS_ENABLED'),
(0, 2, 'prefs_googlemaps', 3, 'GOOGLE_MAPS_ENABLED'),
(0, 6, 'prefs_googlemaps', 1, 'GOOGLE_MAPS_ENABLED'),
(0, 7, 'prefs_api', 3, 'prefs_api'),
(0, 2, 'prefs_api', 1, 'prefs_api'),
(0, 3, 'prefs_twilio', 3, 'prefstwilio'),
(0, 6, 'prefs_twilio', 1, 'prefstwilio'),
(0, 7, 'prefs_twilio', 4, 'prefstwilio'),
(0, 2, 'prefs_twilio', 2, 'prefstwilio'),
(0, 6, 'prefs_commenting', 9, 'commenting'),
(0, 6, 'prefs_socialnetwork', 1, 'prefssn'),
(0, 7, 'prefs_socialnetwork', 3, 'prefssn'),
(0, 2, 'prefs_socialnetwork', 2, 'prefssn'),
(0, 6, 'prefs_locations', 2, 'prefslocation'),
(0, 2, 'prefs_locations', 3, 'prefslocation'),
(0, 2, 'prefs_aprovalrequirement', 2, 'settingsapproval'),
(0, 6, 'prefs_aprovalrequirement', 1, 'settingsapproval'),
(0, 2, 'prefs_twitter', 5, 'prefstwitter'),
(0, 2, 'prefs_featuredcategory', 2, 'prefscategory'),
(0, 6, 'prefs_twitter', 5, 'prefstwitter'),
(0, 6, 'prefs_share', 1, 'prefsshare'),
(0, 7, 'prefs_share', 3, 'prefsshare'),
(0, 7, 'prefs_signinoptions', 7, 'prefssign'),
(0, 6, 'prefs_signinoptions', 5, 'prefssign'),
(0, 7, 'transaction_history', 4, 'PAYMENT_FEATURE'),
(0, 6, 'transaction_history', 2, 'PAYMENT_FEATURE'),
(0, 2, 'invoice_history', 2, 'INVOICEPAYMENT_FEATURE'),
(0, 7, 'invoice_history', 2, 'INVOICEPAYMENT_FEATURE'),
(0, 6, 'invoice_history', 1, 'INVOICEPAYMENT_FEATURE'),
(0, 6, 'custominvoice_manage', 1, 'CUSTOM_INVOICE_FEATURE'),
(0, 7, 'custominvoice_manage', 2, 'CUSTOM_INVOICE_FEATURE'),
(0, 2, 'custominvoice_manage', 2, 'CUSTOM_INVOICE_FEATURE'),
(0, 6, 'listing_search', 45, 'listing'),
(0, 6, 'listingcateg_manage', 9, 'listing'),
(0, 6, 'promotion_manage', 2, 'PROMOTION_FEATURE'),
(0, 7, 'location4_manage', 9, 'location'),
(0, 7, 'location3_manage', 2, 'location'),
(0, 7, 'location4_add', 2, 'location'),
(1, 7, 'listingcateg_manage', 2, 'listing'),
(0, 7, 'seocenter_manage', 1, 'seocenter'),
(0, 7, 'listing_add', 1, 'listing'),
(0, 8, 'domain_manage', 22, 'domain'),
(0, 8, 'prefs_theme', 6, 'prefstheme'),
(1, 8, 'prefs_langcenter', 1, 'MULTILANGUAGE_FEATURE'),
(0, 8, 'listing_manage', 126, 'listing'),
(0, 8, 'blog_manage', 20, 'BLOG_FEATURE'),
(0, 8, 'location1_manage', 3, 'location'),
(0, 8, 'listing_add', 111, 'listing'),
(0, 8, 'post_add', 18, 'BLOG_FEATURE'),
(0, 8, 'listingcateg_manage', 4, 'listing'),
(0, 8, 'listingcateg_add', 8, 'listing'),
(0, 8, 'wordpress', 1, 'wordpress'),
(0, 8, 'prefs_langcenter', 3, 'MULTILANGUAGE_FEATURE'),
(0, 8, 'prefs_pricing', 2, 'pricing'),
(0, 8, 'prefs_managelevel', 6, 'prefslevels'),
(0, 8, 'prefs_modules', 5, 'modules'),
(0, 8, 'prefs_claim', 5, 'CLAIM_FEATURE'),
(0, 8, 'prefs_tax', 4, 'prefstax'),
(0, 8, 'package_manage', 2, 'package builder'),
(0, 8, 'listing_search', 6, 'listing'),
(0, 8, 'content_general', 28, 'content'),
(0, 8, 'content_header', 12, 'content'),
(0, 8, 'content_footer', 9, 'content'),
(0, 8, 'content_noimage', 6, 'content'),
(0, 8, 'content_icon', 5, 'content'),
(0, 8, 'prefs_paymentgateway', 5, 'PAYMENTSYSTEM_FEATURE'),
(0, 8, 'account_manage', 10, 'account'),
(0, 8, 'content_advertisement', 20, 'content'),
(0, 8, 'content_listing', 7, 'content'),
(0, 8, 'content_member', 6, 'content'),
(0, 8, 'content_custom', 3, 'content'),
(0, 8, 'content_blog', 4, 'BLOG_FEATURE'),
(0, 8, 'content_htmleditor', 2, 'content'),
(0, 8, 'content_navigation', 5, 'content'),
(0, 8, 'prefs_designation', 3, 'editorchoice'),
(0, 8, 'prefs_emailnotific', 6, 'emailnotif'),
(0, 8, 'prefs_invoiceinformation', 3, 'INVOICEPAYMENT_FEATURE'),
(0, 8, 'mailapp_manage', 3, 'mailapp'),
(0, 8, 'prefs_emailsendconf', 4, 'prefsemail'),
(0, 8, 'blogcateg_manage', 8, 'BLOG_FEATURE'),
(0, 2, 'blogcateg_add', 1, 'BLOG_FEATURE'),
(0, 8, 'blogcateg_add', 12, 'BLOG_FEATURE'),
(0, 7, 'banner_search', 8, 'BANNER_FEATURE'),
(0, 7, 'promotion_search', 1, 'PROMOTION_FEATURE'),
(0, 8, 'prefs_signinoptions', 3, 'prefssign'),
(0, 8, 'prefs_commenting', 2, 'commenting'),
(0, 8, 'mobile_screen', 2, 'mobile'),
(0, 8, 'import_log', 1, 'import'),
(0, 8, 'prefs_share', 1, 'prefsshare'),
(0, 8, 'prefs_twitter', 7, 'prefstwitter'),
(0, 8, 'prefs_featuredcategory', 1, 'prefscategory'),
(0, 8, 'prefs_aprovalrequirement', 1, 'settingsapproval'),
(0, 8, 'prefs_locations', 5, 'prefslocation'),
(0, 8, 'prefs_socialnetwork', 1, 'prefssn'),
(0, 8, 'prefs_twilio', 1, 'prefstwilio'),
(0, 8, 'prefs_api', 2, 'prefs_api'),
(0, 8, 'prefs_systememail', 2, 'prefsemail'),
(0, 8, 'prefs_googlemaps', 2, 'GOOGLE_MAPS_ENABLED'),
(0, 8, 'prefs_googleads', 1, 'GOOGLE_ADS_ENABLED'),
(0, 8, 'prefs_googleanalytics', 1, 'GOOGLE_ANALYTICS_ENABLED'),
(0, 8, 'transaction_history', 2, 'PAYMENT_FEATURE'),
(0, 8, 'invoice_history', 2, 'INVOICEPAYMENT_FEATURE'),
(0, 8, 'discountcode_manage', 1, 'PAYMENTSYSTEM_FEATURE'),
(0, 8, 'custominvoice_manage', 1, 'CUSTOM_INVOICE_FEATURE'),
(0, 2, 'prefs_faq', 1, 'faq'),
(0, 2, 'discountcode_manage', 1, 'PAYMENTSYSTEM_FEATURE'),
(0, 7, 'discountcode_manage', 1, 'PAYMENTSYSTEM_FEATURE'),
(1, 8, 'prefs_emailsendconf', 2, 'prefsemail'),
(1, 2, 'prefs_emailsendconf', 3, 'prefsemail'),
(1, 7, 'prefs_emailsendconf', 2, 'prefsemail'),
(1, 1, 'prefs_emailsendconf', 3, 'prefsemail'),
(1, 3, 'prefs_emailsendconf', 3, 'prefsemail'),
(1, 6, 'prefs_emailsendconf', 2, 'prefsemail'),
(1, 1, 'mobile_screen', 1, 'mobile'),
(1, 1, 'mobile_notif', 1, 'app_notifications'),
(1, 1, 'mobile_advert', 1, 'app_adverts'),
(1, 1, 'prefs_designation', 5, 'editorchoice'),
(1, 6, 'prefs_designation', 1, 'editorchoice'),
(1, 7, 'prefs_designation', 2, 'editorchoice'),
(0, 6, 'banner_search', 10, 'BANNER_FEATURE'),
(0, 6, 'banner_add', 3, 'BANNER_FEATURE'),
(0, 2, 'banner_add', 5, 'BANNER_FEATURE'),
(0, 8, 'seocenter_manage', 1, 'seocenter'),
(0, 6, 'account_search', 3, 'account'),
(0, 6, 'listing_add', 1, 'listing'),
(0, 6, 'listingcateg_add', 1, 'listing'),
(0, 6, 'listingcateg_disabled', 4, 'listing'),
(0, 6, 'account_add', 5, 'account'),
(1, 1, 'listing_manage', 18, 'listing'),
(1, 6, 'banner_manage', 1, 'BANNER_FEATURE'),
(1, 3, 'listing_manage', 8, 'listing'),
(1, 3, 'listing_search', 4, 'listing'),
(1, 1, 'banner_manage', 7, 'BANNER_FEATURE'),
(1, 1, 'prefs_googlemaps', 1, 'GOOGLE_MAPS_ENABLED'),
(1, 1, 'prefs_googleads', 1, 'GOOGLE_ADS_ENABLED'),
(1, 1, 'prefs_googleanalytics', 1, 'GOOGLE_ANALYTICS_ENABLED'),
(1, 1, 'prefs_promotion', 1, 'prefspromotion'),
(1, 6, 'prefs_promotion', 1, 'prefspromotion'),
(1, 1, 'prefs_modules', 2, 'modules'),
(1, 1, 'prefs_managelevel', 7, 'prefslevels'),
(1, 3, 'prefs_managelevel', 6, 'prefslevels'),
(1, 3, 'prefs_designation', 3, 'editorchoice'),
(1, 2, 'banner_manage', 1, 'BANNER_FEATURE'),
(0, 8, 'account_add', 1, 'account'),
(1, 6, 'prefs_locations', 1, 'prefslocation'),
(1, 6, 'location1_manage', 3, 'location'),
(0, 6, 'location1_manage', 2, 'location'),
(0, 6, 'location3_manage', 4, 'location'),
(1, 7, 'location1_manage', 6, 'location'),
(1, 7, 'location1_add', 1, 'location'),
(1, 7, 'location3_manage', 4, 'location'),
(1, 7, 'location4_manage', 1, 'location'),
(1, 1, 'location1_manage', 1, 'location'),
(1, 6, 'domain_manage', 2, 'domain'),
(1, 7, 'prefs_locations', 5, 'prefslocation'),
(1, 3, 'domain_manage', 5, 'domain'),
(1, 1, 'prefs_robotsfilter', 1, 'prefsrobots'),
(1, 7, 'domain_manage', 1, 'domain'),
(1, 2, 'domain_manage', 1, 'domain'),
(1, 8, 'domain_manage', 1, 'domain'),
(1, 1, 'mailapp_manage', 3, 'mailapp'),
(1, 3, 'mailapp_manage', 5, 'mailapp'),
(1, 6, 'mailapp_manage', 1, 'mailapp'),
(1, 3, 'package_manage', 12, 'package builder'),
(1, 6, 'package_manage', 3, 'package builder'),
(1, 7, 'package_manage', 3, 'package builder'),
(1, 2, 'package_manage', 3, 'package builder'),
(1, 8, 'package_manage', 3, 'package builder'),
(1, 1, 'package_add', 1, 'Package Builder'),
(1, 3, 'prefs_pricing', 1, 'pricing'),
(1, 8, 'package_add', 1, 'Package Builder'),
(1, 1, 'prefs_locations', 2, 'prefslocation'),
(1, 3, 'prefs_locations', 4, 'prefslocation'),
(0, 3, 'prefs_maintenancemode', 2, 'prefsmaintenance'),
(0, 8, 'location3_manage', 3, 'location'),
(0, 8, 'location4_manage', 16, 'location'),
(0, 8, 'banner_manage', 6, 'BANNER_FEATURE'),
(0, 8, 'banner_add', 17, 'BANNER_FEATURE'),
(1, 1, 'content_general', 2, 'content'),
(1, 1, 'content_header', 1, 'content'),
(1, 1, 'content_footer', 1, 'content'),
(1, 1, 'content_noimage', 1, 'content'),
(1, 1, 'content_icon', 1, 'content'),
(1, 1, 'listing_search', 1, 'listing'),
(1, 1, 'event_search', 1, 'EVENT_FEATURE'),
(1, 1, 'classified_search', 1, 'CLASSIFIED_FEATURE'),
(1, 1, 'article_search', 1, 'ARTICLE_FEATURE'),
(1, 1, 'banner_search', 1, 'BANNER_FEATURE'),
(1, 1, 'post_search', 4, 'BLOG_FEATURE'),
(1, 1, 'promotion_search', 1, 'PROMOTION_FEATURE'),
(1, 1, 'account_manage', 3, 'account'),
(1, 1, 'smaccount_manage', 2, 'smaaccount'),
(1, 1, 'prefs_emailnotific', 1, 'emailnotif'),
(1, 3, 'prefs_systememail', 1, 'prefsemail'),
(1, 3, 'prefs_emailnotific', 1, 'emailnotif'),
(1, 3, 'banner_search', 1, 'BANNER_FEATURE'),
(1, 3, 'event_search', 1, 'EVENT_FEATURE'),
(1, 3, 'classified_search', 1, 'CLASSIFIED_FEATURE'),
(1, 3, 'article_search', 1, 'ARTICLE_FEATURE'),
(1, 3, 'promotion_search', 1, 'PROMOTION_FEATURE'),
(1, 3, 'post_search', 4, 'BLOG_FEATURE'),
(1, 3, 'account_manage', 2, 'account'),
(1, 3, 'smaccount_manage', 1, 'smaaccount'),
(1, 3, 'prefs_promotion', 1, 'prefspromotion'),
(1, 3, 'prefs_modules', 1, 'modules'),
(1, 3, 'prefs_claim', 1, 'CLAIM_FEATURE'),
(1, 3, 'prefs_langcenter', 1, 'MULTILANGUAGE_FEATURE'),
(1, 3, 'prefs_tax', 1, 'prefstax'),
(1, 3, 'mobile_screen', 1, 'mobile'),
(1, 3, 'mobile_notif', 1, 'app_notifications'),
(1, 3, 'mobile_advert', 1, 'app_adverts'),
(1, 3, 'import_home', 1, 'import'),
(1, 3, 'import_log', 2, 'import'),
(1, 3, 'prefs_import', 1, 'import'),
(1, 3, 'export_data', 1, 'export'),
(1, 1, 'event_manage', 13, 'EVENT_FEATURE'),
(1, 1, 'classified_manage', 3, 'CLASSIFIED_FEATURE'),
(0, 32, 'domain_manage', 1, 'domain'),
(0, 1, 'mobile_advert_add', 2, 'app_adverts'),
(0, 47, 'prefs_langcenter', 7, 'MULTILANGUAGE_FEATURE'),
(0, 47, 'package_manage', 2, 'package builder'),
(0, 47, 'listingcateg_manage', 3, 'listing'),
(0, 47, 'listingcateg_add', 1, 'listing'),
(0, 47, 'listing_manage', 9, 'listing'),
(0, 47, 'content_general', 2, 'content'),
(0, 47, 'content_listing', 1, 'content'),
(0, 47, 'prefs_theme', 5, 'prefstheme'),
(0, 47, 'wordpress', 4, 'wordpress'),
(0, 47, 'prefs_twilio', 1, 'prefstwilio'),
(0, 47, 'prefs_claim', 1, 'CLAIM_FEATURE'),
(0, 47, 'domain_manage', 4, 'domain'),
(0, 47, 'banner_manage', 1, 'BANNER_FEATURE'),
(0, 1, 'mobile_notif_add', 1, 'app_notifications'),
(0, 47, 'mobile_notif_add', 1, 'app_notifications'),
(0, 47, 'sugar', 1, 'sugar'),
(0, 47, 'domain_add', 1, 'domain'),
(0, 47, 'classified_manage', 4, 'CLASSIFIED_FEATURE'),
(0, 47, 'article_manage', 1, 'ARTICLE_FEATURE'),
(0, 47, 'promotion_manage', 6, 'PROMOTION_FEATURE'),
(0, 47, 'content_promotion', 2, 'PROMOTION_FEATURE'),
(0, 47, 'seocenter_manage', 3, 'seocenter'),
(0, 47, 'mailapp_manage', 2, 'mailapp'),
(0, 47, 'promotion_add', 1, 'PROMOTION_FEATURE'),
(0, 47, 'classifiedcateg_manage', 4, 'CLASSIFIED_FEATURE'),
(0, 47, 'content_article', 1, 'ARTICLE_FEATURE'),
(0, 47, 'content_classified', 1, 'CLASSIFIED_FEATURE'),
(0, 1, 'promotion_search', 2, 'PROMOTION_FEATURE'),
(0, 47, 'import_home', 1, 'import');

CREATE TABLE Image (
  id int(11) NOT NULL AUTO_INCREMENT,
  `type` set('JPG','GIF','SWF','PNG') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'JPG',
  width smallint(6) NOT NULL DEFAULT '0',
  height smallint(6) NOT NULL DEFAULT '0',
  prefix varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1843 ;

INSERT INTO Image (id, type, width, height, prefix) VALUES
(1751, 'JPG', 200, 149, '1_'),
(1769, 'JPG', 187, 165, '2_'),
(1768, 'JPG', 145, 200, '3_'),
(1755, 'JPG', 200, 183, '4_'),
(1756, 'JPG', 189, 111, '8_'),
(1757, 'JPG', 200, 162, '9_'),
(1759, 'JPG', 200, 153, '13_'),
(1760, 'JPG', 200, 151, '19_'),
(1761, 'JPG', 200, 135, '20_'),
(1763, 'GIF', 110, 100, '22_'),
(1762, 'JPG', 200, 134, '218_'),
(1770, 'GIF', 100, 100, '22_'),
(1771, 'JPG', 167, 167, '8_'),
(1772, 'JPG', 200, 200, '218_'),
(1773, 'JPG', 200, 200, '19_'),
(1774, 'JPG', 200, 200, '20_'),
(1775, 'JPG', 200, 200, '13_'),
(1776, 'JPG', 200, 200, '1_'),
(1777, 'JPG', 200, 200, '4_'),
(1778, 'JPG', 200, 200, '9_'),
(1779, 'JPG', 200, 200, '2_'),
(1780, 'JPG', 200, 200, '3_'),
(1781, 'JPG', 200, 200, '12_'),
(1782, 'JPG', 200, 200, '18_'),
(1783, 'JPG', 200, 200, '263_'),
(1784, 'JPG', 200, 200, '13_'),
(1785, 'PNG', 199, 199, '2_'),
(1839, 'PNG', 200, 200, '19_'),
(1833, 'PNG', 200, 200, '20_'),
(1788, 'PNG', 200, 200, '14_'),
(1789, 'PNG', 200, 200, '15_'),
(1790, 'PNG', 91, 91, '16_'),
(1791, 'PNG', 200, 200, '17_'),
(1792, 'PNG', 200, 200, '8_'),
(1794, 'PNG', 200, 200, '6_'),
(1795, 'PNG', 200, 200, '10_'),
(1796, 'PNG', 200, 200, '257_'),
(1797, 'PNG', 200, 200, '267_'),
(1798, 'PNG', 200, 200, '265_'),
(1799, 'PNG', 200, 200, '286_'),
(1800, 'PNG', 200, 200, '275_'),
(1801, 'PNG', 200, 200, '268_'),
(1802, 'PNG', 200, 200, '255_'),
(1803, 'PNG', 200, 200, '278_'),
(1804, 'PNG', 200, 200, '259_'),
(1805, 'PNG', 200, 200, '282_'),
(1806, 'PNG', 200, 200, '256_'),
(1807, 'PNG', 200, 200, '253_'),
(1808, 'PNG', 200, 200, '277_'),
(1809, 'PNG', 200, 200, '262_'),
(1810, 'PNG', 200, 200, '271_'),
(1811, 'PNG', 200, 200, '270_'),
(1812, 'PNG', 200, 200, '260_'),
(1813, 'PNG', 200, 200, '285_'),
(1814, 'PNG', 200, 200, '274_'),
(1815, 'PNG', 200, 200, '273_'),
(1816, 'PNG', 155, 155, '276_'),
(1817, 'PNG', 200, 200, '258_'),
(1818, 'PNG', 200, 200, '283_'),
(1819, 'PNG', 200, 200, '269_'),
(1820, 'PNG', 190, 190, '266_'),
(1821, 'PNG', 200, 200, '254_'),
(1822, 'PNG', 200, 200, '284_'),
(1823, 'PNG', 199, 199, '272_'),
(1824, 'PNG', 199, 199, '280_'),
(1825, 'PNG', 200, 200, '252_'),
(1826, 'PNG', 200, 200, '281_'),
(1827, 'PNG', 200, 200, '261_'),
(1828, 'PNG', 200, 200, '279_'),
(1829, 'PNG', 200, 200, '264_'),
(1830, 'PNG', 199, 199, '1_'),
(1831, 'PNG', 200, 200, '9_'),
(1834, 'JPG', 200, 200, '292_'),
(1835, 'PNG', 200, 200, '295_'),
(1836, 'PNG', 200, 200, '296_'),
(1837, 'PNG', 200, 200, '298_'),
(1838, 'PNG', 200, 200, '301_'),
(1841, 'PNG', 200, 200, '19_');

CREATE TABLE LocationChangeLOG (
  id int(11) NOT NULL AUTO_INCREMENT,
  domain_id int(11) NOT NULL,
  location_id int(11) NOT NULL,
  location_level tinyint(4) NOT NULL,
  parent_old_id int(11) NOT NULL,
  parent_new_id int(11) NOT NULL,
  parent_level tinyint(4) NOT NULL,
  modules_updated char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=205 ;

INSERT INTO LocationChangeLOG (id, domain_id, location_id, location_level, parent_old_id, parent_new_id, parent_level, modules_updated) VALUES
(1, 1, 5, 1, 0, 0, 0, 'n'),
(2, 3, 5, 1, 0, 0, 0, 'n'),
(3, 2, 5, 1, 0, 0, 0, 'n'),
(4, 1, 14222, 4, 5, 5, 1, 'n'),
(5, 3, 14222, 4, 5, 5, 1, 'n'),
(6, 2, 14222, 4, 5, 5, 1, 'n'),
(7, 1, 14222, 4, 0, 0, 2, 'n'),
(8, 3, 14222, 4, 0, 0, 2, 'n'),
(9, 2, 14222, 4, 0, 0, 2, 'n'),
(10, 1, 14222, 4, 119, 119, 3, 'n'),
(11, 3, 14222, 4, 119, 119, 3, 'n'),
(12, 2, 14222, 4, 119, 119, 3, 'n'),
(13, 1, 119, 3, 5, 5, 1, 'n'),
(14, 3, 119, 3, 5, 5, 1, 'n'),
(15, 2, 119, 3, 5, 5, 1, 'n'),
(16, 1, 119, 3, 0, 0, 2, 'n'),
(17, 3, 119, 3, 0, 0, 2, 'n'),
(18, 2, 119, 3, 0, 0, 2, 'n'),
(19, 1, 13137, 4, 2, 2, 1, 'n'),
(20, 3, 13137, 4, 2, 2, 1, 'n'),
(21, 2, 13137, 4, 2, 2, 1, 'n'),
(22, 1, 13137, 4, 0, 0, 2, 'n'),
(23, 3, 13137, 4, 0, 0, 2, 'n'),
(24, 2, 13137, 4, 0, 0, 2, 'n'),
(25, 1, 13137, 4, 84, 84, 3, 'n'),
(26, 3, 13137, 4, 84, 84, 3, 'n'),
(27, 2, 13137, 4, 84, 84, 3, 'n'),
(28, 1, 62, 3, 2, 2, 1, 'n'),
(29, 3, 62, 3, 2, 2, 1, 'n'),
(30, 2, 62, 3, 2, 2, 1, 'n'),
(31, 1, 62, 3, 0, 0, 2, 'n'),
(32, 3, 62, 3, 0, 0, 2, 'n'),
(33, 2, 62, 3, 0, 0, 2, 'n'),
(34, 1, 64, 3, 2, 2, 1, 'n'),
(35, 3, 64, 3, 2, 2, 1, 'n'),
(36, 2, 64, 3, 2, 2, 1, 'n'),
(37, 1, 64, 3, 0, 0, 2, 'n'),
(38, 3, 64, 3, 0, 0, 2, 'n'),
(39, 2, 64, 3, 0, 0, 2, 'n'),
(40, 1, 63, 3, 2, 2, 1, 'n'),
(41, 3, 63, 3, 2, 2, 1, 'n'),
(42, 2, 63, 3, 2, 2, 1, 'n'),
(43, 1, 63, 3, 0, 0, 2, 'n'),
(44, 3, 63, 3, 0, 0, 2, 'n'),
(45, 2, 63, 3, 0, 0, 2, 'n'),
(46, 1, 65, 3, 2, 2, 1, 'n'),
(47, 3, 65, 3, 2, 2, 1, 'n'),
(48, 2, 65, 3, 2, 2, 1, 'n'),
(49, 1, 65, 3, 0, 0, 2, 'n'),
(50, 3, 65, 3, 0, 0, 2, 'n'),
(51, 2, 65, 3, 0, 0, 2, 'n'),
(52, 1, 68, 3, 2, 2, 1, 'n'),
(53, 3, 68, 3, 2, 2, 1, 'n'),
(54, 2, 68, 3, 2, 2, 1, 'n'),
(55, 1, 68, 3, 0, 0, 2, 'n'),
(56, 3, 68, 3, 0, 0, 2, 'n'),
(57, 2, 68, 3, 0, 0, 2, 'n'),
(58, 1, 70, 3, 2, 2, 1, 'n'),
(59, 3, 70, 3, 2, 2, 1, 'n'),
(60, 2, 70, 3, 2, 2, 1, 'n'),
(61, 1, 70, 3, 0, 0, 2, 'n'),
(62, 3, 70, 3, 0, 0, 2, 'n'),
(63, 2, 70, 3, 0, 0, 2, 'n'),
(64, 1, 67, 3, 2, 2, 1, 'n'),
(65, 3, 67, 3, 2, 2, 1, 'n'),
(66, 2, 67, 3, 2, 2, 1, 'n'),
(67, 1, 67, 3, 0, 0, 2, 'n'),
(68, 3, 67, 3, 0, 0, 2, 'n'),
(69, 2, 67, 3, 0, 0, 2, 'n'),
(70, 1, 69, 3, 2, 2, 1, 'n'),
(71, 3, 69, 3, 2, 2, 1, 'n'),
(72, 2, 69, 3, 2, 2, 1, 'n'),
(73, 1, 69, 3, 0, 0, 2, 'n'),
(74, 3, 69, 3, 0, 0, 2, 'n'),
(75, 2, 69, 3, 0, 0, 2, 'n'),
(76, 1, 123, 3, 2, 2, 1, 'n'),
(77, 3, 123, 3, 2, 2, 1, 'n'),
(78, 2, 123, 3, 2, 2, 1, 'n'),
(79, 1, 123, 3, 0, 0, 2, 'n'),
(80, 3, 123, 3, 0, 0, 2, 'n'),
(81, 2, 123, 3, 0, 0, 2, 'n'),
(82, 1, 71, 3, 2, 2, 1, 'n'),
(83, 3, 71, 3, 2, 2, 1, 'n'),
(84, 2, 71, 3, 2, 2, 1, 'n'),
(85, 1, 71, 3, 0, 0, 2, 'n'),
(86, 3, 71, 3, 0, 0, 2, 'n'),
(87, 2, 71, 3, 0, 0, 2, 'n'),
(88, 1, 72, 3, 2, 2, 1, 'n'),
(89, 3, 72, 3, 2, 2, 1, 'n'),
(90, 2, 72, 3, 2, 2, 1, 'n'),
(91, 1, 72, 3, 0, 0, 2, 'n'),
(92, 3, 72, 3, 0, 0, 2, 'n'),
(93, 2, 72, 3, 0, 0, 2, 'n'),
(94, 1, 73, 3, 2, 2, 1, 'n'),
(95, 3, 73, 3, 2, 2, 1, 'n'),
(96, 2, 73, 3, 2, 2, 1, 'n'),
(97, 1, 73, 3, 0, 0, 2, 'n'),
(98, 3, 73, 3, 0, 0, 2, 'n'),
(99, 2, 73, 3, 0, 0, 2, 'n'),
(100, 1, 74, 3, 2, 2, 1, 'n'),
(101, 3, 74, 3, 2, 2, 1, 'n'),
(102, 2, 74, 3, 2, 2, 1, 'n'),
(103, 1, 74, 3, 0, 0, 2, 'n'),
(104, 3, 74, 3, 0, 0, 2, 'n'),
(105, 2, 74, 3, 0, 0, 2, 'n'),
(106, 1, 75, 3, 2, 2, 1, 'n'),
(107, 3, 75, 3, 2, 2, 1, 'n'),
(108, 2, 75, 3, 2, 2, 1, 'n'),
(109, 1, 75, 3, 0, 0, 2, 'n'),
(110, 3, 75, 3, 0, 0, 2, 'n'),
(111, 2, 75, 3, 0, 0, 2, 'n'),
(112, 1, 76, 3, 2, 2, 1, 'n'),
(113, 3, 76, 3, 2, 2, 1, 'n'),
(114, 2, 76, 3, 2, 2, 1, 'n'),
(115, 1, 76, 3, 0, 0, 2, 'n'),
(116, 3, 76, 3, 0, 0, 2, 'n'),
(117, 2, 76, 3, 0, 0, 2, 'n'),
(118, 1, 79, 3, 2, 2, 1, 'n'),
(119, 3, 79, 3, 2, 2, 1, 'n'),
(120, 2, 79, 3, 2, 2, 1, 'n'),
(121, 1, 79, 3, 0, 0, 2, 'n'),
(122, 3, 79, 3, 0, 0, 2, 'n'),
(123, 2, 79, 3, 0, 0, 2, 'n'),
(124, 1, 77, 3, 2, 2, 1, 'n'),
(125, 3, 77, 3, 2, 2, 1, 'n'),
(126, 2, 77, 3, 2, 2, 1, 'n'),
(127, 1, 77, 3, 0, 0, 2, 'n'),
(128, 3, 77, 3, 0, 0, 2, 'n'),
(129, 2, 77, 3, 0, 0, 2, 'n'),
(130, 1, 80, 3, 2, 2, 1, 'n'),
(131, 3, 80, 3, 2, 2, 1, 'n'),
(132, 2, 80, 3, 2, 2, 1, 'n'),
(133, 1, 80, 3, 0, 0, 2, 'n'),
(134, 3, 80, 3, 0, 0, 2, 'n'),
(135, 2, 80, 3, 0, 0, 2, 'n'),
(136, 1, 81, 3, 2, 2, 1, 'n'),
(137, 3, 81, 3, 2, 2, 1, 'n'),
(138, 2, 81, 3, 2, 2, 1, 'n'),
(139, 1, 81, 3, 0, 0, 2, 'n'),
(140, 3, 81, 3, 0, 0, 2, 'n'),
(141, 2, 81, 3, 0, 0, 2, 'n'),
(142, 1, 78, 3, 2, 2, 1, 'n'),
(143, 3, 78, 3, 2, 2, 1, 'n'),
(144, 2, 78, 3, 2, 2, 1, 'n'),
(145, 1, 78, 3, 0, 0, 2, 'n'),
(146, 3, 78, 3, 0, 0, 2, 'n'),
(147, 2, 78, 3, 0, 0, 2, 'n'),
(148, 1, 83, 3, 2, 2, 1, 'n'),
(149, 3, 83, 3, 2, 2, 1, 'n'),
(150, 2, 83, 3, 2, 2, 1, 'n'),
(151, 1, 83, 3, 0, 0, 2, 'n'),
(152, 3, 83, 3, 0, 0, 2, 'n'),
(153, 2, 83, 3, 0, 0, 2, 'n'),
(154, 1, 82, 3, 2, 2, 1, 'n'),
(155, 3, 82, 3, 2, 2, 1, 'n'),
(156, 2, 82, 3, 2, 2, 1, 'n'),
(157, 1, 82, 3, 0, 0, 2, 'n'),
(158, 3, 82, 3, 0, 0, 2, 'n'),
(159, 2, 82, 3, 0, 0, 2, 'n'),
(160, 1, 84, 3, 2, 2, 1, 'n'),
(161, 3, 84, 3, 2, 2, 1, 'n'),
(162, 2, 84, 3, 2, 2, 1, 'n'),
(163, 1, 84, 3, 0, 0, 2, 'n'),
(164, 3, 84, 3, 0, 0, 2, 'n'),
(165, 2, 84, 3, 0, 0, 2, 'n'),
(166, 1, 85, 3, 2, 2, 1, 'n'),
(167, 3, 85, 3, 2, 2, 1, 'n'),
(168, 2, 85, 3, 2, 2, 1, 'n'),
(169, 1, 85, 3, 0, 0, 2, 'n'),
(170, 3, 85, 3, 0, 0, 2, 'n'),
(171, 2, 85, 3, 0, 0, 2, 'n'),
(172, 1, 86, 3, 2, 2, 1, 'n'),
(173, 3, 86, 3, 2, 2, 1, 'n'),
(174, 2, 86, 3, 2, 2, 1, 'n'),
(175, 1, 86, 3, 0, 0, 2, 'n'),
(176, 3, 86, 3, 0, 0, 2, 'n'),
(177, 2, 86, 3, 0, 0, 2, 'n'),
(178, 1, 87, 3, 2, 2, 1, 'n'),
(179, 3, 87, 3, 2, 2, 1, 'n'),
(180, 2, 87, 3, 2, 2, 1, 'n'),
(181, 1, 87, 3, 0, 0, 2, 'n'),
(182, 3, 87, 3, 0, 0, 2, 'n'),
(183, 2, 87, 3, 0, 0, 2, 'n'),
(184, 1, 78, 3, 2, 2, 1, 'n'),
(185, 3, 78, 3, 2, 2, 1, 'n'),
(186, 2, 78, 3, 2, 2, 1, 'n'),
(187, 1, 78, 3, 0, 0, 2, 'n'),
(188, 3, 78, 3, 0, 0, 2, 'n'),
(189, 2, 78, 3, 0, 0, 2, 'n'),
(190, 1, 13848, 4, 2, 2, 1, 'n'),
(191, 3, 13848, 4, 2, 2, 1, 'n'),
(192, 6, 13848, 4, 2, 2, 1, 'n'),
(193, 7, 13848, 4, 2, 2, 1, 'n'),
(194, 2, 13848, 4, 2, 2, 1, 'n'),
(195, 1, 13848, 4, 0, 0, 2, 'n'),
(196, 3, 13848, 4, 0, 0, 2, 'n'),
(197, 6, 13848, 4, 0, 0, 2, 'n'),
(198, 7, 13848, 4, 0, 0, 2, 'n'),
(199, 2, 13848, 4, 0, 0, 2, 'n'),
(200, 1, 13848, 4, 85, 85, 3, 'n'),
(201, 3, 13848, 4, 85, 85, 3, 'n'),
(202, 6, 13848, 4, 85, 85, 3, 'n'),
(203, 7, 13848, 4, 85, 85, 3, 'n'),
(204, 2, 13848, 4, 85, 85, 3, 'n');

CREATE TABLE LocationFulltextwhereList (
  item_table varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  item_id int(11) NOT NULL DEFAULT '0',
  domain_id int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY table_item_id_domain_id (item_id,domain_id,item_table)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO LocationFulltextwhereList (item_table, item_id, domain_id) VALUES
('Listing', 1, 1),
('Listing_Summary', 1, 1),
('Listing', 3, 1),
('Listing_Summary', 3, 1),
('Listing', 16, 1),
('Listing_Summary', 16, 1),
('Event', 128, 1),
('Event', 131, 1),
('Event', 134, 1),
('Event', 138, 1),
('Listing', 180, 1),
('Listing_Summary', 180, 1),
('Listing', 9681, 1),
('Listing_Summary', 9681, 1),
('Listing', 9739, 1),
('Listing_Summary', 9739, 1),
('Listing', 10939, 1),
('Listing_Summary', 10939, 1),
('Listing', 12206, 1),
('Listing_Summary', 12206, 1),
('Listing', 18341, 1),
('Listing_Summary', 18341, 1),
('Listing', 18805, 1),
('Listing_Summary', 18805, 1),
('Listing', 20873, 1),
('Listing_Summary', 20873, 1),
('Listing', 21352, 1),
('Listing_Summary', 21352, 1),
('Listing', 22969, 1),
('Listing_Summary', 22969, 1),
('Listing', 23428, 1),
('Listing_Summary', 23428, 1),
('Listing', 30894, 1),
('Listing_Summary', 30894, 1),
('Listing', 37544, 1),
('Listing_Summary', 37544, 1),
('Listing', 39697, 1),
('Listing_Summary', 39697, 1),
('Listing', 41191, 1),
('Listing_Summary', 41191, 1),
('Listing', 42558, 1),
('Listing_Summary', 42558, 1),
('Listing', 46111, 1),
('Listing_Summary', 46111, 1),
('Listing', 46667, 1),
('Listing_Summary', 46667, 1),
('Listing', 47080, 1),
('Listing_Summary', 47080, 1),
('Listing', 47670, 1),
('Listing_Summary', 47670, 1),
('Listing', 47706, 1),
('Listing_Summary', 47706, 1),
('Listing', 47755, 1),
('Listing_Summary', 47755, 1),
('Listing', 47756, 1),
('Listing_Summary', 47756, 1),
('Listing', 47858, 1),
('Listing_Summary', 47858, 1),
('Listing', 48327, 1),
('Listing_Summary', 48327, 1),
('Listing', 48521, 1),
('Listing_Summary', 48521, 1),
('Listing', 49875, 1),
('Listing_Summary', 49875, 1),
('Listing', 52946, 1),
('Listing_Summary', 52946, 1),
('Listing', 53090, 1),
('Listing_Summary', 53090, 1),
('Listing', 53097, 1),
('Listing_Summary', 53097, 1),
('Listing', 53528, 1),
('Listing_Summary', 53528, 1);

CREATE TABLE Location_1 (
  id int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  abbreviation varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  friendly_url varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_description varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_keywords varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (id),
  KEY friendly_url (friendly_url),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

INSERT INTO Location_1 (id, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(1, 'United States', 'USA', 'united-states', '', ''),
(2, 'Brasil', 'BR', 'brasil', '', ''),
(3, 'Spain', '', 'spain', '', ''),
(4, 'Germany', '', 'germany', '', ''),
(5, 'England', '', 'england', '', '');

CREATE TABLE Location_2 (
  id int(11) NOT NULL AUTO_INCREMENT,
  location_1 int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  abbreviation varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  friendly_url varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_description varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_keywords varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (id),
  KEY friendly_url (friendly_url),
  KEY country_id (location_1),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

INSERT INTO Location_2 (id, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(1, 1, 'Pacific', '', 'pacific', '', ''),
(2, 1, 'Mountain', '', 'mountain', '', ''),
(3, 1, 'West North Central', '', 'west-north-central', '', ''),
(4, 1, 'West South Central', '', 'west-south-central', '', ''),
(5, 1, 'East North Central', '', 'east-north-central', '', ''),
(6, 1, 'East South Central', '', 'east-south-central', '', ''),
(7, 1, 'Middle Atlantic', '', 'middle-atlantic', '', ''),
(8, 1, 'South Atlantic', '', 'south-atlantic', '', ''),
(9, 1, 'New England', '', 'new-england', '', ''),
(10, 1, 'Hawaii', '', 'hawaii', '', '');

CREATE TABLE Location_3 (
  id int(11) NOT NULL AUTO_INCREMENT,
  location_2 int(11) NOT NULL DEFAULT '0',
  location_1 int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  abbreviation varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  friendly_url varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_description varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_keywords varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (id),
  KEY friendly_url (friendly_url),
  KEY state_id (location_2),
  KEY `name` (`name`),
  KEY location_2_level (location_1,location_2)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=124 ;

INSERT INTO Location_3 (id, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(7, 7, 1, 'New Jersey', 'NJ', 'new-jersey', '', ''),
(10, 1, 1, 'California', 'CA', 'california', '', ''),
(9, 4, 1, 'Texas', 'TX', 'texas', '', ''),
(8, 7, 1, 'New York', 'NY', 'new-york', '', ''),
(11, 2, 1, 'Arizona', 'AZ', 'arizona', '', ''),
(12, 1, 1, 'Washington', 'WA', 'washington', '', ''),
(13, 9, 1, 'Massachusetts', 'MA', 'massachusetts', '', ''),
(14, 8, 1, 'Georgia', 'GA', 'georgia', '', ''),
(15, 8, 1, 'Maryland', 'MD', 'maryland', '', ''),
(16, 8, 1, 'Delaware', 'DE', 'delaware', '', ''),
(17, 3, 1, 'Minnesota', 'MN', 'minnesota', '', ''),
(18, 8, 1, 'District Of Columbia', 'DC', 'district-of-columbia', '', ''),
(19, 9, 1, 'New Hampshire', 'NH', 'new-hampshire', '', ''),
(20, 8, 1, 'Florida', 'FL', 'florida', '', ''),
(21, 8, 1, 'Virginia', 'VA', 'virginia', '', ''),
(22, 8, 1, 'North Carolina', 'NC', 'north-carolina', '', ''),
(23, 9, 1, 'Maine', 'ME', 'maine', '', ''),
(24, 2, 1, 'Utah', 'UT', 'utah', '', ''),
(25, 10, 1, 'Hawaii', 'HI', 'hawaii', '', ''),
(26, 1, 1, 'Oregon', 'OR', 'oregon', '', ''),
(27, 8, 1, 'South Carolina', 'SC', 'south-carolina', '', ''),
(28, 9, 1, 'Rhode Island', 'RI', 'rhode-island', '', ''),
(56, 2, 1, 'Idaho', 'ID', 'idaho', '', ''),
(30, 5, 1, 'Ohio', 'OH', 'ohio', '', ''),
(31, 7, 1, 'Pennsylvania', 'PA', 'pennsylvania', '', ''),
(32, 4, 1, 'Oklahoma', 'OK', 'oklahoma', '', ''),
(33, 8, 1, 'West Virginia', 'WV', 'west-virginia', '', ''),
(34, 1, 1, 'Alaska', 'AK', 'alaska', '', ''),
(35, 5, 1, 'Michigan', 'MI', 'michigan', '', ''),
(36, 5, 1, 'Wisconsin', 'WI', 'wisconsin', '', ''),
(37, 6, 1, 'Kentucky', 'KY', 'kentucky', '', ''),
(38, 9, 1, 'Vermont', 'VT', 'vermont', '', ''),
(39, 5, 1, 'Indiana', 'IN', 'indiana', '', ''),
(55, 3, 1, 'Kansas', 'KS', 'kansas', '', ''),
(41, 9, 1, 'Connecticut', 'CT', 'connecticut', '', ''),
(42, 5, 1, 'Illinois', 'IL', 'illinois', '', ''),
(43, 2, 1, 'Colorado', 'CO', 'colorado', '', ''),
(44, 4, 1, 'Louisiana', 'LA', 'louisiana', '', ''),
(45, 2, 1, 'New Mexico', 'NM', 'new-mexico', '', ''),
(47, 3, 1, 'Missouri', 'MO', 'missouri', '', ''),
(48, 6, 1, 'Alabama', 'AL', 'alabama', '', ''),
(49, 3, 1, 'South Dakota', 'SD', 'south-dakota', '', ''),
(50, 3, 1, 'Tennessee', 'TN', 'tennessee', '', ''),
(51, 2, 1, 'Nevada', 'NV', 'nevada', '', ''),
(52, 4, 1, 'Arkansas', 'AR', 'arkansas', '', ''),
(53, 2, 1, 'Montana', 'MT', 'montana', '', ''),
(57, 3, 1, 'Iowa', 'IA', 'iowa', '', ''),
(58, 3, 1, 'Nebraska', 'NE', 'nebraska', '', ''),
(59, 3, 1, 'North Dakota', 'ND', 'north-dakota', '', ''),
(60, 2, 1, 'Wyoming', 'WY', 'wyoming', '', ''),
(61, 6, 1, 'Mississippi', 'MS', 'mississippi', '', ''),
(62, 0, 2, 'Acre', 'AC', 'acre', '', ''),
(63, 0, 2, 'Alagoas', 'AL', 'alagoas', '', ''),
(64, 0, 2, 'Amapá', 'AP', 'amapa', '', ''),
(65, 0, 2, 'Amazonas', 'AM', 'amazonas', '', ''),
(66, 0, 2, 'Bahia', 'BA', 'bahia', '', ''),
(67, 0, 2, 'Ceará', 'CE', 'ceara', '', ''),
(68, 0, 2, 'Distrito Federal', 'DF', 'distrito-federal', '', ''),
(69, 0, 2, 'Espírito Santo', 'ES', 'espirito-santo', '', ''),
(70, 0, 2, 'Goiás', 'GO', 'goias', '', ''),
(71, 0, 2, 'Mato Grosso', 'MT', 'mato-grosso', '', ''),
(72, 0, 2, 'Mato Grosso do Sul', 'MS', 'mato-grosso-do-sul', '', ''),
(73, 0, 2, 'Minas Gerais', 'MG', 'minas-gerais', '', ''),
(74, 0, 2, 'Pará', 'PA', 'para', '', ''),
(75, 0, 2, 'Paraíba', 'PB', 'paraiba', '', ''),
(76, 0, 2, 'Paraná', 'PR', 'parana', '', ''),
(77, 0, 2, 'Pernambuco', 'PE', 'pernambuco', '', ''),
(78, 0, 2, 'Piauí', 'PI', 'piaui', '', ''),
(79, 0, 2, 'Rio de Janeiro', 'RJ', 'rio-de-janeiro', '', ''),
(80, 0, 2, 'Rio Grande do Norte', 'RN', 'rio-grande-do-norte', '', ''),
(81, 0, 2, 'Rio Grande do Sul', 'RS', 'rio-grande-do-sul', '', ''),
(82, 0, 2, 'Rondônia', 'RO', 'rondonia', '', ''),
(83, 0, 2, 'Roraima', 'RR', 'roraima', '', ''),
(84, 0, 2, 'Santa Catarina', 'SC', 'santa-catarina', '', ''),
(85, 0, 2, 'São Paulo', 'SP', 'sao-paulo', '', ''),
(86, 0, 2, 'Sergipe', 'SE', 'sergipe', '', ''),
(87, 0, 2, 'Tocantins', 'TO', 'tocantins', '', ''),
(88, 0, 4, 'Baviera', '', 'baviera', '', ''),
(89, 0, 3, 'Madrid', '', 'madrid', '', ''),
(90, 0, 4, 'Baden-Württemberg', '', 'baden-wrttemberg', '', ''),
(91, 0, 3, 'La Rioja', '', 'la-rioja', '', ''),
(92, 0, 3, 'Guipúzcoa', '', 'guipzcoa', '', ''),
(93, 0, 4, 'Renânia', '', 'rennia', '', ''),
(94, 0, 4, 'Rheinland-Pfalz', '', 'rheinland-pfalz', '', ''),
(95, 0, 3, 'Barcelona', '', 'barcelona', '', ''),
(96, 0, 3, 'Salamanca', '', 'salamanca', '', ''),
(97, 0, 4, 'Bayern', '', 'bayern', '', ''),
(98, 0, 4, 'Saxônia', '', 'saxnia', '', ''),
(99, 0, 4, 'Mecklemburgo-Pomerânia Ocidental', '', 'mecklemburgo-pomernia-ocidental', '', ''),
(100, 0, 3, 'Navarra', '', 'navarra', '', ''),
(101, 0, 3, 'Cantábria', '', 'cantbria', '', ''),
(102, 0, 3, 'Cádiz', '', 'cdiz', '', ''),
(103, 0, 3, 'Asturias', '', 'asturias', '', ''),
(104, 0, 4, 'Hessen', '', 'hessen', '', ''),
(105, 0, 3, 'Tarragona', '', 'tarragona', '', ''),
(106, 0, 4, 'Schleswig-Holstein', '', 'schleswig-holstein', '', ''),
(107, 0, 3, 'Almería', '', 'almera', '', ''),
(108, 0, 3, 'Valencia', '', 'valencia', '', ''),
(109, 0, 3, 'Santa María del Águila', '', 'santa-mara-del-guila', '', ''),
(110, 0, 3, 'Ourense', '', 'ourense', '', ''),
(111, 0, 3, 'Andaluzia', '', 'andaluzia', '', ''),
(112, 0, 4, 'Baixa Saxônia', '', 'baixa-saxnia', '', ''),
(113, 0, 4, 'Turíngia', '', 'turngia', '', ''),
(114, 0, 3, 'Málaga', '', 'mlaga', '', ''),
(115, 0, 3, 'Teruel', '', 'teruel', '', ''),
(116, 0, 3, 'Girona', '', 'girona', '', ''),
(117, 0, 4, 'Berlim', '', 'berlim', '', ''),
(118, 0, 3, 'Burgos', '', 'burgos', '', ''),
(119, 0, 5, 'Greater London', '', 'greater-london', '', ''),
(120, 0, 3, 'Cáceres', '', 'cceres', '', ''),
(121, 0, 3, 'Saragoça', '', 'saragoa', '', ''),
(122, 0, 3, 'Córdoba', '', 'crdoba', '', ''),
(123, 0, 2, 'Maranhão', '', 'maranhao', '', '');

CREATE TABLE Location_4 (
  id int(11) NOT NULL AUTO_INCREMENT,
  location_3 int(11) NOT NULL DEFAULT '0',
  location_2 int(11) NOT NULL DEFAULT '0',
  location_1 int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  abbreviation varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  friendly_url varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_description varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  seo_keywords varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (id),
  KEY region_id (location_3),
  KEY friendly_url (friendly_url),
  KEY `name` (`name`),
  KEY location_3_level (location_1,location_2,location_3)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=14255 ;

INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(22, 7, 7, 1, 'Hackensack', '', 'hackensack', '', ''),
(21, 8, 7, 1, 'New York', '', 'new-york', '', ''),
(28, 10, 1, 1, 'Rancho Cucamonga', '', 'rancho-cucamonga', '', ''),
(27, 13, 9, 1, 'Boston', '', 'boston', '', ''),
(26, 12, 1, 1, 'Redmond', '', 'redmond', '', ''),
(25, 11, 2, 1, 'Phoenix', '', 'phoenix', '', ''),
(24, 10, 1, 1, 'Pacific Palisades', '', 'pacific-palisades', '', ''),
(23, 9, 4, 1, 'Dallas', '', 'dallas', '', ''),
(20, 7, 7, 1, 'Woodbridge', '', 'woodbridge', '', ''),
(29, 12, 1, 1, 'Seattle', '', 'seattle', '', ''),
(30, 14, 8, 1, 'Atlanta', '', 'atlanta', '', ''),
(31, 8, 7, 1, 'Brooklyn', '', 'brooklyn', '', ''),
(32, 15, 8, 1, 'Bowie', '', 'bowie', '', ''),
(33, 10, 1, 1, 'Temecula', '', 'temecula', '', ''),
(34, 16, 8, 1, 'Wilmington', '', 'wilmington', '', ''),
(35, 17, 3, 1, 'Minneapolis', '', 'minneapolis', '', ''),
(36, 18, 0, 1, 'Washington', '', 'washington', '', ''),
(37, 19, 9, 1, 'Salem', '', 'salem', '', ''),
(38, 13, 9, 1, 'North Andover', '', 'north-andover', '', ''),
(39, 13, 9, 1, 'Pembroke', '', 'pembroke', '', ''),
(40, 10, 1, 1, 'Moorpark', '', 'moorpark', '', ''),
(41, 10, 1, 1, 'Agoura Hills', '', 'agoura-hills', '', ''),
(42, 7, 7, 1, 'Bridgewater', '', 'bridgewater', '', ''),
(43, 20, 8, 1, 'Saint Petersburg', '', 'saint-petersburg', '', ''),
(44, 10, 1, 1, 'Beverly Hills', '', 'beverly-hills', '', ''),
(45, 21, 8, 1, 'Mclean', '', 'mclean', '', ''),
(46, 10, 1, 1, 'Long Beach', '', 'long-beach', '', ''),
(47, 10, 1, 1, 'Los Angeles', '', 'los-angeles', '', ''),
(48, 9, 4, 1, 'Highland Village', '', 'highland-village', '', ''),
(49, 20, 8, 1, 'Valrico', '', 'valrico', '', ''),
(50, 10, 1, 1, 'Seal Beach', '', 'seal-beach', '', ''),
(51, 15, 8, 1, 'Cockeysville', '', 'cockeysville', '', ''),
(52, 20, 8, 1, 'Tampa', '', 'tampa', '', ''),
(53, 22, 8, 1, 'Garner', '', 'garner', '', ''),
(54, 15, 8, 1, 'Capitol Heights', '', 'capitol-heights', '', ''),
(55, 7, 7, 1, 'Cresskill', '', 'cresskill', '', ''),
(56, 10, 1, 1, 'Ventura', '', 'ventura', '', ''),
(57, 9, 4, 1, 'Irving', '', 'irving', '', ''),
(58, 8, 7, 1, 'Bronx', '', 'bronx', '', ''),
(59, 10, 1, 1, 'San Diego', '', 'san-diego', '', ''),
(60, 9, 4, 1, 'Cedar Hill', '', 'cedar-hill', '', ''),
(61, 13, 9, 1, 'Acton', '', 'acton', '', ''),
(62, 23, 9, 1, 'Topsham', '', 'topsham', '', ''),
(63, 13, 9, 1, 'Swansea', '', 'swansea', '', ''),
(64, 24, 2, 1, 'Layton', '', 'layton', '', ''),
(65, 10, 1, 1, 'Oxnard', '', 'oxnard', '', ''),
(66, 9, 4, 1, 'Carrollton', '', 'carrollton', '', ''),
(67, 7, 7, 1, 'Point Pleasant Beach', '', 'point-pleasant-beach', '', ''),
(68, 25, 10, 1, 'Lihue', '', 'lihue', '', ''),
(69, 26, 1, 1, 'Portland', '', 'portland', '', ''),
(70, 13, 9, 1, 'Chelmsford', '', 'chelmsford', '', ''),
(71, 13, 9, 1, 'Walpole', '', 'walpole', '', ''),
(72, 15, 8, 1, 'Timonium', '', 'timonium', '', ''),
(73, 13, 9, 1, 'Waltham', '', 'waltham', '', ''),
(74, 9, 4, 1, 'Sherman', '', 'sherman', '', ''),
(75, 12, 1, 1, 'Wenatchee', '', 'wenatchee', '', ''),
(76, 19, 9, 1, 'Plaistow', '', 'plaistow', '', ''),
(77, 27, 8, 1, 'N Myrtle Bch', '', 'n-myrtle-bch', '', ''),
(78, 15, 0, 1, 'Baltimore', '', 'baltimore', '', ''),
(79, 28, 9, 1, 'Narragansett', '', 'narragansett', '', ''),
(80, 13, 9, 1, 'West Roxbury', '', 'west-roxbury', '', ''),
(81, 21, 8, 1, 'Alexandria', '', 'alexandria', '', ''),
(82, 30, 5, 1, 'Norwalk', '', 'norwalk', '', ''),
(83, 23, 9, 1, 'Skowhegan', '', 'skowhegan', '', ''),
(84, 21, 0, 1, 'Norfolk', '', 'norfolk', '', ''),
(85, 15, 8, 1, 'District Heights', '', 'district-heights', '', ''),
(86, 31, 7, 1, 'Murrysville', '', 'murrysville', '', ''),
(87, 10, 1, 1, 'Santa Barbara', '', 'santa-barbara', '', ''),
(88, 8, 7, 1, 'Islip', '', 'islip', '', ''),
(89, 20, 8, 1, 'Sarasota', '', 'sarasota', '', ''),
(90, 10, 1, 1, 'Upland', '', 'upland', '', ''),
(91, 7, 7, 1, 'Trenton', '', 'trenton', '', ''),
(92, 8, 7, 1, 'Whitestone', '', 'whitestone', '', ''),
(93, 9, 4, 1, 'Flower Mound', '', 'flower-mound', '', ''),
(94, 7, 7, 1, 'Princeton', '', 'princeton', '', ''),
(95, 7, 7, 1, 'Hightstown', '', 'hightstown', '', ''),
(96, 15, 8, 1, 'Upper Marlboro', '', 'upper-marlboro', '', ''),
(97, 10, 1, 1, 'Goleta', '', 'goleta', '', ''),
(98, 19, 9, 1, 'Milford', '', 'milford', '', ''),
(99, 13, 9, 1, 'Wellesley', '', 'wellesley', '', ''),
(100, 30, 5, 1, 'Oberlin', '', 'oberlin', '', ''),
(101, 13, 9, 1, 'Braintree', '', 'braintree', '', ''),
(102, 10, 1, 1, 'Granada Hills', '', 'granada-hills', '', ''),
(103, 15, 8, 1, 'Silver Spring', '', 'silver-spring', '', ''),
(104, 23, 9, 1, 'Auburn', '', 'auburn', '', ''),
(105, 10, 1, 1, 'Newbury Park', '', 'newbury-park', '', ''),
(106, 21, 8, 1, 'Chesapeake', '', 'chesapeake', '', ''),
(107, 21, 8, 1, 'Richmond', '', 'richmond', '', ''),
(108, 17, 3, 1, 'Saint Paul', '', 'saint-paul', '', ''),
(109, 20, 8, 1, 'Largo', '', 'largo', '', ''),
(110, 31, 7, 1, 'West Chester', '', 'west-chester', '', ''),
(111, 15, 8, 1, 'Frederick', '', 'frederick', '', ''),
(112, 15, 8, 1, 'Hagerstown', '', 'hagerstown', '', ''),
(113, 10, 1, 1, 'Dana Point', '', 'dana-point', '', ''),
(114, 9, 4, 1, 'Grapevine', '', 'grapevine', '', ''),
(115, 21, 8, 1, 'Newport News', '', 'newport-news', '', ''),
(116, 12, 1, 1, 'Everett', '', 'everett', '', ''),
(117, 7, 7, 1, 'Point Pleasant', '', 'point-pleasant', '', ''),
(118, 23, 9, 1, 'Old Orchard Beach', '', 'old-orchard-beach', '', ''),
(119, 10, 1, 1, 'Capistrano Beach', '', 'capistrano-beach', '', ''),
(120, 21, 8, 1, 'Springfield', '', 'springfield', '', ''),
(121, 20, 0, 1, 'Miami', '', 'miami', '', ''),
(122, 8, 7, 1, 'Pearl River', '', 'pearl-river', '', ''),
(123, 26, 1, 1, 'Aloha', '', 'aloha', '', ''),
(124, 12, 1, 1, 'Sammamish', '', 'sammamish', '', ''),
(125, 10, 1, 1, 'Huntington Beach', '', 'huntington-beach', '', ''),
(126, 10, 1, 1, 'Encinitas', '', 'encinitas', '', ''),
(127, 11, 2, 1, 'Tucson', '', 'tucson', '', ''),
(128, 10, 1, 1, 'San Jose', '', 'san-jose', '', ''),
(129, 13, 9, 1, 'Falmouth', '', 'falmouth', '', ''),
(130, 10, 1, 1, 'Summerland', '', 'summerland', '', ''),
(131, 10, 1, 1, 'Monrovia', '', 'monrovia', '', ''),
(132, 13, 9, 1, 'Worcester', '', 'worcester', '', ''),
(133, 8, 7, 1, 'Manhattan', '', 'manhattan', '', ''),
(134, 9, 4, 1, 'Arlington', '', 'arlington', '', ''),
(135, 7, 7, 1, 'Clementon', '', 'clementon', '', ''),
(136, 8, 7, 1, 'Williamsville', '', 'williamsville', '', ''),
(137, 13, 9, 1, 'Quincy', '', 'quincy', '', ''),
(138, 21, 8, 1, 'Hampton', '', 'hampton', '', ''),
(139, 15, 8, 1, 'Temple Hills', '', 'temple-hills', '', ''),
(140, 13, 9, 1, 'Malden', '', 'malden', '', ''),
(141, 20, 8, 1, 'Bradenton', '', 'bradenton', '', ''),
(142, 25, 10, 1, 'Kailua', '', 'kailua', '', ''),
(143, 9, 4, 1, 'Duncanville', '', 'duncanville', '', ''),
(144, 9, 4, 1, 'Garland', '', 'garland', '', ''),
(145, 24, 2, 1, 'Sandy', '', 'sandy', '', ''),
(146, 32, 4, 1, 'Broken Arrow', '', 'broken-arrow', '', ''),
(147, 10, 1, 1, 'Lake Elsinore', '', 'lake-elsinore', '', ''),
(148, 10, 1, 1, 'Victorville', '', 'victorville', '', ''),
(149, 10, 1, 1, 'Garden Grove', '', 'garden-grove', '', ''),
(150, 10, 1, 1, 'Lakewood', '', 'lakewood', '', ''),
(151, 27, 8, 1, 'North Myrtle Beach', '', 'north-myrtle-beach', '', ''),
(152, 19, 9, 1, 'Nashua', '', 'nashua', '', ''),
(153, 15, 8, 1, 'Aberdeen', '', 'aberdeen', '', ''),
(154, 14, 8, 1, 'Duluth', '', 'duluth', '', ''),
(155, 10, 1, 1, 'San Luis Obispo', '', 'san-luis-obispo', '', ''),
(156, 31, 7, 1, 'Chambersburg', '', 'chambersburg', '', ''),
(157, 10, 1, 1, 'Redlands', '', 'redlands', '', ''),
(158, 33, 8, 1, 'Charleston', '', 'charleston', '', ''),
(159, 10, 1, 1, 'San Bernardino', '', 'san-bernardino', '', ''),
(160, 9, 4, 1, 'San Antonio', '', 'san-antonio', '', ''),
(161, 31, 7, 1, 'Camp Hill', '', 'camp-hill', '', ''),
(162, 15, 8, 1, 'Seat Pleasant', '', 'seat-pleasant', '', ''),
(163, 8, 7, 1, 'Delmar', '', 'delmar', '', ''),
(164, 13, 9, 1, 'Newton Center', '', 'newton-center', '', ''),
(165, 31, 7, 1, 'Blue Bell', '', 'blue-bell', '', ''),
(166, 21, 8, 1, 'Virginia Beach', '', 'virginia-beach', '', ''),
(167, 15, 8, 1, 'Takoma Park', '', 'takoma-park', '', ''),
(168, 19, 9, 1, 'Concord', '', 'concord', '', ''),
(169, 10, 1, 1, 'Los Alamitos', '', 'los-alamitos', '', ''),
(170, 14, 8, 1, 'Kennesaw', '', 'kennesaw', '', ''),
(171, 21, 8, 1, 'Fairfax', '', 'fairfax', '', ''),
(172, 13, 9, 1, 'Framingham', '', 'framingham', '', ''),
(173, 20, 8, 1, 'Safety Harbor', '', 'safety-harbor', '', ''),
(174, 10, 1, 1, 'Bishop', '', 'bishop', '', ''),
(175, 13, 9, 1, 'Taunton', '', 'taunton', '', ''),
(176, 34, 1, 1, 'Palmer', '', 'palmer', '', ''),
(177, 20, 8, 1, 'Venice', '', 'venice', '', ''),
(178, 10, 1, 1, 'Torrance', '', 'torrance', '', ''),
(179, 35, 5, 1, 'Muskegon', '', 'muskegon', '', ''),
(180, 13, 9, 1, 'Marlborough', '', 'marlborough', '', ''),
(181, 31, 7, 1, 'Glen Mills', '', 'glen-mills', '', ''),
(182, 8, 7, 1, 'Jefferson Valley', '', 'jefferson-valley', '', ''),
(183, 13, 9, 1, 'Feeding Hills', '', 'feeding-hills', '', ''),
(184, 22, 8, 1, 'Durham', '', 'durham', '', ''),
(185, 9, 4, 1, 'Plano', '', 'plano', '', ''),
(186, 7, 7, 1, 'Franklin Park', '', 'franklin-park', '', ''),
(187, 8, 7, 1, 'Greenvale', '', 'greenvale', '', ''),
(188, 10, 1, 1, 'Redondo Beach', '', 'redondo-beach', '', ''),
(189, 8, 7, 1, 'East Greenbush', '', 'east-greenbush', '', ''),
(190, 13, 9, 1, 'Franklin', '', 'franklin', '', ''),
(191, 15, 8, 1, 'Rockville', '', 'rockville', '', ''),
(192, 20, 8, 1, 'Brandon', '', 'brandon', '', ''),
(193, 8, 7, 1, 'Cheektowaga', '', 'cheektowaga', '', ''),
(194, 12, 1, 1, 'Kirkland', '', 'kirkland', '', ''),
(195, 10, 1, 1, 'Palm Desert', '', 'palm-desert', '', ''),
(196, 10, 1, 1, 'La Quinta', '', 'la-quinta', '', ''),
(197, 12, 1, 1, 'Richland', '', 'richland', '', ''),
(198, 28, 9, 1, 'Newport', '', 'newport', '', ''),
(199, 12, 1, 1, 'Lynnwood', '', 'lynnwood', '', ''),
(200, 15, 8, 1, 'Clinton', '', 'clinton', '', ''),
(201, 10, 1, 1, 'Barstow', '', 'barstow', '', ''),
(202, 31, 7, 1, 'Philadelphia', '', 'philadelphia', '', ''),
(203, 10, 1, 1, 'Santa Monica', '', 'santa-monica', '', ''),
(204, 15, 8, 1, 'Fort Washington', '', 'fort-washington', '', ''),
(205, 13, 9, 1, 'Newton', '', 'newton', '', ''),
(206, 17, 3, 1, 'Shoreview', '', 'shoreview', '', ''),
(207, 21, 8, 1, 'Lynchburg', '', 'lynchburg', '', ''),
(208, 17, 3, 1, 'Edina', '', 'edina', '', ''),
(209, 10, 1, 1, 'Woodland Hills', '', 'woodland-hills', '', ''),
(210, 20, 8, 1, 'Winter Park', '', 'winter-park', '', ''),
(211, 31, 7, 1, 'Upper Darby', '', 'upper-darby', '', ''),
(212, 10, 1, 1, 'Manhattan Beach', '', 'manhattan-beach', '', ''),
(213, 10, 1, 1, 'Claremont', '', 'claremont', '', ''),
(214, 31, 7, 1, 'Nottingham', '', 'nottingham', '', ''),
(215, 33, 8, 1, 'Morgantown', '', 'morgantown', '', ''),
(216, 19, 9, 1, 'Somersworth', '', 'somersworth', '', ''),
(217, 7, 7, 1, 'Teaneck', '', 'teaneck', '', ''),
(218, 13, 9, 1, 'Lowell', '', 'lowell', '', ''),
(219, 21, 8, 1, 'Winchester', '', 'winchester', '', ''),
(220, 10, 1, 1, 'Lake Forest', '', 'lake-forest', '', ''),
(221, 13, 9, 1, 'Leominster', '', 'leominster', '', ''),
(222, 10, 1, 1, 'Morgan Hill', '', 'morgan-hill', '', ''),
(223, 21, 8, 1, 'Falls Church', '', 'falls-church', '', ''),
(224, 36, 5, 1, 'Marshfield', '', 'marshfield', '', ''),
(225, 20, 8, 1, 'Jupiter', '', 'jupiter', '', ''),
(226, 14, 8, 1, 'Decatur', '', 'decatur', '', ''),
(227, 15, 8, 1, 'Westminster', '', 'westminster', '', ''),
(228, 31, 7, 1, 'Newtown', '', 'newtown', '', ''),
(229, 21, 8, 1, 'Williamsburg', '', 'williamsburg', '', ''),
(230, 15, 8, 1, 'Chestertown', '', 'chestertown', '', ''),
(231, 7, 7, 1, 'Brigantine', '', 'brigantine', '', ''),
(232, 30, 5, 1, 'Wadsworth', '', 'wadsworth', '', ''),
(233, 25, 10, 1, 'Waipahu', '', 'waipahu', '', ''),
(234, 10, 1, 1, 'Fullerton', '', 'fullerton', '', ''),
(235, 8, 7, 1, 'Hilton', '', 'hilton', '', ''),
(236, 10, 1, 1, 'Riverside', '', 'riverside', '', ''),
(237, 20, 8, 1, 'Dunedin', '', 'dunedin', '', ''),
(238, 10, 1, 1, 'La Habra', '', 'la-habra', '', ''),
(239, 15, 8, 1, 'New Carrolltn', '', 'new-carrolltn', '', ''),
(240, 7, 7, 1, 'Milltown', '', 'milltown', '', ''),
(241, 20, 8, 1, 'Lakeland', '', 'lakeland', '', ''),
(242, 10, 1, 1, 'Rialto', '', 'rialto', '', ''),
(243, 10, 1, 1, 'Pasadena', '', 'pasadena', '', ''),
(244, 7, 7, 1, 'Saddle Brook', '', 'saddle-brook', '', ''),
(245, 7, 7, 1, 'Morristown', '', 'morristown', '', ''),
(246, 31, 7, 1, 'Coraopolis', '', 'coraopolis', '', ''),
(247, 26, 1, 1, 'Mcminnville', '', 'mcminnville', '', ''),
(248, 8, 7, 1, 'Williston Park', '', 'williston-park', '', ''),
(249, 10, 1, 1, 'Alta Loma', '', 'alta-loma', '', ''),
(250, 37, 6, 1, 'Lexington', '', 'lexington', '', ''),
(251, 31, 7, 1, 'Harrisburg', '', 'harrisburg', '', ''),
(252, 23, 9, 1, 'North Vassalboro', '', 'north-vassalboro', '', ''),
(253, 10, 1, 1, 'Downey', '', 'downey', '', ''),
(254, 31, 7, 1, 'Wynnewood', '', 'wynnewood', '', ''),
(255, 7, 7, 1, 'Clifton', '', 'clifton', '', ''),
(256, 21, 8, 1, 'Harrisonburg', '', 'harrisonburg', '', ''),
(257, 22, 8, 1, 'Raleigh', '', 'raleigh', '', ''),
(258, 31, 7, 1, 'Pocono Summit', '', 'pocono-summit', '', ''),
(259, 13, 9, 1, 'Stoughton', '', 'stoughton', '', ''),
(260, 7, 7, 1, 'Brick', '', 'brick', '', ''),
(261, 31, 7, 1, 'Lafayette Hill', '', 'lafayette-hill', '', ''),
(262, 15, 8, 1, 'Lutherville Timonium', '', 'lutherville-timonium', '', ''),
(263, 31, 7, 1, 'Uniontown', '', 'uniontown', '', ''),
(264, 13, 9, 1, 'Newton Centre', '', 'newton-centre', '', ''),
(265, 7, 7, 1, 'Northfield', '', 'northfield', '', ''),
(266, 25, 10, 1, 'Honolulu', '', 'honolulu', '', ''),
(267, 33, 8, 1, 'Ripley', '', 'ripley', '', ''),
(268, 31, 7, 1, 'Allentown', '', 'allentown', '', ''),
(269, 15, 8, 1, 'Hyattsville', '', 'hyattsville', '', ''),
(270, 25, 10, 1, 'Aiea', '', 'aiea', '', ''),
(271, 7, 7, 1, 'Fort Lee', '', 'fort-lee', '', ''),
(272, 8, 7, 1, 'Buffalo', '', 'buffalo', '', ''),
(273, 10, 1, 1, 'Gilroy', '', 'gilroy', '', ''),
(274, 13, 9, 1, 'Fall River', '', 'fall-river', '', ''),
(275, 31, 7, 1, 'Jenkintown', '', 'jenkintown', '', ''),
(276, 38, 9, 1, 'Burlington', '', 'burlington', '', ''),
(277, 20, 8, 1, 'Kenneth City', '', 'kenneth-city', '', ''),
(278, 15, 8, 1, 'Laurel', '', 'laurel', '', ''),
(279, 7, 7, 1, 'Hamilton Square', '', 'hamilton-square', '', ''),
(280, 10, 1, 1, 'Cypress', '', 'cypress', '', ''),
(281, 8, 7, 1, 'De Witt', '', 'de-witt', '', ''),
(282, 10, 1, 1, 'Camarillo', '', 'camarillo', '', ''),
(283, 25, 10, 1, 'Wailea', '', 'wailea', '', ''),
(284, 31, 7, 1, 'Bensalem', '', 'bensalem', '', ''),
(285, 7, 7, 1, 'Spring Lake', '', 'spring-lake', '', ''),
(286, 39, 5, 1, 'Valparaiso', '', 'valparaiso', '', ''),
(287, 8, 7, 1, 'Saratoga Springs', '', 'saratoga-springs', '', ''),
(288, 31, 7, 1, 'State College', '', 'state-college', '', ''),
(289, 19, 9, 1, 'Keene', '', 'keene', '', ''),
(290, 24, 2, 1, 'Salt Lake City', '', 'salt-lake-city', '', ''),
(291, 15, 8, 1, 'Columbia', '', 'columbia', '', ''),
(292, 35, 5, 1, 'Mount Pleasant', '', 'mount-pleasant', '', ''),
(293, 13, 9, 1, 'Methuen', '', 'methuen', '', ''),
(294, 8, 7, 1, 'Garden City', '', 'garden-city', '', ''),
(295, 31, 7, 1, 'Silverdale', '', 'silverdale', '', ''),
(296, 8, 7, 1, 'Seaford', '', 'seaford', '', ''),
(297, 31, 7, 1, 'Halifax', '', 'halifax', '', ''),
(298, 7, 7, 1, 'Haddonfield', '', 'haddonfield', '', ''),
(299, 7, 7, 1, 'Madison', '', 'madison', '', ''),
(300, 31, 7, 1, 'York', '', 'york', '', ''),
(301, 31, 7, 1, 'Wilkes Barre', '', 'wilkes-barre', '', ''),
(302, 10, 1, 1, 'Irvine', '', 'irvine', '', ''),
(303, 7, 7, 1, 'Sea Isle City', '', 'sea-isle-city', '', ''),
(304, 10, 1, 1, 'West Covina', '', 'west-covina', '', ''),
(305, 10, 1, 1, 'Palm Springs', '', 'palm-springs', '', ''),
(306, 10, 1, 1, 'Whittier', '', 'whittier', '', ''),
(307, 8, 7, 1, 'Haverstraw', '', 'haverstraw', '', ''),
(308, 38, 9, 1, 'South Burlington', '', 'south-burlington', '', ''),
(309, 15, 8, 1, 'Suitland', '', 'suitland', '', ''),
(310, 10, 1, 1, 'Canyon Lake', '', 'canyon-lake', '', ''),
(311, 10, 1, 1, 'La Mesa', '', 'la-mesa', '', ''),
(312, 7, 7, 1, 'Fair Haven', '', 'fair-haven', '', ''),
(313, 10, 1, 1, 'Thousand Oaks', '', 'thousand-oaks', '', ''),
(314, 8, 7, 1, 'Syracuse', '', 'syracuse', '', ''),
(315, 31, 7, 1, 'New Hope', '', 'new-hope', '', ''),
(316, 10, 1, 1, 'Solvang', '', 'solvang', '', ''),
(317, 31, 7, 1, 'Bellefonte', '', 'bellefonte', '', ''),
(318, 28, 9, 1, 'Middletown', '', 'middletown', '', ''),
(319, 12, 1, 1, 'Bellevue', '', 'bellevue', '', ''),
(320, 10, 1, 1, 'Westlake Village', '', 'westlake-village', '', ''),
(321, 8, 7, 1, 'Albany', '', 'albany', '', ''),
(322, 7, 7, 1, 'Gloucester City', '', 'gloucester-city', '', ''),
(323, 15, 8, 1, 'Havre De Grace', '', 'havre-de-grace', '', ''),
(324, 25, 10, 1, 'Kapaa', '', 'kapaa', '', ''),
(325, 7, 7, 1, 'Florham Park', '', 'florham-park', '', ''),
(326, 12, 1, 1, 'Mount Vernon', '', 'mount-vernon', '', ''),
(327, 21, 8, 1, 'Danville', '', 'danville', '', ''),
(328, 11, 2, 1, 'Chandler', '', 'chandler', '', ''),
(329, 7, 7, 1, 'Englewood', '', 'englewood', '', ''),
(330, 31, 7, 1, 'Perkasie', '', 'perkasie', '', ''),
(331, 31, 7, 1, 'Johnstown', '', 'johnstown', '', ''),
(332, 16, 8, 1, 'Newark', '', 'newark', '', ''),
(333, 31, 7, 1, 'Lemoyne', '', 'lemoyne', '', ''),
(334, 19, 9, 1, 'Portsmouth', '', 'portsmouth', '', ''),
(335, 10, 1, 1, 'Grover Beach', '', 'grover-beach', '', ''),
(336, 8, 7, 1, 'East Amherst', '', 'east-amherst', '', ''),
(337, 21, 8, 1, 'Dale City', '', 'dale-city', '', ''),
(338, 13, 9, 1, 'Manomet', '', 'manomet', '', ''),
(339, 7, 7, 1, 'Tinton Falls', '', 'tinton-falls', '', ''),
(340, 10, 1, 1, 'Ontario', '', 'ontario', '', ''),
(341, 31, 7, 1, 'Hazleton', '', 'hazleton', '', ''),
(342, 39, 5, 1, 'Kokomo', '', 'kokomo', '', ''),
(343, 7, 7, 1, 'Tenafly', '', 'tenafly', '', ''),
(344, 7, 7, 1, 'Westwood', '', 'westwood', '', ''),
(345, 7, 7, 1, 'Chatham', '', 'chatham', '', ''),
(346, 28, 9, 1, 'Cranston', '', 'cranston', '', ''),
(347, 31, 7, 1, 'Wayne', '', 'wayne', '', ''),
(348, 31, 7, 1, 'Hershey', '', 'hershey', '', ''),
(349, 20, 8, 1, 'New Port Richey', '', 'new-port-richey', '', ''),
(350, 13, 9, 1, 'East Bridgewater', '', 'east-bridgewater', '', ''),
(351, 31, 7, 1, 'Emmaus', '', 'emmaus', '', ''),
(352, 17, 3, 1, 'Bloomington', '', 'bloomington', '', ''),
(353, 7, 7, 1, 'Green Brook', '', 'green-brook', '', ''),
(354, 31, 7, 1, 'Lansdale', '', 'lansdale', '', ''),
(355, 31, 7, 1, 'Pottstown', '', 'pottstown', '', ''),
(356, 25, 10, 1, 'Lahaina', '', 'lahaina', '', ''),
(357, 31, 7, 1, 'Plymouth Meeting', '', 'plymouth-meeting', '', ''),
(358, 10, 1, 1, 'Lancaster', '', 'lancaster', '', ''),
(359, 21, 8, 1, 'Fairfax Station', '', 'fairfax-station', '', ''),
(360, 10, 1, 1, 'Culver City', '', 'culver-city', '', ''),
(361, 33, 8, 1, 'Huntington', '', 'huntington', '', ''),
(362, 10, 1, 1, 'Port Hueneme', '', 'port-hueneme', '', ''),
(363, 20, 8, 1, 'Clearwater', '', 'clearwater', '', ''),
(364, 13, 9, 1, 'Brookline', '', 'brookline', '', ''),
(365, 26, 1, 1, 'Hillsboro', '', 'hillsboro', '', ''),
(366, 10, 1, 1, 'Novato', '', 'novato', '', ''),
(367, 31, 7, 1, 'Horsham', '', 'horsham', '', ''),
(368, 8, 7, 1, 'Baldwinsville', '', 'baldwinsville', '', ''),
(369, 7, 7, 1, 'Mount Laurel', '', 'mount-laurel', '', ''),
(370, 31, 7, 1, 'West Pittston', '', 'west-pittston', '', ''),
(371, 20, 8, 1, 'University Park', '', 'university-park', '', ''),
(372, 39, 5, 1, 'Terre Haute', '', 'terre-haute', '', ''),
(373, 8, 7, 1, 'Ithaca', '', 'ithaca', '', ''),
(374, 12, 1, 1, 'Marysville', '', 'marysville', '', ''),
(375, 31, 7, 1, 'Malvern', '', 'malvern', '', ''),
(376, 7, 7, 1, 'Oradell', '', 'oradell', '', ''),
(377, 31, 7, 1, 'Bethlehem', '', 'bethlehem', '', ''),
(378, 31, 7, 1, 'Swarthmore', '', 'swarthmore', '', ''),
(379, 10, 1, 1, 'Laguna Niguel', '', 'laguna-niguel', '', ''),
(380, 42, 5, 1, 'Rantoul', '', 'rantoul', '', ''),
(381, 13, 9, 1, 'Abington', '', 'abington', '', ''),
(382, 24, 2, 1, 'West Jordan', '', 'west-jordan', '', ''),
(383, 9, 4, 1, 'San Angelo', '', 'san-angelo', '', ''),
(384, 10, 1, 1, 'Santa Maria', '', 'santa-maria', '', ''),
(385, 12, 1, 1, 'Snohomish', '', 'snohomish', '', ''),
(386, 15, 8, 1, 'Pikesville', '', 'pikesville', '', ''),
(387, 10, 1, 1, 'Pico Rivera', '', 'pico-rivera', '', ''),
(388, 20, 8, 1, 'Land O Lakes', '', 'land-o-lakes', '', ''),
(389, 21, 8, 1, 'Petersburg', '', 'petersburg', '', ''),
(390, 13, 9, 1, 'Norwell', '', 'norwell', '', ''),
(391, 7, 7, 1, 'Manalapan', '', 'manalapan', '', ''),
(392, 31, 7, 1, 'Richboro', '', 'richboro', '', ''),
(393, 23, 9, 1, 'Biddeford', '', 'biddeford', '', ''),
(394, 7, 7, 1, 'East Orange', '', 'east-orange', '', ''),
(395, 9, 4, 1, 'Greenville', '', 'greenville', '', ''),
(396, 31, 7, 1, 'Exeter', '', 'exeter', '', ''),
(397, 31, 7, 1, 'North Wales', '', 'north-wales', '', ''),
(398, 8, 7, 1, 'Rye', '', 'rye', '', ''),
(399, 15, 8, 1, 'Waldorf', '', 'waldorf', '', ''),
(400, 31, 7, 1, 'West Reading', '', 'west-reading', '', ''),
(401, 10, 1, 1, 'Hawthorne', '', 'hawthorne', '', ''),
(402, 21, 8, 1, 'Centreville', '', 'centreville', '', ''),
(403, 30, 5, 1, 'Medina', '', 'medina', '', ''),
(404, 17, 3, 1, 'Circle Pines', '', 'circle-pines', '', ''),
(405, 10, 1, 1, 'Oceanside', '', 'oceanside', '', ''),
(406, 30, 5, 1, 'Marion', '', 'marion', '', ''),
(407, 13, 9, 1, 'Holden', '', 'holden', '', ''),
(408, 8, 7, 1, 'Vestal', '', 'vestal', '', ''),
(409, 15, 8, 1, 'Easton', '', 'easton', '', ''),
(410, 21, 8, 1, 'Stafford', '', 'stafford', '', ''),
(411, 8, 7, 1, 'Yonkers', '', 'yonkers', '', ''),
(412, 10, 1, 1, 'Montclair', '', 'montclair', '', ''),
(413, 21, 8, 1, 'Vienna', '', 'vienna', '', ''),
(414, 21, 8, 1, 'Roanoke', '', 'roanoke', '', ''),
(415, 13, 9, 1, 'Haverhill', '', 'haverhill', '', ''),
(416, 19, 9, 1, 'Amherst', '', 'amherst', '', ''),
(417, 11, 2, 1, 'Surprise', '', 'surprise', '', ''),
(418, 39, 5, 1, 'Angola', '', 'angola', '', ''),
(419, 7, 7, 1, 'Jersey City', '', 'jersey-city', '', ''),
(420, 10, 1, 1, 'Sherman Oaks', '', 'sherman-oaks', '', ''),
(421, 42, 5, 1, 'West Frankfort', '', 'west-frankfort', '', ''),
(422, 21, 8, 1, 'Colonial Heights', '', 'colonial-heights', '', ''),
(423, 21, 8, 1, 'Midlothian', '', 'midlothian', '', ''),
(424, 31, 7, 1, 'Media', '', 'media', '', ''),
(425, 13, 9, 1, 'Sandwich', '', 'sandwich', '', ''),
(426, 9, 4, 1, 'College Station', '', 'college-station', '', ''),
(427, 26, 1, 1, 'Gresham', '', 'gresham', '', ''),
(428, 8, 7, 1, 'Laurelton', '', 'laurelton', '', ''),
(429, 9, 4, 1, 'Pilot Point', '', 'pilot-point', '', ''),
(430, 28, 9, 1, 'Cumberland', '', 'cumberland', '', ''),
(431, 31, 7, 1, 'Bristol', '', 'bristol', '', ''),
(432, 7, 7, 1, 'Lawnside', '', 'lawnside', '', ''),
(433, 42, 5, 1, 'Paxton', '', 'paxton', '', ''),
(434, 13, 9, 1, 'Weymouth', '', 'weymouth', '', ''),
(435, 8, 7, 1, 'Queensbury', '', 'queensbury', '', ''),
(436, 16, 8, 1, 'Rehoboth Beach', '', 'rehoboth-beach', '', ''),
(437, 9, 4, 1, 'Denton', '', 'denton', '', ''),
(438, 39, 5, 1, 'Fort Wayne', '', 'fort-wayne', '', ''),
(439, 30, 5, 1, 'Cincinnati', '', 'cincinnati', '', ''),
(440, 10, 1, 1, 'La Verne', '', 'la-verne', '', ''),
(441, 43, 2, 1, 'Aurora', '', 'aurora', '', ''),
(442, 10, 1, 1, 'Bellflower', '', 'bellflower', '', ''),
(443, 12, 1, 1, 'Tacoma', '', 'tacoma', '', ''),
(444, 7, 7, 1, 'Ocean City', '', 'ocean-city', '', ''),
(445, 20, 8, 1, 'Ellenton', '', 'ellenton', '', ''),
(446, 20, 8, 1, 'Jacksonville', '', 'jacksonville', '', ''),
(447, 19, 9, 1, 'Hooksett', '', 'hooksett', '', ''),
(448, 10, 1, 1, 'Hacienda Heights', '', 'hacienda-heights', '', ''),
(449, 44, 4, 1, 'Shreveport', '', 'shreveport', '', ''),
(450, 7, 7, 1, 'Glen Rock', '', 'glen-rock', '', ''),
(451, 9, 4, 1, 'Highlands', '', 'highlands', '', ''),
(452, 7, 7, 1, 'Hillsborough', '', 'hillsborough', '', ''),
(453, 15, 8, 1, 'Severna Park', '', 'severna-park', '', ''),
(454, 45, 2, 1, 'Albuquerque', '', 'albuquerque', '', ''),
(455, 10, 1, 1, 'Covina', '', 'covina', '', ''),
(456, 31, 7, 1, 'Mechanicsburg', '', 'mechanicsburg', '', ''),
(457, 31, 0, 1, 'Pittsburgh', '', 'pittsburgh', '', ''),
(813, 8, 7, 1, 'Edgewood', '', 'edgewood', '', ''),
(459, 31, 7, 1, 'Doylestown', '', 'doylestown', '', ''),
(460, 7, 7, 1, 'Pitman', '', 'pitman', '', ''),
(461, 31, 7, 1, 'Jim Thorpe', '', 'jim-thorpe', '', ''),
(462, 20, 8, 1, 'Winter Haven', '', 'winter-haven', '', ''),
(463, 23, 9, 1, 'Kennebunkport', '', 'kennebunkport', '', ''),
(464, 20, 8, 1, 'Orlando', '', 'orlando', '', ''),
(465, 19, 9, 1, 'Manchester', '', 'manchester', '', ''),
(466, 7, 7, 1, 'Pennington', '', 'pennington', '', ''),
(467, 14, 8, 1, 'Columbus', '', 'columbus', '', ''),
(468, 13, 9, 1, 'Andover', '', 'andover', '', ''),
(469, 10, 1, 1, 'Watsonville', '', 'watsonville', '', ''),
(470, 7, 7, 1, 'Westfield', '', 'westfield', '', ''),
(471, 13, 9, 1, 'Milton', '', 'milton', '', ''),
(472, 23, 9, 1, 'Waterville', '', 'waterville', '', ''),
(473, 8, 7, 1, 'Endicott', '', 'endicott', '', ''),
(474, 20, 8, 1, 'Zephyrhills', '', 'zephyrhills', '', ''),
(475, 42, 5, 1, 'Round Lake', '', 'round-lake', '', ''),
(476, 31, 7, 1, 'Exton', '', 'exton', '', ''),
(477, 35, 5, 1, 'Prescott', '', 'prescott', '', ''),
(478, 26, 1, 1, 'Beaverton', '', 'beaverton', '', ''),
(479, 31, 7, 1, 'Tobyhanna', '', 'tobyhanna', '', ''),
(480, 47, 3, 1, 'Saint Louis', '', 'saint-louis', '', ''),
(481, 31, 7, 1, 'Sinking Spring', '', 'sinking-spring', '', ''),
(482, 32, 4, 1, 'Bartlesville', '', 'bartlesville', '', ''),
(483, 13, 9, 1, 'New Bedford', '', 'new-bedford', '', ''),
(484, 27, 8, 1, 'N Charleston', '', 'n-charleston', '', ''),
(485, 20, 8, 1, 'El Portal', '', 'el-portal', '', ''),
(486, 7, 7, 1, 'Robbinsville', '', 'robbinsville', '', ''),
(487, 16, 8, 1, 'Bethany Beach', '', 'bethany-beach', '', ''),
(488, 10, 1, 1, 'Palo Alto', '', 'palo-alto', '', ''),
(489, 14, 8, 1, 'Stone Mountain', '', 'stone-mountain', '', ''),
(490, 13, 9, 1, 'Woburn', '', 'woburn', '', ''),
(491, 7, 7, 1, 'Cherry Hill', '', 'cherry-hill', '', ''),
(492, 13, 9, 1, 'Swampscott', '', 'swampscott', '', ''),
(493, 21, 8, 1, 'Vinton', '', 'vinton', '', ''),
(494, 42, 5, 1, 'Palos Heights', '', 'palos-heights', '', ''),
(495, 7, 7, 1, 'Elizabeth', '', 'elizabeth', '', ''),
(496, 33, 8, 1, 'Lewisburg', '', 'lewisburg', '', ''),
(497, 31, 7, 1, 'Cresco', '', 'cresco', '', ''),
(498, 15, 8, 1, 'Gwynn Oak', '', 'gwynn-oak', '', ''),
(499, 8, 7, 1, 'Highland', '', 'highland', '', ''),
(500, 7, 7, 1, 'Bayonne', '', 'bayonne', '', ''),
(501, 36, 5, 1, 'La Crosse', '', 'la-crosse', '', ''),
(502, 45, 2, 1, 'Roswell', '', 'roswell', '', ''),
(503, 23, 9, 1, 'Brunswick', '', 'brunswick', '', ''),
(504, 14, 8, 1, 'Valdosta', '', 'valdosta', '', ''),
(505, 43, 2, 1, 'Colorado Springs', '', 'colorado-springs', '', ''),
(506, 23, 9, 1, 'Augusta', '', 'augusta', '', ''),
(507, 35, 5, 1, 'Howell', '', 'howell', '', ''),
(508, 8, 7, 1, 'Mount Sinai', '', 'mount-sinai', '', ''),
(509, 20, 8, 1, 'West Palm Beach', '', 'west-palm-beach', '', ''),
(510, 30, 5, 1, 'Cleveland', '', 'cleveland', '', ''),
(511, 13, 9, 1, 'West Boylston', '', 'west-boylston', '', ''),
(512, 7, 7, 1, 'Freehold', '', 'freehold', '', ''),
(513, 39, 5, 1, 'Lafayette', '', 'lafayette', '', ''),
(514, 42, 5, 1, 'New Lenox', '', 'new-lenox', '', ''),
(515, 10, 1, 1, 'Los Altos', '', 'los-altos', '', ''),
(516, 31, 7, 1, 'Scranton', '', 'scranton', '', ''),
(517, 42, 5, 1, 'Chicago', '', 'chicago', '', ''),
(518, 31, 7, 1, 'Lebanon', '', 'lebanon', '', ''),
(519, 14, 8, 1, 'Marietta', '', 'marietta', '', ''),
(520, 31, 7, 1, 'West Mifflin', '', 'west-mifflin', '', ''),
(521, 13, 9, 1, 'Natick', '', 'natick', '', ''),
(522, 7, 7, 1, 'River Edge', '', 'river-edge', '', ''),
(523, 47, 3, 1, 'Winfield', '', 'winfield', '', ''),
(524, 8, 7, 1, 'Lake Placid', '', 'lake-placid', '', ''),
(525, 19, 9, 1, 'North Conway', '', 'north-conway', '', ''),
(526, 13, 9, 1, 'Brockton', '', 'brockton', '', ''),
(527, 10, 1, 1, 'Apple Valley', '', 'apple-valley', '', ''),
(528, 8, 7, 1, 'Plattsburgh', '', 'plattsburgh', '', ''),
(529, 7, 7, 1, 'Red Bank', '', 'red-bank', '', ''),
(530, 7, 7, 1, 'Hoboken', '', 'hoboken', '', ''),
(531, 13, 9, 1, 'Newton Highlands', '', 'newton-highlands', '', ''),
(532, 33, 8, 1, 'Elkins', '', 'elkins', '', ''),
(533, 27, 8, 1, 'Conway', '', 'conway', '', ''),
(534, 8, 7, 1, 'Poughkeepsie', '', 'poughkeepsie', '', ''),
(535, 41, 9, 1, 'New Haven', '', 'new-haven', '', ''),
(536, 30, 5, 1, 'Steubenville', '', 'steubenville', '', ''),
(537, 31, 7, 1, 'Norristown', '', 'norristown', '', ''),
(538, 14, 8, 1, 'Lawrenceville', '', 'lawrenceville', '', ''),
(539, 10, 1, 1, 'Oakland', '', 'oakland', '', ''),
(540, 31, 7, 1, 'New Cumberland', '', 'new-cumberland', '', ''),
(541, 8, 7, 1, 'South Richmond Hill', '', 'south-richmond-hill', '', ''),
(542, 8, 7, 1, 'Lynbrook', '', 'lynbrook', '', ''),
(543, 21, 8, 1, 'King George', '', 'king-george', '', ''),
(544, 8, 7, 1, 'Valley Stream', '', 'valley-stream', '', ''),
(545, 42, 5, 1, 'Des Plaines', '', 'des-plaines', '', ''),
(546, 30, 5, 1, 'Boardman', '', 'boardman', '', ''),
(547, 10, 1, 1, 'Corona', '', 'corona', '', ''),
(548, 8, 7, 1, 'Harrison', '', 'harrison', '', ''),
(549, 39, 5, 1, 'Bedford', '', 'bedford', '', ''),
(550, 8, 7, 1, 'Crown Point', '', 'crown-point', '', ''),
(551, 10, 1, 1, 'Carlsbad', '', 'carlsbad', '', ''),
(552, 10, 1, 1, 'Diamond Bar', '', 'diamond-bar', '', ''),
(553, 13, 9, 1, 'Hanover', '', 'hanover', '', ''),
(554, 20, 8, 1, 'Riverview', '', 'riverview', '', ''),
(555, 43, 2, 1, 'Boulder', '', 'boulder', '', ''),
(556, 10, 1, 1, 'Vallejo', '', 'vallejo', '', ''),
(557, 9, 4, 1, 'Frisco', '', 'frisco', '', ''),
(558, 7, 7, 1, 'East Brunswick', '', 'east-brunswick', '', ''),
(559, 10, 1, 1, 'Gustine', '', 'gustine', '', ''),
(560, 31, 7, 1, 'Schwenksville', '', 'schwenksville', '', ''),
(561, 13, 9, 1, 'Peabody', '', 'peabody', '', ''),
(562, 11, 2, 1, 'Tempe', '', 'tempe', '', ''),
(563, 8, 7, 1, 'Clifton Park', '', 'clifton-park', '', ''),
(564, 15, 8, 1, 'Burtonsville', '', 'burtonsville', '', ''),
(565, 21, 8, 1, 'Suffolk', '', 'suffolk', '', ''),
(566, 8, 7, 1, 'Nanuet', '', 'nanuet', '', ''),
(567, 15, 8, 1, 'Middle River', '', 'middle-river', '', ''),
(568, 21, 8, 1, 'Grafton', '', 'grafton', '', ''),
(569, 33, 8, 1, 'Parkersburg', '', 'parkersburg', '', ''),
(570, 19, 9, 1, 'Kingston', '', 'kingston', '', ''),
(571, 10, 1, 1, 'Caliente', '', 'caliente', '', ''),
(572, 19, 9, 1, 'New London', '', 'new-london', '', ''),
(573, 10, 1, 1, 'Newport Beach', '', 'newport-beach', '', ''),
(574, 31, 7, 1, 'Sewickley', '', 'sewickley', '', ''),
(575, 26, 1, 1, 'Florence', '', 'florence', '', ''),
(576, 7, 7, 1, 'Spotswood', '', 'spotswood', '', ''),
(577, 14, 8, 1, 'Danielsville', '', 'danielsville', '', ''),
(578, 9, 4, 1, 'Houston', '', 'houston', '', ''),
(579, 14, 8, 1, 'Douglasville', '', 'douglasville', '', ''),
(580, 43, 2, 1, 'Littleton', '', 'littleton', '', ''),
(581, 10, 1, 1, 'Saratoga', '', 'saratoga', '', ''),
(582, 20, 8, 1, 'Fort Myers', '', 'fort-myers', '', ''),
(583, 41, 9, 1, 'Hartford', '', 'hartford', '', ''),
(584, 10, 1, 1, 'Santa Rosa', '', 'santa-rosa', '', ''),
(585, 30, 5, 1, 'Woodsfield', '', 'woodsfield', '', ''),
(586, 21, 8, 1, 'Staunton', '', 'staunton', '', ''),
(587, 31, 7, 1, 'Monroeville', '', 'monroeville', '', ''),
(588, 15, 8, 1, 'Annapolis', '', 'annapolis', '', ''),
(589, 47, 3, 1, 'Kansas City', '', 'kansas-city', '', ''),
(590, 20, 8, 1, 'Palm Harbor', '', 'palm-harbor', '', ''),
(591, 19, 9, 1, 'Merrimack', '', 'merrimack', '', ''),
(592, 31, 7, 1, 'Reading', '', 'reading', '', ''),
(593, 27, 8, 1, 'Chapin', '', 'chapin', '', ''),
(594, 39, 5, 1, 'Indianapolis', '', 'indianapolis', '', ''),
(595, 21, 8, 1, 'Lovingston', '', 'lovingston', '', ''),
(596, 22, 8, 1, 'Kinston', '', 'kinston', '', ''),
(597, 32, 4, 1, 'Lindsay', '', 'lindsay', '', ''),
(598, 42, 5, 1, 'Frankfort', '', 'frankfort', '', ''),
(599, 7, 7, 1, 'Brielle', '', 'brielle', '', ''),
(600, 43, 2, 1, 'Pueblo', '', 'pueblo', '', ''),
(601, 10, 1, 1, 'San Mateo', '', 'san-mateo', '', ''),
(602, 20, 8, 1, 'Coral Springs', '', 'coral-springs', '', ''),
(603, 9, 4, 1, 'McCallen', '', 'mccallen', '', ''),
(604, 42, 5, 1, 'Crystal Lake', '', 'crystal-lake', '', ''),
(605, 9, 4, 1, 'Keller', '', 'keller', '', ''),
(606, 31, 7, 1, 'Stroudsburg', '', 'stroudsburg', '', ''),
(607, 31, 7, 1, 'New Kensington', '', 'new-kensington', '', ''),
(608, 45, 2, 1, 'Las Cruces', '', 'las-cruces', '', ''),
(609, 33, 8, 1, 'Beckley', '', 'beckley', '', ''),
(610, 8, 7, 1, 'Hicksville', '', 'hicksville', '', ''),
(611, 31, 7, 1, 'Glenolden', '', 'glenolden', '', ''),
(612, 26, 1, 1, 'La Pine', '', 'la-pine', '', ''),
(613, 13, 9, 1, 'South Boston', '', 'south-boston', '', ''),
(614, 13, 9, 1, 'Cambridge', '', 'cambridge', '', ''),
(615, 10, 1, 1, 'Fremont', '', 'fremont', '', ''),
(616, 13, 9, 1, 'Lynn', '', 'lynn', '', ''),
(617, 13, 9, 1, 'Newburyport', '', 'newburyport', '', ''),
(618, 22, 8, 1, 'Winston Salem', '', 'winston-salem', '', ''),
(619, 11, 2, 1, 'Bullhead City', '', 'bullhead-city', '', ''),
(620, 13, 9, 1, 'Westborough', '', 'westborough', '', ''),
(621, 31, 7, 1, 'Erie', '', 'erie', '', ''),
(622, 9, 4, 1, 'Lubbock', '', 'lubbock', '', ''),
(623, 24, 2, 1, 'Roy', '', 'roy', '', ''),
(624, 21, 8, 1, 'Fredericksburg', '', 'fredericksburg', '', ''),
(625, 7, 7, 1, 'Somerville', '', 'somerville', '', ''),
(626, 10, 1, 1, 'E Palo Alto', '', 'e-palo-alto', '', ''),
(627, 8, 7, 1, 'Tonawanda', '', 'tonawanda', '', ''),
(628, 22, 0, 1, 'Charlotte', '', 'charlotte', '', ''),
(629, 26, 1, 1, 'Tigard', '', 'tigard', '', ''),
(630, 22, 8, 1, 'Monroe', '', 'monroe', '', ''),
(631, 10, 1, 1, 'Glendora', '', 'glendora', '', ''),
(632, 15, 8, 1, 'California', '', 'california', '', ''),
(633, 30, 5, 1, 'North Canton', '', 'north-canton', '', ''),
(634, 13, 9, 1, 'Watertown', '', 'watertown', '', ''),
(635, 26, 1, 1, 'Wilsonville', '', 'wilsonville', '', ''),
(636, 7, 7, 1, 'Woodcliff Lake', '', 'woodcliff-lake', '', ''),
(637, 7, 7, 1, 'Hammonton', '', 'hammonton', '', ''),
(638, 8, 7, 1, 'Syosset', '', 'syosset', '', ''),
(639, 21, 8, 1, 'Mineral', '', 'mineral', '', ''),
(640, 10, 1, 1, 'Walnut Creek', '', 'walnut-creek', '', ''),
(641, 10, 1, 1, 'Moreno Valley', '', 'moreno-valley', '', ''),
(642, 9, 4, 1, 'Fort Worth', '', 'fort-worth', '', ''),
(643, 8, 7, 1, 'Locust Valley', '', 'locust-valley', '', ''),
(644, 10, 1, 1, 'Mill Valley', '', 'mill-valley', '', ''),
(645, 27, 8, 1, 'Myrtle Beach', '', 'myrtle-beach', '', ''),
(646, 15, 8, 1, 'Sykesville', '', 'sykesville', '', ''),
(647, 15, 8, 1, 'Bethesda', '', 'bethesda', '', ''),
(648, 10, 1, 1, 'San Pablo', '', 'san-pablo', '', ''),
(649, 7, 7, 1, 'Union City', '', 'union-city', '', ''),
(650, 39, 5, 1, 'Goshen', '', 'goshen', '', ''),
(651, 31, 7, 1, 'Kennett Square', '', 'kennett-square', '', ''),
(652, 31, 7, 1, 'Chester Springs', '', 'chester-springs', '', ''),
(653, 14, 8, 1, 'Mableton', '', 'mableton', '', ''),
(654, 32, 4, 1, 'Tulsa', '', 'tulsa', '', ''),
(655, 20, 8, 1, 'Juno Beach', '', 'juno-beach', '', ''),
(656, 20, 8, 1, 'Boca Raton', '', 'boca-raton', '', ''),
(657, 36, 5, 1, 'Wauwatosa', '', 'wauwatosa', '', ''),
(658, 7, 7, 1, 'Irvington', '', 'irvington', '', ''),
(659, 31, 7, 1, 'Hermitage', '', 'hermitage', '', ''),
(660, 36, 5, 1, 'Somerset', '', 'somerset', '', ''),
(661, 31, 7, 1, 'Darby', '', 'darby', '', ''),
(662, 48, 6, 1, 'Phenix City', '', 'phenix-city', '', ''),
(663, 8, 7, 1, 'Walden', '', 'walden', '', ''),
(664, 10, 1, 1, 'San Francisco', '', 'san-francisco', '', ''),
(665, 42, 5, 1, 'Bellwood', '', 'bellwood', '', ''),
(666, 42, 5, 1, 'Melrose Park', '', 'melrose-park', '', ''),
(667, 22, 8, 1, 'Saxapahaw', '', 'saxapahaw', '', ''),
(668, 47, 3, 1, 'Jefferson City', '', 'jefferson-city', '', ''),
(669, 35, 5, 1, 'Lansing', '', 'lansing', '', ''),
(670, 22, 8, 1, 'Lumberton', '', 'lumberton', '', ''),
(671, 17, 3, 1, 'Eden Prairie', '', 'eden-prairie', '', ''),
(672, 11, 2, 1, 'Glendale', '', 'glendale', '', ''),
(673, 35, 0, 1, 'Detroit', '', 'detroit', '', ''),
(674, 17, 3, 1, 'Crystal', '', 'crystal', '', ''),
(675, 7, 7, 1, 'Dover', '', 'dover', '', ''),
(676, 8, 7, 1, 'Staten Island', '', 'staten-island', '', ''),
(677, 35, 5, 1, 'Fraser', '', 'fraser', '', ''),
(678, 13, 9, 1, 'Needham', '', 'needham', '', ''),
(679, 20, 8, 1, 'Saint Augustine', '', 'saint-augustine', '', ''),
(680, 7, 7, 1, 'Mullica Hill', '', 'mullica-hill', '', ''),
(681, 7, 7, 1, 'Randolph', '', 'randolph', '', ''),
(682, 10, 1, 1, 'Lawndale', '', 'lawndale', '', ''),
(683, 9, 4, 1, 'Sweetwater', '', 'sweetwater', '', ''),
(684, 39, 5, 1, 'Schererville', '', 'schererville', '', ''),
(685, 23, 9, 1, 'Hampden', '', 'hampden', '', ''),
(686, 23, 9, 1, 'Bangor', '', 'bangor', '', ''),
(687, 20, 8, 1, 'Wilton Manors', '', 'wilton-manors', '', ''),
(688, 8, 7, 1, 'Hamburg', '', 'hamburg', '', ''),
(689, 35, 5, 1, 'Port Huron', '', 'port-huron', '', ''),
(690, 10, 1, 1, 'Ridgecrest', '', 'ridgecrest', '', ''),
(691, 21, 8, 1, 'Herndon', '', 'herndon', '', ''),
(692, 26, 1, 1, 'Forest Grove', '', 'forest-grove', '', ''),
(693, 39, 5, 1, 'West Lafayette', '', 'west-lafayette', '', ''),
(694, 31, 7, 1, 'Grantville', '', 'grantville', '', ''),
(695, 10, 1, 1, 'Twentynine Palms', '', 'twentynine-palms', '', ''),
(696, 7, 7, 1, 'Weehawken', '', 'weehawken', '', ''),
(697, 28, 9, 1, 'Providence', '', 'providence', '', ''),
(698, 42, 5, 1, 'St Charles', '', 'st-charles', '', ''),
(699, 15, 8, 1, 'Gaithersburg', '', 'gaithersburg', '', ''),
(700, 19, 9, 1, 'Hollis', '', 'hollis', '', ''),
(701, 7, 7, 1, 'East Hanover', '', 'east-hanover', '', ''),
(702, 7, 7, 1, 'Little Silver', '', 'little-silver', '', ''),
(703, 8, 7, 1, 'Port Jefferson Station', '', 'port-jefferson-station', '', ''),
(704, 24, 2, 1, 'South Jordan', '', 'south-jordan', '', ''),
(705, 31, 7, 1, 'Greensburg', '', 'greensburg', '', ''),
(706, 36, 5, 1, 'Stevens Point', '', 'stevens-point', '', ''),
(707, 9, 4, 1, 'Dickinson', '', 'dickinson', '', ''),
(708, 15, 8, 1, 'Kensington', '', 'kensington', '', ''),
(709, 20, 8, 1, 'Melbourne', '', 'melbourne', '', ''),
(710, 31, 7, 1, 'Chalfont', '', 'chalfont', '', ''),
(711, 7, 7, 1, 'Camden', '', 'camden', '', ''),
(712, 20, 8, 1, 'Merritt Island', '', 'merritt-island', '', ''),
(713, 47, 3, 1, 'Raytown', '', 'raytown', '', ''),
(714, 43, 2, 1, 'Denver', '', 'denver', '', ''),
(715, 49, 3, 1, 'Yankton', '', 'yankton', '', ''),
(716, 50, 3, 1, 'Dickson', '', 'dickson', '', ''),
(717, 7, 7, 1, 'Galloway', '', 'galloway', '', ''),
(718, 7, 7, 1, 'Mays Landing', '', 'mays-landing', '', ''),
(719, 22, 8, 1, 'Sylva', '', 'sylva', '', ''),
(720, 26, 1, 1, 'Lake Oswego', '', 'lake-oswego', '', ''),
(721, 24, 2, 1, 'Herriman', '', 'herriman', '', ''),
(722, 7, 7, 1, 'Mendham', '', 'mendham', '', ''),
(723, 9, 4, 1, 'Austin', '', 'austin', '', ''),
(724, 41, 9, 1, 'Litchfield', '', 'litchfield', '', ''),
(725, 9, 4, 1, 'Mcallen', '', 'mcallen', '', ''),
(726, 14, 8, 1, 'Barnesville', '', 'barnesville', '', ''),
(727, 28, 9, 1, 'Barrington', '', 'barrington', '', ''),
(728, 8, 7, 1, 'Huntington Stati', '', 'huntington-stati', '', ''),
(729, 10, 1, 1, 'Pomona', '', 'pomona', '', ''),
(730, 10, 1, 1, 'Emeryville', '', 'emeryville', '', ''),
(731, 8, 7, 1, 'Corning', '', 'corning', '', ''),
(732, 31, 7, 1, 'Philipsburg', '', 'philipsburg', '', ''),
(733, 10, 1, 1, 'Sacramento', '', 'sacramento', '', ''),
(734, 21, 8, 1, 'Leesburg', '', 'leesburg', '', ''),
(735, 31, 7, 1, 'Stewartstown', '', 'stewartstown', '', ''),
(736, 14, 8, 1, 'Martinez', '', 'martinez', '', ''),
(737, 7, 7, 1, 'Midland Park', '', 'midland-park', '', ''),
(738, 42, 5, 1, 'Elgin', '', 'elgin', '', ''),
(739, 31, 7, 1, 'Homestead', '', 'homestead', '', ''),
(740, 31, 7, 1, 'Robesonia', '', 'robesonia', '', ''),
(741, 9, 4, 1, 'Port Isabel', '', 'port-isabel', '', ''),
(742, 7, 7, 1, 'Somers Point', '', 'somers-point', '', ''),
(743, 8, 7, 1, 'Schenectady', '', 'schenectady', '', ''),
(744, 31, 7, 1, 'Royersford', '', 'royersford', '', ''),
(745, 8, 7, 1, 'Newburgh', '', 'newburgh', '', ''),
(746, 9, 4, 1, 'Corpus Christi', '', 'corpus-christi', '', ''),
(747, 8, 7, 1, 'Huntington Station', '', 'huntington-station', '', ''),
(748, 15, 8, 1, 'Ellicott City', '', 'ellicott-city', '', ''),
(749, 15, 8, 1, 'College Park', '', 'college-park', '', ''),
(750, 10, 1, 1, 'Costa Mesa', '', 'costa-mesa', '', ''),
(751, 10, 1, 1, 'Los Gatos', '', 'los-gatos', '', ''),
(752, 8, 7, 1, 'Whitesboro', '', 'whitesboro', '', ''),
(753, 13, 9, 1, 'South Easton', '', 'south-easton', '', ''),
(754, 30, 5, 1, 'New Philadelphia', '', 'new-philadelphia', '', ''),
(755, 12, 1, 1, 'Vashon', '', 'vashon', '', ''),
(756, 7, 7, 1, 'Vineland', '', 'vineland', '', ''),
(757, 21, 8, 1, 'Manassas', '', 'manassas', '', ''),
(758, 13, 9, 1, 'Oak Bluffs', '', 'oak-bluffs', '', ''),
(759, 43, 2, 1, 'Greeley', '', 'greeley', '', ''),
(760, 42, 5, 1, 'Waukegan', '', 'waukegan', '', ''),
(761, 31, 7, 1, 'Wrightsville', '', 'wrightsville', '', ''),
(762, 9, 4, 1, 'Round Rock', '', 'round-rock', '', ''),
(763, 10, 1, 1, 'La Jolla', '', 'la-jolla', '', ''),
(764, 11, 2, 1, 'Yuma', '', 'yuma', '', ''),
(765, 10, 1, 1, 'Folsom', '', 'folsom', '', ''),
(766, 41, 9, 1, 'Stamford', '', 'stamford', '', ''),
(767, 13, 9, 1, 'Northampton', '', 'northampton', '', ''),
(768, 10, 1, 1, 'Santa Clara', '', 'santa-clara', '', ''),
(769, 10, 1, 1, 'Chino', '', 'chino', '', ''),
(770, 7, 7, 1, 'Moorestown', '', 'moorestown', '', ''),
(771, 10, 1, 1, 'Palmdale', '', 'palmdale', '', ''),
(772, 7, 7, 1, 'New Brunswick', '', 'new-brunswick', '', ''),
(773, 36, 5, 1, 'Rothschild', '', 'rothschild', '', ''),
(774, 30, 5, 1, 'Eaton', '', 'eaton', '', ''),
(775, 7, 7, 1, 'Raritan', '', 'raritan', '', ''),
(776, 9, 4, 1, 'El Paso', '', 'el-paso', '', ''),
(777, 9, 4, 1, 'Midland', '', 'midland', '', ''),
(778, 17, 3, 1, 'West Saint Paul', '', 'west-saint-paul', '', ''),
(779, 7, 7, 1, 'Warren', '', 'warren', '', ''),
(780, 21, 8, 1, 'Martinsville', '', 'martinsville', '', ''),
(781, 50, 3, 1, 'Nashville', '', 'nashville', '', ''),
(782, 51, 2, 1, 'Las Vegas', '', 'las-vegas', '', ''),
(783, 47, 3, 1, 'Hazelwood', '', 'hazelwood', '', ''),
(784, 10, 1, 1, 'Poway', '', 'poway', '', ''),
(785, 31, 7, 1, 'Jeannette', '', 'jeannette', '', ''),
(786, 10, 1, 1, 'Northridge', '', 'northridge', '', ''),
(787, 10, 1, 1, 'Orosi', '', 'orosi', '', ''),
(788, 15, 8, 1, 'Ashton', '', 'ashton', '', ''),
(789, 52, 4, 1, 'Fort Smith', '', 'fort-smith', '', ''),
(790, 42, 5, 1, 'Cicero', '', 'cicero', '', ''),
(791, 22, 8, 1, 'Chapel Hill', '', 'chapel-hill', '', ''),
(792, 12, 1, 1, 'Edmonds', '', 'edmonds', '', ''),
(793, 8, 7, 1, 'Jamaica', '', 'jamaica', '', ''),
(794, 53, 2, 1, 'Butte', '', 'butte', '', ''),
(795, 10, 1, 1, 'Eureka', '', 'eureka', '', ''),
(796, 10, 1, 1, 'Fairfield', '', 'fairfield', '', ''),
(797, 31, 7, 1, 'Avondale', '', 'avondale', '', ''),
(798, 31, 7, 1, 'Red Lion', '', 'red-lion', '', ''),
(799, 13, 9, 1, 'Orleans', '', 'orleans', '', ''),
(800, 9, 4, 1, 'Humble', '', 'humble', '', ''),
(801, 20, 8, 1, 'Melbourne Beach', '', 'melbourne-beach', '', ''),
(802, 15, 8, 1, 'Rising Sun', '', 'rising-sun', '', ''),
(803, 42, 5, 1, 'Dekalb', '', 'dekalb', '', ''),
(804, 10, 1, 1, 'Salinas', '', 'salinas', '', ''),
(805, 12, 1, 1, 'Bothell', '', 'bothell', '', ''),
(806, 7, 7, 1, 'Jamesburg', '', 'jamesburg', '', ''),
(807, 7, 7, 1, 'North Brunswick', '', 'north-brunswick', '', ''),
(808, 10, 1, 1, 'El Centro', '', 'el-centro', '', ''),
(809, 9, 4, 1, 'Bryan', '', 'bryan', '', ''),
(810, 7, 7, 1, 'Wenonah', '', 'wenonah', '', ''),
(811, 50, 3, 1, 'Mc Minnville', '', 'mc-minnville', '', ''),
(812, 51, 2, 1, 'Sparks', '', 'sparks', '', ''),
(814, 7, 7, 1, 'Paramus', '', 'paramus', '', ''),
(815, 31, 7, 1, 'Bryn Mawr', '', 'bryn-mawr', '', ''),
(816, 8, 7, 1, 'Cortlandt Manor', '', 'cortlandt-manor', '', ''),
(817, 8, 7, 1, 'Mount Kisco', '', 'mount-kisco', '', ''),
(818, 31, 7, 1, 'Montgomeryville', '', 'montgomeryville', '', ''),
(819, 31, 7, 1, 'Palmer Township', '', 'palmer-township', '', ''),
(820, 13, 9, 1, 'Rockland', '', 'rockland', '', ''),
(821, 8, 7, 1, 'Ardsley', '', 'ardsley', '', ''),
(822, 15, 8, 1, 'Bel Air', '', 'bel-air', '', ''),
(823, 21, 8, 1, 'Annandale', '', 'annandale', '', ''),
(824, 38, 9, 1, 'Essex Junction', '', 'essex-junction', '', ''),
(825, 7, 7, 1, 'Atlantic City', '', 'atlantic-city', '', ''),
(826, 7, 7, 1, 'Manasquan', '', 'manasquan', '', ''),
(827, 13, 9, 1, 'Beverly', '', 'beverly', '', ''),
(828, 7, 7, 1, 'Metuchen', '', 'metuchen', '', ''),
(829, 38, 9, 1, 'Williston', '', 'williston', '', ''),
(830, 7, 7, 1, 'Edison', '', 'edison', '', ''),
(831, 10, 1, 1, 'Somis', '', 'somis', '', ''),
(832, 12, 1, 1, 'Mountlake Terrace', '', 'mountlake-terrace', '', ''),
(833, 7, 7, 1, 'Closter', '', 'closter', '', ''),
(834, 8, 7, 1, 'Briarcliff', '', 'briarcliff', '', ''),
(835, 26, 1, 1, 'Brookings', '', 'brookings', '', ''),
(836, 9, 4, 1, 'Aubrey', '', 'aubrey', '', ''),
(837, 8, 7, 1, 'Scarsdale', '', 'scarsdale', '', ''),
(838, 9, 4, 1, 'Coppell', '', 'coppell', '', ''),
(839, 10, 1, 1, 'San Jacinto', '', 'san-jacinto', '', ''),
(840, 7, 7, 1, 'Sewell', '', 'sewell', '', ''),
(841, 31, 7, 1, 'Broomall', '', 'broomall', '', ''),
(842, 31, 7, 1, 'Conshohocken', '', 'conshohocken', '', ''),
(843, 31, 7, 1, 'Hatfield', '', 'hatfield', '', ''),
(844, 8, 7, 1, 'Mahopac', '', 'mahopac', '', ''),
(845, 31, 7, 1, 'Fairview Village', '', 'fairview-village', '', ''),
(846, 26, 1, 1, 'Sherwood', '', 'sherwood', '', ''),
(847, 20, 8, 1, 'Trinity', '', 'trinity', '', ''),
(848, 31, 7, 1, 'Penndel', '', 'penndel', '', ''),
(849, 8, 7, 1, 'Manlius', '', 'manlius', '', ''),
(850, 10, 1, 1, 'Malibu', '', 'malibu', '', ''),
(851, 8, 7, 1, 'Bedford Hills', '', 'bedford-hills', '', ''),
(852, 7, 7, 1, 'Montvale', '', 'montvale', '', ''),
(853, 31, 7, 1, 'Berwyn', '', 'berwyn', '', ''),
(854, 10, 1, 1, 'Fountain Valley', '', 'fountain-valley', '', ''),
(855, 7, 7, 1, 'Maple Shade', '', 'maple-shade', '', ''),
(856, 8, 7, 1, 'East Meadow', '', 'east-meadow', '', ''),
(857, 8, 7, 1, 'Rego Park', '', 'rego-park', '', ''),
(858, 8, 7, 1, 'Forest Hills', '', 'forest-hills', '', ''),
(859, 13, 9, 1, 'Tewksbury', '', 'tewksbury', '', ''),
(860, 13, 9, 1, 'Saugus', '', 'saugus', '', ''),
(861, 19, 9, 1, 'Gorham', '', 'gorham', '', ''),
(862, 15, 8, 1, 'Millersville', '', 'millersville', '', ''),
(863, 8, 7, 1, 'Yorktown Heights', '', 'yorktown-heights', '', ''),
(864, 7, 7, 1, 'Pompton Lakes', '', 'pompton-lakes', '', ''),
(865, 31, 7, 1, 'Warminster', '', 'warminster', '', ''),
(866, 10, 1, 1, 'Brentwood', '', 'brentwood', '', ''),
(867, 7, 7, 1, 'Fair Lawn', '', 'fair-lawn', '', ''),
(868, 7, 7, 1, 'Piscataway', '', 'piscataway', '', ''),
(869, 20, 8, 1, 'Tierra Verde', '', 'tierra-verde', '', ''),
(870, 7, 7, 1, 'Englewood Cliffs', '', 'englewood-cliffs', '', ''),
(871, 10, 1, 1, 'Marina Del Rey', '', 'marina-del-rey', '', ''),
(872, 8, 7, 1, 'Westbury', '', 'westbury', '', ''),
(873, 10, 1, 1, 'Sun City', '', 'sun-city', '', ''),
(874, 10, 1, 1, 'Lompoc', '', 'lompoc', '', ''),
(875, 21, 8, 1, 'Chantilly', '', 'chantilly', '', ''),
(876, 8, 7, 1, 'Wantagh', '', 'wantagh', '', ''),
(877, 7, 7, 1, 'Deptford', '', 'deptford', '', ''),
(878, 13, 9, 1, 'Dedham', '', 'dedham', '', ''),
(879, 13, 9, 1, 'Melrose', '', 'melrose', '', ''),
(880, 31, 7, 1, 'Whitehall', '', 'whitehall', '', ''),
(881, 8, 7, 1, 'Niagara Falls', '', 'niagara-falls', '', ''),
(882, 15, 8, 1, 'Odenton', '', 'odenton', '', ''),
(883, 8, 7, 1, 'East Syracuse', '', 'east-syracuse', '', ''),
(884, 12, 1, 1, 'Carnation', '', 'carnation', '', ''),
(885, 48, 6, 1, 'Birmingham', '', 'birmingham', '', ''),
(886, 7, 7, 1, 'Ho Ho Kus', '', 'ho-ho-kus', '', ''),
(887, 7, 7, 1, 'Pleasantville', '', 'pleasantville', '', ''),
(888, 10, 1, 1, 'Red Bluff', '', 'red-bluff', '', ''),
(889, 42, 5, 1, 'Glenwood', '', 'glenwood', '', ''),
(890, 7, 7, 1, 'South Plainfield', '', 'south-plainfield', '', ''),
(891, 7, 7, 1, 'Secaucus', '', 'secaucus', '', ''),
(892, 48, 6, 1, 'Enterprise', '', 'enterprise', '', ''),
(893, 13, 9, 1, 'East Falmouth', '', 'east-falmouth', '', ''),
(894, 37, 6, 1, 'Corbin', '', 'corbin', '', ''),
(895, 8, 7, 1, 'Ossining', '', 'ossining', '', ''),
(896, 20, 8, 1, 'Palm Beach Gardens', '', 'palm-beach-gardens', '', ''),
(897, 15, 8, 1, 'Berlin', '', 'berlin', '', ''),
(898, 31, 7, 1, 'Paoli', '', 'paoli', '', ''),
(899, 7, 7, 1, 'Hillsdale', '', 'hillsdale', '', ''),
(900, 7, 7, 1, 'Cliffside Park', '', 'cliffside-park', '', ''),
(901, 31, 7, 1, 'Downingtown', '', 'downingtown', '', ''),
(902, 13, 9, 1, 'West Bridgewater', '', 'west-bridgewater', '', ''),
(903, 8, 7, 1, 'Wappingers Falls', '', 'wappingers-falls', '', ''),
(904, 30, 5, 1, 'Garrettsville', '', 'garrettsville', '', ''),
(905, 48, 6, 1, 'Lincoln', '', 'lincoln', '', ''),
(906, 10, 1, 1, 'La Palma', '', 'la-palma', '', ''),
(907, 27, 8, 1, 'Easley', '', 'easley', '', ''),
(908, 7, 7, 1, 'Ramsey', '', 'ramsey', '', ''),
(909, 55, 3, 1, 'Lawrence', '', 'lawrence', '', ''),
(910, 8, 7, 1, 'Elmira', '', 'elmira', '', ''),
(911, 8, 7, 1, 'Port Washington', '', 'port-washington', '', ''),
(912, 7, 7, 1, 'North Wildwood', '', 'north-wildwood', '', ''),
(913, 43, 2, 1, 'Evergreen', '', 'evergreen', '', ''),
(914, 13, 9, 1, 'Vineyard Haven', '', 'vineyard-haven', '', ''),
(915, 7, 7, 1, 'Asbury Park', '', 'asbury-park', '', ''),
(916, 7, 7, 1, 'Waldwick', '', 'waldwick', '', ''),
(917, 31, 7, 1, 'Williamsport', '', 'williamsport', '', ''),
(918, 8, 7, 1, 'Liberty', '', 'liberty', '', ''),
(919, 39, 5, 1, 'Brookville', '', 'brookville', '', ''),
(920, 8, 7, 1, 'College Point', '', 'college-point', '', ''),
(921, 7, 7, 1, 'Garwood', '', 'garwood', '', ''),
(922, 8, 7, 1, 'Greenlawn', '', 'greenlawn', '', ''),
(923, 39, 5, 1, 'Merrillville', '', 'merrillville', '', ''),
(924, 19, 9, 1, 'Laconia', '', 'laconia', '', ''),
(925, 33, 8, 1, 'Martinsburg', '', 'martinsburg', '', ''),
(926, 9, 4, 1, 'Burleson', '', 'burleson', '', ''),
(927, 48, 6, 1, 'Huntsville', '', 'huntsville', '', ''),
(928, 13, 9, 1, 'Cohasset', '', 'cohasset', '', ''),
(929, 31, 7, 1, 'Indiana', '', 'indiana', '', ''),
(930, 7, 7, 1, 'Ventnor City', '', 'ventnor-city', '', ''),
(931, 21, 8, 1, 'Chincoteague Island', '', 'chincoteague-island', '', ''),
(932, 14, 8, 1, 'Savannah', '', 'savannah', '', ''),
(933, 7, 7, 1, 'Sicklerville', '', 'sicklerville', '', ''),
(934, 7, 7, 1, 'Marlton', '', 'marlton', '', ''),
(935, 43, 2, 1, 'Longmont', '', 'longmont', '', ''),
(936, 7, 7, 1, 'Ridgewood', '', 'ridgewood', '', ''),
(937, 7, 7, 1, 'Egg Harbor Township', '', 'egg-harbor-township', '', ''),
(938, 20, 8, 1, 'Vero Beach', '', 'vero-beach', '', ''),
(939, 31, 7, 1, 'Yardley', '', 'yardley', '', ''),
(940, 15, 8, 1, 'Salisbury', '', 'salisbury', '', ''),
(941, 31, 7, 1, 'King Of Prussia', '', 'king-of-prussia', '', ''),
(942, 13, 9, 1, 'Medway', '', 'medway', '', ''),
(943, 41, 9, 1, 'North Haven', '', 'north-haven', '', ''),
(944, 42, 5, 1, 'Oak Park', '', 'oak-park', '', ''),
(945, 11, 2, 1, 'Peoria', '', 'peoria', '', ''),
(946, 8, 7, 1, 'Sag Harbor', '', 'sag-harbor', '', ''),
(947, 8, 7, 1, 'Great Neck', '', 'great-neck', '', ''),
(948, 8, 7, 1, 'Camillus', '', 'camillus', '', ''),
(949, 7, 7, 1, 'Englishtown', '', 'englishtown', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(950, 13, 9, 1, 'Plymouth', '', 'plymouth', '', ''),
(951, 47, 3, 1, 'O Fallon', '', 'o-fallon', '', ''),
(952, 9, 4, 1, 'Christoval', '', 'christoval', '', ''),
(953, 56, 2, 1, 'Sandpoint', '', 'sandpoint', '', ''),
(954, 31, 7, 1, 'Myerstown', '', 'myerstown', '', ''),
(955, 10, 1, 1, 'Corona Del Mar', '', 'corona-del-mar', '', ''),
(956, 39, 5, 1, 'Hobart', '', 'hobart', '', ''),
(957, 15, 8, 1, 'Edgewater', '', 'edgewater', '', ''),
(958, 21, 8, 1, 'Mc Lean', '', 'mc-lean', '', ''),
(959, 47, 3, 1, 'Saint Peters', '', 'saint-peters', '', ''),
(960, 13, 9, 1, 'Middleboro', '', 'middleboro', '', ''),
(961, 13, 9, 1, 'Gloucester', '', 'gloucester', '', ''),
(962, 8, 7, 1, 'Colonie', '', 'colonie', '', ''),
(963, 23, 9, 1, 'Lewiston', '', 'lewiston', '', ''),
(964, 32, 4, 1, 'Lawton', '', 'lawton', '', ''),
(965, 31, 7, 1, 'Ambridge', '', 'ambridge', '', ''),
(966, 15, 8, 1, 'Glen Burnie', '', 'glen-burnie', '', ''),
(967, 9, 4, 1, 'Wylie', '', 'wylie', '', ''),
(968, 31, 7, 1, 'Langhorne', '', 'langhorne', '', ''),
(969, 38, 9, 1, 'Manchester Center', '', 'manchester-center', '', ''),
(970, 35, 5, 1, 'Scottville', '', 'scottville', '', ''),
(971, 12, 1, 1, 'Oak Harbor', '', 'oak-harbor', '', ''),
(972, 28, 9, 1, 'Wakefield', '', 'wakefield', '', ''),
(973, 8, 7, 1, 'East Rockaway', '', 'east-rockaway', '', ''),
(974, 28, 9, 1, 'East Greenwich', '', 'east-greenwich', '', ''),
(975, 8, 7, 1, 'White Plains', '', 'white-plains', '', ''),
(976, 20, 8, 1, 'Oakland Park', '', 'oakland-park', '', ''),
(977, 57, 3, 1, 'Fort Madison', '', 'fort-madison', '', ''),
(978, 9, 4, 1, 'Bellaire', '', 'bellaire', '', ''),
(979, 17, 3, 1, 'Montevideo', '', 'montevideo', '', ''),
(980, 10, 1, 1, 'Van Nuys', '', 'van-nuys', '', ''),
(981, 31, 7, 1, 'Carrolltown', '', 'carrolltown', '', ''),
(982, 23, 9, 1, 'Windham', '', 'windham', '', ''),
(983, 8, 7, 1, 'Amsterdam', '', 'amsterdam', '', ''),
(984, 39, 5, 1, 'Brownsburg', '', 'brownsburg', '', ''),
(985, 44, 4, 1, 'Baton Rouge', '', 'baton-rouge', '', ''),
(986, 10, 1, 1, 'Cotati', '', 'cotati', '', ''),
(987, 10, 1, 1, 'Windsor', '', 'windsor', '', ''),
(988, 30, 5, 1, 'Toledo', '', 'toledo', '', ''),
(989, 10, 1, 1, 'Mountain View', '', 'mountain-view', '', ''),
(990, 36, 5, 1, 'Reedsville', '', 'reedsville', '', ''),
(991, 52, 4, 1, 'Hot Springs National', '', 'hot-springs-national', '', ''),
(992, 9, 4, 1, 'Sugar Land', '', 'sugar-land', '', ''),
(993, 9, 4, 1, 'Tomball', '', 'tomball', '', ''),
(994, 11, 2, 1, 'Scottsdale', '', 'scottsdale', '', ''),
(995, 12, 1, 1, 'Vancouver', '', 'vancouver', '', ''),
(996, 9, 4, 1, 'Mesquite', '', 'mesquite', '', ''),
(997, 9, 4, 1, 'Richardson', '', 'richardson', '', ''),
(998, 9, 4, 1, 'Friendswood', '', 'friendswood', '', ''),
(999, 9, 4, 1, 'Lewisville', '', 'lewisville', '', ''),
(1000, 9, 4, 1, 'Spring', '', 'spring', '', ''),
(1001, 9, 4, 1, 'North Richland Hills', '', 'north-richland-hills', '', ''),
(1002, 9, 4, 1, 'Allen', '', 'allen', '', ''),
(1003, 47, 3, 1, 'Independence', '', 'independence', '', ''),
(1004, 47, 3, 1, 'Saint Charles', '', 'saint-charles', '', ''),
(1005, 26, 1, 1, 'Clackamas', '', 'clackamas', '', ''),
(1006, 43, 2, 1, 'Arvada', '', 'arvada', '', ''),
(1007, 26, 1, 1, 'Medford', '', 'medford', '', ''),
(1008, 50, 3, 1, 'Memphis', '', 'memphis', '', ''),
(1009, 10, 1, 1, 'Davis', '', 'davis', '', ''),
(1010, 10, 1, 1, 'Alamo', '', 'alamo', '', ''),
(1011, 10, 1, 1, 'Aliso Viejo', '', 'aliso-viejo', '', ''),
(1012, 10, 1, 1, 'West Hills', '', 'west-hills', '', ''),
(1013, 10, 1, 1, 'Solana Beach', '', 'solana-beach', '', ''),
(1014, 10, 1, 1, 'Elk Grove', '', 'elk-grove', '', ''),
(1015, 10, 1, 1, 'Manteca', '', 'manteca', '', ''),
(1016, 10, 1, 1, 'Marina', '', 'marina', '', ''),
(1017, 10, 1, 1, 'Livermore', '', 'livermore', '', ''),
(1018, 10, 1, 1, 'Citrus Heights', '', 'citrus-heights', '', ''),
(1019, 10, 1, 1, 'Pacifica', '', 'pacifica', '', ''),
(1020, 10, 1, 1, 'San Dimas', '', 'san-dimas', '', ''),
(1021, 10, 1, 1, 'Antelope', '', 'antelope', '', ''),
(1022, 10, 1, 1, 'Antioch', '', 'antioch', '', ''),
(1023, 10, 1, 1, 'El Granada', '', 'el-granada', '', ''),
(1024, 10, 1, 1, 'Stockton', '', 'stockton', '', ''),
(1025, 10, 1, 1, 'San Juan Capistrano', '', 'san-juan-capistrano', '', ''),
(1026, 10, 1, 1, 'Mission Viejo', '', 'mission-viejo', '', ''),
(1027, 10, 1, 1, 'Panorama City', '', 'panorama-city', '', ''),
(1028, 10, 1, 1, 'San Carlos', '', 'san-carlos', '', ''),
(1029, 10, 1, 1, 'Santa Ana', '', 'santa-ana', '', ''),
(1030, 10, 1, 1, 'Ladera Ranch', '', 'ladera-ranch', '', ''),
(1031, 10, 1, 1, 'Canyon Country', '', 'canyon-country', '', ''),
(1032, 10, 1, 1, 'Laguna Hills', '', 'laguna-hills', '', ''),
(1033, 10, 1, 1, 'Bakersfield', '', 'bakersfield', '', ''),
(1034, 10, 1, 1, 'Visalia', '', 'visalia', '', ''),
(1035, 10, 1, 1, 'Petaluma', '', 'petaluma', '', ''),
(1036, 10, 1, 1, 'Fontana', '', 'fontana', '', ''),
(1037, 10, 1, 1, 'Cupertino', '', 'cupertino', '', ''),
(1038, 10, 1, 1, 'San Ramon', '', 'san-ramon', '', ''),
(1039, 10, 1, 1, 'Roseville', '', 'roseville', '', ''),
(1040, 10, 1, 1, 'Cathedral City', '', 'cathedral-city', '', ''),
(1041, 10, 1, 1, 'Daly City', '', 'daly-city', '', ''),
(1042, 10, 1, 1, 'Larkspur', '', 'larkspur', '', ''),
(1043, 10, 1, 1, 'Pleasanton', '', 'pleasanton', '', ''),
(1044, 10, 1, 1, 'Santa Cruz', '', 'santa-cruz', '', ''),
(1045, 58, 3, 1, 'Papillion', '', 'papillion', '', ''),
(1046, 56, 2, 1, 'Boise', '', 'boise', '', ''),
(1047, 56, 2, 1, 'Coeur D Alene', '', 'coeur-d-alene', '', ''),
(1048, 25, 10, 1, 'Haiku', '', 'haiku', '', ''),
(1049, 24, 2, 1, 'Provo', '', 'provo', '', ''),
(1050, 32, 4, 1, 'Jenks', '', 'jenks', '', ''),
(1051, 58, 3, 1, 'Omaha', '', 'omaha', '', ''),
(1052, 55, 3, 1, 'Shawnee Mission', '', 'shawnee-mission', '', ''),
(1053, 20, 8, 1, 'Orange Park', '', 'orange-park', '', ''),
(1054, 20, 8, 1, 'Plantation', '', 'plantation', '', ''),
(1055, 51, 2, 1, 'Reno', '', 'reno', '', ''),
(1056, 10, 1, 1, 'Anaheim', '', 'anaheim', '', ''),
(1057, 10, 1, 1, 'Brea', '', 'brea', '', ''),
(1058, 10, 1, 1, 'Buena Park', '', 'buena-park', '', ''),
(1059, 10, 1, 1, 'Chula Vista', '', 'chula-vista', '', ''),
(1060, 10, 1, 1, 'City Of Industry', '', 'city-of-industry', '', ''),
(1061, 10, 1, 1, 'Simi Valley', '', 'simi-valley', '', ''),
(1062, 12, 1, 1, 'Spokane', '', 'spokane', '', ''),
(1063, 12, 1, 1, 'Spokane Valley', '', 'spokane-valley', '', ''),
(1064, 10, 1, 1, 'El Cajon', '', 'el-cajon', '', ''),
(1065, 10, 1, 1, 'Escondido', '', 'escondido', '', ''),
(1066, 12, 1, 1, 'Federal Way', '', 'federal-way', '', ''),
(1067, 25, 10, 1, 'Kaneohe', '', 'kaneohe', '', ''),
(1068, 12, 1, 1, 'Kent', '', 'kent', '', ''),
(1069, 10, 1, 1, 'Orange', '', 'orange', '', ''),
(1070, 10, 1, 1, 'San Marcos', '', 'san-marcos', '', ''),
(1071, 10, 1, 1, 'Santee', '', 'santee', '', ''),
(1072, 10, 1, 1, 'Sunnyvale', '', 'sunnyvale', '', ''),
(1073, 10, 1, 1, 'Yorba Linda', '', 'yorba-linda', '', ''),
(1074, 10, 1, 1, 'Hermosa Beach', '', 'hermosa-beach', '', ''),
(1075, 10, 1, 1, 'Chino Hills', '', 'chino-hills', '', ''),
(1076, 9, 4, 1, 'Southlake', '', 'southlake', '', ''),
(1077, 10, 1, 1, 'Bonita', '', 'bonita', '', ''),
(1078, 52, 4, 1, 'Fayetteville', '', 'fayetteville', '', ''),
(1079, 17, 3, 1, 'Kenyon', '', 'kenyon', '', ''),
(1080, 17, 3, 1, 'Janesville', '', 'janesville', '', ''),
(1081, 17, 3, 1, 'Hermantown', '', 'hermantown', '', ''),
(1082, 9, 4, 1, 'Montgomery', '', 'montgomery', '', ''),
(1083, 43, 2, 1, 'Woodland Park', '', 'woodland-park', '', ''),
(1084, 14, 8, 1, 'Lithia Springs', '', 'lithia-springs', '', ''),
(1085, 50, 3, 1, 'Spring Hill', '', 'spring-hill', '', ''),
(1086, 48, 6, 1, 'Childersburg', '', 'childersburg', '', ''),
(1087, 12, 1, 1, 'Ferndale', '', 'ferndale', '', ''),
(1088, 42, 5, 1, 'Shorewood', '', 'shorewood', '', ''),
(1089, 7, 7, 1, 'Avalon', '', 'avalon', '', ''),
(1090, 9, 4, 1, 'Tyler', '', 'tyler', '', ''),
(1091, 30, 5, 1, 'Maumee', '', 'maumee', '', ''),
(1092, 7, 7, 1, 'Chatsworth', '', 'chatsworth', '', ''),
(1093, 32, 4, 1, 'Edmond', '', 'edmond', '', ''),
(1094, 10, 1, 1, 'Scotts Valley', '', 'scotts-valley', '', ''),
(1095, 15, 8, 1, 'Reisterstown', '', 'reisterstown', '', ''),
(1096, 9, 4, 1, 'Cisco', '', 'cisco', '', ''),
(1097, 42, 5, 1, 'Highland Park', '', 'highland-park', '', ''),
(1098, 12, 1, 1, 'Yakima', '', 'yakima', '', ''),
(1099, 12, 1, 1, 'Kennewick', '', 'kennewick', '', ''),
(1100, 17, 3, 1, 'Rochester', '', 'rochester', '', ''),
(1101, 10, 1, 1, 'Rowland Heights', '', 'rowland-heights', '', ''),
(1102, 10, 1, 1, 'San Fernando', '', 'san-fernando', '', ''),
(1103, 36, 5, 1, 'Racine', '', 'racine', '', ''),
(1104, 57, 3, 1, 'Clive', '', 'clive', '', ''),
(1105, 41, 9, 1, 'Waterbury', '', 'waterbury', '', ''),
(1106, 11, 2, 1, 'Thatcher', '', 'thatcher', '', ''),
(1107, 43, 2, 1, 'Nederland', '', 'nederland', '', ''),
(1108, 42, 5, 1, 'Mount Prospect', '', 'mount-prospect', '', ''),
(1109, 31, 7, 1, 'Eighty Four', '', 'eighty-four', '', ''),
(1110, 22, 8, 1, 'Hickory', '', 'hickory', '', ''),
(1111, 42, 5, 1, 'Lockport', '', 'lockport', '', ''),
(1112, 8, 7, 1, 'Bellmore', '', 'bellmore', '', ''),
(1113, 7, 7, 1, 'Barnegat', '', 'barnegat', '', ''),
(1114, 41, 9, 1, 'Voluntown', '', 'voluntown', '', ''),
(1115, 44, 4, 1, 'Franklinton', '', 'franklinton', '', ''),
(1116, 9, 4, 1, 'Alpine', '', 'alpine', '', ''),
(1117, 10, 1, 1, 'Dublin', '', 'dublin', '', ''),
(1118, 9, 4, 1, 'Ingram', '', 'ingram', '', ''),
(1119, 10, 1, 1, 'Reedley', '', 'reedley', '', ''),
(1120, 12, 1, 1, 'Pasco', '', 'pasco', '', ''),
(1121, 26, 1, 1, 'Myrtle Point', '', 'myrtle-point', '', ''),
(1122, 10, 1, 1, 'Yreka', '', 'yreka', '', ''),
(1123, 36, 5, 1, 'Oregon', '', 'oregon', '', ''),
(1124, 27, 8, 1, 'Rock Hill', '', 'rock-hill', '', ''),
(1125, 20, 8, 1, 'Jacksonville Beach', '', 'jacksonville-beach', '', ''),
(1126, 48, 6, 1, 'Rainsville', '', 'rainsville', '', ''),
(1127, 14, 8, 1, 'Woodstock', '', 'woodstock', '', ''),
(1128, 10, 1, 1, 'Loma Linda', '', 'loma-linda', '', ''),
(1129, 36, 5, 1, 'Middleton', '', 'middleton', '', ''),
(1130, 37, 6, 1, 'Shelbyville', '', 'shelbyville', '', ''),
(1131, 20, 8, 1, 'Hollywood', '', 'hollywood', '', ''),
(1132, 8, 7, 1, 'Youngstown', '', 'youngstown', '', ''),
(1133, 47, 3, 1, 'Bonne Terre', '', 'bonne-terre', '', ''),
(1134, 10, 1, 1, 'South Pasadena', '', 'south-pasadena', '', ''),
(1135, 20, 8, 1, 'Orange City', '', 'orange-city', '', ''),
(1136, 8, 7, 1, 'New Hyde Park', '', 'new-hyde-park', '', ''),
(1137, 13, 9, 1, 'Dracut', '', 'dracut', '', ''),
(1138, 8, 7, 1, 'Bayside', '', 'bayside', '', ''),
(1139, 22, 8, 1, 'Mocksville', '', 'mocksville', '', ''),
(1140, 55, 3, 1, 'Prairie Village', '', 'prairie-village', '', ''),
(1141, 20, 8, 1, 'Deland', '', 'deland', '', ''),
(1142, 9, 4, 1, 'Hurst', '', 'hurst', '', ''),
(1143, 43, 2, 1, 'Pagosa Springs', '', 'pagosa-springs', '', ''),
(1144, 9, 4, 1, 'Grand Prairie', '', 'grand-prairie', '', ''),
(1145, 8, 7, 1, 'Malone', '', 'malone', '', ''),
(1146, 49, 3, 1, 'Rapid City', '', 'rapid-city', '', ''),
(1147, 48, 6, 1, 'Rogersville', '', 'rogersville', '', ''),
(1148, 8, 7, 1, 'Latham', '', 'latham', '', ''),
(1149, 9, 4, 1, 'Abilene', '', 'abilene', '', ''),
(1150, 15, 8, 1, 'Abingdon', '', 'abingdon', '', ''),
(1151, 9, 4, 1, 'Alice', '', 'alice', '', ''),
(1152, 20, 8, 1, 'Pompano Beach', '', 'pompano-beach', '', ''),
(1153, 57, 3, 1, 'Marshalltown', '', 'marshalltown', '', ''),
(1154, 47, 3, 1, 'Camdenton', '', 'camdenton', '', ''),
(1155, 59, 3, 1, 'Grand Forks', '', 'grand-forks', '', ''),
(1156, 42, 5, 1, 'Peoria Heights', '', 'peoria-heights', '', ''),
(1157, 14, 8, 1, 'Fort Oglethorpe', '', 'fort-oglethorpe', '', ''),
(1158, 7, 7, 1, 'Lodi', '', 'lodi', '', ''),
(1159, 8, 7, 1, 'East Rochester', '', 'east-rochester', '', ''),
(1160, 9, 4, 1, 'Giddings', '', 'giddings', '', ''),
(1161, 22, 8, 1, 'Carolina Beach', '', 'carolina-beach', '', ''),
(1162, 48, 6, 1, 'Mobile', '', 'mobile', '', ''),
(1163, 60, 2, 1, 'Casper', '', 'casper', '', ''),
(1164, 20, 8, 1, 'Pensacola', '', 'pensacola', '', ''),
(1165, 51, 2, 1, 'Yerington', '', 'yerington', '', ''),
(1166, 20, 8, 1, 'Boynton Beach', '', 'boynton-beach', '', ''),
(1167, 8, 7, 1, 'Fishkill', '', 'fishkill', '', ''),
(1168, 55, 3, 1, 'Topeka', '', 'topeka', '', ''),
(1169, 8, 7, 1, 'Pittsford', '', 'pittsford', '', ''),
(1170, 35, 5, 1, 'Livonia', '', 'livonia', '', ''),
(1171, 10, 1, 1, 'West Hollywood', '', 'west-hollywood', '', ''),
(1172, 17, 3, 1, 'Rushford', '', 'rushford', '', ''),
(1173, 22, 8, 1, 'Carrboro', '', 'carrboro', '', ''),
(1174, 21, 8, 1, 'Charlottesvle', '', 'charlottesvle', '', ''),
(1175, 21, 8, 1, 'Charlottesville', '', 'charlottesville', '', ''),
(1176, 24, 2, 1, 'Logan', '', 'logan', '', ''),
(1177, 8, 7, 1, 'East Northport', '', 'east-northport', '', ''),
(1178, 35, 5, 1, 'Utica', '', 'utica', '', ''),
(1179, 61, 6, 1, 'Brookhaven', '', 'brookhaven', '', ''),
(1180, 12, 1, 1, 'Longview', '', 'longview', '', ''),
(1181, 31, 7, 1, 'Arnold', '', 'arnold', '', ''),
(1182, 36, 5, 1, 'Sheboygan', '', 'sheboygan', '', ''),
(1183, 7, 7, 1, 'Mercerville', '', 'mercerville', '', ''),
(1184, 10, 1, 1, 'Placentia', '', 'placentia', '', ''),
(1185, 30, 5, 1, 'Dayton', '', 'dayton', '', ''),
(1186, 23, 9, 1, 'Madawaska', '', 'madawaska', '', ''),
(1187, 44, 4, 1, 'Church Point', '', 'church-point', '', ''),
(1188, 44, 4, 1, 'New Iberia', '', 'new-iberia', '', ''),
(1189, 57, 3, 1, 'Urbandale', '', 'urbandale', '', ''),
(1190, 56, 2, 1, 'Emmett', '', 'emmett', '', ''),
(1191, 34, 1, 1, 'Anchorage', '', 'anchorage', '', ''),
(1192, 47, 3, 1, 'Chesterfield', '', 'chesterfield', '', ''),
(1193, 47, 3, 1, 'Nixa', '', 'nixa', '', ''),
(1194, 32, 4, 1, 'Sapulpa', '', 'sapulpa', '', ''),
(1195, 9, 4, 1, 'Conroe', '', 'conroe', '', ''),
(1196, 7, 7, 1, 'Stratford', '', 'stratford', '', ''),
(1197, 9, 4, 1, 'Killeen', '', 'killeen', '', ''),
(1198, 12, 1, 1, 'Walla Walla', '', 'walla-walla', '', ''),
(1199, 55, 3, 1, 'Overland Park', '', 'overland-park', '', ''),
(1200, 7, 7, 1, 'Hackettstown', '', 'hackettstown', '', ''),
(1201, 20, 8, 1, 'Crestview', '', 'crestview', '', ''),
(1202, 39, 5, 1, 'Wadesville', '', 'wadesville', '', ''),
(1203, 61, 6, 1, 'Pascagoula', '', 'pascagoula', '', ''),
(1204, 10, 1, 1, 'Modesto', '', 'modesto', '', ''),
(1205, 55, 3, 1, 'Wichita', '', 'wichita', '', ''),
(1206, 10, 1, 1, 'Anaheim Hills', '', 'anaheim-hills', '', ''),
(1207, 10, 1, 1, 'Rohnert Park', '', 'rohnert-park', '', ''),
(1208, 8, 7, 1, 'Hauppauge', '', 'hauppauge', '', ''),
(1209, 31, 7, 1, 'Feasterville Trevose', '', 'feasterville-trevose', '', ''),
(1210, 10, 1, 1, 'Tarzana', '', 'tarzana', '', ''),
(1211, 36, 5, 1, 'Milwaukee', '', 'milwaukee', '', ''),
(1212, 21, 8, 1, 'Reston', '', 'reston', '', ''),
(1213, 33, 8, 1, 'Oak Hill', '', 'oak-hill', '', ''),
(1214, 22, 8, 1, 'Greensboro', '', 'greensboro', '', ''),
(1215, 10, 1, 1, 'Encino', '', 'encino', '', ''),
(1216, 42, 5, 1, 'Metamora', '', 'metamora', '', ''),
(1217, 9, 4, 1, 'Lorenzo', '', 'lorenzo', '', ''),
(1218, 8, 7, 1, 'Depew', '', 'depew', '', ''),
(1219, 10, 1, 1, 'Redding', '', 'redding', '', ''),
(1220, 20, 8, 1, 'Port Saint Lucie', '', 'port-saint-lucie', '', ''),
(1221, 44, 4, 1, 'Ruston', '', 'ruston', '', ''),
(1222, 57, 3, 1, 'Madrid', '', 'madrid', '', ''),
(1223, 24, 2, 1, 'Kanab', '', 'kanab', '', ''),
(1224, 7, 7, 1, 'Plainfield', '', 'plainfield', '', ''),
(1225, 7, 7, 1, 'Verona', '', 'verona', '', ''),
(1226, 14, 8, 1, 'Suwanee', '', 'suwanee', '', ''),
(1227, 14, 8, 1, 'Summerville', '', 'summerville', '', ''),
(1228, 8, 7, 1, 'Nyack', '', 'nyack', '', ''),
(1229, 9, 4, 1, 'Wichita Falls', '', 'wichita-falls', '', ''),
(1230, 47, 3, 1, 'Maryland Heights', '', 'maryland-heights', '', ''),
(1231, 43, 2, 1, 'Wheat Ridge', '', 'wheat-ridge', '', ''),
(1232, 43, 2, 1, 'Lone Tree', '', 'lone-tree', '', ''),
(1233, 41, 9, 1, 'West Hartford', '', 'west-hartford', '', ''),
(1234, 13, 9, 1, 'Wellesley Hills', '', 'wellesley-hills', '', ''),
(1235, 31, 7, 1, 'Narberth', '', 'narberth', '', ''),
(1236, 8, 7, 1, 'Orchard Park', '', 'orchard-park', '', ''),
(1237, 42, 5, 1, 'Monmouth', '', 'monmouth', '', ''),
(1238, 53, 2, 1, 'Helena', '', 'helena', '', ''),
(1239, 39, 5, 1, 'Evansville', '', 'evansville', '', ''),
(1240, 36, 5, 1, 'Fitchburg', '', 'fitchburg', '', ''),
(1241, 41, 9, 1, 'Mystic', '', 'mystic', '', ''),
(1242, 41, 9, 1, 'Niantic', '', 'niantic', '', ''),
(1243, 8, 7, 1, 'Castleton On Hudson', '', 'castleton-on-hudson', '', ''),
(1244, 8, 7, 1, 'Webster', '', 'webster', '', ''),
(1245, 8, 7, 1, 'Churchville', '', 'churchville', '', ''),
(1246, 8, 7, 1, 'Brockport', '', 'brockport', '', ''),
(1247, 42, 5, 1, 'Park Ridge', '', 'park-ridge', '', ''),
(1248, 47, 3, 1, 'Saint Joseph', '', 'saint-joseph', '', ''),
(1249, 32, 4, 1, 'Oklahoma City', '', 'oklahoma-city', '', ''),
(1250, 52, 4, 1, 'Jonesboro', '', 'jonesboro', '', ''),
(1251, 31, 7, 1, 'Pittston', '', 'pittston', '', ''),
(1252, 13, 9, 1, 'Norwood', '', 'norwood', '', ''),
(1253, 31, 7, 1, 'Collegeville', '', 'collegeville', '', ''),
(1254, 57, 3, 1, 'Des Moines', '', 'des-moines', '', ''),
(1255, 56, 2, 1, 'Bonners Ferry', '', 'bonners-ferry', '', ''),
(1256, 9, 4, 1, 'Mercedes', '', 'mercedes', '', ''),
(1257, 39, 5, 1, 'Granger', '', 'granger', '', ''),
(1258, 9, 4, 1, 'Paris', '', 'paris', '', ''),
(1259, 17, 3, 1, 'Hastings', '', 'hastings', '', ''),
(1260, 26, 1, 1, 'Lakeview', '', 'lakeview', '', ''),
(1261, 14, 8, 1, 'Lagrange', '', 'lagrange', '', ''),
(1262, 10, 1, 1, 'Rancho Cordova', '', 'rancho-cordova', '', ''),
(1263, 8, 7, 1, 'Chester', '', 'chester', '', ''),
(1264, 32, 4, 1, 'Nowata', '', 'nowata', '', ''),
(1265, 27, 8, 1, 'Orangeburg', '', 'orangeburg', '', ''),
(1266, 14, 8, 1, 'Tifton', '', 'tifton', '', ''),
(1267, 14, 8, 1, 'Macon', '', 'macon', '', ''),
(1268, 22, 8, 1, 'Efland', '', 'efland', '', ''),
(1269, 7, 7, 1, 'Long Branch', '', 'long-branch', '', ''),
(1270, 7, 7, 1, 'Paterson', '', 'paterson', '', ''),
(1271, 7, 7, 1, 'Mount Holly', '', 'mount-holly', '', ''),
(1272, 42, 5, 1, 'Champaign', '', 'champaign', '', ''),
(1273, 35, 5, 1, 'Dimondale', '', 'dimondale', '', ''),
(1274, 25, 10, 1, 'Makawao', '', 'makawao', '', ''),
(1275, 10, 1, 1, 'San Gabriel', '', 'san-gabriel', '', ''),
(1276, 20, 8, 1, 'Port Charlotte', '', 'port-charlotte', '', ''),
(1277, 27, 8, 1, 'West Columbia', '', 'west-columbia', '', ''),
(1278, 27, 8, 1, 'Greer', '', 'greer', '', ''),
(1279, 52, 4, 1, 'Alma', '', 'alma', '', ''),
(1280, 30, 5, 1, 'Monclova', '', 'monclova', '', ''),
(1281, 20, 8, 1, 'Sanford', '', 'sanford', '', ''),
(1282, 10, 1, 1, 'Winnetka', '', 'winnetka', '', ''),
(1283, 30, 5, 1, 'Akron', '', 'akron', '', ''),
(1284, 10, 1, 1, 'Hanford', '', 'hanford', '', ''),
(1285, 20, 8, 1, 'Alachua', '', 'alachua', '', ''),
(1286, 12, 1, 1, 'Poulsbo', '', 'poulsbo', '', ''),
(1287, 34, 1, 1, 'Eagle River', '', 'eagle-river', '', ''),
(1288, 34, 1, 1, 'Fairbanks', '', 'fairbanks', '', ''),
(1289, 34, 1, 1, 'Soldotna', '', 'soldotna', '', ''),
(1290, 49, 3, 1, 'Alcester', '', 'alcester', '', ''),
(1291, 10, 1, 1, 'Calistoga', '', 'calistoga', '', ''),
(1292, 10, 1, 1, 'El Monte', '', 'el-monte', '', ''),
(1293, 31, 7, 1, 'Meadville', '', 'meadville', '', ''),
(1294, 48, 6, 1, 'Alexander City', '', 'alexander-city', '', ''),
(1295, 31, 7, 1, 'Canonsburg', '', 'canonsburg', '', ''),
(1296, 31, 7, 1, 'Oakmont', '', 'oakmont', '', ''),
(1297, 31, 7, 1, 'Irwin', '', 'irwin', '', ''),
(1298, 10, 1, 1, 'Porterville', '', 'porterville', '', ''),
(1299, 34, 1, 1, 'Klawock', '', 'klawock', '', ''),
(1300, 20, 8, 1, 'Naples', '', 'naples', '', ''),
(1301, 45, 2, 1, 'Santa Fe', '', 'santa-fe', '', ''),
(1302, 8, 7, 1, 'West Islip', '', 'west-islip', '', ''),
(1303, 9, 4, 1, 'Mckinney', '', 'mckinney', '', ''),
(1304, 17, 3, 1, 'Inver Grove Heights', '', 'inver-grove-heights', '', ''),
(1305, 8, 7, 1, 'Grand Island', '', 'grand-island', '', ''),
(1306, 10, 1, 1, 'Tustin', '', 'tustin', '', ''),
(1307, 36, 5, 1, 'Kewaunee', '', 'kewaunee', '', ''),
(1308, 41, 9, 1, 'Torrington', '', 'torrington', '', ''),
(1309, 47, 3, 1, 'Blue Springs', '', 'blue-springs', '', ''),
(1310, 22, 8, 1, 'Statesville', '', 'statesville', '', ''),
(1311, 22, 8, 1, 'Lincolnton', '', 'lincolnton', '', ''),
(1312, 8, 7, 1, 'New Hartford', '', 'new-hartford', '', ''),
(1313, 32, 4, 1, 'Sand Springs', '', 'sand-springs', '', ''),
(1314, 7, 7, 1, 'Manahawkin', '', 'manahawkin', '', ''),
(1315, 14, 8, 1, 'Vidalia', '', 'vidalia', '', ''),
(1316, 13, 9, 1, 'Eastham', '', 'eastham', '', ''),
(1317, 12, 1, 1, 'University Place', '', 'university-place', '', ''),
(1318, 9, 4, 1, 'Rockdale', '', 'rockdale', '', ''),
(1319, 44, 4, 1, 'Many', '', 'many', '', ''),
(1320, 9, 4, 1, 'Eagle Pass', '', 'eagle-pass', '', ''),
(1321, 32, 4, 1, 'Mcloud', '', 'mcloud', '', ''),
(1322, 12, 1, 1, 'Washougal', '', 'washougal', '', ''),
(1323, 20, 8, 1, 'Davie', '', 'davie', '', ''),
(1324, 53, 2, 1, 'Great Falls', '', 'great-falls', '', ''),
(1325, 52, 4, 1, 'Pine Bluff', '', 'pine-bluff', '', ''),
(1326, 37, 6, 1, 'Louisville', '', 'louisville', '', ''),
(1327, 20, 8, 1, 'Ocoee', '', 'ocoee', '', ''),
(1328, 20, 8, 1, 'Altamonte Springs', '', 'altamonte-springs', '', ''),
(1329, 14, 8, 1, 'Powder Springs', '', 'powder-springs', '', ''),
(1330, 22, 8, 1, 'Sparta', '', 'sparta', '', ''),
(1331, 31, 7, 1, 'Warrendale', '', 'warrendale', '', ''),
(1332, 43, 2, 1, 'Avon', '', 'avon', '', ''),
(1333, 35, 5, 1, 'Canton', '', 'canton', '', ''),
(1334, 57, 3, 1, 'Waterloo', '', 'waterloo', '', ''),
(1335, 22, 8, 1, 'Cary', '', 'cary', '', ''),
(1336, 15, 8, 1, 'Lexington Park', '', 'lexington-park', '', ''),
(1337, 17, 3, 1, 'Wabasha', '', 'wabasha', '', ''),
(1338, 44, 4, 1, 'Houma', '', 'houma', '', ''),
(1339, 17, 3, 1, 'Saint Cloud', '', 'saint-cloud', '', ''),
(1340, 49, 3, 1, 'Sioux Falls', '', 'sioux-falls', '', ''),
(1341, 24, 2, 1, 'Moab', '', 'moab', '', ''),
(1342, 52, 4, 1, 'Clarksville', '', 'clarksville', '', ''),
(1343, 28, 9, 1, 'Johnston', '', 'johnston', '', ''),
(1344, 25, 10, 1, 'Hilo', '', 'hilo', '', ''),
(1345, 35, 5, 1, 'Alpena', '', 'alpena', '', ''),
(1346, 20, 8, 1, 'Palm Coast', '', 'palm-coast', '', ''),
(1347, 22, 8, 1, 'High Point', '', 'high-point', '', ''),
(1348, 20, 8, 1, 'Tallahassee', '', 'tallahassee', '', ''),
(1349, 10, 1, 1, 'Truckee', '', 'truckee', '', ''),
(1350, 19, 9, 1, 'North Woodstock', '', 'north-woodstock', '', ''),
(1351, 12, 1, 1, 'North Bend', '', 'north-bend', '', ''),
(1352, 57, 3, 1, 'Dubuque', '', 'dubuque', '', ''),
(1353, 14, 8, 1, 'Darien', '', 'darien', '', ''),
(1354, 42, 5, 1, 'Elk Grove Village', '', 'elk-grove-village', '', ''),
(1355, 53, 2, 1, 'Bozeman', '', 'bozeman', '', ''),
(1356, 53, 2, 1, 'Belgrade', '', 'belgrade', '', ''),
(1357, 8, 7, 1, 'Sound Beach', '', 'sound-beach', '', ''),
(1358, 30, 5, 1, 'Canal Fulton', '', 'canal-fulton', '', ''),
(1359, 43, 2, 1, 'Leadville', '', 'leadville', '', ''),
(1360, 57, 3, 1, 'Altoona', '', 'altoona', '', ''),
(1361, 9, 4, 1, 'Alvin', '', 'alvin', '', ''),
(1362, 44, 4, 1, 'Belle Rose', '', 'belle-rose', '', ''),
(1363, 10, 1, 1, 'Sutter Creek', '', 'sutter-creek', '', ''),
(1364, 9, 4, 1, 'Amarillo', '', 'amarillo', '', ''),
(1365, 9, 4, 1, 'Denison', '', 'denison', '', ''),
(1366, 58, 3, 1, 'Nebraska City', '', 'nebraska-city', '', ''),
(1367, 31, 7, 1, 'Ambler', '', 'ambler', '', ''),
(1368, 20, 8, 1, 'Fernandina Beach', '', 'fernandina-beach', '', ''),
(1369, 44, 4, 1, 'Metairie', '', 'metairie', '', ''),
(1370, 36, 5, 1, 'Waupaca', '', 'waupaca', '', ''),
(1371, 35, 5, 1, 'Jackson', '', 'jackson', '', ''),
(1372, 17, 3, 1, 'Hutchinson', '', 'hutchinson', '', ''),
(1373, 17, 3, 1, 'Owatonna', '', 'owatonna', '', ''),
(1374, 17, 3, 1, 'Mankato', '', 'mankato', '', ''),
(1375, 10, 1, 1, 'National City', '', 'national-city', '', ''),
(1376, 57, 3, 1, 'Jefferson', '', 'jefferson', '', ''),
(1377, 36, 5, 1, 'De Pere', '', 'de-pere', '', ''),
(1378, 8, 7, 1, 'Massapequa Park', '', 'massapequa-park', '', ''),
(1379, 31, 7, 1, 'Greentown', '', 'greentown', '', ''),
(1380, 8, 7, 1, 'Cairo', '', 'cairo', '', ''),
(1381, 30, 5, 1, 'East Liverpool', '', 'east-liverpool', '', ''),
(1382, 42, 5, 1, 'Naperville', '', 'naperville', '', ''),
(1383, 42, 5, 1, 'Granite City', '', 'granite-city', '', ''),
(1384, 21, 8, 1, 'Colonial Hgts', '', 'colonial-hgts', '', ''),
(1385, 21, 8, 1, 'Mechanicsville', '', 'mechanicsville', '', ''),
(1386, 35, 5, 1, 'Waterford', '', 'waterford', '', ''),
(1387, 9, 4, 1, 'Laredo', '', 'laredo', '', ''),
(1388, 41, 9, 1, 'Greenwich', '', 'greenwich', '', ''),
(1389, 24, 2, 1, 'American Fork', '', 'american-fork', '', ''),
(1390, 35, 5, 1, 'Grand Rapids', '', 'grand-rapids', '', ''),
(1391, 10, 1, 1, 'Canoga Park', '', 'canoga-park', '', ''),
(1392, 35, 5, 1, 'Farmington', '', 'farmington', '', ''),
(1393, 36, 5, 1, 'Richfield', '', 'richfield', '', ''),
(1394, 10, 1, 1, 'Delano', '', 'delano', '', ''),
(1395, 16, 8, 1, 'Selbyville', '', 'selbyville', '', ''),
(1396, 37, 6, 1, 'Ashland', '', 'ashland', '', ''),
(1397, 37, 6, 1, 'Grayson', '', 'grayson', '', ''),
(1398, 28, 9, 1, 'West Warwick', '', 'west-warwick', '', ''),
(1399, 60, 2, 1, 'Cheyenne', '', 'cheyenne', '', ''),
(1400, 20, 8, 1, 'Longwood', '', 'longwood', '', ''),
(1401, 9, 4, 1, 'Terrell', '', 'terrell', '', ''),
(1402, 56, 2, 1, 'Idaho Falls', '', 'idaho-falls', '', ''),
(1403, 42, 5, 1, 'Fox Lake', '', 'fox-lake', '', ''),
(1404, 42, 5, 1, 'Ingleside', '', 'ingleside', '', ''),
(1405, 8, 7, 1, 'Maybrook', '', 'maybrook', '', ''),
(1406, 8, 7, 1, 'Bellerose', '', 'bellerose', '', ''),
(1407, 8, 7, 1, 'Woodside', '', 'woodside', '', ''),
(1408, 7, 7, 1, 'Cinnaminson', '', 'cinnaminson', '', ''),
(1409, 30, 5, 1, 'Loveland', '', 'loveland', '', ''),
(1410, 36, 5, 1, 'Eau Claire', '', 'eau-claire', '', ''),
(1411, 10, 1, 1, 'Vacaville', '', 'vacaville', '', ''),
(1412, 20, 8, 1, 'Fort Walton Beach', '', 'fort-walton-beach', '', ''),
(1413, 12, 1, 1, 'Renton', '', 'renton', '', ''),
(1414, 35, 5, 1, 'Troy', '', 'troy', '', ''),
(1415, 57, 3, 1, 'Ames', '', 'ames', '', ''),
(1416, 8, 7, 1, 'Bay Shore', '', 'bay-shore', '', ''),
(1417, 10, 1, 1, 'Pacific Grove', '', 'pacific-grove', '', ''),
(1418, 61, 6, 1, 'Starkville', '', 'starkville', '', ''),
(1419, 61, 6, 1, 'Hattiesburg', '', 'hattiesburg', '', ''),
(1420, 7, 7, 1, 'Mount Arlington', '', 'mount-arlington', '', ''),
(1421, 10, 1, 1, 'Anderson', '', 'anderson', '', ''),
(1422, 56, 2, 1, 'Soda Springs', '', 'soda-springs', '', ''),
(1423, 61, 6, 1, 'Meridian', '', 'meridian', '', ''),
(1424, 35, 5, 1, 'Cassopolis', '', 'cassopolis', '', ''),
(1425, 44, 4, 1, 'Thibodaux', '', 'thibodaux', '', ''),
(1426, 10, 1, 1, 'Studio City', '', 'studio-city', '', ''),
(1427, 32, 4, 1, 'Tahlequah', '', 'tahlequah', '', ''),
(1428, 9, 4, 1, 'Angleton', '', 'angleton', '', ''),
(1429, 10, 1, 1, 'Aromas', '', 'aromas', '', ''),
(1430, 43, 2, 1, 'Durango', '', 'durango', '', ''),
(1431, 57, 3, 1, 'Ankeny', '', 'ankeny', '', ''),
(1432, 35, 5, 1, 'Ann Arbor', '', 'ann-arbor', '', ''),
(1433, 48, 6, 1, 'Anniston', '', 'anniston', '', ''),
(1434, 31, 7, 1, 'Annville', '', 'annville', '', ''),
(1435, 13, 9, 1, 'Attleboro Falls', '', 'attleboro-falls', '', ''),
(1436, 11, 2, 1, 'New River', '', 'new-river', '', ''),
(1437, 55, 3, 1, 'Anthony', '', 'anthony', '', ''),
(1438, 31, 7, 1, 'Minersville', '', 'minersville', '', ''),
(1439, 8, 7, 1, 'Hewlett', '', 'hewlett', '', ''),
(1440, 36, 5, 1, 'Antigo', '', 'antigo', '', ''),
(1441, 8, 7, 1, 'Bayville', '', 'bayville', '', ''),
(1442, 12, 1, 1, 'Chewelah', '', 'chewelah', '', ''),
(1443, 43, 2, 1, 'Greenwood Village', '', 'greenwood-village', '', ''),
(1444, 8, 7, 1, 'Glen Head', '', 'glen-head', '', ''),
(1445, 12, 1, 1, 'Ilwaco', '', 'ilwaco', '', ''),
(1446, 11, 2, 1, 'Prescott Valley', '', 'prescott-valley', '', ''),
(1447, 12, 1, 1, 'Kenmore', '', 'kenmore', '', ''),
(1448, 9, 4, 1, 'New Braunfels', '', 'new-braunfels', '', ''),
(1449, 42, 5, 1, 'Rockford', '', 'rockford', '', ''),
(1450, 17, 3, 1, 'Waite Park', '', 'waite-park', '', ''),
(1451, 31, 7, 1, 'Manheim', '', 'manheim', '', ''),
(1452, 17, 3, 1, 'Willmar', '', 'willmar', '', ''),
(1453, 17, 3, 1, 'Lakeville', '', 'lakeville', '', ''),
(1454, 17, 3, 1, 'Long Lake', '', 'long-lake', '', ''),
(1455, 17, 3, 1, 'Albert Lea', '', 'albert-lea', '', ''),
(1456, 17, 3, 1, 'Bemidji', '', 'bemidji', '', ''),
(1457, 17, 3, 1, 'Big Lake', '', 'big-lake', '', ''),
(1458, 26, 1, 1, 'Newberg', '', 'newberg', '', ''),
(1459, 10, 1, 1, 'Grass Valley', '', 'grass-valley', '', ''),
(1460, 60, 2, 1, 'Lander', '', 'lander', '', ''),
(1461, 44, 4, 1, 'Covington', '', 'covington', '', ''),
(1462, 24, 2, 1, 'Tooele', '', 'tooele', '', ''),
(1463, 44, 4, 1, 'Mandeville', '', 'mandeville', '', ''),
(1464, 24, 2, 1, 'Riverton', '', 'riverton', '', ''),
(1465, 55, 3, 1, 'Dodge City', '', 'dodge-city', '', ''),
(1466, 19, 9, 1, 'West Lebanon', '', 'west-lebanon', '', ''),
(1467, 13, 9, 1, 'Northborough', '', 'northborough', '', ''),
(1468, 17, 3, 1, 'Gaylord', '', 'gaylord', '', ''),
(1469, 17, 3, 1, 'Virginia', '', 'virginia', '', ''),
(1470, 30, 5, 1, 'Strongsville', '', 'strongsville', '', ''),
(1471, 20, 8, 1, 'Gainesville', '', 'gainesville', '', ''),
(1472, 42, 5, 1, 'Normal', '', 'normal', '', ''),
(1473, 47, 3, 1, 'Centralia', '', 'centralia', '', ''),
(1474, 20, 8, 1, 'Apollo Beach', '', 'apollo-beach', '', ''),
(1475, 28, 9, 1, 'Warwick', '', 'warwick', '', ''),
(1476, 30, 5, 1, 'Chagrin Falls', '', 'chagrin-falls', '', ''),
(1477, 45, 2, 1, 'Tucumcari', '', 'tucumcari', '', ''),
(1478, 22, 8, 1, 'Boone', '', 'boone', '', ''),
(1479, 21, 8, 1, 'Cedar Bluff', '', 'cedar-bluff', '', ''),
(1480, 7, 7, 1, 'Cape May Court House', '', 'cape-may-court-house', '', ''),
(1481, 36, 5, 1, 'Appleton', '', 'appleton', '', ''),
(1482, 10, 1, 1, 'Aptos', '', 'aptos', '', ''),
(1483, 31, 7, 1, 'Birdsboro', '', 'birdsboro', '', ''),
(1484, 52, 4, 1, 'Mountain Home', '', 'mountain-home', '', ''),
(1485, 24, 2, 1, 'Clearfield', '', 'clearfield', '', ''),
(1486, 42, 5, 1, 'Lisle', '', 'lisle', '', ''),
(1487, 8, 7, 1, 'Arcade', '', 'arcade', '', ''),
(1488, 10, 1, 1, 'Arcadia', '', 'arcadia', '', ''),
(1489, 33, 8, 1, 'Dunbar', '', 'dunbar', '', ''),
(1490, 10, 1, 1, 'Wildomar', '', 'wildomar', '', ''),
(1491, 17, 3, 1, 'Hopkins', '', 'hopkins', '', ''),
(1492, 44, 4, 1, 'Gretna', '', 'gretna', '', ''),
(1493, 37, 6, 1, 'Paducah', '', 'paducah', '', ''),
(1494, 43, 2, 1, 'Vail', '', 'vail', '', ''),
(1495, 60, 2, 1, 'Rawlins', '', 'rawlins', '', ''),
(1496, 52, 4, 1, 'Arkadelphia', '', 'arkadelphia', '', ''),
(1497, 55, 3, 1, 'Arkansas City', '', 'arkansas-city', '', ''),
(1498, 52, 4, 1, 'Springdale', '', 'springdale', '', ''),
(1499, 52, 4, 1, 'Little Rock', '', 'little-rock', '', ''),
(1500, 52, 4, 1, 'Russellville', '', 'russellville', '', ''),
(1501, 41, 9, 1, 'West Haven', '', 'west-haven', '', ''),
(1502, 21, 8, 1, 'Palmyra', '', 'palmyra', '', ''),
(1503, 45, 2, 1, 'Artesia', '', 'artesia', '', ''),
(1504, 42, 5, 1, 'Park Forest', '', 'park-forest', '', ''),
(1505, 10, 1, 1, 'Cerritos', '', 'cerritos', '', ''),
(1506, 9, 4, 1, 'Rosenberg', '', 'rosenberg', '', ''),
(1507, 10, 1, 1, 'Tahoe City', '', 'tahoe-city', '', ''),
(1508, 38, 9, 1, 'Brownsville', '', 'brownsville', '', ''),
(1509, 21, 8, 1, 'Ashburn', '', 'ashburn', '', ''),
(1510, 22, 8, 1, 'West Jefferson', '', 'west-jefferson', '', ''),
(1511, 22, 8, 1, 'Enka', '', 'enka', '', ''),
(1512, 22, 8, 1, 'Asheville', '', 'asheville', '', ''),
(1513, 48, 6, 1, 'Ashville', '', 'ashville', '', ''),
(1514, 43, 2, 1, 'Aspen', '', 'aspen', '', ''),
(1515, 57, 3, 1, 'Cedar Rapids', '', 'cedar-rapids', '', ''),
(1516, 8, 7, 1, 'Selden', '', 'selden', '', ''),
(1517, 57, 3, 1, 'Amana', '', 'amana', '', ''),
(1518, 26, 1, 1, 'Bend', '', 'bend', '', ''),
(1519, 8, 7, 1, 'Astoria', '', 'astoria', '', ''),
(1520, 32, 4, 1, 'Claremore', '', 'claremore', '', ''),
(1521, 42, 5, 1, 'Skokie', '', 'skokie', '', ''),
(1522, 31, 7, 1, 'Brockway', '', 'brockway', '', ''),
(1523, 8, 7, 1, 'Hoosick Falls', '', 'hoosick-falls', '', ''),
(1524, 7, 7, 1, 'Sayreville', '', 'sayreville', '', ''),
(1525, 7, 7, 1, 'Monmouth Junction', '', 'monmouth-junction', '', ''),
(1526, 50, 3, 1, 'Millington', '', 'millington', '', ''),
(1527, 35, 5, 1, 'Traverse City', '', 'traverse-city', '', ''),
(1528, 13, 9, 1, 'South Yarmouth', '', 'south-yarmouth', '', ''),
(1529, 13, 9, 1, 'West Yarmouth', '', 'west-yarmouth', '', ''),
(1530, 47, 3, 1, 'Fulton', '', 'fulton', '', ''),
(1531, 44, 4, 1, 'Morgan City', '', 'morgan-city', '', ''),
(1532, 39, 5, 1, 'Crawfordsville', '', 'crawfordsville', '', ''),
(1533, 37, 6, 1, 'Owensboro', '', 'owensboro', '', ''),
(1534, 48, 6, 1, 'Athens', '', 'athens', '', ''),
(1535, 20, 8, 1, 'Wellington', '', 'wellington', '', ''),
(1536, 32, 4, 1, 'Bethany', '', 'bethany', '', ''),
(1537, 10, 1, 1, 'Fresno', '', 'fresno', '', ''),
(1538, 39, 5, 1, 'Lawrenceburg', '', 'lawrenceburg', '', ''),
(1539, 52, 4, 1, 'Monticello', '', 'monticello', '', ''),
(1540, 31, 7, 1, 'Trafford', '', 'trafford', '', ''),
(1541, 20, 8, 1, 'Weston', '', 'weston', '', ''),
(1542, 10, 1, 1, 'Woodland', '', 'woodland', '', ''),
(1543, 36, 5, 1, 'Chippewa Falls', '', 'chippewa-falls', '', ''),
(1544, 9, 4, 1, 'Addison', '', 'addison', '', ''),
(1545, 17, 3, 1, 'Osseo', '', 'osseo', '', ''),
(1546, 16, 8, 1, 'Bear', '', 'bear', '', ''),
(1547, 51, 2, 1, 'Henderson', '', 'henderson', '', ''),
(1548, 39, 5, 1, 'South Bend', '', 'south-bend', '', ''),
(1549, 36, 5, 1, 'Menasha', '', 'menasha', '', ''),
(1550, 55, 3, 1, 'Scott City', '', 'scott-city', '', ''),
(1551, 9, 4, 1, 'Harlingen', '', 'harlingen', '', ''),
(1552, 10, 1, 1, 'Paso Robles', '', 'paso-robles', '', ''),
(1553, 7, 7, 1, 'Wildwood', '', 'wildwood', '', ''),
(1554, 14, 8, 1, 'Tucker', '', 'tucker', '', ''),
(1555, 20, 8, 1, 'Fort Lauderdale', '', 'fort-lauderdale', '', ''),
(1556, 7, 7, 1, 'Colts Neck', '', 'colts-neck', '', ''),
(1557, 7, 7, 1, 'Absecon', '', 'absecon', '', ''),
(1558, 8, 7, 1, 'Atlantic Beach', '', 'atlantic-beach', '', ''),
(1559, 33, 8, 1, 'Sophia', '', 'sophia', '', ''),
(1560, 8, 7, 1, 'Spencerport', '', 'spencerport', '', ''),
(1561, 45, 2, 1, 'Espanola', '', 'espanola', '', ''),
(1562, 36, 5, 1, 'Kenosha', '', 'kenosha', '', ''),
(1563, 10, 1, 1, 'San Pedro', '', 'san-pedro', '', ''),
(1564, 19, 9, 1, 'Bath', '', 'bath', '', ''),
(1565, 35, 5, 1, 'South Haven', '', 'south-haven', '', ''),
(1566, 42, 5, 1, 'Palestine', '', 'palestine', '', ''),
(1567, 10, 1, 1, 'Atwater', '', 'atwater', '', ''),
(1568, 7, 7, 1, 'Hasbrouck Heights', '', 'hasbrouck-heights', '', ''),
(1569, 21, 8, 1, 'Fishersville', '', 'fishersville', '', ''),
(1570, 35, 5, 1, 'Ironwood', '', 'ironwood', '', ''),
(1571, 14, 8, 1, 'Cornelia', '', 'cornelia', '', ''),
(1572, 31, 7, 1, 'Beaver', '', 'beaver', '', ''),
(1573, 48, 6, 1, 'Centre', '', 'centre', '', ''),
(1574, 44, 4, 1, 'New Orleans', '', 'new-orleans', '', ''),
(1575, 38, 9, 1, 'Middlebury', '', 'middlebury', '', ''),
(1576, 10, 1, 1, 'Avila Beach', '', 'avila-beach', '', ''),
(1577, 30, 5, 1, 'Avon Lake', '', 'avon-lake', '', ''),
(1578, 50, 3, 1, 'Corryton', '', 'corryton', '', ''),
(1579, 20, 8, 1, 'Hialeah', '', 'hialeah', '', ''),
(1580, 8, 7, 1, 'Rockville Centre', '', 'rockville-centre', '', ''),
(1581, 8, 7, 1, 'New Rochelle', '', 'new-rochelle', '', ''),
(1582, 10, 1, 1, 'Chico', '', 'chico', '', ''),
(1583, 11, 2, 1, 'Gilbert', '', 'gilbert', '', ''),
(1584, 39, 5, 1, 'Jasper', '', 'jasper', '', ''),
(1585, 22, 8, 1, 'Tarboro', '', 'tarboro', '', ''),
(1586, 39, 5, 1, 'New Castle', '', 'new-castle', '', ''),
(1587, 33, 8, 1, 'Mount Hope', '', 'mount-hope', '', ''),
(1588, 23, 9, 1, 'Scarborough', '', 'scarborough', '', ''),
(1589, 35, 5, 1, 'Bay City', '', 'bay-city', '', ''),
(1590, 10, 1, 1, 'Burlingame', '', 'burlingame', '', ''),
(1591, 42, 5, 1, 'Galesburg', '', 'galesburg', '', ''),
(1592, 31, 7, 1, 'Dunmore', '', 'dunmore', '', ''),
(1593, 22, 8, 1, 'Clemmons', '', 'clemmons', '', ''),
(1594, 15, 8, 1, 'Towson', '', 'towson', '', ''),
(1595, 11, 2, 1, 'Queen Creek', '', 'queen-creek', '', ''),
(1596, 8, 7, 1, 'Silver Creek', '', 'silver-creek', '', ''),
(1597, 10, 1, 1, 'Hemet', '', 'hemet', '', ''),
(1598, 26, 1, 1, 'Coos Bay', '', 'coos-bay', '', ''),
(1599, 43, 2, 1, 'Bailey', '', 'bailey', '', ''),
(1600, 47, 3, 1, 'Licking', '', 'licking', '', ''),
(1601, 8, 7, 1, 'Cortland', '', 'cortland', '', ''),
(1602, 8, 7, 1, 'Herkimer', '', 'herkimer', '', ''),
(1603, 48, 6, 1, 'Northport', '', 'northport', '', ''),
(1604, 24, 2, 1, 'Draper', '', 'draper', '', ''),
(1605, 43, 2, 1, 'Edwards', '', 'edwards', '', ''),
(1606, 12, 1, 1, 'Bellingham', '', 'bellingham', '', ''),
(1607, 10, 1, 1, 'Placerville', '', 'placerville', '', ''),
(1608, 43, 2, 1, 'Castle Rock', '', 'castle-rock', '', ''),
(1609, 9, 4, 1, 'Mission', '', 'mission', '', ''),
(1610, 42, 5, 1, 'Carbondale', '', 'carbondale', '', ''),
(1611, 8, 7, 1, 'Bronxville', '', 'bronxville', '', ''),
(1612, 55, 3, 1, 'Wamego', '', 'wamego', '', ''),
(1613, 55, 3, 1, 'Baldwin City', '', 'baldwin-city', '', ''),
(1614, 53, 2, 1, 'Missoula', '', 'missoula', '', ''),
(1615, 61, 6, 1, 'Baldwyn', '', 'baldwyn', '', ''),
(1616, 35, 5, 1, 'Luna Pier', '', 'luna-pier', '', ''),
(1617, 15, 8, 1, 'Leonardtown', '', 'leonardtown', '', ''),
(1618, 47, 3, 1, 'Chillicothe', '', 'chillicothe', '', ''),
(1619, 7, 7, 1, 'Short Hills', '', 'short-hills', '', ''),
(1620, 7, 7, 1, 'Clark', '', 'clark', '', ''),
(1621, 55, 3, 1, 'Leawood', '', 'leawood', '', ''),
(1622, 8, 7, 1, 'Elmhurst', '', 'elmhurst', '', ''),
(1623, 7, 7, 1, 'Woodbury', '', 'woodbury', '', ''),
(1624, 12, 1, 1, 'Olympia', '', 'olympia', '', ''),
(1625, 8, 7, 1, 'Johnson City', '', 'johnson-city', '', ''),
(1626, 8, 7, 1, 'Kew Gardens', '', 'kew-gardens', '', ''),
(1627, 8, 7, 1, 'West Seneca', '', 'west-seneca', '', ''),
(1628, 8, 7, 1, 'Lake Grove', '', 'lake-grove', '', ''),
(1629, 8, 7, 1, 'Port Chester', '', 'port-chester', '', ''),
(1630, 12, 1, 1, 'Puyallup', '', 'puyallup', '', ''),
(1631, 8, 7, 1, 'Levittown', '', 'levittown', '', ''),
(1632, 8, 7, 1, 'Little Neck', '', 'little-neck', '', ''),
(1633, 8, 7, 1, 'Copiague', '', 'copiague', '', ''),
(1634, 11, 2, 1, 'Mesa', '', 'mesa', '', ''),
(1635, 7, 7, 1, 'Voorhees', '', 'voorhees', '', ''),
(1636, 7, 7, 1, 'North Bergen', '', 'north-bergen', '', ''),
(1637, 42, 5, 1, 'Schaumburg', '', 'schaumburg', '', ''),
(1638, 42, 5, 1, 'N Riverside', '', 'n-riverside', '', ''),
(1639, 42, 5, 1, 'Oak Lawn', '', 'oak-lawn', '', ''),
(1640, 42, 5, 1, 'Fairview Heights', '', 'fairview-heights', '', ''),
(1641, 9, 4, 1, 'South Houston', '', 'south-houston', '', ''),
(1642, 42, 5, 1, 'Tinley Park', '', 'tinley-park', '', ''),
(1643, 42, 5, 1, 'Matteson', '', 'matteson', '', ''),
(1644, 42, 5, 1, 'Vernon Hills', '', 'vernon-hills', '', ''),
(1645, 42, 5, 1, 'Glendale Heights', '', 'glendale-heights', '', ''),
(1646, 42, 5, 1, 'Villa Park', '', 'villa-park', '', ''),
(1647, 41, 9, 1, 'Hamden', '', 'hamden', '', ''),
(1648, 42, 5, 1, 'Countryside', '', 'countryside', '', ''),
(1649, 42, 5, 1, 'Morton Grove', '', 'morton-grove', '', ''),
(1650, 42, 5, 1, 'Deerfield', '', 'deerfield', '', ''),
(1651, 42, 5, 1, 'Calumet City', '', 'calumet-city', '', ''),
(1652, 31, 7, 1, 'Woodlyn', '', 'woodlyn', '', ''),
(1653, 31, 7, 1, 'Penn Hills', '', 'penn-hills', '', ''),
(1654, 31, 7, 1, 'Wyncote', '', 'wyncote', '', ''),
(1655, 17, 3, 1, 'Fridley', '', 'fridley', '', ''),
(1656, 31, 7, 1, 'Bethel Park', '', 'bethel-park', '', ''),
(1657, 17, 3, 1, 'Little Canada', '', 'little-canada', '', ''),
(1658, 47, 3, 1, 'Saint Ann', '', 'saint-ann', '', ''),
(1659, 14, 8, 1, 'Smyrna', '', 'smyrna', '', ''),
(1660, 47, 3, 1, 'Clayton', '', 'clayton', '', ''),
(1661, 25, 10, 1, 'Kamuela', '', 'kamuela', '', ''),
(1662, 15, 8, 1, 'Elkridge', '', 'elkridge', '', ''),
(1663, 27, 8, 1, 'Murrells Inlet', '', 'murrells-inlet', '', ''),
(1664, 9, 4, 1, 'Rockwall', '', 'rockwall', '', ''),
(1665, 52, 4, 1, 'Texarkana', '', 'texarkana', '', ''),
(1666, 7, 7, 1, 'Fairview', '', 'fairview', '', ''),
(1667, 7, 7, 1, 'Rumson', '', 'rumson', '', ''),
(1668, 20, 8, 1, 'Seminole', '', 'seminole', '', ''),
(1669, 10, 1, 1, 'Rolling Hills Estates', '', 'rolling-hills-estates', '', ''),
(1670, 7, 7, 1, 'Glassboro', '', 'glassboro', '', ''),
(1671, 12, 1, 1, 'Blaine', '', 'blaine', '', ''),
(1672, 8, 7, 1, 'Mamaroneck', '', 'mamaroneck', '', ''),
(1673, 20, 8, 1, 'Port Richey', '', 'port-richey', '', ''),
(1674, 7, 7, 1, 'Toms River', '', 'toms-river', '', ''),
(1675, 10, 1, 1, 'Desert Hot Springs', '', 'desert-hot-springs', '', ''),
(1676, 10, 1, 1, 'Paramount', '', 'paramount', '', ''),
(1677, 13, 9, 1, 'Southwick', '', 'southwick', '', ''),
(1678, 8, 7, 1, 'Long Island City', '', 'long-island-city', '', ''),
(1679, 36, 5, 1, 'Sauk City', '', 'sauk-city', '', ''),
(1680, 7, 7, 1, 'Rochelle Park', '', 'rochelle-park', '', ''),
(1681, 20, 8, 1, 'Bartow', '', 'bartow', '', ''),
(1682, 7, 7, 1, 'Hewitt', '', 'hewitt', '', ''),
(1683, 13, 9, 1, 'Stoneham', '', 'stoneham', '', ''),
(1684, 7, 7, 1, 'Collingswood', '', 'collingswood', '', ''),
(1685, 10, 1, 1, 'Laguna Beach', '', 'laguna-beach', '', ''),
(1686, 13, 9, 1, 'Dennis', '', 'dennis', '', ''),
(1687, 12, 1, 1, 'Woodinville', '', 'woodinville', '', ''),
(1688, 12, 1, 1, 'Mukilteo', '', 'mukilteo', '', ''),
(1689, 20, 8, 1, 'Pembroke Pines', '', 'pembroke-pines', '', ''),
(1690, 13, 9, 1, 'Marblehead', '', 'marblehead', '', ''),
(1691, 13, 9, 1, 'Ipswich', '', 'ipswich', '', ''),
(1692, 15, 8, 1, 'Bel Alton', '', 'bel-alton', '', ''),
(1693, 12, 1, 1, 'Lynden', '', 'lynden', '', ''),
(1694, 31, 7, 1, 'Quakertown', '', 'quakertown', '', ''),
(1695, 10, 1, 1, 'Banning', '', 'banning', '', ''),
(1696, 15, 8, 1, 'Prince Frederick', '', 'prince-frederick', '', ''),
(1697, 20, 8, 1, 'Temple Terrace', '', 'temple-terrace', '', ''),
(1698, 13, 9, 1, 'Cataumet', '', 'cataumet', '', ''),
(1699, 13, 9, 1, 'Raynham', '', 'raynham', '', ''),
(1700, 38, 9, 1, 'Brattleboro', '', 'brattleboro', '', ''),
(1701, 7, 7, 1, 'Watchung', '', 'watchung', '', ''),
(1702, 39, 5, 1, 'Elkhart', '', 'elkhart', '', ''),
(1703, 25, 10, 1, 'Captain Cook', '', 'captain-cook', '', ''),
(1704, 9, 4, 1, 'Mc Kinney', '', 'mc-kinney', '', ''),
(1705, 31, 7, 1, 'Clarion', '', 'clarion', '', ''),
(1706, 8, 7, 1, 'New City', '', 'new-city', '', ''),
(1707, 14, 8, 1, 'Commerce', '', 'commerce', '', ''),
(1708, 31, 7, 1, 'Chadds Ford', '', 'chadds-ford', '', ''),
(1709, 25, 10, 1, 'Kihei', '', 'kihei', '', ''),
(1710, 35, 5, 1, 'Dearborn Heights', '', 'dearborn-heights', '', ''),
(1711, 7, 7, 1, 'Waretown', '', 'waretown', '', ''),
(1712, 15, 8, 1, 'Jessup', '', 'jessup', '', ''),
(1713, 20, 8, 1, 'Lake Worth', '', 'lake-worth', '', ''),
(1714, 22, 8, 1, 'Matthews', '', 'matthews', '', ''),
(1715, 20, 8, 1, 'Casselberry', '', 'casselberry', '', ''),
(1716, 8, 7, 1, 'Hopewell Junction', '', 'hopewell-junction', '', ''),
(1717, 20, 8, 1, 'Pinellas Park', '', 'pinellas-park', '', ''),
(1718, 7, 7, 1, 'Bedminster', '', 'bedminster', '', ''),
(1719, 22, 8, 1, 'Gastonia', '', 'gastonia', '', ''),
(1720, 7, 7, 1, 'Budd Lake', '', 'budd-lake', '', ''),
(1721, 20, 8, 1, 'Pinecrest', '', 'pinecrest', '', ''),
(1722, 8, 7, 1, 'Guilderland', '', 'guilderland', '', ''),
(1723, 47, 3, 1, 'Creve Coeur', '', 'creve-coeur', '', ''),
(1724, 13, 9, 1, 'Winthrop', '', 'winthrop', '', ''),
(1725, 41, 9, 1, 'Newington', '', 'newington', '', ''),
(1726, 38, 9, 1, 'Rutland', '', 'rutland', '', ''),
(1727, 23, 9, 1, 'Belfast', '', 'belfast', '', ''),
(1728, 41, 9, 1, 'Wilton', '', 'wilton', '', ''),
(1729, 38, 9, 1, 'Montpelier', '', 'montpelier', '', ''),
(1730, 7, 7, 1, 'Cranbury', '', 'cranbury', '', ''),
(1731, 7, 7, 1, 'Franklin Lakes', '', 'franklin-lakes', '', ''),
(1732, 13, 9, 1, 'Harwich Port', '', 'harwich-port', '', ''),
(1733, 21, 8, 1, 'Warrenton', '', 'warrenton', '', ''),
(1734, 35, 5, 1, 'Dearborn', '', 'dearborn', '', ''),
(1735, 13, 9, 1, 'Shelburne Falls', '', 'shelburne-falls', '', ''),
(1736, 8, 7, 1, 'Somers', '', 'somers', '', ''),
(1737, 28, 9, 1, 'North Providence', '', 'north-providence', '', ''),
(1738, 31, 7, 1, 'Reeders', '', 'reeders', '', ''),
(1739, 8, 7, 1, 'Armonk', '', 'armonk', '', ''),
(1740, 41, 9, 1, 'Collinsville', '', 'collinsville', '', ''),
(1741, 38, 9, 1, 'Lyndonville', '', 'lyndonville', '', ''),
(1742, 13, 9, 1, 'Norton', '', 'norton', '', ''),
(1743, 35, 5, 1, 'Saginaw', '', 'saginaw', '', ''),
(1744, 8, 7, 1, 'Suffern', '', 'suffern', '', ''),
(1745, 36, 5, 1, 'Greenfield', '', 'greenfield', '', ''),
(1746, 21, 8, 1, 'Crimora', '', 'crimora', '', ''),
(1747, 15, 8, 1, 'Potomac', '', 'potomac', '', ''),
(1748, 21, 8, 1, 'Onancock', '', 'onancock', '', ''),
(1749, 24, 2, 1, 'Ogden', '', 'ogden', '', ''),
(1750, 13, 9, 1, 'Northbridge', '', 'northbridge', '', ''),
(1751, 8, 7, 1, 'Seneca Falls', '', 'seneca-falls', '', ''),
(1752, 31, 7, 1, 'Ardmore', '', 'ardmore', '', ''),
(1753, 8, 7, 1, 'Newark Valley', '', 'newark-valley', '', ''),
(1754, 43, 2, 1, 'Fort Collins', '', 'fort-collins', '', ''),
(1755, 22, 8, 1, 'Louisburg', '', 'louisburg', '', ''),
(1756, 35, 5, 1, 'Grand Haven', '', 'grand-haven', '', ''),
(1757, 16, 8, 1, 'Lewes', '', 'lewes', '', ''),
(1758, 10, 1, 1, 'Belmont', '', 'belmont', '', ''),
(1759, 42, 5, 1, 'Romeoville', '', 'romeoville', '', ''),
(1760, 20, 8, 1, 'Royal Palm Beach', '', 'royal-palm-beach', '', ''),
(1761, 31, 7, 1, 'Lewistown', '', 'lewistown', '', ''),
(1762, 32, 4, 1, 'Langley', '', 'langley', '', ''),
(1763, 51, 2, 1, 'Ely', '', 'ely', '', ''),
(1764, 8, 7, 1, 'Beacon', '', 'beacon', '', ''),
(1765, 7, 7, 1, 'South River', '', 'south-river', '', ''),
(1766, 9, 4, 1, 'Haltom City', '', 'haltom-city', '', ''),
(1767, 8, 7, 1, 'Hempstead', '', 'hempstead', '', ''),
(1768, 13, 9, 1, 'Boxford', '', 'boxford', '', ''),
(1769, 42, 5, 1, 'Evanston', '', 'evanston', '', ''),
(1770, 7, 7, 1, 'Denville', '', 'denville', '', ''),
(1771, 8, 7, 1, 'Ozone Park', '', 'ozone-park', '', ''),
(1772, 60, 2, 1, 'Cody', '', 'cody', '', ''),
(1773, 13, 9, 1, 'Tyngsboro', '', 'tyngsboro', '', ''),
(1774, 14, 8, 1, 'Zebulon', '', 'zebulon', '', ''),
(1775, 27, 8, 1, 'Irmo', '', 'irmo', '', ''),
(1776, 10, 1, 1, 'NEWHALL', '', 'newhall', '', ''),
(1777, 53, 2, 1, 'Kalispell', '', 'kalispell', '', ''),
(1778, 12, 1, 1, 'Ephrata', '', 'ephrata', '', ''),
(1779, 10, 1, 1, 'North Hollywood', '', 'north-hollywood', '', ''),
(1780, 12, 1, 1, 'Tumwater', '', 'tumwater', '', ''),
(1781, 42, 5, 1, 'Morris', '', 'morris', '', ''),
(1782, 7, 7, 1, 'Parsippany', '', 'parsippany', '', ''),
(1783, 9, 4, 1, 'Booker', '', 'booker', '', ''),
(1784, 47, 3, 1, 'Cameron', '', 'cameron', '', ''),
(1785, 10, 1, 1, 'Reseda', '', 'reseda', '', ''),
(1786, 39, 5, 1, 'Logansport', '', 'logansport', '', ''),
(1787, 8, 7, 1, 'Ronkonkoma', '', 'ronkonkoma', '', ''),
(1788, 17, 3, 1, 'Cannon Falls', '', 'cannon-falls', '', ''),
(1789, 26, 1, 1, 'Scappoose', '', 'scappoose', '', ''),
(1790, 53, 2, 1, 'Seeley Lake', '', 'seeley-lake', '', ''),
(1791, 14, 8, 1, 'Cumming', '', 'cumming', '', ''),
(1792, 50, 3, 1, 'Chattanooga', '', 'chattanooga', '', ''),
(1793, 53, 2, 1, 'Whitefish', '', 'whitefish', '', ''),
(1794, 42, 5, 1, 'La Grange Park', '', 'la-grange-park', '', ''),
(1795, 35, 5, 1, 'Essexville', '', 'essexville', '', ''),
(1796, 13, 9, 1, 'Needham Heights', '', 'needham-heights', '', ''),
(1797, 10, 1, 1, 'San Andreas', '', 'san-andreas', '', ''),
(1798, 9, 4, 1, 'Pharr', '', 'pharr', '', ''),
(1799, 10, 1, 1, 'Hesperia', '', 'hesperia', '', ''),
(1800, 10, 1, 1, 'San Clemente', '', 'san-clemente', '', ''),
(1801, 31, 7, 1, 'Bala Cynwyd', '', 'bala-cynwyd', '', ''),
(1802, 13, 9, 1, 'Shirley', '', 'shirley', '', ''),
(1803, 13, 9, 1, 'Allston', '', 'allston', '', ''),
(1804, 8, 7, 1, 'Norwich', '', 'norwich', '', ''),
(1805, 42, 5, 1, 'Wheaton', '', 'wheaton', '', ''),
(1806, 23, 9, 1, 'Westbrook', '', 'westbrook', '', ''),
(1807, 31, 7, 1, 'Valley Forge', '', 'valley-forge', '', ''),
(1808, 20, 8, 1, 'Hallandale', '', 'hallandale', '', ''),
(1809, 35, 5, 1, 'West Bloomfield', '', 'west-bloomfield', '', ''),
(1810, 20, 8, 1, 'Tarpon Springs', '', 'tarpon-springs', '', ''),
(1811, 13, 9, 1, 'Hyannis', '', 'hyannis', '', ''),
(1812, 15, 8, 1, 'Chevy Chase', '', 'chevy-chase', '', ''),
(1813, 7, 7, 1, 'Moonachie', '', 'moonachie', '', ''),
(1814, 48, 6, 1, 'Pelham', '', 'pelham', '', ''),
(1815, 8, 7, 1, 'Cobleskill', '', 'cobleskill', '', ''),
(1816, 8, 7, 1, 'Canajoharie', '', 'canajoharie', '', ''),
(1817, 30, 5, 1, 'Pickerington', '', 'pickerington', '', ''),
(1818, 31, 7, 1, 'Carlisle', '', 'carlisle', '', ''),
(1819, 31, 7, 1, 'Sciota', '', 'sciota', '', ''),
(1820, 7, 7, 1, 'Rio Grande', '', 'rio-grande', '', ''),
(1821, 30, 5, 1, 'Chesterland', '', 'chesterland', '', ''),
(1822, 37, 6, 1, 'Brooksville', '', 'brooksville', '', ''),
(1823, 10, 1, 1, 'San Lorenzo', '', 'san-lorenzo', '', ''),
(1824, 17, 3, 1, 'Cedar', '', 'cedar', '', ''),
(1825, 50, 3, 1, 'Knoxville', '', 'knoxville', '', ''),
(1826, 31, 7, 1, 'Jonestown', '', 'jonestown', '', ''),
(1827, 11, 2, 1, 'Paradise Valley', '', 'paradise-valley', '', ''),
(1828, 10, 1, 1, 'Duarte', '', 'duarte', '', ''),
(1829, 23, 9, 1, 'Boothbay Harbor', '', 'boothbay-harbor', '', ''),
(1830, 8, 7, 1, 'Floral Park', '', 'floral-park', '', ''),
(1831, 20, 8, 1, 'Coral Gables', '', 'coral-gables', '', ''),
(1832, 10, 1, 1, 'Woodyear', '', 'woodyear', '', ''),
(1833, 7, 7, 1, 'Riverdale', '', 'riverdale', '', ''),
(1834, 15, 8, 1, 'North Bethesda', '', 'north-bethesda', '', ''),
(1835, 32, 4, 1, 'Shawnee', '', 'shawnee', '', ''),
(1836, 15, 8, 1, 'Catonsville', '', 'catonsville', '', ''),
(1837, 43, 2, 1, 'Conifer', '', 'conifer', '', ''),
(1838, 10, 1, 1, 'Carson', '', 'carson', '', ''),
(1839, 42, 5, 1, 'Northbrook', '', 'northbrook', '', ''),
(1840, 15, 8, 1, 'Deale', '', 'deale', '', ''),
(1841, 31, 7, 1, 'Hummelstown', '', 'hummelstown', '', ''),
(1842, 12, 1, 1, 'South Prairie', '', 'south-prairie', '', ''),
(1843, 31, 7, 1, 'Bloomsburg', '', 'bloomsburg', '', ''),
(1844, 31, 7, 1, 'Lititz', '', 'lititz', '', ''),
(1845, 14, 8, 1, 'Helen', '', 'helen', '', ''),
(1846, 43, 2, 1, 'Golden', '', 'golden', '', ''),
(1847, 21, 8, 1, 'Hopewell', '', 'hopewell', '', ''),
(1848, 7, 7, 1, 'Cape May', '', 'cape-may', '', ''),
(1849, 33, 8, 1, 'Wheeling', '', 'wheeling', '', ''),
(1850, 11, 2, 1, 'Apache Junction', '', 'apache-junction', '', ''),
(1851, 13, 9, 1, 'Sturbridge', '', 'sturbridge', '', ''),
(1852, 8, 7, 1, 'Mountainville', '', 'mountainville', '', ''),
(1853, 25, 10, 1, 'Volcano', '', 'volcano', '', ''),
(1854, 13, 9, 1, 'Harvard', '', 'harvard', '', ''),
(1855, 30, 5, 1, 'Lorain', '', 'lorain', '', ''),
(1856, 8, 7, 1, 'Willsboro', '', 'willsboro', '', ''),
(1857, 8, 7, 1, 'Southold', '', 'southold', '', ''),
(1858, 22, 8, 1, 'Fort Bragg', '', 'fort-bragg', '', ''),
(1859, 31, 7, 1, 'Lansford', '', 'lansford', '', ''),
(1860, 9, 4, 1, 'Emory', '', 'emory', '', ''),
(1861, 10, 1, 1, 'Stanton', '', 'stanton', '', ''),
(1862, 20, 8, 1, 'Fort Pierce', '', 'fort-pierce', '', ''),
(1863, 31, 7, 1, 'Gettysburg', '', 'gettysburg', '', ''),
(1864, 45, 2, 1, 'Zuni', '', 'zuni', '', ''),
(1865, 47, 3, 1, 'Kirksville', '', 'kirksville', '', ''),
(1866, 55, 3, 1, 'McPherson', '', 'mcpherson', '', ''),
(1867, 23, 9, 1, 'Bar Harbor', '', 'bar-harbor', '', ''),
(1868, 52, 4, 1, 'Eureka Springs', '', 'eureka-springs', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(1869, 39, 5, 1, 'Mooresville', '', 'mooresville', '', ''),
(1870, 39, 5, 1, 'Muncie', '', 'muncie', '', ''),
(1871, 15, 8, 1, 'Accokeek', '', 'accokeek', '', ''),
(1872, 57, 3, 1, 'Ackley', '', 'ackley', '', ''),
(1873, 35, 5, 1, 'Ada', '', 'ada', '', ''),
(1874, 12, 1, 1, 'Moses Lake', '', 'moses-lake', '', ''),
(1875, 30, 5, 1, 'West Union', '', 'west-union', '', ''),
(1876, 43, 2, 1, 'Brighton', '', 'brighton', '', ''),
(1877, 49, 3, 1, 'Deadwood', '', 'deadwood', '', ''),
(1878, 8, 7, 1, 'Elizabethtown', '', 'elizabethtown', '', ''),
(1879, 15, 8, 1, 'Mardela Springs', '', 'mardela-springs', '', ''),
(1880, 26, 1, 1, 'Baker City', '', 'baker-city', '', ''),
(1881, 35, 5, 1, 'Battle Creek', '', 'battle-creek', '', ''),
(1882, 14, 8, 1, 'Newnan', '', 'newnan', '', ''),
(1883, 15, 8, 1, 'La Plata', '', 'la-plata', '', ''),
(1884, 30, 5, 1, 'Xenia', '', 'xenia', '', ''),
(1885, 13, 9, 1, 'Nantucket', '', 'nantucket', '', ''),
(1886, 17, 3, 1, 'Afton', '', 'afton', '', ''),
(1887, 14, 8, 1, 'Homerville', '', 'homerville', '', ''),
(1888, 26, 1, 1, 'Agness', '', 'agness', '', ''),
(1889, 55, 3, 1, 'Bonner Springs', '', 'bonner-springs', '', ''),
(1890, 53, 2, 1, 'Fort Benton', '', 'fort-benton', '', ''),
(1891, 20, 8, 1, 'Clewiston', '', 'clewiston', '', ''),
(1892, 36, 5, 1, 'Colfax', '', 'colfax', '', ''),
(1893, 19, 9, 1, 'Warner', '', 'warner', '', ''),
(1894, 27, 8, 1, 'Aiken', '', 'aiken', '', ''),
(1895, 20, 8, 1, 'Shalimar', '', 'shalimar', '', ''),
(1896, 57, 3, 1, 'Ottumwa', '', 'ottumwa', '', ''),
(1897, 10, 1, 1, 'Alameda', '', 'alameda', '', ''),
(1898, 48, 6, 1, 'Wetumpka', '', 'wetumpka', '', ''),
(1899, 48, 6, 1, 'Fort Payne', '', 'fort-payne', '', ''),
(1900, 48, 6, 1, 'Dora', '', 'dora', '', ''),
(1901, 34, 1, 1, 'Elmendorf Afb', '', 'elmendorf-afb', '', ''),
(1902, 34, 1, 1, 'Juneau', '', 'juneau', '', ''),
(1903, 35, 5, 1, 'Lanse', '', 'lanse', '', ''),
(1904, 35, 5, 1, 'Albion', '', 'albion', '', ''),
(1905, 35, 5, 1, 'Alden', '', 'alden', '', ''),
(1906, 13, 9, 1, 'Duxbury', '', 'duxbury', '', ''),
(1907, 21, 8, 1, 'Aldie', '', 'aldie', '', ''),
(1908, 58, 3, 1, 'Elmwood', '', 'elmwood', '', ''),
(1909, 41, 9, 1, 'Ridgefield', '', 'ridgefield', '', ''),
(1910, 50, 3, 1, 'Henning', '', 'henning', '', ''),
(1911, 25, 10, 1, 'Kahului', '', 'kahului', '', ''),
(1912, 24, 2, 1, 'Park City', '', 'park-city', '', ''),
(1913, 32, 4, 1, 'Cherokee', '', 'cherokee', '', ''),
(1914, 35, 5, 1, 'Flint', '', 'flint', '', ''),
(1915, 35, 5, 1, 'Algonac', '', 'algonac', '', ''),
(1916, 10, 1, 1, 'Alhambra', '', 'alhambra', '', ''),
(1917, 60, 2, 1, 'Laramie', '', 'laramie', '', ''),
(1918, 61, 6, 1, 'Bay Saint Louis', '', 'bay-saint-louis', '', ''),
(1919, 48, 6, 1, 'Aliceville', '', 'aliceville', '', ''),
(1920, 55, 3, 1, 'Pratt', '', 'pratt', '', ''),
(1921, 7, 7, 1, 'Farmingdale', '', 'farmingdale', '', ''),
(1922, 9, 4, 1, 'Woodville', '', 'woodville', '', ''),
(1923, 53, 2, 1, 'Saint Ignatius', '', 'saint-ignatius', '', ''),
(1924, 31, 7, 1, 'Tarentum', '', 'tarentum', '', ''),
(1925, 35, 5, 1, 'Fennville', '', 'fennville', '', ''),
(1926, 35, 5, 1, 'Allegan', '', 'allegan', '', ''),
(1927, 30, 5, 1, 'Lima', '', 'lima', '', ''),
(1928, 55, 3, 1, 'Iola', '', 'iola', '', ''),
(1929, 8, 7, 1, 'Flushing', '', 'flushing', '', ''),
(1930, 58, 3, 1, 'Alliance', '', 'alliance', '', ''),
(1931, 31, 7, 1, 'Greencastle', '', 'greencastle', '', ''),
(1932, 22, 8, 1, 'Pisgah Forest', '', 'pisgah-forest', '', ''),
(1933, 10, 1, 1, 'Markleeville', '', 'markleeville', '', ''),
(1934, 26, 1, 1, 'Waldport', '', 'waldport', '', ''),
(1935, 10, 1, 1, 'Dinuba', '', 'dinuba', '', ''),
(1936, 10, 1, 1, 'Orland', '', 'orland', '', ''),
(1937, 42, 5, 1, 'Alton', '', 'alton', '', ''),
(1938, 52, 4, 1, 'Altus', '', 'altus', '', ''),
(1939, 34, 1, 1, 'Kodiak', '', 'kodiak', '', ''),
(1940, 30, 5, 1, 'Mason', '', 'mason', '', ''),
(1941, 10, 1, 1, 'Amador City', '', 'amador-city', '', ''),
(1942, 8, 7, 1, 'Amagansett', '', 'amagansett', '', ''),
(1943, 19, 9, 1, 'Gilford', '', 'gilford', '', ''),
(1944, 41, 9, 1, 'Moodus', '', 'moodus', '', ''),
(1945, 42, 5, 1, 'Amboy', '', 'amboy', '', ''),
(1946, 55, 3, 1, 'Atchison', '', 'atchison', '', ''),
(1947, 45, 2, 1, 'Alamogordo', '', 'alamogordo', '', ''),
(1948, 34, 1, 1, 'Haines', '', 'haines', '', ''),
(1949, 8, 7, 1, 'Cooperstown', '', 'cooperstown', '', ''),
(1950, 37, 6, 1, 'Horse Cave', '', 'horse-cave', '', ''),
(1951, 22, 8, 1, 'Asheboro', '', 'asheboro', '', ''),
(1952, 12, 1, 1, 'Toppenish', '', 'toppenish', '', ''),
(1953, 7, 7, 1, 'Haledon', '', 'haledon', '', ''),
(1954, 8, 7, 1, 'Croghan', '', 'croghan', '', ''),
(1955, 31, 7, 1, 'Intercourse', '', 'intercourse', '', ''),
(1956, 10, 1, 1, 'South El Monte', '', 'south-el-monte', '', ''),
(1957, 8, 7, 1, 'Uniondale', '', 'uniondale', '', ''),
(1958, 50, 3, 1, 'Oak Ridge', '', 'oak-ridge', '', ''),
(1959, 47, 3, 1, 'Branson', '', 'branson', '', ''),
(1960, 24, 2, 1, 'Wellsville', '', 'wellsville', '', ''),
(1961, 11, 2, 1, 'Dragoon', '', 'dragoon', '', ''),
(1962, 30, 5, 1, 'South Amherst', '', 'south-amherst', '', ''),
(1963, 42, 5, 1, 'Arcola', '', 'arcola', '', ''),
(1964, 20, 8, 1, 'Key West', '', 'key-west', '', ''),
(1965, 32, 4, 1, 'Elk City', '', 'elk-city', '', ''),
(1966, 32, 4, 1, 'Anadarko', '', 'anadarko', '', ''),
(1967, 57, 3, 1, 'Anamosa', '', 'anamosa', '', ''),
(1968, 43, 2, 1, 'Dolores', '', 'dolores', '', ''),
(1969, 52, 4, 1, 'Booneville', '', 'booneville', '', ''),
(1970, 57, 3, 1, 'West Burlington', '', 'west-burlington', '', ''),
(1971, 24, 2, 1, 'Leeds', '', 'leeds', '', ''),
(1972, 12, 1, 1, 'Anderson Island', '', 'anderson-island', '', ''),
(1973, 36, 5, 1, 'Ephraim', '', 'ephraim', '', ''),
(1974, 36, 5, 1, 'Sister Bay', '', 'sister-bay', '', ''),
(1975, 10, 1, 1, 'Boonville', '', 'boonville', '', ''),
(1976, 21, 8, 1, 'Pearisburg', '', 'pearisburg', '', ''),
(1977, 36, 5, 1, 'Beloit', '', 'beloit', '', ''),
(1978, 10, 1, 1, 'Angels Camp', '', 'angels-camp', '', ''),
(1979, 13, 9, 1, 'Lee', '', 'lee', '', ''),
(1980, 60, 2, 1, 'Newcastle', '', 'newcastle', '', ''),
(1981, 19, 9, 1, 'Meredith', '', 'meredith', '', ''),
(1982, 9, 4, 1, 'Fort Stockton', '', 'fort-stockton', '', ''),
(1983, 17, 3, 1, 'Anoka', '', 'anoka', '', ''),
(1984, 35, 5, 1, 'Caro', '', 'caro', '', ''),
(1985, 9, 4, 1, 'Anson', '', 'anson', '', ''),
(1986, 31, 7, 1, 'Freeland', '', 'freeland', '', ''),
(1987, 57, 3, 1, 'Cedar Falls', '', 'cedar-falls', '', ''),
(1988, 12, 1, 1, 'Curlew', '', 'curlew', '', ''),
(1989, 47, 3, 1, 'Sullivan', '', 'sullivan', '', ''),
(1990, 42, 5, 1, 'Union', '', 'union', '', ''),
(1991, 9, 4, 1, 'Corsicana', '', 'corsicana', '', ''),
(1992, 9, 4, 1, 'Waco', '', 'waco', '', ''),
(1993, 9, 4, 1, 'Elm Mott', '', 'elm-mott', '', ''),
(1994, 31, 7, 1, 'Delaware Water Gap', '', 'delaware-water-gap', '', ''),
(1995, 11, 2, 1, 'Superior', '', 'superior', '', ''),
(1996, 12, 1, 1, 'Eastsound', '', 'eastsound', '', ''),
(1997, 56, 2, 1, 'Moscow', '', 'moscow', '', ''),
(1998, 57, 3, 1, 'Centerville', '', 'centerville', '', ''),
(1999, 20, 8, 1, 'Ocala', '', 'ocala', '', ''),
(2000, 13, 9, 1, 'Buzzards Bay', '', 'buzzards-bay', '', ''),
(2001, 32, 4, 1, 'Mcalester', '', 'mcalester', '', ''),
(2002, 35, 5, 1, 'Au Gres', '', 'au-gres', '', ''),
(2003, 43, 2, 1, 'Idaho Springs', '', 'idaho-springs', '', ''),
(2004, 11, 2, 1, 'Hereford', '', 'hereford', '', ''),
(2005, 11, 2, 1, 'Flagstaff', '', 'flagstaff', '', ''),
(2006, 52, 4, 1, 'Smackover', '', 'smackover', '', ''),
(2007, 52, 4, 1, 'Gillett', '', 'gillett', '', ''),
(2008, 32, 4, 1, 'Catoosa', '', 'catoosa', '', ''),
(2009, 42, 5, 1, 'Arlington Heights', '', 'arlington-heights', '', ''),
(2010, 31, 7, 1, 'Kittanning', '', 'kittanning', '', ''),
(2011, 9, 4, 1, 'Claude', '', 'claude', '', ''),
(2012, 45, 2, 1, 'Pecos', '', 'pecos', '', ''),
(2013, 13, 9, 1, 'Pittsfield', '', 'pittsfield', '', ''),
(2014, 35, 5, 1, 'Kalamazoo', '', 'kalamazoo', '', ''),
(2015, 42, 5, 1, 'Roselle', '', 'roselle', '', ''),
(2016, 9, 4, 1, 'Beaumont', '', 'beaumont', '', ''),
(2017, 20, 8, 1, 'Port Orange', '', 'port-orange', '', ''),
(2018, 8, 7, 1, 'Old Forge', '', 'old-forge', '', ''),
(2019, 11, 2, 1, 'Sahuarita', '', 'sahuarita', '', ''),
(2020, 30, 5, 1, 'Ashtabula', '', 'ashtabula', '', ''),
(2021, 9, 4, 1, 'Galveston', '', 'galveston', '', ''),
(2022, 36, 5, 1, 'Green Bay', '', 'green-bay', '', ''),
(2023, 10, 1, 1, 'Atascadero', '', 'atascadero', '', ''),
(2024, 7, 7, 1, 'Atlantic Highlands', '', 'atlantic-highlands', '', ''),
(2025, 32, 4, 1, 'Atoka', '', 'atoka', '', ''),
(2026, 13, 9, 1, 'Attleboro', '', 'attleboro', '', ''),
(2027, 47, 3, 1, 'Mexico', '', 'mexico', '', ''),
(2028, 20, 8, 1, 'Clearwater Beach', '', 'clearwater-beach', '', ''),
(2029, 30, 5, 1, 'Wapakoneta', '', 'wapakoneta', '', ''),
(2030, 30, 5, 1, 'Saint Marys', '', 'saint-marys', '', ''),
(2031, 42, 5, 1, 'Rock Island', '', 'rock-island', '', ''),
(2032, 20, 8, 1, 'Weirsdale', '', 'weirsdale', '', ''),
(2033, 8, 7, 1, 'Holbrook', '', 'holbrook', '', ''),
(2034, 49, 3, 1, 'Vermillion', '', 'vermillion', '', ''),
(2035, 48, 6, 1, 'Prattville', '', 'prattville', '', ''),
(2036, 35, 5, 1, 'Au Train', '', 'au-train', '', ''),
(2037, 22, 8, 1, 'Smithfield', '', 'smithfield', '', ''),
(2038, 22, 8, 1, 'Dunn', '', 'dunn', '', ''),
(2039, 22, 8, 1, 'Newland', '', 'newland', '', ''),
(2040, 26, 1, 1, 'Corvallis', '', 'corvallis', '', ''),
(2041, 30, 5, 1, 'Granville', '', 'granville', '', ''),
(2042, 10, 1, 1, 'Santa Paula', '', 'santa-paula', '', ''),
(2043, 9, 4, 1, 'Uvalde', '', 'uvalde', '', ''),
(2044, 21, 8, 1, 'Altavista', '', 'altavista', '', ''),
(2045, 20, 8, 1, 'Avon Park', '', 'avon-park', '', ''),
(2046, 45, 2, 1, 'Aztec', '', 'aztec', '', ''),
(2047, 9, 4, 1, 'Teague', '', 'teague', '', ''),
(2048, 13, 9, 1, 'Rockport', '', 'rockport', '', ''),
(2049, 32, 4, 1, 'Muskogee', '', 'muskogee', '', ''),
(2050, 21, 8, 1, 'Surry', '', 'surry', '', ''),
(2051, 36, 5, 1, 'Shullsburg', '', 'shullsburg', '', ''),
(2052, 22, 8, 1, 'Badin', '', 'badin', '', ''),
(2053, 59, 3, 1, 'Mooreton', '', 'mooreton', '', ''),
(2054, 31, 7, 1, 'Boyertown', '', 'boyertown', '', ''),
(2055, 25, 10, 1, 'Wailuku', '', 'wailuku', '', ''),
(2056, 12, 1, 1, 'Bainbridge Island', '', 'bainbridge-island', '', ''),
(2057, 53, 2, 1, 'Martinsdale', '', 'martinsdale', '', ''),
(2058, 55, 3, 1, 'Liberal', '', 'liberal', '', ''),
(2059, 20, 8, 1, 'Baker', '', 'baker', '', ''),
(2060, 10, 1, 1, 'Coalinga', '', 'coalinga', '', ''),
(2061, 43, 2, 1, 'Estes Park', '', 'estes-park', '', ''),
(2062, 48, 6, 1, 'Foley', '', 'foley', '', ''),
(2063, 15, 8, 1, 'Key Hwy', '', 'key-hwy', '', ''),
(2064, 35, 5, 1, 'Romeo', '', 'romeo', '', ''),
(2065, 10, 1, 1, 'Spring Valley', '', 'spring-valley', '', ''),
(2066, 26, 1, 1, 'Bandon', '', 'bandon', '', ''),
(2067, 56, 2, 1, 'Pocatello', '', 'pocatello', '', ''),
(2068, 35, 5, 1, 'Baraga', '', 'baraga', '', ''),
(2069, 30, 5, 1, 'Canal Winchester', '', 'canal-winchester', '', ''),
(2070, 33, 8, 1, 'Philippi', '', 'philippi', '', ''),
(2071, 41, 9, 1, 'Cheshire', '', 'cheshire', '', ''),
(2072, 8, 7, 1, 'Fredonia', '', 'fredonia', '', ''),
(2073, 39, 5, 1, 'Michigan City', '', 'michigan-city', '', ''),
(2074, 37, 6, 1, 'Barlow', '', 'barlow', '', ''),
(2075, 57, 3, 1, 'South Amana', '', 'south-amana', '', ''),
(2076, 9, 4, 1, 'Glen Rose', '', 'glen-rose', '', ''),
(2077, 7, 7, 1, 'Tuckerton', '', 'tuckerton', '', ''),
(2078, 59, 3, 1, 'Valley City', '', 'valley-city', '', ''),
(2079, 31, 7, 1, 'Merion Station', '', 'merion-station', '', ''),
(2080, 41, 9, 1, 'Southington', '', 'southington', '', ''),
(2081, 41, 9, 1, 'Bridgeport', '', 'bridgeport', '', ''),
(2082, 27, 8, 1, 'Barnwell', '', 'barnwell', '', ''),
(2083, 16, 8, 1, 'Frederica', '', 'frederica', '', ''),
(2084, 19, 9, 1, 'New Ipswich', '', 'new-ipswich', '', ''),
(2085, 21, 8, 1, 'Machipongo', '', 'machipongo', '', ''),
(2086, 9, 4, 1, 'Eola', '', 'eola', '', ''),
(2087, 13, 9, 1, 'Amesbury', '', 'amesbury', '', ''),
(2088, 55, 3, 1, 'Great Bend', '', 'great-bend', '', ''),
(2089, 14, 8, 1, 'Cartersville', '', 'cartersville', '', ''),
(2090, 20, 8, 1, 'Miami Beach', '', 'miami-beach', '', ''),
(2091, 9, 4, 1, 'Bastrop', '', 'bastrop', '', ''),
(2092, 42, 5, 1, 'Batavia', '', 'batavia', '', ''),
(2093, 50, 3, 1, 'Lookout Mountain', '', 'lookout-mountain', '', ''),
(2094, 52, 4, 1, 'Bauxite', '', 'bauxite', '', ''),
(2095, 55, 3, 1, 'Baxter Springs', '', 'baxter-springs', '', ''),
(2096, 10, 1, 1, 'Sausalito', '', 'sausalito', '', ''),
(2097, 10, 1, 1, 'Rio Vista', '', 'rio-vista', '', ''),
(2098, 9, 4, 1, 'Seabrook', '', 'seabrook', '', ''),
(2099, 15, 8, 1, 'North Beach', '', 'north-beach', '', ''),
(2100, 9, 4, 1, 'Baytown', '', 'baytown', '', ''),
(2101, 61, 6, 1, 'Indianola', '', 'indianola', '', ''),
(2102, 51, 2, 1, 'Beatty', '', 'beatty', '', ''),
(2103, 44, 4, 1, 'Deridder', '', 'deridder', '', ''),
(2104, 61, 6, 1, 'Biloxi', '', 'biloxi', '', ''),
(2105, 35, 5, 1, 'Beaver Island', '', 'beaver-island', '', ''),
(2106, 53, 2, 1, 'Dillon', '', 'dillon', '', ''),
(2107, 17, 3, 1, 'Detroit Lakes', '', 'detroit-lakes', '', ''),
(2108, 13, 9, 1, 'Becket', '', 'becket', '', ''),
(2109, 11, 2, 1, 'Casa Grande', '', 'casa-grande', '', ''),
(2110, 57, 3, 1, 'Elk Horn', '', 'elk-horn', '', ''),
(2111, 9, 4, 1, 'Beeville', '', 'beeville', '', ''),
(2112, 42, 5, 1, 'Moline', '', 'moline', '', ''),
(2113, 22, 8, 1, 'Belhaven', '', 'belhaven', '', ''),
(2114, 9, 4, 1, 'Belton', '', 'belton', '', ''),
(2115, 37, 6, 1, 'Middlesboro', '', 'middlesboro', '', ''),
(2116, 35, 5, 1, 'Belleville', '', 'belleville', '', ''),
(2117, 8, 7, 1, 'Bellport', '', 'bellport', '', ''),
(2118, 8, 7, 1, 'Old Chatham', '', 'old-chatham', '', ''),
(2119, 10, 1, 1, 'Benicia', '', 'benicia', '', ''),
(2120, 58, 3, 1, 'Crete', '', 'crete', '', ''),
(2121, 57, 3, 1, 'West Des Moines', '', 'west-des-moines', '', ''),
(2122, 38, 9, 1, 'Bennington', '', 'bennington', '', ''),
(2123, 11, 2, 1, 'Benson', '', 'benson', '', ''),
(2124, 12, 1, 1, 'Prosser', '', 'prosser', '', ''),
(2125, 17, 3, 1, 'Sauk Rapids', '', 'sauk-rapids', '', ''),
(2126, 47, 3, 1, 'Warsaw', '', 'warsaw', '', ''),
(2127, 52, 4, 1, 'Bentonville', '', 'bentonville', '', ''),
(2128, 41, 9, 1, 'Tolland', '', 'tolland', '', ''),
(2129, 22, 8, 1, 'Four Oaks', '', 'four-oaks', '', ''),
(2130, 35, 5, 1, 'Benzonia', '', 'benzonia', '', ''),
(2131, 30, 5, 1, 'Berea', '', 'berea', '', ''),
(2132, 7, 7, 1, 'Dumont', '', 'dumont', '', ''),
(2133, 36, 5, 1, 'Neenah', '', 'neenah', '', ''),
(2134, 10, 1, 1, 'Berkeley', '', 'berkeley', '', ''),
(2135, 27, 8, 1, 'Moncks Corner', '', 'moncks-corner', '', ''),
(2136, 13, 9, 1, 'Stockbridge', '', 'stockbridge', '', ''),
(2137, 13, 9, 1, 'Lenox', '', 'lenox', '', ''),
(2138, 44, 4, 1, 'Bernice', '', 'bernice', '', ''),
(2139, 35, 5, 1, 'Berrien Springs', '', 'berrien-springs', '', ''),
(2140, 43, 2, 1, 'Berthoud', '', 'berthoud', '', ''),
(2141, 48, 6, 1, 'Bessemer', '', 'bessemer', '', ''),
(2142, 8, 7, 1, 'Middleburgh', '', 'middleburgh', '', ''),
(2143, 8, 7, 1, 'Selkirk', '', 'selkirk', '', ''),
(2144, 57, 3, 1, 'Davenport', '', 'davenport', '', ''),
(2145, 36, 5, 1, 'Oconto', '', 'oconto', '', ''),
(2146, 56, 2, 1, 'Grangeville', '', 'grangeville', '', ''),
(2147, 30, 5, 1, 'New Bremen', '', 'new-bremen', '', ''),
(2148, 13, 9, 1, 'Monterey', '', 'monterey', '', ''),
(2149, 61, 6, 1, 'Vicksburg', '', 'vicksburg', '', ''),
(2150, 10, 1, 1, 'Big Bear City', '', 'big-bear-city', '', ''),
(2151, 55, 3, 1, 'West Mineral', '', 'west-mineral', '', ''),
(2152, 8, 7, 1, 'Big Flats', '', 'big-flats', '', ''),
(2153, 10, 1, 1, 'Felton', '', 'felton', '', ''),
(2154, 53, 2, 1, 'Hardin', '', 'hardin', '', ''),
(2155, 60, 2, 1, 'Thermopolis', '', 'thermopolis', '', ''),
(2156, 37, 6, 1, 'Pikeville', '', 'pikeville', '', ''),
(2157, 53, 2, 1, 'Big Sandy', '', 'big-sandy', '', ''),
(2158, 17, 3, 1, 'Ortonville', '', 'ortonville', '', ''),
(2159, 43, 2, 1, 'Lamar', '', 'lamar', '', ''),
(2160, 53, 2, 1, 'Billings', '', 'billings', '', ''),
(2161, 9, 4, 1, 'Hico', '', 'hico', '', ''),
(2162, 45, 2, 1, 'Fort Sumner', '', 'fort-sumner', '', ''),
(2163, 57, 3, 1, 'Spillville', '', 'spillville', '', ''),
(2164, 57, 3, 1, 'Winterset', '', 'winterset', '', ''),
(2165, 42, 5, 1, 'Bishop Hill', '', 'bishop-hill', '', ''),
(2166, 55, 3, 1, 'Morland', '', 'morland', '', ''),
(2167, 12, 1, 1, 'Black Diamond', '', 'black-diamond', '', ''),
(2168, 49, 3, 1, 'Lead', '', 'lead', '', ''),
(2169, 10, 1, 1, 'Blythe', '', 'blythe', '', ''),
(2170, 61, 6, 1, 'Corinth', '', 'corinth', '', ''),
(2171, 12, 1, 1, 'Maple Falls', '', 'maple-falls', '', ''),
(2172, 13, 9, 1, 'Roxbury', '', 'roxbury', '', ''),
(2173, 38, 9, 1, 'Ludlow', '', 'ludlow', '', ''),
(2174, 56, 2, 1, 'Hailey', '', 'hailey', '', ''),
(2175, 53, 2, 1, 'Chinook', '', 'chinook', '', ''),
(2176, 57, 3, 1, 'Fort Dodge', '', 'fort-dodge', '', ''),
(2177, 42, 5, 1, 'Blandinsville', '', 'blandinsville', '', ''),
(2178, 43, 2, 1, 'Trinidad', '', 'trinidad', '', ''),
(2179, 36, 5, 1, 'Bloomer', '', 'bloomer', '', ''),
(2180, 31, 7, 1, 'Cogan Station', '', 'cogan-station', '', ''),
(2181, 42, 5, 1, 'Bloomingdale', '', 'bloomingdale', '', ''),
(2182, 48, 6, 1, 'Oneonta', '', 'oneonta', '', ''),
(2183, 39, 5, 1, 'Monroe City', '', 'monroe-city', '', ''),
(2184, 10, 1, 1, 'Blue Lake', '', 'blue-lake', '', ''),
(2185, 37, 6, 1, 'Versailles', '', 'versailles', '', ''),
(2186, 31, 7, 1, 'Boalsburg', '', 'boalsburg', '', ''),
(2187, 57, 3, 1, 'Van Meter', '', 'van-meter', '', ''),
(2188, 9, 4, 1, 'Turkey', '', 'turkey', '', ''),
(2189, 20, 8, 1, 'Boca Grande', '', 'boca-grande', '', ''),
(2190, 17, 3, 1, 'Tower', '', 'tower', '', ''),
(2191, 47, 3, 1, 'Sainte Genevieve', '', 'sainte-genevieve', '', ''),
(2192, 10, 1, 1, 'Bolinas', '', 'bolinas', '', ''),
(2193, 10, 1, 1, 'Tujunga', '', 'tujunga', '', ''),
(2194, 59, 3, 1, 'West Fargo', '', 'west-fargo', '', ''),
(2195, 47, 3, 1, 'Rockaway Beach', '', 'rockaway-beach', '', ''),
(2196, 23, 9, 1, 'Boothbay', '', 'boothbay', '', ''),
(2197, 52, 4, 1, 'Success', '', 'success', '', ''),
(2198, 10, 1, 1, 'Boron', '', 'boron', '', ''),
(2199, 8, 7, 1, 'Garrison', '', 'garrison', '', ''),
(2200, 13, 9, 1, 'Charlestown', '', 'charlestown', '', ''),
(2201, 47, 3, 1, 'Sedalia', '', 'sedalia', '', ''),
(2202, 51, 2, 1, 'Boulder City', '', 'boulder-city', '', ''),
(2203, 24, 2, 1, 'Bountiful', '', 'bountiful', '', ''),
(2204, 42, 5, 1, 'Bourbonnais', '', 'bourbonnais', '', ''),
(2205, 59, 3, 1, 'Bowman', '', 'bowman', '', ''),
(2206, 26, 1, 1, 'Prineville', '', 'prineville', '', ''),
(2207, 43, 2, 1, 'Georgetown', '', 'georgetown', '', ''),
(2208, 45, 2, 1, 'Los Alamos', '', 'los-alamos', '', ''),
(2209, 60, 2, 1, 'Sheridan', '', 'sheridan', '', ''),
(2210, 31, 7, 1, 'Towanda', '', 'towanda', '', ''),
(2211, 21, 8, 1, 'Brandy Station', '', 'brandy-station', '', ''),
(2212, 9, 4, 1, 'Clute', '', 'clute', '', ''),
(2213, 38, 9, 1, 'Glover', '', 'glover', '', ''),
(2214, 9, 4, 1, 'Breckenridge', '', 'breckenridge', '', ''),
(2215, 30, 5, 1, 'Brecksville', '', 'brecksville', '', ''),
(2216, 12, 1, 1, 'Bremerton', '', 'bremerton', '', ''),
(2217, 9, 4, 1, 'Brenham', '', 'brenham', '', ''),
(2218, 10, 1, 1, 'Carmel', '', 'carmel', '', ''),
(2219, 57, 3, 1, 'Dallas Center', '', 'dallas-center', '', ''),
(2220, 20, 8, 1, 'Cocoa', '', 'cocoa', '', ''),
(2221, 22, 8, 1, 'Stanley', '', 'stanley', '', ''),
(2222, 13, 9, 1, 'Brewster', '', 'brewster', '', ''),
(2223, 8, 7, 1, 'Bridgehampton', '', 'bridgehampton', '', ''),
(2224, 8, 7, 1, 'Hudson', '', 'hudson', '', ''),
(2225, 23, 9, 1, 'Bridgton', '', 'bridgton', '', ''),
(2226, 36, 5, 1, 'Brillion', '', 'brillion', '', ''),
(2227, 37, 6, 1, 'Bowling Green', '', 'bowling-green', '', ''),
(2228, 44, 4, 1, 'Sulphur', '', 'sulphur', '', ''),
(2229, 31, 7, 1, 'Robertsdale', '', 'robertsdale', '', ''),
(2230, 8, 7, 1, 'Coxsackie', '', 'coxsackie', '', ''),
(2231, 42, 5, 1, 'Evergreen Park', '', 'evergreen-park', '', ''),
(2232, 33, 8, 1, 'Wellsburg', '', 'wellsburg', '', ''),
(2233, 41, 9, 1, 'Brookfield', '', 'brookfield', '', ''),
(2234, 27, 8, 1, 'Pawleys Island', '', 'pawleys-island', '', ''),
(2235, 8, 7, 1, 'Ridge', '', 'ridge', '', ''),
(2236, 13, 9, 1, 'Harwich', '', 'harwich', '', ''),
(2237, 8, 7, 1, 'Ballston Spa', '', 'ballston-spa', '', ''),
(2238, 43, 2, 1, 'Broomfield', '', 'broomfield', '', ''),
(2239, 55, 3, 1, 'Hiawatha', '', 'hiawatha', '', ''),
(2240, 9, 4, 1, 'Brownwood', '', 'brownwood', '', ''),
(2241, 50, 3, 1, 'Mc Kenzie', '', 'mc-kenzie', '', ''),
(2242, 58, 3, 1, 'Brownville', '', 'brownville', '', ''),
(2243, 43, 2, 1, 'Brush', '', 'brush', '', ''),
(2244, 36, 5, 1, 'Galesville', '', 'galesville', '', ''),
(2245, 38, 9, 1, 'Jeffersonville', '', 'jeffersonville', '', ''),
(2246, 48, 6, 1, 'Tuscaloosa', '', 'tuscaloosa', '', ''),
(2247, 23, 9, 1, 'Bryant Pond', '', 'bryant-pond', '', ''),
(2248, 32, 4, 1, 'Tonkawa', '', 'tonkawa', '', ''),
(2249, 30, 5, 1, 'Wellston', '', 'wellston', '', ''),
(2250, 11, 2, 1, 'Buckeye', '', 'buckeye', '', ''),
(2251, 55, 3, 1, 'Ellis', '', 'ellis', '', ''),
(2252, 43, 2, 1, 'Buena Vista', '', 'buena-vista', '', ''),
(2253, 9, 4, 1, 'Buffalo Gap', '', 'buffalo-gap', '', ''),
(2254, 42, 5, 1, 'Buffalo Grove', '', 'buffalo-grove', '', ''),
(2255, 52, 4, 1, 'Monette', '', 'monette', '', ''),
(2256, 11, 2, 1, 'Overgaard', '', 'overgaard', '', ''),
(2257, 59, 3, 1, 'Epping', '', 'epping', '', ''),
(2258, 50, 3, 1, 'Adamsville', '', 'adamsville', '', ''),
(2259, 31, 7, 1, 'Mifflinburg', '', 'mifflinburg', '', ''),
(2260, 10, 1, 1, 'Burbank', '', 'burbank', '', ''),
(2261, 9, 4, 1, 'Caldwell', '', 'caldwell', '', ''),
(2262, 12, 1, 1, 'Ritzville', '', 'ritzville', '', ''),
(2263, 58, 3, 1, 'Tekamah', '', 'tekamah', '', ''),
(2264, 9, 4, 1, 'Burton', '', 'burton', '', ''),
(2265, 21, 8, 1, 'Millwood', '', 'millwood', '', ''),
(2266, 41, 9, 1, 'Cos Cob', '', 'cos-cob', '', ''),
(2267, 47, 3, 1, 'Bronaugh', '', 'bronaugh', '', ''),
(2268, 47, 3, 1, 'Nevada', '', 'nevada', '', ''),
(2269, 31, 7, 1, 'Butler', '', 'butler', '', ''),
(2270, 30, 5, 1, 'Hamilton', '', 'hamilton', '', ''),
(2271, 55, 3, 1, 'El Dorado', '', 'el-dorado', '', ''),
(2272, 10, 1, 1, 'Oroville', '', 'oroville', '', ''),
(2273, 10, 1, 1, 'Dorris', '', 'dorris', '', ''),
(2274, 55, 3, 1, 'Winona', '', 'winona', '', ''),
(2275, 35, 5, 1, 'Mackinac Island', '', 'mackinac-island', '', ''),
(2276, 41, 9, 1, 'Wethersfield', '', 'wethersfield', '', ''),
(2277, 35, 5, 1, 'Byron Center', '', 'byron-center', '', ''),
(2278, 42, 5, 1, 'Byron', '', 'byron', '', ''),
(2279, 24, 2, 1, 'Price', '', 'price', '', ''),
(2280, 52, 4, 1, 'Murfreesboro', '', 'murfreesboro', '', ''),
(2281, 13, 9, 1, 'Cotuit', '', 'cotuit', '', ''),
(2282, 9, 4, 1, 'Lockhart', '', 'lockhart', '', ''),
(2283, 22, 8, 1, 'Lenoir', '', 'lenoir', '', ''),
(2284, 7, 7, 1, 'Califon', '', 'califon', '', ''),
(2285, 10, 1, 1, 'Morro Bay', '', 'morro-bay', '', ''),
(2286, 10, 1, 1, 'Mariposa', '', 'mariposa', '', ''),
(2287, 15, 8, 1, 'Chesapeake Beach', '', 'chesapeake-beach', '', ''),
(2288, 15, 8, 1, 'Solomons', '', 'solomons', '', ''),
(2289, 57, 3, 1, 'Camanche', '', 'camanche', '', ''),
(2290, 31, 7, 1, 'Ebensburg', '', 'ebensburg', '', ''),
(2291, 47, 3, 1, 'Linn Creek', '', 'linn-creek', '', ''),
(2292, 37, 6, 1, 'Morganfield', '', 'morganfield', '', ''),
(2293, 30, 5, 1, 'Camp Dennison', '', 'camp-dennison', '', ''),
(2294, 36, 5, 1, 'Laona', '', 'laona', '', ''),
(2295, 44, 4, 1, 'Kentwood', '', 'kentwood', '', ''),
(2296, 10, 1, 1, 'Campbell', '', 'campbell', '', ''),
(2297, 8, 7, 1, 'Canaan', '', 'canaan', '', ''),
(2298, 32, 4, 1, 'El Reno', '', 'el-reno', '', ''),
(2299, 44, 4, 1, 'Saint Bernard', '', 'saint-bernard', '', ''),
(2300, 8, 7, 1, 'Canastota', '', 'canastota', '', ''),
(2301, 26, 1, 1, 'Canby', '', 'canby', '', ''),
(2302, 26, 1, 1, 'Cannon Beach', '', 'cannon-beach', '', ''),
(2303, 10, 1, 1, 'Stanford', '', 'stanford', '', ''),
(2304, 56, 2, 1, 'Nampa', '', 'nampa', '', ''),
(2305, 35, 5, 1, 'Capac', '', 'capac', '', ''),
(2306, 21, 8, 1, 'Cape Charles', '', 'cape-charles', '', ''),
(2307, 13, 9, 1, 'Mashpee', '', 'mashpee', '', ''),
(2308, 20, 8, 1, 'Cape Coral', '', 'cape-coral', '', ''),
(2309, 47, 3, 1, 'Cape Girardeau', '', 'cape-girardeau', '', ''),
(2310, 8, 7, 1, 'Cape Vincent', '', 'cape-vincent', '', ''),
(2311, 13, 9, 1, 'Charlton', '', 'charlton', '', ''),
(2312, 10, 1, 1, 'Capitola', '', 'capitola', '', ''),
(2313, 26, 1, 1, 'Columbia City', '', 'columbia-city', '', ''),
(2314, 35, 5, 1, 'Holland', '', 'holland', '', ''),
(2315, 13, 9, 1, 'Wareham', '', 'wareham', '', ''),
(2316, 15, 8, 1, 'Shady Side', '', 'shady-side', '', ''),
(2317, 50, 3, 1, 'Pigeon Forge', '', 'pigeon-forge', '', ''),
(2318, 17, 3, 1, 'Cloquet', '', 'cloquet', '', ''),
(2319, 42, 5, 1, 'Olney', '', 'olney', '', ''),
(2320, 26, 1, 1, 'Oregon City', '', 'oregon-city', '', ''),
(2321, 39, 5, 1, 'New Albany', '', 'new-albany', '', ''),
(2322, 17, 3, 1, 'Luverne', '', 'luverne', '', ''),
(2323, 57, 3, 1, 'New Hampton', '', 'new-hampton', '', ''),
(2324, 8, 7, 1, 'Caroga Lake', '', 'caroga-lake', '', ''),
(2325, 22, 8, 1, 'Huntersville', '', 'huntersville', '', ''),
(2326, 15, 8, 1, 'Preston', '', 'preston', '', ''),
(2327, 10, 1, 1, 'Napa', '', 'napa', '', ''),
(2328, 8, 7, 1, 'North Tonawanda', '', 'north-tonawanda', '', ''),
(2329, 13, 9, 1, 'Rehoboth', '', 'rehoboth', '', ''),
(2330, 10, 1, 1, 'Carpinteria', '', 'carpinteria', '', ''),
(2331, 45, 2, 1, 'Carrizozo', '', 'carrizozo', '', ''),
(2332, 52, 4, 1, 'Berryville', '', 'berryville', '', ''),
(2333, 42, 5, 1, 'Mount Carroll', '', 'mount-carroll', '', ''),
(2334, 21, 8, 1, 'Hillsville', '', 'hillsville', '', ''),
(2335, 57, 3, 1, 'Carroll', '', 'carroll', '', ''),
(2336, 9, 4, 1, 'Panhandle', '', 'panhandle', '', ''),
(2337, 53, 2, 1, 'Ekalaka', '', 'ekalaka', '', ''),
(2338, 21, 8, 1, 'Hiltons', '', 'hiltons', '', ''),
(2339, 22, 8, 1, 'Morehead City', '', 'morehead-city', '', ''),
(2340, 47, 3, 1, 'Carthage', '', 'carthage', '', ''),
(2341, 17, 3, 1, 'Waconia', '', 'waconia', '', ''),
(2342, 11, 2, 1, 'Springerville', '', 'springerville', '', ''),
(2343, 26, 1, 1, 'Cascade Locks', '', 'cascade-locks', '', ''),
(2344, 35, 5, 1, 'Caseville', '', 'caseville', '', ''),
(2345, 28, 9, 1, 'Saunderstown', '', 'saunderstown', '', ''),
(2346, 61, 6, 1, 'Vaughan', '', 'vaughan', '', ''),
(2347, 57, 3, 1, 'Casey', '', 'casey', '', ''),
(2348, 58, 3, 1, 'Plattsmouth', '', 'plattsmouth', '', ''),
(2349, 56, 2, 1, 'Burley', '', 'burley', '', ''),
(2350, 23, 9, 1, 'Castine', '', 'castine', '', ''),
(2351, 9, 4, 1, 'Dimmitt', '', 'dimmitt', '', ''),
(2352, 22, 8, 1, 'Conover', '', 'conover', '', ''),
(2353, 8, 7, 1, 'Fonda', '', 'fonda', '', ''),
(2354, 42, 5, 1, 'Catlin', '', 'catlin', '', ''),
(2355, 11, 2, 1, 'Cave Creek', '', 'cave-creek', '', ''),
(2356, 8, 7, 1, 'Howes Cave', '', 'howes-cave', '', ''),
(2357, 20, 8, 1, 'Cedar Key', '', 'cedar-key', '', ''),
(2358, 35, 5, 1, 'Cedar Springs', '', 'cedar-springs', '', ''),
(2359, 57, 3, 1, 'Osage', '', 'osage', '', ''),
(2360, 31, 7, 1, 'Nazareth', '', 'nazareth', '', ''),
(2361, 10, 1, 1, 'Dos Palos', '', 'dos-palos', '', ''),
(2362, 52, 4, 1, 'Brinkley', '', 'brinkley', '', ''),
(2363, 56, 2, 1, 'Mccall', '', 'mccall', '', ''),
(2364, 51, 2, 1, 'Tonopah', '', 'tonopah', '', ''),
(2365, 8, 7, 1, 'Central Square', '', 'central-square', '', ''),
(2366, 55, 3, 1, 'Larned', '', 'larned', '', ''),
(2367, 9, 4, 1, 'Smithville', '', 'smithville', '', ''),
(2368, 9, 4, 1, 'Rosanky', '', 'rosanky', '', ''),
(2369, 12, 1, 1, 'Union Gap', '', 'union-gap', '', ''),
(2370, 33, 8, 1, 'Ceredo', '', 'ceredo', '', ''),
(2371, 22, 8, 1, 'Chadbourn', '', 'chadbourn', '', ''),
(2372, 36, 5, 1, 'Sturgeon Bay', '', 'sturgeon-bay', '', ''),
(2373, 36, 5, 1, 'New Glarus', '', 'new-glarus', '', ''),
(2374, 39, 5, 1, 'French Lick', '', 'french-lick', '', ''),
(2375, 51, 2, 1, 'Elko', '', 'elko', '', ''),
(2376, 22, 8, 1, 'Fairmont', '', 'fairmont', '', ''),
(2377, 8, 7, 1, 'Glens Falls', '', 'glens-falls', '', ''),
(2378, 10, 1, 1, 'Fortuna', '', 'fortuna', '', ''),
(2379, 17, 3, 1, 'Little Falls', '', 'little-falls', '', ''),
(2380, 35, 5, 1, 'Charlevoix', '', 'charlevoix', '', ''),
(2381, 20, 8, 1, 'Punta Gorda', '', 'punta-gorda', '', ''),
(2382, 8, 7, 1, 'Ballston Lake', '', 'ballston-lake', '', ''),
(2383, 35, 5, 1, 'Chassell', '', 'chassell', '', ''),
(2384, 13, 9, 1, 'North Chatham', '', 'north-chatham', '', ''),
(2385, 14, 8, 1, 'Hogansville', '', 'hogansville', '', ''),
(2386, 35, 5, 1, 'Freeport', '', 'freeport', '', ''),
(2387, 12, 1, 1, 'Montesano', '', 'montesano', '', ''),
(2388, 12, 1, 1, 'Cashmere', '', 'cashmere', '', ''),
(2389, 22, 8, 1, 'Murphy', '', 'murphy', '', ''),
(2390, 27, 8, 1, 'Gaffney', '', 'gaffney', '', ''),
(2391, 32, 4, 1, 'Gore', '', 'gore', '', ''),
(2392, 32, 4, 1, 'Perry', '', 'perry', '', ''),
(2393, 32, 4, 1, 'Alva', '', 'alva', '', ''),
(2394, 8, 7, 1, 'Cherry Valley', '', 'cherry-valley', '', ''),
(2395, 15, 8, 1, 'Hebron', '', 'hebron', '', ''),
(2396, 55, 3, 1, 'Chetopa', '', 'chetopa', '', ''),
(2397, 58, 3, 1, 'Elm Creek', '', 'elm-creek', '', ''),
(2398, 58, 3, 1, 'Sidney', '', 'sidney', '', ''),
(2399, 42, 5, 1, 'Galena', '', 'galena', '', ''),
(2400, 42, 5, 1, 'Glencoe', '', 'glencoe', '', ''),
(2401, 32, 4, 1, 'Tishomingo', '', 'tishomingo', '', ''),
(2402, 52, 4, 1, 'Lake Village', '', 'lake-village', '', ''),
(2403, 14, 8, 1, 'Rome', '', 'rome', '', ''),
(2404, 47, 3, 1, 'Joplin', '', 'joplin', '', ''),
(2405, 10, 1, 1, 'Rancho Mirage', '', 'rancho-mirage', '', ''),
(2406, 19, 9, 1, 'Derry', '', 'derry', '', ''),
(2407, 13, 9, 1, 'Holyoke', '', 'holyoke', '', ''),
(2408, 59, 3, 1, 'Fargo', '', 'fargo', '', ''),
(2409, 13, 9, 1, 'North Easton', '', 'north-easton', '', ''),
(2410, 26, 1, 1, 'Pendleton', '', 'pendleton', '', ''),
(2411, 42, 5, 1, 'Edwardsville', '', 'edwardsville', '', ''),
(2412, 51, 2, 1, 'Carson City', '', 'carson-city', '', ''),
(2413, 20, 8, 1, 'Sebring', '', 'sebring', '', ''),
(2414, 9, 4, 1, 'Victoria', '', 'victoria', '', ''),
(2415, 44, 4, 1, 'Lake Charles', '', 'lake-charles', '', ''),
(2416, 10, 1, 1, 'Oakhurst', '', 'oakhurst', '', ''),
(2417, 9, 4, 1, 'Waxahachie', '', 'waxahachie', '', ''),
(2418, 9, 4, 1, 'Childress', '', 'childress', '', ''),
(2419, 45, 2, 1, 'Chimayo', '', 'chimayo', '', ''),
(2420, 58, 3, 1, 'Bayard', '', 'bayard', '', ''),
(2421, 35, 5, 1, 'Sault Sainte Marie', '', 'sault-sainte-marie', '', ''),
(2422, 11, 2, 1, 'Willcox', '', 'willcox', '', ''),
(2423, 32, 4, 1, 'Duncan', '', 'duncan', '', ''),
(2424, 9, 4, 1, 'Cuero', '', 'cuero', '', ''),
(2425, 32, 4, 1, 'Waurika', '', 'waurika', '', ''),
(2426, 44, 4, 1, 'Jeanerette', '', 'jeanerette', '', ''),
(2427, 44, 4, 1, 'Charenton', '', 'charenton', '', ''),
(2428, 8, 7, 1, 'Chittenango', '', 'chittenango', '', ''),
(2429, 32, 4, 1, 'Salina', '', 'salina', '', ''),
(2430, 15, 8, 1, 'Crisfield', '', 'crisfield', '', ''),
(2431, 42, 5, 1, 'Taylorville', '', 'taylorville', '', ''),
(2432, 25, 10, 1, 'Haleiwa', '', 'haleiwa', '', ''),
(2433, 51, 2, 1, 'Fallon', '', 'fallon', '', ''),
(2434, 49, 3, 1, 'Hill City', '', 'hill-city', '', ''),
(2435, 32, 4, 1, 'Boise City', '', 'boise-city', '', ''),
(2436, 53, 2, 1, 'Circle', '', 'circle', '', ''),
(2437, 34, 1, 1, 'Central', '', 'central', '', ''),
(2438, 39, 5, 1, 'Peru', '', 'peru', '', ''),
(2439, 36, 5, 1, 'Baraboo', '', 'baraboo', '', ''),
(2440, 11, 2, 1, 'Coolidge', '', 'coolidge', '', ''),
(2441, 55, 3, 1, 'Pretty Prairie', '', 'pretty-prairie', '', ''),
(2442, 53, 2, 1, 'Havre', '', 'havre', '', ''),
(2443, 12, 1, 1, 'Port Angeles', '', 'port-angeles', '', ''),
(2444, 8, 7, 1, 'Clarence', '', 'clarence', '', ''),
(2445, 13, 9, 1, 'Williamstown', '', 'williamstown', '', ''),
(2446, 47, 3, 1, 'Kahoka', '', 'kahoka', '', ''),
(2447, 53, 2, 1, 'Fromberg', '', 'fromberg', '', ''),
(2448, 35, 5, 1, 'Clarkston', '', 'clarkston', '', ''),
(2449, 20, 8, 1, 'Rockledge', '', 'rockledge', '', ''),
(2450, 47, 3, 1, 'Kearney', '', 'kearney', '', ''),
(2451, 9, 4, 1, 'Henrietta', '', 'henrietta', '', ''),
(2452, 39, 5, 1, 'Brazil', '', 'brazil', '', ''),
(2453, 55, 3, 1, 'Clay Center', '', 'clay-center', '', ''),
(2454, 17, 3, 1, 'Moorhead', '', 'moorhead', '', ''),
(2455, 50, 3, 1, 'Celina', '', 'celina', '', ''),
(2456, 36, 5, 1, 'Clear Lake', '', 'clear-lake', '', ''),
(2457, 17, 3, 1, 'Shevlin', '', 'shevlin', '', ''),
(2458, 56, 2, 1, 'Orofino', '', 'orofino', '', ''),
(2459, 9, 4, 1, 'Cleburne', '', 'cleburne', '', ''),
(2460, 11, 2, 1, 'Cottonwood', '', 'cottonwood', '', ''),
(2461, 8, 7, 1, 'Germantown', '', 'germantown', '', ''),
(2462, 22, 8, 1, 'Shelby', '', 'shelby', '', ''),
(2463, 31, 7, 1, 'Lock Haven', '', 'lock-haven', '', ''),
(2464, 55, 3, 1, 'Concordia', '', 'concordia', '', ''),
(2465, 10, 1, 1, 'Cloverdale', '', 'cloverdale', '', ''),
(2466, 45, 2, 1, 'Clovis', '', 'clovis', '', ''),
(2467, 12, 1, 1, 'Ellensburg', '', 'ellensburg', '', ''),
(2468, 10, 1, 1, 'Indio', '', 'indio', '', ''),
(2469, 50, 3, 1, 'Hurricane Mills', '', 'hurricane-mills', '', ''),
(2470, 32, 4, 1, 'Coalgate', '', 'coalgate', '', ''),
(2471, 12, 1, 1, 'Port Townsend', '', 'port-townsend', '', ''),
(2472, 27, 8, 1, 'Hilton Head Island', '', 'hilton-head-island', '', ''),
(2473, 14, 8, 1, 'Saint Simons Island', '', 'saint-simons-island', '', ''),
(2474, 31, 7, 1, 'Elkland', '', 'elkland', '', ''),
(2475, 11, 2, 1, 'Douglas', '', 'douglas', '', ''),
(2476, 9, 4, 1, 'Morton', '', 'morton', '', ''),
(2477, 13, 9, 1, 'Newbury', '', 'newbury', '', ''),
(2478, 17, 3, 1, 'Cokato', '', 'cokato', '', ''),
(2479, 50, 3, 1, 'Dunlap', '', 'dunlap', '', ''),
(2480, 41, 9, 1, 'Colchester', '', 'colchester', '', ''),
(2481, 47, 3, 1, 'Cole Camp', '', 'cole-camp', '', ''),
(2482, 55, 3, 1, 'Moundridge', '', 'moundridge', '', ''),
(2483, 49, 3, 1, 'Sturgis', '', 'sturgis', '', ''),
(2484, 42, 5, 1, 'Mattoon', '', 'mattoon', '', ''),
(2485, 30, 5, 1, 'Sugarcreek', '', 'sugarcreek', '', ''),
(2486, 20, 8, 1, 'Estero', '', 'estero', '', ''),
(2487, 27, 8, 1, 'Walterboro', '', 'walterboro', '', ''),
(2488, 44, 4, 1, 'Collinston', '', 'collinston', '', ''),
(2489, 10, 1, 1, 'Colma', '', 'colma', '', ''),
(2490, 21, 8, 1, 'Colonial Beach', '', 'colonial-beach', '', ''),
(2491, 35, 5, 1, 'Mackinaw City', '', 'mackinaw-city', '', ''),
(2492, 9, 4, 1, 'Colorado City', '', 'colorado-city', '', ''),
(2493, 11, 2, 1, 'Parker', '', 'parker', '', ''),
(2494, 10, 1, 1, 'Colton', '', 'colton', '', ''),
(2495, 36, 5, 1, 'Pardeeville', '', 'pardeeville', '', ''),
(2496, 26, 1, 1, 'The Dalles', '', 'the-dalles', '', ''),
(2497, 12, 1, 1, 'Stevenson', '', 'stevenson', '', ''),
(2498, 55, 3, 1, 'Coldwater', '', 'coldwater', '', ''),
(2499, 43, 2, 1, 'Strasburg', '', 'strasburg', '', ''),
(2500, 48, 6, 1, 'Sylacauga', '', 'sylacauga', '', ''),
(2501, 47, 3, 1, 'Portage Des Sioux', '', 'portage-des-sioux', '', ''),
(2502, 17, 3, 1, 'South Saint Paul', '', 'south-saint-paul', '', ''),
(2503, 57, 3, 1, 'Council Bluffs', '', 'council-bluffs', '', ''),
(2504, 55, 3, 1, 'Olathe', '', 'olathe', '', ''),
(2505, 57, 3, 1, 'Middle Amana', '', 'middle-amana', '', ''),
(2506, 41, 9, 1, 'Ivoryton', '', 'ivoryton', '', ''),
(2507, 31, 7, 1, 'Laughlintown', '', 'laughlintown', '', ''),
(2508, 8, 7, 1, 'Springville', '', 'springville', '', ''),
(2509, 31, 7, 1, 'Conestoga', '', 'conestoga', '', ''),
(2510, 9, 4, 1, 'Burnet', '', 'burnet', '', ''),
(2511, 53, 2, 1, 'Pablo', '', 'pablo', '', ''),
(2512, 53, 2, 1, 'Ronan', '', 'ronan', '', ''),
(2513, 30, 5, 1, 'Conneaut', '', 'conneaut', '', ''),
(2514, 41, 9, 1, 'Essex', '', 'essex', '', ''),
(2515, 41, 9, 1, 'East Windsor', '', 'east-windsor', '', ''),
(2516, 12, 1, 1, 'Connell', '', 'connell', '', ''),
(2517, 39, 5, 1, 'Fishers', '', 'fishers', '', ''),
(2518, 57, 3, 1, 'Conrad', '', 'conrad', '', ''),
(2519, 55, 3, 1, 'Lecompton', '', 'lecompton', '', ''),
(2520, 8, 7, 1, 'Highland Falls', '', 'highland-falls', '', ''),
(2521, 50, 3, 1, 'Cookeville', '', 'cookeville', '', ''),
(2522, 55, 3, 1, 'Emporia', '', 'emporia', '', ''),
(2523, 31, 7, 1, 'Coolspring', '', 'coolspring', '', ''),
(2524, 35, 5, 1, 'South Range', '', 'south-range', '', ''),
(2525, 53, 2, 1, 'Anaconda', '', 'anaconda', '', ''),
(2526, 35, 5, 1, 'Calumet', '', 'calumet', '', ''),
(2527, 22, 8, 1, 'Harkers Island', '', 'harkers-island', '', ''),
(2528, 20, 8, 1, 'Delray Beach', '', 'delray-beach', '', ''),
(2529, 10, 1, 1, 'Sonoma', '', 'sonoma', '', ''),
(2530, 35, 5, 1, 'Iron Mountain', '', 'iron-mountain', '', ''),
(2531, 55, 3, 1, 'Lyons', '', 'lyons', '', ''),
(2532, 31, 7, 1, 'Corry', '', 'corry', '', ''),
(2533, 43, 2, 1, 'Cortez', '', 'cortez', '', ''),
(2534, 8, 7, 1, 'Verplanck', '', 'verplanck', '', ''),
(2535, 9, 4, 1, 'Gatesville', '', 'gatesville', '', ''),
(2536, 15, 8, 1, 'Pocomoke City', '', 'pocomoke-city', '', ''),
(2537, 44, 4, 1, 'Lake Providence', '', 'lake-providence', '', ''),
(2538, 61, 6, 1, 'Greenwood', '', 'greenwood', '', ''),
(2539, 55, 3, 1, 'Hoxie', '', 'hoxie', '', ''),
(2540, 50, 3, 1, 'Cowan', '', 'cowan', '', ''),
(2541, 12, 1, 1, 'Kelso', '', 'kelso', '', ''),
(2542, 7, 7, 1, 'Morris Plains', '', 'morris-plains', '', ''),
(2543, 50, 3, 1, 'Gallatin', '', 'gallatin', '', ''),
(2544, 36, 5, 1, 'Warrens', '', 'warrens', '', ''),
(2545, 7, 7, 1, 'Cranford', '', 'cranford', '', ''),
(2546, 26, 1, 1, 'Central Point', '', 'central-point', '', ''),
(2547, 35, 5, 1, 'Grayling', '', 'grayling', '', ''),
(2548, 55, 3, 1, 'Pittsburg', '', 'pittsburg', '', ''),
(2549, 31, 7, 1, 'Breezewood', '', 'breezewood', '', ''),
(2550, 49, 3, 1, 'Custer', '', 'custer', '', ''),
(2551, 53, 2, 1, 'Big Timber', '', 'big-timber', '', ''),
(2552, 43, 2, 1, 'Crested Butte', '', 'crested-butte', '', ''),
(2553, 30, 5, 1, 'Crestline', '', 'crestline', '', ''),
(2554, 26, 1, 1, 'Creswell', '', 'creswell', '', ''),
(2555, 43, 2, 1, 'Cripple Creek', '', 'cripple-creek', '', ''),
(2556, 52, 4, 1, 'Earle', '', 'earle', '', ''),
(2557, 36, 5, 1, 'Crivitz', '', 'crivitz', '', ''),
(2558, 30, 5, 1, 'Eastlake', '', 'eastlake', '', ''),
(2559, 35, 5, 1, 'Mount Clemens', '', 'mount-clemens', '', ''),
(2560, 9, 4, 1, 'Ozona', '', 'ozona', '', ''),
(2561, 10, 1, 1, 'Crockett', '', 'crockett', '', ''),
(2562, 50, 3, 1, 'Cross Plains', '', 'cross-plains', '', ''),
(2563, 17, 3, 1, 'Brainerd', '', 'brainerd', '', ''),
(2564, 8, 7, 1, 'Port Jefferson', '', 'port-jefferson', '', ''),
(2565, 9, 4, 1, 'Van Horn', '', 'van-horn', '', ''),
(2566, 53, 2, 1, 'Culbertson', '', 'culbertson', '', ''),
(2567, 48, 6, 1, 'Cullman', '', 'cullman', '', ''),
(2568, 8, 7, 1, 'Cold Spring', '', 'cold-spring', '', ''),
(2569, 10, 1, 1, 'Pala', '', 'pala', '', ''),
(2570, 26, 1, 1, 'Gold Beach', '', 'gold-beach', '', ''),
(2571, 57, 3, 1, 'Swisher', '', 'swisher', '', ''),
(2572, 15, 8, 1, 'Saint Michaels', '', 'saint-michaels', '', ''),
(2573, 8, 7, 1, 'Hammondsport', '', 'hammondsport', '', ''),
(2574, 53, 2, 1, 'Garryowen', '', 'garryowen', '', ''),
(2575, 53, 2, 1, 'Miles City', '', 'miles-city', '', ''),
(2576, 8, 7, 1, 'Olean', '', 'olean', '', ''),
(2577, 30, 5, 1, 'Cuyahoga Falls', '', 'cuyahoga-falls', '', ''),
(2578, 30, 5, 1, 'Peninsula', '', 'peninsula', '', ''),
(2579, 7, 7, 1, 'Bernardsville', '', 'bernardsville', '', ''),
(2580, 8, 7, 1, 'Cuddebackville', '', 'cuddebackville', '', ''),
(2581, 7, 7, 1, 'Sussex', '', 'sussex', '', ''),
(2582, 49, 3, 1, 'Spearfish', '', 'spearfish', '', ''),
(2583, 12, 1, 1, 'Hoquiam', '', 'hoquiam', '', ''),
(2584, 9, 4, 1, 'Llano', '', 'llano', '', ''),
(2585, 59, 3, 1, 'Hettinger', '', 'hettinger', '', ''),
(2586, 59, 3, 1, 'Minot', '', 'minot', '', ''),
(2587, 49, 3, 1, 'Huron', '', 'huron', '', ''),
(2588, 9, 4, 1, 'Lamesa', '', 'lamesa', '', ''),
(2589, 52, 4, 1, 'Fordyce', '', 'fordyce', '', ''),
(2590, 55, 3, 1, 'Meade', '', 'meade', '', ''),
(2591, 41, 9, 1, 'Danbury', '', 'danbury', '', ''),
(2592, 53, 2, 1, 'Scobey', '', 'scobey', '', ''),
(2593, 9, 4, 1, 'Danevang', '', 'danevang', '', ''),
(2594, 8, 7, 1, 'Dansville', '', 'dansville', '', ''),
(2595, 42, 5, 1, 'Danvers', '', 'danvers', '', ''),
(2596, 38, 9, 1, 'Vergennes', '', 'vergennes', '', ''),
(2597, 27, 8, 1, 'Darlington', '', 'darlington', '', ''),
(2598, 36, 5, 1, 'Green Lake', '', 'green-lake', '', ''),
(2599, 17, 3, 1, 'Dassel', '', 'dassel', '', ''),
(2600, 24, 2, 1, 'Saint George', '', 'saint-george', '', ''),
(2601, 35, 5, 1, 'Davison', '', 'davison', '', ''),
(2602, 58, 3, 1, 'Chadron', '', 'chadron', '', ''),
(2603, 37, 6, 1, 'Dawson Springs', '', 'dawson-springs', '', ''),
(2604, 13, 9, 1, 'West Springfield', '', 'west-springfield', '', ''),
(2605, 57, 3, 1, 'Decorah', '', 'decorah', '', ''),
(2606, 39, 5, 1, 'Fairmount', '', 'fairmount', '', ''),
(2607, 14, 8, 1, 'Bainbridge', '', 'bainbridge', '', ''),
(2608, 23, 9, 1, 'Stonington', '', 'stonington', '', ''),
(2609, 20, 8, 1, 'Deerfield Beach', '', 'deerfield-beach', '', ''),
(2610, 36, 5, 1, 'De Forest', '', 'de-forest', '', ''),
(2611, 35, 5, 1, 'Zeeland', '', 'zeeland', '', ''),
(2612, 10, 1, 1, 'Crescent City', '', 'crescent-city', '', ''),
(2613, 8, 7, 1, 'Delhi', '', 'delhi', '', ''),
(2614, 32, 4, 1, 'Jay', '', 'jay', '', ''),
(2615, 31, 7, 1, 'Willow Grove', '', 'willow-grove', '', ''),
(2616, 49, 3, 1, 'Dell Rapids', '', 'dell-rapids', '', ''),
(2617, 30, 5, 1, 'Delphos', '', 'delphos', '', ''),
(2618, 61, 6, 1, 'Clarksdale', '', 'clarksdale', '', ''),
(2619, 43, 2, 1, 'Delta', '', 'delta', '', ''),
(2620, 20, 8, 1, 'Deltona', '', 'deltona', '', ''),
(2621, 45, 2, 1, 'Deming', '', 'deming', '', ''),
(2622, 7, 7, 1, 'Woodbine', '', 'woodbine', '', ''),
(2623, 30, 5, 1, 'Uhrichsville', '', 'uhrichsville', '', ''),
(2624, 9, 4, 1, 'Denver City', '', 'denver-city', '', ''),
(2625, 8, 7, 1, 'Deposit', '', 'deposit', '', ''),
(2626, 39, 5, 1, 'Linden', '', 'linden', '', ''),
(2627, 52, 4, 1, 'Morrilton', '', 'morrilton', '', ''),
(2628, 26, 1, 1, 'Troutdale', '', 'troutdale', '', ''),
(2629, 31, 7, 1, 'Glenshaw', '', 'glenshaw', '', ''),
(2630, 41, 9, 1, 'Meriden', '', 'meriden', '', ''),
(2631, 11, 2, 1, 'Wickenburg', '', 'wickenburg', '', ''),
(2632, 52, 4, 1, 'Dumas', '', 'dumas', '', ''),
(2633, 20, 8, 1, 'Destin', '', 'destin', '', ''),
(2634, 35, 5, 1, 'Redford', '', 'redford', '', ''),
(2635, 47, 3, 1, 'Hermann', '', 'hermann', '', ''),
(2636, 43, 2, 1, 'Fruita', '', 'fruita', '', ''),
(2637, 32, 4, 1, 'Dewey', '', 'dewey', '', ''),
(2638, 26, 1, 1, 'Prairie City', '', 'prairie-city', '', ''),
(2639, 35, 5, 1, 'Dexter', '', 'dexter', '', ''),
(2640, 30, 5, 1, 'Reynoldsburg', '', 'reynoldsburg', '', ''),
(2641, 57, 3, 1, 'Spirit Lake', '', 'spirit-lake', '', ''),
(2642, 50, 3, 1, 'Greeneville', '', 'greeneville', '', ''),
(2643, 27, 8, 1, 'Latta', '', 'latta', '', ''),
(2644, 42, 5, 1, 'Sterling', '', 'sterling', '', ''),
(2645, 43, 2, 1, 'Canon City', '', 'canon-city', '', ''),
(2646, 53, 2, 1, 'Malta', '', 'malta', '', ''),
(2647, 24, 2, 1, 'Blanding', '', 'blanding', '', ''),
(2648, 24, 2, 1, 'Lehi', '', 'lehi', '', ''),
(2649, 20, 8, 1, 'Plant City', '', 'plant-city', '', ''),
(2650, 37, 6, 1, 'Cave City', '', 'cave-city', '', ''),
(2651, 8, 7, 1, 'Binghamton', '', 'binghamton', '', ''),
(2652, 7, 7, 1, 'Monroe Township', '', 'monroe-township', '', ''),
(2653, 59, 3, 1, 'Crosby', '', 'crosby', '', ''),
(2654, 14, 8, 1, 'Peachtree City', '', 'peachtree-city', '', ''),
(2655, 8, 7, 1, 'Harpursville', '', 'harpursville', '', ''),
(2656, 36, 5, 1, 'Dodgeville', '', 'dodgeville', '', ''),
(2657, 36, 5, 1, 'Beaver Dam', '', 'beaver-dam', '', ''),
(2658, 17, 3, 1, 'Mantorville', '', 'mantorville', '', ''),
(2659, 8, 7, 1, 'Dolgeville', '', 'dolgeville', '', ''),
(2660, 61, 6, 1, 'Ocean Springs', '', 'ocean-springs', '', ''),
(2661, 34, 1, 1, 'Ketchikan', '', 'ketchikan', '', ''),
(2662, 42, 5, 1, 'Rosemont', '', 'rosemont', '', ''),
(2663, 10, 1, 1, 'San Rafael', '', 'san-rafael', '', ''),
(2664, 9, 4, 1, 'Donna', '', 'donna', '', ''),
(2665, 36, 5, 1, 'Ellison Bay', '', 'ellison-bay', '', ''),
(2666, 39, 5, 1, 'Laporte', '', 'laporte', '', ''),
(2667, 31, 7, 1, 'White Mills', '', 'white-mills', '', ''),
(2668, 36, 5, 1, 'Elkhorn', '', 'elkhorn', '', ''),
(2669, 38, 9, 1, 'Dorset', '', 'dorset', '', ''),
(2670, 45, 2, 1, 'Raton', '', 'raton', '', ''),
(2671, 48, 6, 1, 'Dothan', '', 'dothan', '', ''),
(2672, 51, 2, 1, 'Gardnerville', '', 'gardnerville', '', ''),
(2673, 55, 3, 1, 'Douglass', '', 'douglass', '', ''),
(2674, 38, 9, 1, 'West Dover', '', 'west-dover', '', ''),
(2675, 57, 3, 1, 'Dow City', '', 'dow-city', '', ''),
(2676, 42, 5, 1, 'Downers Grove', '', 'downers-grove', '', ''),
(2677, 36, 5, 1, 'Woodruff', '', 'woodruff', '', ''),
(2678, 13, 9, 1, 'South Deerfield', '', 'south-deerfield', '', ''),
(2679, 39, 5, 1, 'Dale', '', 'dale', '', ''),
(2680, 36, 5, 1, 'Drummond', '', 'drummond', '', ''),
(2681, 32, 4, 1, 'Hominy', '', 'hominy', '', ''),
(2682, 35, 5, 1, 'Drummond Island', '', 'drummond-island', '', ''),
(2683, 32, 4, 1, 'Drumright', '', 'drumright', '', ''),
(2684, 31, 7, 1, 'Du Bois', '', 'du-bois', '', ''),
(2685, 60, 2, 1, 'Dubois', '', 'dubois', '', ''),
(2686, 50, 3, 1, 'Ducktown', '', 'ducktown', '', ''),
(2687, 41, 9, 1, 'Guilford', '', 'guilford', '', ''),
(2688, 15, 8, 1, 'Dundalk', '', 'dundalk', '', ''),
(2689, 8, 7, 1, 'Dundee', '', 'dundee', '', ''),
(2690, 42, 5, 1, 'West Dundee', '', 'west-dundee', '', ''),
(2691, 10, 1, 1, 'Guadalupe', '', 'guadalupe', '', ''),
(2692, 42, 5, 1, 'East Saint Louis', '', 'east-saint-louis', '', ''),
(2693, 8, 7, 1, 'Dunkirk', '', 'dunkirk', '', ''),
(2694, 47, 3, 1, 'Kennett', '', 'kennett', '', ''),
(2695, 27, 8, 1, 'Laurens', '', 'laurens', '', ''),
(2696, 59, 3, 1, 'Dunn Center', '', 'dunn-center', '', ''),
(2697, 36, 5, 1, 'Menomonie', '', 'menomonie', '', ''),
(2698, 47, 3, 1, 'Bolivar', '', 'bolivar', '', ''),
(2699, 12, 1, 1, 'Dupont', '', 'dupont', '', ''),
(2700, 8, 7, 1, 'East Durham', '', 'east-durham', '', ''),
(2701, 23, 9, 1, 'Saco', '', 'saco', '', ''),
(2702, 57, 3, 1, 'Dyersville', '', 'dyersville', '', ''),
(2703, 9, 4, 1, 'Flatonia', '', 'flatonia', '', ''),
(2704, 36, 5, 1, 'Oshkosh', '', 'oshkosh', '', ''),
(2705, 34, 1, 1, 'Eagle', '', 'eagle', '', ''),
(2706, 26, 1, 1, 'Eagle Point', '', 'eagle-point', '', ''),
(2707, 14, 8, 1, 'Watkinsville', '', 'watkinsville', '', ''),
(2708, 8, 7, 1, 'Earlville', '', 'earlville', '', ''),
(2709, 42, 5, 1, 'Mahomet', '', 'mahomet', '', ''),
(2710, 30, 5, 1, 'Hilliard', '', 'hilliard', '', ''),
(2711, 58, 3, 1, 'Overton', '', 'overton', '', ''),
(2712, 41, 9, 1, 'Westport', '', 'westport', '', ''),
(2713, 8, 7, 1, 'Greenport', '', 'greenport', '', ''),
(2714, 41, 9, 1, 'East Haddam', '', 'east-haddam', '', ''),
(2715, 8, 7, 1, 'East Hampton', '', 'east-hampton', '', ''),
(2716, 35, 5, 1, 'East Jordan', '', 'east-jordan', '', ''),
(2717, 37, 6, 1, 'Prestonsburg', '', 'prestonsburg', '', ''),
(2718, 26, 1, 1, 'Sweet Home', '', 'sweet-home', '', ''),
(2719, 30, 5, 1, 'East Palestine', '', 'east-palestine', '', ''),
(2720, 17, 3, 1, 'Fosston', '', 'fosston', '', ''),
(2721, 36, 5, 1, 'East Troy', '', 'east-troy', '', ''),
(2722, 11, 2, 1, 'Pima', '', 'pima', '', ''),
(2723, 31, 7, 1, 'York Springs', '', 'york-springs', '', ''),
(2724, 45, 2, 1, 'Portales', '', 'portales', '', ''),
(2725, 21, 8, 1, 'Parksley', '', 'parksley', '', ''),
(2726, 43, 2, 1, 'Hugo', '', 'hugo', '', ''),
(2727, 20, 8, 1, 'Islamorada', '', 'islamorada', '', ''),
(2728, 14, 8, 1, 'Eatonton', '', 'eatonton', '', ''),
(2729, 7, 7, 1, 'Eatontown', '', 'eatontown', '', ''),
(2730, 9, 4, 1, 'Daingerfield', '', 'daingerfield', '', ''),
(2731, 52, 4, 1, 'Pocahontas', '', 'pocahontas', '', ''),
(2732, 8, 7, 1, 'Eden', '', 'eden', '', ''),
(2733, 35, 5, 1, 'Grosse Pointe Shores', '', 'grosse-pointe-shores', '', ''),
(2734, 13, 9, 1, 'Yarmouth Port', '', 'yarmouth-port', '', ''),
(2735, 55, 3, 1, 'Kinsley', '', 'kinsley', '', ''),
(2736, 10, 1, 1, 'Tahoma', '', 'tahoma', '', ''),
(2737, 9, 4, 1, 'El Campo', '', 'el-campo', '', ''),
(2738, 48, 6, 1, 'Grand Bay', '', 'grand-bay', '', ''),
(2739, 45, 2, 1, 'Taos', '', 'taos', '', ''),
(2740, 8, 7, 1, 'East Aurora', '', 'east-aurora', '', ''),
(2741, 31, 7, 1, 'Eldred', '', 'eldred', '', ''),
(2742, 30, 5, 1, 'Sandusky', '', 'sandusky', '', ''),
(2743, 31, 7, 1, 'Ridgway', '', 'ridgway', '', ''),
(2744, 35, 5, 1, 'Elk Rapids', '', 'elk-rapids', '', ''),
(2745, 37, 6, 1, 'Elkhorn City', '', 'elkhorn-city', '', ''),
(2746, 49, 3, 1, 'Elkton', '', 'elkton', '', ''),
(2747, 9, 4, 1, 'Odessa', '', 'odessa', '', ''),
(2748, 17, 3, 1, 'Rogers', '', 'rogers', '', ''),
(2749, 20, 8, 1, 'Stuart', '', 'stuart', '', ''),
(2750, 55, 3, 1, 'Hays', '', 'hays', '', ''),
(2751, 26, 1, 1, 'La Grande', '', 'la-grande', '', ''),
(2752, 47, 3, 1, 'Ellsinore', '', 'ellsinore', '', ''),
(2753, 55, 3, 1, 'Ellsworth', '', 'ellsworth', '', ''),
(2754, 31, 7, 1, 'Ellwood City', '', 'ellwood-city', '', ''),
(2755, 8, 7, 1, 'Elma', '', 'elma', '', ''),
(2756, 61, 6, 1, 'Tupelo', '', 'tupelo', '', ''),
(2757, 57, 3, 1, 'Estherville', '', 'estherville', '', ''),
(2758, 8, 7, 1, 'Phoenicia', '', 'phoenicia', '', ''),
(2759, 49, 3, 1, 'Mitchell', '', 'mitchell', '', ''),
(2760, 17, 3, 1, 'Currie', '', 'currie', '', ''),
(2761, 41, 9, 1, 'Enfield', '', 'enfield', '', ''),
(2762, 35, 5, 1, 'Allendale', '', 'allendale', '', ''),
(2763, 9, 4, 1, 'Ennis', '', 'ennis', '', ''),
(2764, 47, 3, 1, 'Poplar Bluff', '', 'poplar-bluff', '', ''),
(2765, 39, 5, 1, 'Dana', '', 'dana', '', ''),
(2766, 14, 8, 1, 'Moreland', '', 'moreland', '', ''),
(2767, 10, 1, 1, 'Escalon', '', 'escalon', '', ''),
(2768, 7, 7, 1, 'Livingston', '', 'livingston', '', ''),
(2769, 20, 8, 1, 'Fort Myers Beach', '', 'fort-myers-beach', '', ''),
(2770, 8, 7, 1, 'Hartsdale', '', 'hartsdale', '', ''),
(2771, 50, 3, 1, 'Etowah', '', 'etowah', '', ''),
(2772, 20, 8, 1, 'Eustis', '', 'eustis', '', ''),
(2773, 20, 8, 1, 'Everglades City', '', 'everglades-city', '', ''),
(2774, 47, 3, 1, 'Excelsior Springs', '', 'excelsior-springs', '', ''),
(2775, 21, 8, 1, 'Gordonsville', '', 'gordonsville', '', ''),
(2776, 10, 1, 1, 'Rosamond', '', 'rosamond', '', ''),
(2777, 10, 1, 1, 'Helendale', '', 'helendale', '', ''),
(2778, 30, 5, 1, 'Miamisburg', '', 'miamisburg', '', ''),
(2779, 38, 9, 1, 'Saint Johnsbury', '', 'saint-johnsbury', '', ''),
(2780, 58, 3, 1, 'Fairbury', '', 'fairbury', '', ''),
(2781, 27, 8, 1, 'Winnsboro', '', 'winnsboro', '', ''),
(2782, 30, 5, 1, 'Fairport Harbor', '', 'fairport-harbor', '', ''),
(2783, 30, 5, 1, 'Mansfield', '', 'mansfield', '', ''),
(2784, 10, 1, 1, 'Fallbrook', '', 'fallbrook', '', ''),
(2785, 31, 7, 1, 'Ohiopyle', '', 'ohiopyle', '', ''),
(2786, 9, 4, 1, 'Marlin', '', 'marlin', '', ''),
(2787, 50, 3, 1, 'Belvidere', '', 'belvidere', '', ''),
(2788, 57, 3, 1, 'Bettendorf', '', 'bettendorf', '', ''),
(2789, 24, 2, 1, 'Payson', '', 'payson', '', ''),
(2790, 58, 3, 1, 'Gering', '', 'gering', '', ''),
(2791, 17, 3, 1, 'Waseca', '', 'waseca', '', ''),
(2792, 26, 1, 1, 'Klamath Falls', '', 'klamath-falls', '', ''),
(2793, 48, 6, 1, 'Fayette', '', 'fayette', '', ''),
(2794, 35, 5, 1, 'Garden', '', 'garden', '', ''),
(2795, 36, 5, 1, 'Fennimore', '', 'fennimore', '', ''),
(2796, 8, 7, 1, 'Jamestown', '', 'jamestown', '', ''),
(2797, 47, 3, 1, 'Fenton', '', 'fenton', '', ''),
(2798, 55, 3, 1, 'Oakley', '', 'oakley', '', ''),
(2799, 35, 5, 1, 'Fife Lake', '', 'fife-lake', '', ''),
(2800, 21, 8, 1, 'Yorktown', '', 'yorktown', '', ''),
(2801, 10, 1, 1, 'Fillmore', '', 'fillmore', '', ''),
(2802, 17, 3, 1, 'New York Mills', '', 'new-york-mills', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(2803, 55, 3, 1, 'Fort Riley', '', 'fort-riley', '', ''),
(2804, 23, 9, 1, 'New Harbor', '', 'new-harbor', '', ''),
(2805, 42, 5, 1, 'Rochelle', '', 'rochelle', '', ''),
(2806, 20, 8, 1, 'Palm Beach', '', 'palm-beach', '', ''),
(2807, 43, 2, 1, 'Fleming', '', 'fleming', '', ''),
(2808, 30, 5, 1, 'Glenford', '', 'glenford', '', ''),
(2809, 41, 9, 1, 'Old Lyme', '', 'old-lyme', '', ''),
(2810, 20, 8, 1, 'Apalachicola', '', 'apalachicola', '', ''),
(2811, 47, 3, 1, 'Florissant', '', 'florissant', '', ''),
(2812, 9, 4, 1, 'Floydada', '', 'floydada', '', ''),
(2813, 57, 3, 1, 'Charles City', '', 'charles-city', '', ''),
(2814, 12, 1, 1, 'Buckley', '', 'buckley', '', ''),
(2815, 9, 4, 1, 'Katy', '', 'katy', '', ''),
(2816, 44, 4, 1, 'Homer', '', 'homer', '', ''),
(2817, 36, 5, 1, 'Crandon', '', 'crandon', '', ''),
(2818, 32, 4, 1, 'Broken Bow', '', 'broken-bow', '', ''),
(2819, 12, 1, 1, 'Forks', '', 'forks', '', ''),
(2820, 55, 3, 1, 'Phillipsburg', '', 'phillipsburg', '', ''),
(2821, 8, 7, 1, 'Brewerton', '', 'brewerton', '', ''),
(2822, 60, 2, 1, 'Fort Bridger', '', 'fort-bridger', '', ''),
(2823, 8, 7, 1, 'Rensselaer', '', 'rensselaer', '', ''),
(2824, 36, 5, 1, 'Prairie Du Chien', '', 'prairie-du-chien', '', ''),
(2825, 10, 1, 1, 'Fall River Mills', '', 'fall-river-mills', '', ''),
(2826, 8, 7, 1, 'Narrowsburg', '', 'narrowsburg', '', ''),
(2827, 8, 7, 1, 'Fort Edward', '', 'fort-edward', '', ''),
(2828, 43, 2, 1, 'Fort Garland', '', 'fort-garland', '', ''),
(2829, 10, 1, 1, 'Fort Jones', '', 'fort-jones', '', ''),
(2830, 26, 1, 1, 'Fort Klamath', '', 'fort-klamath', '', ''),
(2831, 8, 7, 1, 'Saint Johnsville', '', 'saint-johnsville', '', ''),
(2832, 31, 7, 1, 'Masontown', '', 'masontown', '', ''),
(2833, 48, 6, 1, 'Gulf Shores', '', 'gulf-shores', '', ''),
(2834, 8, 7, 1, 'Oswego', '', 'oswego', '', ''),
(2835, 53, 2, 1, 'Fort Peck', '', 'fort-peck', '', ''),
(2836, 8, 7, 1, 'Fort Plain', '', 'fort-plain', '', ''),
(2837, 14, 8, 1, 'Tybee Island', '', 'tybee-island', '', ''),
(2838, 35, 5, 1, 'Niles', '', 'niles', '', ''),
(2839, 32, 4, 1, 'Fort Supply', '', 'fort-supply', '', ''),
(2840, 59, 3, 1, 'Fort Totten', '', 'fort-totten', '', ''),
(2841, 43, 2, 1, 'Platteville', '', 'platteville', '', ''),
(2842, 11, 2, 1, 'Camp Verde', '', 'camp-verde', '', ''),
(2843, 8, 7, 1, 'Lake George', '', 'lake-george', '', ''),
(2844, 60, 2, 1, 'Kemmerer', '', 'kemmerer', '', ''),
(2845, 11, 2, 1, 'Fountain Hills', '', 'fountain-hills', '', ''),
(2846, 43, 2, 1, 'Fowler', '', 'fowler', '', ''),
(2847, 12, 1, 1, 'Fox Island', '', 'fox-island', '', ''),
(2848, 42, 5, 1, 'South Elgin', '', 'south-elgin', '', ''),
(2849, 43, 2, 1, 'La Veta', '', 'la-veta', '', ''),
(2850, 19, 9, 1, 'Franconia', '', 'franconia', '', ''),
(2851, 17, 3, 1, 'Shafer', '', 'shafer', '', ''),
(2852, 36, 5, 1, 'Spring Green', '', 'spring-green', '', ''),
(2853, 35, 5, 1, 'Frankenmuth', '', 'frankenmuth', '', ''),
(2854, 55, 3, 1, 'Ottawa', '', 'ottawa', '', ''),
(2855, 42, 5, 1, 'Benton', '', 'benton', '', ''),
(2856, 30, 5, 1, 'New Athens', '', 'new-athens', '', ''),
(2857, 42, 5, 1, 'Urbana', '', 'urbana', '', ''),
(2858, 26, 1, 1, 'Milton Freewater', '', 'milton-freewater', '', ''),
(2859, 21, 8, 1, 'Appomattox', '', 'appomattox', '', ''),
(2860, 8, 7, 1, 'Ogdensburg', '', 'ogdensburg', '', ''),
(2861, 9, 4, 1, 'Pampa', '', 'pampa', '', ''),
(2862, 13, 9, 1, 'Assonet', '', 'assonet', '', ''),
(2863, 41, 9, 1, 'Rocky Hill', '', 'rocky-hill', '', ''),
(2864, 26, 1, 1, 'Hammond', '', 'hammond', '', ''),
(2865, 22, 8, 1, 'Beaufort', '', 'beaufort', '', ''),
(2866, 8, 7, 1, 'Union Springs', '', 'union-springs', '', ''),
(2867, 43, 2, 1, 'Glenwood Springs', '', 'glenwood-springs', '', ''),
(2868, 53, 2, 1, 'Deer Lodge', '', 'deer-lodge', '', ''),
(2869, 9, 4, 1, 'Bandera', '', 'bandera', '', ''),
(2870, 32, 4, 1, 'Crescent', '', 'crescent', '', ''),
(2871, 23, 9, 1, 'Fryeburg', '', 'fryeburg', '', ''),
(2872, 8, 7, 1, 'Munnsville', '', 'munnsville', '', ''),
(2873, 9, 4, 1, 'Brackettville', '', 'brackettville', '', ''),
(2874, 30, 5, 1, 'Fort Loramie', '', 'fort-loramie', '', ''),
(2875, 30, 5, 1, 'Fort Recovery', '', 'fort-recovery', '', ''),
(2876, 55, 3, 1, 'Wallace', '', 'wallace', '', ''),
(2877, 42, 5, 1, 'Oak Brook', '', 'oak-brook', '', ''),
(2878, 8, 7, 1, 'Gloversville', '', 'gloversville', '', ''),
(2879, 30, 5, 1, 'Wauseon', '', 'wauseon', '', ''),
(2880, 15, 8, 1, 'Snow Hill', '', 'snow-hill', '', ''),
(2881, 48, 6, 1, 'Gadsden', '', 'gadsden', '', ''),
(2882, 25, 10, 1, 'Waikoloa', '', 'waikoloa', '', ''),
(2883, 42, 5, 1, 'Galva', '', 'galva', '', ''),
(2884, 17, 3, 1, 'Scandia', '', 'scandia', '', ''),
(2885, 55, 3, 1, 'Lucas', '', 'lucas', '', ''),
(2886, 57, 3, 1, 'Arnolds Park', '', 'arnolds-park', '', ''),
(2887, 55, 3, 1, 'Gardner', '', 'gardner', '', ''),
(2888, 58, 3, 1, 'Burwell', '', 'burwell', '', ''),
(2889, 12, 1, 1, 'Pomeroy', '', 'pomeroy', '', ''),
(2890, 30, 5, 1, 'Mentor', '', 'mentor', '', ''),
(2891, 39, 5, 1, 'Garrett', '', 'garrett', '', ''),
(2892, 50, 3, 1, 'Sevierville', '', 'sevierville', '', ''),
(2893, 9, 4, 1, 'Post', '', 'post', '', ''),
(2894, 39, 5, 1, 'Gas City', '', 'gas-city', '', ''),
(2895, 47, 3, 1, 'Owensville', '', 'owensville', '', ''),
(2896, 9, 4, 1, 'Selman City', '', 'selman-city', '', ''),
(2897, 43, 2, 1, 'Gateway', '', 'gateway', '', ''),
(2898, 59, 3, 1, 'Bismarck', '', 'bismarck', '', ''),
(2899, 55, 3, 1, 'Junction City', '', 'junction-city', '', ''),
(2900, 31, 7, 1, 'Montoursville', '', 'montoursville', '', ''),
(2901, 47, 3, 1, 'Republic', '', 'republic', '', ''),
(2902, 8, 7, 1, 'Mumford', '', 'mumford', '', ''),
(2903, 42, 5, 1, 'Geneseo', '', 'geneseo', '', ''),
(2904, 8, 7, 1, 'Geneva', '', 'geneva', '', ''),
(2905, 36, 5, 1, 'Lake Geneva', '', 'lake-geneva', '', ''),
(2906, 51, 2, 1, 'Genoa', '', 'genoa', '', ''),
(2907, 43, 2, 1, 'Silver Plume', '', 'silver-plume', '', ''),
(2908, 36, 5, 1, 'Lac Du Flambeau', '', 'lac-du-flambeau', '', ''),
(2909, 31, 7, 1, 'Wilmerding', '', 'wilmerding', '', ''),
(2910, 14, 8, 1, 'Leslie', '', 'leslie', '', ''),
(2911, 14, 8, 1, 'Midway', '', 'midway', '', ''),
(2912, 14, 8, 1, 'Hinesville', '', 'hinesville', '', ''),
(2913, 14, 8, 1, 'Winterville', '', 'winterville', '', ''),
(2914, 14, 8, 1, 'Milledgeville', '', 'milledgeville', '', ''),
(2915, 30, 5, 1, 'Olmsted Falls', '', 'olmsted-falls', '', ''),
(2916, 44, 4, 1, 'Minden', '', 'minden', '', ''),
(2917, 36, 5, 1, 'Fish Creek', '', 'fish-creek', '', ''),
(2918, 12, 1, 1, 'Gig Harbor', '', 'gig-harbor', '', ''),
(2919, 8, 7, 1, 'Gilboa', '', 'gilboa', '', ''),
(2920, 35, 5, 1, 'Hickory Corners', '', 'hickory-corners', '', ''),
(2921, 43, 2, 1, 'Central City', '', 'central-city', '', ''),
(2922, 35, 5, 1, 'Grand Marais', '', 'grand-marais', '', ''),
(2923, 35, 5, 1, 'Gladwin', '', 'gladwin', '', ''),
(2924, 30, 5, 1, 'Fostoria', '', 'fostoria', '', ''),
(2925, 42, 5, 1, 'Glen Ellyn', '', 'glen-ellyn', '', ''),
(2926, 30, 5, 1, 'New Concord', '', 'new-concord', '', ''),
(2927, 60, 2, 1, 'Glenrock', '', 'glenrock', '', ''),
(2928, 26, 1, 1, 'Gold Hill', '', 'gold-hill', '', ''),
(2929, 14, 8, 1, 'Dahlonega', '', 'dahlonega', '', ''),
(2930, 10, 1, 1, 'Paradise', '', 'paradise', '', ''),
(2931, 26, 1, 1, 'Sumpter', '', 'sumpter', '', ''),
(2932, 31, 7, 1, 'Bethel', '', 'bethel', '', ''),
(2933, 47, 3, 1, 'Cassville', '', 'cassville', '', ''),
(2934, 59, 3, 1, 'Beach', '', 'beach', '', ''),
(2935, 7, 7, 1, 'Seaside Heights', '', 'seaside-heights', '', ''),
(2936, 30, 5, 1, 'Gomer', '', 'gomer', '', ''),
(2937, 9, 4, 1, 'Gonzales', '', 'gonzales', '', ''),
(2938, 31, 7, 1, 'Edinboro', '', 'edinboro', '', ''),
(2939, 17, 3, 1, 'Red Wing', '', 'red-wing', '', ''),
(2940, 26, 1, 1, 'Silverton', '', 'silverton', '', ''),
(2941, 36, 5, 1, 'Gordon', '', 'gordon', '', ''),
(2942, 12, 1, 1, 'Bingen', '', 'bingen', '', ''),
(2943, 8, 7, 1, 'Gouverneur', '', 'gouverneur', '', ''),
(2944, 9, 4, 1, 'George West', '', 'george-west', '', ''),
(2945, 10, 1, 1, 'Ukiah', '', 'ukiah', '', ''),
(2946, 32, 4, 1, 'Chickasha', '', 'chickasha', '', ''),
(2947, 47, 3, 1, 'Granby', '', 'granby', '', ''),
(2948, 35, 5, 1, 'Grand Blanc', '', 'grand-blanc', '', ''),
(2949, 43, 2, 1, 'Hot Sulphur Springs', '', 'hot-sulphur-springs', '', ''),
(2950, 49, 3, 1, 'Lemmon', '', 'lemmon', '', ''),
(2951, 36, 5, 1, 'Markesan', '', 'markesan', '', ''),
(2952, 61, 6, 1, 'Natchez', '', 'natchez', '', ''),
(2953, 26, 1, 1, 'Canyon City', '', 'canyon-city', '', ''),
(2954, 49, 3, 1, 'Milbank', '', 'milbank', '', ''),
(2955, 20, 8, 1, 'Grant', '', 'grant', '', ''),
(2956, 26, 1, 1, 'Grants Pass', '', 'grants-pass', '', ''),
(2957, 52, 4, 1, 'Gravette', '', 'gravette', '', ''),
(2958, 8, 7, 1, 'Derby', '', 'derby', '', ''),
(2959, 42, 5, 1, 'Grayslake', '', 'grayslake', '', ''),
(2960, 31, 7, 1, 'Coatesville', '', 'coatesville', '', ''),
(2961, 7, 7, 1, 'Flemington', '', 'flemington', '', ''),
(2962, 30, 5, 1, 'Vermilion', '', 'vermilion', '', ''),
(2963, 35, 5, 1, 'Rogers City', '', 'rogers-city', '', ''),
(2964, 35, 5, 1, 'Orchard Lake', '', 'orchard-lake', '', ''),
(2965, 44, 4, 1, 'Winnfield', '', 'winnfield', '', ''),
(2966, 10, 1, 1, 'Shafter', '', 'shafter', '', ''),
(2967, 60, 2, 1, 'Big Piney', '', 'big-piney', '', ''),
(2968, 31, 7, 1, 'Waynesburg', '', 'waynesburg', '', ''),
(2969, 42, 5, 1, 'Westmont', '', 'westmont', '', ''),
(2970, 60, 2, 1, 'Greybull', '', 'greybull', '', ''),
(2971, 17, 3, 1, 'Hibbing', '', 'hibbing', '', ''),
(2972, 10, 1, 1, 'Gridley', '', 'gridley', '', ''),
(2973, 39, 5, 1, 'Griffith', '', 'griffith', '', ''),
(2974, 36, 5, 1, 'Kaukauna', '', 'kaukauna', '', ''),
(2975, 35, 5, 1, 'Grosse Ile', '', 'grosse-ile', '', ''),
(2976, 35, 5, 1, 'Grosse Pointe Farms', '', 'grosse-pointe-farms', '', ''),
(2977, 35, 5, 1, 'Jonesville', '', 'jonesville', '', ''),
(2978, 57, 3, 1, 'West Bend', '', 'west-bend', '', ''),
(2979, 10, 1, 1, 'Gualala', '', 'gualala', '', ''),
(2980, 31, 7, 1, 'Grove City', '', 'grove-city', '', ''),
(2981, 42, 5, 1, 'Glenview', '', 'glenview', '', ''),
(2982, 10, 1, 1, 'Groveland', '', 'groveland', '', ''),
(2983, 14, 8, 1, 'Grovetown', '', 'grovetown', '', ''),
(2984, 57, 3, 1, 'Reinbeck', '', 'reinbeck', '', ''),
(2985, 20, 8, 1, 'St Pete Beach', '', 'st-pete-beach', '', ''),
(2986, 20, 8, 1, 'Osprey', '', 'osprey', '', ''),
(2987, 20, 8, 1, 'Gulfport', '', 'gulfport', '', ''),
(2988, 57, 3, 1, 'Panora', '', 'panora', '', ''),
(2989, 21, 8, 1, 'Gwynn', '', 'gwynn', '', ''),
(2990, 36, 5, 1, 'Wisconsin Dells', '', 'wisconsin-dells', '', ''),
(2991, 41, 9, 1, 'Haddam', '', 'haddam', '', ''),
(2992, 56, 2, 1, 'Hagerman', '', 'hagerman', '', ''),
(2993, 9, 4, 1, 'Hale Center', '', 'hale-center', '', ''),
(2994, 20, 8, 1, 'Daytona Beach', '', 'daytona-beach', '', ''),
(2995, 50, 3, 1, 'Tellico Plains', '', 'tellico-plains', '', ''),
(2996, 21, 8, 1, 'New Market', '', 'new-market', '', ''),
(2997, 13, 9, 1, 'Turners Falls', '', 'turners-falls', '', ''),
(2998, 8, 7, 1, 'Riverhead', '', 'riverhead', '', ''),
(2999, 8, 7, 1, 'Southampton', '', 'southampton', '', ''),
(3000, 55, 3, 1, 'Halstead', '', 'halstead', '', ''),
(3001, 42, 5, 1, 'Metropolis', '', 'metropolis', '', ''),
(3002, 39, 5, 1, 'Noblesville', '', 'noblesville', '', ''),
(3003, 23, 9, 1, 'South Berwick', '', 'south-berwick', '', ''),
(3004, 36, 5, 1, 'Two Rivers', '', 'two-rivers', '', ''),
(3005, 8, 7, 1, 'North Salem', '', 'north-salem', '', ''),
(3006, 52, 4, 1, 'Wilson', '', 'wilson', '', ''),
(3007, 15, 8, 1, 'Hampstead', '', 'hampstead', '', ''),
(3008, 25, 10, 1, 'Hana', '', 'hana', '', ''),
(3009, 30, 5, 1, 'Findlay', '', 'findlay', '', ''),
(3010, 15, 8, 1, 'Hancock', '', 'hancock', '', ''),
(3011, 8, 7, 1, 'Ticonderoga', '', 'ticonderoga', '', ''),
(3012, 10, 1, 1, 'Healdsburg', '', 'healdsburg', '', ''),
(3013, 13, 9, 1, 'Ayer', '', 'ayer', '', ''),
(3014, 50, 3, 1, 'Tullahoma', '', 'tullahoma', '', ''),
(3015, 8, 7, 1, 'East Meredith', '', 'east-meredith', '', ''),
(3016, 9, 4, 1, 'Big Spring', '', 'big-spring', '', ''),
(3017, 39, 5, 1, 'Mishawaka', '', 'mishawaka', '', ''),
(3018, 32, 4, 1, 'Grove', '', 'grove', '', ''),
(3019, 35, 5, 1, 'Harbor Springs', '', 'harbor-springs', '', ''),
(3020, 35, 5, 1, 'Crystal Falls', '', 'crystal-falls', '', ''),
(3021, 9, 4, 1, 'Quanah', '', 'quanah', '', ''),
(3022, 57, 3, 1, 'Eldora', '', 'eldora', '', ''),
(3023, 47, 3, 1, 'West Plains', '', 'west-plains', '', ''),
(3024, 31, 7, 1, 'Harmony', '', 'harmony', '', ''),
(3025, 26, 1, 1, 'Burns', '', 'burns', '', ''),
(3026, 37, 6, 1, 'Maysville', '', 'maysville', '', ''),
(3027, 16, 8, 1, 'Harrington', '', 'harrington', '', ''),
(3028, 57, 3, 1, 'Missouri Valley', '', 'missouri-valley', '', ''),
(3029, 42, 5, 1, 'Herrin', '', 'herrin', '', ''),
(3030, 37, 6, 1, 'Harrodsburg', '', 'harrodsburg', '', ''),
(3031, 19, 9, 1, 'Intervale', '', 'intervale', '', ''),
(3032, 45, 2, 1, 'Belen', '', 'belen', '', ''),
(3033, 32, 4, 1, 'Stigler', '', 'stigler', '', ''),
(3034, 25, 10, 1, 'Kapolei', '', 'kapolei', '', ''),
(3035, 59, 3, 1, 'Wolford', '', 'wolford', '', ''),
(3036, 36, 5, 1, 'Delafield', '', 'delafield', '', ''),
(3037, 43, 2, 1, 'Hayden', '', 'hayden', '', ''),
(3038, 39, 5, 1, 'North Vernon', '', 'north-vernon', '', ''),
(3039, 10, 1, 1, 'Hayward', '', 'hayward', '', ''),
(3040, 31, 7, 1, 'Girard', '', 'girard', '', ''),
(3041, 53, 2, 1, 'Three Forks', '', 'three-forks', '', ''),
(3042, 43, 2, 1, 'Glen Haven', '', 'glen-haven', '', ''),
(3043, 48, 6, 1, 'Calera', '', 'calera', '', ''),
(3044, 35, 5, 1, 'Dowagiac', '', 'dowagiac', '', ''),
(3045, 17, 3, 1, 'Maynard', '', 'maynard', '', ''),
(3046, 31, 7, 1, 'Wernersville', '', 'wernersville', '', ''),
(3047, 53, 2, 1, 'Glendive', '', 'glendive', '', ''),
(3048, 52, 4, 1, 'Piggott', '', 'piggott', '', ''),
(3049, 23, 9, 1, 'Southport', '', 'southport', '', ''),
(3050, 17, 3, 1, 'Shakopee', '', 'shakopee', '', ''),
(3051, 58, 3, 1, 'Cozad', '', 'cozad', '', ''),
(3052, 9, 4, 1, 'Kingsville', '', 'kingsville', '', ''),
(3053, 57, 3, 1, 'Orient', '', 'orient', '', ''),
(3054, 52, 4, 1, 'Hope', '', 'hope', '', ''),
(3055, 32, 4, 1, 'Henryetta', '', 'henryetta', '', ''),
(3056, 37, 6, 1, 'Hickman', '', 'hickman', '', ''),
(3057, 36, 5, 1, 'New Richmond', '', 'new-richmond', '', ''),
(3058, 10, 1, 1, 'Tulare', '', 'tulare', '', ''),
(3059, 20, 8, 1, 'Winter Garden', '', 'winter-garden', '', ''),
(3060, 42, 5, 1, 'Okawville', '', 'okawville', '', ''),
(3061, 52, 4, 1, 'Mount Ida', '', 'mount-ida', '', ''),
(3062, 10, 1, 1, 'Mccloud', '', 'mccloud', '', ''),
(3063, 9, 4, 1, 'Seguin', '', 'seguin', '', ''),
(3064, 9, 4, 1, 'Falfurrias', '', 'falfurrias', '', ''),
(3065, 53, 2, 1, 'Libby', '', 'libby', '', ''),
(3066, 49, 3, 1, 'Sisseton', '', 'sisseton', '', ''),
(3067, 9, 4, 1, 'Weimar', '', 'weimar', '', ''),
(3068, 17, 3, 1, 'Mountain Lake', '', 'mountain-lake', '', ''),
(3069, 44, 4, 1, 'Tallulah', '', 'tallulah', '', ''),
(3070, 10, 1, 1, 'Yucca Valley', '', 'yucca-valley', '', ''),
(3071, 30, 5, 1, 'Elyria', '', 'elyria', '', ''),
(3072, 9, 4, 1, 'Hidalgo', '', 'hidalgo', '', ''),
(3073, 22, 8, 1, 'Taylorsville', '', 'taylorsville', '', ''),
(3074, 22, 8, 1, 'Hiddenite', '', 'hiddenite', '', ''),
(3075, 36, 5, 1, 'Couderay', '', 'couderay', '', ''),
(3076, 37, 6, 1, 'Campbellsville', '', 'campbellsville', '', ''),
(3077, 21, 8, 1, 'Tazewell', '', 'tazewell', '', ''),
(3078, 57, 3, 1, 'Okoboji', '', 'okoboji', '', ''),
(3079, 55, 3, 1, 'Goodland', '', 'goodland', '', ''),
(3080, 13, 9, 1, 'Truro', '', 'truro', '', ''),
(3081, 61, 6, 1, 'Leland', '', 'leland', '', ''),
(3082, 9, 4, 1, 'Kerrville', '', 'kerrville', '', ''),
(3083, 17, 3, 1, 'Hinckley', '', 'hinckley', '', ''),
(3084, 13, 9, 1, 'Hingham', '', 'hingham', '', ''),
(3085, 32, 4, 1, 'Hinton', '', 'hinton', '', ''),
(3086, 42, 5, 1, 'Roscoe', '', 'roscoe', '', ''),
(3087, 27, 8, 1, 'Mc Connells', '', 'mc-connells', '', ''),
(3088, 22, 8, 1, 'Morganton', '', 'morganton', '', ''),
(3089, 39, 5, 1, 'Connersville', '', 'connersville', '', ''),
(3090, 61, 6, 1, 'Hernando', '', 'hernando', '', ''),
(3091, 44, 4, 1, 'Donaldsonville', '', 'donaldsonville', '', ''),
(3092, 8, 7, 1, 'Tarrytown', '', 'tarrytown', '', ''),
(3093, 36, 5, 1, 'Portage', '', 'portage', '', ''),
(3094, 39, 5, 1, 'Cambridge City', '', 'cambridge-city', '', ''),
(3095, 13, 9, 1, 'Sudbury', '', 'sudbury', '', ''),
(3096, 39, 5, 1, 'New Harmony', '', 'new-harmony', '', ''),
(3097, 7, 7, 1, 'Nutley', '', 'nutley', '', ''),
(3098, 8, 7, 1, 'Saranac Lake', '', 'saranac-lake', '', ''),
(3099, 31, 7, 1, 'Schaefferstown', '', 'schaefferstown', '', ''),
(3100, 9, 4, 1, 'Gilmer', '', 'gilmer', '', ''),
(3101, 35, 5, 1, 'Cheboygan', '', 'cheboygan', '', ''),
(3102, 36, 5, 1, 'Wisconsin Rapids', '', 'wisconsin-rapids', '', ''),
(3103, 32, 4, 1, 'Norman', '', 'norman', '', ''),
(3104, 57, 3, 1, 'Storm Lake', '', 'storm-lake', '', ''),
(3105, 7, 7, 1, 'Ocean View', '', 'ocean-view', '', ''),
(3106, 10, 1, 1, 'Arcata', '', 'arcata', '', ''),
(3107, 57, 3, 1, 'Coralville', '', 'coralville', '', ''),
(3108, 7, 7, 1, 'Bloomfield', '', 'bloomfield', '', ''),
(3109, 41, 9, 1, 'East Hartford', '', 'east-hartford', '', ''),
(3110, 20, 8, 1, 'Fort Meade', '', 'fort-meade', '', ''),
(3111, 7, 7, 1, 'Ocean Grove', '', 'ocean-grove', '', ''),
(3112, 7, 7, 1, 'Penns Grove', '', 'penns-grove', '', ''),
(3113, 10, 1, 1, 'Temple City', '', 'temple-city', '', ''),
(3114, 8, 7, 1, 'East Bloomfield', '', 'east-bloomfield', '', ''),
(3115, 22, 8, 1, 'Holly Ridge', '', 'holly-ridge', '', ''),
(3116, 26, 1, 1, 'Rickreall', '', 'rickreall', '', ''),
(3117, 33, 8, 1, 'Welch', '', 'welch', '', ''),
(3118, 17, 3, 1, 'Perham', '', 'perham', '', ''),
(3119, 36, 5, 1, 'Fort Atkinson', '', 'fort-atkinson', '', ''),
(3120, 57, 3, 1, 'Britt', '', 'britt', '', ''),
(3121, 7, 7, 1, 'Lambertville', '', 'lambertville', '', ''),
(3122, 30, 5, 1, 'Willoughby', '', 'willoughby', '', ''),
(3123, 36, 5, 1, 'Stone Lake', '', 'stone-lake', '', ''),
(3124, 8, 7, 1, 'Glen Cove', '', 'glen-cove', '', ''),
(3125, 35, 5, 1, 'Farmington Hills', '', 'farmington-hills', '', ''),
(3126, 47, 3, 1, 'Mound City', '', 'mound-city', '', ''),
(3127, 50, 3, 1, 'Crossville', '', 'crossville', '', ''),
(3128, 60, 2, 1, 'Powell', '', 'powell', '', ''),
(3129, 35, 5, 1, 'Marshall', '', 'marshall', '', ''),
(3130, 9, 4, 1, 'Granbury', '', 'granbury', '', ''),
(3131, 26, 1, 1, 'Hood River', '', 'hood-river', '', ''),
(3132, 60, 2, 1, 'Kaycee', '', 'kaycee', '', ''),
(3133, 13, 9, 1, 'North Adams', '', 'north-adams', '', ''),
(3134, 57, 3, 1, 'West Branch', '', 'west-branch', '', ''),
(3135, 11, 2, 1, 'Second Mesa', '', 'second-mesa', '', ''),
(3136, 37, 6, 1, 'Hopkinsville', '', 'hopkinsville', '', ''),
(3137, 7, 7, 1, 'Saddle River', '', 'saddle-river', '', ''),
(3138, 36, 5, 1, 'Horicon', '', 'horicon', '', ''),
(3139, 15, 8, 1, 'Gambrills', '', 'gambrills', '', ''),
(3140, 8, 7, 1, 'Horseheads', '', 'horseheads', '', ''),
(3141, 43, 2, 1, 'Hotchkiss', '', 'hotchkiss', '', ''),
(3142, 52, 4, 1, 'Hot Springs', '', 'hot-springs', '', ''),
(3143, 35, 5, 1, 'Hubbell', '', 'hubbell', '', ''),
(3144, 35, 5, 1, 'Houghton Lake', '', 'houghton-lake', '', ''),
(3145, 14, 8, 1, 'Warner Robins', '', 'warner-robins', '', ''),
(3146, 15, 8, 1, 'West Friendship', '', 'west-friendship', '', ''),
(3147, 11, 2, 1, 'Fort Huachuca', '', 'fort-huachuca', '', ''),
(3148, 17, 3, 1, 'Park Rapids', '', 'park-rapids', '', ''),
(3149, 45, 2, 1, 'Ruidoso Downs', '', 'ruidoso-downs', '', ''),
(3150, 32, 4, 1, 'Holdenville', '', 'holdenville', '', ''),
(3151, 25, 10, 1, 'Kailua Kona', '', 'kailua-kona', '', ''),
(3152, 13, 9, 1, 'Hull', '', 'hull', '', ''),
(3153, 57, 3, 1, 'Dakota City', '', 'dakota-city', '', ''),
(3154, 51, 2, 1, 'Winnemucca', '', 'winnemucca', '', ''),
(3155, 42, 5, 1, 'Mendota', '', 'mendota', '', ''),
(3156, 50, 3, 1, 'Waverly', '', 'waverly', '', ''),
(3157, 7, 7, 1, 'Passaic', '', 'passaic', '', ''),
(3158, 12, 1, 1, 'Hunters', '', 'hunters', '', ''),
(3159, 31, 7, 1, 'Tionesta', '', 'tionesta', '', ''),
(3160, 50, 3, 1, 'Huntingdon', '', 'huntingdon', '', ''),
(3161, 41, 9, 1, 'Scotland', '', 'scotland', '', ''),
(3162, 53, 2, 1, 'Huntley', '', 'huntley', '', ''),
(3163, 8, 7, 1, 'Hurley', '', 'hurley', '', ''),
(3164, 35, 5, 1, 'Port Austin', '', 'port-austin', '', ''),
(3165, 24, 2, 1, 'Hurricane', '', 'hurricane', '', ''),
(3166, 9, 4, 1, 'Borger', '', 'borger', '', ''),
(3167, 26, 1, 1, 'Mount Hood Parkdale', '', 'mount-hood-parkdale', '', ''),
(3168, 49, 3, 1, 'Highmore', '', 'highmore', '', ''),
(3169, 44, 4, 1, 'Plaquemine', '', 'plaquemine', '', ''),
(3170, 9, 4, 1, 'Silsbee', '', 'silsbee', '', ''),
(3171, 56, 2, 1, 'Idaho City', '', 'idaho-city', '', ''),
(3172, 56, 2, 1, 'Blackfoot', '', 'blackfoot', '', ''),
(3173, 35, 5, 1, 'Idlewild', '', 'idlewild', '', ''),
(3174, 42, 5, 1, 'Bolingbrook', '', 'bolingbrook', '', ''),
(3175, 42, 5, 1, 'Pontiac', '', 'pontiac', '', ''),
(3176, 51, 2, 1, 'Searchlight', '', 'searchlight', '', ''),
(3177, 7, 7, 1, 'Mantua', '', 'mantua', '', ''),
(3178, 35, 5, 1, 'Imlay City', '', 'imlay-city', '', ''),
(3179, 57, 3, 1, 'Emerson', '', 'emerson', '', ''),
(3180, 30, 5, 1, 'Painesville', '', 'painesville', '', ''),
(3181, 20, 8, 1, 'Fort Walton Bch', '', 'fort-walton-bch', '', ''),
(3182, 32, 4, 1, 'Caddo', '', 'caddo', '', ''),
(3183, 39, 5, 1, 'Vincennes', '', 'vincennes', '', ''),
(3184, 8, 7, 1, 'Dresden', '', 'dresden', '', ''),
(3185, 20, 8, 1, 'Panama City Beach', '', 'panama-city-beach', '', ''),
(3186, 61, 6, 1, 'Petal', '', 'petal', '', ''),
(3187, 32, 4, 1, 'Guthrie', '', 'guthrie', '', ''),
(3188, 9, 4, 1, 'Marble Falls', '', 'marble-falls', '', ''),
(3189, 17, 3, 1, 'Bovey', '', 'bovey', '', ''),
(3190, 49, 3, 1, 'Roslyn', '', 'roslyn', '', ''),
(3191, 35, 5, 1, 'East Tawas', '', 'east-tawas', '', ''),
(3192, 57, 3, 1, 'Marengo', '', 'marengo', '', ''),
(3193, 9, 4, 1, 'Iraan', '', 'iraan', '', ''),
(3194, 8, 7, 1, 'Port Henry', '', 'port-henry', '', ''),
(3195, 35, 5, 1, 'Caspian', '', 'caspian', '', ''),
(3196, 24, 2, 1, 'Cedar City', '', 'cedar-city', '', ''),
(3197, 36, 5, 1, 'Iron River', '', 'iron-river', '', ''),
(3198, 34, 1, 1, 'Sitka', '', 'sitka', '', ''),
(3199, 12, 1, 1, 'Coupeville', '', 'coupeville', '', ''),
(3200, 23, 9, 1, 'Northeast Harbor', '', 'northeast-harbor', '', ''),
(3201, 23, 9, 1, 'Islesboro', '', 'islesboro', '', ''),
(3202, 12, 1, 1, 'Issaquah', '', 'issaquah', '', ''),
(3203, 42, 5, 1, 'Itasca', '', 'itasca', '', ''),
(3204, 45, 2, 1, 'Rio Rancho', '', 'rio-rancho', '', ''),
(3205, 56, 2, 1, 'Pierce', '', 'pierce', '', ''),
(3206, 53, 2, 1, 'Virginia City', '', 'virginia-city', '', ''),
(3207, 10, 1, 1, 'Joshua Tree', '', 'joshua-tree', '', ''),
(3208, 9, 4, 1, 'Jacksboro', '', 'jacksboro', '', ''),
(3209, 47, 3, 1, 'Lees Summit', '', 'lees-summit', '', ''),
(3210, 47, 3, 1, 'Sibley', '', 'sibley', '', ''),
(3211, 39, 5, 1, 'Brownstown', '', 'brownstown', '', ''),
(3212, 17, 3, 1, 'Lakefield', '', 'lakefield', '', ''),
(3213, 55, 3, 1, 'Holton', '', 'holton', '', ''),
(3214, 8, 7, 1, 'Jamesville', '', 'jamesville', '', ''),
(3215, 55, 3, 1, 'Chapman', '', 'chapman', '', ''),
(3216, 14, 8, 1, 'Fitzgerald', '', 'fitzgerald', '', ''),
(3217, 45, 2, 1, 'Jemez Pueblo', '', 'jemez-pueblo', '', ''),
(3218, 48, 6, 1, 'Talladega', '', 'talladega', '', ''),
(3219, 31, 7, 1, 'Pottsville', '', 'pottsville', '', ''),
(3220, 42, 5, 1, 'Jerseyville', '', 'jerseyville', '', ''),
(3221, 42, 5, 1, 'Somonauk', '', 'somonauk', '', ''),
(3222, 33, 8, 1, 'Harpers Ferry', '', 'harpers-ferry', '', ''),
(3223, 35, 5, 1, 'Okemos', '', 'okemos', '', ''),
(3224, 30, 5, 1, 'Coshocton', '', 'coshocton', '', ''),
(3225, 42, 5, 1, 'Joliet', '', 'joliet', '', ''),
(3226, 50, 3, 1, 'Jonesborough', '', 'jonesborough', '', ''),
(3227, 9, 4, 1, 'Marfa', '', 'marfa', '', ''),
(3228, 10, 1, 1, 'Julian', '', 'julian', '', ''),
(3229, 20, 8, 1, 'Panama City', '', 'panama-city', '', ''),
(3230, 8, 7, 1, 'Center Moriches', '', 'center-moriches', '', ''),
(3231, 26, 1, 1, 'John Day', '', 'john-day', '', ''),
(3232, 17, 3, 1, 'Mora', '', 'mora', '', ''),
(3233, 31, 7, 1, 'Kane', '', 'kane', '', ''),
(3234, 14, 8, 1, 'Dawsonville', '', 'dawsonville', '', ''),
(3235, 42, 5, 1, 'Kankakee', '', 'kankakee', '', ''),
(3236, 55, 3, 1, 'Marquette', '', 'marquette', '', ''),
(3237, 9, 4, 1, 'Karnes City', '', 'karnes-city', '', ''),
(3238, 8, 7, 1, 'Katonah', '', 'katonah', '', ''),
(3239, 43, 2, 1, 'Grand Lake', '', 'grand-lake', '', ''),
(3240, 32, 4, 1, 'Kaw City', '', 'kaw-city', '', ''),
(3241, 55, 3, 1, 'Council Grove', '', 'council-grove', '', ''),
(3242, 7, 7, 1, 'Perth Amboy', '', 'perth-amboy', '', ''),
(3243, 7, 7, 1, 'Kearny', '', 'kearny', '', ''),
(3244, 17, 3, 1, 'Elk River', '', 'elk-river', '', ''),
(3245, 10, 1, 1, 'Mendocino', '', 'mendocino', '', ''),
(3246, 30, 5, 1, 'Kelleys Island', '', 'kelleys-island', '', ''),
(3247, 22, 8, 1, 'Pinebluff', '', 'pinebluff', '', ''),
(3248, 44, 4, 1, 'Kenner', '', 'kenner', '', ''),
(3249, 36, 5, 1, 'Pleasant Prairie', '', 'pleasant-prairie', '', ''),
(3250, 31, 7, 1, 'Chalk Hill', '', 'chalk-hill', '', ''),
(3251, 37, 6, 1, 'Benham', '', 'benham', '', ''),
(3252, 26, 1, 1, 'Kerby', '', 'kerby', '', ''),
(3253, 10, 1, 1, 'Taft', '', 'taft', '', ''),
(3254, 10, 1, 1, 'Kernville', '', 'kernville', '', ''),
(3255, 32, 4, 1, 'Poteau', '', 'poteau', '', ''),
(3256, 56, 2, 1, 'Ketchum', '', 'ketchum', '', ''),
(3257, 42, 5, 1, 'Kewanee', '', 'kewanee', '', ''),
(3258, 35, 5, 1, 'Mohawk', '', 'mohawk', '', ''),
(3259, 7, 7, 1, 'Keyport', '', 'keyport', '', ''),
(3260, 49, 3, 1, 'Keystone', '', 'keystone', '', ''),
(3261, 9, 4, 1, 'Lampasas', '', 'lampasas', '', ''),
(3262, 10, 1, 1, 'Dunsmuir', '', 'dunsmuir', '', ''),
(3263, 9, 4, 1, 'Kilgore', '', 'kilgore', '', ''),
(3264, 21, 8, 1, 'Kilmarnock', '', 'kilmarnock', '', ''),
(3265, 9, 4, 1, 'Junction', '', 'junction', '', ''),
(3266, 11, 2, 1, 'Kingman', '', 'kingman', '', ''),
(3267, 22, 8, 1, 'Kings Mountain', '', 'kings-mountain', '', ''),
(3268, 50, 3, 1, 'Kingsport', '', 'kingsport', '', ''),
(3269, 8, 7, 1, 'Lake Luzerne', '', 'lake-luzerne', '', ''),
(3270, 35, 5, 1, 'Kinross', '', 'kinross', '', ''),
(3271, 21, 8, 1, 'Kinsale', '', 'kinsale', '', ''),
(3272, 43, 2, 1, 'Eads', '', 'eads', '', ''),
(3273, 9, 4, 1, 'Kountze', '', 'kountze', '', ''),
(3274, 9, 4, 1, 'Kirbyville', '', 'kirbyville', '', ''),
(3275, 48, 6, 1, 'Tuskegee', '', 'tuskegee', '', ''),
(3276, 23, 9, 1, 'Kittery', '', 'kittery', '', ''),
(3277, 17, 3, 1, 'Lake Bronson', '', 'lake-bronson', '', ''),
(3278, 43, 2, 1, 'La Junta', '', 'la-junta', '', ''),
(3279, 49, 3, 1, 'Parkston', '', 'parkston', '', ''),
(3280, 49, 3, 1, 'Mobridge', '', 'mobridge', '', ''),
(3281, 34, 1, 1, 'Wasilla', '', 'wasilla', '', ''),
(3282, 36, 5, 1, 'Cedarburg', '', 'cedarburg', '', ''),
(3283, 42, 5, 1, 'Wilmette', '', 'wilmette', '', ''),
(3284, 25, 10, 1, 'Hanapepe', '', 'hanapepe', '', ''),
(3285, 25, 10, 1, 'Kealakekua', '', 'kealakekua', '', ''),
(3286, 17, 3, 1, 'International Falls', '', 'international-falls', '', ''),
(3287, 42, 5, 1, 'Tuscola', '', 'tuscola', '', ''),
(3288, 17, 3, 1, 'Minnesota Lake', '', 'minnesota-lake', '', ''),
(3289, 27, 8, 1, 'Lake City', '', 'lake-city', '', ''),
(3290, 30, 5, 1, 'Hubbard', '', 'hubbard', '', ''),
(3291, 12, 1, 1, 'La Conner', '', 'la-conner', '', ''),
(3292, 9, 4, 1, 'San Ygnacio', '', 'san-ygnacio', '', ''),
(3293, 20, 8, 1, 'Labelle', '', 'labelle', '', ''),
(3294, 12, 1, 1, 'Lacey', '', 'lacey', '', ''),
(3295, 48, 6, 1, 'Andalusia', '', 'andalusia', '', ''),
(3296, 10, 1, 1, 'Lake Arrowhead', '', 'lake-arrowhead', '', ''),
(3297, 17, 3, 1, 'Lake Benton', '', 'lake-benton', '', ''),
(3298, 42, 5, 1, 'Lake Bluff', '', 'lake-bluff', '', ''),
(3299, 12, 1, 1, 'Chelan', '', 'chelan', '', ''),
(3300, 17, 3, 1, 'Two Harbors', '', 'two-harbors', '', ''),
(3301, 10, 1, 1, 'Lakeport', '', 'lakeport', '', ''),
(3302, 30, 5, 1, 'Put In Bay', '', 'put-in-bay', '', ''),
(3303, 8, 7, 1, 'Bolton Landing', '', 'bolton-landing', '', ''),
(3304, 11, 2, 1, 'Lake Havasu City', '', 'lake-havasu-city', '', ''),
(3305, 7, 7, 1, 'Landing', '', 'landing', '', ''),
(3306, 44, 4, 1, 'Madisonville', '', 'madisonville', '', ''),
(3307, 59, 3, 1, 'Devils Lake', '', 'devils-lake', '', ''),
(3308, 10, 1, 1, 'South Lake Tahoe', '', 'south-lake-tahoe', '', ''),
(3309, 22, 8, 1, 'Lake Waccamaw', '', 'lake-waccamaw', '', ''),
(3310, 20, 8, 1, 'Lake Wales', '', 'lake-wales', '', ''),
(3311, 7, 7, 1, 'Lakehurst', '', 'lakehurst', '', ''),
(3312, 30, 5, 1, 'Lakeside Marblehead', '', 'lakeside-marblehead', '', ''),
(3313, 10, 1, 1, 'Lakeside', '', 'lakeside', '', ''),
(3314, 9, 4, 1, 'Olton', '', 'olton', '', ''),
(3315, 56, 2, 1, 'Challis', '', 'challis', '', ''),
(3316, 55, 3, 1, 'Dighton', '', 'dighton', '', ''),
(3317, 17, 3, 1, 'Lanesboro', '', 'lanesboro', '', ''),
(3318, 55, 3, 1, 'Edgerton', '', 'edgerton', '', ''),
(3319, 36, 5, 1, 'Manitowoc', '', 'manitowoc', '', ''),
(3320, 44, 4, 1, 'Jena', '', 'jena', '', ''),
(3321, 26, 1, 1, 'Tillamook', '', 'tillamook', '', ''),
(3322, 9, 4, 1, 'Del Rio', '', 'del-rio', '', ''),
(3323, 25, 10, 1, 'Laupahoehoe', '', 'laupahoehoe', '', ''),
(3324, 49, 3, 1, 'De Smet', '', 'de-smet', '', ''),
(3325, 17, 3, 1, 'Walnut Grove', '', 'walnut-grove', '', ''),
(3326, 9, 4, 1, 'Hallettsville', '', 'hallettsville', '', ''),
(3327, 48, 6, 1, 'Moulton', '', 'moulton', '', ''),
(3328, 30, 5, 1, 'Ironton', '', 'ironton', '', ''),
(3329, 45, 2, 1, 'Hobbs', '', 'hobbs', '', ''),
(3330, 8, 7, 1, 'Maryland', '', 'maryland', '', ''),
(3331, 12, 1, 1, 'Leavenworth', '', 'leavenworth', '', ''),
(3332, 23, 9, 1, 'Blue Hill', '', 'blue-hill', '', ''),
(3333, 31, 7, 1, 'Leechburg', '', 'leechburg', '', ''),
(3334, 8, 7, 1, 'Manhasset', '', 'manhasset', '', ''),
(3335, 45, 2, 1, 'Algodones', '', 'algodones', '', ''),
(3336, 57, 3, 1, 'Lehigh', '', 'lehigh', '', ''),
(3337, 36, 5, 1, 'Wausau', '', 'wausau', '', ''),
(3338, 42, 5, 1, 'Lemont', '', 'lemont', '', ''),
(3339, 35, 5, 1, 'Adrian', '', 'adrian', '', ''),
(3340, 50, 3, 1, 'Lenoir City', '', 'lenoir-city', '', ''),
(3341, 32, 4, 1, 'Enid', '', 'enid', '', ''),
(3342, 10, 1, 1, 'Calabasas', '', 'calabasas', '', ''),
(3343, 52, 4, 1, 'Lepanto', '', 'lepanto', '', ''),
(3344, 35, 5, 1, 'Leroy', '', 'leroy', '', ''),
(3345, 35, 5, 1, 'Cedarville', '', 'cedarville', '', ''),
(3346, 17, 3, 1, 'Elysian', '', 'elysian', '', ''),
(3347, 17, 3, 1, 'Le Sueur', '', 'le-sueur', '', ''),
(3348, 39, 5, 1, 'Fountain City', '', 'fountain-city', '', ''),
(3349, 20, 8, 1, 'Chiefland', '', 'chiefland', '', ''),
(3350, 59, 3, 1, 'Alexander', '', 'alexander', '', ''),
(3351, 12, 1, 1, 'Chehalis', '', 'chehalis', '', ''),
(3352, 50, 3, 1, 'Hohenwald', '', 'hohenwald', '', ''),
(3353, 39, 5, 1, 'Vevay', '', 'vevay', '', ''),
(3354, 39, 5, 1, 'Ligonier', '', 'ligonier', '', ''),
(3355, 25, 10, 1, 'Hanalei', '', 'hanalei', '', ''),
(3356, 9, 4, 1, 'Groesbeck', '', 'groesbeck', '', ''),
(3357, 23, 9, 1, 'Wiscasset', '', 'wiscasset', '', ''),
(3358, 58, 3, 1, 'North Platte', '', 'north-platte', '', ''),
(3359, 42, 5, 1, 'Beardstown', '', 'beardstown', '', ''),
(3360, 37, 6, 1, 'Hodgenville', '', 'hodgenville', '', ''),
(3361, 23, 9, 1, 'Lincolnville', '', 'lincolnville', '', ''),
(3362, 45, 2, 1, 'Lordsburg', '', 'lordsburg', '', ''),
(3363, 7, 7, 1, 'Linwood', '', 'linwood', '', ''),
(3364, 26, 1, 1, 'Yachats', '', 'yachats', '', ''),
(3365, 8, 7, 1, 'Clymer', '', 'clymer', '', ''),
(3366, 60, 2, 1, 'Savery', '', 'savery', '', ''),
(3367, 35, 5, 1, 'Petoskey', '', 'petoskey', '', ''),
(3368, 10, 1, 1, 'Yountville', '', 'yountville', '', ''),
(3369, 38, 9, 1, 'Marlboro', '', 'marlboro', '', ''),
(3370, 38, 9, 1, 'Whitingham', '', 'whitingham', '', ''),
(3371, 12, 1, 1, 'Anacortes', '', 'anacortes', '', ''),
(3372, 23, 9, 1, 'Bailey Island', '', 'bailey-island', '', ''),
(3373, 60, 2, 1, 'Rock Springs', '', 'rock-springs', '', ''),
(3374, 41, 9, 1, 'Terryville', '', 'terryville', '', ''),
(3375, 45, 2, 1, 'Pinos Altos', '', 'pinos-altos', '', ''),
(3376, 12, 1, 1, 'Port Orchard', '', 'port-orchard', '', ''),
(3377, 52, 4, 1, 'Fairfield Bay', '', 'fairfield-bay', '', ''),
(3378, 30, 5, 1, 'Bellefontaine', '', 'bellefontaine', '', ''),
(3379, 42, 5, 1, 'Murphysboro', '', 'murphysboro', '', ''),
(3380, 36, 5, 1, 'Rhinelander', '', 'rhinelander', '', ''),
(3381, 30, 5, 1, 'Canfield', '', 'canfield', '', ''),
(3382, 53, 2, 1, 'Loma', '', 'loma', '', ''),
(3383, 10, 1, 1, 'Lomita', '', 'lomita', '', ''),
(3384, 47, 3, 1, 'Lone Jack', '', 'lone-jack', '', ''),
(3385, 10, 1, 1, 'Lone Pine', '', 'lone-pine', '', ''),
(3386, 7, 7, 1, 'Beach Haven', '', 'beach-haven', '', ''),
(3387, 8, 7, 1, 'West Sayville', '', 'west-sayville', '', ''),
(3388, 13, 9, 1, 'Acushnet', '', 'acushnet', '', ''),
(3389, 20, 8, 1, 'Longboat Key', '', 'longboat-key', '', ''),
(3390, 13, 9, 1, 'Longmeadow', '', 'longmeadow', '', ''),
(3391, 13, 9, 1, 'Chestnut Hill', '', 'chestnut-hill', '', ''),
(3392, 12, 1, 1, 'Lopez Island', '', 'lopez-island', '', ''),
(3393, 33, 8, 1, 'Lost City', '', 'lost-city', '', ''),
(3394, 47, 3, 1, 'Louisiana', '', 'louisiana', '', ''),
(3395, 44, 4, 1, 'Lafitte', '', 'lafitte', '', ''),
(3396, 44, 4, 1, 'Port Allen', '', 'port-allen', '', ''),
(3397, 44, 4, 1, 'Oil City', '', 'oil-city', '', ''),
(3398, 42, 5, 1, 'Dixon', '', 'dixon', '', ''),
(3399, 23, 9, 1, 'Lovell', '', 'lovell', '', ''),
(3400, 27, 8, 1, 'Port Royal', '', 'port-royal', '', ''),
(3401, 43, 2, 1, 'Victor', '', 'victor', '', ''),
(3402, 31, 7, 1, 'Shamokin', '', 'shamokin', '', ''),
(3403, 8, 7, 1, 'Elmsford', '', 'elmsford', '', ''),
(3404, 9, 4, 1, 'Lufkin', '', 'lufkin', '', ''),
(3405, 52, 4, 1, 'Oden', '', 'oden', '', ''),
(3406, 23, 9, 1, 'Patten', '', 'patten', '', ''),
(3407, 27, 8, 1, 'Seneca', '', 'seneca', '', ''),
(3408, 21, 8, 1, 'Luray', '', 'luray', '', ''),
(3409, 10, 1, 1, 'Sebastopol', '', 'sebastopol', '', ''),
(3410, 10, 1, 1, 'Rancho Santa Fe', '', 'rancho-santa-fe', '', ''),
(3411, 49, 3, 1, 'Presho', '', 'presho', '', ''),
(3412, 8, 7, 1, 'Rotterdam Junction', '', 'rotterdam-junction', '', ''),
(3413, 17, 3, 1, 'Mabel', '', 'mabel', '', ''),
(3414, 30, 5, 1, 'West Liberty', '', 'west-liberty', '', ''),
(3415, 21, 8, 1, 'Chase City', '', 'chase-city', '', ''),
(3416, 8, 7, 1, 'Macedon', '', 'macedon', '', ''),
(3417, 57, 3, 1, 'Mason City', '', 'mason-city', '', ''),
(3418, 42, 5, 1, 'Carlinville', '', 'carlinville', '', ''),
(3419, 36, 5, 1, 'La Pointe', '', 'la-pointe', '', ''),
(3420, 8, 7, 1, 'Oneida', '', 'oneida', '', ''),
(3421, 45, 2, 1, 'Cerrillos', '', 'cerrillos', '', ''),
(3422, 57, 3, 1, 'Oskaloosa', '', 'oskaloosa', '', ''),
(3423, 8, 7, 1, 'Baldwin Place', '', 'baldwin-place', '', ''),
(3424, 22, 8, 1, 'Forest City', '', 'forest-city', '', ''),
(3425, 16, 8, 1, 'Delaware City', '', 'delaware-city', '', ''),
(3426, 20, 8, 1, 'Maitland', '', 'maitland', '', ''),
(3427, 12, 1, 1, 'Neah Bay', '', 'neah-bay', '', ''),
(3428, 10, 1, 1, 'Mammoth Lakes', '', 'mammoth-lakes', '', ''),
(3429, 35, 5, 1, 'Manistee', '', 'manistee', '', ''),
(3430, 48, 6, 1, 'Opelika', '', 'opelika', '', ''),
(3431, 8, 7, 1, 'Manorville', '', 'manorville', '', ''),
(3432, 35, 5, 1, 'Manton', '', 'manton', '', ''),
(3433, 12, 1, 1, 'Maple Valley', '', 'maple-valley', '', ''),
(3434, 47, 3, 1, 'Saint James', '', 'saint-james', '', ''),
(3435, 10, 1, 1, 'June Lake', '', 'june-lake', '', ''),
(3436, 7, 7, 1, 'Holmdel', '', 'holmdel', '', ''),
(3437, 7, 7, 1, 'Pluckemin', '', 'pluckemin', '', ''),
(3438, 31, 7, 1, 'Jamison', '', 'jamison', '', ''),
(3439, 9, 4, 1, 'Fredericksbrg', '', 'fredericksbrg', '', ''),
(3440, 23, 9, 1, 'Waldoboro', '', 'waldoboro', '', ''),
(3441, 20, 8, 1, 'Indian Rocks Beach', '', 'indian-rocks-beach', '', ''),
(3442, 45, 2, 1, 'Gallup', '', 'gallup', '', ''),
(3443, 31, 7, 1, 'Tamaqua', '', 'tamaqua', '', ''),
(3444, 12, 1, 1, 'Soap Lake', '', 'soap-lake', '', ''),
(3445, 31, 7, 1, 'Gibsonia', '', 'gibsonia', '', ''),
(3446, 44, 4, 1, 'Belle Chasse', '', 'belle-chasse', '', ''),
(3447, 36, 5, 1, 'Bayfield', '', 'bayfield', '', ''),
(3448, 10, 1, 1, 'Rocklin', '', 'rocklin', '', ''),
(3449, 20, 8, 1, 'Lauderhill', '', 'lauderhill', '', ''),
(3450, 42, 5, 1, 'Calumet Park', '', 'calumet-park', '', ''),
(3451, 13, 9, 1, 'Shrewsbury', '', 'shrewsbury', '', ''),
(3452, 31, 7, 1, 'Hellertown', '', 'hellertown', '', ''),
(3453, 9, 4, 1, 'Willis', '', 'willis', '', ''),
(3454, 20, 8, 1, 'Kissimmee', '', 'kissimmee', '', ''),
(3455, 7, 7, 1, 'Lyndhurst', '', 'lyndhurst', '', ''),
(3456, 30, 5, 1, 'Nelsonville', '', 'nelsonville', '', ''),
(3457, 35, 5, 1, 'Oscoda', '', 'oscoda', '', ''),
(3458, 42, 5, 1, 'Noble', '', 'noble', '', ''),
(3459, 42, 5, 1, 'Carterville', '', 'carterville', '', ''),
(3460, 7, 7, 1, 'Elmwood Park', '', 'elmwood-park', '', ''),
(3461, 14, 8, 1, 'Conyers', '', 'conyers', '', ''),
(3462, 20, 8, 1, 'North Miami', '', 'north-miami', '', ''),
(3463, 14, 8, 1, 'East Point', '', 'east-point', '', ''),
(3464, 8, 7, 1, 'Port Jefferson Stati', '', 'port-jefferson-stati', '', ''),
(3465, 8, 7, 1, 'Candor', '', 'candor', '', ''),
(3466, 9, 4, 1, 'League City', '', 'league-city', '', ''),
(3467, 7, 7, 1, 'Buena', '', 'buena', '', ''),
(3468, 31, 7, 1, 'Newtown Square', '', 'newtown-square', '', ''),
(3469, 8, 7, 1, 'Liverpool', '', 'liverpool', '', ''),
(3470, 13, 9, 1, 'Groton', '', 'groton', '', ''),
(3471, 7, 7, 1, 'Little Ferry', '', 'little-ferry', '', ''),
(3472, 14, 8, 1, 'Norcross', '', 'norcross', '', ''),
(3473, 10, 1, 1, 'Wrightwood', '', 'wrightwood', '', ''),
(3474, 30, 5, 1, 'Westlake', '', 'westlake', '', ''),
(3475, 17, 3, 1, 'Golden Valley', '', 'golden-valley', '', ''),
(3476, 12, 1, 1, 'Interbay', '', 'interbay', '', ''),
(3477, 13, 9, 1, 'Nahant', '', 'nahant', '', ''),
(3478, 33, 8, 1, 'Hundred', '', 'hundred', '', ''),
(3479, 45, 2, 1, 'Truth or Consequences', '', 'truth-or-consequences', '', ''),
(3480, 20, 8, 1, 'Lutz', '', 'lutz', '', ''),
(3481, 25, 10, 1, 'Kilauea', '', 'kilauea', '', ''),
(3482, 9, 4, 1, 'Rowlett', '', 'rowlett', '', ''),
(3483, 10, 1, 1, 'Redwood City', '', 'redwood-city', '', ''),
(3484, 20, 8, 1, 'N Fort Myers', '', 'n-fort-myers', '', ''),
(3485, 17, 3, 1, 'Burnsville', '', 'burnsville', '', ''),
(3486, 10, 1, 1, 'Ojai', '', 'ojai', '', ''),
(3487, 10, 1, 1, 'Toluca Lake', '', 'toluca-lake', '', ''),
(3488, 17, 3, 1, 'St Louis Park', '', 'st-louis-park', '', ''),
(3489, 31, 7, 1, 'Temple', '', 'temple', '', ''),
(3490, 35, 5, 1, 'Wyandotte', '', 'wyandotte', '', ''),
(3491, 14, 8, 1, 'Lavonia', '', 'lavonia', '', ''),
(3492, 10, 1, 1, 'Inglewood', '', 'inglewood', '', ''),
(3493, 42, 5, 1, 'Carol Stream', '', 'carol-stream', '', ''),
(3494, 27, 8, 1, 'North Charleston', '', 'north-charleston', '', ''),
(3495, 7, 7, 1, 'Matawan', '', 'matawan', '', ''),
(3496, 7, 7, 1, 'Carlstadt', '', 'carlstadt', '', ''),
(3497, 10, 1, 1, 'Murrieta', '', 'murrieta', '', ''),
(3498, 33, 8, 1, 'Scott Depot', '', 'scott-depot', '', ''),
(3499, 10, 1, 1, 'Carmichael', '', 'carmichael', '', ''),
(3500, 36, 5, 1, 'Pewaukee', '', 'pewaukee', '', ''),
(3501, 48, 6, 1, 'Bay Minette', '', 'bay-minette', '', ''),
(3502, 55, 3, 1, 'Fort Scott', '', 'fort-scott', '', ''),
(3503, 38, 9, 1, 'Stowe', '', 'stowe', '', ''),
(3504, 9, 4, 1, 'Desoto', '', 'desoto', '', ''),
(3505, 27, 8, 1, 'North Augusta', '', 'north-augusta', '', ''),
(3506, 21, 8, 1, 'Christiansburg', '', 'christiansburg', '', ''),
(3507, 20, 8, 1, 'Key Biscayne', '', 'key-biscayne', '', ''),
(3508, 27, 8, 1, 'Surfside Beach', '', 'surfside-beach', '', ''),
(3509, 14, 8, 1, 'Ringgold', '', 'ringgold', '', ''),
(3510, 57, 3, 1, 'Iowa City', '', 'iowa-city', '', ''),
(3511, 9, 4, 1, 'Universal City', '', 'universal-city', '', ''),
(3512, 9, 4, 1, 'Argyle', '', 'argyle', '', ''),
(3513, 8, 7, 1, 'Farmingville', '', 'farmingville', '', ''),
(3514, 12, 1, 1, 'Rainier', '', 'rainier', '', ''),
(3515, 10, 1, 1, 'Tehachapi', '', 'tehachapi', '', ''),
(3516, 27, 8, 1, 'Cheraw', '', 'cheraw', '', ''),
(3517, 39, 5, 1, 'Lake Station', '', 'lake-station', '', ''),
(3518, 12, 1, 1, 'East Wenatchee', '', 'east-wenatchee', '', ''),
(3519, 41, 9, 1, 'New Britain', '', 'new-britain', '', ''),
(3520, 35, 5, 1, 'Hamtramck', '', 'hamtramck', '', ''),
(3521, 21, 8, 1, 'Jarratt', '', 'jarratt', '', ''),
(3522, 30, 5, 1, 'Maple Heights', '', 'maple-heights', '', ''),
(3523, 22, 8, 1, 'Goldsboro', '', 'goldsboro', '', ''),
(3524, 8, 7, 1, 'Jackson Heights', '', 'jackson-heights', '', ''),
(3525, 52, 4, 1, 'Hot Springs National Park', '', 'hot-springs-national-park', '', ''),
(3526, 7, 7, 1, 'West New York', '', 'west-new-york', '', ''),
(3527, 59, 3, 1, 'New Rockford', '', 'new-rockford', '', ''),
(3528, 31, 7, 1, 'Phila', '', 'phila', '', ''),
(3529, 10, 1, 1, 'West Sacramento', '', 'west-sacramento', '', ''),
(3530, 26, 1, 1, 'Tualatin', '', 'tualatin', '', ''),
(3531, 9, 4, 1, 'Euless', '', 'euless', '', ''),
(3532, 48, 6, 1, 'Silas', '', 'silas', '', ''),
(3533, 10, 1, 1, 'Ramona', '', 'ramona', '', ''),
(3534, 23, 9, 1, 'Presque Isle', '', 'presque-isle', '', ''),
(3535, 8, 7, 1, 'Rosedale', '', 'rosedale', '', ''),
(3536, 61, 6, 1, 'Amory', '', 'amory', '', ''),
(3537, 20, 8, 1, 'Margate', '', 'margate', '', ''),
(3538, 9, 4, 1, 'Kennedale', '', 'kennedale', '', ''),
(3539, 31, 7, 1, 'West Point', '', 'west-point', '', ''),
(3540, 31, 7, 1, 'Harleysville', '', 'harleysville', '', ''),
(3541, 22, 8, 1, 'Apex', '', 'apex', '', ''),
(3542, 47, 3, 1, 'Grandview', '', 'grandview', '', ''),
(3543, 23, 9, 1, 'Mount Desert', '', 'mount-desert', '', ''),
(3544, 35, 5, 1, 'Three Oaks', '', 'three-oaks', '', ''),
(3545, 48, 6, 1, 'Trussville', '', 'trussville', '', ''),
(3546, 26, 1, 1, 'Veneta', '', 'veneta', '', ''),
(3547, 10, 1, 1, 'Agoura', '', 'agoura', '', ''),
(3548, 14, 8, 1, 'Buford', '', 'buford', '', ''),
(3549, 8, 7, 1, 'Olivebridge', '', 'olivebridge', '', ''),
(3550, 26, 1, 1, 'Eugene', '', 'eugene', '', ''),
(3551, 15, 8, 1, 'Linthicum Heights', '', 'linthicum-heights', '', ''),
(3552, 30, 5, 1, 'Fairborn', '', 'fairborn', '', ''),
(3553, 26, 1, 1, 'Talent', '', 'talent', '', ''),
(3554, 35, 5, 1, 'Royal Oak', '', 'royal-oak', '', ''),
(3555, 31, 7, 1, 'Morrisville', '', 'morrisville', '', ''),
(3556, 8, 7, 1, 'Tupper Lake', '', 'tupper-lake', '', ''),
(3557, 15, 8, 1, 'Glen Echo', '', 'glen-echo', '', ''),
(3558, 8, 7, 1, 'Bohemia', '', 'bohemia', '', ''),
(3559, 22, 8, 1, 'Albemarle', '', 'albemarle', '', ''),
(3560, 47, 3, 1, 'Sikeston', '', 'sikeston', '', ''),
(3561, 42, 5, 1, 'Wood Dale', '', 'wood-dale', '', ''),
(3562, 13, 9, 1, 'Hyde Park', '', 'hyde-park', '', ''),
(3563, 28, 9, 1, 'Pawtucket', '', 'pawtucket', '', ''),
(3564, 31, 7, 1, 'Croydon', '', 'croydon', '', ''),
(3565, 41, 9, 1, 'Branford', '', 'branford', '', ''),
(3566, 35, 5, 1, 'Clinton Township', '', 'clinton-township', '', ''),
(3567, 25, 10, 1, 'Keauhou', '', 'keauhou', '', ''),
(3568, 42, 5, 1, 'Lombard', '', 'lombard', '', ''),
(3569, 14, 8, 1, 'Alpharetta', '', 'alpharetta', '', ''),
(3570, 8, 7, 1, 'Round Top', '', 'round-top', '', ''),
(3571, 7, 7, 1, 'Mount Ephraim', '', 'mount-ephraim', '', ''),
(3572, 56, 2, 1, 'American Falls', '', 'american-falls', '', ''),
(3573, 47, 3, 1, 'Wentzville', '', 'wentzville', '', ''),
(3574, 36, 5, 1, 'Amery', '', 'amery', '', ''),
(3575, 35, 5, 1, 'Quinnesec', '', 'quinnesec', '', ''),
(3576, 22, 8, 1, 'Andrews', '', 'andrews', '', ''),
(3577, 35, 5, 1, 'Sterling Heights', '', 'sterling-heights', '', ''),
(3578, 8, 7, 1, 'New Windsor', '', 'new-windsor', '', ''),
(3579, 55, 3, 1, 'Tonganoxie', '', 'tonganoxie', '', ''),
(3580, 21, 8, 1, 'Wise', '', 'wise', '', ''),
(3581, 7, 7, 1, 'Elmer', '', 'elmer', '', ''),
(3582, 31, 7, 1, 'Delmont', '', 'delmont', '', ''),
(3583, 31, 7, 1, 'Windber', '', 'windber', '', ''),
(3584, 24, 2, 1, 'Orem', '', 'orem', '', ''),
(3585, 30, 5, 1, 'Gallipolis', '', 'gallipolis', '', ''),
(3586, 11, 2, 1, 'Sun City West', '', 'sun-city-west', '', ''),
(3587, 30, 5, 1, 'North Olmsted', '', 'north-olmsted', '', ''),
(3588, 47, 3, 1, 'Arrow Rock', '', 'arrow-rock', '', ''),
(3589, 11, 2, 1, 'Show Low', '', 'show-low', '', ''),
(3590, 14, 8, 1, 'Dalton', '', 'dalton', '', ''),
(3591, 20, 8, 1, 'Niceville', '', 'niceville', '', ''),
(3592, 7, 7, 1, 'Maplewood', '', 'maplewood', '', ''),
(3593, 8, 7, 1, 'Sayville', '', 'sayville', '', ''),
(3594, 23, 9, 1, 'Arundel', '', 'arundel', '', ''),
(3595, 8, 7, 1, 'Tuckahoe', '', 'tuckahoe', '', ''),
(3596, 31, 7, 1, 'Phoenixville', '', 'phoenixville', '', ''),
(3597, 13, 9, 1, 'Great Barrington', '', 'great-barrington', '', ''),
(3598, 42, 5, 1, 'Highwood', '', 'highwood', '', ''),
(3599, 12, 1, 1, 'Pullman', '', 'pullman', '', ''),
(3600, 9, 4, 1, 'Pflugerville', '', 'pflugerville', '', ''),
(3601, 30, 5, 1, 'Mentor On The', '', 'mentor-on-the', '', ''),
(3602, 17, 3, 1, 'Frazee', '', 'frazee', '', ''),
(3603, 7, 7, 1, 'West Berlin', '', 'west-berlin', '', ''),
(3604, 31, 7, 1, 'Hawley', '', 'hawley', '', ''),
(3605, 15, 8, 1, 'Street', '', 'street', '', ''),
(3606, 37, 6, 1, 'Edmonton', '', 'edmonton', '', ''),
(3607, 35, 5, 1, 'Port Sanilac', '', 'port-sanilac', '', ''),
(3608, 13, 9, 1, 'Barnstable', '', 'barnstable', '', ''),
(3609, 31, 7, 1, 'Ridley Park', '', 'ridley-park', '', ''),
(3610, 19, 9, 1, 'Tamworth', '', 'tamworth', '', ''),
(3611, 38, 9, 1, 'Barre', '', 'barre', '', ''),
(3612, 13, 9, 1, 'Sheffield', '', 'sheffield', '', ''),
(3613, 36, 5, 1, 'Barron', '', 'barron', '', ''),
(3614, 16, 8, 1, 'Dagsboro', '', 'dagsboro', '', ''),
(3615, 27, 8, 1, 'Sumter', '', 'sumter', '', ''),
(3616, 8, 7, 1, 'Bearsville', '', 'bearsville', '', ''),
(3617, 58, 3, 1, 'Beatrice', '', 'beatrice', '', ''),
(3618, 22, 8, 1, 'Hendersonville', '', 'hendersonville', '', ''),
(3619, 47, 3, 1, 'Parkville', '', 'parkville', '', ''),
(3620, 9, 4, 1, 'Crystal City', '', 'crystal-city', '', ''),
(3621, 7, 7, 1, 'Berkeley Heights', '', 'berkeley-heights', '', ''),
(3622, 38, 9, 1, 'Pownal', '', 'pownal', '', ''),
(3623, 20, 8, 1, 'Gulf Breeze', '', 'gulf-breeze', '', ''),
(3624, 10, 1, 1, 'Merced', '', 'merced', '', ''),
(3625, 10, 1, 1, 'Murphys', '', 'murphys', '', ''),
(3626, 49, 3, 1, 'Hermosa', '', 'hermosa', '', ''),
(3627, 31, 7, 1, 'Kutztown', '', 'kutztown', '', ''),
(3628, 22, 8, 1, 'Blowing Rock', '', 'blowing-rock', '', ''),
(3629, 14, 8, 1, 'Blue Ridge', '', 'blue-ridge', '', ''),
(3630, 33, 8, 1, 'Bluefield', '', 'bluefield', '', ''),
(3631, 8, 7, 1, 'Massapequa', '', 'massapequa', '', ''),
(3632, 7, 7, 1, 'Boonton', '', 'boonton', '', ''),
(3633, 23, 9, 1, 'Ogunquit', '', 'ogunquit', '', ''),
(3634, 13, 9, 1, 'Provincetown', '', 'provincetown', '', ''),
(3635, 16, 8, 1, 'Claymont', '', 'claymont', '', ''),
(3636, 14, 8, 1, 'Acworth', '', 'acworth', '', ''),
(3637, 20, 8, 1, 'Indian Harbour Beach', '', 'indian-harbour-beach', '', ''),
(3638, 22, 8, 1, 'Brevard', '', 'brevard', '', ''),
(3639, 8, 7, 1, 'Lindenhurst', '', 'lindenhurst', '', ''),
(3640, 30, 5, 1, 'Broadview Heights', '', 'broadview-heights', '', ''),
(3641, 7, 7, 1, 'North Plainfield', '', 'north-plainfield', '', ''),
(3642, 35, 5, 1, 'Eastpointe', '', 'eastpointe', '', ''),
(3643, 31, 7, 1, 'Grindstone', '', 'grindstone', '', ''),
(3644, 36, 5, 1, 'Bruce', '', 'bruce', '', ''),
(3645, 31, 7, 1, 'Bryn Athyn', '', 'bryn-athyn', '', ''),
(3646, 35, 5, 1, 'Buchanan', '', 'buchanan', '', ''),
(3647, 12, 1, 1, 'Burien', '', 'burien', '', ''),
(3648, 7, 7, 1, 'Pemberton', '', 'pemberton', '', ''),
(3649, 43, 2, 1, 'Grand Junction', '', 'grand-junction', '', ''),
(3650, 36, 5, 1, 'Franksville', '', 'franksville', '', ''),
(3651, 8, 7, 1, 'Dobbs Ferry', '', 'dobbs-ferry', '', ''),
(3652, 10, 1, 1, 'Huntington Park', '', 'huntington-park', '', ''),
(3653, 10, 1, 1, 'Moraga', '', 'moraga', '', ''),
(3654, 13, 9, 1, 'Boylston', '', 'boylston', '', ''),
(3655, 13, 9, 1, 'South Weymouth', '', 'south-weymouth', '', ''),
(3656, 12, 1, 1, 'Stanwood', '', 'stanwood', '', ''),
(3657, 11, 2, 1, 'Sedona', '', 'sedona', '', ''),
(3658, 8, 7, 1, 'Old Bethpage', '', 'old-bethpage', '', ''),
(3659, 10, 1, 1, 'Fair Oaks', '', 'fair-oaks', '', ''),
(3660, 9, 4, 1, 'Edinburg', '', 'edinburg', '', ''),
(3661, 37, 6, 1, 'Harlan', '', 'harlan', '', ''),
(3662, 22, 8, 1, 'Southern Pines', '', 'southern-pines', '', ''),
(3663, 20, 8, 1, 'Titusville', '', 'titusville', '', ''),
(3664, 31, 7, 1, 'Tannersville', '', 'tannersville', '', ''),
(3665, 31, 7, 1, 'Vandergrift', '', 'vandergrift', '', ''),
(3666, 35, 5, 1, 'Cass City', '', 'cass-city', '', ''),
(3667, 38, 9, 1, 'Castleton', '', 'castleton', '', ''),
(3668, 39, 5, 1, 'Seymour', '', 'seymour', '', ''),
(3669, 7, 7, 1, 'Roselle Park', '', 'roselle-park', '', ''),
(3670, 36, 5, 1, 'Mosinee', '', 'mosinee', '', ''),
(3671, 23, 9, 1, 'South Paris', '', 'south-paris', '', ''),
(3672, 31, 7, 1, 'Lansdowne', '', 'lansdowne', '', ''),
(3673, 17, 3, 1, 'Fergus Falls', '', 'fergus-falls', '', ''),
(3674, 9, 4, 1, 'Deer Park', '', 'deer-park', '', ''),
(3675, 7, 7, 1, 'Wyckoff', '', 'wyckoff', '', ''),
(3676, 31, 7, 1, 'Shippensburg', '', 'shippensburg', '', ''),
(3677, 57, 3, 1, 'Grundy Center', '', 'grundy-center', '', ''),
(3678, 8, 7, 1, 'Centereach', '', 'centereach', '', ''),
(3679, 20, 8, 1, 'Oviedo', '', 'oviedo', '', ''),
(3680, 12, 1, 1, 'Enumclaw', '', 'enumclaw', '', ''),
(3681, 17, 3, 1, 'Chanhassen', '', 'chanhassen', '', ''),
(3682, 53, 2, 1, 'Stevensville', '', 'stevensville', '', ''),
(3683, 55, 3, 1, 'Chanute', '', 'chanute', '', ''),
(3684, 31, 7, 1, 'Cheswick', '', 'cheswick', '', ''),
(3685, 30, 5, 1, 'Munroe Falls', '', 'munroe-falls', '', ''),
(3686, 20, 8, 1, 'Ormond Beach', '', 'ormond-beach', '', ''),
(3687, 7, 7, 1, 'Lincroft', '', 'lincroft', '', ''),
(3688, 22, 8, 1, 'Angier', '', 'angier', '', ''),
(3689, 42, 5, 1, 'Savoy', '', 'savoy', '', ''),
(3690, 15, 8, 1, 'Church Hill', '', 'church-hill', '', ''),
(3691, 7, 7, 1, 'Kenilworth', '', 'kenilworth', '', ''),
(3692, 31, 7, 1, 'Honesdale', '', 'honesdale', '', ''),
(3693, 42, 5, 1, 'Macomb', '', 'macomb', '', ''),
(3694, 48, 6, 1, 'Headland', '', 'headland', '', ''),
(3695, 30, 5, 1, 'Piqua', '', 'piqua', '', ''),
(3696, 10, 1, 1, 'Yuba City', '', 'yuba-city', '', ''),
(3697, 42, 5, 1, 'Forest Park', '', 'forest-park', '', ''),
(3698, 10, 1, 1, 'La Mirada', '', 'la-mirada', '', ''),
(3699, 44, 4, 1, 'Tioga', '', 'tioga', '', ''),
(3700, 8, 7, 1, 'Patchogue', '', 'patchogue', '', ''),
(3701, 10, 1, 1, 'Sunland', '', 'sunland', '', ''),
(3702, 52, 4, 1, 'Heber Springs', '', 'heber-springs', '', ''),
(3703, 30, 5, 1, 'Wickliffe', '', 'wickliffe', '', ''),
(3704, 59, 3, 1, 'Clifford', '', 'clifford', '', ''),
(3705, 17, 3, 1, 'Inver Grove', '', 'inver-grove', '', ''),
(3706, 42, 5, 1, 'Breese', '', 'breese', '', ''),
(3707, 35, 5, 1, 'Clio', '', 'clio', '', ''),
(3708, 10, 1, 1, 'Coarsegold', '', 'coarsegold', '', ''),
(3709, 10, 1, 1, 'San Anselmo', '', 'san-anselmo', '', ''),
(3710, 52, 4, 1, 'Paragould', '', 'paragould', '', ''),
(3711, 31, 7, 1, 'Clifton Heights', '', 'clifton-heights', '', ''),
(3712, 28, 9, 1, 'Westerly', '', 'westerly', '', ''),
(3713, 8, 7, 1, 'Ghent', '', 'ghent', '', ''),
(3714, 17, 3, 1, 'Cook', '', 'cook', '', ''),
(3715, 8, 7, 1, 'Commack', '', 'commack', '', ''),
(3716, 15, 8, 1, 'Frostburg', '', 'frostburg', '', ''),
(3717, 42, 5, 1, 'Bradley', '', 'bradley', '', ''),
(3718, 37, 6, 1, 'Murray', '', 'murray', '', ''),
(3719, 41, 9, 1, 'Cromwell', '', 'cromwell', '', ''),
(3720, 27, 8, 1, 'Lyman', '', 'lyman', '', ''),
(3721, 42, 5, 1, 'Goodfield', '', 'goodfield', '', ''),
(3722, 41, 9, 1, 'Prospect', '', 'prospect', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(3723, 32, 4, 1, 'Pawhuska', '', 'pawhuska', '', ''),
(3724, 39, 5, 1, 'Corydon', '', 'corydon', '', ''),
(3725, 36, 5, 1, 'Merrill', '', 'merrill', '', ''),
(3726, 26, 1, 1, 'Cottage Grove', '', 'cottage-grove', '', ''),
(3727, 32, 4, 1, 'Pryor', '', 'pryor', '', ''),
(3728, 42, 5, 1, 'Cissna Park', '', 'cissna-park', '', ''),
(3729, 57, 3, 1, 'Eldridge', '', 'eldridge', '', ''),
(3730, 17, 3, 1, 'Carlton', '', 'carlton', '', ''),
(3731, 21, 8, 1, 'Mathews', '', 'mathews', '', ''),
(3732, 8, 7, 1, 'Glen Oaks', '', 'glen-oaks', '', ''),
(3733, 9, 4, 1, 'Schulenburg', '', 'schulenburg', '', ''),
(3734, 31, 7, 1, 'Cranberry Twp', '', 'cranberry-twp', '', ''),
(3735, 20, 8, 1, 'North Miami Beach', '', 'north-miami-beach', '', ''),
(3736, 43, 2, 1, 'Creede', '', 'creede', '', ''),
(3737, 17, 3, 1, 'Maple Grove', '', 'maple-grove', '', ''),
(3738, 9, 4, 1, 'Stephenville', '', 'stephenville', '', ''),
(3739, 49, 3, 1, 'Flandreau', '', 'flandreau', '', ''),
(3740, 21, 8, 1, 'Culpeper', '', 'culpeper', '', ''),
(3741, 30, 5, 1, 'Sunbury', '', 'sunbury', '', ''),
(3742, 12, 1, 1, 'Metaline Falls', '', 'metaline-falls', '', ''),
(3743, 59, 3, 1, 'Wishek', '', 'wishek', '', ''),
(3744, 10, 1, 1, 'Calimesa', '', 'calimesa', '', ''),
(3745, 10, 1, 1, 'Lakehead', '', 'lakehead', '', ''),
(3746, 21, 8, 1, 'Powhatan', '', 'powhatan', '', ''),
(3747, 10, 1, 1, 'Sugarloaf', '', 'sugarloaf', '', ''),
(3748, 20, 8, 1, 'Palm Bay', '', 'palm-bay', '', ''),
(3749, 14, 8, 1, 'Griffin', '', 'griffin', '', ''),
(3750, 14, 8, 1, 'Thomasville', '', 'thomasville', '', ''),
(3751, 10, 1, 1, 'San Bruno', '', 'san-bruno', '', ''),
(3752, 20, 8, 1, 'Coconut Creek', '', 'coconut-creek', '', ''),
(3753, 27, 8, 1, 'Fountain Inn', '', 'fountain-inn', '', ''),
(3754, 22, 8, 1, 'New Bern', '', 'new-bern', '', ''),
(3755, 7, 7, 1, 'Sea Girt', '', 'sea-girt', '', ''),
(3756, 37, 6, 1, 'La Grange', '', 'la-grange', '', ''),
(3757, 31, 7, 1, 'Boothwyn', '', 'boothwyn', '', ''),
(3758, 9, 4, 1, 'Missouri City', '', 'missouri-city', '', ''),
(3759, 22, 8, 1, 'Davidson', '', 'davidson', '', ''),
(3760, 8, 7, 1, 'Bayport', '', 'bayport', '', ''),
(3761, 11, 2, 1, 'Carefree', '', 'carefree', '', ''),
(3762, 10, 1, 1, 'Vista', '', 'vista', '', ''),
(3763, 10, 1, 1, 'Pleasant Hill', '', 'pleasant-hill', '', ''),
(3764, 47, 3, 1, 'Bridgeton', '', 'bridgeton', '', ''),
(3765, 8, 7, 1, 'Johnson', '', 'johnson', '', ''),
(3766, 8, 7, 1, 'Merrick', '', 'merrick', '', ''),
(3767, 31, 7, 1, 'Tunkhannock', '', 'tunkhannock', '', ''),
(3768, 13, 9, 1, 'West Stockbridge', '', 'west-stockbridge', '', ''),
(3769, 47, 3, 1, 'Hollister', '', 'hollister', '', ''),
(3770, 20, 8, 1, 'Palmetto', '', 'palmetto', '', ''),
(3771, 17, 3, 1, 'Brownton', '', 'brownton', '', ''),
(3772, 14, 8, 1, 'Hiram', '', 'hiram', '', ''),
(3773, 21, 8, 1, 'Hudgins', '', 'hudgins', '', ''),
(3774, 13, 9, 1, 'Ashfield', '', 'ashfield', '', ''),
(3775, 28, 9, 1, 'Coventry', '', 'coventry', '', ''),
(3776, 15, 8, 1, 'Fallston', '', 'fallston', '', ''),
(3777, 31, 7, 1, 'Drexel Hill', '', 'drexel-hill', '', ''),
(3778, 30, 5, 1, 'Lewis Center', '', 'lewis-center', '', ''),
(3779, 13, 9, 1, 'Lunenburg', '', 'lunenburg', '', ''),
(3780, 31, 7, 1, 'Green Lane', '', 'green-lane', '', ''),
(3781, 10, 1, 1, 'Valencia', '', 'valencia', '', ''),
(3782, 9, 4, 1, 'Broaddus', '', 'broaddus', '', ''),
(3783, 35, 5, 1, 'Ypsilanti', '', 'ypsilanti', '', ''),
(3784, 10, 1, 1, 'El Dorado Hills', '', 'el-dorado-hills', '', ''),
(3785, 10, 1, 1, 'San Juan Bautista', '', 'san-juan-bautista', '', ''),
(3786, 44, 4, 1, 'Meraux', '', 'meraux', '', ''),
(3787, 10, 1, 1, 'Santa Clarita', '', 'santa-clarita', '', ''),
(3788, 8, 7, 1, 'Montrose', '', 'montrose', '', ''),
(3789, 33, 8, 1, 'Sutton', '', 'sutton', '', ''),
(3790, 9, 4, 1, 'Wimberley', '', 'wimberley', '', ''),
(3791, 22, 8, 1, 'Edenton', '', 'edenton', '', ''),
(3792, 20, 8, 1, 'Sunrise', '', 'sunrise', '', ''),
(3793, 45, 2, 1, 'Holloman Afb', '', 'holloman-afb', '', ''),
(3794, 22, 8, 1, 'Elizabeth City', '', 'elizabeth-city', '', ''),
(3795, 42, 5, 1, 'Streator', '', 'streator', '', ''),
(3796, 21, 8, 1, 'Belle Haven', '', 'belle-haven', '', ''),
(3797, 7, 7, 1, 'West Orange', '', 'west-orange', '', ''),
(3798, 35, 5, 1, 'Chelsea', '', 'chelsea', '', ''),
(3799, 9, 4, 1, 'Plainview', '', 'plainview', '', ''),
(3800, 30, 5, 1, 'Novelty', '', 'novelty', '', ''),
(3801, 10, 1, 1, 'Compton', '', 'compton', '', ''),
(3802, 50, 3, 1, 'Maryville', '', 'maryville', '', ''),
(3803, 42, 5, 1, 'Clarendon Hills', '', 'clarendon-hills', '', ''),
(3804, 8, 7, 1, 'Mineola', '', 'mineola', '', ''),
(3805, 8, 7, 1, 'Roslyn Heights', '', 'roslyn-heights', '', ''),
(3806, 22, 8, 1, 'Flat Rock', '', 'flat-rock', '', ''),
(3807, 13, 9, 1, 'South Hamilton', '', 'south-hamilton', '', ''),
(3808, 20, 8, 1, 'North Fort Myers', '', 'north-fort-myers', '', ''),
(3809, 20, 8, 1, 'Lantana', '', 'lantana', '', ''),
(3810, 36, 5, 1, 'Fond Du Lac', '', 'fond-du-lac', '', ''),
(3811, 10, 1, 1, 'Nevada City', '', 'nevada-city', '', ''),
(3812, 13, 9, 1, 'Jamaica Plain', '', 'jamaica-plain', '', ''),
(3813, 17, 3, 1, 'Forest Lake', '', 'forest-lake', '', ''),
(3814, 8, 7, 1, 'Forestburgh', '', 'forestburgh', '', ''),
(3815, 21, 8, 1, 'Barboursville', '', 'barboursville', '', ''),
(3816, 39, 5, 1, 'Chesterton', '', 'chesterton', '', ''),
(3817, 8, 7, 1, 'Franklin Square', '', 'franklin-square', '', ''),
(3818, 31, 7, 1, 'Christiana', '', 'christiana', '', ''),
(3819, 33, 8, 1, 'Triadelphia', '', 'triadelphia', '', ''),
(3820, 37, 6, 1, 'Hazard', '', 'hazard', '', ''),
(3821, 30, 5, 1, 'Galion', '', 'galion', '', ''),
(3822, 22, 8, 1, 'Ahoskie', '', 'ahoskie', '', ''),
(3823, 9, 4, 1, 'Texas City', '', 'texas-city', '', ''),
(3824, 31, 7, 1, 'Wind Gap', '', 'wind-gap', '', ''),
(3825, 31, 7, 1, 'Nanticoke', '', 'nanticoke', '', ''),
(3826, 39, 5, 1, 'Kendallville', '', 'kendallville', '', ''),
(3827, 23, 9, 1, 'Hallowell', '', 'hallowell', '', ''),
(3828, 8, 7, 1, 'Pultneyville', '', 'pultneyville', '', ''),
(3829, 13, 9, 1, 'Southbridge', '', 'southbridge', '', ''),
(3830, 36, 5, 1, 'Mequon', '', 'mequon', '', ''),
(3831, 30, 5, 1, 'Chardon', '', 'chardon', '', ''),
(3832, 42, 5, 1, 'Villa Grove', '', 'villa-grove', '', ''),
(3833, 30, 5, 1, 'Rocky River', '', 'rocky-river', '', ''),
(3834, 35, 5, 1, 'Northville', '', 'northville', '', ''),
(3835, 14, 8, 1, 'Thomson', '', 'thomson', '', ''),
(3836, 9, 4, 1, 'Fort Hood', '', 'fort-hood', '', ''),
(3837, 42, 5, 1, 'Hanover Park', '', 'hanover-park', '', ''),
(3838, 39, 5, 1, 'Batesville', '', 'batesville', '', ''),
(3839, 10, 1, 1, 'Turlock', '', 'turlock', '', ''),
(3840, 13, 9, 1, 'Gilbertville', '', 'gilbertville', '', ''),
(3841, 57, 3, 1, 'Sioux City', '', 'sioux-city', '', ''),
(3842, 31, 7, 1, 'Womelsdorf', '', 'womelsdorf', '', ''),
(3843, 58, 3, 1, 'Oxford', '', 'oxford', '', ''),
(3844, 17, 3, 1, 'Baudette', '', 'baudette', '', ''),
(3845, 42, 5, 1, 'Du Quoin', '', 'du-quoin', '', ''),
(3846, 10, 1, 1, 'Arroyo Grande', '', 'arroyo-grande', '', ''),
(3847, 10, 1, 1, 'Oceano', '', 'oceano', '', ''),
(3848, 57, 3, 1, 'Keokuk', '', 'keokuk', '', ''),
(3849, 19, 9, 1, 'Wolfeboro', '', 'wolfeboro', '', ''),
(3850, 15, 8, 1, 'Greenbelt', '', 'greenbelt', '', ''),
(3851, 57, 3, 1, 'Grinnell', '', 'grinnell', '', ''),
(3852, 35, 5, 1, 'Grosse Pointe Park', '', 'grosse-pointe-park', '', ''),
(3853, 7, 7, 1, 'Netcong', '', 'netcong', '', ''),
(3854, 9, 4, 1, 'Roma', '', 'roma', '', ''),
(3855, 20, 8, 1, 'Lecanto', '', 'lecanto', '', ''),
(3856, 32, 4, 1, 'Guymon', '', 'guymon', '', ''),
(3857, 14, 8, 1, 'Snellville', '', 'snellville', '', ''),
(3858, 23, 9, 1, 'Berwick', '', 'berwick', '', ''),
(3859, 20, 8, 1, 'Haines City', '', 'haines-city', '', ''),
(3860, 24, 2, 1, 'Midvale', '', 'midvale', '', ''),
(3861, 31, 7, 1, 'Wellsboro', '', 'wellsboro', '', ''),
(3862, 8, 7, 1, 'Quogue', '', 'quogue', '', ''),
(3863, 12, 1, 1, 'Raymond', '', 'raymond', '', ''),
(3864, 47, 3, 1, 'Hannibal', '', 'hannibal', '', ''),
(3865, 7, 7, 1, 'Stone Harbor', '', 'stone-harbor', '', ''),
(3866, 7, 7, 1, 'Scotch Plains', '', 'scotch-plains', '', ''),
(3867, 17, 3, 1, 'Redwood Falls', '', 'redwood-falls', '', ''),
(3868, 32, 4, 1, 'Harrah', '', 'harrah', '', ''),
(3869, 35, 5, 1, 'Hartland', '', 'hartland', '', ''),
(3870, 27, 8, 1, 'Hartsville', '', 'hartsville', '', ''),
(3871, 13, 9, 1, 'West Harwich', '', 'west-harwich', '', ''),
(3872, 22, 8, 1, 'Weaverville', '', 'weaverville', '', ''),
(3873, 47, 3, 1, 'Shelbina', '', 'shelbina', '', ''),
(3874, 14, 8, 1, 'Locust Grove', '', 'locust-grove', '', ''),
(3875, 24, 2, 1, 'Brigham City', '', 'brigham-city', '', ''),
(3876, 10, 1, 1, 'Valley Village', '', 'valley-village', '', ''),
(3877, 31, 7, 1, 'Latrobe', '', 'latrobe', '', ''),
(3878, 10, 1, 1, 'Carmel Valley', '', 'carmel-valley', '', ''),
(3879, 10, 1, 1, 'Foster City', '', 'foster-city', '', ''),
(3880, 48, 6, 1, 'Scottsboro', '', 'scottsboro', '', ''),
(3881, 15, 8, 1, 'Halethorpe', '', 'halethorpe', '', ''),
(3882, 8, 7, 1, 'Gowanda', '', 'gowanda', '', ''),
(3883, 8, 7, 1, 'Croton On Hudson', '', 'croton-on-hudson', '', ''),
(3884, 55, 3, 1, 'Sedan', '', 'sedan', '', ''),
(3885, 35, 5, 1, 'Clare', '', 'clare', '', ''),
(3886, 50, 3, 1, 'Old Hickory', '', 'old-hickory', '', ''),
(3887, 8, 7, 1, 'Ilion', '', 'ilion', '', ''),
(3888, 31, 7, 1, 'New Holland', '', 'new-holland', '', ''),
(3889, 8, 7, 1, 'West Nyack', '', 'west-nyack', '', ''),
(3890, 8, 7, 1, 'Cambria Heights', '', 'cambria-heights', '', ''),
(3891, 15, 8, 1, 'Bryans Road', '', 'bryans-road', '', ''),
(3892, 39, 5, 1, 'Gary', '', 'gary', '', ''),
(3893, 52, 4, 1, 'Harrell', '', 'harrell', '', ''),
(3894, 10, 1, 1, 'Castro Valley', '', 'castro-valley', '', ''),
(3895, 35, 5, 1, 'Ionia', '', 'ionia', '', ''),
(3896, 57, 3, 1, 'Windsor Heights', '', 'windsor-heights', '', ''),
(3897, 56, 2, 1, 'Malad City', '', 'malad-city', '', ''),
(3898, 43, 2, 1, 'Manitou Springs', '', 'manitou-springs', '', ''),
(3899, 39, 5, 1, 'Winamac', '', 'winamac', '', ''),
(3900, 20, 8, 1, 'Anna Maria', '', 'anna-maria', '', ''),
(3901, 10, 1, 1, 'Menifee', '', 'menifee', '', ''),
(3902, 42, 5, 1, 'Richton Park', '', 'richton-park', '', ''),
(3903, 30, 5, 1, 'Springboro', '', 'springboro', '', ''),
(3904, 44, 4, 1, 'Westwego', '', 'westwego', '', ''),
(3905, 14, 8, 1, 'Richmond Hill', '', 'richmond-hill', '', ''),
(3906, 23, 9, 1, 'Gardiner', '', 'gardiner', '', ''),
(3907, 11, 2, 1, 'Globe', '', 'globe', '', ''),
(3908, 32, 4, 1, 'Bristow', '', 'bristow', '', ''),
(3909, 7, 7, 1, 'Frenchtown', '', 'frenchtown', '', ''),
(3910, 7, 7, 1, 'Forked River', '', 'forked-river', '', ''),
(3911, 20, 8, 1, 'Lynn Haven', '', 'lynn-haven', '', ''),
(3912, 26, 1, 1, 'Seaside', '', 'seaside', '', ''),
(3913, 30, 5, 1, 'Groveport', '', 'groveport', '', ''),
(3914, 15, 8, 1, 'Forest Hill', '', 'forest-hill', '', ''),
(3915, 55, 3, 1, 'Kechi', '', 'kechi', '', ''),
(3916, 31, 7, 1, 'Beallsville', '', 'beallsville', '', ''),
(3917, 10, 1, 1, 'Calif City', '', 'calif-city', '', ''),
(3918, 7, 7, 1, 'Longport', '', 'longport', '', ''),
(3919, 22, 8, 1, 'Kernersville', '', 'kernersville', '', ''),
(3920, 31, 7, 1, 'Glenside', '', 'glenside', '', ''),
(3921, 37, 6, 1, 'Russell Springs', '', 'russell-springs', '', ''),
(3922, 13, 9, 1, 'Carver', '', 'carver', '', ''),
(3923, 31, 7, 1, 'East Stroudsburg', '', 'east-stroudsburg', '', ''),
(3924, 9, 4, 1, 'Bulverde', '', 'bulverde', '', ''),
(3925, 9, 4, 1, 'Pearland', '', 'pearland', '', ''),
(3926, 31, 7, 1, 'Saint Clair', '', 'saint-clair', '', ''),
(3927, 10, 1, 1, 'Indian Wells', '', 'indian-wells', '', ''),
(3928, 10, 1, 1, 'Lemon grove', '', 'lemon-grove', '', ''),
(3929, 36, 5, 1, 'Rice Lake', '', 'rice-lake', '', ''),
(3930, 8, 7, 1, 'Penn Yan', '', 'penn-yan', '', ''),
(3931, 36, 5, 1, 'Washburn', '', 'washburn', '', ''),
(3932, 9, 4, 1, 'Lake Jackson', '', 'lake-jackson', '', ''),
(3933, 42, 5, 1, 'Hawthorn Woods', '', 'hawthorn-woods', '', ''),
(3934, 23, 9, 1, 'Rangeley', '', 'rangeley', '', ''),
(3935, 31, 7, 1, 'Galeton', '', 'galeton', '', ''),
(3936, 35, 5, 1, 'Drayton Plains', '', 'drayton-plains', '', ''),
(3937, 9, 4, 1, 'Nacogdoches', '', 'nacogdoches', '', ''),
(3938, 21, 8, 1, 'White Stone', '', 'white-stone', '', ''),
(3939, 31, 7, 1, 'Landenberg', '', 'landenberg', '', ''),
(3940, 35, 5, 1, 'Lapeer', '', 'lapeer', '', ''),
(3941, 8, 7, 1, 'Larchmont', '', 'larchmont', '', ''),
(3942, 9, 4, 1, 'Dalhart', '', 'dalhart', '', ''),
(3943, 51, 2, 1, 'North Las Vegas', '', 'north-las-vegas', '', ''),
(3944, 10, 1, 1, 'Le Grand', '', 'le-grand', '', ''),
(3945, 35, 5, 1, 'Owosso', '', 'owosso', '', ''),
(3946, 42, 5, 1, 'Homer Glen', '', 'homer-glen', '', ''),
(3947, 11, 2, 1, 'Sierra Vista', '', 'sierra-vista', '', ''),
(3948, 42, 5, 1, 'Bensenville', '', 'bensenville', '', ''),
(3949, 30, 5, 1, 'Massillon', '', 'massillon', '', ''),
(3950, 7, 7, 1, 'Branchville', '', 'branchville', '', ''),
(3951, 58, 3, 1, 'Weeping Water', '', 'weeping-water', '', ''),
(3952, 21, 8, 1, 'Big Stone Gap', '', 'big-stone-gap', '', ''),
(3953, 8, 7, 1, 'Delevan', '', 'delevan', '', ''),
(3954, 8, 7, 1, 'Nesconset', '', 'nesconset', '', ''),
(3955, 42, 5, 1, 'Hoopeston', '', 'hoopeston', '', ''),
(3956, 11, 2, 1, 'Fort Mohave', '', 'fort-mohave', '', ''),
(3957, 22, 8, 1, 'Manteo', '', 'manteo', '', ''),
(3958, 31, 7, 1, 'Lykens', '', 'lykens', '', ''),
(3959, 15, 8, 1, 'Randallstown', '', 'randallstown', '', ''),
(3960, 21, 8, 1, 'Blacksburg', '', 'blacksburg', '', ''),
(3961, 35, 5, 1, 'Ludington', '', 'ludington', '', ''),
(3962, 57, 3, 1, 'Belmond', '', 'belmond', '', ''),
(3963, 57, 3, 1, 'Osceola', '', 'osceola', '', ''),
(3964, 47, 3, 1, 'Lake Ozark', '', 'lake-ozark', '', ''),
(3965, 36, 5, 1, 'Waunakee', '', 'waunakee', '', ''),
(3966, 30, 5, 1, 'Barberton', '', 'barberton', '', ''),
(3967, 9, 4, 1, 'Sulphur Springs', '', 'sulphur-springs', '', ''),
(3968, 53, 2, 1, 'Big Sky', '', 'big-sky', '', ''),
(3969, 9, 4, 1, 'Farmersville', '', 'farmersville', '', ''),
(3970, 47, 3, 1, 'Osage Beach', '', 'osage-beach', '', ''),
(3971, 50, 3, 1, 'Goodlettsville', '', 'goodlettsville', '', ''),
(3972, 57, 3, 1, 'Emmetsburg', '', 'emmetsburg', '', ''),
(3973, 31, 7, 1, 'Shavertown', '', 'shavertown', '', ''),
(3974, 9, 4, 1, 'Manor', '', 'manor', '', ''),
(3975, 20, 8, 1, 'Marathon', '', 'marathon', '', ''),
(3976, 9, 4, 1, 'Liberty Hill', '', 'liberty-hill', '', ''),
(3977, 10, 1, 1, 'Montebello', '', 'montebello', '', ''),
(3978, 42, 5, 1, 'Lincolnshire', '', 'lincolnshire', '', ''),
(3979, 23, 9, 1, 'Brooks', '', 'brooks', '', ''),
(3980, 15, 8, 1, 'Joppa', '', 'joppa', '', ''),
(3981, 17, 3, 1, 'Lynd', '', 'lynd', '', ''),
(3982, 31, 7, 1, 'Finleyville', '', 'finleyville', '', ''),
(3983, 36, 5, 1, 'Wautoma', '', 'wautoma', '', ''),
(3984, 31, 7, 1, 'Mckeesport', '', 'mckeesport', '', ''),
(3985, 39, 5, 1, 'Knox', '', 'knox', '', ''),
(3986, 47, 3, 1, 'Steelville', '', 'steelville', '', ''),
(3987, 20, 8, 1, 'West Melbourne', '', 'west-melbourne', '', ''),
(3988, 35, 5, 1, 'East Lansing', '', 'east-lansing', '', ''),
(3989, 35, 5, 1, 'Houghton', '', 'houghton', '', ''),
(3990, 17, 3, 1, 'Sandstone', '', 'sandstone', '', ''),
(3991, 28, 9, 1, 'Central Falls', '', 'central-falls', '', ''),
(3992, 35, 5, 1, 'Southfield', '', 'southfield', '', ''),
(3993, 42, 5, 1, 'Blue Island', '', 'blue-island', '', ''),
(3994, 36, 5, 1, 'Ladysmith', '', 'ladysmith', '', ''),
(3995, 36, 5, 1, 'Mineral Point', '', 'mineral-point', '', ''),
(3996, 39, 5, 1, 'Trafalgar', '', 'trafalgar', '', ''),
(3997, 30, 5, 1, 'Loudonville', '', 'loudonville', '', ''),
(3998, 36, 5, 1, 'Montello', '', 'montello', '', ''),
(3999, 31, 7, 1, 'Souderton', '', 'souderton', '', ''),
(4000, 8, 7, 1, 'West Harrison', '', 'west-harrison', '', ''),
(4001, 31, 7, 1, 'Oaks', '', 'oaks', '', ''),
(4002, 37, 6, 1, 'Paintsville', '', 'paintsville', '', ''),
(4003, 30, 5, 1, 'Perrysburg', '', 'perrysburg', '', ''),
(4004, 22, 8, 1, 'Mount Olive', '', 'mount-olive', '', ''),
(4005, 10, 1, 1, 'Walnut', '', 'walnut', '', ''),
(4006, 50, 3, 1, 'Readyville', '', 'readyville', '', ''),
(4007, 42, 5, 1, 'Palatine', '', 'palatine', '', ''),
(4008, 39, 5, 1, 'Nappanee', '', 'nappanee', '', ''),
(4009, 9, 4, 1, 'Navasota', '', 'navasota', '', ''),
(4010, 7, 7, 1, 'Deal', '', 'deal', '', ''),
(4011, 27, 8, 1, 'Newberry', '', 'newberry', '', ''),
(4012, 22, 8, 1, 'Black Mountain', '', 'black-mountain', '', ''),
(4013, 22, 8, 1, 'Rocky Mount', '', 'rocky-mount', '', ''),
(4014, 8, 7, 1, 'Mattituck', '', 'mattituck', '', ''),
(4015, 12, 1, 1, 'Colville', '', 'colville', '', ''),
(4016, 12, 1, 1, 'Bitter Lake', '', 'bitter-lake', '', ''),
(4017, 7, 7, 1, 'Bergenfield', '', 'bergenfield', '', ''),
(4018, 8, 7, 1, 'Ocean Beach', '', 'ocean-beach', '', ''),
(4019, 12, 1, 1, 'Ocean Shores', '', 'ocean-shores', '', ''),
(4020, 21, 8, 1, 'Floyd', '', 'floyd', '', ''),
(4021, 23, 9, 1, 'Buckfield', '', 'buckfield', '', ''),
(4022, 14, 8, 1, 'Waycross', '', 'waycross', '', ''),
(4023, 24, 2, 1, 'Fielding', '', 'fielding', '', ''),
(4024, 38, 9, 1, 'Bradford', '', 'bradford', '', ''),
(4025, 17, 3, 1, 'Excelsior', '', 'excelsior', '', ''),
(4026, 10, 1, 1, 'El Segundo', '', 'el-segundo', '', ''),
(4027, 13, 9, 1, 'Edgartown', '', 'edgartown', '', ''),
(4028, 49, 3, 1, 'Worthing', '', 'worthing', '', ''),
(4029, 30, 5, 1, 'North Ridgeville', '', 'north-ridgeville', '', ''),
(4030, 12, 1, 1, 'Sequim', '', 'sequim', '', ''),
(4031, 21, 8, 1, 'Stephens City', '', 'stephens-city', '', ''),
(4032, 8, 7, 1, 'Margaretville', '', 'margaretville', '', ''),
(4033, 38, 9, 1, 'Enosburg Falls', '', 'enosburg-falls', '', ''),
(4034, 12, 1, 1, 'East Olympia', '', 'east-olympia', '', ''),
(4035, 10, 1, 1, 'Orinda', '', 'orinda', '', ''),
(4036, 8, 7, 1, 'Saugerties', '', 'saugerties', '', ''),
(4037, 13, 9, 1, 'Foxboro', '', 'foxboro', '', ''),
(4038, 30, 5, 1, 'Westerville', '', 'westerville', '', ''),
(4039, 36, 5, 1, 'Elkhart Lake', '', 'elkhart-lake', '', ''),
(4040, 36, 5, 1, 'Mukwonago', '', 'mukwonago', '', ''),
(4041, 7, 7, 1, 'Millburn', '', 'millburn', '', ''),
(4042, 8, 7, 1, 'Peekskill', '', 'peekskill', '', ''),
(4043, 7, 7, 1, 'Neptune', '', 'neptune', '', ''),
(4044, 57, 3, 1, 'Shenandoah', '', 'shenandoah', '', ''),
(4045, 36, 5, 1, 'Park Falls', '', 'park-falls', '', ''),
(4046, 35, 5, 1, 'Paw Paw', '', 'paw-paw', '', ''),
(4047, 8, 7, 1, 'Pawling', '', 'pawling', '', ''),
(4048, 13, 9, 1, 'North Truro', '', 'north-truro', '', ''),
(4049, 42, 5, 1, 'Mokena', '', 'mokena', '', ''),
(4050, 42, 5, 1, 'Pecatonica', '', 'pecatonica', '', ''),
(4051, 57, 3, 1, 'Pella', '', 'pella', '', ''),
(4052, 8, 7, 1, 'Stony Point', '', 'stony-point', '', ''),
(4053, 35, 5, 1, 'Negaunee', '', 'negaunee', '', ''),
(4054, 36, 5, 1, 'Egg Harbor', '', 'egg-harbor', '', ''),
(4055, 31, 7, 1, 'Center Valley', '', 'center-valley', '', ''),
(4056, 8, 7, 1, 'Purchase', '', 'purchase', '', ''),
(4057, 41, 9, 1, 'Trumbull', '', 'trumbull', '', ''),
(4058, 41, 9, 1, 'New Canaan', '', 'new-canaan', '', ''),
(4059, 42, 5, 1, 'Spring Grove', '', 'spring-grove', '', ''),
(4060, 8, 7, 1, 'West Hurley', '', 'west-hurley', '', ''),
(4061, 19, 9, 1, 'Peterborough', '', 'peterborough', '', ''),
(4062, 22, 8, 1, 'Kannapolis', '', 'kannapolis', '', ''),
(4063, 49, 3, 1, 'Pierre', '', 'pierre', '', ''),
(4064, 61, 6, 1, 'Mccomb', '', 'mccomb', '', ''),
(4065, 17, 3, 1, 'Pipestone', '', 'pipestone', '', ''),
(4066, 31, 7, 1, 'Mc Kees Rocks', '', 'mc-kees-rocks', '', ''),
(4067, 12, 1, 1, 'Mercer Island', '', 'mercer-island', '', ''),
(4068, 31, 7, 1, 'Skippack', '', 'skippack', '', ''),
(4069, 35, 5, 1, 'Escanaba', '', 'escanaba', '', ''),
(4070, 7, 7, 1, 'Leonia', '', 'leonia', '', ''),
(4071, 20, 8, 1, 'Crystal River', '', 'crystal-river', '', ''),
(4072, 7, 7, 1, 'Summit', '', 'summit', '', ''),
(4073, 59, 3, 1, 'Mott', '', 'mott', '', ''),
(4074, 30, 5, 1, 'Port Clinton', '', 'port-clinton', '', ''),
(4075, 53, 2, 1, 'West Yellowstone', '', 'west-yellowstone', '', ''),
(4076, 7, 7, 1, 'Ocean', '', 'ocean', '', ''),
(4077, 31, 7, 1, 'Mountainhome', '', 'mountainhome', '', ''),
(4078, 32, 4, 1, 'Ponca City', '', 'ponca-city', '', ''),
(4079, 21, 8, 1, 'Poquoson', '', 'poquoson', '', ''),
(4080, 9, 4, 1, 'Port Arthur', '', 'port-arthur', '', ''),
(4081, 9, 4, 1, 'Port Lavaca', '', 'port-lavaca', '', ''),
(4082, 23, 9, 1, 'South Portland', '', 'south-portland', '', ''),
(4083, 31, 7, 1, 'Burgettstown', '', 'burgettstown', '', ''),
(4084, 8, 7, 1, 'Pound Ridge', '', 'pound-ridge', '', ''),
(4085, 24, 2, 1, 'Vernal', '', 'vernal', '', ''),
(4086, 17, 3, 1, 'Barrett', '', 'barrett', '', ''),
(4087, 42, 5, 1, 'Rushville', '', 'rushville', '', ''),
(4088, 7, 7, 1, 'Oaklyn', '', 'oaklyn', '', ''),
(4089, 49, 3, 1, 'Herreid', '', 'herreid', '', ''),
(4090, 7, 7, 1, 'Rahway', '', 'rahway', '', ''),
(4091, 48, 6, 1, 'Daphne', '', 'daphne', '', ''),
(4092, 35, 5, 1, 'Saugatuck', '', 'saugatuck', '', ''),
(4093, 31, 7, 1, 'Allison Park', '', 'allison-park', '', ''),
(4094, 31, 7, 1, 'Zelienople', '', 'zelienople', '', ''),
(4095, 31, 7, 1, 'Fombell', '', 'fombell', '', ''),
(4096, 26, 1, 1, 'Gladstone', '', 'gladstone', '', ''),
(4097, 14, 8, 1, 'Austell', '', 'austell', '', ''),
(4098, 56, 2, 1, 'Kellogg', '', 'kellogg', '', ''),
(4099, 56, 2, 1, 'Rupert', '', 'rupert', '', ''),
(4100, 30, 5, 1, 'Trotwood', '', 'trotwood', '', ''),
(4101, 57, 3, 1, 'Villisca', '', 'villisca', '', ''),
(4102, 22, 8, 1, 'Rockingham', '', 'rockingham', '', ''),
(4103, 52, 4, 1, 'Blytheville', '', 'blytheville', '', ''),
(4104, 9, 4, 1, 'Snyder', '', 'snyder', '', ''),
(4105, 50, 3, 1, 'Milan', '', 'milan', '', ''),
(4106, 30, 5, 1, 'Tiffin', '', 'tiffin', '', ''),
(4107, 33, 8, 1, 'Spencer', '', 'spencer', '', ''),
(4108, 35, 5, 1, 'Roscommon', '', 'roscommon', '', ''),
(4109, 17, 3, 1, 'Rosemount', '', 'rosemount', '', ''),
(4110, 8, 7, 1, 'Rosendale', '', 'rosendale', '', ''),
(4111, 17, 3, 1, 'Roseau', '', 'roseau', '', ''),
(4112, 13, 9, 1, 'North Attleboro', '', 'north-attleboro', '', ''),
(4113, 56, 2, 1, 'Saint Anthony', '', 'saint-anthony', '', ''),
(4114, 13, 9, 1, 'Revere', '', 'revere', '', ''),
(4115, 36, 5, 1, 'Whitewater', '', 'whitewater', '', ''),
(4116, 10, 1, 1, 'Tuolumne', '', 'tuolumne', '', ''),
(4117, 20, 8, 1, 'Ruskin', '', 'ruskin', '', ''),
(4118, 55, 3, 1, 'Russell', '', 'russell', '', ''),
(4119, 14, 8, 1, 'Americus', '', 'americus', '', ''),
(4120, 23, 9, 1, 'Buxton', '', 'buxton', '', ''),
(4121, 35, 5, 1, 'Bloomfield Hills', '', 'bloomfield-hills', '', ''),
(4122, 9, 4, 1, 'Salado', '', 'salado', '', ''),
(4123, 43, 2, 1, 'Salida', '', 'salida', '', ''),
(4124, 31, 7, 1, 'Wexford', '', 'wexford', '', ''),
(4125, 12, 1, 1, 'Friday Harbor', '', 'friday-harbor', '', ''),
(4126, 38, 9, 1, 'Putney', '', 'putney', '', ''),
(4127, 23, 9, 1, 'Springvale', '', 'springvale', '', ''),
(4128, 24, 2, 1, 'Moroni', '', 'moroni', '', ''),
(4129, 10, 1, 1, 'Soquel', '', 'soquel', '', ''),
(4130, 26, 1, 1, 'Coquille', '', 'coquille', '', ''),
(4131, 31, 7, 1, 'Sayre', '', 'sayre', '', ''),
(4132, 23, 9, 1, 'Winter Harbor', '', 'winter-harbor', '', ''),
(4133, 23, 9, 1, 'Standish', '', 'standish', '', ''),
(4134, 24, 2, 1, 'Ivins', '', 'ivins', '', ''),
(4135, 31, 7, 1, 'Scottdale', '', 'scottdale', '', ''),
(4136, 20, 8, 1, 'Archer', '', 'archer', '', ''),
(4137, 20, 8, 1, 'Santa Rosa Beach', '', 'santa-rosa-beach', '', ''),
(4138, 31, 7, 1, 'Sellersville', '', 'sellersville', '', ''),
(4139, 48, 6, 1, 'Selma', '', 'selma', '', ''),
(4140, 20, 8, 1, 'Clermont', '', 'clermont', '', ''),
(4141, 8, 7, 1, 'Ellenville', '', 'ellenville', '', ''),
(4142, 10, 1, 1, 'Garberville', '', 'garberville', '', ''),
(4143, 26, 1, 1, 'Saint Helens', '', 'saint-helens', '', ''),
(4144, 20, 8, 1, 'Lake Helen', '', 'lake-helen', '', ''),
(4145, 20, 8, 1, 'Miami Shores', '', 'miami-shores', '', ''),
(4146, 13, 9, 1, 'Seekonk', '', 'seekonk', '', ''),
(4147, 15, 8, 1, 'Beltsville', '', 'beltsville', '', ''),
(4148, 30, 5, 1, 'Blanchester', '', 'blanchester', '', ''),
(4149, 10, 1, 1, 'Sierra City', '', 'sierra-city', '', ''),
(4150, 10, 1, 1, 'Sierra Madre', '', 'sierra-madre', '', ''),
(4151, 10, 1, 1, 'Sonora', '', 'sonora', '', ''),
(4152, 22, 8, 1, 'Creedmoor', '', 'creedmoor', '', ''),
(4153, 50, 3, 1, 'Signal Mountain', '', 'signal-mountain', '', ''),
(4154, 41, 9, 1, 'Simsbury', '', 'simsbury', '', ''),
(4155, 8, 7, 1, 'Shokan', '', 'shokan', '', ''),
(4156, 12, 1, 1, 'Sedro Woolley', '', 'sedro-woolley', '', ''),
(4157, 31, 7, 1, 'Gratz', '', 'gratz', '', ''),
(4158, 31, 7, 1, 'Strabane', '', 'strabane', '', ''),
(4159, 8, 7, 1, 'Sleepy Hollow', '', 'sleepy-hollow', '', ''),
(4160, 8, 7, 1, 'Smithtown', '', 'smithtown', '', ''),
(4161, 12, 1, 1, 'Fall City', '', 'fall-city', '', ''),
(4162, 14, 8, 1, 'Social Circle', '', 'social-circle', '', ''),
(4163, 10, 1, 1, 'Suisun City', '', 'suisun-city', '', ''),
(4164, 10, 1, 1, 'Freedom', '', 'freedom', '', ''),
(4165, 7, 7, 1, 'Whippany', '', 'whippany', '', ''),
(4166, 42, 5, 1, 'Mchenry', '', 'mchenry', '', ''),
(4167, 48, 6, 1, 'Alabaster', '', 'alabaster', '', ''),
(4168, 41, 9, 1, 'Southbury', '', 'southbury', '', ''),
(4169, 35, 5, 1, 'Southgate', '', 'southgate', '', ''),
(4170, 37, 6, 1, 'South Williamson', '', 'south-williamson', '', ''),
(4171, 37, 6, 1, 'Belfry', '', 'belfry', '', ''),
(4172, 14, 8, 1, 'Fairburn', '', 'fairburn', '', ''),
(4173, 27, 8, 1, 'Spartanburg', '', 'spartanburg', '', ''),
(4174, 45, 2, 1, 'Alto', '', 'alto', '', ''),
(4175, 31, 7, 1, 'Wycombe', '', 'wycombe', '', ''),
(4176, 8, 7, 1, 'Putnam Valley', '', 'putnam-valley', '', ''),
(4177, 36, 5, 1, 'Saint Croix Falls', '', 'saint-croix-falls', '', ''),
(4178, 10, 1, 1, 'Sun Valley', '', 'sun-valley', '', ''),
(4179, 42, 5, 1, 'La Salle', '', 'la-salle', '', ''),
(4180, 31, 7, 1, 'Carnegie', '', 'carnegie', '', ''),
(4181, 32, 4, 1, 'Yukon', '', 'yukon', '', ''),
(4182, 35, 5, 1, 'White Cloud', '', 'white-cloud', '', ''),
(4183, 13, 9, 1, 'Fiskdale', '', 'fiskdale', '', ''),
(4184, 47, 3, 1, 'Ozark', '', 'ozark', '', ''),
(4185, 36, 5, 1, 'Reedsburg', '', 'reedsburg', '', ''),
(4186, 48, 6, 1, 'Summerdale', '', 'summerdale', '', ''),
(4187, 47, 3, 1, 'Cadet', '', 'cadet', '', ''),
(4188, 55, 3, 1, 'Dearing', '', 'dearing', '', ''),
(4189, 48, 6, 1, 'Rainbow City', '', 'rainbow-city', '', ''),
(4190, 13, 9, 1, 'Blackstone', '', 'blackstone', '', ''),
(4191, 8, 7, 1, 'Pine Plains', '', 'pine-plains', '', ''),
(4192, 8, 7, 1, 'Schroon Lake', '', 'schroon-lake', '', ''),
(4193, 13, 9, 1, 'Sharon', '', 'sharon', '', ''),
(4194, 33, 8, 1, 'Summersville', '', 'summersville', '', ''),
(4195, 36, 5, 1, 'Sun Prairie', '', 'sun-prairie', '', ''),
(4196, 35, 5, 1, 'Williamston', '', 'williamston', '', ''),
(4197, 58, 3, 1, 'Holdrege', '', 'holdrege', '', ''),
(4198, 36, 5, 1, 'Elm Grove', '', 'elm-grove', '', ''),
(4199, 50, 3, 1, 'Gatlinburg', '', 'gatlinburg', '', ''),
(4200, 47, 3, 1, 'Blue Eye', '', 'blue-eye', '', ''),
(4201, 22, 8, 1, 'Wake Forest', '', 'wake-forest', '', ''),
(4202, 35, 5, 1, 'Tecumseh', '', 'tecumseh', '', ''),
(4203, 9, 4, 1, 'Canyon', '', 'canyon', '', ''),
(4204, 9, 4, 1, 'Weatherford', '', 'weatherford', '', ''),
(4205, 8, 7, 1, 'Sunnyside', '', 'sunnyside', '', ''),
(4206, 32, 4, 1, 'Durant', '', 'durant', '', ''),
(4207, 41, 9, 1, 'Shelton', '', 'shelton', '', ''),
(4208, 7, 7, 1, 'Montville', '', 'montville', '', ''),
(4209, 42, 5, 1, 'Chicago Heights', '', 'chicago-heights', '', ''),
(4210, 50, 3, 1, 'Dyersburg', '', 'dyersburg', '', ''),
(4211, 7, 7, 1, 'Mountain Lakes', '', 'mountain-lakes', '', ''),
(4212, 20, 8, 1, 'Greenacres', '', 'greenacres', '', ''),
(4213, 52, 4, 1, 'West Memphis', '', 'west-memphis', '', ''),
(4214, 32, 4, 1, 'Disney', '', 'disney', '', ''),
(4215, 7, 7, 1, 'High Bridge', '', 'high-bridge', '', ''),
(4216, 22, 8, 1, 'Stoneville', '', 'stoneville', '', ''),
(4217, 20, 8, 1, 'Holiday', '', 'holiday', '', ''),
(4218, 22, 8, 1, 'Crumpler', '', 'crumpler', '', ''),
(4219, 9, 4, 1, 'Eldorado', '', 'eldorado', '', ''),
(4220, 7, 7, 1, 'Flanders', '', 'flanders', '', ''),
(4221, 7, 7, 1, 'Succasunna', '', 'succasunna', '', ''),
(4222, 48, 6, 1, 'Fairhope', '', 'fairhope', '', ''),
(4223, 31, 7, 1, 'Plumsteadville', '', 'plumsteadville', '', ''),
(4224, 39, 5, 1, 'Munster', '', 'munster', '', ''),
(4225, 36, 5, 1, 'Shell Lake', '', 'shell-lake', '', ''),
(4226, 8, 7, 1, 'Fresh Meadows', '', 'fresh-meadows', '', ''),
(4227, 8, 7, 1, 'Saint Albans', '', 'saint-albans', '', ''),
(4228, 58, 3, 1, 'Republican City', '', 'republican-city', '', ''),
(4229, 42, 5, 1, 'Western Springs', '', 'western-springs', '', ''),
(4230, 36, 5, 1, 'Marinette', '', 'marinette', '', ''),
(4231, 44, 4, 1, 'Bossier City', '', 'bossier-city', '', ''),
(4232, 26, 1, 1, 'Lincoln City', '', 'lincoln-city', '', ''),
(4233, 28, 9, 1, 'Woonsocket', '', 'woonsocket', '', ''),
(4234, 30, 5, 1, 'Heath', '', 'heath', '', ''),
(4235, 35, 5, 1, 'Three Rivers', '', 'three-rivers', '', ''),
(4236, 8, 7, 1, 'Owego', '', 'owego', '', ''),
(4237, 31, 7, 1, 'Mount Gretna', '', 'mount-gretna', '', ''),
(4238, 30, 5, 1, 'Tipp City', '', 'tipp-city', '', ''),
(4239, 31, 7, 1, 'Buckingham', '', 'buckingham', '', ''),
(4240, 32, 4, 1, 'Stillwater', '', 'stillwater', '', ''),
(4241, 43, 2, 1, 'Holly', '', 'holly', '', ''),
(4242, 35, 5, 1, 'South Rockwood', '', 'south-rockwood', '', ''),
(4243, 31, 7, 1, 'Matamoras', '', 'matamoras', '', ''),
(4244, 7, 7, 1, 'Basking Ridge', '', 'basking-ridge', '', ''),
(4245, 9, 4, 1, 'Aransas Pass', '', 'aransas-pass', '', ''),
(4246, 13, 9, 1, 'Auburndale', '', 'auburndale', '', ''),
(4247, 26, 1, 1, 'Roseburg', '', 'roseburg', '', ''),
(4248, 8, 7, 1, 'Unadilla', '', 'unadilla', '', ''),
(4249, 38, 9, 1, 'Calais', '', 'calais', '', ''),
(4250, 23, 9, 1, 'Unity', '', 'unity', '', ''),
(4251, 37, 6, 1, 'Morehead', '', 'morehead', '', ''),
(4252, 41, 9, 1, 'Mansfield Center', '', 'mansfield-center', '', ''),
(4253, 8, 7, 1, 'Rhinebeck', '', 'rhinebeck', '', ''),
(4254, 8, 7, 1, 'Wyandanch', '', 'wyandanch', '', ''),
(4255, 10, 1, 1, 'Stevenson Ranch', '', 'stevenson-ranch', '', ''),
(4256, 10, 1, 1, 'North Hills', '', 'north-hills', '', ''),
(4257, 24, 2, 1, 'Lindon', '', 'lindon', '', ''),
(4258, 38, 9, 1, 'Waitsfield', '', 'waitsfield', '', ''),
(4259, 52, 4, 1, 'Van Buren', '', 'van-buren', '', ''),
(4260, 7, 7, 1, 'Colonia', '', 'colonia', '', ''),
(4261, 37, 6, 1, 'Crestwood', '', 'crestwood', '', ''),
(4262, 52, 4, 1, 'Bella Vista', '', 'bella-vista', '', ''),
(4263, 31, 7, 1, 'Hatboro', '', 'hatboro', '', ''),
(4264, 30, 5, 1, 'North Baltimore', '', 'north-baltimore', '', ''),
(4265, 57, 3, 1, 'Chariton', '', 'chariton', '', ''),
(4266, 13, 9, 1, 'Wayland', '', 'wayland', '', ''),
(4267, 7, 7, 1, 'Atco', '', 'atco', '', ''),
(4268, 17, 3, 1, 'Warroad', '', 'warroad', '', ''),
(4269, 15, 8, 1, 'Mount Rainier', '', 'mount-rainier', '', ''),
(4270, 13, 9, 1, 'Holliston', '', 'holliston', '', ''),
(4271, 36, 5, 1, 'Waukesha', '', 'waukesha', '', ''),
(4272, 36, 5, 1, 'Schofield', '', 'schofield', '', ''),
(4273, 19, 9, 1, 'Whitefield', '', 'whitefield', '', ''),
(4274, 57, 3, 1, 'Webster City', '', 'webster-city', '', ''),
(4275, 13, 9, 1, 'Wellfleet', '', 'wellfleet', '', ''),
(4276, 23, 9, 1, 'Wells', '', 'wells', '', ''),
(4277, 7, 7, 1, 'Thorofare', '', 'thorofare', '', ''),
(4278, 17, 3, 1, 'Maple Plain', '', 'maple-plain', '', ''),
(4279, 12, 1, 1, 'Tulalip', '', 'tulalip', '', ''),
(4280, 42, 5, 1, 'Mount Morris', '', 'mount-morris', '', ''),
(4281, 32, 4, 1, 'Nicoma Park', '', 'nicoma-park', '', ''),
(4282, 48, 6, 1, 'Guntersville', '', 'guntersville', '', ''),
(4283, 7, 7, 1, 'Rutherford', '', 'rutherford', '', ''),
(4284, 10, 1, 1, 'Willits', '', 'willits', '', ''),
(4285, 49, 3, 1, 'Winner', '', 'winner', '', ''),
(4286, 17, 3, 1, 'Winsted', '', 'winsted', '', ''),
(4287, 57, 3, 1, 'Paullina', '', 'paullina', '', ''),
(4288, 13, 9, 1, 'Woods Hole', '', 'woods-hole', '', ''),
(4289, 17, 3, 1, 'Akeley', '', 'akeley', '', ''),
(4290, 32, 4, 1, 'Woodward', '', 'woodward', '', ''),
(4291, 32, 4, 1, 'Moore', '', 'moore', '', ''),
(4292, 8, 7, 1, 'Shrub Oak', '', 'shrub-oak', '', ''),
(4293, 43, 2, 1, 'Walsenburg', '', 'walsenburg', '', ''),
(4294, 10, 1, 1, 'Yucaipa', '', 'yucaipa', '', ''),
(4295, 10, 1, 1, 'San Leandro', '', 'san-leandro', '', ''),
(4296, 30, 5, 1, 'Zanesville', '', 'zanesville', '', ''),
(4297, 42, 5, 1, 'Zion', '', 'zion', '', ''),
(4298, 7, 7, 1, 'Old Bridge', '', 'old-bridge', '', ''),
(4299, 7, 7, 1, 'Wallington', '', 'wallington', '', ''),
(4300, 31, 7, 1, 'West Homestead', '', 'west-homestead', '', ''),
(4301, 31, 7, 1, 'Trexlertown', '', 'trexlertown', '', ''),
(4302, 20, 8, 1, 'Miramar', '', 'miramar', '', ''),
(4303, 8, 7, 1, 'West Hempstead', '', 'west-hempstead', '', ''),
(4304, 26, 1, 1, 'Sisters', '', 'sisters', '', ''),
(4305, 33, 8, 1, 'Seth', '', 'seth', '', ''),
(4306, 31, 7, 1, 'Ronks', '', 'ronks', '', ''),
(4307, 8, 7, 1, 'Babylon', '', 'babylon', '', ''),
(4308, 38, 9, 1, 'Shelburne', '', 'shelburne', '', ''),
(4309, 7, 7, 1, 'South Hackensack', '', 'south-hackensack', '', ''),
(4310, 20, 8, 1, 'Palm City', '', 'palm-city', '', ''),
(4311, 7, 7, 1, 'Lanoka Harbor', '', 'lanoka-harbor', '', ''),
(4312, 8, 7, 1, 'Melville', '', 'melville', '', ''),
(4313, 8, 7, 1, 'East Norwich', '', 'east-norwich', '', ''),
(4314, 8, 7, 1, 'Cross River', '', 'cross-river', '', ''),
(4315, 20, 8, 1, 'Jensen Beach', '', 'jensen-beach', '', ''),
(4316, 7, 7, 1, 'Rockaway', '', 'rockaway', '', ''),
(4317, 8, 7, 1, 'Port Jefferson Sta', '', 'port-jefferson-sta', '', ''),
(4318, 8, 7, 1, 'Wading River', '', 'wading-river', '', ''),
(4319, 30, 5, 1, 'Euclid', '', 'euclid', '', ''),
(4320, 31, 7, 1, 'New Tripoli', '', 'new-tripoli', '', ''),
(4321, 8, 7, 1, 'Cedarhurst', '', 'cedarhurst', '', ''),
(4322, 8, 7, 1, 'Oakdale', '', 'oakdale', '', ''),
(4323, 8, 7, 1, 'Jericho', '', 'jericho', '', ''),
(4324, 8, 7, 1, 'Blauvelt', '', 'blauvelt', '', ''),
(4325, 41, 9, 1, 'Windsor Locks', '', 'windsor-locks', '', ''),
(4326, 8, 7, 1, 'West Babylon', '', 'west-babylon', '', ''),
(4327, 8, 7, 1, 'Bethpage', '', 'bethpage', '', ''),
(4328, 7, 7, 1, 'Princeton Junction', '', 'princeton-junction', '', ''),
(4329, 7, 7, 1, 'Garfield', '', 'garfield', '', ''),
(4330, 7, 7, 1, 'Bradley Beach', '', 'bradley-beach', '', ''),
(4331, 20, 8, 1, 'Tamarac', '', 'tamarac', '', ''),
(4332, 7, 7, 1, 'Whitehouse Station', '', 'whitehouse-station', '', ''),
(4333, 8, 7, 1, 'Kings Park', '', 'kings-park', '', ''),
(4334, 8, 7, 1, 'Shoreham', '', 'shoreham', '', ''),
(4335, 7, 7, 1, 'South Amboy', '', 'south-amboy', '', ''),
(4336, 8, 7, 1, 'Albertson', '', 'albertson', '', ''),
(4337, 7, 7, 1, 'Hillside', '', 'hillside', '', ''),
(4338, 7, 7, 1, 'Haskell', '', 'haskell', '', ''),
(4339, 41, 9, 1, 'Willimantic', '', 'willimantic', '', ''),
(4340, 7, 7, 1, 'West Long Branch', '', 'west-long-branch', '', ''),
(4341, 20, 8, 1, 'Cape Canaveral', '', 'cape-canaveral', '', ''),
(4342, 8, 7, 1, 'North Bellmore', '', 'north-bellmore', '', ''),
(4343, 7, 7, 1, 'Plainsboro', '', 'plainsboro', '', ''),
(4344, 31, 7, 1, 'Mount Pocono', '', 'mount-pocono', '', ''),
(4345, 8, 7, 1, 'Moriches', '', 'moriches', '', ''),
(4346, 31, 7, 1, 'Dresher', '', 'dresher', '', ''),
(4347, 42, 5, 1, 'Harwood Heights', '', 'harwood-heights', '', ''),
(4348, 8, 7, 1, 'Red Hook', '', 'red-hook', '', ''),
(4349, 8, 7, 1, 'Oakland Gardens', '', 'oakland-gardens', '', ''),
(4350, 10, 1, 1, 'Millbrae', '', 'millbrae', '', ''),
(4351, 7, 7, 1, 'Bound Brook', '', 'bound-brook', '', ''),
(4352, 35, 5, 1, 'Wixom', '', 'wixom', '', ''),
(4353, 7, 7, 1, 'Belford', '', 'belford', '', ''),
(4354, 41, 9, 1, 'South Windsor', '', 'south-windsor', '', ''),
(4355, 7, 7, 1, 'Middlesex', '', 'middlesex', '', ''),
(4356, 35, 5, 1, 'Madison Heights', '', 'madison-heights', '', ''),
(4357, 7, 7, 1, 'West Milford', '', 'west-milford', '', ''),
(4358, 8, 7, 1, 'Kinderhook', '', 'kinderhook', '', ''),
(4359, 20, 8, 1, 'Osteen', '', 'osteen', '', ''),
(4360, 20, 8, 1, 'New Smyrna Beach', '', 'new-smyrna-beach', '', ''),
(4361, 20, 8, 1, 'Satellite Beach', '', 'satellite-beach', '', ''),
(4362, 7, 7, 1, 'Westville', '', 'westville', '', ''),
(4363, 8, 7, 1, 'Woodmere', '', 'woodmere', '', ''),
(4364, 8, 7, 1, 'Dryden', '', 'dryden', '', ''),
(4365, 8, 7, 1, 'Potsdam', '', 'potsdam', '', ''),
(4366, 7, 7, 1, 'Surf City', '', 'surf-city', '', ''),
(4367, 35, 5, 1, 'Wyoming', '', 'wyoming', '', ''),
(4368, 8, 7, 1, 'Speonk', '', 'speonk', '', ''),
(4369, 31, 7, 1, 'Fairless Hills', '', 'fairless-hills', '', ''),
(4370, 7, 7, 1, 'Branchburg', '', 'branchburg', '', ''),
(4371, 7, 7, 1, 'West Caldwell', '', 'west-caldwell', '', ''),
(4372, 8, 7, 1, 'Tappan', '', 'tappan', '', ''),
(4373, 42, 5, 1, 'Libertyville', '', 'libertyville', '', ''),
(4374, 7, 7, 1, 'Parlin', '', 'parlin', '', ''),
(4375, 10, 1, 1, 'Redway', '', 'redway', '', ''),
(4376, 7, 7, 1, 'Mine Hill', '', 'mine-hill', '', ''),
(4377, 7, 7, 1, 'Hopatcong', '', 'hopatcong', '', ''),
(4378, 8, 7, 1, 'Islip Terrace', '', 'islip-terrace', '', ''),
(4379, 21, 8, 1, 'South Hill', '', 'south-hill', '', ''),
(4380, 22, 8, 1, 'Havelock', '', 'havelock', '', ''),
(4381, 41, 9, 1, 'Plainville', '', 'plainville', '', ''),
(4382, 8, 7, 1, 'Middle Island', '', 'middle-island', '', ''),
(4383, 7, 7, 1, 'New Providence', '', 'new-providence', '', ''),
(4384, 53, 2, 1, 'Kila', '', 'kila', '', ''),
(4385, 41, 9, 1, 'Glastonbury', '', 'glastonbury', '', ''),
(4386, 20, 8, 1, 'Sebastian', '', 'sebastian', '', ''),
(4387, 7, 7, 1, 'Wildwood Crest', '', 'wildwood-crest', '', ''),
(4388, 30, 5, 1, 'Vandalia', '', 'vandalia', '', ''),
(4389, 7, 7, 1, 'Lavallette', '', 'lavallette', '', ''),
(4390, 7, 7, 1, 'Maywood', '', 'maywood', '', ''),
(4391, 30, 5, 1, 'Sylvania', '', 'sylvania', '', ''),
(4392, 41, 9, 1, 'New Milford', '', 'new-milford', '', ''),
(4393, 8, 7, 1, 'Far Rockaway', '', 'far-rockaway', '', ''),
(4394, 8, 7, 1, 'Rockaway Park', '', 'rockaway-park', '', ''),
(4395, 8, 7, 1, 'Howard Beach', '', 'howard-beach', '', ''),
(4396, 35, 5, 1, 'Saline', '', 'saline', '', ''),
(4397, 42, 5, 1, 'Algonquin', '', 'algonquin', '', ''),
(4398, 7, 7, 1, 'Palisades Park', '', 'palisades-park', '', ''),
(4399, 42, 5, 1, 'Gurnee', '', 'gurnee', '', ''),
(4400, 41, 9, 1, 'Chaplin', '', 'chaplin', '', ''),
(4401, 7, 7, 1, 'West Paterson', '', 'west-paterson', '', ''),
(4402, 8, 7, 1, 'Miller Place', '', 'miller-place', '', ''),
(4403, 41, 9, 1, 'Vernon Rockville', '', 'vernon-rockville', '', ''),
(4404, 42, 5, 1, 'Lake Zurich', '', 'lake-zurich', '', ''),
(4405, 35, 5, 1, 'Jenison', '', 'jenison', '', ''),
(4406, 35, 5, 1, 'Lake Orion', '', 'lake-orion', '', ''),
(4407, 35, 5, 1, 'Allen Park', '', 'allen-park', '', ''),
(4408, 35, 5, 1, 'Rochester Hills', '', 'rochester-hills', '', ''),
(4409, 10, 1, 1, 'Bay Point', '', 'bay-point', '', ''),
(4410, 35, 5, 1, 'Harrison Township', '', 'harrison-township', '', ''),
(4411, 36, 5, 1, 'New Berlin', '', 'new-berlin', '', ''),
(4412, 36, 5, 1, 'Plover', '', 'plover', '', ''),
(4413, 36, 5, 1, 'Hales Corners', '', 'hales-corners', '', ''),
(4414, 36, 5, 1, 'Menomonee Falls', '', 'menomonee-falls', '', ''),
(4415, 11, 2, 1, 'Anthem', '', 'anthem', '', ''),
(4416, 35, 5, 1, 'Commerce Township', '', 'commerce-township', '', ''),
(4417, 13, 9, 1, 'Medfield', '', 'medfield', '', ''),
(4418, 8, 7, 1, 'Stone Ridge', '', 'stone-ridge', '', ''),
(4419, 7, 7, 1, 'Bogota', '', 'bogota', '', ''),
(4420, 7, 7, 1, 'Bordentown', '', 'bordentown', '', ''),
(4421, 8, 7, 1, 'Briarcliff Manor', '', 'briarcliff-manor', '', ''),
(4422, 10, 1, 1, 'Pismo Beach', '', 'pismo-beach', '', ''),
(4423, 30, 5, 1, 'Beachwood', '', 'beachwood', '', ''),
(4424, 20, 8, 1, 'Winter Springs', '', 'winter-springs', '', ''),
(4425, 7, 7, 1, 'Totowa', '', 'totowa', '', ''),
(4426, 8, 7, 1, 'Rocky Point', '', 'rocky-point', '', ''),
(4427, 30, 5, 1, 'Fairlawn', '', 'fairlawn', '', ''),
(4428, 8, 7, 1, 'Fairport', '', 'fairport', '', ''),
(4429, 17, 3, 1, 'Minnetonka', '', 'minnetonka', '', ''),
(4430, 22, 8, 1, 'Pineville', '', 'pineville', '', ''),
(4431, 30, 5, 1, 'Stow', '', 'stow', '', ''),
(4432, 35, 5, 1, 'Grosse Pointe', '', 'grosse-pointe', '', ''),
(4433, 36, 5, 1, 'Oconomowoc', '', 'oconomowoc', '', ''),
(4434, 30, 5, 1, 'Solon', '', 'solon', '', ''),
(4435, 10, 1, 1, 'Coronado', '', 'coronado', '', ''),
(4436, 22, 8, 1, 'Cornelius', '', 'cornelius', '', ''),
(4437, 17, 3, 1, 'Wayzata', '', 'wayzata', '', ''),
(4438, 10, 1, 1, 'Del Mar', '', 'del-mar', '', ''),
(4439, 8, 7, 1, 'Cornwall', '', 'cornwall', '', ''),
(4440, 8, 7, 1, 'New Lebanon', '', 'new-lebanon', '', ''),
(4441, 43, 2, 1, 'Fort Morgan', '', 'fort-morgan', '', ''),
(4442, 7, 7, 1, 'Ringwood', '', 'ringwood', '', ''),
(4443, 7, 7, 1, 'Old Tappan', '', 'old-tappan', '', ''),
(4444, 10, 1, 1, 'Empire', '', 'empire', '', ''),
(4445, 8, 7, 1, 'Port Jervis', '', 'port-jervis', '', ''),
(4446, 31, 7, 1, 'Squirrel Hill', '', 'squirrel-hill', '', ''),
(4447, 21, 8, 1, 'Oakton', '', 'oakton', '', ''),
(4448, 8, 7, 1, 'Eastchester', '', 'eastchester', '', ''),
(4449, 7, 7, 1, 'Stanhope', '', 'stanhope', '', ''),
(4450, 15, 8, 1, 'Hunt Valley', '', 'hunt-valley', '', ''),
(4451, 10, 1, 1, 'Madera', '', 'madera', '', ''),
(4452, 7, 7, 1, 'Swedesboro', '', 'swedesboro', '', ''),
(4453, 8, 7, 1, 'Congers', '', 'congers', '', ''),
(4454, 7, 7, 1, 'Port Reading', '', 'port-reading', '', ''),
(4455, 10, 1, 1, 'Kerman', '', 'kerman', '', ''),
(4456, 15, 8, 1, 'Owings Mills', '', 'owings-mills', '', ''),
(4457, 8, 7, 1, 'Baldwin', '', 'baldwin', '', ''),
(4458, 44, 4, 1, 'Slidell', '', 'slidell', '', ''),
(4459, 25, 10, 1, 'Koloa', '', 'koloa', '', ''),
(4460, 8, 7, 1, 'Valley Cottage', '', 'valley-cottage', '', ''),
(4461, 8, 7, 1, 'Montauk', '', 'montauk', '', ''),
(4462, 7, 7, 1, 'Dunellen', '', 'dunellen', '', ''),
(4463, 31, 7, 1, 'Marshalls Creek', '', 'marshalls-creek', '', ''),
(4464, 38, 9, 1, 'Swanton', '', 'swanton', '', ''),
(4465, 15, 8, 1, 'Windsor Mill', '', 'windsor-mill', '', ''),
(4466, 8, 7, 1, 'East Islip', '', 'east-islip', '', ''),
(4467, 8, 7, 1, 'Eastport', '', 'eastport', '', ''),
(4468, 42, 5, 1, 'Lake In The Hills', '', 'lake-in-the-hills', '', ''),
(4469, 42, 5, 1, 'Rolling Mdws', '', 'rolling-mdws', '', ''),
(4470, 35, 5, 1, 'Berkley', '', 'berkley', '', ''),
(4471, 35, 5, 1, 'Grosse Pointe Woods', '', 'grosse-pointe-woods', '', ''),
(4472, 20, 8, 1, 'South Miami', '', 'south-miami', '', ''),
(4473, 20, 8, 1, 'Lake Mary', '', 'lake-mary', '', ''),
(4474, 7, 7, 1, 'Belmar', '', 'belmar', '', ''),
(4475, 24, 2, 1, 'Salt Lake Cty', '', 'salt-lake-cty', '', ''),
(4476, 13, 9, 1, 'Dorchester', '', 'dorchester', '', ''),
(4477, 36, 5, 1, 'Delavan', '', 'delavan', '', ''),
(4478, 20, 8, 1, 'Marco Island', '', 'marco-island', '', ''),
(4479, 8, 7, 1, 'Fallsburg', '', 'fallsburg', '', ''),
(4480, 7, 7, 1, 'Fanwood', '', 'fanwood', '', ''),
(4481, 41, 9, 1, 'East Lyme', '', 'east-lyme', '', ''),
(4482, 42, 5, 1, 'Rock Falls', '', 'rock-falls', '', ''),
(4483, 8, 7, 1, 'Pine Bush', '', 'pine-bush', '', ''),
(4484, 7, 7, 1, 'Hazlet', '', 'hazlet', '', ''),
(4485, 7, 7, 1, 'Port Monmouth', '', 'port-monmouth', '', ''),
(4486, 7, 7, 1, 'Keansburg', '', 'keansburg', '', ''),
(4487, 12, 1, 1, 'Beaux Arts', '', 'beaux-arts', '', ''),
(4488, 8, 7, 1, 'Washingtonville', '', 'washingtonville', '', ''),
(4489, 42, 5, 1, 'Hickory Hills', '', 'hickory-hills', '', ''),
(4490, 42, 5, 1, 'Hometown', '', 'hometown', '', ''),
(4491, 8, 7, 1, 'Hampton Bays', '', 'hampton-bays', '', ''),
(4492, 7, 7, 1, 'Leonardo', '', 'leonardo', '', ''),
(4493, 13, 9, 1, 'East Taunton', '', 'east-taunton', '', ''),
(4494, 15, 8, 1, 'Perry Hall', '', 'perry-hall', '', ''),
(4495, 7, 7, 1, 'Margate City', '', 'margate-city', '', ''),
(4496, 7, 7, 1, 'South Orange', '', 'south-orange', '', ''),
(4497, 7, 7, 1, 'Lake Hiawatha', '', 'lake-hiawatha', '', ''),
(4498, 8, 7, 1, 'Altamont', '', 'altamont', '', ''),
(4499, 8, 7, 1, 'Amityville', '', 'amityville', '', ''),
(4500, 7, 7, 1, 'Ledgewood', '', 'ledgewood', '', ''),
(4501, 8, 7, 1, 'Sloatsburg', '', 'sloatsburg', '', ''),
(4502, 8, 7, 1, 'Garnerville', '', 'garnerville', '', ''),
(4503, 7, 7, 1, 'Pompton Plains', '', 'pompton-plains', '', ''),
(4504, 42, 5, 1, 'Mundelein', '', 'mundelein', '', ''),
(4505, 7, 7, 1, 'Willingboro', '', 'willingboro', '', ''),
(4506, 9, 4, 1, 'Mt Pleasant', '', 'mt-pleasant', '', ''),
(4507, 7, 7, 1, 'Fords', '', 'fords', '', ''),
(4508, 22, 8, 1, 'Corolla', '', 'corolla', '', ''),
(4509, 22, 8, 1, 'Kill Devil Hills', '', 'kill-devil-hills', '', ''),
(4510, 7, 7, 1, 'Lincoln Park', '', 'lincoln-park', '', ''),
(4511, 13, 9, 1, 'Upton', '', 'upton', '', ''),
(4512, 7, 7, 1, 'Vernon', '', 'vernon', '', ''),
(4513, 60, 2, 1, 'Gillette', '', 'gillette', '', ''),
(4514, 31, 7, 1, 'Dickson City', '', 'dickson-city', '', ''),
(4515, 8, 7, 1, 'Malverne', '', 'malverne', '', ''),
(4516, 7, 7, 1, 'Haddon Township', '', 'haddon-township', '', ''),
(4517, 31, 7, 1, 'Flourtown', '', 'flourtown', '', ''),
(4518, 8, 7, 1, 'Mastic Beach', '', 'mastic-beach', '', ''),
(4519, 31, 7, 1, 'Havertown', '', 'havertown', '', ''),
(4520, 31, 7, 1, 'Clarks Summit', '', 'clarks-summit', '', ''),
(4521, 7, 7, 1, 'Bellmawr', '', 'bellmawr', '', ''),
(4522, 22, 8, 1, 'Kitty Hawk', '', 'kitty-hawk', '', ''),
(4523, 20, 8, 1, 'Hobe Sound', '', 'hobe-sound', '', ''),
(4524, 56, 2, 1, 'Buhl', '', 'buhl', '', ''),
(4525, 22, 8, 1, 'Sneads Ferry', '', 'sneads-ferry', '', ''),
(4526, 8, 7, 1, 'Mongaup Valley', '', 'mongaup-valley', '', ''),
(4527, 8, 7, 1, 'Hunter', '', 'hunter', '', ''),
(4528, 8, 7, 1, 'North Babylon', '', 'north-babylon', '', ''),
(4529, 12, 1, 1, 'Spanaway', '', 'spanaway', '', ''),
(4530, 51, 2, 1, 'Incline Village', '', 'incline-village', '', ''),
(4531, 21, 8, 1, 'Waynesboro', '', 'waynesboro', '', ''),
(4532, 14, 8, 1, 'Statesboro', '', 'statesboro', '', ''),
(4533, 10, 1, 1, 'Oregon House', '', 'oregon-house', '', ''),
(4534, 26, 1, 1, 'Depoe Bay', '', 'depoe-bay', '', ''),
(4535, 31, 7, 1, 'Warrington', '', 'warrington', '', ''),
(4536, 8, 7, 1, 'Middle Village', '', 'middle-village', '', ''),
(4537, 20, 8, 1, 'Bonita Springs', '', 'bonita-springs', '', ''),
(4538, 50, 3, 1, 'Hixson', '', 'hixson', '', ''),
(4539, 42, 5, 1, 'Orland Park', '', 'orland-park', '', ''),
(4540, 26, 1, 1, 'Wallowa', '', 'wallowa', '', ''),
(4541, 26, 1, 1, 'South Beach', '', 'south-beach', '', ''),
(4542, 36, 5, 1, 'Pepin', '', 'pepin', '', ''),
(4543, 7, 7, 1, 'Greendell', '', 'greendell', '', ''),
(4544, 47, 3, 1, 'Whiteman Air Force Base', '', 'whiteman-air-force-base', '', ''),
(4545, 31, 7, 1, 'Lahaska', '', 'lahaska', '', ''),
(4546, 56, 2, 1, 'Twin Falls', '', 'twin-falls', '', ''),
(4547, 8, 7, 1, 'Monsey', '', 'monsey', '', ''),
(4548, 10, 1, 1, 'Calif Hot Spg', '', 'calif-hot-spg', '', ''),
(4549, 24, 2, 1, 'Kamas', '', 'kamas', '', ''),
(4550, 25, 10, 1, 'Kualapuu', '', 'kualapuu', '', ''),
(4551, 25, 10, 1, 'Mililani', '', 'mililani', '', ''),
(4552, 12, 1, 1, 'Seabeck', '', 'seabeck', '', ''),
(4553, 47, 3, 1, 'St Louis', '', 'st-louis', '', ''),
(4554, 10, 1, 1, 'Lemoore', '', 'lemoore', '', ''),
(4555, 10, 1, 1, 'Forestville', '', 'forestville', '', ''),
(4556, 14, 8, 1, 'Lake Park', '', 'lake-park', '', ''),
(4557, 31, 7, 1, 'Prospect Park', '', 'prospect-park', '', ''),
(4558, 8, 7, 1, 'Honeoye', '', 'honeoye', '', ''),
(4559, 11, 2, 1, 'Goodyear', '', 'goodyear', '', ''),
(4560, 53, 2, 1, 'Babb', '', 'babb', '', ''),
(4561, 17, 3, 1, 'Coon Rapids', '', 'coon-rapids', '', ''),
(4562, 8, 7, 1, 'Honeoye Falls', '', 'honeoye-falls', '', ''),
(4563, 14, 8, 1, 'Hartwell', '', 'hartwell', '', ''),
(4564, 9, 4, 1, 'Forney', '', 'forney', '', ''),
(4565, 50, 3, 1, 'Norris', '', 'norris', '', ''),
(4566, 56, 2, 1, 'Mackay', '', 'mackay', '', ''),
(4567, 35, 5, 1, 'Prudenville', '', 'prudenville', '', ''),
(4568, 8, 7, 1, 'South Glens Falls', '', 'south-glens-falls', '', ''),
(4569, 22, 8, 1, 'Lake Lure', '', 'lake-lure', '', ''),
(4570, 30, 5, 1, 'Kinsman', '', 'kinsman', '', ''),
(4571, 22, 8, 1, 'Whiteville', '', 'whiteville', '', ''),
(4572, 10, 1, 1, 'Kings Beach', '', 'kings-beach', '', ''),
(4573, 20, 8, 1, 'Long Key', '', 'long-key', '', ''),
(4574, 7, 7, 1, 'North Branch', '', 'north-branch', '', ''),
(4575, 26, 1, 1, 'Hermiston', '', 'hermiston', '', ''),
(4576, 22, 8, 1, 'N Topsail Beach', '', 'n-topsail-beach', '', ''),
(4577, 42, 5, 1, 'Elk Grove Vlg', '', 'elk-grove-vlg', '', ''),
(4578, 22, 8, 1, 'Biscoe', '', 'biscoe', '', ''),
(4579, 50, 3, 1, 'Mount Juliet', '', 'mount-juliet', '', ''),
(4580, 10, 1, 1, 'Loomis', '', 'loomis', '', ''),
(4581, 19, 9, 1, 'Londonderry', '', 'londonderry', '', ''),
(4582, 21, 8, 1, 'Forest', '', 'forest', '', ''),
(4583, 10, 1, 1, 'La Crescenta', '', 'la-crescenta', '', ''),
(4584, 10, 1, 1, 'Menlo Park', '', 'menlo-park', '', ''),
(4585, 25, 10, 1, 'Pearl City', '', 'pearl-city', '', ''),
(4586, 20, 8, 1, 'Aventura', '', 'aventura', '', ''),
(4587, 10, 1, 1, 'West Los Angeles', '', 'west-los-angeles', '', ''),
(4588, 31, 7, 1, 'Aston', '', 'aston', '', ''),
(4589, 10, 1, 1, 'Willows', '', 'willows', '', ''),
(4590, 19, 9, 1, 'North Hampton', '', 'north-hampton', '', ''),
(4591, 7, 7, 1, 'Ridgefield Park', '', 'ridgefield-park', '', ''),
(4592, 20, 8, 1, 'Holmes Beach', '', 'holmes-beach', '', ''),
(4593, 31, 7, 1, 'Robinson', '', 'robinson', '', ''),
(4594, 42, 5, 1, 'Mt Prospect', '', 'mt-prospect', '', ''),
(4595, 24, 2, 1, 'St George', '', 'st-george', '', ''),
(4596, 10, 1, 1, 'Gardena', '', 'gardena', '', ''),
(4597, 37, 6, 1, 'Radcliff', '', 'radcliff', '', ''),
(4598, 13, 9, 1, 'East Watertown', '', 'east-watertown', '', ''),
(4599, 10, 1, 1, 'Half Moon Bay', '', 'half-moon-bay', '', ''),
(4600, 10, 1, 1, 'Montecito', '', 'montecito', '', ''),
(4601, 10, 1, 1, 'El Cerrito', '', 'el-cerrito', '', ''),
(4602, 8, 7, 1, 'Chestnut Ridge', '', 'chestnut-ridge', '', ''),
(4603, 61, 6, 1, 'Pearl', '', 'pearl', '', ''),
(4604, 13, 9, 1, 'East Boston', '', 'east-boston', '', ''),
(4605, 9, 4, 1, 'Mont Belvieu', '', 'mont-belvieu', '', ''),
(4606, 31, 7, 1, 'Glenmoore', '', 'glenmoore', '', ''),
(4607, 9, 4, 1, 'La Feria', '', 'la-feria', '', ''),
(4608, 12, 1, 1, 'Lake Stevens', '', 'lake-stevens', '', ''),
(4609, 48, 6, 1, 'Pine Hill', '', 'pine-hill', '', ''),
(4610, 13, 9, 1, 'Fairhaven', '', 'fairhaven', '', ''),
(4611, 39, 5, 1, 'Otwell', '', 'otwell', '', ''),
(4612, 33, 8, 1, 'Chapmanville', '', 'chapmanville', '', ''),
(4613, 31, 7, 1, 'Beaver Falls', '', 'beaver-falls', '', ''),
(4614, 58, 3, 1, 'Curtis', '', 'curtis', '', ''),
(4615, 13, 9, 1, 'Southborough', '', 'southborough', '', ''),
(4616, 31, 7, 1, 'Mount Aetna', '', 'mount-aetna', '', ''),
(4617, 33, 8, 1, 'Rainelle', '', 'rainelle', '', ''),
(4618, 20, 8, 1, 'Atlantis', '', 'atlantis', '', ''),
(4619, 7, 7, 1, 'Lake Hopatcong', '', 'lake-hopatcong', '', ''),
(4620, 28, 9, 1, 'East Providence', '', 'east-providence', '', ''),
(4621, 31, 7, 1, 'S Williamsport', '', 's-williamsport', '', ''),
(4622, 8, 7, 1, 'Blue Point', '', 'blue-point', '', ''),
(4623, 9, 4, 1, 'Rio Grande City', '', 'rio-grande-city', '', ''),
(4624, 21, 8, 1, 'Brookneal', '', 'brookneal', '', ''),
(4625, 8, 7, 1, 'Port Ewen', '', 'port-ewen', '', ''),
(4626, 33, 8, 1, 'Clarksburg', '', 'clarksburg', '', ''),
(4627, 42, 5, 1, 'Anna', '', 'anna', '', ''),
(4628, 33, 8, 1, 'Grantsville', '', 'grantsville', '', ''),
(4629, 41, 9, 1, 'Dayville', '', 'dayville', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(4630, 53, 2, 1, 'Red Lodge', '', 'red-lodge', '', ''),
(4631, 9, 4, 1, 'Castroville', '', 'castroville', '', ''),
(4632, 30, 5, 1, 'Willoughby Hills', '', 'willoughby-hills', '', ''),
(4633, 7, 7, 1, 'Pennsauken', '', 'pennsauken', '', ''),
(4634, 10, 1, 1, 'Portola Valley', '', 'portola-valley', '', ''),
(4635, 33, 8, 1, 'Mullens', '', 'mullens', '', ''),
(4636, 12, 1, 1, 'Bonney Lake', '', 'bonney-lake', '', ''),
(4637, 30, 5, 1, 'Hamersville', '', 'hamersville', '', ''),
(4638, 15, 8, 1, 'Walkersville', '', 'walkersville', '', ''),
(4639, 35, 5, 1, 'Chesterfield Township', '', 'chesterfield-township', '', ''),
(4640, 11, 2, 1, 'Tolleson', '', 'tolleson', '', ''),
(4641, 20, 8, 1, 'North Port', '', 'north-port', '', ''),
(4642, 20, 8, 1, 'Dania', '', 'dania', '', ''),
(4643, 15, 8, 1, 'Cheverly', '', 'cheverly', '', ''),
(4644, 10, 1, 1, 'Ben Lomond', '', 'ben-lomond', '', ''),
(4645, 43, 2, 1, 'Parachute', '', 'parachute', '', ''),
(4646, 14, 8, 1, 'Hephzibah', '', 'hephzibah', '', ''),
(4647, 20, 8, 1, 'Cocoa Beach', '', 'cocoa-beach', '', ''),
(4648, 22, 8, 1, 'Holly Springs', '', 'holly-springs', '', ''),
(4649, 42, 5, 1, 'Mc Leansboro', '', 'mc-leansboro', '', ''),
(4650, 39, 5, 1, 'Frankton', '', 'frankton', '', ''),
(4651, 36, 5, 1, 'Walworth', '', 'walworth', '', ''),
(4652, 47, 3, 1, 'Fredericktown', '', 'fredericktown', '', ''),
(4653, 39, 5, 1, 'Leo', '', 'leo', '', ''),
(4654, 14, 8, 1, 'Lithonia', '', 'lithonia', '', ''),
(4655, 13, 9, 1, 'Agawam', '', 'agawam', '', ''),
(4656, 20, 8, 1, 'Homosassa', '', 'homosassa', '', ''),
(4657, 31, 7, 1, 'Aliquippa', '', 'aliquippa', '', ''),
(4658, 13, 9, 1, 'Chicopee', '', 'chicopee', '', ''),
(4659, 30, 5, 1, 'Byesville', '', 'byesville', '', ''),
(4660, 31, 7, 1, 'Solebury', '', 'solebury', '', ''),
(4661, 22, 8, 1, 'Wadesboro', '', 'wadesboro', '', ''),
(4662, 25, 10, 1, 'Keaau', '', 'keaau', '', ''),
(4663, 25, 10, 1, 'Kula', '', 'kula', '', ''),
(4664, 30, 5, 1, 'Amanda', '', 'amanda', '', ''),
(4665, 31, 7, 1, 'Gladwyne', '', 'gladwyne', '', ''),
(4666, 31, 7, 1, 'Duncansville', '', 'duncansville', '', ''),
(4667, 13, 9, 1, 'East Freetown', '', 'east-freetown', '', ''),
(4668, 10, 1, 1, 'South San Francisco', '', 'south-san-francisco', '', ''),
(4669, 7, 7, 1, 'Iselin', '', 'iselin', '', ''),
(4670, 9, 4, 1, 'Devine', '', 'devine', '', ''),
(4671, 11, 2, 1, 'Litchfield Park', '', 'litchfield-park', '', ''),
(4672, 30, 5, 1, 'Piketon', '', 'piketon', '', ''),
(4673, 44, 4, 1, 'Bogalusa', '', 'bogalusa', '', ''),
(4674, 8, 7, 1, 'South Ozone Park', '', 'south-ozone-park', '', ''),
(4675, 13, 9, 1, 'West Newton', '', 'west-newton', '', ''),
(4676, 33, 8, 1, 'Weirton', '', 'weirton', '', ''),
(4677, 22, 8, 1, 'Yadkinville', '', 'yadkinville', '', ''),
(4678, 7, 7, 1, 'Avenel', '', 'avenel', '', ''),
(4679, 7, 7, 1, 'Oceanport', '', 'oceanport', '', ''),
(4680, 7, 7, 1, 'Cape May C H', '', 'cape-may-c-h', '', ''),
(4681, 13, 9, 1, 'North Brookfield', '', 'north-brookfield', '', ''),
(4682, 21, 8, 1, 'Christiansbrg', '', 'christiansbrg', '', ''),
(4683, 31, 7, 1, 'Washington Crossing', '', 'washington-crossing', '', ''),
(4684, 8, 7, 1, 'Lake Ronkonkoma', '', 'lake-ronkonkoma', '', ''),
(4685, 13, 9, 1, 'Hanson', '', 'hanson', '', ''),
(4686, 20, 8, 1, 'Ft Lauderdale', '', 'ft-lauderdale', '', ''),
(4687, 31, 7, 1, 'White Oak', '', 'white-oak', '', ''),
(4688, 8, 7, 1, 'Oyster Bay', '', 'oyster-bay', '', ''),
(4689, 9, 4, 1, 'Goldthwaite', '', 'goldthwaite', '', ''),
(4690, 7, 7, 1, 'Wrightstown', '', 'wrightstown', '', ''),
(4691, 21, 8, 1, 'Dumfries', '', 'dumfries', '', ''),
(4692, 31, 7, 1, 'Collingdale', '', 'collingdale', '', ''),
(4693, 31, 7, 1, 'Limerick', '', 'limerick', '', ''),
(4694, 25, 10, 1, 'Pahoa', '', 'pahoa', '', ''),
(4695, 31, 7, 1, 'Wyomissing', '', 'wyomissing', '', ''),
(4696, 10, 1, 1, 'Thermal', '', 'thermal', '', ''),
(4697, 31, 7, 1, 'Lincoln Univ', '', 'lincoln-univ', '', ''),
(4698, 25, 10, 1, 'Lanai City', '', 'lanai-city', '', ''),
(4699, 25, 10, 1, 'Honokaa', '', 'honokaa', '', ''),
(4700, 9, 4, 1, 'Weslaco', '', 'weslaco', '', ''),
(4701, 10, 1, 1, 'Mission Hills', '', 'mission-hills', '', ''),
(4702, 31, 7, 1, 'Trevose', '', 'trevose', '', ''),
(4703, 16, 8, 1, 'Hockessin', '', 'hockessin', '', ''),
(4704, 20, 8, 1, 'Sun City Center', '', 'sun-city-center', '', ''),
(4705, 28, 9, 1, 'Slatersville', '', 'slatersville', '', ''),
(4706, 7, 7, 1, 'Haddon Heights', '', 'haddon-heights', '', ''),
(4707, 36, 5, 1, 'Campbellsport', '', 'campbellsport', '', ''),
(4708, 20, 8, 1, 'St Augustine', '', 'st-augustine', '', ''),
(4709, 15, 8, 1, 'Severn', '', 'severn', '', ''),
(4710, 7, 7, 1, 'Dorothy', '', 'dorothy', '', ''),
(4711, 13, 9, 1, 'North Grafton', '', 'north-grafton', '', ''),
(4712, 15, 8, 1, 'Smithsburg', '', 'smithsburg', '', ''),
(4713, 56, 2, 1, 'Dalton Gardens', '', 'dalton-gardens', '', ''),
(4714, 30, 5, 1, 'Seaman', '', 'seaman', '', ''),
(4715, 20, 8, 1, 'Lake Alfred', '', 'lake-alfred', '', ''),
(4716, 31, 7, 1, 'Charleroi', '', 'charleroi', '', ''),
(4717, 8, 7, 1, 'Endwell', '', 'endwell', '', ''),
(4718, 23, 9, 1, 'Machias', '', 'machias', '', ''),
(4719, 7, 7, 1, 'Northvale', '', 'northvale', '', ''),
(4720, 17, 3, 1, 'Fertile', '', 'fertile', '', ''),
(4721, 30, 5, 1, 'Laurelville', '', 'laurelville', '', ''),
(4722, 8, 7, 1, 'Claverack', '', 'claverack', '', ''),
(4723, 15, 8, 1, 'McDaniel', '', 'mcdaniel', '', ''),
(4724, 10, 1, 1, 'Signal Hill', '', 'signal-hill', '', ''),
(4725, 28, 9, 1, 'Rumford', '', 'rumford', '', ''),
(4726, 30, 5, 1, 'Berlin Heights', '', 'berlin-heights', '', ''),
(4727, 25, 10, 1, 'Holualoa', '', 'holualoa', '', ''),
(4728, 7, 7, 1, 'West Windsor', '', 'west-windsor', '', ''),
(4729, 8, 7, 1, 'Lackawanna', '', 'lackawanna', '', ''),
(4730, 7, 7, 1, 'Lake Como', '', 'lake-como', '', ''),
(4731, 13, 9, 1, 'East Longmeadow', '', 'east-longmeadow', '', ''),
(4732, 7, 7, 1, 'West Trenton', '', 'west-trenton', '', ''),
(4733, 20, 8, 1, 'Seffner', '', 'seffner', '', ''),
(4734, 32, 4, 1, 'Inola', '', 'inola', '', ''),
(4735, 36, 5, 1, 'Rewey', '', 'rewey', '', ''),
(4736, 10, 1, 1, 'Templeton', '', 'templeton', '', ''),
(4737, 42, 5, 1, 'Hoffman Estates', '', 'hoffman-estates', '', ''),
(4738, 8, 7, 1, 'La Fayette', '', 'la-fayette', '', ''),
(4739, 31, 7, 1, 'Coplay', '', 'coplay', '', ''),
(4740, 47, 3, 1, 'Grover', '', 'grover', '', ''),
(4741, 33, 8, 1, 'Keyser', '', 'keyser', '', ''),
(4742, 13, 9, 1, 'Rowley', '', 'rowley', '', ''),
(4743, 20, 8, 1, 'Crystal Springs', '', 'crystal-springs', '', ''),
(4744, 7, 7, 1, 'Blackwood', '', 'blackwood', '', ''),
(4745, 9, 4, 1, 'Ferris', '', 'ferris', '', ''),
(4746, 44, 4, 1, 'Chalmette', '', 'chalmette', '', ''),
(4747, 44, 4, 1, 'La Place', '', 'la-place', '', ''),
(4748, 27, 8, 1, 'Mauldin', '', 'mauldin', '', ''),
(4749, 10, 1, 1, 'Rancho Santa Margarita', '', 'rancho-santa-margarita', '', ''),
(4750, 27, 8, 1, 'Bluffton', '', 'bluffton', '', ''),
(4751, 7, 7, 1, 'Glen Ridge', '', 'glen-ridge', '', ''),
(4752, 36, 5, 1, 'Minocqua', '', 'minocqua', '', ''),
(4753, 10, 1, 1, 'Milpitas', '', 'milpitas', '', ''),
(4754, 13, 9, 1, 'Scituate', '', 'scituate', '', ''),
(4755, 42, 5, 1, 'Monroe Center', '', 'monroe-center', '', ''),
(4756, 50, 3, 1, 'Rossville', '', 'rossville', '', ''),
(4757, 31, 7, 1, 'Holmes', '', 'holmes', '', ''),
(4758, 17, 3, 1, 'Brooklyn Park', '', 'brooklyn-park', '', ''),
(4759, 8, 7, 1, 'Queens Village', '', 'queens-village', '', ''),
(4760, 8, 7, 1, 'Weedsport', '', 'weedsport', '', ''),
(4761, 8, 7, 1, 'Chappaqua', '', 'chappaqua', '', ''),
(4762, 8, 7, 1, 'Glenmont', '', 'glenmont', '', ''),
(4763, 7, 7, 1, 'Woodstown', '', 'woodstown', '', ''),
(4764, 50, 3, 1, 'Harriman', '', 'harriman', '', ''),
(4765, 7, 7, 1, 'Wharton', '', 'wharton', '', ''),
(4766, 41, 9, 1, 'Old Saybrook', '', 'old-saybrook', '', ''),
(4767, 61, 6, 1, 'Byhalia', '', 'byhalia', '', ''),
(4768, 10, 1, 1, 'Altadena', '', 'altadena', '', ''),
(4769, 9, 4, 1, 'Wills Point', '', 'wills-point', '', ''),
(4770, 9, 4, 1, 'Abernathy', '', 'abernathy', '', ''),
(4771, 43, 2, 1, 'Snowmass Village', '', 'snowmass-village', '', ''),
(4772, 9, 4, 1, 'Pottsboro', '', 'pottsboro', '', ''),
(4773, 41, 9, 1, 'Ansonia', '', 'ansonia', '', ''),
(4774, 8, 7, 1, 'Lake Katrine', '', 'lake-katrine', '', ''),
(4775, 37, 6, 1, 'Martin', '', 'martin', '', ''),
(4776, 15, 8, 1, 'Mountain Lake Park', '', 'mountain-lake-park', '', ''),
(4777, 35, 5, 1, 'Munith', '', 'munith', '', ''),
(4778, 21, 8, 1, 'Broadway', '', 'broadway', '', ''),
(4779, 14, 8, 1, 'Blairsville', '', 'blairsville', '', ''),
(4780, 34, 1, 1, 'Delta Junction', '', 'delta-junction', '', ''),
(4781, 48, 6, 1, 'Albertville', '', 'albertville', '', ''),
(4782, 42, 5, 1, 'East Peoria', '', 'east-peoria', '', ''),
(4783, 43, 2, 1, 'Palisade', '', 'palisade', '', ''),
(4784, 50, 3, 1, 'Soddy Daisy', '', 'soddy-daisy', '', ''),
(4785, 36, 5, 1, 'Lyndon Station', '', 'lyndon-station', '', ''),
(4786, 22, 8, 1, 'Mount Airy', '', 'mount-airy', '', ''),
(4787, 31, 7, 1, 'Fleetwood', '', 'fleetwood', '', ''),
(4788, 35, 5, 1, 'Caledonia', '', 'caledonia', '', ''),
(4789, 48, 6, 1, 'Piedmont', '', 'piedmont', '', ''),
(4790, 14, 8, 1, 'Jesup', '', 'jesup', '', ''),
(4791, 42, 5, 1, 'Sycamore', '', 'sycamore', '', ''),
(4792, 42, 5, 1, 'Grant Park', '', 'grant-park', '', ''),
(4793, 7, 7, 1, 'Carteret', '', 'carteret', '', ''),
(4794, 41, 9, 1, 'Wallingford', '', 'wallingford', '', ''),
(4795, 31, 7, 1, 'Elkins Park', '', 'elkins-park', '', ''),
(4796, 44, 4, 1, 'West Monroe', '', 'west-monroe', '', ''),
(4797, 14, 8, 1, 'Baxley', '', 'baxley', '', ''),
(4798, 52, 4, 1, 'Searcy', '', 'searcy', '', ''),
(4799, 17, 3, 1, 'Mahtomedi', '', 'mahtomedi', '', ''),
(4800, 39, 5, 1, 'Worthington', '', 'worthington', '', ''),
(4801, 20, 8, 1, 'Lady Lake', '', 'lady-lake', '', ''),
(4802, 35, 5, 1, 'Pinckney', '', 'pinckney', '', ''),
(4803, 16, 8, 1, 'Millsboro', '', 'millsboro', '', ''),
(4804, 31, 7, 1, 'South Waverly', '', 'south-waverly', '', ''),
(4805, 12, 1, 1, 'Grayland', '', 'grayland', '', ''),
(4806, 61, 6, 1, 'Waveland', '', 'waveland', '', ''),
(4807, 48, 6, 1, 'Boaz', '', 'boaz', '', ''),
(4808, 8, 7, 1, 'Baychester', '', 'baychester', '', ''),
(4809, 9, 4, 1, 'Buda', '', 'buda', '', ''),
(4810, 14, 8, 1, 'Winder', '', 'winder', '', ''),
(4811, 7, 7, 1, 'Roebling', '', 'roebling', '', ''),
(4812, 44, 4, 1, 'Eunice', '', 'eunice', '', ''),
(4813, 25, 10, 1, 'Waialua', '', 'waialua', '', ''),
(4814, 47, 3, 1, 'Lake Saint Louis', '', 'lake-saint-louis', '', ''),
(4815, 37, 6, 1, 'Mayfield', '', 'mayfield', '', ''),
(4816, 22, 8, 1, 'Cashiers', '', 'cashiers', '', ''),
(4817, 20, 8, 1, 'Debary', '', 'debary', '', ''),
(4818, 20, 8, 1, 'Yulee', '', 'yulee', '', ''),
(4819, 8, 7, 1, 'Inwood', '', 'inwood', '', ''),
(4820, 11, 2, 1, 'Green Valley', '', 'green-valley', '', ''),
(4821, 19, 9, 1, 'Greenland', '', 'greenland', '', ''),
(4822, 39, 5, 1, 'Beech Grove', '', 'beech-grove', '', ''),
(4823, 32, 4, 1, 'Bixby', '', 'bixby', '', ''),
(4824, 43, 2, 1, 'Telluride', '', 'telluride', '', ''),
(4825, 35, 5, 1, 'Coleman', '', 'coleman', '', ''),
(4826, 23, 9, 1, 'Hollis Center', '', 'hollis-center', '', ''),
(4827, 7, 7, 1, 'Merchantville', '', 'merchantville', '', ''),
(4828, 33, 8, 1, 'Charles Town', '', 'charles-town', '', ''),
(4829, 42, 5, 1, 'Arthur', '', 'arthur', '', ''),
(4830, 31, 7, 1, 'Sharpsville', '', 'sharpsville', '', ''),
(4831, 42, 5, 1, 'Carpentersville', '', 'carpentersville', '', ''),
(4832, 50, 3, 1, 'South Pittsburg', '', 'south-pittsburg', '', ''),
(4833, 15, 8, 1, 'Darnestown', '', 'darnestown', '', ''),
(4834, 10, 1, 1, 'Glen Ellen', '', 'glen-ellen', '', ''),
(4835, 50, 3, 1, 'Collegedale', '', 'collegedale', '', ''),
(4836, 35, 5, 1, 'Acme', '', 'acme', '', ''),
(4837, 20, 8, 1, 'Mary Esther', '', 'mary-esther', '', ''),
(4838, 35, 5, 1, 'Saint Clair Shores', '', 'saint-clair-shores', '', ''),
(4839, 31, 7, 1, 'Leesport', '', 'leesport', '', ''),
(4840, 22, 8, 1, 'Youngsville', '', 'youngsville', '', ''),
(4841, 22, 8, 1, 'Trent Woods', '', 'trent-woods', '', ''),
(4842, 48, 6, 1, 'Brookwood', '', 'brookwood', '', ''),
(4843, 41, 9, 1, 'Bantam', '', 'bantam', '', ''),
(4844, 9, 4, 1, 'Whitehouse', '', 'whitehouse', '', ''),
(4845, 31, 7, 1, 'Lehighton', '', 'lehighton', '', ''),
(4846, 7, 7, 1, 'Turnersville', '', 'turnersville', '', ''),
(4847, 22, 8, 1, 'Nags Head', '', 'nags-head', '', ''),
(4848, 37, 6, 1, 'Glasgow', '', 'glasgow', '', ''),
(4849, 17, 3, 1, 'Thief River Falls', '', 'thief-river-falls', '', ''),
(4850, 8, 7, 1, 'Valatie', '', 'valatie', '', ''),
(4851, 42, 5, 1, 'Aledo', '', 'aledo', '', ''),
(4852, 59, 3, 1, 'Wahpeton', '', 'wahpeton', '', ''),
(4853, 7, 7, 1, 'Towaco', '', 'towaco', '', ''),
(4854, 26, 1, 1, 'Cave Junction', '', 'cave-junction', '', ''),
(4855, 48, 6, 1, 'Sumiton', '', 'sumiton', '', ''),
(4856, 10, 1, 1, 'Orangevale', '', 'orangevale', '', ''),
(4857, 20, 8, 1, 'Ponte Vedra Beach', '', 'ponte-vedra-beach', '', ''),
(4858, 10, 1, 1, 'Hidden Valley Lake', '', 'hidden-valley-lake', '', ''),
(4859, 31, 7, 1, 'Walnutport', '', 'walnutport', '', ''),
(4860, 43, 2, 1, 'Mead', '', 'mead', '', ''),
(4861, 52, 4, 1, 'Hackett', '', 'hackett', '', ''),
(4862, 31, 7, 1, 'Selinsgrove', '', 'selinsgrove', '', ''),
(4863, 13, 9, 1, 'Roslindale', '', 'roslindale', '', ''),
(4864, 13, 9, 1, 'Wilbraham', '', 'wilbraham', '', ''),
(4865, 15, 8, 1, 'Conowingo', '', 'conowingo', '', ''),
(4866, 37, 6, 1, 'Bardstown', '', 'bardstown', '', ''),
(4867, 43, 2, 1, 'Minturn', '', 'minturn', '', ''),
(4868, 51, 2, 1, 'Washoe Valley', '', 'washoe-valley', '', ''),
(4869, 15, 8, 1, 'Maugansville', '', 'maugansville', '', ''),
(4870, 9, 4, 1, 'Pantego', '', 'pantego', '', ''),
(4871, 42, 5, 1, 'Lake Villa', '', 'lake-villa', '', ''),
(4872, 20, 8, 1, 'Navarre', '', 'navarre', '', ''),
(4873, 31, 7, 1, 'Bairdford', '', 'bairdford', '', ''),
(4874, 35, 5, 1, 'River Rouge', '', 'river-rouge', '', ''),
(4875, 15, 8, 1, 'Thurmont', '', 'thurmont', '', ''),
(4876, 10, 1, 1, 'Grand Terrace', '', 'grand-terrace', '', ''),
(4877, 31, 7, 1, 'Brodheadsville', '', 'brodheadsville', '', ''),
(4878, 31, 7, 1, 'Bridgeville', '', 'bridgeville', '', ''),
(4879, 35, 5, 1, 'Comstock Park', '', 'comstock-park', '', ''),
(4880, 22, 8, 1, 'Gibsonville', '', 'gibsonville', '', ''),
(4881, 8, 7, 1, 'Coram', '', 'coram', '', ''),
(4882, 10, 1, 1, 'La Canada Flintridge', '', 'la-canada-flintridge', '', ''),
(4883, 31, 7, 1, 'Huntingdon Valley', '', 'huntingdon-valley', '', ''),
(4884, 15, 8, 1, 'Laytonsville', '', 'laytonsville', '', ''),
(4885, 15, 8, 1, 'Lanham', '', 'lanham', '', ''),
(4886, 42, 5, 1, 'Loves Park', '', 'loves-park', '', ''),
(4887, 8, 7, 1, 'Old Westbury', '', 'old-westbury', '', ''),
(4888, 32, 4, 1, 'Warr Acres', '', 'warr-acres', '', ''),
(4889, 42, 5, 1, 'East Dundee', '', 'east-dundee', '', ''),
(4890, 9, 4, 1, 'Gordonville', '', 'gordonville', '', ''),
(4891, 30, 5, 1, 'Delaware', '', 'delaware', '', ''),
(4892, 14, 8, 1, 'Cataula', '', 'cataula', '', ''),
(4893, 15, 8, 1, 'Huntingtown', '', 'huntingtown', '', ''),
(4894, 21, 8, 1, 'Keswick', '', 'keswick', '', ''),
(4895, 35, 5, 1, 'Dewitt', '', 'dewitt', '', ''),
(4896, 47, 3, 1, 'New Melle', '', 'new-melle', '', ''),
(4897, 42, 5, 1, 'Stillman Valley', '', 'stillman-valley', '', ''),
(4898, 41, 9, 1, 'Naugatuck', '', 'naugatuck', '', ''),
(4899, 48, 6, 1, 'Orange Beach', '', 'orange-beach', '', ''),
(4900, 20, 8, 1, 'Indian Shores', '', 'indian-shores', '', ''),
(4901, 9, 4, 1, 'New Boston', '', 'new-boston', '', ''),
(4902, 15, 8, 1, 'North East', '', 'north-east', '', ''),
(4903, 48, 6, 1, 'Atmore', '', 'atmore', '', ''),
(4904, 10, 1, 1, 'Lathrop', '', 'lathrop', '', ''),
(4905, 45, 2, 1, 'Red River', '', 'red-river', '', ''),
(4906, 7, 7, 1, 'Union Beach', '', 'union-beach', '', ''),
(4907, 10, 1, 1, 'Mount Shasta', '', 'mount-shasta', '', ''),
(4908, 36, 5, 1, 'Adell', '', 'adell', '', ''),
(4909, 42, 5, 1, 'Lakemoor', '', 'lakemoor', '', ''),
(4910, 36, 5, 1, 'Little Chute', '', 'little-chute', '', ''),
(4911, 20, 8, 1, 'Key Largo', '', 'key-largo', '', ''),
(4912, 41, 9, 1, 'East Haven', '', 'east-haven', '', ''),
(4913, 10, 1, 1, 'Denair', '', 'denair', '', ''),
(4914, 41, 9, 1, 'Centerbrook', '', 'centerbrook', '', ''),
(4915, 44, 4, 1, 'Addis', '', 'addis', '', ''),
(4916, 10, 1, 1, 'Winterhaven', '', 'winterhaven', '', ''),
(4917, 37, 6, 1, 'Fort Mitchell', '', 'fort-mitchell', '', ''),
(4918, 50, 3, 1, 'Elizabethton', '', 'elizabethton', '', ''),
(4919, 26, 1, 1, 'Joseph', '', 'joseph', '', ''),
(4920, 14, 8, 1, 'Sylvester', '', 'sylvester', '', ''),
(4921, 52, 4, 1, 'Cabot', '', 'cabot', '', ''),
(4922, 31, 7, 1, 'Hollidaysburg', '', 'hollidaysburg', '', ''),
(4923, 22, 8, 1, 'Horse Shoe', '', 'horse-shoe', '', ''),
(4924, 19, 9, 1, 'Hampton Falls', '', 'hampton-falls', '', ''),
(4925, 9, 4, 1, 'Robstown', '', 'robstown', '', ''),
(4926, 31, 7, 1, 'Apollo', '', 'apollo', '', ''),
(4927, 8, 7, 1, 'Hermon', '', 'hermon', '', ''),
(4928, 36, 5, 1, 'Gilman', '', 'gilman', '', ''),
(4929, 15, 8, 1, 'Upperco', '', 'upperco', '', ''),
(4930, 45, 2, 1, 'Placitas', '', 'placitas', '', ''),
(4931, 23, 9, 1, 'Orrs Island', '', 'orrs-island', '', ''),
(4932, 14, 8, 1, 'Blackshear', '', 'blackshear', '', ''),
(4933, 31, 7, 1, 'Etna', '', 'etna', '', ''),
(4934, 14, 8, 1, 'Quitman', '', 'quitman', '', ''),
(4935, 32, 4, 1, 'Blanchard', '', 'blanchard', '', ''),
(4936, 20, 8, 1, 'Babson Park', '', 'babson-park', '', ''),
(4937, 9, 4, 1, 'Eastland', '', 'eastland', '', ''),
(4938, 9, 4, 1, 'Converse', '', 'converse', '', ''),
(4939, 30, 5, 1, 'South Point', '', 'south-point', '', ''),
(4940, 14, 8, 1, 'Wadley', '', 'wadley', '', ''),
(4941, 30, 5, 1, 'Twinsburg', '', 'twinsburg', '', ''),
(4942, 56, 2, 1, 'Shelley', '', 'shelley', '', ''),
(4943, 38, 9, 1, 'Fairlee', '', 'fairlee', '', ''),
(4944, 20, 8, 1, 'N Ft Myers', '', 'n-ft-myers', '', ''),
(4945, 31, 7, 1, 'Mcadoo', '', 'mcadoo', '', ''),
(4946, 50, 3, 1, 'Five Points', '', 'five-points', '', ''),
(4947, 21, 8, 1, 'Melfa', '', 'melfa', '', ''),
(4948, 39, 5, 1, 'Zionsville', '', 'zionsville', '', ''),
(4949, 9, 4, 1, 'Cedar Park', '', 'cedar-park', '', ''),
(4950, 52, 4, 1, 'Mena', '', 'mena', '', ''),
(4951, 21, 8, 1, 'Shipman', '', 'shipman', '', ''),
(4952, 37, 6, 1, 'Rineyville', '', 'rineyville', '', ''),
(4953, 8, 7, 1, 'Pleasant Valley', '', 'pleasant-valley', '', ''),
(4954, 31, 7, 1, 'Pen Argyl', '', 'pen-argyl', '', ''),
(4955, 31, 7, 1, 'Frackville', '', 'frackville', '', ''),
(4956, 14, 8, 1, 'Hiawassee', '', 'hiawassee', '', ''),
(4957, 13, 9, 1, 'Bolton', '', 'bolton', '', ''),
(4958, 20, 8, 1, 'Miami Springs', '', 'miami-springs', '', ''),
(4959, 9, 4, 1, 'Schertz', '', 'schertz', '', ''),
(4960, 10, 1, 1, 'Perris', '', 'perris', '', ''),
(4961, 36, 5, 1, 'Sturtevant', '', 'sturtevant', '', ''),
(4962, 13, 9, 1, 'Lynnfield', '', 'lynnfield', '', ''),
(4963, 30, 5, 1, 'North Royalton', '', 'north-royalton', '', ''),
(4964, 48, 6, 1, 'Lillian', '', 'lillian', '', ''),
(4965, 50, 3, 1, 'Cordova', '', 'cordova', '', ''),
(4966, 21, 8, 1, 'Beaverdam', '', 'beaverdam', '', ''),
(4967, 31, 7, 1, 'Mc Keesport', '', 'mc-keesport', '', ''),
(4968, 30, 5, 1, 'Jewett', '', 'jewett', '', ''),
(4969, 24, 2, 1, 'Brian Head', '', 'brian-head', '', ''),
(4970, 13, 9, 1, 'Billerica', '', 'billerica', '', ''),
(4971, 31, 7, 1, 'Venetia', '', 'venetia', '', ''),
(4972, 10, 1, 1, 'San Marino', '', 'san-marino', '', ''),
(4973, 14, 8, 1, 'Brooklet', '', 'brooklet', '', ''),
(4974, 23, 9, 1, 'East Waterboro', '', 'east-waterboro', '', ''),
(4975, 31, 7, 1, 'Loganville', '', 'loganville', '', ''),
(4976, 36, 5, 1, 'Clintonville', '', 'clintonville', '', ''),
(4977, 8, 7, 1, 'Sea Cliff', '', 'sea-cliff', '', ''),
(4978, 31, 7, 1, 'East Pittsburgh', '', 'east-pittsburgh', '', ''),
(4979, 30, 5, 1, 'Millersburg', '', 'millersburg', '', ''),
(4980, 31, 7, 1, 'Braddock', '', 'braddock', '', ''),
(4981, 14, 8, 1, 'Adairsville', '', 'adairsville', '', ''),
(4982, 9, 4, 1, 'Stonewall', '', 'stonewall', '', ''),
(4983, 21, 8, 1, 'Burke', '', 'burke', '', ''),
(4984, 48, 6, 1, 'Loxley', '', 'loxley', '', ''),
(4985, 9, 4, 1, 'Hitchcock', '', 'hitchcock', '', ''),
(4986, 61, 6, 1, 'Southaven', '', 'southaven', '', ''),
(4987, 9, 4, 1, 'Glenn Heights', '', 'glenn-heights', '', ''),
(4988, 12, 1, 1, 'Omak', '', 'omak', '', ''),
(4989, 20, 8, 1, 'Lehigh Acres', '', 'lehigh-acres', '', ''),
(4990, 7, 7, 1, 'Newfoundland', '', 'newfoundland', '', ''),
(4991, 20, 8, 1, 'Loxahatchee', '', 'loxahatchee', '', ''),
(4992, 44, 4, 1, 'Saint Martinville', '', 'saint-martinville', '', ''),
(4993, 44, 4, 1, 'Abbeville', '', 'abbeville', '', ''),
(4994, 44, 4, 1, 'Pierre Part', '', 'pierre-part', '', ''),
(4995, 31, 7, 1, 'Monaca', '', 'monaca', '', ''),
(4996, 20, 8, 1, 'Flagler Beach', '', 'flagler-beach', '', ''),
(4997, 36, 5, 1, 'Cedar Grove', '', 'cedar-grove', '', ''),
(4998, 10, 1, 1, 'Sanger', '', 'sanger', '', ''),
(4999, 21, 8, 1, 'Catlett', '', 'catlett', '', ''),
(5000, 10, 1, 1, 'Cambria', '', 'cambria', '', ''),
(5001, 9, 4, 1, 'Helotes', '', 'helotes', '', ''),
(5002, 30, 5, 1, 'Bellville', '', 'bellville', '', ''),
(5003, 24, 2, 1, 'West Valley City', '', 'west-valley-city', '', ''),
(5004, 37, 6, 1, 'Nicholasville', '', 'nicholasville', '', ''),
(5005, 35, 5, 1, 'Edwardsburg', '', 'edwardsburg', '', ''),
(5006, 45, 2, 1, 'Silver City', '', 'silver-city', '', ''),
(5007, 20, 8, 1, 'St Petersburg', '', 'st-petersburg', '', ''),
(5008, 20, 8, 1, 'Nokomis', '', 'nokomis', '', ''),
(5009, 12, 1, 1, 'Winlock', '', 'winlock', '', ''),
(5010, 7, 7, 1, 'Mahwah', '', 'mahwah', '', ''),
(5011, 52, 4, 1, 'North Little Rock', '', 'north-little-rock', '', ''),
(5012, 35, 5, 1, 'White Lake', '', 'white-lake', '', ''),
(5013, 36, 5, 1, 'Oostburg', '', 'oostburg', '', ''),
(5014, 30, 5, 1, 'Poland', '', 'poland', '', ''),
(5015, 13, 9, 1, 'Forestdale', '', 'forestdale', '', ''),
(5016, 20, 8, 1, 'Thonotosassa', '', 'thonotosassa', '', ''),
(5017, 30, 5, 1, 'Waynesville', '', 'waynesville', '', ''),
(5018, 22, 8, 1, 'Richlands', '', 'richlands', '', ''),
(5019, 14, 8, 1, 'Pooler', '', 'pooler', '', ''),
(5020, 48, 6, 1, 'Theodore', '', 'theodore', '', ''),
(5021, 58, 3, 1, 'South Sioux City', '', 'south-sioux-city', '', ''),
(5022, 31, 7, 1, 'Reynoldsville', '', 'reynoldsville', '', ''),
(5023, 30, 5, 1, 'Willard', '', 'willard', '', ''),
(5024, 48, 6, 1, 'Owens Cross Roads', '', 'owens-cross-roads', '', ''),
(5025, 53, 2, 1, 'Judith Gap', '', 'judith-gap', '', ''),
(5026, 28, 9, 1, 'Block Island', '', 'block-island', '', ''),
(5027, 15, 8, 1, 'Riva', '', 'riva', '', ''),
(5028, 10, 1, 1, 'Sylmar', '', 'sylmar', '', ''),
(5029, 8, 7, 1, 'Apalachin', '', 'apalachin', '', ''),
(5030, 13, 9, 1, 'North Weymouth', '', 'north-weymouth', '', ''),
(5031, 19, 9, 1, 'Center Harbor', '', 'center-harbor', '', ''),
(5032, 22, 8, 1, 'Pleasant Garden', '', 'pleasant-garden', '', ''),
(5033, 13, 9, 1, 'Mattapoisett', '', 'mattapoisett', '', ''),
(5034, 9, 4, 1, 'Burkburnett', '', 'burkburnett', '', ''),
(5035, 35, 5, 1, 'Suttons Bay', '', 'suttons-bay', '', ''),
(5036, 30, 5, 1, 'Macedonia', '', 'macedonia', '', ''),
(5037, 44, 4, 1, 'Sunset', '', 'sunset', '', ''),
(5038, 10, 1, 1, 'Altaville', '', 'altaville', '', ''),
(5039, 20, 8, 1, 'Blountstown', '', 'blountstown', '', ''),
(5040, 14, 8, 1, 'Thomaston', '', 'thomaston', '', ''),
(5041, 8, 7, 1, 'East Patchogue', '', 'east-patchogue', '', ''),
(5042, 11, 2, 1, 'Chino Valley', '', 'chino-valley', '', ''),
(5043, 31, 7, 1, 'Orwigsburg', '', 'orwigsburg', '', ''),
(5044, 8, 7, 1, 'Marcellus', '', 'marcellus', '', ''),
(5045, 31, 7, 1, 'Oley', '', 'oley', '', ''),
(5046, 8, 7, 1, 'Kerhonkson', '', 'kerhonkson', '', ''),
(5047, 20, 8, 1, 'Floral City', '', 'floral-city', '', ''),
(5048, 13, 9, 1, 'North Dartmouth', '', 'north-dartmouth', '', ''),
(5049, 35, 5, 1, 'Benton Harbor', '', 'benton-harbor', '', ''),
(5050, 39, 5, 1, 'East Chicago', '', 'east-chicago', '', ''),
(5051, 8, 7, 1, 'Richfield Springs', '', 'richfield-springs', '', ''),
(5052, 50, 3, 1, 'Humboldt', '', 'humboldt', '', ''),
(5053, 10, 1, 1, 'Norco', '', 'norco', '', ''),
(5054, 48, 6, 1, 'Clanton', '', 'clanton', '', ''),
(5055, 7, 7, 1, 'Millville', '', 'millville', '', ''),
(5056, 31, 7, 1, 'Ashley', '', 'ashley', '', ''),
(5057, 33, 8, 1, 'Buckhannon', '', 'buckhannon', '', ''),
(5058, 47, 3, 1, 'O''Fallon', '', 'o-fallon-5058', '', ''),
(5059, 8, 7, 1, 'Stony Brook', '', 'stony-brook', '', ''),
(5060, 10, 1, 1, '29 Palms', '', '29-palms', '', ''),
(5061, 11, 2, 1, 'Nogales', '', 'nogales', '', ''),
(5062, 14, 8, 1, 'Claxton', '', 'claxton', '', ''),
(5063, 52, 4, 1, 'Barling', '', 'barling', '', ''),
(5064, 60, 2, 1, 'Farson', '', 'farson', '', ''),
(5065, 13, 9, 1, 'Adams', '', 'adams', '', ''),
(5066, 31, 7, 1, 'Mount Union', '', 'mount-union', '', ''),
(5067, 8, 7, 1, 'New Paltz', '', 'new-paltz', '', ''),
(5068, 31, 7, 1, 'East Earl', '', 'east-earl', '', ''),
(5069, 43, 2, 1, 'Peyton', '', 'peyton', '', ''),
(5070, 13, 9, 1, 'Millbury', '', 'millbury', '', ''),
(5071, 30, 5, 1, 'New Carlisle', '', 'new-carlisle', '', ''),
(5072, 14, 8, 1, 'Folkston', '', 'folkston', '', ''),
(5073, 7, 7, 1, 'Runnemede', '', 'runnemede', '', ''),
(5074, 44, 4, 1, 'Terrytown', '', 'terrytown', '', ''),
(5075, 22, 8, 1, 'Pilot Mountain', '', 'pilot-mountain', '', ''),
(5076, 37, 6, 1, 'Crescent Springs', '', 'crescent-springs', '', ''),
(5077, 31, 7, 1, 'Coopersburg', '', 'coopersburg', '', ''),
(5078, 10, 1, 1, 'Los Olivos', '', 'los-olivos', '', ''),
(5079, 41, 9, 1, 'Gales Ferry', '', 'gales-ferry', '', ''),
(5080, 47, 3, 1, 'Stanberry', '', 'stanberry', '', ''),
(5081, 14, 8, 1, 'Mcdonough', '', 'mcdonough', '', ''),
(5082, 17, 3, 1, 'Windom', '', 'windom', '', ''),
(5083, 13, 9, 1, 'Wrentham', '', 'wrentham', '', ''),
(5084, 33, 8, 1, 'Mineral Wells', '', 'mineral-wells', '', ''),
(5085, 8, 7, 1, 'Sidney Center', '', 'sidney-center', '', ''),
(5086, 44, 4, 1, 'Hineston', '', 'hineston', '', ''),
(5087, 33, 8, 1, 'Mount Storm', '', 'mount-storm', '', ''),
(5088, 58, 3, 1, 'Mc Cook', '', 'mc-cook', '', ''),
(5089, 13, 9, 1, 'Pepperell', '', 'pepperell', '', ''),
(5090, 26, 1, 1, 'Boring', '', 'boring', '', ''),
(5091, 60, 2, 1, 'Centennial', '', 'centennial', '', ''),
(5092, 33, 8, 1, 'Moundsville', '', 'moundsville', '', ''),
(5093, 44, 4, 1, 'Zwolle', '', 'zwolle', '', ''),
(5094, 56, 2, 1, 'Kamiah', '', 'kamiah', '', ''),
(5095, 42, 5, 1, 'Effingham', '', 'effingham', '', ''),
(5096, 22, 8, 1, 'Wendell', '', 'wendell', '', ''),
(5097, 22, 8, 1, 'Wilkesboro', '', 'wilkesboro', '', ''),
(5098, 27, 8, 1, 'Inman', '', 'inman', '', ''),
(5099, 36, 5, 1, 'La Farge', '', 'la-farge', '', ''),
(5100, 61, 6, 1, 'Iuka', '', 'iuka', '', ''),
(5101, 13, 9, 1, 'Topsfield', '', 'topsfield', '', ''),
(5102, 36, 5, 1, 'Lake Delton', '', 'lake-delton', '', ''),
(5103, 25, 10, 1, 'Maui', '', 'maui', '', ''),
(5104, 47, 3, 1, 'Kimberling City', '', 'kimberling-city', '', ''),
(5105, 8, 7, 1, 'Skaneateles', '', 'skaneateles', '', ''),
(5106, 12, 1, 1, 'Snoqualmie', '', 'snoqualmie', '', ''),
(5107, 55, 3, 1, 'Garden Plain', '', 'garden-plain', '', ''),
(5108, 9, 4, 1, 'Channelview', '', 'channelview', '', ''),
(5109, 8, 7, 1, 'Island Park', '', 'island-park', '', ''),
(5110, 10, 1, 1, 'Nipomo', '', 'nipomo', '', ''),
(5111, 35, 5, 1, 'Holt', '', 'holt', '', ''),
(5112, 22, 8, 1, 'Lattimore', '', 'lattimore', '', ''),
(5113, 10, 1, 1, 'March Air Force Base', '', 'march-air-force-base', '', ''),
(5114, 58, 3, 1, 'Bradshaw', '', 'bradshaw', '', ''),
(5115, 30, 5, 1, 'Wooster', '', 'wooster', '', ''),
(5116, 31, 7, 1, 'Connellsville', '', 'connellsville', '', ''),
(5117, 33, 8, 1, 'Cross Lanes', '', 'cross-lanes', '', ''),
(5118, 31, 7, 1, 'Mc Murray', '', 'mc-murray', '', ''),
(5119, 31, 7, 1, 'Hanover Township', '', 'hanover-township', '', ''),
(5120, 20, 8, 1, 'North Palm Beach', '', 'north-palm-beach', '', ''),
(5121, 31, 7, 1, 'Elysburg', '', 'elysburg', '', ''),
(5122, 41, 9, 1, 'Pomfret Center', '', 'pomfret-center', '', ''),
(5123, 7, 7, 1, 'Wanaque', '', 'wanaque', '', ''),
(5124, 7, 7, 1, 'Bay Head', '', 'bay-head', '', ''),
(5125, 10, 1, 1, 'Moren Valley', '', 'moren-valley', '', ''),
(5126, 24, 2, 1, 'Woods Cross', '', 'woods-cross', '', ''),
(5127, 28, 9, 1, 'North Scituate', '', 'north-scituate', '', ''),
(5128, 47, 3, 1, 'Saint Robert', '', 'saint-robert', '', ''),
(5129, 8, 7, 1, 'Newfield', '', 'newfield', '', ''),
(5130, 30, 5, 1, 'New Middletown', '', 'new-middletown', '', ''),
(5131, 27, 8, 1, 'Little River', '', 'little-river', '', ''),
(5132, 31, 7, 1, 'Lake Harmony', '', 'lake-harmony', '', ''),
(5133, 24, 2, 1, 'Santaquin', '', 'santaquin', '', ''),
(5134, 38, 9, 1, 'Ferrisburg', '', 'ferrisburg', '', ''),
(5135, 9, 4, 1, 'Dripping Springs', '', 'dripping-springs', '', ''),
(5136, 31, 7, 1, 'Pitcairn', '', 'pitcairn', '', ''),
(5137, 24, 2, 1, 'Spanish Fork', '', 'spanish-fork', '', ''),
(5138, 11, 2, 1, 'Catalina', '', 'catalina', '', ''),
(5139, 28, 9, 1, 'North Kingstown', '', 'north-kingstown', '', ''),
(5140, 9, 4, 1, 'Watauga', '', 'watauga', '', ''),
(5141, 42, 5, 1, 'Capron', '', 'capron', '', ''),
(5142, 45, 2, 1, 'Ruidoso', '', 'ruidoso', '', ''),
(5143, 44, 4, 1, 'Farmerville', '', 'farmerville', '', ''),
(5144, 39, 5, 1, 'Ellettsville', '', 'ellettsville', '', ''),
(5145, 31, 7, 1, 'Pleasant Unity', '', 'pleasant-unity', '', ''),
(5146, 31, 7, 1, 'Millerton', '', 'millerton', '', ''),
(5147, 56, 2, 1, 'Gooding', '', 'gooding', '', ''),
(5148, 52, 4, 1, 'Maumelle', '', 'maumelle', '', ''),
(5149, 44, 4, 1, 'Broussard', '', 'broussard', '', ''),
(5150, 27, 8, 1, 'Pelzer', '', 'pelzer', '', ''),
(5151, 42, 5, 1, 'Minooka', '', 'minooka', '', ''),
(5152, 10, 1, 1, 'Coulterville', '', 'coulterville', '', ''),
(5153, 8, 7, 1, 'North Baldwin', '', 'north-baldwin', '', ''),
(5154, 20, 8, 1, 'Opa Locka', '', 'opa-locka', '', ''),
(5155, 10, 1, 1, 'Portola', '', 'portola', '', ''),
(5156, 35, 5, 1, 'Grandville', '', 'grandville', '', ''),
(5157, 36, 5, 1, 'Potosi', '', 'potosi', '', ''),
(5158, 11, 2, 1, 'Higley', '', 'higley', '', ''),
(5159, 30, 5, 1, 'Copley', '', 'copley', '', ''),
(5160, 10, 1, 1, 'American Canyon', '', 'american-canyon', '', ''),
(5161, 30, 5, 1, 'Cleveland Heights', '', 'cleveland-heights', '', ''),
(5162, 61, 6, 1, 'Diamondhead', '', 'diamondhead', '', ''),
(5163, 15, 8, 1, 'Curtis Bay', '', 'curtis-bay', '', ''),
(5164, 9, 4, 1, 'Hallsville', '', 'hallsville', '', ''),
(5165, 20, 8, 1, 'Starke', '', 'starke', '', ''),
(5166, 33, 8, 1, 'Middlebourne', '', 'middlebourne', '', ''),
(5167, 36, 5, 1, 'Muskego', '', 'muskego', '', ''),
(5168, 10, 1, 1, 'Discovery Bay', '', 'discovery-bay', '', ''),
(5169, 44, 4, 1, 'Bush', '', 'bush', '', ''),
(5170, 8, 7, 1, 'Dix Hills', '', 'dix-hills', '', ''),
(5171, 61, 6, 1, 'Hollandale', '', 'hollandale', '', ''),
(5172, 27, 8, 1, 'Johns Island', '', 'johns-island', '', ''),
(5173, 25, 10, 1, 'Wahiawa', '', 'wahiawa', '', ''),
(5174, 35, 5, 1, 'Taylor', '', 'taylor', '', ''),
(5175, 23, 9, 1, 'Alfred', '', 'alfred', '', ''),
(5176, 30, 5, 1, 'Wheelersburg', '', 'wheelersburg', '', ''),
(5177, 15, 8, 1, 'Keedysville', '', 'keedysville', '', ''),
(5178, 13, 9, 1, 'Dudley', '', 'dudley', '', ''),
(5179, 10, 1, 1, 'Monterey Park', '', 'monterey-park', '', ''),
(5180, 8, 7, 1, 'Piermont', '', 'piermont', '', ''),
(5181, 20, 8, 1, 'Oldsmar', '', 'oldsmar', '', ''),
(5182, 9, 4, 1, 'Early', '', 'early', '', ''),
(5183, 8, 7, 1, 'Esperance', '', 'esperance', '', ''),
(5184, 31, 7, 1, 'Conyngham', '', 'conyngham', '', ''),
(5185, 12, 1, 1, 'Liberty Lake', '', 'liberty-lake', '', ''),
(5186, 34, 1, 1, 'Kasilof', '', 'kasilof', '', ''),
(5187, 42, 5, 1, 'South Holland', '', 'south-holland', '', ''),
(5188, 57, 3, 1, 'Elkader', '', 'elkader', '', ''),
(5189, 19, 9, 1, 'Madbury', '', 'madbury', '', ''),
(5190, 12, 1, 1, 'Sumner', '', 'sumner', '', ''),
(5191, 55, 3, 1, 'Belle Plaine', '', 'belle-plaine', '', ''),
(5192, 45, 2, 1, 'Bosque Farms', '', 'bosque-farms', '', ''),
(5193, 32, 4, 1, 'Owasso', '', 'owasso', '', ''),
(5194, 31, 7, 1, 'West Lawn', '', 'west-lawn', '', ''),
(5195, 14, 8, 1, 'Lilburn', '', 'lilburn', '', ''),
(5196, 7, 7, 1, 'Blairstown', '', 'blairstown', '', ''),
(5197, 48, 6, 1, 'Hartselle', '', 'hartselle', '', ''),
(5198, 14, 8, 1, 'Moultrie', '', 'moultrie', '', ''),
(5199, 10, 1, 1, 'Sunset beach', '', 'sunset-beach', '', ''),
(5200, 21, 8, 1, 'Purcellville', '', 'purcellville', '', ''),
(5201, 15, 8, 1, 'Montgomery Village', '', 'montgomery-village', '', ''),
(5202, 50, 3, 1, 'White House', '', 'white-house', '', ''),
(5203, 22, 8, 1, 'Hope Mills', '', 'hope-mills', '', ''),
(5204, 14, 8, 1, 'Irwinton', '', 'irwinton', '', ''),
(5205, 44, 4, 1, 'Breaux Bridge', '', 'breaux-bridge', '', ''),
(5206, 22, 8, 1, 'Rutherfordton', '', 'rutherfordton', '', ''),
(5207, 7, 7, 1, 'Egg Harbor City', '', 'egg-harbor-city', '', ''),
(5208, 7, 7, 1, 'Skillman', '', 'skillman', '', ''),
(5209, 20, 8, 1, 'Summerfield', '', 'summerfield', '', ''),
(5210, 21, 8, 1, 'The Plains', '', 'the-plains', '', ''),
(5211, 19, 9, 1, 'Suncook', '', 'suncook', '', ''),
(5212, 31, 7, 1, 'Spring House', '', 'spring-house', '', ''),
(5213, 21, 8, 1, 'Galax', '', 'galax', '', ''),
(5214, 8, 7, 1, 'Granite Springs', '', 'granite-springs', '', ''),
(5215, 8, 7, 1, 'Millbrook', '', 'millbrook', '', ''),
(5216, 33, 8, 1, 'Ravenswood', '', 'ravenswood', '', ''),
(5217, 31, 7, 1, 'Zion Grove', '', 'zion-grove', '', ''),
(5218, 20, 8, 1, 'Sanibel', '', 'sanibel', '', ''),
(5219, 48, 6, 1, 'Valley', '', 'valley', '', ''),
(5220, 9, 4, 1, 'Boerne', '', 'boerne', '', ''),
(5221, 22, 8, 1, 'Vanceboro', '', 'vanceboro', '', ''),
(5222, 20, 8, 1, 'Inverness', '', 'inverness', '', ''),
(5223, 32, 4, 1, 'Tuttle', '', 'tuttle', '', ''),
(5224, 61, 6, 1, 'Sardis', '', 'sardis', '', ''),
(5225, 8, 7, 1, 'Highland Mills', '', 'highland-mills', '', ''),
(5226, 9, 4, 1, 'Kaufman', '', 'kaufman', '', ''),
(5227, 35, 5, 1, 'Fort Gratiot', '', 'fort-gratiot', '', ''),
(5228, 42, 5, 1, 'Norridge', '', 'norridge', '', ''),
(5229, 21, 8, 1, 'Haymarket', '', 'haymarket', '', ''),
(5230, 8, 7, 1, 'Constantia', '', 'constantia', '', ''),
(5231, 20, 8, 1, 'Bonifay', '', 'bonifay', '', ''),
(5232, 15, 8, 1, 'Churchton', '', 'churchton', '', ''),
(5233, 22, 8, 1, 'Laurinburg', '', 'laurinburg', '', ''),
(5234, 9, 4, 1, 'Hondo', '', 'hondo', '', ''),
(5235, 35, 5, 1, 'Novi', '', 'novi', '', ''),
(5236, 31, 7, 1, 'Pulaski', '', 'pulaski', '', ''),
(5237, 31, 7, 1, 'Pocono Lake', '', 'pocono-lake', '', ''),
(5238, 41, 9, 1, 'North Windham', '', 'north-windham', '', ''),
(5239, 31, 7, 1, 'Ford City', '', 'ford-city', '', ''),
(5240, 50, 3, 1, 'Pleasant Shade', '', 'pleasant-shade', '', ''),
(5241, 10, 1, 1, 'Azusa', '', 'azusa', '', ''),
(5242, 21, 8, 1, 'Max Meadows', '', 'max-meadows', '', ''),
(5243, 35, 5, 1, 'Shelby Township', '', 'shelby-township', '', ''),
(5244, 12, 1, 1, 'Twisp', '', 'twisp', '', ''),
(5245, 15, 8, 1, 'Linthicum Hts', '', 'linthicum-hts', '', ''),
(5246, 14, 8, 1, 'Oakwood', '', 'oakwood', '', ''),
(5247, 13, 9, 1, 'Whitman', '', 'whitman', '', ''),
(5248, 31, 7, 1, 'Villanova', '', 'villanova', '', ''),
(5249, 38, 9, 1, 'Bellows Falls', '', 'bellows-falls', '', ''),
(5250, 31, 7, 1, 'Mountain Top', '', 'mountain-top', '', ''),
(5251, 8, 7, 1, 'Sinclairville', '', 'sinclairville', '', ''),
(5252, 42, 5, 1, 'Yorkville', '', 'yorkville', '', ''),
(5253, 36, 5, 1, 'Saint Nazianz', '', 'saint-nazianz', '', ''),
(5254, 31, 7, 1, 'Olyphant', '', 'olyphant', '', ''),
(5255, 39, 5, 1, 'Henryville', '', 'henryville', '', ''),
(5256, 31, 7, 1, 'Moon Township', '', 'moon-township', '', ''),
(5257, 31, 7, 1, 'Schuylkill Haven', '', 'schuylkill-haven', '', ''),
(5258, 44, 4, 1, 'Ponchatoula', '', 'ponchatoula', '', ''),
(5259, 23, 9, 1, 'Cornish', '', 'cornish', '', ''),
(5260, 50, 3, 1, 'Collierville', '', 'collierville', '', ''),
(5261, 55, 3, 1, 'Overbrook', '', 'overbrook', '', ''),
(5262, 41, 9, 1, 'Beacon Falls', '', 'beacon-falls', '', ''),
(5263, 48, 6, 1, 'Satsuma', '', 'satsuma', '', ''),
(5264, 20, 8, 1, 'Coconut Grove', '', 'coconut-grove', '', ''),
(5265, 39, 5, 1, 'Veedersburg', '', 'veedersburg', '', ''),
(5266, 27, 8, 1, 'Cope', '', 'cope', '', ''),
(5267, 10, 1, 1, 'Del Rey', '', 'del-rey', '', ''),
(5268, 22, 8, 1, 'Pinehurst', '', 'pinehurst', '', ''),
(5269, 61, 6, 1, 'Gautier', '', 'gautier', '', ''),
(5270, 31, 7, 1, 'Wyalusing', '', 'wyalusing', '', ''),
(5271, 15, 8, 1, 'Damascus', '', 'damascus', '', ''),
(5272, 27, 8, 1, 'Fort Mill', '', 'fort-mill', '', ''),
(5273, 36, 5, 1, 'Sheboygan Falls', '', 'sheboygan-falls', '', ''),
(5274, 47, 3, 1, 'Reeds Spring', '', 'reeds-spring', '', ''),
(5275, 17, 3, 1, 'Eagan', '', 'eagan', '', ''),
(5276, 13, 9, 1, 'Osterville', '', 'osterville', '', ''),
(5277, 20, 8, 1, 'Lauderdale Lakes', '', 'lauderdale-lakes', '', ''),
(5278, 9, 4, 1, 'Kerens', '', 'kerens', '', ''),
(5279, 42, 5, 1, 'Coal Valley', '', 'coal-valley', '', ''),
(5280, 42, 5, 1, 'Hinsdale', '', 'hinsdale', '', ''),
(5281, 13, 9, 1, 'Hadley', '', 'hadley', '', ''),
(5282, 7, 7, 1, 'Yardville', '', 'yardville', '', ''),
(5283, 19, 9, 1, 'Epsom', '', 'epsom', '', ''),
(5284, 37, 6, 1, 'Lexingtion', '', 'lexingtion', '', ''),
(5285, 11, 2, 1, 'Marana', '', 'marana', '', ''),
(5286, 21, 8, 1, 'Clintwood', '', 'clintwood', '', ''),
(5287, 23, 9, 1, 'Cumberland Center', '', 'cumberland-center', '', ''),
(5288, 39, 5, 1, 'Knightstown', '', 'knightstown', '', ''),
(5289, 44, 4, 1, 'Tickfaw', '', 'tickfaw', '', ''),
(5290, 35, 5, 1, 'Superior Township', '', 'superior-township', '', ''),
(5291, 35, 5, 1, 'Marine City', '', 'marine-city', '', ''),
(5292, 8, 7, 1, 'Alexandria Bay', '', 'alexandria-bay', '', ''),
(5293, 41, 9, 1, 'Putnam', '', 'putnam', '', ''),
(5294, 41, 9, 1, 'Stafford Springs', '', 'stafford-springs', '', ''),
(5295, 31, 7, 1, 'New Brighton', '', 'new-brighton', '', ''),
(5296, 8, 7, 1, 'Kiamesha lake', '', 'kiamesha-lake', '', ''),
(5297, 21, 8, 1, 'Prince George', '', 'prince-george', '', ''),
(5298, 31, 7, 1, 'Monongahela', '', 'monongahela', '', ''),
(5299, 35, 5, 1, 'Middleville', '', 'middleville', '', ''),
(5300, 22, 8, 1, 'Ocean Isle Beach', '', 'ocean-isle-beach', '', ''),
(5301, 42, 5, 1, 'Streamwood', '', 'streamwood', '', ''),
(5302, 35, 5, 1, 'Clawson', '', 'clawson', '', ''),
(5303, 27, 8, 1, 'Prosperity', '', 'prosperity', '', ''),
(5304, 11, 2, 1, 'Safford', '', 'safford', '', ''),
(5305, 44, 4, 1, 'Natchitoches', '', 'natchitoches', '', ''),
(5306, 10, 1, 1, 'Orange Cove', '', 'orange-cove', '', ''),
(5307, 10, 1, 1, 'North Highlands', '', 'north-highlands', '', ''),
(5308, 21, 8, 1, 'Dulles', '', 'dulles', '', ''),
(5309, 9, 4, 1, 'The Woodlands', '', 'the-woodlands', '', ''),
(5310, 30, 5, 1, 'Beavercreek', '', 'beavercreek', '', ''),
(5311, 10, 1, 1, 'Cabazon', '', 'cabazon', '', ''),
(5312, 61, 6, 1, 'Ridgeland', '', 'ridgeland', '', ''),
(5313, 56, 2, 1, 'Fruitland', '', 'fruitland', '', ''),
(5314, 17, 3, 1, 'Stacy', '', 'stacy', '', ''),
(5315, 7, 7, 1, 'Audubon', '', 'audubon', '', ''),
(5316, 30, 5, 1, 'Tallmadge', '', 'tallmadge', '', ''),
(5317, 20, 8, 1, 'Wesley Chapel', '', 'wesley-chapel', '', ''),
(5318, 39, 5, 1, 'Scottsburg', '', 'scottsburg', '', ''),
(5319, 43, 2, 1, 'Rifle', '', 'rifle', '', ''),
(5320, 30, 5, 1, 'Middlefield', '', 'middlefield', '', ''),
(5321, 7, 7, 1, 'Manville', '', 'manville', '', ''),
(5322, 48, 6, 1, 'Demopolis', '', 'demopolis', '', ''),
(5323, 47, 3, 1, 'Napoleon', '', 'napoleon', '', ''),
(5324, 27, 8, 1, 'Goose Creek', '', 'goose-creek', '', ''),
(5325, 60, 2, 1, 'Green River', '', 'green-river', '', ''),
(5326, 13, 9, 1, 'Brimfield', '', 'brimfield', '', ''),
(5327, 43, 2, 1, 'Northglenn', '', 'northglenn', '', ''),
(5328, 61, 6, 1, 'Belzoni', '', 'belzoni', '', ''),
(5329, 20, 8, 1, 'Wabasso', '', 'wabasso', '', ''),
(5330, 20, 8, 1, 'Hallandale Beach', '', 'hallandale-beach', '', ''),
(5331, 25, 10, 1, 'Kalaheo', '', 'kalaheo', '', ''),
(5332, 42, 5, 1, 'Winthrop Harbor', '', 'winthrop-harbor', '', ''),
(5333, 39, 5, 1, 'Edinburgh', '', 'edinburgh', '', ''),
(5334, 43, 2, 1, 'Silverthorne', '', 'silverthorne', '', ''),
(5335, 26, 1, 1, 'Woodburn', '', 'woodburn', '', ''),
(5336, 35, 5, 1, 'Birch Run', '', 'birch-run', '', ''),
(5337, 35, 5, 1, 'Auburn Hills', '', 'auburn-hills', '', ''),
(5338, 36, 5, 1, 'Johnson Creek', '', 'johnson-creek', '', ''),
(5339, 10, 1, 1, 'Terra Bella', '', 'terra-bella', '', ''),
(5340, 41, 9, 1, 'Harwinton', '', 'harwinton', '', ''),
(5341, 7, 7, 1, 'Haworth', '', 'haworth', '', ''),
(5342, 45, 2, 1, 'Thoreau', '', 'thoreau', '', ''),
(5343, 8, 7, 1, 'Franklinville', '', 'franklinville', '', ''),
(5344, 32, 4, 1, 'Pocasset', '', 'pocasset', '', ''),
(5345, 52, 4, 1, 'Siloam Springs', '', 'siloam-springs', '', ''),
(5346, 13, 9, 1, 'North Quincy', '', 'north-quincy', '', ''),
(5347, 22, 8, 1, 'Raeford', '', 'raeford', '', ''),
(5348, 12, 1, 1, 'Monitor', '', 'monitor', '', ''),
(5349, 36, 5, 1, 'Lannon', '', 'lannon', '', ''),
(5350, 7, 7, 1, 'Highland Lakes', '', 'highland-lakes', '', ''),
(5351, 61, 6, 1, 'Kosciusko', '', 'kosciusko', '', ''),
(5352, 41, 9, 1, 'Ledyard', '', 'ledyard', '', ''),
(5353, 13, 9, 1, 'Indian Orchard', '', 'indian-orchard', '', ''),
(5354, 21, 8, 1, 'Honaker', '', 'honaker', '', ''),
(5355, 25, 10, 1, 'Naalehu', '', 'naalehu', '', ''),
(5356, 12, 1, 1, 'Hoodsport', '', 'hoodsport', '', ''),
(5357, 12, 1, 1, 'Veradale', '', 'veradale', '', ''),
(5358, 20, 8, 1, 'Apopka', '', 'apopka', '', ''),
(5359, 21, 8, 1, 'Occoquan', '', 'occoquan', '', ''),
(5360, 32, 4, 1, 'Hydro', '', 'hydro', '', ''),
(5361, 10, 1, 1, 'Imperial Beach', '', 'imperial-beach', '', ''),
(5362, 56, 2, 1, 'Kuna', '', 'kuna', '', ''),
(5363, 44, 4, 1, 'Denham Springs', '', 'denham-springs', '', ''),
(5364, 50, 3, 1, 'La Follette', '', 'la-follette', '', ''),
(5365, 30, 5, 1, 'Minerva', '', 'minerva', '', ''),
(5366, 10, 1, 1, 'Bard', '', 'bard', '', ''),
(5367, 12, 1, 1, 'Napavine', '', 'napavine', '', ''),
(5368, 43, 2, 1, 'U S A F Academy', '', 'u-s-a-f-academy', '', ''),
(5369, 31, 7, 1, 'Oreland', '', 'oreland', '', ''),
(5370, 42, 5, 1, 'Wauconda', '', 'wauconda', '', ''),
(5371, 11, 2, 1, 'Oracle', '', 'oracle', '', ''),
(5372, 14, 8, 1, 'Conley', '', 'conley', '', ''),
(5373, 20, 8, 1, 'Mount Dora', '', 'mount-dora', '', ''),
(5374, 44, 4, 1, 'Iota', '', 'iota', '', ''),
(5375, 11, 2, 1, 'Mayer', '', 'mayer', '', ''),
(5376, 9, 4, 1, 'Colleyville', '', 'colleyville', '', ''),
(5377, 7, 7, 1, 'Woodbury Heights', '', 'woodbury-heights', '', ''),
(5378, 9, 4, 1, 'Huffman', '', 'huffman', '', ''),
(5379, 31, 7, 1, 'Slatington', '', 'slatington', '', ''),
(5380, 21, 8, 1, 'Glen Allen', '', 'glen-allen', '', ''),
(5381, 61, 6, 1, 'Magee', '', 'magee', '', ''),
(5382, 22, 8, 1, 'Knightdale', '', 'knightdale', '', ''),
(5383, 21, 8, 1, 'Front Royal', '', 'front-royal', '', ''),
(5384, 13, 9, 1, 'North Falmouth', '', 'north-falmouth', '', ''),
(5385, 9, 4, 1, 'Lindale', '', 'lindale', '', ''),
(5386, 19, 9, 1, 'Goffstown', '', 'goffstown', '', ''),
(5387, 8, 7, 1, 'Ravena', '', 'ravena', '', ''),
(5388, 33, 8, 1, 'New Martinsville', '', 'new-martinsville', '', ''),
(5389, 30, 5, 1, 'North Kingsville', '', 'north-kingsville', '', ''),
(5390, 10, 1, 1, 'Blue Jay', '', 'blue-jay', '', ''),
(5391, 9, 4, 1, 'Hamshire', '', 'hamshire', '', ''),
(5392, 31, 7, 1, 'Peckville', '', 'peckville', '', ''),
(5393, 8, 7, 1, 'Wurtsboro', '', 'wurtsboro', '', ''),
(5394, 27, 8, 1, 'Travelers Rest', '', 'travelers-rest', '', ''),
(5395, 9, 4, 1, 'Sinton', '', 'sinton', '', ''),
(5396, 50, 3, 1, 'Joelton', '', 'joelton', '', ''),
(5397, 36, 5, 1, 'Neshkoro', '', 'neshkoro', '', ''),
(5398, 8, 7, 1, 'Watervliet', '', 'watervliet', '', ''),
(5399, 10, 1, 1, 'Knightsen', '', 'knightsen', '', ''),
(5400, 14, 8, 1, 'Villa Rica', '', 'villa-rica', '', ''),
(5401, 7, 7, 1, 'Villas', '', 'villas', '', ''),
(5402, 31, 7, 1, 'East Berlin', '', 'east-berlin', '', ''),
(5403, 13, 9, 1, 'Millis', '', 'millis', '', ''),
(5404, 50, 3, 1, 'Maynardville', '', 'maynardville', '', ''),
(5405, 50, 3, 1, 'New Tazewell', '', 'new-tazewell', '', ''),
(5406, 10, 1, 1, 'Baldwin Park', '', 'baldwin-park', '', ''),
(5407, 10, 1, 1, 'Ontagio', '', 'ontagio', '', ''),
(5408, 9, 4, 1, 'Winters', '', 'winters', '', ''),
(5409, 51, 2, 1, 'Jean', '', 'jean', '', ''),
(5410, 32, 4, 1, 'Chouteau', '', 'chouteau', '', ''),
(5411, 9, 4, 1, 'Timpson', '', 'timpson', '', ''),
(5412, 20, 8, 1, 'Dade City', '', 'dade-city', '', ''),
(5413, 47, 3, 1, 'Warrensburg', '', 'warrensburg', '', ''),
(5414, 9, 4, 1, 'Vidor', '', 'vidor', '', ''),
(5415, 14, 8, 1, 'Chamblee', '', 'chamblee', '', ''),
(5416, 60, 2, 1, 'Wheatland', '', 'wheatland', '', ''),
(5417, 27, 8, 1, 'Pageland', '', 'pageland', '', ''),
(5418, 9, 4, 1, 'Magnolia', '', 'magnolia', '', ''),
(5419, 47, 3, 1, 'Monett', '', 'monett', '', ''),
(5420, 10, 1, 1, 'Lynwood', '', 'lynwood', '', ''),
(5421, 10, 1, 1, 'Gold River', '', 'gold-river', '', ''),
(5422, 9, 4, 1, 'La Coste', '', 'la-coste', '', ''),
(5423, 42, 5, 1, 'East Moline', '', 'east-moline', '', ''),
(5424, 9, 4, 1, 'Pearsall', '', 'pearsall', '', ''),
(5425, 26, 1, 1, 'Stayton', '', 'stayton', '', ''),
(5426, 45, 2, 1, 'Tularosa', '', 'tularosa', '', ''),
(5427, 10, 1, 1, 'Bell Gardens', '', 'bell-gardens', '', ''),
(5428, 10, 1, 1, 'Santa Fe Springs', '', 'santa-fe-springs', '', ''),
(5429, 10, 1, 1, 'Rimforest', '', 'rimforest', '', ''),
(5430, 9, 4, 1, 'Ballinger', '', 'ballinger', '', ''),
(5431, 11, 2, 1, 'Winslow', '', 'winslow', '', ''),
(5432, 44, 4, 1, 'Hodge', '', 'hodge', '', ''),
(5433, 58, 3, 1, 'David City', '', 'david-city', '', ''),
(5434, 9, 4, 1, 'Floresville', '', 'floresville', '', ''),
(5435, 9, 4, 1, 'The Colony', '', 'the-colony', '', ''),
(5436, 10, 1, 1, 'Calexico', '', 'calexico', '', ''),
(5437, 42, 5, 1, 'Bridgeview', '', 'bridgeview', '', ''),
(5438, 26, 1, 1, 'Willamina', '', 'willamina', '', ''),
(5439, 42, 5, 1, 'Summit Argo', '', 'summit-argo', '', ''),
(5440, 14, 8, 1, 'Morrow', '', 'morrow', '', ''),
(5441, 20, 8, 1, 'Altamonte Spg', '', 'altamonte-spg', '', ''),
(5442, 11, 2, 1, 'Bisbee', '', 'bisbee', '', ''),
(5443, 43, 2, 1, 'Alamosa', '', 'alamosa', '', ''),
(5444, 43, 2, 1, 'Gunnison', '', 'gunnison', '', ''),
(5445, 38, 9, 1, 'Winooski', '', 'winooski', '', ''),
(5446, 43, 2, 1, 'Monte Vista', '', 'monte-vista', '', ''),
(5447, 9, 4, 1, 'Port Aransas', '', 'port-aransas', '', ''),
(5448, 61, 6, 1, 'Tupeloa', '', 'tupeloa', '', ''),
(5449, 9, 4, 1, 'East Bernard', '', 'east-bernard', '', ''),
(5450, 11, 2, 1, 'San Manuel', '', 'san-manuel', '', ''),
(5451, 10, 1, 1, 'Soledad', '', 'soledad', '', ''),
(5452, 20, 8, 1, 'De Leon Springs', '', 'de-leon-springs', '', ''),
(5453, 14, 8, 1, 'Ellijay', '', 'ellijay', '', ''),
(5454, 7, 7, 1, 'Browns Mills', '', 'browns-mills', '', ''),
(5455, 10, 1, 1, 'Lamont', '', 'lamont', '', ''),
(5456, 51, 2, 1, 'Primm', '', 'primm', '', ''),
(5457, 10, 1, 1, 'Williams', '', 'williams', '', ''),
(5458, 17, 3, 1, 'White Bear Lake', '', 'white-bear-lake', '', ''),
(5459, 32, 4, 1, 'Midwest City', '', 'midwest-city', '', ''),
(5460, 9, 4, 1, 'Brownfield', '', 'brownfield', '', ''),
(5461, 20, 8, 1, 'Wimauma', '', 'wimauma', '', ''),
(5462, 20, 8, 1, 'Indiantown', '', 'indiantown', '', ''),
(5463, 32, 4, 1, 'Hooker', '', 'hooker', '', ''),
(5464, 43, 2, 1, 'Fort Lupton', '', 'fort-lupton', '', ''),
(5465, 17, 3, 1, 'Onamia', '', 'onamia', '', ''),
(5466, 32, 4, 1, 'Wilburton', '', 'wilburton', '', ''),
(5467, 55, 3, 1, 'Hugoton', '', 'hugoton', '', ''),
(5468, 10, 1, 1, 'Chowchilla', '', 'chowchilla', '', ''),
(5469, 10, 1, 1, 'Bonsall', '', 'bonsall', '', ''),
(5470, 35, 5, 1, 'Romulus', '', 'romulus', '', ''),
(5471, 9, 4, 1, 'Edna', '', 'edna', '', ''),
(5472, 47, 3, 1, 'Stover', '', 'stover', '', ''),
(5473, 21, 8, 1, 'Ruckersville', '', 'ruckersville', '', ''),
(5474, 10, 1, 1, 'Susanville', '', 'susanville', '', ''),
(5475, 14, 8, 1, 'Elberton', '', 'elberton', '', ''),
(5476, 37, 6, 1, 'Cadiz', '', 'cadiz', '', ''),
(5477, 10, 1, 1, 'Point Arena', '', 'point-arena', '', ''),
(5478, 42, 5, 1, 'Crest Hill', '', 'crest-hill', '', ''),
(5479, 10, 1, 1, 'Wasco', '', 'wasco', '', ''),
(5480, 11, 2, 1, 'Huachuca City', '', 'huachuca-city', '', ''),
(5481, 32, 4, 1, 'Vinita', '', 'vinita', '', ''),
(5482, 52, 4, 1, 'Stuttgart', '', 'stuttgart', '', ''),
(5483, 43, 2, 1, 'Pueblo West', '', 'pueblo-west', '', ''),
(5484, 32, 4, 1, 'Roland', '', 'roland', '', ''),
(5485, 47, 3, 1, 'Neosho', '', 'neosho', '', ''),
(5486, 55, 3, 1, 'Coffeyville', '', 'coffeyville', '', ''),
(5487, 10, 1, 1, 'Caruthers', '', 'caruthers', '', ''),
(5488, 43, 2, 1, 'Commerce City', '', 'commerce-city', '', ''),
(5489, 10, 1, 1, 'Big Bear Lake', '', 'big-bear-lake', '', ''),
(5490, 10, 1, 1, 'Brawley', '', 'brawley', '', ''),
(5491, 12, 1, 1, 'Mattawa', '', 'mattawa', '', ''),
(5492, 47, 3, 1, 'Sappington', '', 'sappington', '', ''),
(5493, 48, 6, 1, 'Hazel Green', '', 'hazel-green', '', ''),
(5494, 30, 5, 1, 'Van Wert', '', 'van-wert', '', ''),
(5495, 9, 4, 1, 'New Summerfield', '', 'new-summerfield', '', ''),
(5496, 12, 1, 1, 'Sumas', '', 'sumas', '', ''),
(5497, 47, 3, 1, 'South West City', '', 'south-west-city', '', ''),
(5498, 39, 5, 1, 'Cedar Lake', '', 'cedar-lake', '', ''),
(5499, 47, 3, 1, 'Webb City', '', 'webb-city', '', ''),
(5500, 20, 8, 1, 'Waldo', '', 'waldo', '', ''),
(5501, 9, 4, 1, 'San Juan', '', 'san-juan', '', ''),
(5502, 9, 4, 1, 'La Joya', '', 'la-joya', '', ''),
(5503, 10, 1, 1, 'South Gate', '', 'south-gate', '', ''),
(5504, 14, 8, 1, 'Cordele', '', 'cordele', '', ''),
(5505, 61, 6, 1, 'Flowood', '', 'flowood', '', ''),
(5506, 42, 5, 1, 'Mt Vernon', '', 'mt-vernon', '', ''),
(5507, 9, 4, 1, 'Diboll', '', 'diboll', '', ''),
(5508, 9, 4, 1, 'Joaquin', '', 'joaquin', '', ''),
(5509, 10, 1, 1, 'Live Oak', '', 'live-oak', '', ''),
(5510, 30, 5, 1, 'Gahanna', '', 'gahanna', '', ''),
(5511, 11, 2, 1, 'Chandler Heights', '', 'chandler-heights', '', ''),
(5512, 43, 2, 1, 'Fountain', '', 'fountain', '', ''),
(5513, 17, 3, 1, 'Trimont', '', 'trimont', '', ''),
(5514, 14, 8, 1, 'Calhoun', '', 'calhoun', '', ''),
(5515, 9, 4, 1, 'Fabens', '', 'fabens', '', ''),
(5516, 26, 1, 1, 'Milwaukie', '', 'milwaukie', '', ''),
(5517, 9, 4, 1, 'San Benito', '', 'san-benito', '', ''),
(5518, 9, 4, 1, 'Porter', '', 'porter', '', ''),
(5519, 20, 8, 1, 'Immokalee', '', 'immokalee', '', ''),
(5520, 27, 8, 1, 'Simpsonville', '', 'simpsonville', '', ''),
(5521, 14, 8, 1, 'Sandy Springs', '', 'sandy-springs', '', ''),
(5522, 22, 8, 1, 'Marshville', '', 'marshville', '', ''),
(5523, 32, 4, 1, 'Waynoka', '', 'waynoka', '', ''),
(5524, 44, 4, 1, 'Crowley', '', 'crowley', '', ''),
(5525, 9, 4, 1, 'Kemp', '', 'kemp', '', ''),
(5526, 10, 1, 1, 'Auberry', '', 'auberry', '', ''),
(5527, 45, 2, 1, 'Vado', '', 'vado', '', ''),
(5528, 55, 3, 1, 'Parsons', '', 'parsons', '', ''),
(5529, 32, 4, 1, 'Fort Gibson', '', 'fort-gibson', '', ''),
(5530, 9, 4, 1, 'Granite Shoals', '', 'granite-shoals', '', ''),
(5531, 45, 2, 1, 'Hatch', '', 'hatch', '', ''),
(5532, 22, 8, 1, 'Hamlet', '', 'hamlet', '', ''),
(5533, 30, 5, 1, 'Maineville', '', 'maineville', '', ''),
(5534, 10, 1, 1, 'Clearlake Oaks', '', 'clearlake-oaks', '', ''),
(5535, 11, 2, 1, 'Pinetop', '', 'pinetop', '', ''),
(5536, 9, 4, 1, 'Zapata', '', 'zapata', '', ''),
(5537, 24, 2, 1, 'Wendover', '', 'wendover', '', ''),
(5538, 55, 3, 1, 'St Marys', '', 'st-marys', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(5539, 10, 1, 1, 'La Puente', '', 'la-puente', '', ''),
(5540, 9, 4, 1, 'South Padre Island', '', 'south-padre-island', '', ''),
(5541, 32, 4, 1, 'Haileyville', '', 'haileyville', '', ''),
(5542, 11, 2, 1, 'Sells', '', 'sells', '', ''),
(5543, 22, 8, 1, 'Maggie Valley', '', 'maggie-valley', '', ''),
(5544, 32, 4, 1, 'Madill', '', 'madill', '', ''),
(5545, 55, 3, 1, 'Harper', '', 'harper', '', ''),
(5546, 10, 1, 1, 'Frazier Park', '', 'frazier-park', '', ''),
(5547, 9, 4, 1, 'Refugio', '', 'refugio', '', ''),
(5548, 11, 2, 1, 'Heber', '', 'heber', '', ''),
(5549, 45, 2, 1, 'Sunland Park', '', 'sunland-park', '', ''),
(5550, 27, 8, 1, 'Saint Stephen', '', 'saint-stephen', '', ''),
(5551, 48, 6, 1, 'Guin', '', 'guin', '', ''),
(5553, 9, 4, 1, 'Wolfforth', '', 'wolfforth', '', ''),
(5554, 10, 1, 1, 'Parlier', '', 'parlier', '', ''),
(5555, 9, 4, 1, 'Socorro', '', 'socorro', '', ''),
(5556, 9, 4, 1, 'Port O Connor', '', 'port-o-connor', '', ''),
(5557, 32, 4, 1, 'Wagoner', '', 'wagoner', '', ''),
(5558, 47, 3, 1, 'Hayti', '', 'hayti', '', ''),
(5559, 24, 2, 1, 'La Verkin', '', 'la-verkin', '', ''),
(5560, 61, 6, 1, 'Tiplersville', '', 'tiplersville', '', ''),
(5561, 50, 3, 1, 'Gray', '', 'gray', '', ''),
(5562, 10, 1, 1, 'Ceres', '', 'ceres', '', ''),
(5563, 10, 1, 1, 'Los Osos', '', 'los-osos', '', ''),
(5564, 45, 2, 1, 'Mesilla Park', '', 'mesilla-park', '', ''),
(5565, 9, 4, 1, 'Canutillo', '', 'canutillo', '', ''),
(5566, 10, 1, 1, 'Lennox', '', 'lennox', '', ''),
(5567, 51, 2, 1, 'Fernley', '', 'fernley', '', ''),
(5568, 10, 1, 1, 'Chualar', '', 'chualar', '', ''),
(5569, 14, 8, 1, 'Cedartown', '', 'cedartown', '', ''),
(5570, 10, 1, 1, 'Bell', '', 'bell', '', ''),
(5571, 9, 4, 1, 'Elsa', '', 'elsa', '', ''),
(5572, 22, 8, 1, 'Archdale', '', 'archdale', '', ''),
(5573, 20, 8, 1, 'Zolfo Springs', '', 'zolfo-springs', '', ''),
(5574, 61, 6, 1, 'Pontotoc', '', 'pontotoc', '', ''),
(5575, 47, 3, 1, 'Rolla', '', 'rolla', '', ''),
(5576, 61, 6, 1, 'Lucedale', '', 'lucedale', '', ''),
(5577, 56, 2, 1, 'Weiser', '', 'weiser', '', ''),
(5578, 24, 2, 1, 'Parowan', '', 'parowan', '', ''),
(5579, 20, 8, 1, 'Defuniak Springs', '', 'defuniak-springs', '', ''),
(5580, 22, 8, 1, 'Shannon', '', 'shannon', '', ''),
(5581, 9, 4, 1, 'Cookville', '', 'cookville', '', ''),
(5582, 11, 2, 1, 'San Luis', '', 'san-luis', '', ''),
(5583, 50, 3, 1, 'Westmoreland', '', 'westmoreland', '', ''),
(5584, 9, 4, 1, 'Spring Branch', '', 'spring-branch', '', ''),
(5585, 50, 3, 1, 'Eagleville', '', 'eagleville', '', ''),
(5586, 9, 4, 1, 'Muleshoe', '', 'muleshoe', '', ''),
(5587, 10, 1, 1, 'Northhollywood', '', 'northhollywood', '', ''),
(5588, 35, 5, 1, 'Davisburg', '', 'davisburg', '', ''),
(5589, 42, 5, 1, 'Silvis', '', 'silvis', '', ''),
(5590, 35, 5, 1, 'Coloma', '', 'coloma', '', ''),
(5591, 22, 8, 1, 'Beech Mountain', '', 'beech-mountain', '', ''),
(5592, 56, 2, 1, 'Lava Hot Springs', '', 'lava-hot-springs', '', ''),
(5593, 14, 8, 1, 'Comer', '', 'comer', '', ''),
(5594, 9, 4, 1, 'Comfort', '', 'comfort', '', ''),
(5595, 10, 1, 1, 'Arvin', '', 'arvin', '', ''),
(5596, 27, 8, 1, 'Hardeeville', '', 'hardeeville', '', ''),
(5597, 32, 4, 1, 'Hennessey', '', 'hennessey', '', ''),
(5598, 32, 4, 1, 'Blackwell', '', 'blackwell', '', ''),
(5599, 10, 1, 1, 'Trabuco Canyon', '', 'trabuco-canyon', '', ''),
(5600, 22, 8, 1, 'Wingate', '', 'wingate', '', ''),
(5601, 42, 5, 1, 'Atwood', '', 'atwood', '', ''),
(5602, 57, 3, 1, 'Waukee', '', 'waukee', '', ''),
(5603, 13, 9, 1, 'South Attleboro', '', 'south-attleboro', '', ''),
(5604, 10, 1, 1, 'Traver', '', 'traver', '', ''),
(5605, 51, 2, 1, 'Laughlin', '', 'laughlin', '', ''),
(5606, 10, 1, 1, 'Cool', '', 'cool', '', ''),
(5607, 55, 3, 1, 'Plains', '', 'plains', '', ''),
(5608, 10, 1, 1, 'Boulder Creek', '', 'boulder-creek', '', ''),
(5609, 57, 3, 1, 'Muscatine', '', 'muscatine', '', ''),
(5610, 9, 4, 1, 'Canadian', '', 'canadian', '', ''),
(5611, 10, 1, 1, 'Cameron Park', '', 'cameron-park', '', ''),
(5612, 60, 2, 1, 'Worland', '', 'worland', '', ''),
(5613, 10, 1, 1, 'Cayucos', '', 'cayucos', '', ''),
(5614, 20, 8, 1, 'The Villages', '', 'the-villages', '', ''),
(5615, 48, 6, 1, 'Saraland', '', 'saraland', '', ''),
(5616, 36, 5, 1, 'Iron Ridge', '', 'iron-ridge', '', ''),
(5617, 42, 5, 1, 'Rockton', '', 'rockton', '', ''),
(5618, 47, 3, 1, 'Moberly', '', 'moberly', '', ''),
(5619, 42, 5, 1, 'Willowbrook', '', 'willowbrook', '', ''),
(5620, 8, 7, 1, 'Ruby', '', 'ruby', '', ''),
(5621, 53, 2, 1, 'Cascade', '', 'cascade', '', ''),
(5622, 35, 5, 1, 'Sterling Hts', '', 'sterling-hts', '', ''),
(5623, 10, 1, 1, 'North Palm Springs', '', 'north-palm-springs', '', ''),
(5624, 27, 8, 1, 'Elloree', '', 'elloree', '', ''),
(5625, 42, 5, 1, 'Olympia Fields', '', 'olympia-fields', '', ''),
(5626, 36, 5, 1, 'Lake Tomahawk', '', 'lake-tomahawk', '', ''),
(5627, 32, 4, 1, 'Geary', '', 'geary', '', ''),
(5628, 8, 7, 1, 'New York City', '', 'new-york-city', '', ''),
(5629, 15, 8, 1, 'Brandywine', '', 'brandywine', '', ''),
(5630, 43, 2, 1, 'Highlands Ranch', '', 'highlands-ranch', '', ''),
(5631, 23, 9, 1, 'Kennebunk', '', 'kennebunk', '', ''),
(5632, 30, 5, 1, 'Parma', '', 'parma', '', ''),
(5633, 20, 8, 1, 'Ft. Lauderdale', '', 'ft-lauderdale-5633', '', ''),
(5634, 8, 7, 1, 'Clay', '', 'clay', '', ''),
(5635, 35, 5, 1, 'Center Line', '', 'center-line', '', ''),
(5636, 8, 7, 1, 'South Fallsburg', '', 'south-fallsburg', '', ''),
(5637, 32, 4, 1, 'Marlow', '', 'marlow', '', ''),
(5638, 10, 1, 1, 'Palos Verdes Peninsula', '', 'palos-verdes-peninsula', '', ''),
(5639, 14, 8, 1, 'Toccoa', '', 'toccoa', '', ''),
(5640, 8, 7, 1, 'Woodhaven', '', 'woodhaven', '', ''),
(5641, 44, 4, 1, 'Harvey', '', 'harvey', '', ''),
(5642, 12, 1, 1, 'Tukwila', '', 'tukwila', '', ''),
(5643, 10, 1, 1, 'Ripon', '', 'ripon', '', ''),
(5644, 21, 8, 1, 'Dunn Loring', '', 'dunn-loring', '', ''),
(5645, 17, 3, 1, 'Baxter', '', 'baxter', '', ''),
(5646, 26, 1, 1, 'Madras', '', 'madras', '', ''),
(5647, 23, 9, 1, 'West Paris', '', 'west-paris', '', ''),
(5648, 23, 9, 1, 'Milo', '', 'milo', '', ''),
(5649, 55, 3, 1, 'Palco', '', 'palco', '', ''),
(5650, 24, 2, 1, 'Nephi', '', 'nephi', '', ''),
(5651, 8, 7, 1, 'Stormville', '', 'stormville', '', ''),
(5652, 10, 1, 1, 'Silverado', '', 'silverado', '', ''),
(5653, 14, 8, 1, 'Midville', '', 'midville', '', ''),
(5654, 10, 1, 1, 'Los Altos Hills', '', 'los-altos-hills', '', ''),
(5655, 50, 3, 1, 'Townsend', '', 'townsend', '', ''),
(5656, 45, 2, 1, 'Corrales', '', 'corrales', '', ''),
(5657, 12, 1, 1, 'Graham', '', 'graham', '', ''),
(5658, 33, 8, 1, 'Berkeley Springs', '', 'berkeley-springs', '', ''),
(5659, 19, 9, 1, 'Campton', '', 'campton', '', ''),
(5660, 37, 6, 1, 'Tompkinsville', '', 'tompkinsville', '', ''),
(5661, 20, 8, 1, 'Polk City', '', 'polk-city', '', ''),
(5662, 9, 4, 1, 'Horseshoe Bay', '', 'horseshoe-bay', '', ''),
(5663, 30, 5, 1, 'Defiance', '', 'defiance', '', ''),
(5664, 16, 8, 1, 'Camden Wyoming', '', 'camden-wyoming', '', ''),
(5665, 19, 9, 1, 'Rye Beach', '', 'rye-beach', '', ''),
(5666, 53, 2, 1, 'Wolf Point', '', 'wolf-point', '', ''),
(5667, 8, 7, 1, 'Voorheesville', '', 'voorheesville', '', ''),
(5668, 44, 4, 1, 'Woodworth', '', 'woodworth', '', ''),
(5669, 57, 3, 1, 'Algona', '', 'algona', '', ''),
(5670, 21, 8, 1, 'Amelia Court House', '', 'amelia-court-house', '', ''),
(5671, 22, 8, 1, 'Lillington', '', 'lillington', '', ''),
(5672, 58, 3, 1, 'Neligh', '', 'neligh', '', ''),
(5673, 8, 7, 1, 'Tribes Hill', '', 'tribes-hill', '', ''),
(5674, 10, 1, 1, 'Arbuckle', '', 'arbuckle', '', ''),
(5675, 9, 4, 1, 'Archer City', '', 'archer-city', '', ''),
(5676, 31, 7, 1, 'Slippery Rock', '', 'slippery-rock', '', ''),
(5677, 26, 1, 1, 'Molalla', '', 'molalla', '', ''),
(5678, 30, 5, 1, 'Minster', '', 'minster', '', ''),
(5679, 31, 7, 1, 'Cheltenham', '', 'cheltenham', '', ''),
(5680, 52, 4, 1, 'Ashdown', '', 'ashdown', '', ''),
(5681, 57, 3, 1, 'Atlantic', '', 'atlantic', '', ''),
(5682, 8, 7, 1, 'Attica', '', 'attica', '', ''),
(5683, 8, 7, 1, 'Au Sable Forks', '', 'au-sable-forks', '', ''),
(5684, 21, 8, 1, 'Riner', '', 'riner', '', ''),
(5685, 9, 4, 1, 'Spicewood', '', 'spicewood', '', ''),
(5686, 36, 5, 1, 'Valders', '', 'valders', '', ''),
(5687, 47, 3, 1, 'Ava', '', 'ava', '', ''),
(5688, 52, 4, 1, 'Bald Knob', '', 'bald-knob', '', ''),
(5689, 57, 3, 1, 'Huxley', '', 'huxley', '', ''),
(5690, 14, 8, 1, 'Evans', '', 'evans', '', ''),
(5691, 52, 4, 1, 'Dardanelle', '', 'dardanelle', '', ''),
(5692, 20, 8, 1, 'Tavares', '', 'tavares', '', ''),
(5693, 22, 8, 1, 'Vass', '', 'vass', '', ''),
(5694, 37, 6, 1, 'Clay City', '', 'clay-city', '', ''),
(5695, 20, 8, 1, 'Belleair', '', 'belleair', '', ''),
(5696, 30, 5, 1, 'Saint Clairsville', '', 'saint-clairsville', '', ''),
(5697, 58, 3, 1, 'Benkelman', '', 'benkelman', '', ''),
(5698, 14, 8, 1, 'Marble Hill', '', 'marble-hill', '', ''),
(5699, 58, 3, 1, 'Dwight', '', 'dwight', '', ''),
(5700, 22, 8, 1, 'Advance', '', 'advance', '', ''),
(5701, 12, 1, 1, 'Wilbur', '', 'wilbur', '', ''),
(5702, 52, 4, 1, 'Pea Ridge', '', 'pea-ridge', '', ''),
(5703, 27, 8, 1, 'Bishopville', '', 'bishopville', '', ''),
(5704, 10, 1, 1, 'Pioneer', '', 'pioneer', '', ''),
(5705, 27, 8, 1, 'Loris', '', 'loris', '', ''),
(5706, 36, 5, 1, 'Suring', '', 'suring', '', ''),
(5707, 39, 5, 1, 'Hartford City', '', 'hartford-city', '', ''),
(5708, 27, 8, 1, 'Blackville', '', 'blackville', '', ''),
(5709, 13, 9, 1, 'Blandford', '', 'blandford', '', ''),
(5710, 17, 3, 1, 'Menahga', '', 'menahga', '', ''),
(5711, 44, 4, 1, 'Rayville', '', 'rayville', '', ''),
(5712, 9, 4, 1, 'Bonham', '', 'bonham', '', ''),
(5713, 10, 1, 1, 'Borrego Springs', '', 'borrego-springs', '', ''),
(5714, 21, 8, 1, 'Troutville', '', 'troutville', '', ''),
(5715, 31, 7, 1, 'Mountville', '', 'mountville', '', ''),
(5716, 31, 7, 1, 'Natrona Heights', '', 'natrona-heights', '', ''),
(5717, 57, 3, 1, 'Breda', '', 'breda', '', ''),
(5718, 17, 3, 1, 'Pequot Lakes', '', 'pequot-lakes', '', ''),
(5719, 48, 6, 1, 'Brewton', '', 'brewton', '', ''),
(5720, 47, 3, 1, 'Carl Junction', '', 'carl-junction', '', ''),
(5721, 22, 8, 1, 'Shallotte', '', 'shallotte', '', ''),
(5722, 10, 1, 1, 'Friant', '', 'friant', '', ''),
(5723, 49, 3, 1, 'Britton', '', 'britton', '', ''),
(5724, 47, 3, 1, 'Saint Catharine', '', 'saint-catharine', '', ''),
(5725, 8, 7, 1, 'Porter Corners', '', 'porter-corners', '', ''),
(5726, 17, 3, 1, 'Rush City', '', 'rush-city', '', ''),
(5727, 22, 8, 1, 'Browns Summit', '', 'browns-summit', '', ''),
(5728, 27, 8, 1, 'Awendaw', '', 'awendaw', '', ''),
(5729, 17, 3, 1, 'Mound', '', 'mound', '', ''),
(5730, 20, 8, 1, 'Miramar Beach', '', 'miramar-beach', '', ''),
(5731, 35, 5, 1, 'Cadillac', '', 'cadillac', '', ''),
(5732, 27, 8, 1, 'Okatie', '', 'okatie', '', ''),
(5733, 10, 1, 1, 'Shingle Springs', '', 'shingle-springs', '', ''),
(5734, 10, 1, 1, 'Camino', '', 'camino', '', ''),
(5735, 8, 7, 1, 'Canandaigua', '', 'canandaigua', '', ''),
(5736, 55, 3, 1, 'Caney', '', 'caney', '', ''),
(5737, 14, 8, 1, 'Sharpsburg', '', 'sharpsburg', '', ''),
(5738, 9, 4, 1, 'Coldspring', '', 'coldspring', '', ''),
(5739, 42, 5, 1, 'Carmi', '', 'carmi', '', ''),
(5740, 22, 8, 1, 'Olivia', '', 'olivia', '', ''),
(5741, 8, 7, 1, 'Catskill', '', 'catskill', '', ''),
(5742, 39, 5, 1, 'Elwood', '', 'elwood', '', ''),
(5743, 8, 7, 1, 'Cazenovia', '', 'cazenovia', '', ''),
(5744, 35, 5, 1, 'Sand Lake', '', 'sand-lake', '', ''),
(5745, 36, 5, 1, 'Onalaska', '', 'onalaska', '', ''),
(5746, 35, 5, 1, 'New Baltimore', '', 'new-baltimore', '', ''),
(5747, 8, 7, 1, 'Clayville', '', 'clayville', '', ''),
(5748, 57, 3, 1, 'Columbus Junction', '', 'columbus-junction', '', ''),
(5749, 23, 9, 1, 'Chebeague Island', '', 'chebeague-island', '', ''),
(5750, 48, 6, 1, 'Union Grove', '', 'union-grove', '', ''),
(5751, 61, 6, 1, 'Walls', '', 'walls', '', ''),
(5752, 52, 4, 1, 'Cherokee Village', '', 'cherokee-village', '', ''),
(5753, 15, 8, 1, 'Lusby', '', 'lusby', '', ''),
(5754, 27, 8, 1, 'Chesnee', '', 'chesnee', '', ''),
(5755, 31, 7, 1, 'Frazer', '', 'frazer', '', ''),
(5756, 8, 7, 1, 'Darien Center', '', 'darien-center', '', ''),
(5757, 22, 8, 1, 'Weldon', '', 'weldon', '', ''),
(5758, 9, 4, 1, 'Farwell', '', 'farwell', '', ''),
(5759, 55, 3, 1, 'Cimarron', '', 'cimarron', '', ''),
(5760, 55, 3, 1, 'Satanta', '', 'satanta', '', ''),
(5761, 20, 8, 1, 'Dunnellon', '', 'dunnellon', '', ''),
(5762, 27, 8, 1, 'Manning', '', 'manning', '', ''),
(5763, 57, 3, 1, 'Clarinda', '', 'clarinda', '', ''),
(5764, 10, 1, 1, 'Kelseyville', '', 'kelseyville', '', ''),
(5765, 33, 8, 1, 'Oceana', '', 'oceana', '', ''),
(5766, 8, 7, 1, 'Clifton Springs', '', 'clifton-springs', '', ''),
(5767, 31, 7, 1, 'Mill Hall', '', 'mill-hall', '', ''),
(5768, 14, 8, 1, 'Forsyth', '', 'forsyth', '', ''),
(5769, 22, 8, 1, 'Burgaw', '', 'burgaw', '', ''),
(5770, 55, 3, 1, 'Colby', '', 'colby', '', ''),
(5771, 27, 8, 1, 'Longs', '', 'longs', '', ''),
(5772, 27, 8, 1, 'Blythewood', '', 'blythewood', '', ''),
(5773, 30, 5, 1, 'Columbia Station', '', 'columbia-station', '', ''),
(5774, 31, 7, 1, 'Concordville', '', 'concordville', '', ''),
(5775, 20, 8, 1, 'Cooper City', '', 'cooper-city', '', ''),
(5776, 24, 2, 1, 'Magna', '', 'magna', '', ''),
(5777, 20, 8, 1, 'Placida', '', 'placida', '', ''),
(5778, 10, 1, 1, 'San Martin', '', 'san-martin', '', ''),
(5779, 43, 2, 1, 'Steamboat Springs', '', 'steamboat-springs', '', ''),
(5780, 57, 3, 1, 'Correctionville', '', 'correctionville', '', ''),
(5781, 57, 3, 1, 'Leon', '', 'leon', '', ''),
(5782, 57, 3, 1, 'Montezuma', '', 'montezuma', '', ''),
(5783, 39, 5, 1, 'Delphi', '', 'delphi', '', ''),
(5784, 30, 5, 1, 'Thornville', '', 'thornville', '', ''),
(5785, 39, 5, 1, 'Sellersburg', '', 'sellersburg', '', ''),
(5786, 42, 5, 1, 'Kilbourne', '', 'kilbourne', '', ''),
(5787, 33, 8, 1, 'Shepherdstown', '', 'shepherdstown', '', ''),
(5788, 57, 3, 1, 'Creston', '', 'creston', '', ''),
(5789, 15, 8, 1, 'Crofton', '', 'crofton', '', ''),
(5790, 22, 8, 1, 'Fuquay Varina', '', 'fuquay-varina', '', ''),
(5791, 37, 6, 1, 'London', '', 'london', '', ''),
(5792, 14, 8, 1, 'Colquitt', '', 'colquitt', '', ''),
(5793, 50, 3, 1, 'Fall Branch', '', 'fall-branch', '', ''),
(5794, 19, 9, 1, 'Francestown', '', 'francestown', '', ''),
(5795, 52, 4, 1, 'Wynne', '', 'wynne', '', ''),
(5796, 43, 2, 1, 'Basalt', '', 'basalt', '', ''),
(5797, 38, 9, 1, 'Killington', '', 'killington', '', ''),
(5798, 8, 7, 1, 'Ellicottville', '', 'ellicottville', '', ''),
(5799, 17, 3, 1, 'Taylors Falls', '', 'taylors-falls', '', ''),
(5800, 10, 1, 1, 'Lakeshore', '', 'lakeshore', '', ''),
(5801, 21, 8, 1, 'Mc Gaheysville', '', 'mc-gaheysville', '', ''),
(5802, 23, 9, 1, 'Kingfield', '', 'kingfield', '', ''),
(5803, 31, 7, 1, 'Union Dale', '', 'union-dale', '', ''),
(5804, 31, 7, 1, 'Kempton', '', 'kempton', '', ''),
(5805, 51, 2, 1, 'Stateline', '', 'stateline', '', ''),
(5806, 13, 9, 1, 'Westford', '', 'westford', '', ''),
(5807, 38, 9, 1, 'Newfane', '', 'newfane', '', ''),
(5808, 31, 7, 1, 'Shawnee On Delaware', '', 'shawnee-on-delaware', '', ''),
(5809, 8, 7, 1, 'Patterson', '', 'patterson', '', ''),
(5810, 23, 9, 1, 'Monson', '', 'monson', '', ''),
(5811, 36, 5, 1, 'Phelps', '', 'phelps', '', ''),
(5812, 34, 1, 1, 'Valdez', '', 'valdez', '', ''),
(5813, 45, 2, 1, 'Taos Ski Valley', '', 'taos-ski-valley', '', ''),
(5814, 20, 8, 1, 'Alafaya', '', 'alafaya', '', ''),
(5815, 10, 1, 1, 'Alpine Meadows', '', 'alpine-meadows', '', ''),
(5816, 31, 7, 1, 'Analomink', '', 'analomink', '', ''),
(5817, 35, 5, 1, 'Whitmore Lake', '', 'whitmore-lake', '', ''),
(5818, 34, 1, 1, 'Girdwood', '', 'girdwood', '', ''),
(5819, 34, 1, 1, 'Fort Richardson', '', 'fort-richardson', '', ''),
(5820, 45, 2, 1, 'Angel Fire', '', 'angel-fire', '', ''),
(5821, 19, 9, 1, 'Bartlett', '', 'bartlett', '', ''),
(5822, 19, 9, 1, 'Colebrook', '', 'colebrook', '', ''),
(5823, 31, 7, 1, 'Macungie', '', 'macungie', '', ''),
(5824, 8, 7, 1, 'West Chazy', '', 'west-chazy', '', ''),
(5825, 43, 2, 1, 'Red Feather Lakes', '', 'red-feather-lakes', '', ''),
(5826, 22, 8, 1, 'Banner Elk', '', 'banner-elk', '', ''),
(5827, 8, 7, 1, 'Highmount', '', 'highmount', '', ''),
(5828, 13, 9, 1, 'Charlemont', '', 'charlemont', '', ''),
(5829, 53, 2, 1, 'Wise River', '', 'wise-river', '', ''),
(5830, 60, 2, 1, 'Ten Sleep', '', 'ten-sleep', '', ''),
(5831, 23, 9, 1, 'Mars Hill', '', 'mars-hill', '', ''),
(5832, 19, 9, 1, 'Alton Bay', '', 'alton-bay', '', ''),
(5833, 35, 5, 1, 'Otsego', '', 'otsego', '', ''),
(5834, 24, 2, 1, 'Alta', '', 'alta', '', ''),
(5835, 27, 8, 1, 'Clemson', '', 'clemson', '', ''),
(5836, 52, 4, 1, 'Gamaliel', '', 'gamaliel', '', ''),
(5837, 36, 5, 1, 'Nekoosa', '', 'nekoosa', '', ''),
(5838, 9, 4, 1, 'New Caney', '', 'new-caney', '', ''),
(5839, 26, 1, 1, 'Shady Cove', '', 'shady-cove', '', ''),
(5840, 31, 7, 1, 'Stockertown', '', 'stockertown', '', ''),
(5841, 44, 4, 1, 'Cut Off', '', 'cut-off', '', ''),
(5842, 52, 4, 1, 'Bryant', '', 'bryant', '', ''),
(5843, 53, 2, 1, 'Absarokee', '', 'absarokee', '', ''),
(5844, 7, 7, 1, 'North Cape May', '', 'north-cape-may', '', ''),
(5845, 35, 5, 1, 'Hudsonville', '', 'hudsonville', '', ''),
(5846, 20, 8, 1, 'Palatka', '', 'palatka', '', ''),
(5847, 19, 9, 1, 'Weare', '', 'weare', '', ''),
(5848, 23, 9, 1, 'Caratunk', '', 'caratunk', '', ''),
(5849, 26, 1, 1, 'Blue River', '', 'blue-river', '', ''),
(5850, 22, 8, 1, 'Bryson City', '', 'bryson-city', '', ''),
(5851, 15, 8, 1, 'White Marsh', '', 'white-marsh', '', ''),
(5852, 20, 8, 1, 'Gibsonton', '', 'gibsonton', '', ''),
(5853, 34, 1, 1, 'Cooper Landing', '', 'cooper-landing', '', ''),
(5854, 34, 1, 1, 'North Pole', '', 'north-pole', '', ''),
(5855, 55, 3, 1, 'Arma', '', 'arma', '', ''),
(5856, 30, 5, 1, 'Kalida', '', 'kalida', '', ''),
(5857, 8, 7, 1, 'Fort Ann', '', 'fort-ann', '', ''),
(5858, 47, 3, 1, 'Imperial', '', 'imperial', '', ''),
(5859, 47, 3, 1, 'Eminence', '', 'eminence', '', ''),
(5860, 26, 1, 1, 'Maupin', '', 'maupin', '', ''),
(5861, 34, 1, 1, 'Chugiak', '', 'chugiak', '', ''),
(5862, 61, 6, 1, 'Horn Lake', '', 'horn-lake', '', ''),
(5863, 35, 5, 1, 'Newaygo', '', 'newaygo', '', ''),
(5864, 8, 7, 1, 'Burnt Hills', '', 'burnt-hills', '', ''),
(5865, 31, 7, 1, 'Rostraver', '', 'rostraver', '', ''),
(5866, 17, 3, 1, 'Ottertail', '', 'ottertail', '', ''),
(5867, 11, 2, 1, 'Page', '', 'page', '', ''),
(5868, 45, 2, 1, 'Elephant Butte', '', 'elephant-butte', '', ''),
(5869, 22, 8, 1, 'Todd', '', 'todd', '', ''),
(5870, 20, 8, 1, 'Neptune Beach', '', 'neptune-beach', '', ''),
(5871, 43, 2, 1, 'Ignacio', '', 'ignacio', '', ''),
(5872, 36, 5, 1, 'Niagara', '', 'niagara', '', ''),
(5873, 43, 2, 1, 'Cotopaxi', '', 'cotopaxi', '', ''),
(5874, 22, 8, 1, 'Troutman', '', 'troutman', '', ''),
(5875, 47, 3, 1, 'Lesterville', '', 'lesterville', '', ''),
(5876, 20, 8, 1, 'Laud Lakes', '', 'laud-lakes', '', ''),
(5877, 44, 4, 1, 'Prairieville', '', 'prairieville', '', ''),
(5878, 20, 8, 1, 'Bal Harbour', '', 'bal-harbour', '', ''),
(5879, 20, 8, 1, 'Green Cove Springs', '', 'green-cove-springs', '', ''),
(5880, 47, 3, 1, 'Gravois Mills', '', 'gravois-mills', '', ''),
(5881, 22, 8, 1, 'Wanchese', '', 'wanchese', '', ''),
(5882, 22, 8, 1, 'Moyock', '', 'moyock', '', ''),
(5883, 20, 8, 1, 'Summerland Key', '', 'summerland-key', '', ''),
(5884, 35, 5, 1, 'Maple City', '', 'maple-city', '', ''),
(5885, 27, 8, 1, 'Saint Helena Island', '', 'saint-helena-island', '', ''),
(5886, 39, 5, 1, 'North Webster', '', 'north-webster', '', ''),
(5887, 13, 9, 1, 'West Dennis', '', 'west-dennis', '', ''),
(5888, 52, 4, 1, 'Bull Shoals', '', 'bull-shoals', '', ''),
(5889, 47, 3, 1, 'Lampe', '', 'lampe', '', ''),
(5890, 20, 8, 1, 'Madeira Beach', '', 'madeira-beach', '', ''),
(5891, 44, 4, 1, 'Ville Platte', '', 'ville-platte', '', ''),
(5892, 44, 4, 1, 'Haughton', '', 'haughton', '', ''),
(5893, 31, 7, 1, 'Avoca', '', 'avoca', '', ''),
(5894, 31, 7, 1, 'E Stroudsburg', '', 'e-stroudsburg', '', ''),
(5895, 31, 7, 1, 'Folcroft', '', 'folcroft', '', ''),
(5896, 13, 9, 1, 'South Chatham', '', 'south-chatham', '', ''),
(5897, 7, 7, 1, 'Far Hills', '', 'far-hills', '', ''),
(5898, 12, 1, 1, 'Seatac', '', 'seatac', '', ''),
(5899, 17, 3, 1, 'Brooklyn Center', '', 'brooklyn-center', '', ''),
(5900, 47, 3, 1, 'Moscow Mills', '', 'moscow-mills', '', ''),
(5901, 31, 7, 1, 'Swiftwater', '', 'swiftwater', '', ''),
(5902, 47, 3, 1, 'Kirkwood', '', 'kirkwood', '', ''),
(5903, 15, 8, 1, 'Taneytown', '', 'taneytown', '', ''),
(5904, 21, 8, 1, 'Drewryville', '', 'drewryville', '', ''),
(5905, 9, 4, 1, 'Kirby', '', 'kirby', '', ''),
(5906, 44, 4, 1, 'Basile', '', 'basile', '', ''),
(5907, 7, 7, 1, 'Ewing', '', 'ewing', '', ''),
(5908, 48, 6, 1, 'Harpersville', '', 'harpersville', '', ''),
(5909, 36, 5, 1, 'Turtle Lake', '', 'turtle-lake', '', ''),
(5910, 28, 9, 1, 'Mapleville', '', 'mapleville', '', ''),
(5911, 21, 8, 1, 'Mount Jackson', '', 'mount-jackson', '', ''),
(5912, 20, 8, 1, 'Okeechobee', '', 'okeechobee', '', ''),
(5913, 9, 4, 1, 'Splendora', '', 'splendora', '', ''),
(5914, 42, 5, 1, 'Palos Hills', '', 'palos-hills', '', ''),
(5915, 13, 9, 1, 'Hopkinton', '', 'hopkinton', '', ''),
(5916, 14, 8, 1, 'Doraville', '', 'doraville', '', ''),
(5917, 37, 6, 1, 'Shepherdsville', '', 'shepherdsville', '', ''),
(5918, 43, 2, 1, 'Craig', '', 'craig', '', ''),
(5919, 30, 5, 1, 'Sheffield Village', '', 'sheffield-village', '', ''),
(5920, 30, 5, 1, 'North Jackson', '', 'north-jackson', '', ''),
(5921, 20, 8, 1, 'Medley', '', 'medley', '', ''),
(5922, 35, 5, 1, 'Hazel Park', '', 'hazel-park', '', ''),
(5923, 30, 5, 1, 'Warrensville Heights', '', 'warrensville-heights', '', ''),
(5924, 22, 8, 1, 'Spindale', '', 'spindale', '', ''),
(5925, 37, 6, 1, 'Walton', '', 'walton', '', ''),
(5926, 8, 7, 1, 'Cohoes', '', 'cohoes', '', ''),
(5927, 30, 5, 1, 'Bexley', '', 'bexley', '', ''),
(5928, 7, 7, 1, 'S Hackensack', '', 's-hackensack', '', ''),
(5929, 31, 7, 1, 'Essington', '', 'essington', '', ''),
(5930, 9, 4, 1, 'Plum', '', 'plum', '', ''),
(5931, 22, 8, 1, 'Plumtree', '', 'plumtree', '', ''),
(5932, 10, 1, 1, 'Rosemead', '', 'rosemead', '', ''),
(5933, 56, 2, 1, 'Rexburg', '', 'rexburg', '', ''),
(5934, 22, 8, 1, 'Bolivia', '', 'bolivia', '', ''),
(5935, 22, 8, 1, 'Roxboro', '', 'roxboro', '', ''),
(5936, 8, 7, 1, 'Carle Place', '', 'carle-place', '', ''),
(5937, 42, 5, 1, 'Orland Hills', '', 'orland-hills', '', ''),
(5938, 42, 5, 1, 'East Alton', '', 'east-alton', '', ''),
(5939, 17, 3, 1, 'Chaska', '', 'chaska', '', ''),
(5940, 8, 7, 1, 'Gansevoort', '', 'gansevoort', '', ''),
(5941, 42, 5, 1, 'Hoffman', '', 'hoffman', '', ''),
(5942, 55, 3, 1, 'Haysville', '', 'haysville', '', ''),
(5943, 10, 1, 1, 'Harbor City', '', 'harbor-city', '', ''),
(5944, 35, 5, 1, 'Plainwell', '', 'plainwell', '', ''),
(5945, 50, 3, 1, 'Luttrell', '', 'luttrell', '', ''),
(5946, 8, 7, 1, 'Savona', '', 'savona', '', ''),
(5947, 8, 7, 1, 'Painted Post', '', 'painted-post', '', ''),
(5948, 21, 8, 1, 'Round Hill', '', 'round-hill', '', ''),
(5949, 9, 4, 1, 'Bridge City', '', 'bridge-city', '', ''),
(6065, 36, 5, 1, 'Poynette', '', 'poynette', '', ''),
(5951, 52, 4, 1, 'Walnut Ridge', '', 'walnut-ridge', '', ''),
(5952, 20, 8, 1, 'South Daytona', '', 'south-daytona', '', ''),
(5953, 50, 3, 1, 'Cornersville', '', 'cornersville', '', ''),
(5954, 7, 7, 1, 'Morganville', '', 'morganville', '', ''),
(5955, 7, 7, 1, 'Pine Brook', '', 'pine-brook', '', ''),
(5956, 30, 5, 1, 'Upper Sandusky', '', 'upper-sandusky', '', ''),
(5957, 42, 5, 1, 'Round Lake Beach', '', 'round-lake-beach', '', ''),
(5958, 36, 5, 1, 'Washington Island', '', 'washington-island', '', ''),
(5959, 36, 5, 1, 'Baileys Harbor', '', 'baileys-harbor', '', ''),
(5960, 8, 7, 1, 'Rock Tavern', '', 'rock-tavern', '', ''),
(5961, 14, 8, 1, 'Hazlehurst', '', 'hazlehurst', '', ''),
(5962, 30, 5, 1, 'North Lima', '', 'north-lima', '', ''),
(5963, 30, 5, 1, 'Belpre', '', 'belpre', '', ''),
(5964, 48, 6, 1, 'Smiths', '', 'smiths', '', ''),
(5965, 22, 8, 1, 'Fletcher', '', 'fletcher', '', ''),
(5966, 30, 5, 1, 'Martins Ferry', '', 'martins-ferry', '', ''),
(5967, 44, 4, 1, 'Scott', '', 'scott', '', ''),
(5968, 42, 5, 1, 'New Baden', '', 'new-baden', '', ''),
(5969, 7, 7, 1, 'Vauxhall', '', 'vauxhall', '', ''),
(5970, 7, 7, 1, 'Cookstown', '', 'cookstown', '', ''),
(5971, 48, 6, 1, 'Mc Calla', '', 'mc-calla', '', ''),
(5972, 25, 10, 1, 'Paia', '', 'paia', '', ''),
(5973, 53, 2, 1, 'Cut Bank', '', 'cut-bank', '', ''),
(5974, 22, 8, 1, 'Cherryville', '', 'cherryville', '', ''),
(5975, 15, 8, 1, 'Oxon Hill', '', 'oxon-hill', '', ''),
(5976, 8, 7, 1, 'Montour Falls', '', 'montour-falls', '', ''),
(5977, 31, 7, 1, 'Edgemont', '', 'edgemont', '', ''),
(5978, 7, 7, 1, 'Roseland', '', 'roseland', '', ''),
(5979, 23, 9, 1, 'Shapleigh', '', 'shapleigh', '', ''),
(5980, 24, 2, 1, 'Roosevelt', '', 'roosevelt', '', ''),
(5981, 30, 5, 1, 'Miamitown', '', 'miamitown', '', ''),
(5982, 7, 7, 1, 'Marmora', '', 'marmora', '', ''),
(5983, 8, 7, 1, 'Greenfield Center', '', 'greenfield-center', '', ''),
(5984, 21, 8, 1, 'Stuarts Draft', '', 'stuarts-draft', '', ''),
(5985, 47, 3, 1, 'Ballwin', '', 'ballwin', '', ''),
(5986, 51, 2, 1, 'Pahrump', '', 'pahrump', '', ''),
(5987, 35, 5, 1, 'Ottawa Lake', '', 'ottawa-lake', '', ''),
(5988, 32, 4, 1, 'Purcell', '', 'purcell', '', ''),
(5989, 9, 4, 1, 'Cotulla', '', 'cotulla', '', ''),
(5990, 31, 7, 1, 'Blakeslee', '', 'blakeslee', '', ''),
(5991, 41, 9, 1, 'Ellington', '', 'ellington', '', ''),
(5992, 20, 8, 1, 'Lawtey', '', 'lawtey', '', ''),
(5993, 13, 9, 1, 'Athol', '', 'athol', '', ''),
(5994, 42, 5, 1, 'Lincolnwood', '', 'lincolnwood', '', ''),
(5995, 22, 8, 1, 'Roanoke Rapids', '', 'roanoke-rapids', '', ''),
(5996, 35, 5, 1, 'Westland', '', 'westland', '', ''),
(5997, 43, 2, 1, 'Beaver Creek', '', 'beaver-creek', '', ''),
(5998, 30, 5, 1, 'Brook Park', '', 'brook-park', '', ''),
(5999, 30, 5, 1, 'Green', '', 'green', '', ''),
(6000, 43, 2, 1, 'Gypsum', '', 'gypsum', '', ''),
(6001, 20, 8, 1, 'Tequesta', '', 'tequesta', '', ''),
(6002, 13, 9, 1, 'bourne', '', 'bourne', '', ''),
(6003, 42, 5, 1, 'Schiller Park', '', 'schiller-park', '', ''),
(6004, 50, 3, 1, 'La Vergne', '', 'la-vergne', '', ''),
(6005, 22, 8, 1, 'Arden', '', 'arden', '', ''),
(6006, 50, 3, 1, 'Blountville', '', 'blountville', '', ''),
(6007, 21, 8, 1, 'Sandston', '', 'sandston', '', ''),
(6008, 15, 8, 1, 'Linthicum', '', 'linthicum', '', ''),
(6009, 21, 8, 1, 'Hayes', '', 'hayes', '', ''),
(6010, 12, 1, 1, 'Shoreline', '', 'shoreline', '', ''),
(6011, 13, 9, 1, 'North Reading', '', 'north-reading', '', ''),
(6012, 36, 5, 1, 'Twin Lakes', '', 'twin-lakes', '', ''),
(6013, 31, 7, 1, 'Export', '', 'export', '', ''),
(6014, 15, 8, 1, 'Tilghman', '', 'tilghman', '', ''),
(6015, 28, 9, 1, 'Tiverton', '', 'tiverton', '', ''),
(6016, 31, 7, 1, 'Mount Lebanon', '', 'mount-lebanon', '', ''),
(6017, 23, 9, 1, 'Yarmouth', '', 'yarmouth', '', ''),
(6018, 24, 2, 1, 'Honeyville', '', 'honeyville', '', ''),
(6019, 32, 4, 1, 'Choctaw', '', 'choctaw', '', ''),
(6020, 10, 1, 1, 'Palos Verdes Peninsu', '', 'palos-verdes-peninsu', '', ''),
(6021, 10, 1, 1, 'Meadow Vista', '', 'meadow-vista', '', ''),
(6022, 50, 3, 1, 'Ooltewah', '', 'ooltewah', '', ''),
(6023, 9, 4, 1, 'Kingwood', '', 'kingwood', '', ''),
(6024, 35, 5, 1, 'Kingsford', '', 'kingsford', '', ''),
(6025, 20, 8, 1, 'Umatilla', '', 'umatilla', '', ''),
(6026, 8, 7, 1, 'Penfield', '', 'penfield', '', ''),
(6027, 30, 5, 1, 'Ravenna', '', 'ravenna', '', ''),
(6028, 7, 7, 1, 'Lindenwold', '', 'lindenwold', '', ''),
(6029, 30, 5, 1, 'Ludlow Falls', '', 'ludlow-falls', '', ''),
(6030, 25, 10, 1, 'Kaunakakai', '', 'kaunakakai', '', ''),
(6031, 36, 5, 1, 'Merrillan', '', 'merrillan', '', ''),
(6032, 8, 7, 1, 'Salamanca', '', 'salamanca', '', ''),
(6033, 31, 7, 1, 'Pipersville', '', 'pipersville', '', ''),
(6034, 15, 8, 1, 'Monkton', '', 'monkton', '', ''),
(6035, 8, 7, 1, 'Cold Spring Harbor', '', 'cold-spring-harbor', '', ''),
(6036, 21, 8, 1, 'White Post', '', 'white-post', '', ''),
(6037, 36, 5, 1, 'Cashton', '', 'cashton', '', ''),
(6038, 21, 8, 1, 'Sperryville', '', 'sperryville', '', ''),
(6039, 7, 7, 1, 'Avon By The Sea', '', 'avon-by-the-sea', '', ''),
(6040, 8, 7, 1, 'Saratoga Spgs', '', 'saratoga-spgs', '', ''),
(6041, 15, 8, 1, 'Rock Hall', '', 'rock-hall', '', ''),
(6042, 23, 9, 1, 'Belgrade Lakes', '', 'belgrade-lakes', '', ''),
(6043, 23, 9, 1, 'Bucksport', '', 'bucksport', '', ''),
(6044, 28, 9, 1, 'West Greenwich', '', 'west-greenwich', '', ''),
(6045, 31, 7, 1, 'Andreas', '', 'andreas', '', ''),
(6046, 13, 9, 1, 'Winchendon', '', 'winchendon', '', ''),
(6047, 52, 4, 1, 'Caddo Gap', '', 'caddo-gap', '', ''),
(6048, 23, 9, 1, 'Edgecomb', '', 'edgecomb', '', ''),
(6049, 43, 2, 1, 'Green Mountain Falls', '', 'green-mountain-falls', '', ''),
(6050, 23, 9, 1, 'Spruce Head', '', 'spruce-head', '', ''),
(6051, 7, 7, 1, 'New Egypt', '', 'new-egypt', '', ''),
(6052, 60, 2, 1, 'Jackson Hole', '', 'jackson-hole', '', ''),
(6053, 19, 9, 1, 'Lyme', '', 'lyme', '', ''),
(6054, 56, 2, 1, 'Priest River', '', 'priest-river', '', ''),
(6055, 34, 1, 1, 'Seward', '', 'seward', '', ''),
(6056, 23, 9, 1, 'Eliot', '', 'eliot', '', ''),
(6057, 31, 7, 1, 'Cooksburg', '', 'cooksburg', '', ''),
(6058, 19, 9, 1, 'Holderness', '', 'holderness', '', ''),
(6059, 36, 5, 1, 'Manawa', '', 'manawa', '', ''),
(6060, 31, 7, 1, 'Campbelltown', '', 'campbelltown', '', ''),
(6061, 15, 8, 1, 'Claiborne', '', 'claiborne', '', ''),
(6062, 42, 5, 1, 'Pinckneyville', '', 'pinckneyville', '', ''),
(6063, 19, 9, 1, 'Waterville Valley', '', 'waterville-valley', '', ''),
(6064, 9, 4, 1, 'College Sta', '', 'college-sta', '', ''),
(6066, 37, 6, 1, 'Burnside', '', 'burnside', '', ''),
(6067, 36, 5, 1, 'Saint Germain', '', 'saint-germain', '', ''),
(6068, 35, 5, 1, 'Twin Lake', '', 'twin-lake', '', ''),
(6069, 9, 4, 1, 'Buchanan Dam', '', 'buchanan-dam', '', ''),
(6070, 47, 3, 1, 'Cape Fair', '', 'cape-fair', '', ''),
(6071, 17, 3, 1, 'Tofte', '', 'tofte', '', ''),
(6072, 56, 2, 1, 'Priest Lake', '', 'priest-lake', '', ''),
(6073, 31, 7, 1, 'Pocono Pines', '', 'pocono-pines', '', ''),
(6074, 17, 3, 1, 'Wirt', '', 'wirt', '', ''),
(6075, 19, 9, 1, 'Mirror Lake', '', 'mirror-lake', '', ''),
(6076, 47, 3, 1, 'Shell Knob', '', 'shell-knob', '', ''),
(6077, 33, 8, 1, 'Terra Alta', '', 'terra-alta', '', ''),
(6078, 8, 7, 1, 'Henderson Harbor', '', 'henderson-harbor', '', ''),
(6079, 17, 3, 1, 'Deer River', '', 'deer-river', '', ''),
(6080, 17, 3, 1, 'Orr', '', 'orr', '', ''),
(6081, 56, 2, 1, 'Bayview', '', 'bayview', '', ''),
(6082, 36, 5, 1, 'Friendship', '', 'friendship', '', ''),
(6083, 36, 5, 1, 'Kiel', '', 'kiel', '', ''),
(6084, 9, 4, 1, 'Quinlan', '', 'quinlan', '', ''),
(6085, 17, 3, 1, 'Isle', '', 'isle', '', ''),
(6086, 12, 1, 1, 'Medical Lake', '', 'medical-lake', '', ''),
(6087, 31, 7, 1, 'Conneaut Lake', '', 'conneaut-lake', '', ''),
(6088, 35, 5, 1, 'Wetmore', '', 'wetmore', '', ''),
(6089, 36, 5, 1, 'Minong', '', 'minong', '', ''),
(6090, 17, 3, 1, 'Squaw Lake', '', 'squaw-lake', '', ''),
(6091, 36, 5, 1, 'Boulder Junction', '', 'boulder-junction', '', ''),
(6092, 12, 1, 1, 'Cheney', '', 'cheney', '', ''),
(6093, 17, 3, 1, 'Hines', '', 'hines', '', ''),
(6094, 36, 5, 1, 'Tomahawk', '', 'tomahawk', '', ''),
(6095, 36, 5, 1, 'Rib Lake', '', 'rib-lake', '', ''),
(6096, 8, 7, 1, 'Johnsburg', '', 'johnsburg', '', ''),
(6097, 17, 3, 1, 'Crane Lake', '', 'crane-lake', '', ''),
(6098, 36, 5, 1, 'Birchwood', '', 'birchwood', '', ''),
(6099, 52, 4, 1, 'Peel', '', 'peel', '', ''),
(6100, 35, 5, 1, 'Central Lake', '', 'central-lake', '', ''),
(6101, 35, 5, 1, 'Copper Harbor', '', 'copper-harbor', '', ''),
(6102, 10, 1, 1, 'Needles', '', 'needles', '', ''),
(6103, 50, 3, 1, 'Silver Point', '', 'silver-point', '', ''),
(6104, 37, 6, 1, 'Gilbertsville', '', 'gilbertsville', '', ''),
(6105, 9, 4, 1, 'Kingsland', '', 'kingsland', '', ''),
(6106, 42, 5, 1, 'Tonica', '', 'tonica', '', ''),
(6107, 9, 4, 1, 'Sunrise Beach', '', 'sunrise-beach', '', ''),
(6108, 48, 6, 1, 'Langston', '', 'langston', '', ''),
(6109, 34, 1, 1, 'Willow', '', 'willow', '', ''),
(6110, 36, 5, 1, 'Phillips', '', 'phillips', '', ''),
(6111, 17, 3, 1, 'Waubun', '', 'waubun', '', ''),
(6112, 8, 7, 1, 'East Otto', '', 'east-otto', '', ''),
(6113, 12, 1, 1, 'Tonasket', '', 'tonasket', '', ''),
(6114, 8, 7, 1, 'Lowman', '', 'lowman', '', ''),
(6115, 59, 3, 1, 'Binford', '', 'binford', '', ''),
(6116, 42, 5, 1, 'Whittington', '', 'whittington', '', ''),
(6117, 10, 1, 1, 'Earp', '', 'earp', '', ''),
(6118, 36, 5, 1, 'Mellen', '', 'mellen', '', ''),
(6119, 35, 5, 1, 'Belding', '', 'belding', '', ''),
(6120, 44, 4, 1, 'Heflin', '', 'heflin', '', ''),
(6121, 10, 1, 1, 'Shaver Lake', '', 'shaver-lake', '', ''),
(6122, 12, 1, 1, 'Loon Lake', '', 'loon-lake', '', ''),
(6123, 35, 5, 1, 'Channing', '', 'channing', '', ''),
(6124, 12, 1, 1, 'Eatonville', '', 'eatonville', '', ''),
(6125, 12, 1, 1, 'Sprague', '', 'sprague', '', ''),
(6126, 8, 7, 1, 'Swan Lake', '', 'swan-lake', '', ''),
(6127, 49, 3, 1, 'Pollock', '', 'pollock', '', ''),
(6139, 35, 5, 1, 'Gaylord', '', 'gaylord', '', ''),
(6140, 17, 3, 1, 'Duluth', '', 'duluth', '', ''),
(6141, 58, 3, 1, 'Elkhorn', '', 'elkhorn', '', ''),
(6142, 30, 5, 1, 'Warren', '', 'warren', '', ''),
(6143, 26, 1, 1, 'Astoria', '', 'astoria', '', ''),
(6144, 10, 1, 1, 'Monterey', '', 'monterey', '', ''),
(6145, 52, 4, 1, 'Benton', '', 'benton', '', ''),
(6146, 20, 8, 1, 'Spring Hill', '', 'spring-hill', '', ''),
(6147, 41, 9, 1, 'Norwalk', '', 'norwalk', '', ''),
(6148, 30, 5, 1, 'Milford', '', 'milford', '', ''),
(6149, 34, 0, 1, 'Skagway', '', 'skagway', '', ''),
(6150, 34, 0, 1, 'Scammon Bay', '', 'scammon-bay', '', ''),
(6151, 34, 0, 1, 'Shishmaref', '', 'shishmaref', '', ''),
(6152, 34, 0, 1, 'St Michael', '', 'st-michael', '', ''),
(6153, 34, 0, 1, 'Sutton', '', 'sutton-6153', '', ''),
(6154, 34, 0, 1, 'Two Rivers', '', 'two-rivers-6154', '', ''),
(6155, 34, 0, 1, 'Trapper Creek', '', 'trapper-creek', '', ''),
(6156, 34, 0, 1, 'Talkeetna', '', 'talkeetna', '', ''),
(6157, 34, 0, 1, 'Thorne Bay', '', 'thorne-bay', '', ''),
(6158, 34, 0, 1, 'Tok', '', 'tok', '', ''),
(6159, 34, 0, 1, 'Unalaska', '', 'unalaska', '', ''),
(6160, 34, 0, 1, 'Unalakleet', '', 'unalakleet', '', ''),
(6161, 34, 0, 1, 'Ward Cove', '', 'ward-cove', '', ''),
(6162, 34, 0, 1, 'Whittier', '', 'whittier-6162', '', ''),
(6163, 34, 0, 1, 'Wrangell', '', 'wrangell', '', ''),
(6164, 34, 0, 1, 'Yakutat', '', 'yakutat', '', ''),
(6165, 48, 0, 1, 'Salem', '', 'salem-6165', '', ''),
(6166, 48, 0, 1, 'Springville', '', 'springville-6166', '', ''),
(6167, 48, 0, 1, 'Sulligent', '', 'sulligent', '', ''),
(6168, 48, 0, 1, 'Sheffield', '', 'sheffield-6168', '', ''),
(6169, 48, 0, 1, 'Stevenson', '', 'stevenson-6169', '', ''),
(6170, 48, 0, 1, 'Sylvania', '', 'sylvania-6170', '', ''),
(6171, 48, 0, 1, 'Slocomb', '', 'slocomb', '', ''),
(6172, 48, 0, 1, 'Spanish Fort', '', 'spanish-fort', '', ''),
(6173, 48, 0, 1, 'Semmes', '', 'semmes', '', ''),
(6174, 48, 0, 1, 'Silverhill', '', 'silverhill', '', ''),
(6175, 48, 0, 1, 'Stockton', '', 'stockton-6175', '', ''),
(6176, 48, 0, 1, 'Trinity', '', 'trinity-6176', '', ''),
(6177, 48, 0, 1, 'Thorsby', '', 'thorsby', '', ''),
(6178, 48, 0, 1, 'Toxey', '', 'toxey', '', ''),
(6179, 48, 0, 1, 'Thomasville', '', 'thomasville-6179', '', ''),
(6180, 48, 0, 1, 'Tuscumbia', '', 'tuscumbia', '', ''),
(6181, 48, 0, 1, 'Troy', '', 'troy-6181', '', ''),
(6182, 48, 0, 1, 'Tallassee', '', 'tallassee', '', ''),
(6183, 48, 0, 1, 'Tuskegee Inst', '', 'tuskegee-inst', '', ''),
(6184, 48, 0, 1, 'Toney', '', 'toney', '', ''),
(6185, 48, 0, 1, 'Tibbie', '', 'tibbie', '', ''),
(6186, 48, 0, 1, 'Thomaston', '', 'thomaston-6186', '', ''),
(6187, 48, 0, 1, 'Tyler', '', 'tyler-6187', '', ''),
(6188, 48, 0, 1, 'Tanner', '', 'tanner', '', ''),
(6189, 48, 0, 1, 'Town Creek', '', 'town-creek', '', ''),
(6190, 48, 0, 1, 'Trafford', '', 'trafford-6190', '', ''),
(6191, 48, 0, 1, 'Tuskegee Institute', '', 'tuskegee-institute', '', ''),
(6192, 48, 0, 1, 'Uniontown', '', 'uniontown-6192', '', ''),
(6193, 48, 0, 1, 'Union Springs', '', 'union-springs-6193', '', ''),
(6194, 48, 0, 1, 'Uriah', '', 'uriah', '', ''),
(6195, 48, 0, 1, 'Verbena', '', 'verbena', '', ''),
(6196, 48, 0, 1, 'Vandiver', '', 'vandiver', '', ''),
(6197, 48, 0, 1, 'Vincent', '', 'vincent', '', ''),
(6198, 48, 0, 1, 'Vestavia Hills', '', 'vestavia-hills', '', ''),
(6199, 48, 0, 1, 'Vinegar Bend', '', 'vinegar-bend', '', ''),
(6200, 48, 0, 1, 'Valley Head', '', 'valley-head', '', ''),
(6201, 48, 0, 1, 'Vance', '', 'vance', '', ''),
(6202, 48, 0, 1, 'Valley Grande', '', 'valley-grande', '', ''),
(6203, 48, 0, 1, 'Vernon', '', 'vernon-6203', '', ''),
(6204, 48, 0, 1, 'Vinemont', '', 'vinemont', '', ''),
(6205, 48, 0, 1, 'Vredenburgh', '', 'vredenburgh', '', ''),
(6206, 48, 0, 1, 'Winfield', '', 'winfield-6206', '', ''),
(6207, 48, 0, 1, 'Woodstock', '', 'woodstock-6207', '', ''),
(6208, 48, 0, 1, 'Wilmer', '', 'wilmer', '', ''),
(6209, 48, 0, 1, 'West Blocton', '', 'west-blocton', '', ''),
(6210, 48, 0, 1, 'Woodland', '', 'woodland-6210', '', ''),
(6211, 48, 0, 1, 'Wedowee', '', 'wedowee', '', ''),
(6212, 48, 0, 1, 'Wadley', '', 'wadley-6212', '', ''),
(6213, 48, 0, 1, 'Wilsonville', '', 'wilsonville-6213', '', ''),
(6214, 48, 0, 1, 'Webb', '', 'webb', '', ''),
(6215, 48, 0, 1, 'Woodville', '', 'woodville-6215', '', ''),
(6216, 48, 0, 1, 'Wagarville', '', 'wagarville', '', ''),
(6217, 48, 0, 1, 'Warrior', '', 'warrior', '', ''),
(6218, 48, 0, 1, 'Wellington', '', 'wellington-6218', '', ''),
(6219, 48, 0, 1, 'Weaver', '', 'weaver', '', ''),
(6220, 48, 0, 1, 'Waterloo', '', 'waterloo-6220', '', ''),
(6221, 48, 0, 1, 'Wattsville', '', 'wattsville', '', ''),
(6222, 48, 0, 1, 'York', '', 'york-6222', '', ''),
(6223, 52, 0, 1, 'Sherwood', '', 'sherwood-6223', '', ''),
(6224, 52, 0, 1, 'Scranton', '', 'scranton-6224', '', ''),
(6225, 52, 0, 1, 'Star City', '', 'star-city', '', ''),
(6226, 52, 0, 1, 'Stephens', '', 'stephens', '', ''),
(6227, 52, 0, 1, 'Strong', '', 'strong', '', ''),
(6228, 52, 0, 1, 'Stamps', '', 'stamps', '', ''),
(6229, 52, 0, 1, 'Scott', '', 'scott-6229', '', ''),
(6230, 52, 0, 1, 'Sheridan', '', 'sheridan-6230', '', ''),
(6231, 52, 0, 1, 'Swifton', '', 'swifton', '', ''),
(6232, 52, 0, 1, 'Salem', '', 'salem-6232', '', ''),
(6233, 52, 0, 1, 'Saint Joe', '', 'saint-joe', '', ''),
(6234, 52, 0, 1, 'Shirley', '', 'shirley-6234', '', ''),
(6235, 52, 0, 1, 'Smithville', '', 'smithville-6235', '', ''),
(6236, 52, 0, 1, 'Saint Paul', '', 'saint-paul-6236', '', ''),
(6237, 52, 0, 1, 'Sulphur Springs', '', 'sulphur-springs-6237', '', ''),
(6238, 52, 0, 1, 'Taylor', '', 'taylor-6238', '', ''),
(6239, 52, 0, 1, 'Tillar', '', 'tillar', '', ''),
(6240, 52, 0, 1, 'Turrell', '', 'turrell', '', ''),
(6241, 52, 0, 1, 'Tontitown', '', 'tontitown', '', ''),
(6242, 52, 0, 1, 'Trumann', '', 'trumann', '', ''),
(6243, 52, 0, 1, 'Tuckerman', '', 'tuckerman', '', ''),
(6244, 52, 0, 1, 'Tyronza', '', 'tyronza', '', ''),
(6245, 52, 0, 1, 'Timbo', '', 'timbo', '', ''),
(6246, 52, 0, 1, 'Thornton', '', 'thornton', '', ''),
(6247, 52, 0, 1, 'Ulm', '', 'ulm', '', ''),
(6248, 52, 0, 1, 'Vilonia', '', 'vilonia', '', ''),
(6249, 52, 0, 1, 'Viola', '', 'viola', '', ''),
(6250, 52, 0, 1, 'Valley Springs', '', 'valley-springs', '', ''),
(6251, 52, 0, 1, 'Waldron', '', 'waldron', '', ''),
(6252, 52, 0, 1, 'Watson', '', 'watson', '', ''),
(6253, 52, 0, 1, 'Wrightsville', '', 'wrightsville-6253', '', ''),
(6254, 52, 0, 1, 'Warren', '', 'warren-6254', '', ''),
(6255, 52, 0, 1, 'Wheatley', '', 'wheatley', '', ''),
(6256, 52, 0, 1, 'Wilmot', '', 'wilmot', '', ''),
(6257, 52, 0, 1, 'Waldo', '', 'waldo-6257', '', ''),
(6258, 52, 0, 1, 'West Fork', '', 'west-fork', '', ''),
(6259, 52, 0, 1, 'Winslow', '', 'winslow-6259', '', ''),
(6260, 52, 0, 1, 'Washington', '', 'washington-6260', '', ''),
(6261, 52, 0, 1, 'White Hall', '', 'white-hall', '', ''),
(6262, 52, 0, 1, 'West Helena', '', 'west-helena', '', ''),
(6263, 52, 0, 1, 'Wabbaseka', '', 'wabbaseka', '', ''),
(6264, 52, 0, 1, 'Ward', '', 'ward', '', ''),
(6265, 52, 0, 1, 'Weiner', '', 'weiner', '', ''),
(6266, 52, 0, 1, 'Waldenburg', '', 'waldenburg', '', ''),
(6267, 52, 0, 1, 'Wickes', '', 'wickes', '', ''),
(6268, 52, 0, 1, 'Western Grove', '', 'western-grove', '', ''),
(6269, 52, 0, 1, 'Woodson', '', 'woodson', '', ''),
(6270, 52, 0, 1, 'Witts Springs', '', 'witts-springs', '', ''),
(6271, 52, 0, 1, 'Yellville', '', 'yellville', '', ''),
(6272, 52, 0, 1, 'Yorktown', '', 'yorktown-6272', '', ''),
(6273, 11, 0, 1, 'Tacna', '', 'tacna', '', ''),
(6274, 11, 0, 1, 'Tonopah', '', 'tonopah-6274', '', ''),
(6275, 11, 0, 1, 'Tonto Basin', '', 'tonto-basin', '', ''),
(6276, 11, 0, 1, 'Tombstone', '', 'tombstone', '', ''),
(6277, 11, 0, 1, 'Tubac', '', 'tubac', '', ''),
(6278, 11, 0, 1, 'Taylor', '', 'taylor-6278', '', ''),
(6279, 11, 0, 1, 'Tuba City', '', 'tuba-city', '', ''),
(6280, 11, 0, 1, 'Tortilla Flat', '', 'tortilla-flat', '', ''),
(6281, 11, 0, 1, 'Tumacacori', '', 'tumacacori', '', ''),
(6282, 11, 0, 1, 'Topock', '', 'topock', '', ''),
(6283, 11, 0, 1, 'Vail', '', 'vail-6283', '', ''),
(6284, 11, 0, 1, 'Window Rock', '', 'window-rock', '', ''),
(6285, 11, 0, 1, 'Williams', '', 'williams-6285', '', ''),
(6286, 11, 0, 1, 'Willow Beach', '', 'willow-beach', '', ''),
(6287, 11, 0, 1, 'Wenden', '', 'wenden', '', ''),
(6288, 11, 0, 1, 'Waddell', '', 'waddell', '', ''),
(6289, 11, 0, 1, 'Wikieup', '', 'wikieup', '', ''),
(6290, 11, 0, 1, 'White Mtn Lake', '', 'white-mtn-lake', '', ''),
(6291, 11, 0, 1, 'Winkelman', '', 'winkelman', '', ''),
(6292, 11, 0, 1, 'Why', '', 'why', '', ''),
(6293, 11, 0, 1, 'Wellton', '', 'wellton', '', ''),
(6294, 11, 0, 1, 'Whiteriver', '', 'whiteriver', '', ''),
(6295, 11, 0, 1, 'Young', '', 'young', '', ''),
(6296, 11, 0, 1, 'Youngtown', '', 'youngtown', '', ''),
(6297, 11, 0, 1, 'Yarnell', '', 'yarnell', '', ''),
(6298, 11, 0, 1, 'Yucca', '', 'yucca', '', ''),
(6299, 10, 0, 1, 'La Honda', '', 'la-honda', '', ''),
(6300, 10, 0, 1, 'Lafayette', '', 'lafayette-6300', '', ''),
(6301, 10, 0, 1, 'Laguna Woods', '', 'laguna-woods', '', ''),
(6302, 10, 0, 1, 'Lagunitas', '', 'lagunitas', '', ''),
(6303, 10, 0, 1, 'Lake Hughes', '', 'lake-hughes', '', ''),
(6304, 10, 0, 1, 'Lake Isabella', '', 'lake-isabella', '', ''),
(6305, 10, 0, 1, 'Lake View Ter', '', 'lake-view-ter', '', ''),
(6306, 10, 0, 1, 'Los Alamos', '', 'los-alamos-6306', '', ''),
(6307, 10, 0, 1, 'Laytonville', '', 'laytonville', '', ''),
(6308, 10, 0, 1, 'Landers', '', 'landers', '', ''),
(6309, 10, 0, 1, 'Loma Mar', '', 'loma-mar', '', ''),
(6310, 10, 0, 1, 'Lodi', '', 'lodi-6310', '', ''),
(6311, 10, 0, 1, 'Linden', '', 'linden-6311', '', ''),
(6312, 10, 0, 1, 'Lockeford', '', 'lockeford', '', ''),
(6313, 10, 0, 1, 'Lucerne Valley', '', 'lucerne-valley', '', ''),
(6314, 10, 0, 1, 'Lincoln', '', 'lincoln-6314', '', ''),
(6315, 10, 0, 1, 'Lytle Creek', '', 'lytle-creek', '', ''),
(6316, 10, 0, 1, 'Los Banos', '', 'los-banos', '', ''),
(6317, 10, 0, 1, 'Livingston', '', 'livingston-6317', '', ''),
(6318, 10, 0, 1, 'Littleriver', '', 'littleriver', '', ''),
(6319, 10, 0, 1, 'Lee Vining', '', 'lee-vining', '', ''),
(6320, 10, 0, 1, 'Likely', '', 'likely', '', ''),
(6321, 10, 0, 1, 'Leggett', '', 'leggett', '', ''),
(6322, 10, 0, 1, 'Lotus', '', 'lotus', '', ''),
(6323, 10, 0, 1, 'Lebec', '', 'lebec', '', ''),
(6324, 10, 0, 1, 'Lower Lake', '', 'lower-lake', '', ''),
(6325, 10, 0, 1, 'Lost Hills', '', 'lost-hills', '', ''),
(6326, 10, 0, 1, 'Loleta', '', 'loleta', '', ''),
(6327, 10, 0, 1, 'Lucerne', '', 'lucerne', '', ''),
(6328, 10, 0, 1, 'Loch Lomond', '', 'loch-lomond', '', ''),
(6329, 10, 0, 1, 'Lemoore Nas', '', 'lemoore-nas', '', ''),
(6330, 10, 0, 1, 'Ludlow', '', 'ludlow-6330', '', ''),
(6331, 10, 0, 1, 'Litchfield', '', 'litchfield-6331', '', ''),
(6332, 10, 0, 1, 'Springville', '', 'springville-6332', '', ''),
(6333, 10, 0, 1, 'San Simeon', '', 'san-simeon', '', ''),
(6334, 10, 0, 1, 'Santa Ynez', '', 'santa-ynez', '', ''),
(6335, 10, 0, 1, 'Selma', '', 'selma-6335', '', ''),
(6336, 10, 0, 1, 'San Luis Rey', '', 'san-luis-rey', '', ''),
(6337, 10, 0, 1, 'San Ysidro', '', 'san-ysidro', '', ''),
(6338, 10, 0, 1, 'Salton City', '', 'salton-city', '', ''),
(6339, 10, 0, 1, 'Trinidad', '', 'trinidad-6339', '', ''),
(6340, 10, 0, 1, 'Topanga', '', 'topanga', '', ''),
(6341, 10, 0, 1, 'Tomales', '', 'tomales', '', ''),
(6342, 10, 0, 1, 'Tahoe Vista', '', 'tahoe-vista', '', ''),
(6343, 10, 0, 1, 'Thousand Palms', '', 'thousand-palms', '', ''),
(6344, 10, 0, 1, 'Tranquillity', '', 'tranquillity', '', ''),
(6345, 10, 0, 1, 'Twin Bridges', '', 'twin-bridges', '', ''),
(6346, 10, 0, 1, 'Twain Harte', '', 'twain-harte', '', ''),
(6347, 10, 0, 1, 'Three Rivers', '', 'three-rivers-6347', '', ''),
(6348, 10, 0, 1, 'Tipton', '', 'tipton', '', ''),
(6349, 10, 0, 1, 'Travis Afb', '', 'travis-afb', '', ''),
(6350, 10, 0, 1, 'Tulelake', '', 'tulelake', '', ''),
(6351, 10, 0, 1, 'Tracy', '', 'tracy', '', ''),
(6352, 10, 0, 1, 'Thornton', '', 'thornton-6352', '', ''),
(6353, 10, 0, 1, 'Tres Pinos', '', 'tres-pinos', '', ''),
(6354, 10, 0, 1, 'Twin Peaks', '', 'twin-peaks', '', ''),
(6355, 10, 0, 1, 'Trona', '', 'trona', '', ''),
(6356, 10, 0, 1, 'Topaz', '', 'topaz', '', ''),
(6357, 10, 0, 1, 'Talmage', '', 'talmage', '', ''),
(6358, 10, 0, 1, 'The Sea Ranch', '', 'the-sea-ranch', '', ''),
(6359, 10, 0, 1, 'Universal City', '', 'universal-city-6359', '', ''),
(6360, 10, 0, 1, 'Union City', '', 'union-city-6360', '', ''),
(6361, 10, 0, 1, 'Upper Lake', '', 'upper-lake', '', ''),
(6362, 10, 0, 1, 'Volcano', '', 'volcano-6362', '', ''),
(6363, 10, 0, 1, 'Valley Springs', '', 'valley-springs-6363', '', ''),
(6364, 10, 0, 1, 'Venice', '', 'venice-6364', '', ''),
(6365, 10, 0, 1, 'Verdugo City', '', 'verdugo-city', '', ''),
(6366, 10, 0, 1, 'Vina', '', 'vina', '', ''),
(6367, 10, 0, 1, 'Valley Ford', '', 'valley-ford', '', ''),
(6368, 10, 0, 1, 'Vandenberg Afb', '', 'vandenberg-afb', '', ''),
(6369, 10, 0, 1, 'Vernalis', '', 'vernalis', '', ''),
(6370, 10, 0, 1, 'Victor', '', 'victor-6370', '', ''),
(6371, 10, 0, 1, 'Valley Center', '', 'valley-center', '', ''),
(6372, 10, 0, 1, 'Vernon', '', 'vernon-6372', '', ''),
(6373, 10, 0, 1, 'Willow Creek', '', 'willow-creek', '', ''),
(6374, 10, 0, 1, 'Westmorland', '', 'westmorland', '', ''),
(6375, 10, 0, 1, 'Wilmington', '', 'wilmington-6375', '', ''),
(6376, 10, 0, 1, 'Winton', '', 'winton', '', ''),
(6377, 10, 0, 1, 'Westminster', '', 'westminster-6377', '', ''),
(6378, 10, 0, 1, 'Winters', '', 'winters-6378', '', ''),
(6379, 10, 0, 1, 'Walnut Grove', '', 'walnut-grove-6379', '', ''),
(6380, 10, 0, 1, 'Wallace', '', 'wallace-6380', '', ''),
(6381, 10, 0, 1, 'West Point', '', 'west-point-6381', '', ''),
(6382, 10, 0, 1, 'Wheatland', '', 'wheatland-6382', '', ''),
(6383, 10, 0, 1, 'Weaverville', '', 'weaverville-6383', '', ''),
(6384, 10, 0, 1, 'Woodlake', '', 'woodlake', '', ''),
(6385, 10, 0, 1, 'Westley', '', 'westley', '', ''),
(6386, 10, 0, 1, 'Waterford', '', 'waterford-6386', '', ''),
(6387, 10, 0, 1, 'Weed', '', 'weed', '', ''),
(6388, 10, 0, 1, 'Woodside', '', 'woodside-6388', '', ''),
(6389, 10, 0, 1, 'Woodbridge', '', 'woodbridge-6389', '', ''),
(6390, 10, 0, 1, 'Winchester', '', 'winchester-6390', '', ''),
(6391, 10, 0, 1, 'Wofford Heights', '', 'wofford-heights', '', ''),
(6392, 10, 0, 1, 'Westwood', '', 'westwood-6392', '', ''),
(6393, 10, 0, 1, 'Whitethorn', '', 'whitethorn', '', ''),
(6394, 10, 0, 1, 'Weldon', '', 'weldon-6394', '', ''),
(6395, 10, 0, 1, 'Woodacre', '', 'woodacre', '', ''),
(6396, 10, 0, 1, 'Warner Springs', '', 'warner-springs', '', ''),
(6397, 10, 0, 1, 'Yolo', '', 'yolo', '', ''),
(6398, 10, 0, 1, 'Yermo', '', 'yermo', '', ''),
(6399, 43, 0, 1, 'Paonia', '', 'paonia', '', ''),
(6400, 43, 0, 1, 'Palmer Lake', '', 'palmer-lake', '', ''),
(6401, 43, 0, 1, 'Parker', '', 'parker-6401', '', ''),
(6402, 43, 0, 1, 'Peetz', '', 'peetz', '', ''),
(6403, 43, 0, 1, 'Penrose', '', 'penrose', '', ''),
(6404, 43, 0, 1, 'Pitkin', '', 'pitkin', '', ''),
(6405, 43, 0, 1, 'Poncha Springs', '', 'poncha-springs', '', ''),
(6406, 43, 0, 1, 'Pierce', '', 'pierce-6406', '', ''),
(6407, 43, 0, 1, 'Romeo', '', 'romeo-6407', '', ''),
(6408, 43, 0, 1, 'Rico', '', 'rico', '', ''),
(6409, 43, 0, 1, 'Rollinsville', '', 'rollinsville', '', ''),
(6410, 43, 0, 1, 'Rand', '', 'rand', '', ''),
(6411, 43, 0, 1, 'Rush', '', 'rush', '', ''),
(6412, 43, 0, 1, 'Redstone', '', 'redstone', '', ''),
(6413, 43, 0, 1, 'Red Cliff', '', 'red-cliff', '', ''),
(6414, 43, 0, 1, 'Red Feather Lks', '', 'red-feather-lks', '', ''),
(6415, 43, 0, 1, 'Ridgway', '', 'ridgway-6415', '', ''),
(6416, 43, 0, 1, 'Rocky Ford', '', 'rocky-ford', '', ''),
(6417, 43, 0, 1, 'Rangely', '', 'rangely', '', ''),
(6418, 43, 0, 1, 'Rye', '', 'rye-6418', '', ''),
(6419, 43, 0, 1, 'Superior', '', 'superior-6419', '', ''),
(6420, 43, 0, 1, 'Sheridan', '', 'sheridan-6420', '', ''),
(6421, 43, 0, 1, 'Springfield', '', 'springfield-6421', '', ''),
(6422, 43, 0, 1, 'Silver Cliff', '', 'silver-cliff', '', ''),
(6423, 43, 0, 1, 'San Luis', '', 'san-luis-6423', '', ''),
(6424, 43, 0, 1, 'Somerset', '', 'somerset-6424', '', ''),
(6425, 43, 0, 1, 'Sedalia', '', 'sedalia-6425', '', ''),
(6426, 43, 0, 1, 'Silt', '', 'silt', '', ''),
(6427, 43, 0, 1, 'Simla', '', 'simla', '', ''),
(6428, 43, 0, 1, 'Stratton', '', 'stratton', '', ''),
(6429, 43, 0, 1, 'Sterling', '', 'sterling-6429', '', ''),
(6430, 43, 0, 1, 'Slater', '', 'slater', '', ''),
(6431, 43, 0, 1, 'Swink', '', 'swink', '', ''),
(6432, 43, 0, 1, 'Steamboat Spgs', '', 'steamboat-spgs', '', ''),
(6433, 43, 0, 1, 'Silverton', '', 'silverton-6433', '', ''),
(6434, 43, 0, 1, 'South Fork', '', 'south-fork', '', ''),
(6435, 43, 0, 1, 'Snowmass', '', 'snowmass', '', ''),
(6436, 43, 0, 1, 'Sedgwick', '', 'sedgwick', '', ''),
(6437, 43, 0, 1, 'Saguache', '', 'saguache', '', ''),
(6438, 43, 0, 1, 'Sargents', '', 'sargents', '', ''),
(6439, 43, 0, 1, 'Severance', '', 'severance', '', ''),
(6440, 43, 0, 1, 'Stoneham', '', 'stoneham-6440', '', ''),
(6441, 43, 0, 1, 'Thornton', '', 'thornton-6441', '', ''),
(6442, 43, 0, 1, 'Tabernash', '', 'tabernash', '', ''),
(6443, 43, 0, 1, 'Twin Lakes', '', 'twin-lakes-6443', '', ''),
(6444, 43, 0, 1, 'Timnath', '', 'timnath', '', ''),
(6445, 43, 0, 1, 'Towaoc', '', 'towaoc', '', ''),
(6446, 43, 0, 1, 'Usaf Academy', '', 'usaf-academy', '', ''),
(6447, 43, 0, 1, 'Villa Grove', '', 'villa-grove-6447', '', ''),
(6448, 43, 0, 1, 'Westminster', '', 'westminster-6448', '', ''),
(6449, 43, 0, 1, 'Westcliffe', '', 'westcliffe', '', ''),
(6450, 43, 0, 1, 'Ward', '', 'ward-6450', '', ''),
(6451, 43, 0, 1, 'Watkins', '', 'watkins', '', ''),
(6452, 43, 0, 1, 'Walsh', '', 'walsh', '', ''),
(6453, 43, 0, 1, 'Wetmore', '', 'wetmore-6453', '', ''),
(6454, 43, 0, 1, 'Winter Park', '', 'winter-park-6454', '', ''),
(6455, 43, 0, 1, 'Walden', '', 'walden-6455', '', ''),
(6456, 43, 0, 1, 'Wolcott', '', 'wolcott', '', ''),
(6457, 43, 0, 1, 'Wellington', '', 'wellington-6457', '', ''),
(6458, 43, 0, 1, 'Windsor', '', 'windsor-6458', '', ''),
(6459, 43, 0, 1, 'Weldona', '', 'weldona', '', ''),
(6460, 43, 0, 1, 'Wiggins', '', 'wiggins', '', ''),
(6461, 43, 0, 1, 'Whitewater', '', 'whitewater-6461', '', ''),
(6462, 43, 0, 1, 'Wiley', '', 'wiley', '', ''),
(6463, 43, 0, 1, 'Woody Creek', '', 'woody-creek', '', ''),
(6464, 43, 0, 1, 'Wray', '', 'wray', '', ''),
(6465, 43, 0, 1, 'Weston', '', 'weston-6465', '', ''),
(6466, 43, 0, 1, 'Yampa', '', 'yampa', '', ''),
(6467, 43, 0, 1, 'Yuma', '', 'yuma-6467', '', ''),
(6468, 43, 0, 1, 'Yoder', '', 'yoder', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(6469, 41, 0, 1, 'Wolcott', '', 'wolcott-6469', '', ''),
(6470, 41, 0, 1, 'Woodbridge', '', 'woodbridge-6470', '', ''),
(6471, 41, 0, 1, 'Winsted', '', 'winsted-6471', '', ''),
(6472, 41, 0, 1, 'Weston', '', 'weston-6472', '', ''),
(6473, 41, 0, 1, 'Windsor', '', 'windsor-6473', '', ''),
(6474, 41, 0, 1, 'West Willington', '', 'west-willington', '', ''),
(6475, 41, 0, 1, 'Waterford', '', 'waterford-6475', '', ''),
(6476, 41, 0, 1, 'Westbrook', '', 'westbrook-6476', '', ''),
(6477, 41, 0, 1, 'Washington Depot', '', 'washington-depot', '', ''),
(6478, 41, 0, 1, 'Watertown', '', 'watertown-6478', '', ''),
(6479, 41, 0, 1, 'Woodbury', '', 'woodbury-6479', '', ''),
(6480, 16, 0, 1, 'Yorklyn', '', 'yorklyn', '', ''),
(6481, 20, 0, 1, 'Tavernier', '', 'tavernier', '', ''),
(6482, 20, 0, 1, 'Tyndall Afb', '', 'tyndall-afb', '', ''),
(6483, 20, 0, 1, 'Treasure Island', '', 'treasure-island', '', ''),
(6484, 20, 0, 1, 'Tallevast', '', 'tallevast', '', ''),
(6485, 20, 0, 1, 'Trenton', '', 'trenton-6485', '', ''),
(6486, 20, 0, 1, 'Tangerine', '', 'tangerine', '', ''),
(6487, 20, 0, 1, 'Virginia Gardens', '', 'virginia-gardens', '', ''),
(6488, 20, 0, 1, 'Valparaiso', '', 'valparaiso-6488', '', ''),
(6489, 20, 0, 1, 'Vernon', '', 'vernon-6489', '', ''),
(6490, 20, 0, 1, 'Wewahitchka', '', 'wewahitchka', '', ''),
(6491, 20, 0, 1, 'Walnut Hill', '', 'walnut-hill', '', ''),
(6492, 20, 0, 1, 'Wildwood', '', 'wildwood-6492', '', ''),
(6493, 20, 0, 1, 'Windermere', '', 'windermere', '', ''),
(6494, 20, 0, 1, 'Weeki Wachee', '', 'weeki-wachee', '', ''),
(6495, 20, 0, 1, 'Westville', '', 'westville-6495', '', ''),
(6496, 20, 0, 1, 'White Springs', '', 'white-springs', '', ''),
(6497, 20, 0, 1, 'Williston', '', 'williston-6497', '', ''),
(6498, 20, 0, 1, 'Welaka', '', 'welaka', '', ''),
(6499, 20, 0, 1, 'Webster', '', 'webster-6499', '', ''),
(6500, 20, 0, 1, 'West Miami', '', 'west-miami', '', ''),
(6501, 20, 0, 1, 'Woodville', '', 'woodville-6501', '', ''),
(6502, 20, 0, 1, 'Wauchula', '', 'wauchula', '', ''),
(6503, 20, 0, 1, 'Wausau', '', 'wausau-6503', '', ''),
(6504, 20, 0, 1, 'Wellborn', '', 'wellborn', '', ''),
(6505, 20, 0, 1, 'Yankeetown', '', 'yankeetown', '', ''),
(6506, 20, 0, 1, 'Youngstown', '', 'youngstown-6506', '', ''),
(6507, 20, 0, 1, 'Yalaha', '', 'yalaha', '', ''),
(6508, 20, 0, 1, 'Zellwood', '', 'zellwood', '', ''),
(6509, 14, 0, 1, 'Saint Marys', '', 'saint-marys-6509', '', ''),
(6510, 14, 0, 1, 'Screven', '', 'screven', '', ''),
(6511, 14, 0, 1, 'Saint George', '', 'saint-george-6511', '', ''),
(6512, 14, 0, 1, 'Sparks', '', 'sparks-6512', '', ''),
(6513, 14, 0, 1, 'Sale City', '', 'sale-city', '', ''),
(6514, 14, 0, 1, 'Sycamore', '', 'sycamore-6514', '', ''),
(6515, 14, 0, 1, 'Shiloh', '', 'shiloh', '', ''),
(6516, 14, 0, 1, 'Sasser', '', 'sasser', '', ''),
(6517, 14, 0, 1, 'Shellman', '', 'shellman', '', ''),
(6518, 14, 0, 1, 'Trion', '', 'trion', '', ''),
(6519, 14, 0, 1, 'Thunderbolt', '', 'thunderbolt', '', ''),
(6520, 14, 0, 1, 'Taylorsville', '', 'taylorsville-6520', '', ''),
(6521, 14, 0, 1, 'Temple', '', 'temple-6521', '', ''),
(6522, 14, 0, 1, 'Trenton', '', 'trenton-6522', '', ''),
(6523, 14, 0, 1, 'Tyrone', '', 'tyrone', '', ''),
(6524, 14, 0, 1, 'Twin City', '', 'twin-city', '', ''),
(6525, 14, 0, 1, 'Tate', '', 'tate', '', ''),
(6526, 14, 0, 1, 'Talbotton', '', 'talbotton', '', ''),
(6527, 14, 0, 1, 'Tignall', '', 'tignall', '', ''),
(6528, 14, 0, 1, 'Toccoa Falls', '', 'toccoa-falls', '', ''),
(6529, 14, 0, 1, 'Talking Rock', '', 'talking-rock', '', ''),
(6530, 14, 0, 1, 'Toomsboro', '', 'toomsboro', '', ''),
(6531, 14, 0, 1, 'Tennille', '', 'tennille', '', ''),
(6532, 14, 0, 1, 'Tunnel Hill', '', 'tunnel-hill', '', ''),
(6533, 14, 0, 1, 'Tallulah Falls', '', 'tallulah-falls', '', ''),
(6534, 14, 0, 1, 'Townsend', '', 'townsend-6534', '', ''),
(6535, 14, 0, 1, 'Tallapoosa', '', 'tallapoosa', '', ''),
(6536, 14, 0, 1, 'Tennga', '', 'tennga', '', ''),
(6537, 14, 0, 1, 'Talmo', '', 'talmo', '', ''),
(6538, 14, 0, 1, 'Turnerville', '', 'turnerville', '', ''),
(6539, 14, 0, 1, 'Unadilla', '', 'unadilla-6539', '', ''),
(6540, 14, 0, 1, 'Union City', '', 'union-city-6540', '', ''),
(6541, 14, 0, 1, 'Uvalda', '', 'uvalda', '', ''),
(6542, 14, 0, 1, 'Union Point', '', 'union-point', '', ''),
(6543, 14, 0, 1, 'Upatoi', '', 'upatoi', '', ''),
(6544, 14, 0, 1, 'Vienna', '', 'vienna-6544', '', ''),
(6545, 14, 0, 1, 'White', '', 'white', '', ''),
(6546, 14, 0, 1, 'Waverly', '', 'waverly-6546', '', ''),
(6547, 14, 0, 1, 'Whitesburg', '', 'whitesburg', '', ''),
(6548, 14, 0, 1, 'Woodbine', '', 'woodbine-6548', '', ''),
(6549, 14, 0, 1, 'Waynesboro', '', 'waynesboro-6549', '', ''),
(6550, 14, 0, 1, 'Willacoochee', '', 'willacoochee', '', ''),
(6551, 14, 0, 1, 'Waynesville', '', 'waynesville-6551', '', ''),
(6552, 14, 0, 1, 'Waleska', '', 'waleska', '', ''),
(6553, 14, 0, 1, 'West Green', '', 'west-green', '', ''),
(6554, 14, 0, 1, 'Winston', '', 'winston', '', ''),
(6555, 14, 0, 1, 'Washington', '', 'washington-6555', '', ''),
(6556, 14, 0, 1, 'Warrenton', '', 'warrenton-6556', '', ''),
(6557, 14, 0, 1, 'West Point', '', 'west-point-6557', '', ''),
(6558, 14, 0, 1, 'Warthen', '', 'warthen', '', ''),
(6559, 14, 0, 1, 'Warm Springs', '', 'warm-springs', '', ''),
(6560, 14, 0, 1, 'Williamson', '', 'williamson', '', ''),
(6561, 14, 0, 1, 'Wrightsville', '', 'wrightsville-6561', '', ''),
(6562, 14, 0, 1, 'Woodbury', '', 'woodbury-6562', '', ''),
(6563, 14, 0, 1, 'Waco', '', 'waco-6563', '', ''),
(6564, 14, 0, 1, 'Waverly Hall', '', 'waverly-hall', '', ''),
(6565, 14, 0, 1, 'White Plains', '', 'white-plains-6565', '', ''),
(6566, 14, 0, 1, 'Wrens', '', 'wrens', '', ''),
(6567, 14, 0, 1, 'Wiley', '', 'wiley-6567', '', ''),
(6568, 14, 0, 1, 'Wildwood', '', 'wildwood-6568', '', ''),
(6569, 14, 0, 1, 'White Oak', '', 'white-oak-6569', '', ''),
(6570, 14, 0, 1, 'Whigham', '', 'whigham', '', ''),
(6571, 14, 0, 1, 'Young Harris', '', 'young-harris', '', ''),
(6572, 14, 0, 1, 'Yatesville', '', 'yatesville', '', ''),
(6573, 25, 0, 1, 'Pearl Harbor', '', 'pearl-harbor', '', ''),
(6574, 25, 0, 1, 'Papaikou', '', 'papaikou', '', ''),
(6575, 25, 0, 1, 'Princeville', '', 'princeville', '', ''),
(6576, 25, 0, 1, 'Waimea', '', 'waimea', '', ''),
(6577, 25, 0, 1, 'Waianae', '', 'waianae', '', ''),
(6578, 25, 0, 1, 'Waimanalo', '', 'waimanalo', '', ''),
(6579, 57, 0, 1, 'Underwood', '', 'underwood', '', ''),
(6580, 57, 0, 1, 'Ute', '', 'ute', '', ''),
(6581, 57, 0, 1, 'Victor', '', 'victor-6581', '', ''),
(6582, 57, 0, 1, 'Van Horne', '', 'van-horne', '', ''),
(6583, 57, 0, 1, 'Vinton', '', 'vinton-6583', '', ''),
(6584, 57, 0, 1, 'Ventura', '', 'ventura-6584', '', ''),
(6585, 57, 0, 1, 'Vail', '', 'vail-6585', '', ''),
(6586, 57, 0, 1, 'Vincent', '', 'vincent-6586', '', ''),
(6587, 57, 0, 1, 'Waukon', '', 'waukon', '', ''),
(6588, 57, 0, 1, 'Waterville', '', 'waterville-6588', '', ''),
(6589, 57, 0, 1, 'Williamsburg', '', 'williamsburg-6589', '', ''),
(6590, 57, 0, 1, 'Walford', '', 'walford', '', ''),
(6591, 57, 0, 1, 'Washburn', '', 'washburn-6591', '', ''),
(6592, 57, 0, 1, 'Winfield', '', 'winfield-6592', '', ''),
(6593, 57, 0, 1, 'Wayland', '', 'wayland-6593', '', ''),
(6594, 57, 0, 1, 'Woodbine', '', 'woodbine-6594', '', ''),
(6595, 57, 0, 1, 'Williams', '', 'williams-6595', '', ''),
(6596, 57, 0, 1, 'Woden', '', 'woden', '', ''),
(6597, 57, 0, 1, 'Waverly', '', 'waverly-6597', '', ''),
(6598, 57, 0, 1, 'Whiting', '', 'whiting', '', ''),
(6599, 57, 0, 1, 'Winthrop', '', 'winthrop-6599', '', ''),
(6600, 57, 0, 1, 'Wilton', '', 'wilton-6600', '', ''),
(6601, 57, 0, 1, 'West Liberty', '', 'west-liberty-6601', '', ''),
(6602, 57, 0, 1, 'Wiota', '', 'wiota', '', ''),
(6603, 57, 0, 1, 'Woodburn', '', 'woodburn-6603', '', ''),
(6604, 57, 0, 1, 'Webb', '', 'webb-6604', '', ''),
(6605, 57, 0, 1, 'Welton', '', 'welton', '', ''),
(6606, 57, 0, 1, 'Wheatland', '', 'wheatland-6606', '', ''),
(6607, 57, 0, 1, 'Westside', '', 'westside', '', ''),
(6608, 57, 0, 1, 'Woodward', '', 'woodward-6608', '', ''),
(6609, 57, 0, 1, 'Weldon', '', 'weldon-6609', '', ''),
(6610, 57, 0, 1, 'Walnut', '', 'walnut-6610', '', ''),
(6611, 57, 0, 1, 'Worthington', '', 'worthington-6611', '', ''),
(6612, 57, 0, 1, 'Wall Lake', '', 'wall-lake', '', ''),
(6613, 57, 0, 1, 'Walcott', '', 'walcott', '', ''),
(6614, 57, 0, 1, 'Wallingford', '', 'wallingford-6614', '', ''),
(6615, 57, 0, 1, 'Waucoma', '', 'waucoma', '', ''),
(6616, 57, 0, 1, 'Westgate', '', 'westgate', '', ''),
(6617, 57, 0, 1, 'Wadena', '', 'wadena', '', ''),
(6618, 57, 0, 1, 'West Union', '', 'west-union-6618', '', ''),
(6619, 57, 0, 1, 'Wellsburg', '', 'wellsburg-6619', '', ''),
(6620, 57, 0, 1, 'Westphalia', '', 'westphalia', '', ''),
(6621, 57, 0, 1, 'Williamson', '', 'williamson-6621', '', ''),
(6622, 57, 0, 1, 'Wapello', '', 'wapello', '', ''),
(6623, 57, 0, 1, 'Walker', '', 'walker', '', ''),
(6624, 57, 0, 1, 'Washington', '', 'washington-6624', '', ''),
(6625, 57, 0, 1, 'Wellman', '', 'wellman', '', ''),
(6626, 57, 0, 1, 'Wever', '', 'wever', '', ''),
(6627, 57, 0, 1, 'West Point', '', 'west-point-6627', '', ''),
(6628, 57, 0, 1, 'Wesley', '', 'wesley', '', ''),
(6629, 57, 0, 1, 'Whittemore', '', 'whittemore', '', ''),
(6630, 57, 0, 1, 'What Cheer', '', 'what-cheer', '', ''),
(6631, 57, 0, 1, 'Wyoming', '', 'wyoming-6631', '', ''),
(6632, 57, 0, 1, 'Woolstock', '', 'woolstock', '', ''),
(6633, 57, 0, 1, 'Yarmouth', '', 'yarmouth-6633', '', ''),
(6634, 57, 0, 1, 'Yale', '', 'yale', '', ''),
(6635, 57, 0, 1, 'Zwingle', '', 'zwingle', '', ''),
(6636, 57, 0, 1, 'Zearing', '', 'zearing', '', ''),
(6637, 56, 0, 1, 'Salmon', '', 'salmon', '', ''),
(6638, 56, 0, 1, 'Sagle', '', 'sagle', '', ''),
(6639, 56, 0, 1, 'St Maries', '', 'st-maries', '', ''),
(6640, 56, 0, 1, 'Springfield', '', 'springfield-6640', '', ''),
(6641, 56, 0, 1, 'Stanley', '', 'stanley-6641', '', ''),
(6642, 56, 0, 1, 'Shoshone', '', 'shoshone', '', ''),
(6643, 56, 0, 1, 'Sun Valley', '', 'sun-valley-6643', '', ''),
(6644, 56, 0, 1, 'Spencer', '', 'spencer-6644', '', ''),
(6645, 56, 0, 1, 'Stites', '', 'stites', '', ''),
(6646, 56, 0, 1, 'Spirit Lake', '', 'spirit-lake-6646', '', ''),
(6647, 56, 0, 1, 'Teton', '', 'teton', '', ''),
(6648, 56, 0, 1, 'Troy', '', 'troy-6648', '', ''),
(6649, 56, 0, 1, 'Terreton', '', 'terreton', '', ''),
(6650, 56, 0, 1, 'Tetonia', '', 'tetonia', '', ''),
(6651, 56, 0, 1, 'Ucon', '', 'ucon', '', ''),
(6652, 56, 0, 1, 'Victor', '', 'victor-6652', '', ''),
(6653, 56, 0, 1, 'Warren', '', 'warren-6653', '', ''),
(6654, 56, 0, 1, 'Worley', '', 'worley', '', ''),
(6655, 56, 0, 1, 'White Bird', '', 'white-bird', '', ''),
(6656, 56, 0, 1, 'Wallace', '', 'wallace-6656', '', ''),
(6657, 56, 0, 1, 'Wilder', '', 'wilder', '', ''),
(6658, 56, 0, 1, 'Winchester', '', 'winchester-6658', '', ''),
(6659, 56, 0, 1, 'Wendell', '', 'wendell-6659', '', ''),
(6660, 56, 0, 1, 'Weippe', '', 'weippe', '', ''),
(6661, 56, 0, 1, 'Yellow Pine', '', 'yellow-pine', '', ''),
(6662, 42, 0, 1, 'Springfield', '', 'springfield-6662', '', ''),
(6663, 42, 0, 1, 'Salem', '', 'salem-6663', '', ''),
(6664, 42, 0, 1, 'Sandoval', '', 'sandoval', '', ''),
(6665, 42, 0, 1, 'Saint Elmo', '', 'saint-elmo', '', ''),
(6666, 42, 0, 1, 'Sainte Marie', '', 'sainte-marie', '', ''),
(6667, 42, 0, 1, 'Stewardson', '', 'stewardson', '', ''),
(6668, 42, 0, 1, 'Sumner', '', 'sumner-6668', '', ''),
(6669, 42, 0, 1, 'Shelbyville', '', 'shelbyville-6669', '', ''),
(6670, 42, 0, 1, 'Stonington', '', 'stonington-6670', '', ''),
(6671, 42, 0, 1, 'Saint Libory', '', 'saint-libory', '', ''),
(6672, 42, 0, 1, 'Smithton', '', 'smithton', '', ''),
(6673, 42, 0, 1, 'Sparta', '', 'sparta-6673', '', ''),
(6674, 42, 0, 1, 'Summerfield', '', 'summerfield-6674', '', ''),
(6675, 42, 0, 1, 'Steeleville', '', 'steeleville', '', ''),
(6676, 42, 0, 1, 'Sadorus', '', 'sadorus', '', ''),
(6677, 42, 0, 1, 'Saint Joseph', '', 'saint-joseph-6677', '', ''),
(6678, 42, 0, 1, 'Sidell', '', 'sidell', '', ''),
(6679, 42, 0, 1, 'Sullivan', '', 'sullivan-6679', '', ''),
(6680, 42, 0, 1, 'Sawyerville', '', 'sawyerville', '', ''),
(6681, 42, 0, 1, 'South Roxana', '', 'south-roxana', '', ''),
(6682, 42, 0, 1, 'Staunton', '', 'staunton-6682', '', ''),
(6683, 42, 0, 1, 'Saunemin', '', 'saunemin', '', ''),
(6684, 42, 0, 1, 'Saybrook', '', 'saybrook', '', ''),
(6685, 42, 0, 1, 'Secor', '', 'secor', '', ''),
(6686, 42, 0, 1, 'Sibley', '', 'sibley-6686', '', ''),
(6687, 42, 0, 1, 'Seneca', '', 'seneca-6687', '', ''),
(6688, 42, 0, 1, 'Sheffield', '', 'sheffield-6688', '', ''),
(6689, 42, 0, 1, 'Spring Valley', '', 'spring-valley-6689', '', ''),
(6690, 42, 0, 1, 'Standard', '', 'standard', '', ''),
(6691, 42, 0, 1, 'Sublette', '', 'sublette', '', ''),
(6692, 42, 0, 1, 'Saint Augustine', '', 'saint-augustine-6692', '', ''),
(6693, 42, 0, 1, 'Smithfield', '', 'smithfield-6693', '', ''),
(6694, 42, 0, 1, 'Stronghurst', '', 'stronghurst', '', ''),
(6695, 42, 0, 1, 'Saint David', '', 'saint-david', '', ''),
(6696, 42, 0, 1, 'Sherrard', '', 'sherrard', '', ''),
(6697, 42, 0, 1, 'Saint Anne', '', 'saint-anne', '', ''),
(6698, 42, 0, 1, 'Sheldon', '', 'sheldon', '', ''),
(6699, 42, 0, 1, 'Stockland', '', 'stockland', '', ''),
(6700, 42, 0, 1, 'Savanna', '', 'savanna', '', ''),
(6701, 42, 0, 1, 'Scales Mound', '', 'scales-mound', '', ''),
(6702, 42, 0, 1, 'Shannon', '', 'shannon-6702', '', ''),
(6703, 42, 0, 1, 'South Beloit', '', 'south-beloit', '', ''),
(6704, 42, 0, 1, 'Stockton', '', 'stockton-6704', '', ''),
(6705, 42, 0, 1, 'Sandwich', '', 'sandwich-6705', '', ''),
(6706, 42, 0, 1, 'Serena', '', 'serena', '', ''),
(6707, 42, 0, 1, 'Shabbona', '', 'shabbona', '', ''),
(6708, 42, 0, 1, 'Sheridan', '', 'sheridan-6708', '', ''),
(6709, 42, 0, 1, 'Steward', '', 'steward', '', ''),
(6710, 42, 0, 1, 'Sugar Grove', '', 'sugar-grove', '', ''),
(6711, 42, 0, 1, 'South Wilmington', '', 'south-wilmington', '', ''),
(6712, 42, 0, 1, 'Steger', '', 'steger', '', ''),
(6713, 42, 0, 1, 'Stone Park', '', 'stone-park', '', ''),
(6714, 42, 0, 1, 'Saint Charles', '', 'saint-charles-6714', '', ''),
(6715, 42, 0, 1, 'Third Lake', '', 'third-lake', '', ''),
(6716, 42, 0, 1, 'Thomson', '', 'thomson-6716', '', ''),
(6717, 42, 0, 1, 'Trenton', '', 'trenton-6717', '', ''),
(6718, 42, 0, 1, 'Tamms', '', 'tamms', '', ''),
(6719, 42, 0, 1, 'Tovey', '', 'tovey', '', ''),
(6720, 42, 0, 1, 'Tiskilwa', '', 'tiskilwa', '', ''),
(6721, 42, 0, 1, 'Troy Grove', '', 'troy-grove', '', ''),
(6722, 42, 0, 1, 'Triumph', '', 'triumph', '', ''),
(6723, 42, 0, 1, 'Tilden', '', 'tilden', '', ''),
(6724, 42, 0, 1, 'Toulon', '', 'toulon', '', ''),
(6725, 42, 0, 1, 'Tamaroa', '', 'tamaroa', '', ''),
(6726, 42, 0, 1, 'Towanda', '', 'towanda-6726', '', ''),
(6727, 42, 0, 1, 'Toluca', '', 'toluca', '', ''),
(6728, 42, 0, 1, 'Tennessee', '', 'tennessee', '', ''),
(6729, 42, 0, 1, 'Taylor Springs', '', 'taylor-springs', '', ''),
(6730, 42, 0, 1, 'Tallula', '', 'tallula', '', ''),
(6731, 42, 0, 1, 'Tilton', '', 'tilton', '', ''),
(6732, 42, 0, 1, 'Tampico', '', 'tampico', '', ''),
(6733, 42, 0, 1, 'Thayer', '', 'thayer', '', ''),
(6734, 42, 0, 1, 'Tower Hill', '', 'tower-hill', '', ''),
(6735, 42, 0, 1, 'Thornton', '', 'thornton-6735', '', ''),
(6736, 42, 0, 1, 'Teutopolis', '', 'teutopolis', '', ''),
(6737, 42, 0, 1, 'Toledo', '', 'toledo-6737', '', ''),
(6738, 42, 0, 1, 'Troy', '', 'troy-6738', '', ''),
(6739, 42, 0, 1, 'Trivoli', '', 'trivoli', '', ''),
(6740, 42, 0, 1, 'Tolono', '', 'tolono', '', ''),
(6741, 42, 0, 1, 'Topeka', '', 'topeka-6741', '', ''),
(6742, 42, 0, 1, 'Thomasboro', '', 'thomasboro', '', ''),
(6743, 42, 0, 1, 'Tremont', '', 'tremont', '', ''),
(6744, 42, 0, 1, 'Taylor Ridge', '', 'taylor-ridge', '', ''),
(6745, 42, 0, 1, 'Thompsonville', '', 'thompsonville', '', ''),
(6746, 42, 0, 1, 'Table Grove', '', 'table-grove', '', ''),
(6747, 42, 0, 1, 'Utica', '', 'utica-6747', '', ''),
(6748, 42, 0, 1, 'Ullin', '', 'ullin', '', ''),
(6749, 42, 0, 1, 'Ursa', '', 'ursa', '', ''),
(6750, 42, 0, 1, 'University Park', '', 'university-park-6750', '', ''),
(6751, 42, 0, 1, 'Vermont', '', 'vermont', '', ''),
(6752, 42, 0, 1, 'Vandalia', '', 'vandalia-6752', '', ''),
(6753, 42, 0, 1, 'Vienna', '', 'vienna-6753', '', ''),
(6754, 42, 0, 1, 'Volo', '', 'volo', '', ''),
(6755, 42, 0, 1, 'Verona', '', 'verona-6755', '', ''),
(6756, 42, 0, 1, 'Virginia', '', 'virginia-6756', '', ''),
(6757, 42, 0, 1, 'Valmeyer', '', 'valmeyer', '', ''),
(6758, 42, 0, 1, 'Vernon', '', 'vernon-6758', '', ''),
(6759, 42, 0, 1, 'Virden', '', 'virden', '', ''),
(6760, 42, 0, 1, 'Varna', '', 'varna', '', ''),
(6761, 42, 0, 1, 'Viola', '', 'viola-6761', '', ''),
(6762, 42, 0, 1, 'Vlg Of Lakewood', '', 'vlg-of-lakewood', '', ''),
(6763, 42, 0, 1, 'Venice', '', 'venice-6763', '', ''),
(6764, 42, 0, 1, 'Victoria', '', 'victoria-6764', '', ''),
(6765, 42, 0, 1, 'Watseka', '', 'watseka', '', ''),
(6766, 42, 0, 1, 'Woodlawn', '', 'woodlawn', '', ''),
(6767, 42, 0, 1, 'Wadsworth', '', 'wadsworth-6767', '', ''),
(6768, 42, 0, 1, 'Wapella', '', 'wapella', '', ''),
(6769, 42, 0, 1, 'Wellington', '', 'wellington-6769', '', ''),
(6770, 42, 0, 1, 'Waltonville', '', 'waltonville', '', ''),
(6771, 42, 0, 1, 'Walnut', '', 'walnut-6771', '', ''),
(6772, 42, 0, 1, 'Westfield', '', 'westfield-6772', '', ''),
(6773, 42, 0, 1, 'Wyanet', '', 'wyanet', '', ''),
(6774, 42, 0, 1, 'West Union', '', 'west-union-6774', '', ''),
(6775, 42, 0, 1, 'Woodhull', '', 'woodhull', '', ''),
(6776, 42, 0, 1, 'Wheeling', '', 'wheeling-6776', '', ''),
(6777, 42, 0, 1, 'Warrensburg', '', 'warrensburg-6777', '', ''),
(6778, 42, 0, 1, 'West Chicago', '', 'west-chicago', '', ''),
(6779, 42, 0, 1, 'White Hall', '', 'white-hall-6779', '', ''),
(6780, 42, 0, 1, 'Waterloo', '', 'waterloo-6780', '', ''),
(6781, 42, 0, 1, 'Willisville', '', 'willisville', '', ''),
(6782, 42, 0, 1, 'Winchester', '', 'winchester-6782', '', ''),
(6783, 42, 0, 1, 'Warren', '', 'warren-6783', '', ''),
(6784, 42, 0, 1, 'Wyoming', '', 'wyoming-6784', '', ''),
(6785, 42, 0, 1, 'Warsaw', '', 'warsaw-6785', '', ''),
(6786, 42, 0, 1, 'Warrenville', '', 'warrenville', '', ''),
(6787, 42, 0, 1, 'Worth', '', 'worth', '', ''),
(6788, 42, 0, 1, 'Westchester', '', 'westchester', '', ''),
(6789, 42, 0, 1, 'Wedron', '', 'wedron', '', ''),
(6790, 42, 0, 1, 'Witt', '', 'witt', '', ''),
(6791, 42, 0, 1, 'Wenona', '', 'wenona', '', ''),
(6792, 42, 0, 1, 'Wilsonville', '', 'wilsonville-6792', '', ''),
(6793, 42, 0, 1, 'Williamsville', '', 'williamsville-6793', '', ''),
(6794, 42, 0, 1, 'Westville', '', 'westville-6794', '', ''),
(6795, 42, 0, 1, 'Willow Springs', '', 'willow-springs', '', ''),
(6796, 42, 0, 1, 'Winnebago', '', 'winnebago', '', ''),
(6797, 42, 0, 1, 'Windsor', '', 'windsor-6797', '', ''),
(6798, 42, 0, 1, 'Woodridge', '', 'woodridge', '', ''),
(6799, 42, 0, 1, 'Winslow', '', 'winslow-6799', '', ''),
(6800, 42, 0, 1, 'Winnetka', '', 'winnetka-6800', '', ''),
(6801, 42, 0, 1, 'Winfield', '', 'winfield-6801', '', ''),
(6802, 42, 0, 1, 'West Salem', '', 'west-salem', '', ''),
(6803, 42, 0, 1, 'Woodstock', '', 'woodstock-6803', '', ''),
(6804, 42, 0, 1, 'West Peoria', '', 'west-peoria', '', ''),
(6805, 42, 0, 1, 'Worden', '', 'worden', '', ''),
(6806, 42, 0, 1, 'Waverly', '', 'waverly-6806', '', ''),
(6807, 42, 0, 1, 'Wataga', '', 'wataga', '', ''),
(6808, 42, 0, 1, 'Wonder Lake', '', 'wonder-lake', '', ''),
(6809, 42, 0, 1, 'Wasco', '', 'wasco-6809', '', ''),
(6810, 42, 0, 1, 'Wood River', '', 'wood-river', '', ''),
(6811, 42, 0, 1, 'Waterman', '', 'waterman', '', ''),
(6812, 42, 0, 1, 'Williamsfield', '', 'williamsfield', '', ''),
(6813, 42, 0, 1, 'Woodson', '', 'woodson-6813', '', ''),
(6814, 42, 0, 1, 'Washington', '', 'washington-6814', '', ''),
(6815, 42, 0, 1, 'Wilmington', '', 'wilmington-6815', '', ''),
(6816, 42, 0, 1, 'Washburn', '', 'washburn-6816', '', ''),
(6817, 42, 0, 1, 'Washington Park', '', 'washington-park', '', ''),
(6818, 42, 0, 1, 'Wayne City', '', 'wayne-city', '', ''),
(6819, 42, 0, 1, 'Watson', '', 'watson-6819', '', ''),
(6820, 42, 0, 1, 'Willow Hill', '', 'willow-hill', '', ''),
(6821, 42, 0, 1, 'West Brooklyn', '', 'west-brooklyn', '', ''),
(6822, 42, 0, 1, 'Xenia', '', 'xenia-6822', '', ''),
(6823, 42, 0, 1, 'Yates City', '', 'yates-city', '', ''),
(6824, 42, 0, 1, 'Zeigler', '', 'zeigler', '', ''),
(6825, 39, 0, 1, 'Shelbyville', '', 'shelbyville-6825', '', ''),
(6826, 39, 0, 1, 'Spencer', '', 'spencer-6826', '', ''),
(6827, 39, 0, 1, 'Sunman', '', 'sunman', '', ''),
(6828, 39, 0, 1, 'Shoals', '', 'shoals', '', ''),
(6829, 39, 0, 1, 'Star City', '', 'star-city-6829', '', ''),
(6830, 39, 0, 1, 'San Pierre', '', 'san-pierre', '', ''),
(6831, 39, 0, 1, 'Summitville', '', 'summitville', '', ''),
(6832, 39, 0, 1, 'Saint Anthony', '', 'saint-anthony-6832', '', ''),
(6833, 39, 0, 1, 'Selma', '', 'selma-6833', '', ''),
(6834, 39, 0, 1, 'Shirley', '', 'shirley-6834', '', ''),
(6835, 39, 0, 1, 'Solsberry', '', 'solsberry', '', ''),
(6836, 39, 0, 1, 'Salem', '', 'salem-6836', '', ''),
(6837, 39, 0, 1, 'Swayzee', '', 'swayzee', '', ''),
(6838, 39, 0, 1, 'South Whitley', '', 'south-whitley', '', ''),
(6839, 39, 0, 1, 'Stroh', '', 'stroh', '', ''),
(6840, 39, 0, 1, 'Syracuse', '', 'syracuse-6840', '', ''),
(6841, 39, 0, 1, 'Saint John', '', 'saint-john', '', ''),
(6842, 39, 0, 1, 'Sheridan', '', 'sheridan-6842', '', ''),
(6843, 39, 0, 1, 'Taswell', '', 'taswell', '', ''),
(6844, 39, 0, 1, 'Tippecanoe', '', 'tippecanoe', '', ''),
(6845, 39, 0, 1, 'Trail Creek', '', 'trail-creek', '', ''),
(6846, 39, 0, 1, 'Thayer', '', 'thayer-6846', '', ''),
(6847, 39, 0, 1, 'Thorntown', '', 'thorntown', '', ''),
(6848, 39, 0, 1, 'Taylorsville', '', 'taylorsville-6848', '', ''),
(6849, 39, 0, 1, 'Twelve Mile', '', 'twelve-mile', '', ''),
(6850, 39, 0, 1, 'Tell City', '', 'tell-city', '', ''),
(6851, 39, 0, 1, 'Topeka', '', 'topeka-6851', '', ''),
(6852, 39, 0, 1, 'Tipton', '', 'tipton-6852', '', ''),
(6853, 39, 0, 1, 'Troy', '', 'troy-6853', '', ''),
(6854, 39, 0, 1, 'Tennyson', '', 'tennyson', '', ''),
(6855, 39, 0, 1, 'Union Mills', '', 'union-mills', '', ''),
(6856, 39, 0, 1, 'Unionville', '', 'unionville', '', ''),
(6857, 39, 0, 1, 'Urbana', '', 'urbana-6857', '', ''),
(6858, 39, 0, 1, 'Union City', '', 'union-city-6858', '', ''),
(6859, 39, 0, 1, 'Upland', '', 'upland-6859', '', ''),
(6860, 39, 0, 1, 'Universal', '', 'universal', '', ''),
(6861, 39, 0, 1, 'Vernon', '', 'vernon-6861', '', ''),
(6862, 39, 0, 1, 'Vallonia', '', 'vallonia', '', ''),
(6863, 39, 0, 1, 'Van Buren', '', 'van-buren-6863', '', ''),
(6864, 39, 0, 1, 'Versailles', '', 'versailles-6864', '', ''),
(6865, 39, 0, 1, 'West Harrison', '', 'west-harrison-6865', '', ''),
(6866, 39, 0, 1, 'Whiting', '', 'whiting-6866', '', ''),
(6867, 39, 0, 1, 'Warsaw', '', 'warsaw-6867', '', ''),
(6868, 39, 0, 1, 'Winona Lake', '', 'winona-lake', '', ''),
(6869, 39, 0, 1, 'Wheatfield', '', 'wheatfield', '', ''),
(6870, 39, 0, 1, 'Wanamaker', '', 'wanamaker', '', ''),
(6871, 39, 0, 1, 'Wheeler', '', 'wheeler', '', ''),
(6872, 39, 0, 1, 'Wabash', '', 'wabash', '', ''),
(6873, 39, 0, 1, 'Washington', '', 'washington-6873', '', ''),
(6874, 39, 0, 1, 'Woodburn', '', 'woodburn-6874', '', ''),
(6875, 39, 0, 1, 'Wolcott', '', 'wolcott-6875', '', ''),
(6876, 39, 0, 1, 'Westport', '', 'westport-6876', '', ''),
(6877, 39, 0, 1, 'Westpoint', '', 'westpoint', '', ''),
(6878, 39, 0, 1, 'Westfield', '', 'westfield-6878', '', ''),
(6879, 39, 0, 1, 'Whiteland', '', 'whiteland', '', ''),
(6880, 39, 0, 1, 'Westville', '', 'westville-6880', '', ''),
(6881, 39, 0, 1, 'Wanatah', '', 'wanatah', '', ''),
(6882, 39, 0, 1, 'Wakarusa', '', 'wakarusa', '', ''),
(6883, 39, 0, 1, 'Warren', '', 'warren-6883', '', ''),
(6884, 39, 0, 1, 'West Baden Spgs', '', 'west-baden-spgs', '', ''),
(6885, 39, 0, 1, 'Walton', '', 'walton-6885', '', ''),
(6886, 39, 0, 1, 'Whitestown', '', 'whitestown', '', ''),
(6887, 39, 0, 1, 'Winchester', '', 'winchester-6887', '', ''),
(6888, 39, 0, 1, 'Waterloo', '', 'waterloo-6888', '', ''),
(6889, 39, 0, 1, 'Williamsport', '', 'williamsport-6889', '', ''),
(6890, 39, 0, 1, 'Wolcottville', '', 'wolcottville', '', ''),
(6891, 39, 0, 1, 'Wilkinson', '', 'wilkinson', '', ''),
(6892, 39, 0, 1, 'Windfall', '', 'windfall', '', ''),
(6893, 39, 0, 1, 'Walkerton', '', 'walkerton', '', ''),
(6894, 39, 0, 1, 'Westphalia', '', 'westphalia-6894', '', ''),
(6895, 39, 0, 1, 'West Lebanon', '', 'west-lebanon-6895', '', ''),
(6896, 39, 0, 1, 'Wheatland', '', 'wheatland-6896', '', ''),
(6897, 39, 0, 1, 'Wyatt', '', 'wyatt', '', ''),
(6898, 39, 0, 1, 'Waynetown', '', 'waynetown', '', ''),
(6899, 39, 0, 1, 'Waveland', '', 'waveland-6899', '', ''),
(6900, 39, 0, 1, 'West Terre Haute', '', 'west-terre-haute', '', ''),
(6901, 39, 0, 1, 'Wolflake', '', 'wolflake', '', ''),
(6902, 39, 0, 1, 'Winslow', '', 'winslow-6902', '', ''),
(6903, 39, 0, 1, 'W College Corner', '', 'w-college-corner', '', ''),
(6904, 39, 0, 1, 'Wingate', '', 'wingate-6904', '', ''),
(6905, 39, 0, 1, 'Waldron', '', 'waldron-6905', '', ''),
(6906, 39, 0, 1, 'West Baden Springs', '', 'west-baden-springs', '', ''),
(6907, 39, 0, 1, 'West Newton', '', 'west-newton-6907', '', ''),
(6908, 39, 0, 1, 'Yorktown', '', 'yorktown-6908', '', ''),
(6909, 39, 0, 1, 'Zanesville', '', 'zanesville-6909', '', ''),
(6910, 55, 0, 1, 'Winfield', '', 'winfield-6910', '', ''),
(6911, 55, 0, 1, 'White City', '', 'white-city', '', ''),
(6912, 55, 0, 1, 'Washington', '', 'washington-6912', '', ''),
(6913, 55, 0, 1, 'Weir', '', 'weir', '', ''),
(6914, 55, 0, 1, 'Wellsville', '', 'wellsville-6914', '', ''),
(6915, 55, 0, 1, 'Yoder', '', 'yoder-6915', '', ''),
(6916, 55, 0, 1, 'Yates Center', '', 'yates-center', '', ''),
(6917, 55, 0, 1, 'Zenda', '', 'zenda', '', ''),
(6918, 37, 0, 1, 'Southgate', '', 'southgate-6918', '', ''),
(6919, 37, 0, 1, 'Silver Grove', '', 'silver-grove', '', ''),
(6920, 37, 0, 1, 'Stoney Fork', '', 'stoney-fork', '', ''),
(6921, 37, 0, 1, 'Smithfield', '', 'smithfield-6921', '', ''),
(6922, 37, 0, 1, 'Sulphur', '', 'sulphur-6922', '', ''),
(6923, 37, 0, 1, 'Sandgap', '', 'sandgap', '', ''),
(6924, 37, 0, 1, 'Springfield', '', 'springfield-6924', '', ''),
(6925, 37, 0, 1, 'Somerset', '', 'somerset-6925', '', ''),
(6926, 37, 0, 1, 'Science Hill', '', 'science-hill', '', ''),
(6927, 37, 0, 1, 'Scottsville', '', 'scottsville', '', ''),
(6928, 37, 0, 1, 'St Matthews', '', 'st-matthews', '', ''),
(6929, 37, 0, 1, 'Simpsonville', '', 'simpsonville-6929', '', ''),
(6930, 37, 0, 1, 'Shively', '', 'shively', '', ''),
(6931, 37, 0, 1, 'Summer Shade', '', 'summer-shade', '', ''),
(6932, 37, 0, 1, 'Salem', '', 'salem-6932', '', ''),
(6933, 37, 0, 1, 'Smithland', '', 'smithland', '', ''),
(6934, 37, 0, 1, 'Sandy Hook', '', 'sandy-hook', '', ''),
(6935, 37, 0, 1, 'Sulphur Well', '', 'sulphur-well', '', ''),
(6936, 37, 0, 1, 'Salyersville', '', 'salyersville', '', ''),
(6937, 37, 0, 1, 'Stopover', '', 'stopover', '', ''),
(6938, 37, 0, 1, 'Sidney', '', 'sidney-6938', '', ''),
(6939, 37, 0, 1, 'Stearns', '', 'stearns', '', ''),
(6940, 37, 0, 1, 'Symsonia', '', 'symsonia', '', ''),
(6941, 37, 0, 1, 'South Shore', '', 'south-shore', '', ''),
(6942, 37, 0, 1, 'Sturgis', '', 'sturgis-6942', '', ''),
(6943, 37, 0, 1, 'Stanville', '', 'stanville', '', ''),
(6944, 37, 0, 1, 'Stone', '', 'stone', '', ''),
(6945, 37, 0, 1, 'Sassafras', '', 'sassafras', '', ''),
(6946, 37, 0, 1, 'Stanford', '', 'stanford-6946', '', ''),
(6947, 37, 0, 1, 'Stanton', '', 'stanton-6947', '', ''),
(6948, 37, 0, 1, 'Stinnett', '', 'stinnett', '', ''),
(6949, 37, 0, 1, 'Sacramento', '', 'sacramento-6949', '', ''),
(6950, 37, 0, 1, 'Steele', '', 'steele', '', ''),
(6951, 37, 0, 1, 'Sebree', '', 'sebree', '', ''),
(6952, 37, 0, 1, 'Smiths Grove', '', 'smiths-grove', '', ''),
(6953, 37, 0, 1, 'Shelbiana', '', 'shelbiana', '', ''),
(6954, 37, 0, 1, 'Salvisa', '', 'salvisa', '', ''),
(6955, 37, 0, 1, 'Salt Lick', '', 'salt-lick', '', ''),
(6956, 37, 0, 1, 'Sharpsburg', '', 'sharpsburg-6956', '', ''),
(6957, 37, 0, 1, 'Sparta', '', 'sparta-6957', '', ''),
(6958, 37, 0, 1, 'Stamping Ground', '', 'stamping-ground', '', ''),
(6959, 37, 0, 1, 'Sedalia', '', 'sedalia-6959', '', ''),
(6960, 37, 0, 1, 'Slade', '', 'slade', '', ''),
(6961, 37, 0, 1, 'Summit', '', 'summit-6961', '', ''),
(6962, 37, 0, 1, 'Sullivan', '', 'sullivan-6962', '', ''),
(6963, 37, 0, 1, 'Sonora', '', 'sonora-6963', '', ''),
(6964, 37, 0, 1, 'Taylorsville', '', 'taylorsville-6964', '', ''),
(6965, 37, 0, 1, 'Tollesboro', '', 'tollesboro', '', ''),
(6966, 37, 0, 1, 'Taylor Mill', '', 'taylor-mill', '', ''),
(6967, 37, 0, 1, 'Topmost', '', 'topmost', '', ''),
(6968, 37, 0, 1, 'Turners Station', '', 'turners-station', '', ''),
(6969, 37, 0, 1, 'Tiline', '', 'tiline', '', ''),
(6970, 37, 0, 1, 'Union', '', 'union-6970', '', ''),
(6971, 37, 0, 1, 'Uniontown', '', 'uniontown-6971', '', ''),
(6972, 37, 0, 1, 'Utica', '', 'utica-6972', '', ''),
(6973, 37, 0, 1, 'Upton', '', 'upton-6973', '', ''),
(6974, 37, 0, 1, 'Valley Station', '', 'valley-station', '', ''),
(6975, 37, 0, 1, 'Verona', '', 'verona-6975', '', ''),
(6976, 37, 0, 1, 'Vine Grove', '', 'vine-grove', '', ''),
(6977, 37, 0, 1, 'Vicco', '', 'vicco', '', ''),
(6978, 37, 0, 1, 'Vanceburg', '', 'vanceburg', '', ''),
(6979, 37, 0, 1, 'Virgie', '', 'virgie', '', ''),
(6980, 37, 0, 1, 'Villa Hills', '', 'villa-hills', '', ''),
(6981, 37, 0, 1, 'Vincent', '', 'vincent-6981', '', ''),
(6982, 37, 0, 1, 'Viper', '', 'viper', '', ''),
(6983, 37, 0, 1, 'Winchester', '', 'winchester-6983', '', ''),
(6984, 37, 0, 1, 'Wickliffe', '', 'wickliffe-6984', '', ''),
(6985, 37, 0, 1, 'Williamsburg', '', 'williamsburg-6985', '', ''),
(6986, 37, 0, 1, 'Wilder', '', 'wilder-6986', '', ''),
(6987, 37, 0, 1, 'Waddy', '', 'waddy', '', ''),
(6988, 37, 0, 1, 'West Paducah', '', 'west-paducah', '', ''),
(6989, 37, 0, 1, 'West Liberty', '', 'west-liberty-6989', '', ''),
(6990, 37, 0, 1, 'Whitesburg', '', 'whitesburg-6990', '', ''),
(6991, 37, 0, 1, 'Williamstown', '', 'williamstown-6991', '', ''),
(6992, 37, 0, 1, 'Whitley City', '', 'whitley-city', '', ''),
(6993, 37, 0, 1, 'Warsaw', '', 'warsaw-6993', '', ''),
(6994, 37, 0, 1, 'Worthington', '', 'worthington-6994', '', ''),
(6995, 37, 0, 1, 'Whitesville', '', 'whitesville', '', ''),
(6996, 37, 0, 1, 'Wheelwright', '', 'wheelwright', '', ''),
(6997, 37, 0, 1, 'Woodburn', '', 'woodburn-6997', '', ''),
(6998, 37, 0, 1, 'Warfield', '', 'warfield', '', ''),
(6999, 37, 0, 1, 'Wilmore', '', 'wilmore', '', ''),
(7000, 37, 0, 1, 'West Point', '', 'west-point-7000', '', ''),
(7001, 37, 0, 1, 'White Plains', '', 'white-plains-7001', '', ''),
(7002, 37, 0, 1, 'Waverly', '', 'waverly-7002', '', ''),
(7003, 37, 0, 1, 'Washington', '', 'washington-7003', '', ''),
(7004, 37, 0, 1, 'Wheatcroft', '', 'wheatcroft', '', ''),
(7005, 37, 0, 1, 'Wayland', '', 'wayland-7005', '', ''),
(7006, 37, 0, 1, 'Westport', '', 'westport-7006', '', ''),
(7007, 37, 0, 1, 'Wooton', '', 'wooton', '', ''),
(7008, 37, 0, 1, 'Wallins Creek', '', 'wallins-creek', '', ''),
(7009, 37, 0, 1, 'Waco', '', 'waco-7009', '', ''),
(7010, 44, 0, 1, 'Springfield', '', 'springfield-7010', '', ''),
(7011, 44, 0, 1, 'St Gabriel', '', 'st-gabriel', '', ''),
(7012, 44, 0, 1, 'Simsboro', '', 'simsboro', '', ''),
(7013, 44, 0, 1, 'St Rose', '', 'st-rose', '', ''),
(7014, 44, 0, 1, 'Sterlington', '', 'sterlington', '', ''),
(7015, 44, 0, 1, 'St Bernard', '', 'st-bernard', '', ''),
(7016, 44, 0, 1, 'St James', '', 'st-james', '', ''),
(7017, 44, 0, 1, 'St Martinville', '', 'st-martinville', '', ''),
(7018, 44, 0, 1, 'Schriever', '', 'schriever', '', ''),
(7019, 44, 0, 1, 'St Joseph', '', 'st-joseph', '', ''),
(7020, 44, 0, 1, 'Sun', '', 'sun', '', ''),
(7021, 44, 0, 1, 'Shongaloo', '', 'shongaloo', '', ''),
(7022, 44, 0, 1, 'St Francisville', '', 'st-francisville', '', ''),
(7023, 44, 0, 1, 'Springhill', '', 'springhill', '', ''),
(7024, 44, 0, 1, 'Sarepta', '', 'sarepta', '', ''),
(7025, 44, 0, 1, 'Simpson', '', 'simpson', '', ''),
(7026, 44, 0, 1, 'Spearsville', '', 'spearsville', '', ''),
(7027, 44, 0, 1, 'Saint Amant', '', 'saint-amant', '', ''),
(7028, 44, 0, 1, 'Saint Francisville', '', 'saint-francisville', '', ''),
(7029, 44, 0, 1, 'Saint Gabriel', '', 'saint-gabriel', '', ''),
(7030, 44, 0, 1, 'Slaughter', '', 'slaughter', '', ''),
(7031, 44, 0, 1, 'Summerfield', '', 'summerfield-7031', '', ''),
(7032, 44, 0, 1, 'Saint Joseph', '', 'saint-joseph-7032', '', ''),
(7033, 44, 0, 1, 'Tullos', '', 'tullos', '', ''),
(7034, 44, 0, 1, 'Turkey Creek', '', 'turkey-creek', '', ''),
(7035, 44, 0, 1, 'Torbert', '', 'torbert', '', ''),
(7036, 44, 0, 1, 'Tangipahoa', '', 'tangipahoa', '', ''),
(7037, 44, 0, 1, 'Theriot', '', 'theriot', '', ''),
(7038, 44, 0, 1, 'Vivian', '', 'vivian', '', ''),
(7039, 44, 0, 1, 'Vinton', '', 'vinton-7039', '', ''),
(7040, 44, 0, 1, 'Vidalia', '', 'vidalia-7040', '', ''),
(7041, 44, 0, 1, 'Verda', '', 'verda', '', ''),
(7042, 44, 0, 1, 'Violet', '', 'violet', '', ''),
(7043, 44, 0, 1, 'Venice', '', 'venice-7043', '', ''),
(7044, 44, 0, 1, 'Vacherie', '', 'vacherie', '', ''),
(7045, 44, 0, 1, 'Ventress', '', 'ventress', '', ''),
(7046, 44, 0, 1, 'Westlake', '', 'westlake-7046', '', ''),
(7047, 44, 0, 1, 'Welsh', '', 'welsh', '', ''),
(7048, 44, 0, 1, 'Winnsboro', '', 'winnsboro-7048', '', ''),
(7049, 44, 0, 1, 'White Castle', '', 'white-castle', '', ''),
(7050, 44, 0, 1, 'Walker', '', 'walker-7050', '', ''),
(7051, 44, 0, 1, 'Wisner', '', 'wisner', '', ''),
(7052, 44, 0, 1, 'Waterproof', '', 'waterproof', '', ''),
(7053, 44, 0, 1, 'Washington', '', 'washington-7053', '', ''),
(7054, 44, 0, 1, 'Wakefield', '', 'wakefield-7054', '', ''),
(7055, 44, 0, 1, 'Youngsville', '', 'youngsville-7055', '', ''),
(7056, 44, 0, 1, 'Zachary', '', 'zachary', '', ''),
(7057, 13, 0, 1, 'Wenham', '', 'wenham', '', ''),
(7058, 13, 0, 1, 'Webster', '', 'webster-7058', '', ''),
(7059, 13, 0, 1, 'Warren', '', 'warren-7059', '', ''),
(7060, 13, 0, 1, 'Westminster', '', 'westminster-7060', '', ''),
(7061, 13, 0, 1, 'West Brookfield', '', 'west-brookfield', '', ''),
(7062, 13, 0, 1, 'West Wareham', '', 'west-wareham', '', ''),
(7063, 13, 0, 1, 'West Warren', '', 'west-warren', '', ''),
(7064, 13, 0, 1, 'Whitinsville', '', 'whitinsville', '', ''),
(7065, 13, 0, 1, 'Westport', '', 'westport-7065', '', ''),
(7066, 13, 0, 1, 'Whately', '', 'whately', '', ''),
(7067, 13, 0, 1, 'Weston', '', 'weston-7067', '', ''),
(7068, 13, 0, 1, 'Wakefield', '', 'wakefield-7068', '', ''),
(7069, 13, 0, 1, 'Wendell', '', 'wendell-7069', '', ''),
(7070, 13, 0, 1, 'Wilmington', '', 'wilmington-7070', '', ''),
(7071, 13, 0, 1, 'Waban', '', 'waban', '', ''),
(7072, 13, 0, 1, 'Winchester', '', 'winchester-7072', '', ''),
(7073, 13, 0, 1, 'West Townsend', '', 'west-townsend', '', ''),
(7074, 13, 0, 1, 'Westfield', '', 'westfield-7074', '', ''),
(7075, 13, 0, 1, 'Wales', '', 'wales', '', ''),
(7076, 13, 0, 1, 'Wilkinsonville', '', 'wilkinsonville', '', ''),
(7077, 13, 0, 1, 'Winchendon Springs', '', 'winchendon-springs', '', ''),
(7078, 13, 0, 1, 'Ware', '', 'ware', '', ''),
(7079, 13, 0, 1, 'Westwood', '', 'westwood-7079', '', ''),
(7080, 13, 0, 1, 'West Tisbury', '', 'west-tisbury', '', ''),
(7081, 15, 0, 1, 'Sherwood Forest', '', 'sherwood-forest', '', ''),
(7082, 15, 0, 1, 'Saint Leonard', '', 'saint-leonard', '', ''),
(7083, 15, 0, 1, 'Stevenson', '', 'stevenson-7083', '', ''),
(7084, 15, 0, 1, 'Swanton', '', 'swanton-7084', '', ''),
(7085, 15, 0, 1, 'Stevensville', '', 'stevensville-7085', '', ''),
(7086, 15, 0, 1, 'Sharpsburg', '', 'sharpsburg-7086', '', ''),
(7087, 15, 0, 1, 'Tracys Landing', '', 'tracys-landing', '', ''),
(7088, 15, 0, 1, 'Taylors Island', '', 'taylors-island', '', ''),
(7089, 15, 0, 1, 'Tuscarora', '', 'tuscarora', '', ''),
(7090, 15, 0, 1, 'Tyaskin', '', 'tyaskin', '', ''),
(7091, 15, 0, 1, 'Union Bridge', '', 'union-bridge', '', ''),
(7092, 15, 0, 1, 'Vienna', '', 'vienna-7092', '', ''),
(7093, 15, 0, 1, 'Westernport', '', 'westernport', '', ''),
(7094, 15, 0, 1, 'White Hall', '', 'white-hall-7094', '', ''),
(7095, 15, 0, 1, 'Woodbine', '', 'woodbine-7095', '', ''),
(7096, 15, 0, 1, 'Warwick', '', 'warwick-7096', '', ''),
(7097, 15, 0, 1, 'White Plains', '', 'white-plains-7097', '', ''),
(7098, 15, 0, 1, 'West Hyattsville', '', 'west-hyattsville', '', ''),
(7099, 15, 0, 1, 'Woodsboro', '', 'woodsboro', '', ''),
(7100, 15, 0, 1, 'Woodstock', '', 'woodstock-7100', '', ''),
(7101, 15, 0, 1, 'Whiteford', '', 'whiteford', '', ''),
(7102, 15, 0, 1, 'Westover', '', 'westover', '', ''),
(7103, 15, 0, 1, 'Willards', '', 'willards', '', ''),
(7104, 15, 0, 1, 'Williamsport', '', 'williamsport-7104', '', ''),
(7105, 15, 0, 1, 'Whaleyville', '', 'whaleyville', '', ''),
(7106, 15, 0, 1, 'Wheaton', '', 'wheaton-7106', '', ''),
(7107, 15, 0, 1, 'West River', '', 'west-river', '', ''),
(7108, 23, 0, 1, 'Winslow', '', 'winslow-7108', '', ''),
(7109, 23, 0, 1, 'Winthrop', '', 'winthrop-7109', '', ''),
(7110, 23, 0, 1, 'Wilton', '', 'wilton-7110', '', ''),
(7111, 23, 0, 1, 'Washburn', '', 'washburn-7111', '', ''),
(7112, 23, 0, 1, 'Wayne', '', 'wayne-7112', '', ''),
(7113, 23, 0, 1, 'Windsor', '', 'windsor-7113', '', ''),
(7114, 23, 0, 1, 'Warren', '', 'warren-7114', '', ''),
(7115, 23, 0, 1, 'Washington', '', 'washington-7115', '', ''),
(7116, 23, 0, 1, 'Westport Island', '', 'westport-island', '', ''),
(7117, 23, 0, 1, 'Whitefield', '', 'whitefield-7117', '', ''),
(7118, 23, 0, 1, 'Walpole', '', 'walpole-7118', '', ''),
(7119, 23, 0, 1, 'Waterford', '', 'waterford-7119', '', ''),
(7120, 23, 0, 1, 'Winn', '', 'winn', '', ''),
(7121, 23, 0, 1, 'West Enfield', '', 'west-enfield', '', ''),
(7122, 23, 0, 1, 'Woolwich', '', 'woolwich', '', ''),
(7123, 23, 0, 1, 'Wellington', '', 'wellington-7123', '', ''),
(7124, 23, 0, 1, 'West Forks', '', 'west-forks', '', ''),
(7125, 23, 0, 1, 'Winterport', '', 'winterport', '', ''),
(7126, 23, 0, 1, 'Waterboro', '', 'waterboro', '', ''),
(7127, 23, 0, 1, 'West Bowdoin', '', 'west-bowdoin', '', ''),
(7128, 23, 0, 1, 'York', '', 'york-7128', '', ''),
(7129, 23, 0, 1, 'York Beach', '', 'york-beach', '', ''),
(7130, 23, 0, 1, 'York Harbor', '', 'york-harbor', '', ''),
(7131, 17, 0, 1, 'Saint Bonifacius', '', 'saint-bonifacius', '', ''),
(7132, 17, 0, 1, 'Saint Michael', '', 'saint-michael', '', ''),
(7133, 17, 0, 1, 'Santiago', '', 'santiago', '', ''),
(7134, 17, 0, 1, 'Savage', '', 'savage', '', ''),
(7135, 17, 0, 1, 'Silver Lake', '', 'silver-lake', '', ''),
(7136, 17, 0, 1, 'South Haven', '', 'south-haven-7136', '', ''),
(7137, 17, 0, 1, 'Spring Park', '', 'spring-park', '', ''),
(7138, 17, 0, 1, 'Schroeder', '', 'schroeder', '', ''),
(7139, 17, 0, 1, 'Silver Bay', '', 'silver-bay', '', ''),
(7140, 17, 0, 1, 'Saginaw', '', 'saginaw-7140', '', ''),
(7141, 17, 0, 1, 'Side Lake', '', 'side-lake', '', ''),
(7142, 17, 0, 1, 'Soudan', '', 'soudan', '', ''),
(7143, 17, 0, 1, 'Sturgeon Lake', '', 'sturgeon-lake', '', ''),
(7144, 17, 0, 1, 'Swan River', '', 'swan-river', '', ''),
(7145, 17, 0, 1, 'Saint Charles', '', 'saint-charles-7145', '', ''),
(7146, 17, 0, 1, 'Spring Grove', '', 'spring-grove-7146', '', ''),
(7147, 17, 0, 1, 'Spring Valley', '', 'spring-valley-7147', '', ''),
(7148, 17, 0, 1, 'Stewartville', '', 'stewartville', '', ''),
(7149, 17, 0, 1, 'Stockton', '', 'stockton-7149', '', ''),
(7150, 17, 0, 1, 'Saint James', '', 'saint-james-7150', '', ''),
(7151, 17, 0, 1, 'Saint Peter', '', 'saint-peter', '', ''),
(7152, 17, 0, 1, 'Sanborn', '', 'sanborn', '', ''),
(7153, 17, 0, 1, 'Sleepy Eye', '', 'sleepy-eye', '', ''),
(7154, 17, 0, 1, 'Springfield', '', 'springfield-7154', '', ''),
(7155, 17, 0, 1, 'Tenstrike', '', 'tenstrike', '', ''),
(7156, 17, 0, 1, 'Turtle River', '', 'turtle-river', '', ''),
(7157, 17, 0, 1, 'Taopi', '', 'taopi', '', ''),
(7158, 17, 0, 1, 'Tyler', '', 'tyler-7158', '', ''),
(7159, 17, 0, 1, 'Thief River Fls', '', 'thief-river-fls', '', ''),
(7160, 17, 0, 1, 'Tracy', '', 'tracy-7160', '', ''),
(7161, 17, 0, 1, 'Twin Valley', '', 'twin-valley', '', ''),
(7162, 17, 0, 1, 'Trail', '', 'trail', '', ''),
(7163, 17, 0, 1, 'Truman', '', 'truman', '', ''),
(7164, 17, 0, 1, 'Taunton', '', 'taunton-7164', '', ''),
(7165, 17, 0, 1, 'Tintah', '', 'tintah', '', ''),
(7166, 17, 0, 1, 'Talmoon', '', 'talmoon', '', ''),
(7167, 17, 0, 1, 'Trosky', '', 'trosky', '', ''),
(7168, 17, 0, 1, 'Twin Lakes', '', 'twin-lakes-7168', '', ''),
(7169, 17, 0, 1, 'Upsala', '', 'upsala', '', ''),
(7170, 17, 0, 1, 'Utica', '', 'utica-7170', '', ''),
(7171, 17, 0, 1, 'Ulen', '', 'ulen', '', ''),
(7172, 17, 0, 1, 'Underwood', '', 'underwood-7172', '', ''),
(7173, 17, 0, 1, 'Villard', '', 'villard', '', ''),
(7174, 17, 0, 1, 'Victoria', '', 'victoria-7174', '', ''),
(7175, 17, 0, 1, 'Vermillion', '', 'vermillion-7175', '', ''),
(7176, 17, 0, 1, 'Vernon Center', '', 'vernon-center', '', ''),
(7177, 17, 0, 1, 'Vesta', '', 'vesta', '', ''),
(7178, 17, 0, 1, 'Vergas', '', 'vergas', '', ''),
(7179, 17, 0, 1, 'Vadnais Heights', '', 'vadnais-heights', '', ''),
(7180, 17, 0, 1, 'Verndale', '', 'verndale', '', ''),
(7181, 17, 0, 1, 'Viking', '', 'viking', '', ''),
(7182, 17, 0, 1, 'Vining', '', 'vining', '', ''),
(7183, 17, 0, 1, 'West St Paul', '', 'west-st-paul', '', ''),
(7184, 17, 0, 1, 'Wanamingo', '', 'wanamingo', '', ''),
(7185, 17, 0, 1, 'Wabasso', '', 'wabasso-7185', '', ''),
(7186, 17, 0, 1, 'Waterville', '', 'waterville-7186', '', ''),
(7187, 17, 0, 1, 'Welch', '', 'welch-7187', '', ''),
(7188, 17, 0, 1, 'Wyoming', '', 'wyoming-7188', '', ''),
(7189, 17, 0, 1, 'Willow River', '', 'willow-river', '', ''),
(7190, 17, 0, 1, 'Winnebago', '', 'winnebago-7190', '', ''),
(7191, 17, 0, 1, 'Watertown', '', 'watertown-7191', '', ''),
(7192, 17, 0, 1, 'Wells', '', 'wells-7192', '', ''),
(7193, 17, 0, 1, 'Waskish', '', 'waskish', '', ''),
(7194, 17, 0, 1, 'Walters', '', 'walters', '', ''),
(7195, 17, 0, 1, 'Wanda', '', 'wanda', '', ''),
(7196, 17, 0, 1, 'Winona', '', 'winona-7196', '', ''),
(7197, 17, 0, 1, 'Woodbury', '', 'woodbury-7197', '', ''),
(7198, 17, 0, 1, 'Walker', '', 'walker-7198', '', ''),
(7199, 17, 0, 1, 'Willernie', '', 'willernie', '', ''),
(7200, 17, 0, 1, 'West Concord', '', 'west-concord', '', ''),
(7201, 17, 0, 1, 'Wendell', '', 'wendell-7201', '', ''),
(7202, 17, 0, 1, 'Westbrook', '', 'westbrook-7202', '', ''),
(7203, 17, 0, 1, 'Wykoff', '', 'wykoff', '', ''),
(7204, 17, 0, 1, 'Worthington', '', 'worthington-7204', '', ''),
(7205, 17, 0, 1, 'Watkins', '', 'watkins-7205', '', ''),
(7206, 17, 0, 1, 'Waltham', '', 'waltham-7206', '', ''),
(7207, 17, 0, 1, 'Warren', '', 'warren-7207', '', ''),
(7208, 17, 0, 1, 'Woodstock', '', 'woodstock-7208', '', ''),
(7209, 17, 0, 1, 'Wrenshall', '', 'wrenshall', '', ''),
(7210, 17, 0, 1, 'Wadena', '', 'wadena-7210', '', ''),
(7211, 17, 0, 1, 'Wannaska', '', 'wannaska', '', ''),
(7212, 17, 0, 1, 'Winthrop', '', 'winthrop-7212', '', ''),
(7213, 17, 0, 1, 'Wright', '', 'wright', '', ''),
(7214, 17, 0, 1, 'Williams', '', 'williams-7214', '', ''),
(7215, 17, 0, 1, 'Waverly', '', 'waverly-7215', '', ''),
(7216, 17, 0, 1, 'Wolf Lake', '', 'wolf-lake', '', ''),
(7217, 17, 0, 1, 'Warsaw', '', 'warsaw-7217', '', ''),
(7218, 17, 0, 1, 'Wheaton', '', 'wheaton-7218', '', ''),
(7219, 17, 0, 1, 'Winger', '', 'winger', '', ''),
(7220, 17, 0, 1, 'Waldorf', '', 'waldorf-7220', '', ''),
(7221, 17, 0, 1, 'Welcome', '', 'welcome', '', ''),
(7222, 17, 0, 1, 'Wahkon', '', 'wahkon', '', ''),
(7223, 17, 0, 1, 'Webster', '', 'webster-7223', '', ''),
(7224, 17, 0, 1, 'Wolverton', '', 'wolverton', '', ''),
(7225, 17, 0, 1, 'Wood Lake', '', 'wood-lake', '', ''),
(7226, 17, 0, 1, 'West Union', '', 'west-union-7226', '', ''),
(7227, 17, 0, 1, 'Warba', '', 'warba', '', ''),
(7228, 17, 0, 1, 'Young America', '', 'young-america', '', ''),
(7229, 17, 0, 1, 'Zumbrota', '', 'zumbrota', '', ''),
(7230, 17, 0, 1, 'Zimmerman', '', 'zimmerman', '', ''),
(7231, 17, 0, 1, 'Zumbro Falls', '', 'zumbro-falls', '', ''),
(7232, 47, 0, 1, 'Silex', '', 'silex', '', ''),
(7233, 47, 0, 1, 'Shelbyville', '', 'shelbyville-7233', '', ''),
(7234, 47, 0, 1, 'Saint Marys', '', 'saint-marys-7234', '', ''),
(7235, 47, 0, 1, 'Scott City', '', 'scott-city-7235', '', ''),
(7236, 47, 0, 1, 'Senath', '', 'senath', '', ''),
(7237, 47, 0, 1, 'Steele', '', 'steele-7237', '', ''),
(7238, 47, 0, 1, 'Silva', '', 'silva', '', ''),
(7239, 47, 0, 1, 'Smithville', '', 'smithville-7239', '', ''),
(7240, 47, 0, 1, 'Strasburg', '', 'strasburg-7240', '', ''),
(7241, 47, 0, 1, 'Tarkio', '', 'tarkio', '', ''),
(7242, 47, 0, 1, 'Tebbetts', '', 'tebbetts', '', ''),
(7243, 47, 0, 1, 'Trenton', '', 'trenton-7243', '', ''),
(7244, 47, 0, 1, 'Tipton', '', 'tipton-7244', '', ''),
(7245, 47, 0, 1, 'Troy', '', 'troy-7245', '', ''),
(7246, 47, 0, 1, 'Tuscumbia', '', 'tuscumbia-7246', '', ''),
(7247, 47, 0, 1, 'Theodosia', '', 'theodosia', '', ''),
(7248, 47, 0, 1, 'Thayer', '', 'thayer-7248', '', ''),
(7249, 47, 0, 1, 'Taylor', '', 'taylor-7249', '', ''),
(7250, 47, 0, 1, 'Thornfield', '', 'thornfield', '', ''),
(7251, 47, 0, 1, 'Taneyville', '', 'taneyville', '', ''),
(7252, 47, 0, 1, 'Treloar', '', 'treloar', '', ''),
(7253, 47, 0, 1, 'Union', '', 'union-7253', '', ''),
(7254, 47, 0, 1, 'Urich', '', 'urich', '', ''),
(7255, 47, 0, 1, 'Urbana', '', 'urbana-7255', '', ''),
(7256, 47, 0, 1, 'Union Star', '', 'union-star', '', ''),
(7257, 47, 0, 1, 'Unionville', '', 'unionville-7257', '', ''),
(7258, 47, 0, 1, 'Utica', '', 'utica-7258', '', ''),
(7259, 47, 0, 1, 'University City', '', 'university-city', '', ''),
(7260, 47, 0, 1, 'Ulman', '', 'ulman', '', ''),
(7261, 47, 0, 1, 'Vandalia', '', 'vandalia-7261', '', ''),
(7262, 47, 0, 1, 'Villa Ridge', '', 'villa-ridge', '', ''),
(7263, 47, 0, 1, 'Van Buren', '', 'van-buren-7263', '', ''),
(7264, 47, 0, 1, 'Vanzant', '', 'vanzant', '', ''),
(7265, 47, 0, 1, 'Viburnum', '', 'viburnum', '', ''),
(7266, 47, 0, 1, 'Valles Mines', '', 'valles-mines', '', ''),
(7267, 47, 0, 1, 'Versailles', '', 'versailles-7267', '', ''),
(7268, 47, 0, 1, 'Vienna', '', 'vienna-7268', '', ''),
(7269, 47, 0, 1, 'Valley Park', '', 'valley-park', '', ''),
(7270, 47, 0, 1, 'Vanduser', '', 'vanduser', '', ''),
(7271, 47, 0, 1, 'Verona', '', 'verona-7271', '', ''),
(7272, 47, 0, 1, 'Washburn', '', 'washburn-7272', '', ''),
(7273, 47, 0, 1, 'Wheaton', '', 'wheaton-7273', '', ''),
(7274, 47, 0, 1, 'Williamsburg', '', 'williamsburg-7274', '', ''),
(7275, 47, 0, 1, 'Wheatland', '', 'wheatland-7275', '', ''),
(7276, 47, 0, 1, 'Washington', '', 'washington-7276', '', ''),
(7277, 47, 0, 1, 'Windsor', '', 'windsor-7277', '', ''),
(7278, 47, 0, 1, 'Wyaconda', '', 'wyaconda', '', ''),
(7279, 47, 0, 1, 'Winston', '', 'winston-7279', '', ''),
(7280, 47, 0, 1, 'Walnut Grove', '', 'walnut-grove-7280', '', ''),
(7281, 47, 0, 1, 'Willard', '', 'willard-7281', '', ''),
(7282, 47, 0, 1, 'Wayland', '', 'wayland-7282', '', ''),
(7283, 47, 0, 1, 'Willow Springs', '', 'willow-springs-7283', '', ''),
(7284, 47, 0, 1, 'Whiteman Afb', '', 'whiteman-afb', '', ''),
(7285, 47, 0, 1, 'Weston', '', 'weston-7285', '', ''),
(7286, 47, 0, 1, 'Waynesville', '', 'waynesville-7286', '', ''),
(7287, 47, 0, 1, 'Westphalia', '', 'westphalia-7287', '', ''),
(7288, 47, 0, 1, 'Waverly', '', 'waverly-7288', '', ''),
(7289, 47, 0, 1, 'Wellsville', '', 'wellsville-7289', '', ''),
(7290, 47, 0, 1, 'Wardell', '', 'wardell', '', ''),
(7291, 47, 0, 1, 'Wellington', '', 'wellington-7291', '', ''),
(7292, 47, 0, 1, 'Wyatt', '', 'wyatt-7292', '', ''),
(7293, 47, 0, 1, 'Webster Groves', '', 'webster-groves', '', ''),
(7294, 47, 0, 1, 'Winona', '', 'winona-7294', '', ''),
(7295, 47, 0, 1, 'West Alton', '', 'west-alton', '', ''),
(7296, 47, 0, 1, 'Wright City', '', 'wright-city', '', ''),
(7297, 47, 0, 1, 'Winigan', '', 'winigan', '', ''),
(7298, 47, 0, 1, 'Warrenton', '', 'warrenton-7298', '', ''),
(7299, 47, 0, 1, 'Walker', '', 'walker-7299', '', ''),
(7300, 47, 0, 1, 'Wappapello', '', 'wappapello', '', ''),
(7301, 47, 0, 1, 'Walnut Shade', '', 'walnut-shade', '', ''),
(7302, 47, 0, 1, 'Weaubleau', '', 'weaubleau', '', ''),
(7303, 47, 0, 1, 'Williamsville', '', 'williamsville-7303', '', ''),
(7304, 47, 0, 1, 'Zalma', '', 'zalma', '', ''),
(7305, 61, 0, 1, 'Tylertown', '', 'tylertown', '', ''),
(7306, 61, 0, 1, 'Tutwiler', '', 'tutwiler', '', ''),
(7307, 61, 0, 1, 'Terry', '', 'terry', '', ''),
(7308, 61, 0, 1, 'Tunica', '', 'tunica', '', ''),
(7309, 61, 0, 1, 'Tougaloo', '', 'tougaloo', '', ''),
(7310, 61, 0, 1, 'Taylorsville', '', 'taylorsville-7310', '', ''),
(7311, 61, 0, 1, 'Tishomingo', '', 'tishomingo-7311', '', ''),
(7312, 61, 0, 1, 'Tchula', '', 'tchula', '', ''),
(7313, 61, 0, 1, 'Toomsuba', '', 'toomsuba', '', ''),
(7314, 61, 0, 1, 'Taylor', '', 'taylor-7314', '', ''),
(7315, 61, 0, 1, 'Tillatoba', '', 'tillatoba', '', ''),
(7316, 61, 0, 1, 'Utica', '', 'utica-7316', '', ''),
(7317, 61, 0, 1, 'Union', '', 'union-7317', '', ''),
(7318, 61, 0, 1, 'University', '', 'university', '', ''),
(7319, 61, 0, 1, 'Vaiden', '', 'vaiden', '', ''),
(7320, 61, 0, 1, 'Vardaman', '', 'vardaman', '', ''),
(7321, 61, 0, 1, 'Verona', '', 'verona-7321', '', ''),
(7322, 61, 0, 1, 'West Point', '', 'west-point-7322', '', ''),
(7323, 61, 0, 1, 'Wiggins', '', 'wiggins-7323', '', ''),
(7324, 61, 0, 1, 'Wesson', '', 'wesson', '', ''),
(7325, 61, 0, 1, 'Winstonville', '', 'winstonville', '', ''),
(7326, 61, 0, 1, 'West', '', 'west', '', ''),
(7327, 61, 0, 1, 'Weir', '', 'weir-7327', '', ''),
(7328, 61, 0, 1, 'Walnut', '', 'walnut-7328', '', ''),
(7329, 61, 0, 1, 'Webb', '', 'webb-7329', '', ''),
(7330, 61, 0, 1, 'Walnut Grove', '', 'walnut-grove-7330', '', ''),
(7331, 61, 0, 1, 'Winona', '', 'winona-7331', '', ''),
(7332, 61, 0, 1, 'Waynesboro', '', 'waynesboro-7332', '', ''),
(7333, 61, 0, 1, 'Woodville', '', 'woodville-7333', '', ''),
(7334, 61, 0, 1, 'Water Valley', '', 'water-valley', '', ''),
(7335, 61, 0, 1, 'Yazoo City', '', 'yazoo-city', '', ''),
(7336, 53, 0, 1, 'Shelby', '', 'shelby-7336', '', ''),
(7337, 53, 0, 1, 'Sidney', '', 'sidney-7337', '', ''),
(7338, 53, 0, 1, 'Shepherd', '', 'shepherd', '', ''),
(7339, 53, 0, 1, 'Saco', '', 'saco-7339', '', ''),
(7340, 53, 0, 1, 'Savage', '', 'savage-7340', '', ''),
(7341, 53, 0, 1, 'Stanford', '', 'stanford-7341', '', ''),
(7342, 53, 0, 1, 'Stockett', '', 'stockett', '', ''),
(7343, 53, 0, 1, 'Sun River', '', 'sun-river', '', ''),
(7344, 53, 0, 1, 'Sweetgrass', '', 'sweetgrass', '', ''),
(7345, 53, 0, 1, 'Sheridan', '', 'sheridan-7345', '', ''),
(7346, 53, 0, 1, 'Silver Star', '', 'silver-star', '', ''),
(7347, 53, 0, 1, 'Saint Regis', '', 'saint-regis', '', ''),
(7348, 53, 0, 1, 'Superior', '', 'superior-7348', '', ''),
(7349, 53, 0, 1, 'Somers', '', 'somers-7349', '', ''),
(7350, 53, 0, 1, 'Townsend', '', 'townsend-7350', '', ''),
(7351, 53, 0, 1, 'Twin Bridges', '', 'twin-bridges-7351', '', ''),
(7352, 53, 0, 1, 'Troy', '', 'troy-7352', '', ''),
(7353, 53, 0, 1, 'Trout Creek', '', 'trout-creek', '', ''),
(7354, 53, 0, 1, 'Thompson Falls', '', 'thompson-falls', '', ''),
(7355, 53, 0, 1, 'Terry', '', 'terry-7355', '', ''),
(7356, 53, 0, 1, 'Twodot', '', 'twodot', '', ''),
(7357, 53, 0, 1, 'Turner', '', 'turner', '', ''),
(7358, 53, 0, 1, 'Toston', '', 'toston', '', ''),
(7359, 53, 0, 1, 'Ulm', '', 'ulm-7359', '', ''),
(7360, 53, 0, 1, 'Victor', '', 'victor-7360', '', ''),
(7361, 53, 0, 1, 'Valier', '', 'valier', '', ''),
(7362, 53, 0, 1, 'Vida', '', 'vida', '', ''),
(7363, 53, 0, 1, 'Vaughn', '', 'vaughn', '', ''),
(7364, 53, 0, 1, 'Wolf Creek', '', 'wolf-creek', '', ''),
(7365, 53, 0, 1, 'White Slphr Spgs', '', 'white-slphr-spgs', '', ''),
(7366, 53, 0, 1, 'Winnett', '', 'winnett', '', ''),
(7367, 53, 0, 1, 'Whitehall', '', 'whitehall-7367', '', ''),
(7368, 53, 0, 1, 'Worden', '', 'worden-7368', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(7369, 53, 0, 1, 'Wibaux', '', 'wibaux', '', ''),
(7370, 53, 0, 1, 'Westby', '', 'westby', '', ''),
(7371, 53, 0, 1, 'Wilsall', '', 'wilsall', '', ''),
(7372, 53, 0, 1, 'Winifred', '', 'winifred', '', ''),
(7373, 53, 0, 1, 'White Sulphur Springs', '', 'white-sulphur-springs', '', ''),
(7374, 53, 0, 1, 'Wisdom', '', 'wisdom', '', ''),
(7375, 53, 0, 1, 'West Glacier', '', 'west-glacier', '', ''),
(7376, 53, 0, 1, 'Zortman', '', 'zortman', '', ''),
(7377, 22, 0, 1, 'Scotland Neck', '', 'scotland-neck', '', ''),
(7378, 22, 0, 1, 'Seaboard', '', 'seaboard', '', ''),
(7379, 22, 0, 1, 'Severn', '', 'severn-7379', '', ''),
(7380, 22, 0, 1, 'Sharpsburg', '', 'sharpsburg-7380', '', ''),
(7381, 22, 0, 1, 'Sims', '', 'sims', '', ''),
(7382, 22, 0, 1, 'Spring Hope', '', 'spring-hope', '', ''),
(7383, 22, 0, 1, 'Stantonsburg', '', 'stantonsburg', '', ''),
(7384, 22, 0, 1, 'Shiloh', '', 'shiloh-7384', '', ''),
(7385, 22, 0, 1, 'Sunbury', '', 'sunbury-7385', '', ''),
(7386, 22, 0, 1, 'Salisbury', '', 'salisbury-7386', '', ''),
(7387, 22, 0, 1, 'Trenton', '', 'trenton-7387', '', ''),
(7388, 22, 0, 1, 'Topsail Beach', '', 'topsail-beach', '', ''),
(7389, 22, 0, 1, 'Timberlake', '', 'timberlake', '', ''),
(7390, 22, 0, 1, 'Trinity', '', 'trinity-7390', '', ''),
(7391, 22, 0, 1, 'Tobaccoville', '', 'tobaccoville', '', ''),
(7392, 22, 0, 1, 'Thomasville', '', 'thomasville-7392', '', ''),
(7393, 22, 0, 1, 'Traphill', '', 'traphill', '', ''),
(7394, 22, 0, 1, 'Troy', '', 'troy-7394', '', ''),
(7395, 22, 0, 1, 'Townsville', '', 'townsville', '', ''),
(7396, 22, 0, 1, 'Tuckasegee', '', 'tuckasegee', '', ''),
(7397, 22, 0, 1, 'Tabor City', '', 'tabor-city', '', ''),
(7398, 22, 0, 1, 'Tar Heel', '', 'tar-heel', '', ''),
(7399, 22, 0, 1, 'Toast', '', 'toast', '', ''),
(7400, 22, 0, 1, 'Tyner', '', 'tyner', '', ''),
(7401, 22, 0, 1, 'Terrell', '', 'terrell-7401', '', ''),
(7402, 22, 0, 1, 'Tuxedo', '', 'tuxedo', '', ''),
(7403, 22, 0, 1, 'Tryon', '', 'tryon', '', ''),
(7404, 22, 0, 1, 'Topton', '', 'topton', '', ''),
(7405, 22, 0, 1, 'Union Grove', '', 'union-grove-7405', '', ''),
(7406, 22, 0, 1, 'Union Mills', '', 'union-mills-7406', '', ''),
(7407, 22, 0, 1, 'Vale', '', 'vale', '', ''),
(7408, 22, 0, 1, 'Valle Crucis', '', 'valle-crucis', '', ''),
(7409, 22, 0, 1, 'Valdese', '', 'valdese', '', ''),
(7410, 22, 0, 1, 'Vilas', '', 'vilas', '', ''),
(7411, 22, 0, 1, 'Washington', '', 'washington-7411', '', ''),
(7412, 22, 0, 1, 'Wallace', '', 'wallace-7412', '', ''),
(7413, 22, 0, 1, 'Warsaw', '', 'warsaw-7413', '', ''),
(7414, 22, 0, 1, 'Walkertown', '', 'walkertown', '', ''),
(7415, 22, 0, 1, 'Williamston', '', 'williamston-7415', '', ''),
(7416, 22, 0, 1, 'Winton', '', 'winton-7416', '', ''),
(7417, 22, 0, 1, 'Whitakers', '', 'whitakers', '', ''),
(7418, 22, 0, 1, 'Waves', '', 'waves', '', ''),
(7419, 22, 0, 1, 'Walstonburg', '', 'walstonburg', '', ''),
(7420, 22, 0, 1, 'Windsor', '', 'windsor-7420', '', ''),
(7421, 22, 0, 1, 'Wade', '', 'wade', '', ''),
(7422, 22, 0, 1, 'Welcome', '', 'welcome-7422', '', ''),
(7423, 22, 0, 1, 'Waynesville', '', 'waynesville-7423', '', ''),
(7424, 22, 0, 1, 'Whitsett', '', 'whitsett', '', ''),
(7425, 22, 0, 1, 'Walnut Cove', '', 'walnut-cove', '', ''),
(7426, 22, 0, 1, 'Warrensville', '', 'warrensville', '', ''),
(7427, 22, 0, 1, 'Wilmington', '', 'wilmington-7427', '', ''),
(7428, 22, 0, 1, 'Watha', '', 'watha', '', ''),
(7429, 22, 0, 1, 'Whittier', '', 'whittier-7429', '', ''),
(7430, 22, 0, 1, 'Wilson', '', 'wilson-7430', '', ''),
(7431, 22, 0, 1, 'Winterville', '', 'winterville-7431', '', ''),
(7432, 22, 0, 1, 'Wrightsville Bch', '', 'wrightsville-bch', '', ''),
(7433, 22, 0, 1, 'Willow Spring', '', 'willow-spring', '', ''),
(7434, 22, 0, 1, 'Wagram', '', 'wagram', '', ''),
(7435, 22, 0, 1, 'Woodleaf', '', 'woodleaf', '', ''),
(7436, 22, 0, 1, 'Westfield', '', 'westfield-7436', '', ''),
(7437, 22, 0, 1, 'White Oak', '', 'white-oak-7437', '', ''),
(7438, 22, 0, 1, 'Weddington', '', 'weddington', '', ''),
(7439, 22, 0, 1, 'Wilsons Mills', '', 'wilsons-mills', '', ''),
(7440, 22, 0, 1, 'Warrenton', '', 'warrenton-7440', '', ''),
(7441, 22, 0, 1, 'West End', '', 'west-end', '', ''),
(7442, 22, 0, 1, 'Woodland', '', 'woodland-7442', '', ''),
(7443, 22, 0, 1, 'Waxhaw', '', 'waxhaw', '', ''),
(7444, 22, 0, 1, 'Wallburg', '', 'wallburg', '', ''),
(7445, 22, 0, 1, 'Yanceyville', '', 'yanceyville', '', ''),
(7446, 22, 0, 1, 'Zebulon', '', 'zebulon-7446', '', ''),
(7447, 59, 0, 1, 'Turtle Lake', '', 'turtle-lake-7447', '', ''),
(7448, 59, 0, 1, 'Thompson', '', 'thompson', '', ''),
(7449, 59, 0, 1, 'Tolna', '', 'tolna', '', ''),
(7450, 59, 0, 1, 'Tuttle', '', 'tuttle-7450', '', ''),
(7451, 59, 0, 1, 'Taylor', '', 'taylor-7451', '', ''),
(7452, 59, 0, 1, 'Tolley', '', 'tolley', '', ''),
(7453, 59, 0, 1, 'Towner', '', 'towner', '', ''),
(7454, 59, 0, 1, 'Tioga', '', 'tioga-7454', '', ''),
(7455, 59, 0, 1, 'Underwood', '', 'underwood-7455', '', ''),
(7456, 59, 0, 1, 'Upham', '', 'upham', '', ''),
(7457, 59, 0, 1, 'Verona', '', 'verona-7457', '', ''),
(7458, 59, 0, 1, 'Venturia', '', 'venturia', '', ''),
(7459, 59, 0, 1, 'Velva', '', 'velva', '', ''),
(7460, 59, 0, 1, 'Williston', '', 'williston-7460', '', ''),
(7461, 59, 0, 1, 'Wildrose', '', 'wildrose', '', ''),
(7462, 59, 0, 1, 'Windsor', '', 'windsor-7462', '', ''),
(7463, 59, 0, 1, 'Woodworth', '', 'woodworth-7463', '', ''),
(7464, 59, 0, 1, 'Wales', '', 'wales-7464', '', ''),
(7465, 59, 0, 1, 'Walhalla', '', 'walhalla', '', ''),
(7466, 59, 0, 1, 'Willow City', '', 'willow-city', '', ''),
(7467, 59, 0, 1, 'Washburn', '', 'washburn-7467', '', ''),
(7468, 59, 0, 1, 'Watford City', '', 'watford-city', '', ''),
(7469, 59, 0, 1, 'Wilton', '', 'wilton-7469', '', ''),
(7470, 59, 0, 1, 'Walcott', '', 'walcott-7470', '', ''),
(7471, 59, 0, 1, 'Wyndmere', '', 'wyndmere', '', ''),
(7472, 59, 0, 1, 'Wimbledon', '', 'wimbledon', '', ''),
(7473, 59, 0, 1, 'Warwick', '', 'warwick-7473', '', ''),
(7474, 59, 0, 1, 'Wing', '', 'wing', '', ''),
(7475, 59, 0, 1, 'Westhope', '', 'westhope', '', ''),
(7476, 59, 0, 1, 'Wheatland', '', 'wheatland-7476', '', ''),
(7477, 59, 0, 1, 'Ypsilanti', '', 'ypsilanti-7477', '', ''),
(7478, 59, 0, 1, 'Zeeland', '', 'zeeland-7478', '', ''),
(7479, 59, 0, 1, 'Zap', '', 'zap', '', ''),
(7480, 58, 0, 1, 'Scottsbluff', '', 'scottsbluff', '', ''),
(7481, 58, 0, 1, 'Seward', '', 'seward-7481', '', ''),
(7482, 58, 0, 1, 'Steele City', '', 'steele-city', '', ''),
(7483, 58, 0, 1, 'Stapleton', '', 'stapleton', '', ''),
(7484, 58, 0, 1, 'Sterling', '', 'sterling-7484', '', ''),
(7485, 58, 0, 1, 'Sutherland', '', 'sutherland', '', ''),
(7486, 58, 0, 1, 'Sprague', '', 'sprague-7486', '', ''),
(7487, 58, 0, 1, 'Stromsburg', '', 'stromsburg', '', ''),
(7488, 58, 0, 1, 'Springfield', '', 'springfield-7488', '', ''),
(7489, 58, 0, 1, 'Salem', '', 'salem-7489', '', ''),
(7490, 58, 0, 1, 'Shelby', '', 'shelby-7490', '', ''),
(7491, 58, 0, 1, 'St Paul', '', 'st-paul', '', ''),
(7492, 58, 0, 1, 'Superior', '', 'superior-7492', '', ''),
(7493, 58, 0, 1, 'Syracuse', '', 'syracuse-7493', '', ''),
(7494, 58, 0, 1, 'Steinauer', '', 'steinauer', '', ''),
(7495, 58, 0, 1, 'Stanton', '', 'stanton-7495', '', ''),
(7496, 58, 0, 1, 'Swanton', '', 'swanton-7496', '', ''),
(7497, 58, 0, 1, 'Springview', '', 'springview', '', ''),
(7498, 58, 0, 1, 'Shelton', '', 'shelton-7498', '', ''),
(7499, 58, 0, 1, 'Silver Creek', '', 'silver-creek-7499', '', ''),
(7500, 58, 0, 1, 'Schuyler', '', 'schuyler', '', ''),
(7501, 58, 0, 1, 'Scotia', '', 'scotia', '', ''),
(7502, 58, 0, 1, 'Stratton', '', 'stratton-7502', '', ''),
(7503, 58, 0, 1, 'Seneca', '', 'seneca-7503', '', ''),
(7504, 58, 0, 1, 'Shubert', '', 'shubert', '', ''),
(7505, 58, 0, 1, 'Spencer', '', 'spencer-7505', '', ''),
(7506, 58, 0, 1, 'Staplehurst', '', 'staplehurst', '', ''),
(7507, 58, 0, 1, 'Stella', '', 'stella', '', ''),
(7508, 58, 0, 1, 'Stockville', '', 'stockville', '', ''),
(7509, 58, 0, 1, 'Snyder', '', 'snyder-7509', '', ''),
(7510, 58, 0, 1, 'Spalding', '', 'spalding', '', ''),
(7511, 58, 0, 1, 'Shickley', '', 'shickley', '', ''),
(7512, 58, 0, 1, 'Sargent', '', 'sargent', '', ''),
(7513, 58, 0, 1, 'St Edward', '', 'st-edward', '', ''),
(7514, 58, 0, 1, 'Sutton', '', 'sutton-7514', '', ''),
(7515, 58, 0, 1, 'Sumner', '', 'sumner-7515', '', ''),
(7516, 58, 0, 1, 'Scribner', '', 'scribner', '', ''),
(7517, 58, 0, 1, 'Stamford', '', 'stamford-7517', '', ''),
(7518, 58, 0, 1, 'Saint Edward', '', 'saint-edward', '', ''),
(7519, 58, 0, 1, 'Stuart', '', 'stuart-7519', '', ''),
(7520, 58, 0, 1, 'Saint Libory', '', 'saint-libory-7520', '', ''),
(7521, 58, 0, 1, 'Saint Paul', '', 'saint-paul-7521', '', ''),
(7522, 58, 0, 1, 'Tilden', '', 'tilden-7522', '', ''),
(7523, 58, 0, 1, 'Tryon', '', 'tryon-7523', '', ''),
(7524, 58, 0, 1, 'Taylor', '', 'taylor-7524', '', ''),
(7525, 58, 0, 1, 'Tecumseh', '', 'tecumseh-7525', '', ''),
(7526, 58, 0, 1, 'Trenton', '', 'trenton-7526', '', ''),
(7527, 58, 0, 1, 'Tobias', '', 'tobias', '', ''),
(7528, 58, 0, 1, 'Table Rock', '', 'table-rock', '', ''),
(7529, 58, 0, 1, 'Thedford', '', 'thedford', '', ''),
(7530, 58, 0, 1, 'Uehling', '', 'uehling', '', ''),
(7531, 58, 0, 1, 'Upland', '', 'upland-7531', '', ''),
(7532, 58, 0, 1, 'Union', '', 'union-7532', '', ''),
(7533, 58, 0, 1, 'Unadilla', '', 'unadilla-7533', '', ''),
(7534, 58, 0, 1, 'Utica', '', 'utica-7534', '', ''),
(7535, 58, 0, 1, 'Valentine', '', 'valentine', '', ''),
(7536, 58, 0, 1, 'Valley', '', 'valley-7536', '', ''),
(7537, 58, 0, 1, 'Venango', '', 'venango', '', ''),
(7538, 58, 0, 1, 'Verdigre', '', 'verdigre', '', ''),
(7539, 58, 0, 1, 'Valparaiso', '', 'valparaiso-7539', '', ''),
(7540, 58, 0, 1, 'Verdon', '', 'verdon', '', ''),
(7541, 58, 0, 1, 'Wymore', '', 'wymore', '', ''),
(7542, 58, 0, 1, 'West Point', '', 'west-point-7542', '', ''),
(7543, 58, 0, 1, 'Wisner', '', 'wisner-7543', '', ''),
(7544, 58, 0, 1, 'Wynot', '', 'wynot', '', ''),
(7545, 58, 0, 1, 'Waterbury', '', 'waterbury-7545', '', ''),
(7546, 58, 0, 1, 'Wauneta', '', 'wauneta', '', ''),
(7547, 58, 0, 1, 'Wood River', '', 'wood-river-7547', '', ''),
(7548, 58, 0, 1, 'Wolbach', '', 'wolbach', '', ''),
(7549, 58, 0, 1, 'Waterloo', '', 'waterloo-7549', '', ''),
(7550, 58, 0, 1, 'Wakefield', '', 'wakefield-7550', '', ''),
(7551, 58, 0, 1, 'Wood Lake', '', 'wood-lake-7551', '', ''),
(7552, 58, 0, 1, 'Walton', '', 'walton-7552', '', ''),
(7553, 58, 0, 1, 'Wausa', '', 'wausa', '', ''),
(7554, 58, 0, 1, 'Wellfleet', '', 'wellfleet-7554', '', ''),
(7555, 58, 0, 1, 'Wallace', '', 'wallace-7555', '', ''),
(7556, 58, 0, 1, 'Winnetoon', '', 'winnetoon', '', ''),
(7557, 58, 0, 1, 'Waverly', '', 'waverly-7557', '', ''),
(7558, 58, 0, 1, 'Western', '', 'western', '', ''),
(7559, 58, 0, 1, 'Wayne', '', 'wayne-7559', '', ''),
(7560, 58, 0, 1, 'Wahoo', '', 'wahoo', '', ''),
(7561, 58, 0, 1, 'Whiteclay', '', 'whiteclay', '', ''),
(7562, 58, 0, 1, 'Walthill', '', 'walthill', '', ''),
(7563, 58, 0, 1, 'Wilber', '', 'wilber', '', ''),
(7564, 58, 0, 1, 'Winside', '', 'winside', '', ''),
(7565, 58, 0, 1, 'Winnebago', '', 'winnebago-7565', '', ''),
(7566, 58, 0, 1, 'Waco', '', 'waco-7566', '', ''),
(7567, 58, 0, 1, 'Wilcox', '', 'wilcox', '', ''),
(7568, 58, 0, 1, 'Weston', '', 'weston-7568', '', ''),
(7569, 58, 0, 1, 'Winslow', '', 'winslow-7569', '', ''),
(7570, 58, 0, 1, 'York', '', 'york-7570', '', ''),
(7571, 58, 0, 1, 'Yutan', '', 'yutan', '', ''),
(7572, 19, 0, 1, 'Strafford', '', 'strafford', '', ''),
(7573, 19, 0, 1, 'Stratham', '', 'stratham', '', ''),
(7574, 19, 0, 1, 'Seabrook', '', 'seabrook-7574', '', ''),
(7575, 19, 0, 1, 'South Hampton', '', 'south-hampton', '', ''),
(7576, 19, 0, 1, 'Spofford', '', 'spofford', '', ''),
(7577, 19, 0, 1, 'Swanzey', '', 'swanzey', '', ''),
(7578, 19, 0, 1, 'Sunapee', '', 'sunapee', '', ''),
(7579, 19, 0, 1, 'Sanbornville', '', 'sanbornville', '', ''),
(7580, 19, 0, 1, 'Sandown', '', 'sandown', '', ''),
(7581, 19, 0, 1, 'Silver Lake', '', 'silver-lake-7581', '', ''),
(7582, 19, 0, 1, 'Tilton', '', 'tilton-7582', '', ''),
(7583, 19, 0, 1, 'Twin Mountain', '', 'twin-mountain', '', ''),
(7584, 19, 0, 1, 'Thornton', '', 'thornton-7584', '', ''),
(7585, 19, 0, 1, 'Temple', '', 'temple-7585', '', ''),
(7586, 19, 0, 1, 'Troy', '', 'troy-7586', '', ''),
(7587, 19, 0, 1, 'Union', '', 'union-7587', '', ''),
(7588, 19, 0, 1, 'Wolfeboro Falls', '', 'wolfeboro-falls', '', ''),
(7589, 19, 0, 1, 'Woodsville', '', 'woodsville', '', ''),
(7590, 19, 0, 1, 'Warren', '', 'warren-7590', '', ''),
(7591, 19, 0, 1, 'Windham', '', 'windham-7591', '', ''),
(7592, 19, 0, 1, 'Waterville Vly', '', 'waterville-vly', '', ''),
(7593, 19, 0, 1, 'Winnisquam', '', 'winnisquam', '', ''),
(7594, 19, 0, 1, 'Wilmot', '', 'wilmot-7594', '', ''),
(7595, 19, 0, 1, 'W Stewartstown', '', 'w-stewartstown', '', ''),
(7596, 19, 0, 1, 'West Ossipee', '', 'west-ossipee', '', ''),
(7597, 19, 0, 1, 'Winchester', '', 'winchester-7597', '', ''),
(7598, 19, 0, 1, 'Walpole', '', 'walpole-7598', '', ''),
(7599, 19, 0, 1, 'W Chesterfield', '', 'w-chesterfield', '', ''),
(7600, 19, 0, 1, 'West Swanzey', '', 'west-swanzey', '', ''),
(7601, 19, 0, 1, 'Wilton', '', 'wilton-7601', '', ''),
(7602, 19, 0, 1, 'Westmoreland', '', 'westmoreland-7602', '', ''),
(7603, 19, 0, 1, 'West Springfield', '', 'west-springfield-7603', '', ''),
(7604, 19, 0, 1, 'Wilmot Flat', '', 'wilmot-flat', '', ''),
(7605, 19, 0, 1, 'Woodstock', '', 'woodstock-7605', '', ''),
(7606, 19, 0, 1, 'West Stewartstown', '', 'west-stewartstown', '', ''),
(7607, 7, 0, 1, 'Union', '', 'union-7607', '', ''),
(7608, 7, 0, 1, 'Upper Saddle Rvr', '', 'upper-saddle-rvr', '', ''),
(7609, 7, 0, 1, 'Vincentown', '', 'vincentown', '', ''),
(7610, 7, 0, 1, 'Wall Township', '', 'wall-township', '', ''),
(7611, 7, 0, 1, 'Wayne', '', 'wayne-7611', '', ''),
(7612, 7, 0, 1, 'Wood Ridge', '', 'wood-ridge', '', ''),
(7613, 7, 0, 1, 'Washington Twp', '', 'washington-twp', '', ''),
(7614, 7, 0, 1, 'Williamstown', '', 'williamstown-7614', '', ''),
(7615, 7, 0, 1, 'Windsor', '', 'windsor-7615', '', ''),
(7616, 7, 0, 1, 'Westmont', '', 'westmont-7616', '', ''),
(7617, 7, 0, 1, 'Winslow', '', 'winslow-7617', '', ''),
(7618, 7, 0, 1, 'Waterford Works', '', 'waterford-works', '', ''),
(7619, 7, 0, 1, 'Whitehouse Sta', '', 'whitehouse-sta', '', ''),
(7620, 7, 0, 1, 'W Collingswd Hts', '', 'w-collingswd-hts', '', ''),
(7621, 7, 0, 1, 'Whitehouse', '', 'whitehouse-7621', '', ''),
(7622, 7, 0, 1, 'Washington', '', 'washington-7622', '', ''),
(7623, 7, 0, 1, 'Whiting', '', 'whiting-7623', '', ''),
(7624, 7, 0, 1, 'Westampton', '', 'westampton', '', ''),
(7625, 7, 0, 1, 'W Collingswood', '', 'w-collingswood', '', ''),
(7626, 7, 0, 1, 'Whitesboro', '', 'whitesboro-7626', '', ''),
(7627, 7, 0, 1, 'Wall', '', 'wall', '', ''),
(7628, 7, 0, 1, 'West Creek', '', 'west-creek', '', ''),
(7629, 7, 0, 1, 'Wickatunk', '', 'wickatunk', '', ''),
(7630, 7, 0, 1, 'Wallpack Center', '', 'wallpack-center', '', ''),
(7631, 7, 0, 1, 'White House Station', '', 'white-house-station', '', ''),
(7632, 7, 0, 1, 'Wood-Ridge', '', 'wood-ridge-7632', '', ''),
(7633, 45, 0, 1, 'Shiprock', '', 'shiprock', '', ''),
(7634, 45, 0, 1, 'Santa Teresa', '', 'santa-teresa', '', ''),
(7635, 45, 0, 1, 'Santa Rosa', '', 'santa-rosa-7635', '', ''),
(7636, 45, 0, 1, 'Springer', '', 'springer', '', ''),
(7637, 45, 0, 1, 'Socorro', '', 'socorro-7637', '', ''),
(7638, 45, 0, 1, 'Sandia Park', '', 'sandia-park', '', ''),
(7639, 45, 0, 1, 'San Patricio', '', 'san-patricio', '', ''),
(7640, 45, 0, 1, 'San Jon', '', 'san-jon', '', ''),
(7641, 45, 0, 1, 'San Antonio', '', 'san-antonio-7641', '', ''),
(7642, 45, 0, 1, 'San Juan Pueblo', '', 'san-juan-pueblo', '', ''),
(7643, 45, 0, 1, 'Santa Cruz', '', 'santa-cruz-7643', '', ''),
(7644, 45, 0, 1, 'San Rafael', '', 'san-rafael-7644', '', ''),
(7645, 45, 0, 1, 'Stanley', '', 'stanley-7645', '', ''),
(7646, 45, 0, 1, 'Truth Or Cnsqncs', '', 'truth-or-cnsqncs', '', ''),
(7647, 45, 0, 1, 'Tesuque', '', 'tesuque', '', ''),
(7648, 45, 0, 1, 'Tinnie', '', 'tinnie', '', ''),
(7649, 45, 0, 1, 'Timberon', '', 'timberon', '', ''),
(7650, 45, 0, 1, 'Tijeras', '', 'tijeras', '', ''),
(7651, 45, 0, 1, 'Texico', '', 'texico', '', ''),
(7652, 45, 0, 1, 'Tatum', '', 'tatum', '', ''),
(7653, 45, 0, 1, 'Tierra Amarilla', '', 'tierra-amarilla', '', ''),
(7654, 45, 0, 1, 'Tyrone', '', 'tyrone-7654', '', ''),
(7655, 45, 0, 1, 'Vaughn', '', 'vaughn-7655', '', ''),
(7656, 45, 0, 1, 'Velarde', '', 'velarde', '', ''),
(7657, 45, 0, 1, 'Veguita', '', 'veguita', '', ''),
(7658, 45, 0, 1, 'White Sands', '', 'white-sands', '', ''),
(7659, 45, 0, 1, 'Weed', '', 'weed-7659', '', ''),
(7660, 45, 0, 1, 'Williamsburg', '', 'williamsburg-7660', '', ''),
(7661, 45, 0, 1, 'Wagon Mound', '', 'wagon-mound', '', ''),
(7662, 45, 0, 1, 'Willard', '', 'willard-7662', '', ''),
(7663, 51, 0, 1, 'Sun Valley', '', 'sun-valley-7663', '', ''),
(7664, 51, 0, 1, 'Spring Creek', '', 'spring-creek', '', ''),
(7665, 51, 0, 1, 'Silver Springs', '', 'silver-springs', '', ''),
(7666, 51, 0, 1, 'Smith', '', 'smith', '', ''),
(7667, 51, 0, 1, 'Silverpeak', '', 'silverpeak', '', ''),
(7668, 51, 0, 1, 'Sandy Valley', '', 'sandy-valley', '', ''),
(7669, 51, 0, 1, 'Silver City', '', 'silver-city-7669', '', ''),
(7670, 51, 0, 1, 'Verdi', '', 'verdi', '', ''),
(7671, 51, 0, 1, 'Virginia City', '', 'virginia-city-7671', '', ''),
(7672, 51, 0, 1, 'Wadsworth', '', 'wadsworth-7672', '', ''),
(7673, 51, 0, 1, 'Wellington', '', 'wellington-7673', '', ''),
(7674, 51, 0, 1, 'Wells', '', 'wells-7674', '', ''),
(7675, 51, 0, 1, 'West Wendover', '', 'west-wendover', '', ''),
(7676, 51, 0, 1, 'Wendover', '', 'wendover-7676', '', ''),
(7677, 51, 0, 1, 'Zephyr Cove', '', 'zephyr-cove', '', ''),
(7678, 30, 0, 1, 'Tiro', '', 'tiro', '', ''),
(7679, 30, 0, 1, 'Trenton', '', 'trenton-7679', '', ''),
(7680, 30, 0, 1, 'Terrace Park', '', 'terrace-park', '', ''),
(7681, 30, 0, 1, 'Troy', '', 'troy-7681', '', ''),
(7682, 30, 0, 1, 'Thurman', '', 'thurman', '', ''),
(7683, 30, 0, 1, 'Upper Arlington', '', 'upper-arlington', '', ''),
(7684, 30, 0, 1, 'Union City', '', 'union-city-7684', '', ''),
(7685, 30, 0, 1, 'Unionville', '', 'unionville-7685', '', ''),
(7686, 30, 0, 1, 'Uniontown', '', 'uniontown-7686', '', ''),
(7687, 30, 0, 1, 'Urbana', '', 'urbana-7687', '', ''),
(7688, 30, 0, 1, 'Utica', '', 'utica-7688', '', ''),
(7689, 30, 0, 1, 'Union', '', 'union-7689', '', ''),
(7690, 30, 0, 1, 'Versailles', '', 'versailles-7690', '', ''),
(7691, 30, 0, 1, 'Valley City', '', 'valley-city-7691', '', ''),
(7692, 30, 0, 1, 'Van Buren', '', 'van-buren-7692', '', ''),
(7693, 30, 0, 1, 'Verona', '', 'verona-7693', '', ''),
(7694, 30, 0, 1, 'Vickery', '', 'vickery', '', ''),
(7695, 30, 0, 1, 'Vincent', '', 'vincent-7695', '', ''),
(7696, 30, 0, 1, 'Vienna', '', 'vienna-7696', '', ''),
(7697, 30, 0, 1, 'Vinton', '', 'vinton-7697', '', ''),
(7698, 30, 0, 1, 'Worthington', '', 'worthington-7698', '', ''),
(7699, 30, 0, 1, 'Whitehall', '', 'whitehall-7699', '', ''),
(7700, 30, 0, 1, 'Williamsburg', '', 'williamsburg-7700', '', ''),
(7701, 30, 0, 1, 'Williamsfield', '', 'williamsfield-7701', '', ''),
(7702, 30, 0, 1, 'West Lafayette', '', 'west-lafayette-7702', '', ''),
(7703, 30, 0, 1, 'Warsaw', '', 'warsaw-7703', '', ''),
(7704, 30, 0, 1, 'West Jefferson', '', 'west-jefferson-7704', '', ''),
(7705, 30, 0, 1, 'Willowick', '', 'willowick', '', ''),
(7706, 30, 0, 1, 'Winchester', '', 'winchester-7706', '', ''),
(7707, 30, 0, 1, 'West Mansfield', '', 'west-mansfield', '', ''),
(7708, 30, 0, 1, 'West Milton', '', 'west-milton', '', ''),
(7709, 30, 0, 1, 'Walhonding', '', 'walhonding', '', ''),
(7710, 30, 0, 1, 'Waynesburg', '', 'waynesburg-7710', '', ''),
(7711, 30, 0, 1, 'Windsor', '', 'windsor-7711', '', ''),
(7712, 30, 0, 1, 'Windham', '', 'windham-7712', '', ''),
(7713, 30, 0, 1, 'West Portsmouth', '', 'west-portsmouth', '', ''),
(7714, 30, 0, 1, 'Wilmot', '', 'wilmot-7714', '', ''),
(7715, 30, 0, 1, 'Wilmington', '', 'wilmington-7715', '', ''),
(7716, 30, 0, 1, 'Wellington', '', 'wellington-7716', '', ''),
(7717, 30, 0, 1, 'Wintersville', '', 'wintersville', '', ''),
(7718, 30, 0, 1, 'Wright Ptrsn Afb', '', 'wright-ptrsn-afb', '', ''),
(7719, 30, 0, 1, 'Walnut Creek', '', 'walnut-creek-7719', '', ''),
(7720, 30, 0, 1, 'Wilberforce', '', 'wilberforce', '', ''),
(7721, 30, 0, 1, 'West Chester', '', 'west-chester-7721', '', ''),
(7722, 30, 0, 1, 'Wellsville', '', 'wellsville-7722', '', ''),
(7723, 30, 0, 1, 'Washingtonville', '', 'washingtonville-7723', '', ''),
(7724, 30, 0, 1, 'West Alexandria', '', 'west-alexandria', '', ''),
(7725, 30, 0, 1, 'West Unity', '', 'west-unity', '', ''),
(7726, 30, 0, 1, 'West Manchester', '', 'west-manchester', '', ''),
(7727, 30, 0, 1, 'Winesburg', '', 'winesburg', '', ''),
(7728, 30, 0, 1, 'Waynesfield', '', 'waynesfield', '', ''),
(7729, 30, 0, 1, 'West Carrollton', '', 'west-carrollton', '', ''),
(7730, 30, 0, 1, 'Waldo', '', 'waldo-7730', '', ''),
(7731, 30, 0, 1, 'Washington Twp', '', 'washington-twp-7731', '', ''),
(7732, 30, 0, 1, 'West Elkton', '', 'west-elkton', '', ''),
(7733, 30, 0, 1, 'Waverly', '', 'waverly-7733', '', ''),
(7734, 30, 0, 1, 'Washington Ct Hs', '', 'washington-ct-hs', '', ''),
(7735, 30, 0, 1, 'Waterville', '', 'waterville-7735', '', ''),
(7736, 30, 0, 1, 'Woodville', '', 'woodville-7736', '', ''),
(7737, 30, 0, 1, 'Wakeman', '', 'wakeman', '', ''),
(7738, 30, 0, 1, 'Whitehouse', '', 'whitehouse-7738', '', ''),
(7739, 30, 0, 1, 'Williamsport', '', 'williamsport-7739', '', ''),
(7740, 30, 0, 1, 'Willshire', '', 'willshire', '', ''),
(7741, 30, 0, 1, 'Walbridge', '', 'walbridge', '', ''),
(7742, 30, 0, 1, 'Wayne', '', 'wayne-7742', '', ''),
(7743, 30, 0, 1, 'West Salem', '', 'west-salem-7743', '', ''),
(7744, 30, 0, 1, 'Waterford', '', 'waterford-7744', '', ''),
(7745, 30, 0, 1, 'West Farmington', '', 'west-farmington', '', ''),
(7746, 30, 0, 1, 'Weston', '', 'weston-7746', '', ''),
(7747, 30, 0, 1, 'Whipple', '', 'whipple', '', ''),
(7748, 30, 0, 1, 'Wren', '', 'wren', '', ''),
(7749, 30, 0, 1, 'Woodstock', '', 'woodstock-7749', '', ''),
(7750, 30, 0, 1, 'Wilkesville', '', 'wilkesville', '', ''),
(7751, 30, 0, 1, 'Willow Wood', '', 'willow-wood', '', ''),
(7752, 30, 0, 1, 'Wingett Run', '', 'wingett-run', '', ''),
(7753, 30, 0, 1, 'Washington Court House', '', 'washington-court-house', '', ''),
(7754, 30, 0, 1, 'Westfield Center', '', 'westfield-center', '', ''),
(7755, 30, 0, 1, 'West Point', '', 'west-point-7755', '', ''),
(7756, 30, 0, 1, 'Yorkshire', '', 'yorkshire', '', ''),
(7757, 30, 0, 1, 'Youngstown', '', 'youngstown-7757', '', ''),
(7758, 30, 0, 1, 'Yorkville', '', 'yorkville-7758', '', ''),
(7759, 30, 0, 1, 'Yellow Springs', '', 'yellow-springs', '', ''),
(7760, 30, 0, 1, 'Zanesfield', '', 'zanesfield', '', ''),
(7761, 30, 0, 1, 'Zaleski', '', 'zaleski', '', ''),
(7762, 30, 0, 1, 'Zoar', '', 'zoar', '', ''),
(7763, 32, 0, 1, 'Turpin', '', 'turpin', '', ''),
(7764, 32, 0, 1, 'Talihina', '', 'talihina', '', ''),
(7765, 32, 0, 1, 'Tecumseh', '', 'tecumseh-7765', '', ''),
(7766, 32, 0, 1, 'Union City', '', 'union-city-7766', '', ''),
(7767, 32, 0, 1, 'Valliant', '', 'valliant', '', ''),
(7768, 32, 0, 1, 'Vici', '', 'vici', '', ''),
(7769, 32, 0, 1, 'Vinson', '', 'vinson', '', ''),
(7770, 32, 0, 1, 'Verden', '', 'verden', '', ''),
(7771, 32, 0, 1, 'Vian', '', 'vian', '', ''),
(7772, 32, 0, 1, 'Velma', '', 'velma', '', ''),
(7773, 32, 0, 1, 'Warner', '', 'warner-7773', '', ''),
(7774, 32, 0, 1, 'Wellston', '', 'wellston-7774', '', ''),
(7775, 32, 0, 1, 'Watson', '', 'watson-7775', '', ''),
(7776, 32, 0, 1, 'Webbers Falls', '', 'webbers-falls', '', ''),
(7777, 32, 0, 1, 'Wister', '', 'wister', '', ''),
(7778, 32, 0, 1, 'Weleetka', '', 'weleetka', '', ''),
(7779, 32, 0, 1, 'Wright City', '', 'wright-city-7779', '', ''),
(7780, 32, 0, 1, 'Weatherford', '', 'weatherford-7780', '', ''),
(7781, 32, 0, 1, 'Willow', '', 'willow-7781', '', ''),
(7782, 32, 0, 1, 'Watonga', '', 'watonga', '', ''),
(7783, 32, 0, 1, 'Welch', '', 'welch-7783', '', ''),
(7784, 32, 0, 1, 'Washington', '', 'washington-7784', '', ''),
(7785, 32, 0, 1, 'Wynnewood', '', 'wynnewood-7785', '', ''),
(7786, 32, 0, 1, 'Watts', '', 'watts', '', ''),
(7787, 32, 0, 1, 'Wilson', '', 'wilson-7787', '', ''),
(7788, 32, 0, 1, 'Wapanucka', '', 'wapanucka', '', ''),
(7789, 32, 0, 1, 'Wakita', '', 'wakita', '', ''),
(7790, 32, 0, 1, 'Walters', '', 'walters-7790', '', ''),
(7791, 32, 0, 1, 'Westville', '', 'westville-7791', '', ''),
(7792, 32, 0, 1, 'Wayne', '', 'wayne-7792', '', ''),
(7793, 32, 0, 1, 'Wewoka', '', 'wewoka', '', ''),
(7794, 32, 0, 1, 'Wyandotte', '', 'wyandotte-7794', '', ''),
(7795, 32, 0, 1, 'Wanette', '', 'wanette', '', ''),
(7796, 32, 0, 1, 'Wynona', '', 'wynona', '', ''),
(7797, 32, 0, 1, 'Waukomis', '', 'waukomis', '', ''),
(7798, 32, 0, 1, 'Wetumka', '', 'wetumka', '', ''),
(7799, 32, 0, 1, 'Yale', '', 'yale-7799', '', ''),
(7800, 26, 0, 1, 'Salem', '', 'salem-7800', '', ''),
(7801, 26, 0, 1, 'Scio', '', 'scio', '', ''),
(7802, 26, 0, 1, 'Scotts Mills', '', 'scotts-mills', '', ''),
(7803, 26, 0, 1, 'Shedd', '', 'shedd', '', ''),
(7804, 26, 0, 1, 'Sheridan', '', 'sheridan-7804', '', ''),
(7805, 26, 0, 1, 'Siletz', '', 'siletz', '', ''),
(7806, 26, 0, 1, 'Sublimity', '', 'sublimity', '', ''),
(7807, 26, 0, 1, 'Springfield', '', 'springfield-7807', '', ''),
(7808, 26, 0, 1, 'Sutherlin', '', 'sutherlin', '', ''),
(7809, 26, 0, 1, 'Swisshome', '', 'swisshome', '', ''),
(7810, 26, 0, 1, 'Selma', '', 'selma-7810', '', ''),
(7811, 26, 0, 1, 'Silver Lake', '', 'silver-lake-7811', '', ''),
(7812, 26, 0, 1, 'Sprague River', '', 'sprague-river', '', ''),
(7813, 26, 0, 1, 'Seneca', '', 'seneca-7813', '', ''),
(7814, 26, 0, 1, 'Tiller', '', 'tiller', '', ''),
(7815, 26, 0, 1, 'Tolovana Park', '', 'tolovana-park', '', ''),
(7816, 26, 0, 1, 'Terrebonne', '', 'terrebonne', '', ''),
(7817, 26, 0, 1, 'Toledo', '', 'toledo-7817', '', ''),
(7818, 26, 0, 1, 'Turner', '', 'turner-7818', '', ''),
(7819, 26, 0, 1, 'Tidewater', '', 'tidewater', '', ''),
(7820, 26, 0, 1, 'Tygh Valley', '', 'tygh-valley', '', ''),
(7821, 26, 0, 1, 'Tangent', '', 'tangent', '', ''),
(7822, 26, 0, 1, 'Timber', '', 'timber', '', ''),
(7823, 26, 0, 1, 'Trail', '', 'trail-7823', '', ''),
(7824, 26, 0, 1, 'Unity', '', 'unity-7824', '', ''),
(7825, 26, 0, 1, 'Umatilla', '', 'umatilla-7825', '', ''),
(7826, 26, 0, 1, 'Union', '', 'union-7826', '', ''),
(7827, 26, 0, 1, 'Ukiah', '', 'ukiah-7827', '', ''),
(7828, 26, 0, 1, 'Vale', '', 'vale-7828', '', ''),
(7829, 26, 0, 1, 'Vernonia', '', 'vernonia', '', ''),
(7830, 26, 0, 1, 'Vida', '', 'vida-7830', '', ''),
(7831, 26, 0, 1, 'Winston', '', 'winston-7831', '', ''),
(7832, 26, 0, 1, 'Warrenton', '', 'warrenton-7832', '', ''),
(7833, 26, 0, 1, 'Winchester Bay', '', 'winchester-bay', '', ''),
(7834, 26, 0, 1, 'Winchester', '', 'winchester-7834', '', ''),
(7835, 26, 0, 1, 'White City', '', 'white-city-7835', '', ''),
(7836, 26, 0, 1, 'West Linn', '', 'west-linn', '', ''),
(7837, 26, 0, 1, 'Welches', '', 'welches', '', ''),
(7838, 26, 0, 1, 'Weston', '', 'weston-7838', '', ''),
(7839, 26, 0, 1, 'Wamic', '', 'wamic', '', ''),
(7840, 26, 0, 1, 'Warm Springs', '', 'warm-springs-7840', '', ''),
(7841, 26, 0, 1, 'Wasco', '', 'wasco-7841', '', ''),
(7842, 26, 0, 1, 'Walton', '', 'walton-7842', '', ''),
(7843, 26, 0, 1, 'Williams', '', 'williams-7843', '', ''),
(7844, 26, 0, 1, 'Wilderville', '', 'wilderville', '', ''),
(7845, 26, 0, 1, 'Warren', '', 'warren-7845', '', ''),
(7846, 26, 0, 1, 'Wolf Creek', '', 'wolf-creek-7846', '', ''),
(7847, 26, 0, 1, 'Wheeler', '', 'wheeler-7847', '', ''),
(7848, 26, 0, 1, 'Wood Village', '', 'wood-village', '', ''),
(7849, 26, 0, 1, 'Walterville', '', 'walterville', '', ''),
(7850, 26, 0, 1, 'Wedderburn', '', 'wedderburn', '', ''),
(7851, 26, 0, 1, 'Wilbur', '', 'wilbur-7851', '', ''),
(7852, 26, 0, 1, 'Yoncalla', '', 'yoncalla', '', ''),
(7853, 26, 0, 1, 'Yamhill', '', 'yamhill', '', ''),
(7854, 31, 0, 1, 'Trucksville', '', 'trucksville', '', ''),
(7855, 31, 0, 1, 'Trout Run', '', 'trout-run', '', ''),
(7856, 31, 0, 1, 'Transfer', '', 'transfer', '', ''),
(7857, 31, 0, 1, 'Telford', '', 'telford', '', ''),
(7858, 31, 0, 1, 'Tatamy', '', 'tatamy', '', ''),
(7859, 31, 0, 1, 'Trevorton', '', 'trevorton', '', ''),
(7860, 31, 0, 1, 'Turbotville', '', 'turbotville', '', ''),
(7861, 31, 0, 1, 'Tafton', '', 'tafton', '', ''),
(7862, 31, 0, 1, 'Tamiment', '', 'tamiment', '', ''),
(7863, 31, 0, 1, 'Tylersport', '', 'tylersport', '', ''),
(7864, 31, 0, 1, 'Tremont', '', 'tremont-7864', '', ''),
(7865, 31, 0, 1, 'Tower City', '', 'tower-city', '', ''),
(7866, 31, 0, 1, 'Taylorstown', '', 'taylorstown', '', ''),
(7867, 31, 0, 1, 'Thomasville', '', 'thomasville-7867', '', ''),
(7868, 31, 0, 1, 'Tarrs', '', 'tarrs', '', ''),
(7869, 31, 0, 1, 'Tioga', '', 'tioga-7869', '', ''),
(7870, 31, 0, 1, 'Three Springs', '', 'three-springs', '', ''),
(7871, 31, 0, 1, 'Thompsontown', '', 'thompsontown', '', ''),
(7872, 31, 0, 1, 'Topton', '', 'topton-7872', '', ''),
(7873, 31, 0, 1, 'Thorndale', '', 'thorndale', '', ''),
(7874, 31, 0, 1, 'Thornton', '', 'thornton-7874', '', ''),
(7875, 31, 0, 1, 'Trumbauersville', '', 'trumbauersville', '', ''),
(7876, 31, 0, 1, 'Thompson', '', 'thompson-7876', '', ''),
(7877, 31, 0, 1, 'Taylor', '', 'taylor-7877', '', ''),
(7878, 31, 0, 1, 'Treichlers', '', 'treichlers', '', ''),
(7879, 31, 0, 1, 'Turtle Creek', '', 'turtle-creek', '', ''),
(7880, 31, 0, 1, 'Twin Rocks', '', 'twin-rocks', '', ''),
(7881, 31, 0, 1, 'Templeton', '', 'templeton-7881', '', ''),
(7882, 31, 0, 1, 'Tidioute', '', 'tidioute', '', ''),
(7883, 31, 0, 1, 'Tiona', '', 'tiona', '', ''),
(7884, 31, 0, 1, 'Titusville', '', 'titusville-7884', '', ''),
(7885, 31, 0, 1, 'Townville', '', 'townville', '', ''),
(7886, 31, 0, 1, 'Tylersburg', '', 'tylersburg', '', ''),
(7887, 31, 0, 1, 'Tipton', '', 'tipton-7887', '', ''),
(7888, 31, 0, 1, 'Tyrone', '', 'tyrone-7888', '', ''),
(7889, 31, 0, 1, 'Troy', '', 'troy-7889', '', ''),
(7890, 31, 0, 1, 'Terre Hill', '', 'terre-hill', '', ''),
(7891, 31, 0, 1, 'University Park', '', 'university-park-7891', '', ''),
(7892, 31, 0, 1, 'Ulster', '', 'ulster', '', ''),
(7893, 31, 0, 1, 'Upper Black Eddy', '', 'upper-black-eddy', '', ''),
(7894, 31, 0, 1, 'Uwchland', '', 'uwchland', '', ''),
(7895, 31, 0, 1, 'Unityville', '', 'unityville', '', ''),
(7896, 31, 0, 1, 'Ulysses', '', 'ulysses', '', ''),
(7897, 31, 0, 1, 'Union City', '', 'union-city-7897', '', ''),
(7898, 31, 0, 1, 'United', '', 'united', '', ''),
(7899, 31, 0, 1, 'Valencia', '', 'valencia-7899', '', ''),
(7900, 31, 0, 1, 'Vowinckel', '', 'vowinckel', '', ''),
(7901, 31, 0, 1, 'Virginville', '', 'virginville', '', ''),
(7902, 31, 0, 1, 'Verona', '', 'verona-7902', '', ''),
(7903, 31, 0, 1, 'Volant', '', 'volant', '', ''),
(7904, 31, 0, 1, 'Venus', '', 'venus', '', ''),
(7905, 31, 0, 1, 'Valley View', '', 'valley-view', '', ''),
(7906, 31, 0, 1, 'Vestaburg', '', 'vestaburg', '', ''),
(7907, 31, 0, 1, 'Vanderbilt', '', 'vanderbilt', '', ''),
(7908, 31, 0, 1, 'Weatherly', '', 'weatherly', '', ''),
(7909, 31, 0, 1, 'Worthington', '', 'worthington-7909', '', ''),
(7910, 31, 0, 1, 'Wormleysburg', '', 'wormleysburg', '', ''),
(7911, 31, 0, 1, 'Weedville', '', 'weedville', '', ''),
(7912, 31, 0, 1, 'Williamstown', '', 'williamstown-7912', '', ''),
(7913, 31, 0, 1, 'Wilcox', '', 'wilcox-7913', '', ''),
(7914, 31, 0, 1, 'Wallingford', '', 'wallingford-7914', '', ''),
(7915, 31, 0, 1, 'Walnut Bottom', '', 'walnut-bottom', '', ''),
(7916, 31, 0, 1, 'Woodward', '', 'woodward-7916', '', ''),
(7917, 31, 0, 1, 'Winburne', '', 'winburne', '', ''),
(7918, 31, 0, 1, 'West Decatur', '', 'west-decatur', '', ''),
(7919, 31, 0, 1, 'Woolrich', '', 'woolrich', '', ''),
(7920, 31, 0, 1, 'Wysox', '', 'wysox', '', ''),
(7921, 31, 0, 1, 'Williamsburg', '', 'williamsburg-7921', '', ''),
(7922, 31, 0, 1, 'Woodbury', '', 'woodbury-7922', '', ''),
(7923, 31, 0, 1, 'Wilkinsburg', '', 'wilkinsburg', '', ''),
(7924, 31, 0, 1, 'West Elizabeth', '', 'west-elizabeth', '', ''),
(7925, 31, 0, 1, 'Whitaker', '', 'whitaker', '', ''),
(7926, 31, 0, 1, 'West View', '', 'west-view', '', ''),
(7927, 31, 0, 1, 'Wall', '', 'wall-7927', '', ''),
(7928, 31, 0, 1, 'Wilmore', '', 'wilmore-7928', '', ''),
(7929, 31, 0, 1, 'Weissport', '', 'weissport', '', ''),
(7930, 31, 0, 1, 'West Sunbury', '', 'west-sunbury', '', ''),
(7931, 31, 0, 1, 'Washington Crsng', '', 'washington-crsng', '', ''),
(7932, 31, 0, 1, 'West Grove', '', 'west-grove', '', ''),
(7933, 31, 0, 1, 'Westtown', '', 'westtown', '', ''),
(7934, 31, 0, 1, 'Willow Street', '', 'willow-street', '', ''),
(7935, 31, 0, 1, 'Waverly', '', 'waverly-7935', '', ''),
(7936, 31, 0, 1, 'West Pittsburg', '', 'west-pittsburg', '', ''),
(7937, 31, 0, 1, 'Wampum', '', 'wampum', '', ''),
(7938, 31, 0, 1, 'Wescosville', '', 'wescosville', '', ''),
(7939, 31, 0, 1, 'West Hazleton', '', 'west-hazleton', '', ''),
(7940, 31, 0, 1, 'Wyoming', '', 'wyoming-7940', '', ''),
(7941, 31, 0, 1, 'White Haven', '', 'white-haven', '', ''),
(7942, 31, 0, 1, 'Warrior Run', '', 'warrior-run', '', ''),
(7943, 31, 0, 1, 'Wapwallopen', '', 'wapwallopen', '', ''),
(7944, 31, 0, 1, 'Waterville', '', 'waterville-7944', '', ''),
(7945, 31, 0, 1, 'West Middlesex', '', 'west-middlesex', '', ''),
(7946, 31, 0, 1, 'Wheatland', '', 'wheatland-7946', '', ''),
(7947, 31, 0, 1, 'Westline', '', 'westline', '', ''),
(7948, 31, 0, 1, 'Worcester', '', 'worcester-7948', '', ''),
(7949, 31, 0, 1, 'W Conshohocken', '', 'w-conshohocken', '', ''),
(7950, 31, 0, 1, 'Washingtonville', '', 'washingtonville-7950', '', ''),
(7951, 31, 0, 1, 'Watsontown', '', 'watsontown', '', ''),
(7952, 31, 0, 1, 'Washington', '', 'washington-7952', '', ''),
(7953, 31, 0, 1, 'West Milton', '', 'west-milton-7953', '', ''),
(7954, 31, 0, 1, 'Winfield', '', 'winfield-7954', '', ''),
(7955, 31, 0, 1, 'West Alexander', '', 'west-alexander', '', ''),
(7956, 31, 0, 1, 'West Newton', '', 'west-newton-7956', '', ''),
(7957, 31, 0, 1, 'Whitney', '', 'whitney', '', ''),
(7958, 31, 0, 1, 'Windsor', '', 'windsor-7958', '', ''),
(7959, 31, 0, 1, 'Waymart', '', 'waymart', '', ''),
(7960, 31, 0, 1, 'Westfield', '', 'westfield-7960', '', ''),
(7961, 31, 0, 1, 'Wellsville', '', 'wellsville-7961', '', ''),
(7962, 31, 0, 1, 'Waterford', '', 'waterford-7962', '', ''),
(7963, 31, 0, 1, 'West Springfield', '', 'west-springfield-7963', '', ''),
(7964, 31, 0, 1, 'Waynesboro', '', 'waynesboro-7964', '', ''),
(7965, 31, 0, 1, 'Wattsburg', '', 'wattsburg', '', ''),
(7966, 31, 0, 1, 'Warfordsburg', '', 'warfordsburg', '', ''),
(7967, 31, 0, 1, 'Waterfall', '', 'waterfall', '', ''),
(7968, 31, 0, 1, 'Wind Ridge', '', 'wind-ridge', '', ''),
(7969, 31, 0, 1, 'West Hickory', '', 'west-hickory', '', ''),
(7970, 31, 0, 1, 'Walston', '', 'walston', '', ''),
(7971, 31, 0, 1, 'Wyano', '', 'wyano', '', ''),
(7972, 31, 0, 1, 'Wagontown', '', 'wagontown', '', ''),
(7973, 31, 0, 1, 'West Finley', '', 'west-finley', '', ''),
(7974, 31, 0, 1, 'Westmoreland City', '', 'westmoreland-city', '', ''),
(7975, 31, 0, 1, 'Warren', '', 'warren-7975', '', ''),
(7976, 31, 0, 1, 'Warriors Mark', '', 'warriors-mark', '', ''),
(7977, 31, 0, 1, 'Woodland', '', 'woodland-7977', '', ''),
(7978, 31, 0, 1, 'Williamson', '', 'williamson-7978', '', ''),
(7979, 31, 0, 1, 'Willow Hill', '', 'willow-hill-7979', '', ''),
(7980, 31, 0, 1, 'Yatesboro', '', 'yatesboro', '', ''),
(7981, 31, 0, 1, 'Yeadon', '', 'yeadon', '', ''),
(7982, 31, 0, 1, 'Yeagertown', '', 'yeagertown', '', ''),
(7983, 31, 0, 1, 'Youngwood', '', 'youngwood', '', ''),
(7984, 31, 0, 1, 'Yukon', '', 'yukon-7984', '', ''),
(7985, 31, 0, 1, 'Youngstown', '', 'youngstown-7985', '', ''),
(7986, 31, 0, 1, 'York Haven', '', 'york-haven', '', ''),
(7987, 31, 0, 1, 'York New Salem', '', 'york-new-salem', '', ''),
(7988, 31, 0, 1, 'Youngsville', '', 'youngsville-7988', '', ''),
(7989, 31, 0, 1, 'Zionsville', '', 'zionsville-7989', '', ''),
(7990, 31, 0, 1, 'Zieglerville', '', 'zieglerville', '', ''),
(7991, 31, 0, 1, 'Zullinger', '', 'zullinger', '', ''),
(7992, 28, 0, 1, 'West Kingston', '', 'west-kingston', '', ''),
(7993, 28, 0, 1, 'Warren', '', 'warren-7993', '', ''),
(7994, 28, 0, 1, 'Wyoming', '', 'wyoming-7994', '', ''),
(7995, 27, 0, 1, 'Sharon', '', 'sharon-7995', '', ''),
(7996, 27, 0, 1, 'Smyrna', '', 'smyrna-7996', '', ''),
(7997, 27, 0, 1, 'Salters', '', 'salters', '', ''),
(7998, 27, 0, 1, 'Six Mile', '', 'six-mile', '', ''),
(7999, 27, 0, 1, 'Starr', '', 'starr', '', ''),
(8000, 27, 0, 1, 'Salem', '', 'salem-8000', '', ''),
(8001, 27, 0, 1, 'Scranton', '', 'scranton-8001', '', ''),
(8002, 27, 0, 1, 'Sellers', '', 'sellers', '', ''),
(8003, 27, 0, 1, 'Saint George', '', 'saint-george-8003', '', ''),
(8004, 27, 0, 1, 'Sullivans Island', '', 'sullivans-island', '', ''),
(8005, 27, 0, 1, 'Summerville', '', 'summerville-8005', '', ''),
(8006, 27, 0, 1, 'Saint Matthews', '', 'saint-matthews', '', ''),
(8007, 27, 0, 1, 'Saluda', '', 'saluda', '', ''),
(8008, 27, 0, 1, 'Santee', '', 'santee-8008', '', ''),
(8009, 27, 0, 1, 'Springfield', '', 'springfield-8009', '', ''),
(8010, 27, 0, 1, 'Summerton', '', 'summerton', '', ''),
(8011, 27, 0, 1, 'Shaw A F B', '', 'shaw-a-f-b', '', ''),
(8012, 27, 0, 1, 'Swansea', '', 'swansea-8012', '', ''),
(8013, 27, 0, 1, 'Turbeville', '', 'turbeville', '', ''),
(8014, 27, 0, 1, 'Townville', '', 'townville-8014', '', ''),
(8015, 27, 0, 1, 'Timmonsville', '', 'timmonsville', '', ''),
(8016, 27, 0, 1, 'Taylors', '', 'taylors', '', ''),
(8017, 27, 0, 1, 'Trenton', '', 'trenton-8017', '', ''),
(8018, 27, 0, 1, 'Troy', '', 'troy-8018', '', ''),
(8019, 27, 0, 1, 'Tatum', '', 'tatum-8019', '', ''),
(8020, 27, 0, 1, 'Ulmer', '', 'ulmer', '', ''),
(8021, 27, 0, 1, 'Union', '', 'union-8021', '', ''),
(8022, 27, 0, 1, 'Varnville', '', 'varnville', '', ''),
(8023, 27, 0, 1, 'Vance', '', 'vance-8023', '', ''),
(8024, 27, 0, 1, 'Williston', '', 'williston-8024', '', ''),
(8025, 27, 0, 1, 'Warrenville', '', 'warrenville-8025', '', ''),
(8026, 27, 0, 1, 'Williamston', '', 'williamston-8026', '', ''),
(8027, 27, 0, 1, 'Wando', '', 'wando', '', ''),
(8028, 27, 0, 1, 'Wagener', '', 'wagener', '', ''),
(8029, 27, 0, 1, 'Wadmalaw Island', '', 'wadmalaw-island', '', ''),
(8030, 27, 0, 1, 'Walhalla', '', 'walhalla-8030', '', ''),
(8031, 27, 0, 1, 'Westminster', '', 'westminster-8031', '', ''),
(8032, 27, 0, 1, 'Waterloo', '', 'waterloo-8032', '', ''),
(8033, 27, 0, 1, 'Ware Shoals', '', 'ware-shoals', '', ''),
(8034, 27, 0, 1, 'West Union', '', 'west-union-8034', '', ''),
(8035, 27, 0, 1, 'Whitmire', '', 'whitmire', '', ''),
(8036, 27, 0, 1, 'Wallace', '', 'wallace-8036', '', ''),
(8037, 27, 0, 1, 'Woodruff', '', 'woodruff-8037', '', ''),
(8038, 27, 0, 1, 'Wedgefield', '', 'wedgefield', '', ''),
(8039, 27, 0, 1, 'Wellford', '', 'wellford', '', ''),
(8040, 27, 0, 1, 'Windsor', '', 'windsor-8040', '', ''),
(8041, 27, 0, 1, 'Yonges Island', '', 'yonges-island', '', ''),
(8042, 27, 0, 1, 'Yemassee', '', 'yemassee', '', ''),
(8043, 27, 0, 1, 'York', '', 'york-8043', '', ''),
(8044, 49, 0, 1, 'Watertown', '', 'watertown-8044', '', ''),
(8045, 49, 0, 1, 'Woonsocket', '', 'woonsocket-8045', '', ''),
(8046, 49, 0, 1, 'Wagner', '', 'wagner', '', ''),
(8047, 49, 0, 1, 'Webster', '', 'webster-8047', '', ''),
(8048, 49, 0, 1, 'Wall', '', 'wall-8048', '', ''),
(8049, 49, 0, 1, 'Wilmot', '', 'wilmot-8049', '', ''),
(8050, 49, 0, 1, 'Wessington', '', 'wessington', '', ''),
(8051, 49, 0, 1, 'White', '', 'white-8051', '', ''),
(8052, 49, 0, 1, 'White Lake', '', 'white-lake-8052', '', ''),
(8053, 49, 0, 1, 'Wessington Spgs', '', 'wessington-spgs', '', ''),
(8054, 49, 0, 1, 'Whitewood', '', 'whitewood', '', ''),
(8055, 49, 0, 1, 'Waubay', '', 'waubay', '', ''),
(8056, 49, 0, 1, 'White River', '', 'white-river', '', ''),
(8057, 49, 0, 1, 'Wolsey', '', 'wolsey', '', ''),
(8058, 49, 0, 1, 'Wentworth', '', 'wentworth', '', ''),
(8059, 49, 0, 1, 'Ward', '', 'ward-8059', '', ''),
(8060, 49, 0, 1, 'Wakonda', '', 'wakonda', '', ''),
(8061, 49, 0, 1, 'Winfred', '', 'winfred', '', ''),
(8062, 49, 0, 1, 'White Owl', '', 'white-owl', '', ''),
(8063, 49, 0, 1, 'Wasta', '', 'wasta', '', ''),
(8064, 49, 0, 1, 'Wetonka', '', 'wetonka', '', ''),
(8065, 49, 0, 1, 'Willow Lake', '', 'willow-lake', '', ''),
(8066, 49, 0, 1, 'Westport', '', 'westport-8066', '', ''),
(8067, 49, 0, 1, 'Wessington Springs', '', 'wessington-springs', '', ''),
(8068, 49, 0, 1, 'Warner', '', 'warner-8068', '', ''),
(8069, 49, 0, 1, 'Wood', '', 'wood', '', ''),
(8070, 49, 0, 1, 'Yale', '', 'yale-8070', '', ''),
(8071, 50, 0, 1, 'Ridgely', '', 'ridgely', '', ''),
(8072, 50, 0, 1, 'Red Boiling Spgs', '', 'red-boiling-spgs', '', ''),
(8073, 50, 0, 1, 'Ramer', '', 'ramer', '', ''),
(8074, 50, 0, 1, 'Ripley', '', 'ripley-8074', '', ''),
(8075, 50, 0, 1, 'Rogersville', '', 'rogersville-8075', '', ''),
(8076, 50, 0, 1, 'Rockwood', '', 'rockwood', '', ''),
(8077, 50, 0, 1, 'Robbins', '', 'robbins', '', ''),
(8078, 50, 0, 1, 'Rickman', '', 'rickman', '', ''),
(8079, 50, 0, 1, 'Rives', '', 'rives', '', ''),
(8080, 50, 0, 1, 'Rutledge', '', 'rutledge', '', ''),
(8081, 50, 0, 1, 'Russellville', '', 'russellville-8081', '', ''),
(8082, 50, 0, 1, 'Rutherford', '', 'rutherford-8082', '', ''),
(8083, 50, 0, 1, 'Reagan', '', 'reagan', '', ''),
(8084, 50, 0, 1, 'Red Boiling Springs', '', 'red-boiling-springs', '', ''),
(8085, 50, 0, 1, 'Roan Mountain', '', 'roan-mountain', '', ''),
(8086, 50, 0, 1, 'Rockford', '', 'rockford-8086', '', ''),
(8087, 50, 0, 1, 'Rock Island', '', 'rock-island-8087', '', ''),
(8088, 50, 0, 1, 'Reliance', '', 'reliance', '', ''),
(8089, 50, 0, 1, 'Riceville', '', 'riceville', '', ''),
(8090, 50, 0, 1, 'Speedwell', '', 'speedwell', '', ''),
(8091, 50, 0, 1, 'Shady Valley', '', 'shady-valley', '', ''),
(8092, 50, 0, 1, 'Springville', '', 'springville-8092', '', ''),
(8093, 50, 0, 1, 'Sneedville', '', 'sneedville', '', ''),
(8094, 50, 0, 1, 'Sewanee', '', 'sewanee', '', ''),
(8095, 50, 0, 1, 'Shelbyville', '', 'shelbyville-8095', '', ''),
(8096, 50, 0, 1, 'Surgoinsville', '', 'surgoinsville', '', ''),
(8097, 50, 0, 1, 'Sugar Tree', '', 'sugar-tree', '', ''),
(8098, 50, 0, 1, 'Santa Fe', '', 'santa-fe-8098', '', ''),
(8099, 50, 0, 1, 'Summertown', '', 'summertown', '', ''),
(8100, 50, 0, 1, 'Springfield', '', 'springfield-8100', '', ''),
(8101, 50, 0, 1, 'Sweetwater', '', 'sweetwater-8101', '', ''),
(8102, 50, 0, 1, 'Sharon', '', 'sharon-8102', '', ''),
(8103, 50, 0, 1, 'Spencer', '', 'spencer-8103', '', ''),
(8104, 50, 0, 1, 'Sunbright', '', 'sunbright', '', ''),
(8105, 50, 0, 1, 'Smithville', '', 'smithville-8105', '', ''),
(8106, 50, 0, 1, 'Somerville', '', 'somerville-8106', '', ''),
(8107, 50, 0, 1, 'St Joseph', '', 'st-joseph-8107', '', ''),
(8108, 50, 0, 1, 'Stanton', '', 'stanton-8108', '', ''),
(8109, 50, 0, 1, 'Savannah', '', 'savannah-8109', '', ''),
(8110, 50, 0, 1, 'Selmer', '', 'selmer', '', ''),
(8111, 50, 0, 1, 'Strawberry Plns', '', 'strawberry-plns', '', ''),
(8112, 50, 0, 1, 'Sale Creek', '', 'sale-creek', '', ''),
(8113, 50, 0, 1, 'Scotts Hill', '', 'scotts-hill', '', ''),
(8114, 50, 0, 1, 'Shiloh', '', 'shiloh-8114', '', ''),
(8115, 50, 0, 1, 'Stewart', '', 'stewart', '', ''),
(8116, 50, 0, 1, 'Saltillo', '', 'saltillo', '', ''),
(8117, 50, 0, 1, 'Sardis', '', 'sardis-8117', '', ''),
(8118, 50, 0, 1, 'Seymour', '', 'seymour-8118', '', ''),
(8119, 50, 0, 1, 'Smyrna', '', 'smyrna-8119', '', ''),
(8120, 50, 0, 1, 'South Fulton', '', 'south-fulton', '', ''),
(8121, 50, 0, 1, 'Spring City', '', 'spring-city', '', ''),
(8122, 50, 0, 1, 'Sparta', '', 'sparta-8122', '', ''),
(8123, 50, 0, 1, 'Sharps Chapel', '', 'sharps-chapel', '', ''),
(8124, 50, 0, 1, 'Samburg', '', 'samburg', '', ''),
(8125, 50, 0, 1, 'Sequatchie', '', 'sequatchie', '', ''),
(8126, 50, 0, 1, 'Stantonville', '', 'stantonville', '', ''),
(8127, 50, 0, 1, 'Saint Joseph', '', 'saint-joseph-8127', '', ''),
(8128, 50, 0, 1, 'Strawberry Plains', '', 'strawberry-plains', '', ''),
(8129, 50, 0, 1, 'Summitville', '', 'summitville-8129', '', ''),
(8130, 50, 0, 1, 'Saint Bethlehem', '', 'saint-bethlehem', '', ''),
(8131, 50, 0, 1, 'Tazewell', '', 'tazewell-8131', '', ''),
(8132, 50, 0, 1, 'Tracy City', '', 'tracy-city', '', ''),
(8133, 50, 0, 1, 'Trimble', '', 'trimble', '', ''),
(8134, 50, 0, 1, 'Trade', '', 'trade', '', ''),
(8135, 50, 0, 1, 'Thorn Hill', '', 'thorn-hill', '', ''),
(8136, 50, 0, 1, 'Ten Mile', '', 'ten-mile', '', ''),
(8137, 50, 0, 1, 'Toone', '', 'toone', '', ''),
(8138, 50, 0, 1, 'Trezevant', '', 'trezevant', '', ''),
(8139, 50, 0, 1, 'Trenton', '', 'trenton-8139', '', ''),
(8140, 50, 0, 1, 'Talbott', '', 'talbott', '', ''),
(8141, 50, 0, 1, 'Tiptonville', '', 'tiptonville', '', ''),
(8142, 50, 0, 1, 'Troy', '', 'troy-8142', '', ''),
(8143, 50, 0, 1, 'Tennessee Ridge', '', 'tennessee-ridge', '', ''),
(8144, 50, 0, 1, 'Telford', '', 'telford-8144', '', ''),
(8145, 50, 0, 1, 'Tigrett', '', 'tigrett', '', ''),
(8146, 50, 0, 1, 'Taft', '', 'taft-8146', '', ''),
(8147, 50, 0, 1, 'Turtletown', '', 'turtletown', '', ''),
(8148, 50, 0, 1, 'Unicoi', '', 'unicoi', '', ''),
(8149, 50, 0, 1, 'Union City', '', 'union-city-8149', '', ''),
(8150, 50, 0, 1, 'Viola', '', 'viola-8150', '', ''),
(8151, 50, 0, 1, 'Vonore', '', 'vonore', '', ''),
(8152, 50, 0, 1, 'Watauga', '', 'watauga-8152', '', ''),
(8153, 50, 0, 1, 'Whites Creek', '', 'whites-creek', '', ''),
(8154, 50, 0, 1, 'Winchester', '', 'winchester-8154', '', ''),
(8155, 50, 0, 1, 'Wartrace', '', 'wartrace', '', ''),
(8156, 50, 0, 1, 'Woodbury', '', 'woodbury-8156', '', ''),
(8157, 50, 0, 1, 'Whiteville', '', 'whiteville-8157', '', ''),
(8158, 50, 0, 1, 'White Bluff', '', 'white-bluff', '', ''),
(8159, 50, 0, 1, 'Washburn', '', 'washburn-8159', '', ''),
(8160, 50, 0, 1, 'Walland', '', 'walland', '', ''),
(8161, 50, 0, 1, 'Whitwell', '', 'whitwell', '', ''),
(8162, 50, 0, 1, 'Waynesboro', '', 'waynesboro-8162', '', ''),
(8163, 50, 0, 1, 'Wartburg', '', 'wartburg', '', ''),
(8164, 50, 0, 1, 'Watertown', '', 'watertown-8164', '', ''),
(8165, 50, 0, 1, 'Westpoint', '', 'westpoint-8165', '', ''),
(8166, 50, 0, 1, 'White Pine', '', 'white-pine', '', ''),
(8167, 50, 0, 1, 'Whitesburg', '', 'whitesburg-8167', '', ''),
(8168, 50, 0, 1, 'Wildersville', '', 'wildersville', '', ''),
(8169, 50, 0, 1, 'Woodlawn', '', 'woodlawn-8169', '', ''),
(8170, 50, 0, 1, 'Walling', '', 'walling', '', ''),
(8171, 50, 0, 1, 'Winfield', '', 'winfield-8171', '', ''),
(8172, 50, 0, 1, 'Yuma', '', 'yuma-8172', '', ''),
(8173, 50, 0, 1, 'Yorkville', '', 'yorkville-8173', '', ''),
(8174, 36, 0, 1, 'Slinger', '', 'slinger', '', ''),
(8175, 9, 0, 1, 'Shiro', '', 'shiro', '', ''),
(8176, 9, 0, 1, 'Snook', '', 'snook', '', ''),
(8177, 9, 0, 1, 'Somerville', '', 'somerville-8177', '', ''),
(8178, 9, 0, 1, 'Seadrift', '', 'seadrift', '', ''),
(8179, 9, 0, 1, 'Shiner', '', 'shiner', '', ''),
(8180, 9, 0, 1, 'Somerset', '', 'somerset-8180', '', ''),
(8181, 9, 0, 1, 'Saint Hedwig', '', 'saint-hedwig', '', ''),
(8182, 9, 0, 1, 'Stockdale', '', 'stockdale', '', ''),
(8183, 9, 0, 1, 'Santa Fe', '', 'santa-fe-8183', '', ''),
(8184, 9, 0, 1, 'Sabine Pass', '', 'sabine-pass', '', ''),
(8185, 9, 0, 1, 'Sour Lake', '', 'sour-lake', '', ''),
(8186, 9, 0, 1, 'Spurger', '', 'spurger', '', ''),
(8187, 9, 0, 1, 'Stowell', '', 'stowell', '', ''),
(8188, 9, 0, 1, 'Shepherd', '', 'shepherd-8188', '', ''),
(8189, 9, 0, 1, 'Sealy', '', 'sealy', '', ''),
(8190, 9, 0, 1, 'Stafford', '', 'stafford-8190', '', ''),
(8191, 9, 0, 1, 'Sweeny', '', 'sweeny', '', ''),
(8192, 9, 0, 1, 'Santo', '', 'santo', '', ''),
(8193, 9, 0, 1, 'San Saba', '', 'san-saba', '', ''),
(8194, 9, 0, 1, 'Santa Anna', '', 'santa-anna', '', ''),
(8195, 9, 0, 1, 'Sonora', '', 'sonora-8195', '', ''),
(8196, 9, 0, 1, 'Sterling City', '', 'sterling-city', '', ''),
(8197, 9, 0, 1, 'Scurry', '', 'scurry', '', ''),
(8198, 9, 0, 1, 'Seagoville', '', 'seagoville', '', ''),
(8199, 9, 0, 1, 'Scroggins', '', 'scroggins', '', ''),
(8200, 9, 0, 1, 'Simms', '', 'simms', '', ''),
(8201, 9, 0, 1, 'Streetman', '', 'streetman', '', ''),
(8202, 9, 0, 1, 'San Augustine', '', 'san-augustine', '', ''),
(8203, 9, 0, 1, 'Springtown', '', 'springtown', '', ''),
(8204, 9, 0, 1, 'Saint Jo', '', 'saint-jo', '', ''),
(8205, 9, 0, 1, 'Sanger', '', 'sanger-8205', '', ''),
(8206, 9, 0, 1, 'Seymour', '', 'seymour-8206', '', ''),
(8207, 9, 0, 1, 'Temple', '', 'temple-8207', '', ''),
(8208, 9, 0, 1, 'Trenton', '', 'trenton-8208', '', ''),
(8209, 9, 0, 1, 'Throckmorton', '', 'throckmorton', '', ''),
(8210, 9, 0, 1, 'Tye', '', 'tye', '', ''),
(8211, 9, 0, 1, 'Three Rivers', '', 'three-rivers-8211', '', ''),
(8212, 9, 0, 1, 'Telephone', '', 'telephone', '', ''),
(8213, 9, 0, 1, 'Tuscola', '', 'tuscola-8213', '', ''),
(8214, 9, 0, 1, 'Tatum', '', 'tatum-8214', '', ''),
(8215, 9, 0, 1, 'Thomaston', '', 'thomaston-8215', '', ''),
(8216, 9, 0, 1, 'Texline', '', 'texline', '', ''),
(8217, 9, 0, 1, 'Tow', '', 'tow', '', ''),
(8218, 9, 0, 1, 'Tahoka', '', 'tahoka', '', ''),
(8219, 9, 0, 1, 'Toyah', '', 'toyah', '', ''),
(8220, 9, 0, 1, 'Troup', '', 'troup', '', ''),
(8221, 9, 0, 1, 'Trent', '', 'trent', '', ''),
(8222, 9, 0, 1, 'Troy', '', 'troy-8222', '', ''),
(8223, 9, 0, 1, 'Thornton', '', 'thornton-8223', '', ''),
(8224, 9, 0, 1, 'Tulia', '', 'tulia', '', ''),
(8225, 9, 0, 1, 'Texarkana', '', 'texarkana-8225', '', ''),
(8226, 9, 0, 1, 'Terlingua', '', 'terlingua', '', ''),
(8227, 9, 0, 1, 'Tennessee Colony', '', 'tennessee-colony', '', ''),
(8228, 9, 0, 1, 'Tarpley', '', 'tarpley', '', ''),
(8229, 9, 0, 1, 'Tornillo', '', 'tornillo', '', ''),
(8230, 9, 0, 1, 'Tioga', '', 'tioga-8230', '', ''),
(8231, 9, 0, 1, 'Tom Bean', '', 'tom-bean', '', ''),
(8232, 9, 0, 1, 'Thorndale', '', 'thorndale-8232', '', ''),
(8233, 9, 0, 1, 'Taylor', '', 'taylor-8233', '', ''),
(8234, 9, 0, 1, 'Tivoli', '', 'tivoli', '', ''),
(8235, 9, 0, 1, 'Taft', '', 'taft-8235', '', ''),
(8236, 9, 0, 1, 'Telferner', '', 'telferner', '', ''),
(8237, 9, 0, 1, 'Trinity', '', 'trinity-8237', '', ''),
(8238, 9, 0, 1, 'Talco', '', 'talco', '', ''),
(8239, 9, 0, 1, 'Tenaha', '', 'tenaha', '', ''),
(8240, 9, 0, 1, 'Tilden', '', 'tilden-8240', '', ''),
(8241, 9, 0, 1, 'Trinidad', '', 'trinidad-8241', '', ''),
(8242, 9, 0, 1, 'Umbarger', '', 'umbarger', '', ''),
(8243, 9, 0, 1, 'Utopia', '', 'utopia', '', ''),
(8244, 9, 0, 1, 'Valley Mills', '', 'valley-mills', '', ''),
(8245, 9, 0, 1, 'Valera', '', 'valera', '', ''),
(8246, 9, 0, 1, 'Vega', '', 'vega', '', ''),
(8247, 9, 0, 1, 'Venus', '', 'venus-8247', '', ''),
(8248, 9, 0, 1, 'Van Vleck', '', 'van-vleck', '', ''),
(8249, 9, 0, 1, 'Von Ormy', '', 'von-ormy', '', ''),
(8250, 9, 0, 1, 'Valley View', '', 'valley-view-8250', '', ''),
(8251, 9, 0, 1, 'Vinton', '', 'vinton-8251', '', ''),
(8252, 9, 0, 1, 'Van Alstyne', '', 'van-alstyne', '', ''),
(8253, 9, 0, 1, 'Village Mills', '', 'village-mills', '', ''),
(8254, 9, 0, 1, 'Vernon', '', 'vernon-8254', '', ''),
(8255, 9, 0, 1, 'Van', '', 'van', '', ''),
(8256, 9, 0, 1, 'Willow City', '', 'willow-city-8256', '', ''),
(8257, 9, 0, 1, 'West Columbia', '', 'west-columbia-8257', '', ''),
(8258, 9, 0, 1, 'White Oak', '', 'white-oak-8258', '', ''),
(8259, 9, 0, 1, 'Winona', '', 'winona-8259', '', ''),
(8260, 9, 0, 1, 'Winnie', '', 'winnie', '', ''),
(8261, 9, 0, 1, 'Wellington', '', 'wellington-8261', '', ''),
(8262, 9, 0, 1, 'Washington', '', 'washington-8262', '', ''),
(8263, 9, 0, 1, 'Walnut Springs', '', 'walnut-springs', '', ''),
(8264, 9, 0, 1, 'Westhoff', '', 'westhoff', '', ''),
(8265, 9, 0, 1, 'Wildorado', '', 'wildorado', '', ''),
(8266, 9, 0, 1, 'Westbrook', '', 'westbrook-8266', '', ''),
(8267, 9, 0, 1, 'White Settlement', '', 'white-settlement', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(8268, 9, 0, 1, 'Woodson', '', 'woodson-8268', '', ''),
(8269, 9, 0, 1, 'Wingate', '', 'wingate-8269', '', ''),
(8270, 9, 0, 1, 'Wolfe City', '', 'wolfe-city', '', ''),
(8271, 9, 0, 1, 'Wadsworth', '', 'wadsworth-8271', '', ''),
(8272, 9, 0, 1, 'Woodway', '', 'woodway', '', ''),
(8273, 9, 0, 1, 'West', '', 'west-8273', '', ''),
(8274, 9, 0, 1, 'Wink', '', 'wink', '', ''),
(8275, 9, 0, 1, 'Wheeler', '', 'wheeler-8275', '', ''),
(8276, 9, 0, 1, 'Wallisville', '', 'wallisville', '', ''),
(8277, 36, 0, 1, 'Sussex', '', 'sussex', '', ''),
(8278, 9, 0, 1, 'White Deer', '', 'white-deer', '', ''),
(8279, 9, 0, 1, 'Waelder', '', 'waelder', '', ''),
(8280, 9, 0, 1, 'Waskom', '', 'waskom', '', ''),
(8281, 9, 0, 1, 'Warrenton', '', 'warrenton-8281', '', ''),
(8282, 9, 0, 1, 'Wortham', '', 'wortham', '', ''),
(8283, 9, 0, 1, 'Webberville', '', 'webberville', '', ''),
(8284, 9, 0, 1, 'Wake Village', '', 'wake-village', '', ''),
(8285, 9, 0, 1, 'Wells', '', 'wells-8285', '', ''),
(8286, 9, 0, 1, 'Welch', '', 'welch-8286', '', ''),
(8287, 9, 0, 1, 'Whitewright', '', 'whitewright', '', ''),
(8288, 9, 0, 1, 'Whitesboro', '', 'whitesboro-8288', '', ''),
(8289, 9, 0, 1, 'Weesatche', '', 'weesatche', '', ''),
(8290, 9, 0, 1, 'Whitney', '', 'whitney-8290', '', ''),
(8291, 9, 0, 1, 'Willow Park', '', 'willow-park', '', ''),
(8292, 9, 0, 1, 'Walburg', '', 'walburg', '', ''),
(8293, 9, 0, 1, 'Woodsboro', '', 'woodsboro-8293', '', ''),
(8294, 9, 0, 1, 'Warren', '', 'warren-8294', '', ''),
(8295, 9, 0, 1, 'Wall', '', 'wall-8295', '', ''),
(8296, 9, 0, 1, 'Wellman', '', 'wellman-8296', '', ''),
(8297, 9, 0, 1, 'Wharton', '', 'wharton-8297', '', ''),
(8298, 9, 0, 1, 'Wickett', '', 'wickett', '', ''),
(8299, 9, 0, 1, 'Waller', '', 'waller', '', ''),
(8300, 9, 0, 1, 'Winnsboro', '', 'winnsboro-8300', '', ''),
(8301, 9, 0, 1, 'Wallis', '', 'wallis', '', ''),
(8302, 9, 0, 1, 'Winfield', '', 'winfield-8302', '', ''),
(8303, 9, 0, 1, 'Woodlake', '', 'woodlake-8303', '', ''),
(8304, 9, 0, 1, 'Webster', '', 'webster-8304', '', ''),
(8305, 9, 0, 1, 'Wilson', '', 'wilson-8305', '', ''),
(8306, 9, 0, 1, 'Wilmer', '', 'wilmer-8306', '', ''),
(8307, 9, 0, 1, 'Windom', '', 'windom-8307', '', ''),
(8308, 9, 0, 1, 'Weston', '', 'weston-8308', '', ''),
(8309, 9, 0, 1, 'Yoakum', '', 'yoakum', '', ''),
(8310, 9, 0, 1, 'Yorktown', '', 'yorktown-8310', '', ''),
(8311, 9, 0, 1, 'Yantis', '', 'yantis', '', ''),
(8312, 9, 0, 1, 'Zavalla', '', 'zavalla', '', ''),
(8313, 9, 0, 1, 'Zephyr', '', 'zephyr', '', ''),
(8314, 24, 0, 1, 'Stockton', '', 'stockton-8314', '', ''),
(8315, 24, 0, 1, 'Syracuse', '', 'syracuse-8315', '', ''),
(8316, 24, 0, 1, 'Tremonton', '', 'tremonton', '', ''),
(8317, 24, 0, 1, 'Tropic', '', 'tropic', '', ''),
(8318, 24, 0, 1, 'Tabiona', '', 'tabiona', '', ''),
(8319, 24, 0, 1, 'Torrey', '', 'torrey', '', ''),
(8320, 24, 0, 1, 'Veyo', '', 'veyo', '', ''),
(8321, 24, 0, 1, 'West Valley', '', 'west-valley', '', ''),
(8322, 24, 0, 1, 'Wellington', '', 'wellington-8322', '', ''),
(8323, 24, 0, 1, 'Willard', '', 'willard-8323', '', ''),
(8324, 24, 0, 1, 'Washington', '', 'washington-8324', '', ''),
(8325, 24, 0, 1, 'West Haven', '', 'west-haven-8325', '', ''),
(8326, 21, 0, 1, 'Viewtown', '', 'viewtown', '', ''),
(8327, 21, 0, 1, 'Weyers Cave', '', 'weyers-cave', '', ''),
(8328, 21, 0, 1, 'Wylliesburg', '', 'wylliesburg', '', ''),
(8329, 21, 0, 1, 'Woodford', '', 'woodford', '', ''),
(8330, 21, 0, 1, 'Warm Springs', '', 'warm-springs-8330', '', ''),
(8331, 21, 0, 1, 'Wallops Island', '', 'wallops-island', '', ''),
(8332, 21, 0, 1, 'Wachapreague', '', 'wachapreague', '', ''),
(8333, 21, 0, 1, 'Willis', '', 'willis-8333', '', ''),
(8334, 21, 0, 1, 'Wirtz', '', 'wirtz', '', ''),
(8335, 21, 0, 1, 'White Marsh', '', 'white-marsh-8335', '', ''),
(8336, 21, 0, 1, 'West Point', '', 'west-point-8336', '', ''),
(8337, 21, 0, 1, 'Windsor', '', 'windsor-8337', '', ''),
(8338, 21, 0, 1, 'Woolwine', '', 'woolwine', '', ''),
(8339, 21, 0, 1, 'Willis Wharf', '', 'willis-wharf', '', ''),
(8340, 21, 0, 1, 'Warsaw', '', 'warsaw-8340', '', ''),
(8341, 21, 0, 1, 'Woodbridge', '', 'woodbridge-8341', '', ''),
(8342, 21, 0, 1, 'Wytheville', '', 'wytheville', '', ''),
(8343, 21, 0, 1, 'Woodstock', '', 'woodstock-8343', '', ''),
(8344, 21, 0, 1, 'Weber City', '', 'weber-city', '', ''),
(8345, 21, 0, 1, 'Washington', '', 'washington-8345', '', ''),
(8346, 21, 0, 1, 'Waverly', '', 'waverly-8346', '', ''),
(8347, 21, 0, 1, 'Wakefield', '', 'wakefield-8347', '', ''),
(8348, 21, 0, 1, 'Wingina', '', 'wingina', '', ''),
(8349, 21, 0, 1, 'Woodlawn', '', 'woodlawn-8349', '', ''),
(8350, 21, 0, 1, 'Warfield', '', 'warfield-8350', '', ''),
(8351, 21, 0, 1, 'Wake', '', 'wake', '', ''),
(8352, 21, 0, 1, 'Weems', '', 'weems', '', ''),
(8353, 21, 0, 1, 'Zanoni', '', 'zanoni', '', ''),
(8354, 38, 0, 1, 'Waterbury Center', '', 'waterbury-center', '', ''),
(8355, 38, 0, 1, 'White River Jct', '', 'white-river-jct', '', ''),
(8356, 38, 0, 1, 'West Rutland', '', 'west-rutland', '', ''),
(8357, 38, 0, 1, 'Weston', '', 'weston-8357', '', ''),
(8358, 38, 0, 1, 'West Burke', '', 'west-burke', '', ''),
(8359, 38, 0, 1, 'West Marlboro', '', 'west-marlboro', '', ''),
(8360, 38, 0, 1, 'Waterbury', '', 'waterbury-8360', '', ''),
(8361, 38, 0, 1, 'Washington', '', 'washington-8361', '', ''),
(8362, 38, 0, 1, 'Warren', '', 'warren-8362', '', ''),
(8363, 38, 0, 1, 'Wallingford', '', 'wallingford-8363', '', ''),
(8364, 38, 0, 1, 'Wilmington', '', 'wilmington-8364', '', ''),
(8365, 38, 0, 1, 'Windsor', '', 'windsor-8365', '', ''),
(8366, 38, 0, 1, 'Woodstock', '', 'woodstock-8366', '', ''),
(8367, 38, 0, 1, 'Williamstown', '', 'williamstown-8367', '', ''),
(8368, 38, 0, 1, 'West Glover', '', 'west-glover', '', ''),
(8369, 38, 0, 1, 'Westfield', '', 'westfield-8369', '', ''),
(8370, 38, 0, 1, 'Westminster', '', 'westminster-8370', '', ''),
(8371, 38, 0, 1, 'Wells River', '', 'wells-river', '', ''),
(8372, 38, 0, 1, 'White River Junction', '', 'white-river-junction', '', ''),
(8373, 38, 0, 1, 'Wardsboro', '', 'wardsboro', '', ''),
(8374, 38, 0, 1, 'Williamsville', '', 'williamsville-8374', '', ''),
(8375, 38, 0, 1, 'Websterville', '', 'websterville', '', ''),
(8376, 38, 0, 1, 'Wolcott', '', 'wolcott-8376', '', ''),
(8377, 12, 0, 1, 'Valley', '', 'valley-8377', '', ''),
(8378, 12, 0, 1, 'Vantage', '', 'vantage', '', ''),
(8379, 12, 0, 1, 'Vader', '', 'vader', '', ''),
(8380, 12, 0, 1, 'Vaughn', '', 'vaughn-8380', '', ''),
(8381, 12, 0, 1, 'Woodland', '', 'woodland-8381', '', ''),
(8382, 12, 0, 1, 'Westport', '', 'westport-8382', '', ''),
(8383, 12, 0, 1, 'Waverly', '', 'waverly-8383', '', ''),
(8384, 12, 0, 1, 'White Salmon', '', 'white-salmon', '', ''),
(8385, 12, 0, 1, 'West Richland', '', 'west-richland', '', ''),
(8386, 12, 0, 1, 'Waterville', '', 'waterville-8386', '', ''),
(8387, 12, 0, 1, 'Winthrop', '', 'winthrop-8387', '', ''),
(8388, 12, 0, 1, 'Warden', '', 'warden', '', ''),
(8389, 12, 0, 1, 'Washtucna', '', 'washtucna', '', ''),
(8390, 12, 0, 1, 'Waitsburg', '', 'waitsburg', '', ''),
(8391, 12, 0, 1, 'Wapato', '', 'wapato', '', ''),
(8392, 12, 0, 1, 'White Swan', '', 'white-swan', '', ''),
(8393, 12, 0, 1, 'Wilkeson', '', 'wilkeson', '', ''),
(8394, 12, 0, 1, 'Yelm', '', 'yelm', '', ''),
(8395, 12, 0, 1, 'Yacolt', '', 'yacolt', '', ''),
(8396, 12, 0, 1, 'Zillah', '', 'zillah', '', ''),
(8397, 36, 0, 1, 'Rochester', '', 'rochester-8397', '', ''),
(8398, 36, 0, 1, 'Radisson', '', 'radisson', '', ''),
(8399, 36, 0, 1, 'Roberts', '', 'roberts', '', ''),
(8400, 36, 0, 1, 'Redgranite', '', 'redgranite', '', ''),
(8401, 36, 0, 1, 'Rudolph', '', 'rudolph', '', ''),
(8402, 36, 0, 1, 'Readstown', '', 'readstown', '', ''),
(8403, 36, 0, 1, 'Readfield', '', 'readfield', '', ''),
(8404, 36, 0, 1, 'Random Lake', '', 'random-lake', '', ''),
(8405, 36, 0, 1, 'Richland Center', '', 'richland-center', '', ''),
(8406, 36, 0, 1, 'Rosholt', '', 'rosholt', '', ''),
(8407, 36, 0, 1, 'Rock Springs', '', 'rock-springs-8407', '', ''),
(8408, 36, 0, 1, 'Reeseville', '', 'reeseville', '', ''),
(8409, 36, 0, 1, 'Rubicon', '', 'rubicon', '', ''),
(8410, 36, 0, 1, 'Ripon', '', 'ripon-8410', '', ''),
(8411, 36, 0, 1, 'Rosendale', '', 'rosendale-8411', '', ''),
(8412, 36, 0, 1, 'Ridgeland', '', 'ridgeland-8412', '', ''),
(8413, 36, 0, 1, 'Ringle', '', 'ringle', '', ''),
(8414, 36, 0, 1, 'Ridgeway', '', 'ridgeway', '', ''),
(8415, 36, 0, 1, 'Randolph', '', 'randolph-8415', '', ''),
(8416, 36, 0, 1, 'Rio', '', 'rio', '', ''),
(8417, 36, 0, 1, 'River Falls', '', 'river-falls', '', ''),
(8418, 36, 0, 1, 'Superior', '', 'superior-8418', '', ''),
(8419, 36, 0, 1, 'Siren', '', 'siren', '', ''),
(8420, 36, 0, 1, 'South Range', '', 'south-range-8420', '', ''),
(8421, 36, 0, 1, 'Solon Springs', '', 'solon-springs', '', ''),
(8422, 36, 0, 1, 'Sullivan', '', 'sullivan-8422', '', ''),
(8423, 36, 0, 1, 'Spencer', '', 'spencer-8423', '', ''),
(8424, 36, 0, 1, 'Summit Lake', '', 'summit-lake', '', ''),
(8425, 36, 0, 1, 'Stratford', '', 'stratford-8425', '', ''),
(8426, 36, 0, 1, 'South Milwaukee', '', 'south-milwaukee', '', ''),
(8427, 36, 0, 1, 'Sparta', '', 'sparta-8427', '', ''),
(8428, 36, 0, 1, 'Salem', '', 'salem-8428', '', ''),
(8429, 36, 0, 1, 'Stanley', '', 'stanley-8429', '', ''),
(8430, 36, 0, 1, 'Silver Lake', '', 'silver-lake-8430', '', ''),
(8431, 36, 0, 1, 'Stoughton', '', 'stoughton-8431', '', ''),
(8432, 36, 0, 1, 'Spring Valley', '', 'spring-valley-8432', '', ''),
(8433, 36, 0, 1, 'Saxon', '', 'saxon', '', ''),
(8434, 36, 0, 1, 'St Nazianz', '', 'st-nazianz', '', ''),
(8435, 36, 0, 1, 'Seymour', '', 'seymour-8435', '', ''),
(8436, 36, 0, 1, 'Soldiers Grove', '', 'soldiers-grove', '', ''),
(8437, 36, 0, 1, 'Sherwood', '', 'sherwood-8437', '', ''),
(8438, 36, 0, 1, 'Suamico', '', 'suamico', '', ''),
(8439, 36, 0, 1, 'St Cloud', '', 'st-cloud', '', ''),
(8440, 36, 0, 1, 'South Wayne', '', 'south-wayne', '', ''),
(8441, 36, 0, 1, 'Shiocton', '', 'shiocton', '', ''),
(8442, 36, 0, 1, 'Shorewood', '', 'shorewood-8442', '', ''),
(8443, 36, 0, 1, 'Somers', '', 'somers-8443', '', ''),
(8444, 36, 0, 1, 'Stockbridge', '', 'stockbridge-8444', '', ''),
(8445, 36, 0, 1, 'Steuben', '', 'steuben', '', ''),
(8446, 36, 0, 1, 'St Francis', '', 'st-francis', '', ''),
(8447, 36, 0, 1, 'Seneca', '', 'seneca-8447', '', ''),
(8448, 36, 0, 1, 'Sand Creek', '', 'sand-creek', '', ''),
(8449, 36, 0, 1, 'St Germain', '', 'st-germain', '', ''),
(8450, 36, 0, 1, 'Shawano', '', 'shawano', '', ''),
(8451, 36, 0, 1, 'Saukville', '', 'saukville', '', ''),
(8452, 36, 0, 1, 'Sharon', '', 'sharon-8452', '', ''),
(8453, 36, 0, 1, 'Spooner', '', 'spooner', '', ''),
(8454, 36, 0, 1, 'Springbrook', '', 'springbrook', '', ''),
(8455, 36, 0, 1, 'Stetsonville', '', 'stetsonville', '', ''),
(8456, 36, 0, 1, 'Sayner', '', 'sayner', '', ''),
(8457, 36, 0, 1, 'St Croix Falls', '', 'st-croix-falls', '', ''),
(8458, 36, 0, 1, 'Stoddard', '', 'stoddard', '', ''),
(8459, 36, 0, 1, 'Sarona', '', 'sarona', '', ''),
(8460, 36, 0, 1, 'Scandinavia', '', 'scandinavia', '', ''),
(8461, 36, 0, 1, 'Star Prairie', '', 'star-prairie', '', ''),
(8462, 36, 0, 1, 'Stockholm', '', 'stockholm', '', ''),
(8463, 36, 0, 1, 'Sobieski', '', 'sobieski', '', ''),
(8464, 36, 0, 1, 'Sheldon', '', 'sheldon-8464', '', ''),
(8465, 36, 0, 1, 'Star Lake', '', 'star-lake', '', ''),
(8466, 36, 0, 1, 'Strum', '', 'strum', '', ''),
(8467, 36, 0, 1, 'Saint Cloud', '', 'saint-cloud-8467', '', ''),
(8468, 18, 0, 1, 'Bolling Afb', '', 'bolling-afb', '', ''),
(8469, 18, 0, 1, 'Fort Mcnair', '', 'fort-mcnair', '', ''),
(8470, 21, 0, 1, 'Arlington', '', 'arlington-8470', '', ''),
(8471, 21, 0, 1, 'Amelia Court Hse', '', 'amelia-court-hse', '', ''),
(8472, 21, 0, 1, 'Amherst', '', 'amherst-8472', '', ''),
(8473, 21, 0, 1, 'Atlantic', '', 'atlantic-8473', '', ''),
(8474, 21, 0, 1, 'Alberta', '', 'alberta', '', ''),
(8475, 21, 0, 1, 'Accomac', '', 'accomac', '', ''),
(8476, 21, 0, 1, 'Arvonia', '', 'arvonia', '', ''),
(8477, 21, 0, 1, 'Alleghany', '', 'alleghany', '', ''),
(8478, 21, 0, 1, 'Ashland', '', 'ashland-8478', '', ''),
(8479, 21, 0, 1, 'Aylett', '', 'aylett', '', ''),
(8480, 21, 0, 1, 'Axton', '', 'axton', '', ''),
(8481, 21, 0, 1, 'Arrington', '', 'arrington', '', ''),
(8482, 21, 0, 1, 'Ararat', '', 'ararat', '', ''),
(8483, 21, 0, 1, 'Afton', '', 'afton-8483', '', ''),
(8484, 21, 0, 1, 'Abingdon', '', 'abingdon-8484', '', ''),
(8485, 21, 0, 1, 'Atkins', '', 'atkins', '', ''),
(8486, 21, 0, 1, 'Amissville', '', 'amissville', '', ''),
(8487, 21, 0, 1, 'Appalachia', '', 'appalachia', '', ''),
(8488, 21, 0, 1, 'Austinville', '', 'austinville', '', ''),
(8489, 21, 0, 1, 'Achilles', '', 'achilles', '', ''),
(8490, 21, 0, 1, 'Bedford', '', 'bedford-8490', '', ''),
(8491, 21, 0, 1, 'Bristol', '', 'bristol-8491', '', ''),
(8492, 21, 0, 1, 'Brodnax', '', 'brodnax', '', ''),
(8493, 21, 0, 1, 'Buchanan', '', 'buchanan-8493', '', ''),
(8494, 21, 0, 1, 'Buena Vista', '', 'buena-vista-8494', '', ''),
(8495, 21, 0, 1, 'Bowling Green', '', 'bowling-green-8495', '', ''),
(8496, 21, 0, 1, 'Blue Ridge', '', 'blue-ridge-8496', '', ''),
(8497, 21, 0, 1, 'Bland', '', 'bland', '', ''),
(8498, 21, 0, 1, 'Bon Air', '', 'bon-air', '', ''),
(8499, 21, 0, 1, 'Big Island', '', 'big-island', '', ''),
(8500, 21, 0, 1, 'Birchleaf', '', 'birchleaf', '', ''),
(8501, 21, 0, 1, 'Berryville', '', 'berryville-8501', '', ''),
(8502, 21, 0, 1, 'Boyce', '', 'boyce', '', ''),
(8503, 21, 0, 1, 'Breaks', '', 'breaks', '', ''),
(8504, 21, 0, 1, 'Baileys Crossrds', '', 'baileys-crossrds', '', ''),
(8505, 21, 0, 1, 'Boones Mill', '', 'boones-mill', '', ''),
(8506, 21, 0, 1, 'Bealeton', '', 'bealeton', '', ''),
(8507, 21, 0, 1, 'Ben Hur', '', 'ben-hur', '', ''),
(8508, 21, 0, 1, 'Bassett', '', 'bassett', '', ''),
(8509, 21, 0, 1, 'Bluemont', '', 'bluemont', '', ''),
(8510, 21, 0, 1, 'Blackstone', '', 'blackstone-8510', '', ''),
(8511, 21, 0, 1, 'Bracey', '', 'bracey', '', ''),
(8512, 21, 0, 1, 'Blairs', '', 'blairs', '', ''),
(8513, 21, 0, 1, 'Burkeville', '', 'burkeville', '', ''),
(8514, 21, 0, 1, 'Burgess', '', 'burgess', '', ''),
(8515, 21, 0, 1, 'Boydton', '', 'boydton', '', ''),
(8516, 21, 0, 1, 'Basye', '', 'basye', '', ''),
(8517, 21, 0, 1, 'Bristow', '', 'bristow-8517', '', ''),
(8518, 21, 0, 1, 'Bluefield', '', 'bluefield-8518', '', ''),
(8519, 21, 0, 1, 'Bridgewater', '', 'bridgewater-8519', '', ''),
(8520, 21, 0, 1, 'Bent Mountain', '', 'bent-mountain', '', ''),
(8521, 21, 0, 1, 'Boykins', '', 'boykins', '', ''),
(8522, 21, 0, 1, 'Big Rock', '', 'big-rock', '', ''),
(8523, 21, 0, 1, 'Barren Springs', '', 'barren-springs', '', ''),
(8524, 21, 0, 1, 'Broadford', '', 'broadford', '', ''),
(8525, 21, 0, 1, 'Bumpass', '', 'bumpass', '', ''),
(8526, 21, 0, 1, 'Boston', '', 'boston-8526', '', ''),
(8527, 21, 0, 1, 'Chincoteague', '', 'chincoteague', '', ''),
(8528, 21, 0, 1, 'Chester', '', 'chester-8528', '', ''),
(8529, 21, 0, 1, 'Craigsville', '', 'craigsville', '', ''),
(8530, 21, 0, 1, 'Chesterfield', '', 'chesterfield-8530', '', ''),
(8531, 21, 0, 1, 'Clifton Forge', '', 'clifton-forge', '', ''),
(8532, 21, 0, 1, 'Concord', '', 'concord-8532', '', ''),
(8533, 21, 0, 1, 'Charles City', '', 'charles-city-8533', '', ''),
(8534, 21, 0, 1, 'Cloverdale', '', 'cloverdale-8534', '', ''),
(8535, 21, 0, 1, 'Crozet', '', 'crozet', '', ''),
(8536, 21, 0, 1, 'Churchville', '', 'churchville-8536', '', ''),
(8537, 21, 0, 1, 'Cana', '', 'cana', '', ''),
(8538, 21, 0, 1, 'Charlotte Ct Hse', '', 'charlotte-ct-hse', '', ''),
(8539, 21, 0, 1, 'Cullen', '', 'cullen', '', ''),
(8540, 21, 0, 1, 'Covington', '', 'covington-8540', '', ''),
(8541, 21, 0, 1, 'Church Road', '', 'church-road', '', ''),
(8542, 21, 0, 1, 'Cumberland', '', 'cumberland-8542', '', ''),
(8543, 21, 0, 1, 'Carson', '', 'carson-8543', '', ''),
(8544, 21, 0, 1, 'Clifton', '', 'clifton-8544', '', ''),
(8545, 21, 0, 1, 'Clear Brook', '', 'clear-brook', '', ''),
(8546, 21, 0, 1, 'Crozier', '', 'crozier', '', ''),
(8547, 21, 0, 1, 'Collinsville', '', 'collinsville-8547', '', ''),
(8548, 21, 0, 1, 'Carrsville', '', 'carrsville', '', ''),
(8549, 21, 0, 1, 'Carrollton', '', 'carrollton-8549', '', ''),
(8550, 21, 0, 1, 'Clover', '', 'clover', '', ''),
(8551, 21, 0, 1, 'Callands', '', 'callands', '', ''),
(8552, 21, 0, 1, 'Callao', '', 'callao', '', ''),
(8553, 21, 0, 1, 'Crewe', '', 'crewe', '', ''),
(8554, 21, 0, 1, 'Cheriton', '', 'cheriton', '', ''),
(8555, 21, 0, 1, 'Chatham', '', 'chatham-8555', '', ''),
(8556, 21, 0, 1, 'Clarksville', '', 'clarksville-8556', '', ''),
(8557, 21, 0, 1, 'Claudville', '', 'claudville', '', ''),
(8558, 21, 0, 1, 'Clinchport', '', 'clinchport', '', ''),
(8559, 21, 0, 1, 'Courtland', '', 'courtland', '', ''),
(8560, 21, 0, 1, 'Coeburn', '', 'coeburn', '', ''),
(8561, 21, 0, 1, 'Chilhowie', '', 'chilhowie', '', ''),
(8562, 21, 0, 1, 'Catawba', '', 'catawba', '', ''),
(8563, 21, 0, 1, 'Castlewood', '', 'castlewood', '', ''),
(8564, 21, 0, 1, 'Capron', '', 'capron-8564', '', ''),
(8565, 21, 0, 1, 'Catharpin', '', 'catharpin', '', ''),
(8566, 21, 0, 1, 'Crockett', '', 'crockett-8566', '', ''),
(8567, 21, 0, 1, 'Copper Hill', '', 'copper-hill', '', ''),
(8568, 21, 0, 1, 'Claremont', '', 'claremont-8568', '', ''),
(8569, 21, 0, 1, 'Charlotte Court House', '', 'charlotte-court-house', '', ''),
(8570, 21, 0, 1, 'Cobbs Creek', '', 'cobbs-creek', '', ''),
(8571, 21, 0, 1, 'Daleville', '', 'daleville', '', ''),
(8572, 21, 0, 1, 'Drakes Branch', '', 'drakes-branch', '', ''),
(8573, 21, 0, 1, 'Dillwyn', '', 'dillwyn', '', ''),
(8574, 21, 0, 1, 'Davenport', '', 'davenport-8574', '', ''),
(8575, 21, 0, 1, 'Dinwiddie', '', 'dinwiddie', '', ''),
(8576, 21, 0, 1, 'Dyke', '', 'dyke', '', ''),
(8577, 21, 0, 1, 'Doswell', '', 'doswell', '', ''),
(8578, 21, 0, 1, 'Dahlgren', '', 'dahlgren', '', ''),
(8579, 21, 0, 1, 'Dry Fork', '', 'dry-fork', '', ''),
(8580, 21, 0, 1, 'Deltaville', '', 'deltaville', '', ''),
(8581, 21, 0, 1, 'Dundas', '', 'dundas', '', ''),
(8582, 21, 0, 1, 'Damascus', '', 'damascus-8582', '', ''),
(8583, 21, 0, 1, 'Dublin', '', 'dublin-8583', '', ''),
(8584, 21, 0, 1, 'Disputanta', '', 'disputanta', '', ''),
(8585, 21, 0, 1, 'Dayton', '', 'dayton-8585', '', ''),
(8586, 21, 0, 1, 'Duffield', '', 'duffield', '', ''),
(8587, 21, 0, 1, 'Dendron', '', 'dendron', '', ''),
(8588, 21, 0, 1, 'Doran', '', 'doran', '', ''),
(8589, 21, 0, 1, 'Dungannon', '', 'dungannon', '', ''),
(8590, 21, 0, 1, 'Deerfield', '', 'deerfield-8590', '', ''),
(8591, 21, 0, 1, 'Dryden', '', 'dryden-8591', '', ''),
(8592, 21, 0, 1, 'Eagle Rock', '', 'eagle-rock', '', ''),
(8593, 21, 0, 1, 'Earlysville', '', 'earlysville', '', ''),
(8594, 21, 0, 1, 'Emporia', '', 'emporia-8594', '', ''),
(8595, 21, 0, 1, 'Elk Creek', '', 'elk-creek', '', ''),
(8596, 21, 0, 1, 'Ewing', '', 'ewing-8596', '', ''),
(8597, 21, 0, 1, 'Eastville', '', 'eastville', '', ''),
(8598, 21, 0, 1, 'Exmore', '', 'exmore', '', ''),
(8599, 21, 0, 1, 'Ettrick', '', 'ettrick', '', ''),
(8600, 21, 0, 1, 'Elliston', '', 'elliston', '', ''),
(8601, 21, 0, 1, 'Edinburg', '', 'edinburg-8601', '', ''),
(8602, 21, 0, 1, 'Elkton', '', 'elkton-8602', '', ''),
(8603, 21, 0, 1, 'Emory', '', 'emory-8603', '', ''),
(8604, 21, 0, 1, 'Free Union', '', 'free-union', '', ''),
(8605, 21, 0, 1, 'Fincastle', '', 'fincastle', '', ''),
(8606, 21, 0, 1, 'Freeman', '', 'freeman', '', ''),
(8607, 21, 0, 1, 'Fancy Gap', '', 'fancy-gap', '', ''),
(8608, 21, 0, 1, 'Fort Belvoir', '', 'fort-belvoir', '', ''),
(8609, 21, 0, 1, 'Franconia', '', 'franconia-8609', '', ''),
(8610, 21, 0, 1, 'Franklin', '', 'franklin-8610', '', ''),
(8611, 21, 0, 1, 'Fries', '', 'fries', '', ''),
(8612, 21, 0, 1, 'Ferrum', '', 'ferrum', '', ''),
(8613, 21, 0, 1, 'Fork Union', '', 'fork-union', '', ''),
(8614, 21, 0, 1, 'Fieldale', '', 'fieldale', '', ''),
(8615, 21, 0, 1, 'Farmville', '', 'farmville', '', ''),
(8616, 21, 0, 1, 'Fort Lee', '', 'fort-lee-8616', '', ''),
(8617, 21, 0, 1, 'Fairlawn', '', 'fairlawn-8617', '', ''),
(8618, 21, 0, 1, 'Flint Hill', '', 'flint-hill', '', ''),
(8619, 21, 0, 1, 'Farnham', '', 'farnham', '', ''),
(8620, 21, 0, 1, 'Fairfield', '', 'fairfield-8620', '', ''),
(8621, 21, 0, 1, 'Faber', '', 'faber', '', ''),
(8622, 21, 0, 1, 'Greenville', '', 'greenville-8622', '', ''),
(8623, 21, 0, 1, 'Greenbackville', '', 'greenbackville', '', ''),
(8624, 21, 0, 1, 'Grundy', '', 'grundy', '', ''),
(8625, 21, 0, 1, 'Goodview', '', 'goodview', '', ''),
(8626, 21, 0, 1, 'Gasburg', '', 'gasburg', '', ''),
(8627, 21, 0, 1, 'Great Falls', '', 'great-falls-8627', '', ''),
(8628, 21, 0, 1, 'Gloucester', '', 'gloucester-8628', '', ''),
(8629, 21, 0, 1, 'Gloucester Point', '', 'gloucester-point', '', ''),
(8630, 21, 0, 1, 'Goochland', '', 'goochland', '', ''),
(8631, 21, 0, 1, 'Gore', '', 'gore-8631', '', ''),
(8632, 21, 0, 1, 'Gretna', '', 'gretna-8632', '', ''),
(8633, 21, 0, 1, 'Grimstead', '', 'grimstead', '', ''),
(8634, 21, 0, 1, 'Graves Mill', '', 'graves-mill', '', ''),
(8635, 21, 0, 1, 'Glade Spring', '', 'glade-spring', '', ''),
(8636, 21, 0, 1, 'Gainesville', '', 'gainesville-8636', '', ''),
(8637, 21, 0, 1, 'Gate City', '', 'gate-city', '', ''),
(8638, 21, 0, 1, 'Goshen', '', 'goshen-8638', '', ''),
(8639, 21, 0, 1, 'Grottoes', '', 'grottoes', '', ''),
(8640, 21, 0, 1, 'Glasgow', '', 'glasgow-8640', '', ''),
(8641, 21, 0, 1, 'Garrisonville', '', 'garrisonville', '', ''),
(8642, 21, 0, 1, 'Huddleston', '', 'huddleston', '', ''),
(8643, 21, 0, 1, 'Hardy', '', 'hardy', '', ''),
(8644, 21, 0, 1, 'Hot Springs', '', 'hot-springs-8644', '', ''),
(8645, 21, 0, 1, 'Hurley', '', 'hurley-8645', '', ''),
(8646, 21, 0, 1, 'Harman', '', 'harman', '', ''),
(8647, 21, 0, 1, 'Haysi', '', 'haysi', '', ''),
(8648, 21, 0, 1, 'Horntown', '', 'horntown', '', ''),
(8649, 21, 0, 1, 'Highland Springs', '', 'highland-springs', '', ''),
(8650, 21, 0, 1, 'Henry', '', 'henry', '', ''),
(8651, 21, 0, 1, 'Hamilton', '', 'hamilton-8651', '', ''),
(8652, 21, 0, 1, 'Halifax', '', 'halifax-8652', '', ''),
(8653, 21, 0, 1, 'Hanover', '', 'hanover-8653', '', ''),
(8654, 21, 0, 1, 'Hurt', '', 'hurt', '', ''),
(8655, 21, 0, 1, 'Heathsville', '', 'heathsville', '', ''),
(8656, 21, 0, 1, 'Hartfield', '', 'hartfield', '', ''),
(8657, 21, 0, 1, 'Hague', '', 'hague', '', ''),
(8658, 21, 0, 1, 'Hollins', '', 'hollins', '', ''),
(8659, 21, 0, 1, 'Hartwood', '', 'hartwood', '', ''),
(8660, 21, 0, 1, 'Hampden Sydney', '', 'hampden-sydney', '', ''),
(8661, 21, 0, 1, 'Hardyville', '', 'hardyville', '', ''),
(8662, 21, 0, 1, 'Hood', '', 'hood', '', ''),
(8663, 21, 0, 1, 'Hume', '', 'hume', '', ''),
(8664, 21, 0, 1, 'Ivy', '', 'ivy', '', ''),
(8665, 21, 0, 1, 'Independence', '', 'independence-8665', '', ''),
(8666, 21, 0, 1, 'Irvington', '', 'irvington-8666', '', ''),
(8667, 21, 0, 1, 'Ironto', '', 'ironto', '', ''),
(8668, 21, 0, 1, 'Ivor', '', 'ivor', '', ''),
(8669, 21, 0, 1, 'Isle Of Wight', '', 'isle-of-wight', '', ''),
(8670, 21, 0, 1, 'Jetersville', '', 'jetersville', '', ''),
(8671, 21, 0, 1, 'Jonesville', '', 'jonesville-8671', '', ''),
(8672, 21, 0, 1, 'Java', '', 'java', '', ''),
(8673, 21, 0, 1, 'Jeffersonton', '', 'jeffersonton', '', ''),
(8674, 21, 0, 1, 'Keysville', '', 'keysville', '', ''),
(8675, 21, 0, 1, 'King William', '', 'king-william', '', ''),
(8676, 21, 0, 1, 'King & Queen C H', '', 'king-queen-c-h', '', ''),
(8677, 21, 0, 1, 'Kenbridge', '', 'kenbridge', '', ''),
(8678, 21, 0, 1, 'Lawrenceville', '', 'lawrenceville-8678', '', ''),
(8679, 21, 0, 1, 'Ladysmith', '', 'ladysmith-8679', '', ''),
(8680, 21, 0, 1, 'Low Moor', '', 'low-moor', '', ''),
(8681, 21, 0, 1, 'Lambsburg', '', 'lambsburg', '', ''),
(8682, 21, 0, 1, 'Lorton', '', 'lorton', '', ''),
(8683, 21, 0, 1, 'Lexington', '', 'lexington-8683', '', ''),
(8684, 21, 0, 1, 'Lancaster', '', 'lancaster-8684', '', ''),
(8685, 21, 0, 1, 'Lovettsville', '', 'lovettsville', '', ''),
(8686, 21, 0, 1, 'Lively', '', 'lively', '', ''),
(8687, 21, 0, 1, 'Lightfoot', '', 'lightfoot', '', ''),
(8688, 21, 0, 1, 'Langley Afb', '', 'langley-afb', '', ''),
(8689, 21, 0, 1, 'Locust Hill', '', 'locust-hill', '', ''),
(8690, 21, 0, 1, 'Louisa', '', 'louisa', '', ''),
(8691, 21, 0, 1, 'Locust Grove', '', 'locust-grove-8691', '', ''),
(8692, 21, 0, 1, 'Lanexa', '', 'lanexa', '', ''),
(8693, 21, 0, 1, 'Leon', '', 'leon-8693', '', ''),
(8694, 21, 0, 1, 'La Crosse', '', 'la-crosse-8694', '', ''),
(8695, 21, 0, 1, 'Lebanon', '', 'lebanon-8695', '', ''),
(8696, 21, 0, 1, 'Lowmoor', '', 'lowmoor', '', ''),
(8697, 21, 0, 1, 'Locust Dale', '', 'locust-dale', '', ''),
(8698, 21, 0, 1, 'Lottsburg', '', 'lottsburg', '', ''),
(8699, 21, 0, 1, 'Madison Heights', '', 'madison-heights-8699', '', ''),
(8700, 21, 0, 1, 'Moneta', '', 'moneta', '', ''),
(8701, 21, 0, 1, 'Maxie', '', 'maxie', '', ''),
(8702, 21, 0, 1, 'Millboro', '', 'millboro', '', ''),
(8703, 21, 0, 1, 'Mt Sidney', '', 'mt-sidney', '', ''),
(8704, 21, 0, 1, 'Mappsville', '', 'mappsville', '', ''),
(8705, 21, 0, 1, 'Monroe', '', 'monroe-8705', '', ''),
(8706, 21, 0, 1, 'Montvale', '', 'montvale-8706', '', ''),
(8707, 21, 0, 1, 'Mc Kenney', '', 'mc-kenney', '', ''),
(8708, 21, 0, 1, 'Mc Clure', '', 'mc-clure', '', ''),
(8709, 21, 0, 1, 'Marshall', '', 'marshall-8709', '', ''),
(8710, 21, 0, 1, 'Manakin Sabot', '', 'manakin-sabot', '', ''),
(8711, 21, 0, 1, 'Middletown', '', 'middletown-8711', '', ''),
(8712, 21, 0, 1, 'Midland', '', 'midland-8712', '', ''),
(8713, 21, 0, 1, 'Maidens', '', 'maidens', '', ''),
(8714, 21, 0, 1, 'Morrisville', '', 'morrisville-8714', '', ''),
(8715, 21, 0, 1, 'Mt Vernon', '', 'mt-vernon-8715', '', ''),
(8716, 21, 0, 1, 'Mouth Of Wilson', '', 'mouth-of-wilson', '', ''),
(8717, 21, 0, 1, 'Middleburg', '', 'middleburg', '', ''),
(8718, 21, 0, 1, 'Monterey', '', 'monterey-8718', '', ''),
(8719, 21, 0, 1, 'Montpelier', '', 'montpelier-8719', '', ''),
(8720, 21, 0, 1, 'Manassas Park', '', 'manassas-park', '', ''),
(8721, 21, 0, 1, 'Madison', '', 'madison-8721', '', ''),
(8722, 21, 0, 1, 'Meadows Of Dan', '', 'meadows-of-dan', '', ''),
(8723, 21, 0, 1, 'Moseley', '', 'moseley', '', ''),
(8724, 21, 0, 1, 'Montross', '', 'montross', '', ''),
(8725, 21, 0, 1, 'Marion', '', 'marion-8725', '', ''),
(8726, 21, 0, 1, 'Mt Crawford', '', 'mt-crawford', '', ''),
(8727, 21, 0, 1, 'Mt Jackson', '', 'mt-jackson', '', ''),
(8728, 21, 0, 1, 'Meadowview', '', 'meadowview', '', ''),
(8729, 21, 0, 1, 'Mount Sidney', '', 'mount-sidney', '', ''),
(8730, 21, 0, 1, 'Mattaponi', '', 'mattaponi', '', ''),
(8731, 21, 0, 1, 'Mount Crawford', '', 'mount-crawford', '', ''),
(8732, 21, 0, 1, 'Milford', '', 'milford-8732', '', ''),
(8733, 21, 0, 1, 'Mount Holly', '', 'mount-holly-8733', '', ''),
(8734, 21, 0, 1, 'Merrifield', '', 'merrifield', '', ''),
(8735, 21, 0, 1, 'North Garden', '', 'north-garden', '', ''),
(8736, 21, 0, 1, 'New Church', '', 'new-church', '', ''),
(8737, 21, 0, 1, 'Naruna', '', 'naruna', '', ''),
(8738, 21, 0, 1, 'New Castle', '', 'new-castle-8738', '', ''),
(8739, 21, 0, 1, 'Narrows', '', 'narrows', '', ''),
(8740, 21, 0, 1, 'Newington', '', 'newington-8740', '', ''),
(8741, 21, 0, 1, 'Nathalie', '', 'nathalie', '', ''),
(8742, 21, 0, 1, 'Norton', '', 'norton-8742', '', ''),
(8743, 21, 0, 1, 'Nellysford', '', 'nellysford', '', ''),
(8744, 21, 0, 1, 'Naval Base', '', 'naval-base', '', ''),
(8745, 21, 0, 1, 'New Kent', '', 'new-kent', '', ''),
(8746, 21, 0, 1, 'Nassawadox', '', 'nassawadox', '', ''),
(8747, 21, 0, 1, 'Natural Brdg Sta', '', 'natural-brdg-sta', '', ''),
(8748, 21, 0, 1, 'Natural Bridge', '', 'natural-bridge', '', ''),
(8749, 21, 0, 1, 'North Tazewell', '', 'north-tazewell', '', ''),
(8750, 21, 0, 1, 'Nokesville', '', 'nokesville', '', ''),
(8751, 21, 0, 1, 'Nickelsville', '', 'nickelsville', '', ''),
(8752, 21, 0, 1, 'Newsoms', '', 'newsoms', '', ''),
(8753, 21, 0, 1, 'Natural Bridge Station', '', 'natural-bridge-station', '', ''),
(8754, 21, 0, 1, 'Onley', '', 'onley', '', ''),
(8755, 21, 0, 1, 'Oakwood', '', 'oakwood-8755', '', ''),
(8756, 21, 0, 1, 'Oak Hall', '', 'oak-hall', '', ''),
(8757, 21, 0, 1, 'Oilville', '', 'oilville', '', ''),
(8758, 21, 0, 1, 'Orange', '', 'orange-8758', '', ''),
(8759, 21, 0, 1, 'Orkney Springs', '', 'orkney-springs', '', ''),
(8760, 21, 0, 1, 'Ordinary', '', 'ordinary', '', ''),
(8761, 21, 0, 1, 'Port Royal', '', 'port-royal-8761', '', ''),
(8762, 21, 0, 1, 'Pembroke', '', 'pembroke-8762', '', ''),
(8763, 21, 0, 1, 'Paris', '', 'paris-8763', '', ''),
(8764, 21, 0, 1, 'Penhook', '', 'penhook', '', ''),
(8765, 21, 0, 1, 'Pennington Gap', '', 'pennington-gap', '', ''),
(8766, 21, 0, 1, 'Providence Forge', '', 'providence-forge', '', ''),
(8767, 21, 0, 1, 'Patrick Springs', '', 'patrick-springs', '', ''),
(8768, 21, 0, 1, 'Portsmouth', '', 'portsmouth-8768', '', ''),
(8769, 21, 0, 1, 'Pulaski', '', 'pulaski-8769', '', ''),
(8770, 21, 0, 1, 'Pound', '', 'pound', '', ''),
(8771, 21, 0, 1, 'Pocahontas', '', 'pocahontas-8771', '', ''),
(8772, 21, 0, 1, 'Pounding Mill', '', 'pounding-mill', '', ''),
(8773, 21, 0, 1, 'Parrott', '', 'parrott', '', ''),
(8774, 21, 0, 1, 'Pamplin', '', 'pamplin', '', ''),
(8775, 21, 0, 1, 'Prospect', '', 'prospect-8775', '', ''),
(8776, 21, 0, 1, 'Quinton', '', 'quinton', '', ''),
(8777, 21, 0, 1, 'Quantico', '', 'quantico', '', ''),
(8778, 21, 0, 1, 'Quinque', '', 'quinque', '', ''),
(8779, 21, 0, 1, 'Ruther Glen', '', 'ruther-glen', '', ''),
(8780, 21, 0, 1, 'Red House', '', 'red-house', '', ''),
(8781, 21, 0, 1, 'Rustburg', '', 'rustburg', '', ''),
(8782, 21, 0, 1, 'Rocky Gap', '', 'rocky-gap', '', ''),
(8783, 21, 0, 1, 'Rowe', '', 'rowe', '', ''),
(8784, 21, 0, 1, 'Rocky Mount', '', 'rocky-mount-8784', '', ''),
(8785, 21, 0, 1, 'Rich Creek', '', 'rich-creek', '', ''),
(8786, 21, 0, 1, 'Remington', '', 'remington', '', ''),
(8787, 21, 0, 1, 'Ripplemead', '', 'ripplemead', '', ''),
(8788, 21, 0, 1, 'Ridgeway', '', 'ridgeway-8788', '', ''),
(8789, 21, 0, 1, 'Rose Hill', '', 'rose-hill', '', ''),
(8790, 21, 0, 1, 'Ringgold', '', 'ringgold-8790', '', ''),
(8791, 21, 0, 1, 'Reedville', '', 'reedville', '', ''),
(8792, 21, 0, 1, 'Radford', '', 'radford', '', ''),
(8793, 21, 0, 1, 'Raphine', '', 'raphine', '', ''),
(8794, 21, 0, 1, 'Richlands', '', 'richlands-8794', '', ''),
(8795, 21, 0, 1, 'Rural Retreat', '', 'rural-retreat', '', ''),
(8796, 21, 0, 1, 'Rice', '', 'rice', '', ''),
(8797, 21, 0, 1, 'Rosedale', '', 'rosedale-8797', '', ''),
(8798, 21, 0, 1, 'Raven', '', 'raven', '', ''),
(8799, 21, 0, 1, 'Rockville', '', 'rockville-8799', '', ''),
(8800, 21, 0, 1, 'Roseland', '', 'roseland-8800', '', ''),
(8801, 21, 0, 1, 'Richardsville', '', 'richardsville', '', ''),
(8802, 21, 0, 1, 'Scottsville', '', 'scottsville-8802', '', ''),
(8803, 21, 0, 1, 'Saxis', '', 'saxis', '', ''),
(8804, 21, 0, 1, 'Sutherland', '', 'sutherland-8804', '', ''),
(8805, 21, 0, 1, 'Stevensburg', '', 'stevensburg', '', ''),
(8806, 21, 0, 1, 'Sandy Hook', '', 'sandy-hook-8806', '', ''),
(8807, 21, 0, 1, 'Star Tannery', '', 'star-tannery', '', ''),
(8808, 21, 0, 1, 'Stanardsville', '', 'stanardsville', '', ''),
(8809, 21, 0, 1, 'South Boston', '', 'south-boston-8809', '', ''),
(8810, 21, 0, 1, 'Smithfield', '', 'smithfield-8810', '', ''),
(8811, 21, 0, 1, 'Sterling', '', 'sterling-8811', '', ''),
(8812, 21, 0, 1, 'South Riding', '', 'south-riding', '', ''),
(8813, 21, 0, 1, 'Stanleytown', '', 'stanleytown', '', ''),
(8814, 21, 0, 1, 'Spencer', '', 'spencer-8814', '', ''),
(8815, 21, 0, 1, 'Shacklefords', '', 'shacklefords', '', ''),
(8816, 21, 0, 1, 'Shenandoah', '', 'shenandoah-8816', '', ''),
(8817, 21, 0, 1, 'Shawsville', '', 'shawsville', '', ''),
(8818, 21, 0, 1, 'Saluda', '', 'saluda-8818', '', ''),
(8819, 21, 0, 1, 'Stuart', '', 'stuart-8819', '', ''),
(8820, 21, 0, 1, 'Stanley', '', 'stanley-8820', '', ''),
(8821, 21, 0, 1, 'Sandy Level', '', 'sandy-level', '', ''),
(8822, 21, 0, 1, 'Schuyler', '', 'schuyler-8822', '', ''),
(8823, 21, 0, 1, 'Salem', '', 'salem-8823', '', ''),
(8824, 21, 0, 1, 'Strasburg', '', 'strasburg-8824', '', ''),
(8825, 21, 0, 1, 'Spotsylvania', '', 'spotsylvania', '', ''),
(8826, 21, 0, 1, 'Saltville', '', 'saltville', '', ''),
(8827, 21, 0, 1, 'St Paul', '', 'st-paul-8827', '', ''),
(8828, 21, 0, 1, 'Stony Creek', '', 'stony-creek', '', ''),
(8829, 21, 0, 1, 'Speedwell', '', 'speedwell-8829', '', ''),
(8830, 21, 0, 1, 'Sugar Grove', '', 'sugar-grove-8830', '', ''),
(8831, 21, 0, 1, 'Syria', '', 'syria', '', ''),
(8832, 21, 0, 1, 'Spout Spring', '', 'spout-spring', '', ''),
(8833, 21, 0, 1, 'Swoope', '', 'swoope', '', ''),
(8834, 21, 0, 1, 'Saint Paul', '', 'saint-paul-8834', '', ''),
(8835, 21, 0, 1, 'Sharps', '', 'sharps', '', ''),
(8836, 21, 0, 1, 'Tangier', '', 'tangier', '', ''),
(8837, 21, 0, 1, 'Temperanceville', '', 'temperanceville', '', ''),
(8838, 21, 0, 1, 'Tappahannock', '', 'tappahannock', '', ''),
(8839, 21, 0, 1, 'Troy', '', 'troy-8839', '', ''),
(8840, 21, 0, 1, 'Troutdale', '', 'troutdale-8840', '', ''),
(8841, 21, 0, 1, 'Toano', '', 'toano', '', ''),
(8842, 21, 0, 1, 'Topping', '', 'topping', '', ''),
(8843, 21, 0, 1, 'Tabb', '', 'tabb', '', ''),
(8844, 21, 0, 1, 'Thornburg', '', 'thornburg', '', ''),
(8845, 21, 0, 1, 'Triangle', '', 'triangle', '', ''),
(8846, 21, 0, 1, 'Timberville', '', 'timberville', '', ''),
(8847, 21, 0, 1, 'Toms Brook', '', 'toms-brook', '', ''),
(8848, 21, 0, 1, 'Tasley', '', 'tasley', '', ''),
(8849, 21, 0, 1, 'Upperville', '', 'upperville', '', ''),
(8850, 21, 0, 1, 'Union Hall', '', 'union-hall', '', ''),
(8851, 21, 0, 1, 'Urbanna', '', 'urbanna', '', ''),
(8852, 21, 0, 1, 'Unionville', '', 'unionville-8852', '', ''),
(8853, 21, 0, 1, 'Verona', '', 'verona-8853', '', ''),
(8854, 21, 0, 1, 'Valentines', '', 'valentines', '', ''),
(8855, 21, 0, 1, 'Vansant', '', 'vansant', '', ''),
(8856, 21, 0, 1, 'Victoria', '', 'victoria-8856', '', ''),
(8857, 30, 0, 1, 'Columbus', '', 'columbus', '', ''),
(8858, 62, 0, 2, 'Acrelândia', '', 'acrelandia', '', ''),
(8859, 62, 0, 2, 'Assis Brasil', '', 'assis-brasil', '', ''),
(8860, 62, 0, 2, 'Brasiléia', '', 'brasileia', '', ''),
(8861, 62, 0, 2, 'Bujari', '', 'bujari', '', ''),
(8862, 62, 0, 2, 'Capixaba', '', 'capixaba', '', ''),
(8863, 62, 0, 2, 'Cruzeiro do Sul', '', 'cruzeiro-do-sul', '', ''),
(8864, 62, 0, 2, 'Epitaciolândia', '', 'epitaciolandia', '', ''),
(8865, 62, 0, 2, 'Feijó', '', 'feijo', '', ''),
(8866, 62, 0, 2, 'Jordão', '', 'jordao', '', ''),
(8867, 62, 0, 2, 'Mâncio Lima', '', 'mancio-lima', '', ''),
(8868, 62, 0, 2, 'Manoel Urbano', '', 'manoel-urbano', '', ''),
(8869, 62, 0, 2, 'Marechal Thaumaturgo', '', 'marechal-thaumaturgo', '', ''),
(8870, 62, 0, 2, 'Plácido de Castro', '', 'placido-de-castro', '', ''),
(8871, 62, 0, 2, 'Porto Acre', '', 'porto-acre', '', ''),
(8872, 62, 0, 2, 'Porto Walter', '', 'porto-walter', '', ''),
(8873, 62, 0, 2, 'Rio Branco', '', 'rio-branco', '', ''),
(8874, 62, 0, 2, 'Rodrigues Alves', '', 'rodrigues-alves', '', ''),
(8875, 62, 0, 2, 'Santa Rosa do Purus', '', 'santa-rosa-do-purus', '', ''),
(8876, 62, 0, 2, 'Sena Madureira', '', 'sena-madureira', '', ''),
(8877, 62, 0, 2, 'Senador Guiomard', '', 'senador-guiomard', '', ''),
(8878, 62, 0, 2, 'Tarauacá', '', 'tarauaca', '', ''),
(8879, 62, 0, 2, 'Xapuri', '', 'xapuri', '', ''),
(8880, 63, 0, 2, 'Água Branca', '', 'agua-branca', '', ''),
(8881, 63, 0, 2, 'Anadia', '', 'anadia', '', ''),
(8882, 63, 0, 2, 'Arapiraca', '', 'arapiraca', '', ''),
(8883, 63, 0, 2, 'Atalaia', '', 'atalaia', '', ''),
(8884, 63, 0, 2, 'Barra de Santo Antônio', '', 'barra-de-santo-antonio', '', ''),
(8885, 63, 0, 2, 'Barra de São Miguel', '', 'barra-de-sao-miguel', '', ''),
(8886, 63, 0, 2, 'Batalha', '', 'batalha', '', ''),
(8887, 63, 0, 2, 'Belém', '', 'belem', '', ''),
(8888, 63, 0, 2, 'Belo Monte', '', 'belo-monte', '', ''),
(8889, 63, 0, 2, 'Boca da Mata', '', 'boca-da-mata', '', ''),
(8890, 63, 0, 2, 'Branquinha', '', 'branquinha', '', ''),
(8891, 63, 0, 2, 'Cacimbinhas', '', 'cacimbinhas', '', ''),
(8892, 63, 0, 2, 'Cajueiro', '', 'cajueiro', '', ''),
(8893, 63, 0, 2, 'Campestre', '', 'campestre', '', ''),
(8894, 63, 0, 2, 'Campo Alegre', '', 'campo-alegre', '', ''),
(8895, 63, 0, 2, 'Campo Grande', '', 'campo-grande', '', ''),
(8896, 63, 0, 2, 'Canapi', '', 'canapi', '', ''),
(8897, 63, 0, 2, 'Capela', '', 'capela', '', ''),
(8898, 63, 0, 2, 'Carneiros', '', 'carneiros', '', ''),
(8899, 63, 0, 2, 'Chã Preta', '', 'cha-preta', '', ''),
(8900, 63, 0, 2, 'Coité do Nóia', '', 'coite-do-noia', '', ''),
(8901, 63, 0, 2, 'Colônia Leopoldina', '', 'colonia-leopoldina', '', ''),
(8902, 63, 0, 2, 'Coqueiro Seco', '', 'coqueiro-seco', '', ''),
(8903, 63, 0, 2, 'Coruripe', '', 'coruripe', '', ''),
(8904, 63, 0, 2, 'Craíbas', '', 'craibas', '', ''),
(8905, 63, 0, 2, 'Delmiro Gouveia', '', 'delmiro-gouveia', '', ''),
(8906, 63, 0, 2, 'Dois Riachos', '', 'dois-riachos', '', ''),
(8907, 63, 0, 2, 'Estrela de Alagoas', '', 'estrela-de-alagoas', '', ''),
(8908, 63, 0, 2, 'Feira Grande', '', 'feira-grande', '', ''),
(8909, 63, 0, 2, 'Feliz Deserto', '', 'feliz-deserto', '', ''),
(8910, 63, 0, 2, 'Flexeiras', '', 'flexeiras', '', ''),
(8911, 63, 0, 2, 'Girau do Ponciano', '', 'girau-do-ponciano', '', ''),
(8912, 63, 0, 2, 'Ibateguara', '', 'ibateguara', '', ''),
(8913, 63, 0, 2, 'Igaci', '', 'igaci', '', ''),
(8914, 63, 0, 2, 'Igreja Nova', '', 'igreja-nova', '', ''),
(8915, 63, 0, 2, 'Inhapi', '', 'inhapi', '', ''),
(8916, 63, 0, 2, 'Jacaré dos Homens', '', 'jacare-dos-homens', '', ''),
(8917, 63, 0, 2, 'Jacuípe', '', 'jacuipe', '', ''),
(8918, 63, 0, 2, 'Japaratinga', '', 'japaratinga', '', ''),
(8919, 63, 0, 2, 'Jaramataia', '', 'jaramataia', '', ''),
(8920, 63, 0, 2, 'Joaquim Gomes', '', 'joaquim-gomes', '', ''),
(8921, 63, 0, 2, 'Jundiá', '', 'jundia', '', ''),
(8922, 63, 0, 2, 'Junqueiro', '', 'junqueiro', '', ''),
(8923, 63, 0, 2, 'Lagoa da Canoa', '', 'lagoa-da-canoa', '', ''),
(8924, 63, 0, 2, 'Limoeiro de Anadia', '', 'limoeiro-de-anadia', '', ''),
(8925, 63, 0, 2, 'Maceió', '', 'maceio', '', ''),
(8926, 63, 0, 2, 'Major Isidoro', '', 'major-isidoro', '', ''),
(8927, 63, 0, 2, 'Mar Vermelho', '', 'mar-vermelho', '', ''),
(8928, 63, 0, 2, 'Maragogi', '', 'maragogi', '', ''),
(8929, 63, 0, 2, 'Maravilha', '', 'maravilha', '', ''),
(8930, 63, 0, 2, 'Marechal Deodoro', '', 'marechal-deodoro', '', ''),
(8931, 63, 0, 2, 'Maribondo', '', 'maribondo', '', ''),
(8932, 63, 0, 2, 'Mata Grande', '', 'mata-grande', '', ''),
(8933, 63, 0, 2, 'Matriz de Camaragibe', '', 'matriz-de-camaragibe', '', ''),
(8934, 63, 0, 2, 'Messias', '', 'messias', '', ''),
(8935, 63, 0, 2, 'Minador do Negrão', '', 'minador-do-negrao', '', ''),
(8936, 63, 0, 2, 'Monteirópolis', '', 'monteiropolis', '', ''),
(8937, 63, 0, 2, 'Murici', '', 'murici', '', ''),
(8938, 63, 0, 2, 'Novo Lino', '', 'novo-lino', '', ''),
(8939, 63, 0, 2, 'Olho d`Água das Flores', '', 'olho-d`agua-das-flores', '', ''),
(8940, 63, 0, 2, 'Olho d`Água do Casado', '', 'olho-d`agua-do-casado', '', ''),
(8941, 63, 0, 2, 'Olho d`Água Grande', '', 'olho-d`agua-grande', '', ''),
(8942, 63, 0, 2, 'Olivença', '', 'olivenca', '', ''),
(8943, 63, 0, 2, 'Ouro Branco', '', 'ouro-branco', '', ''),
(8944, 63, 0, 2, 'Palestina', '', 'palestina', '', ''),
(8945, 63, 0, 2, 'Palmeira dos Índios', '', 'palmeira-dos-indios', '', ''),
(8946, 63, 0, 2, 'Pão de Açúcar', '', 'pao-de-acucar', '', ''),
(8947, 63, 0, 2, 'Pariconha', '', 'pariconha', '', ''),
(8948, 63, 0, 2, 'Paripueira', '', 'paripueira', '', ''),
(8949, 63, 0, 2, 'Passo de Camaragibe', '', 'passo-de-camaragibe', '', ''),
(8950, 63, 0, 2, 'Paulo Jacinto', '', 'paulo-jacinto', '', ''),
(8951, 63, 0, 2, 'Penedo', '', 'penedo', '', ''),
(8952, 63, 0, 2, 'Piaçabuçu', '', 'piacabucu', '', ''),
(8953, 63, 0, 2, 'Pilar', '', 'pilar', '', ''),
(8954, 63, 0, 2, 'Pindoba', '', 'pindoba', '', ''),
(8955, 63, 0, 2, 'Piranhas', '', 'piranhas', '', ''),
(8956, 63, 0, 2, 'Poço das Trincheiras', '', 'poco-das-trincheiras', '', ''),
(8957, 63, 0, 2, 'Porto Calvo', '', 'porto-calvo', '', ''),
(8958, 63, 0, 2, 'Porto de Pedras', '', 'porto-de-pedras', '', ''),
(8959, 63, 0, 2, 'Porto Real do Colégio', '', 'porto-real-do-colegio', '', ''),
(8960, 63, 0, 2, 'Quebrangulo', '', 'quebrangulo', '', ''),
(8961, 63, 0, 2, 'Rio Largo', '', 'rio-largo', '', ''),
(8962, 63, 0, 2, 'Roteiro', '', 'roteiro', '', ''),
(8963, 63, 0, 2, 'Santa Luzia do Norte', '', 'santa-luzia-do-norte', '', ''),
(8964, 63, 0, 2, 'Santana do Ipanema', '', 'santana-do-ipanema', '', ''),
(8965, 63, 0, 2, 'Santana do Mundaú', '', 'santana-do-mundau', '', ''),
(8966, 63, 0, 2, 'São Brás', '', 'sao-bras', '', ''),
(8967, 63, 0, 2, 'São José da Laje', '', 'sao-jose-da-laje', '', ''),
(8968, 63, 0, 2, 'São José da Tapera', '', 'sao-jose-da-tapera', '', ''),
(8969, 63, 0, 2, 'São Luís do Quitunde', '', 'sao-luis-do-quitunde', '', ''),
(8970, 63, 0, 2, 'São Miguel dos Campos', '', 'sao-miguel-dos-campos', '', ''),
(8971, 63, 0, 2, 'São Miguel dos Milagres', '', 'sao-miguel-dos-milagres', '', ''),
(8972, 63, 0, 2, 'São Sebastião', '', 'sao-sebastiao', '', ''),
(8973, 63, 0, 2, 'Satuba', '', 'satuba', '', ''),
(8974, 63, 0, 2, 'Senador Rui Palmeira', '', 'senador-rui-palmeira', '', ''),
(8975, 63, 0, 2, 'Tanque d`Arca', '', 'tanque-d`arca', '', ''),
(8976, 63, 0, 2, 'Taquarana', '', 'taquarana', '', ''),
(8977, 63, 0, 2, 'Teotônio Vilela', '', 'teotonio-vilela', '', ''),
(8978, 63, 0, 2, 'Traipu', '', 'traipu', '', ''),
(8979, 63, 0, 2, 'União dos Palmares', '', 'uniao-dos-palmares', '', ''),
(8980, 63, 0, 2, 'Viçosa', '', 'vicosa', '', ''),
(8981, 64, 0, 2, 'Amapá', '', 'amapa', '', ''),
(8982, 64, 0, 2, 'Calçoene', '', 'calcoene', '', ''),
(8983, 64, 0, 2, 'Cutias', '', 'cutias', '', ''),
(8984, 64, 0, 2, 'Ferreira Gomes', '', 'ferreira-gomes', '', ''),
(8985, 64, 0, 2, 'Itaubal', '', 'itaubal', '', ''),
(8986, 64, 0, 2, 'Laranjal do Jari', '', 'laranjal-do-jari', '', ''),
(8987, 64, 0, 2, 'Macapá', '', 'macapa', '', ''),
(8988, 64, 0, 2, 'Mazagão', '', 'mazagao', '', ''),
(8989, 64, 0, 2, 'Oiapoque', '', 'oiapoque', '', ''),
(8990, 64, 0, 2, 'Pedra Branca do Amaparí', '', 'pedra-branca-do-amapari', '', ''),
(8991, 64, 0, 2, 'Porto Grande', '', 'porto-grande', '', ''),
(8992, 64, 0, 2, 'Pracuúba', '', 'pracuuba', '', ''),
(8993, 64, 0, 2, 'Santana', '', 'santana', '', ''),
(8994, 64, 0, 2, 'Serra do Navio', '', 'serra-do-navio', '', ''),
(8995, 64, 0, 2, 'Tartarugalzinho', '', 'tartarugalzinho', '', ''),
(8996, 64, 0, 2, 'Vitória do Jari', '', 'vitoria-do-jari', '', ''),
(8997, 65, 0, 2, 'Alvarães', '', 'alvaraes', '', ''),
(8998, 65, 0, 2, 'Amaturá', '', 'amatura', '', ''),
(8999, 65, 0, 2, 'namã', '', 'nama', '', ''),
(9000, 65, 0, 2, 'Anori', '', 'anori', '', ''),
(9001, 65, 0, 2, 'Apuí', '', 'apui', '', ''),
(9002, 65, 0, 2, 'Atalaia do Norte', '', 'atalaia-do-norte', '', ''),
(9003, 65, 0, 2, 'Autazes', '', 'autazes', '', ''),
(9004, 65, 0, 2, 'Barcelos', '', 'barcelos', '', ''),
(9005, 65, 0, 2, 'Barreirinha', '', 'barreirinha', '', ''),
(9006, 65, 0, 2, 'Benjamin Constant', '', 'benjamin-constant', '', ''),
(9007, 65, 0, 2, 'Beruri', '', 'beruri', '', ''),
(9008, 65, 0, 2, 'Boa Vista do Ramos', '', 'boa-vista-do-ramos', '', ''),
(9009, 65, 0, 2, 'Boca do Acre', '', 'boca-do-acre', '', ''),
(9010, 65, 0, 2, 'Borba', '', 'borba', '', ''),
(9011, 65, 0, 2, 'Caapiranga', '', 'caapiranga', '', ''),
(9012, 65, 0, 2, 'Canutama', '', 'canutama', '', ''),
(9013, 65, 0, 2, 'Carauari', '', 'carauari', '', ''),
(9014, 65, 0, 2, 'Careiro', '', 'careiro', '', ''),
(9015, 65, 0, 2, 'Careiro da Várzea', '', 'careiro-da-varzea', '', ''),
(9016, 65, 0, 2, 'Coari', '', 'coari', '', ''),
(9017, 65, 0, 2, 'Codajás', '', 'codajas', '', ''),
(9018, 65, 0, 2, 'Eirunepé', '', 'eirunepe', '', ''),
(9019, 65, 0, 2, 'Envira', '', 'envira', '', ''),
(9020, 65, 0, 2, 'Fonte Boa', '', 'fonte-boa', '', ''),
(9021, 65, 0, 2, 'Guajará', '', 'guajara', '', ''),
(9022, 65, 0, 2, 'Humaitá', '', 'humaita', '', ''),
(9023, 65, 0, 2, 'Ipixuna', '', 'ipixuna', '', ''),
(9024, 65, 0, 2, 'Iranduba', '', 'iranduba', '', ''),
(9025, 65, 0, 2, 'Itacoatiara', '', 'itacoatiara', '', ''),
(9026, 65, 0, 2, 'Itamarati', '', 'itamarati', '', ''),
(9027, 65, 0, 2, 'Itapiranga', '', 'itapiranga', '', ''),
(9028, 65, 0, 2, 'Japurá', '', 'japura', '', ''),
(9029, 65, 0, 2, 'Juruá', '', 'jurua', '', ''),
(9030, 65, 0, 2, 'Jutaí', '', 'jutai', '', ''),
(9031, 65, 0, 2, 'Lábrea', '', 'labrea', '', ''),
(9032, 65, 0, 2, 'Manacapuru', '', 'manacapuru', '', ''),
(9033, 65, 0, 2, 'Manaquiri', '', 'manaquiri', '', ''),
(9034, 65, 0, 2, 'Manaus', '', 'manaus', '', ''),
(9035, 65, 0, 2, 'Manicoré', '', 'manicore', '', ''),
(9036, 65, 0, 2, 'Maraã', '', 'maraa', '', ''),
(9037, 65, 0, 2, 'Maués', '', 'maues', '', ''),
(9038, 65, 0, 2, 'Nhamundá', '', 'nhamunda', '', ''),
(9039, 65, 0, 2, 'Nova Olinda do Norte', '', 'nova-olinda-do-norte', '', ''),
(9040, 65, 0, 2, 'Novo Airão', '', 'novo-airao', '', ''),
(9041, 65, 0, 2, 'Novo Aripuanã', '', 'novo-aripuana', '', ''),
(9042, 65, 0, 2, 'Parintins', '', 'parintins', '', ''),
(9043, 65, 0, 2, 'Pauini', '', 'pauini', '', ''),
(9044, 65, 0, 2, 'Presidente Figueiredo', '', 'presidente-figueiredo', '', ''),
(9045, 65, 0, 2, 'Rio Preto da Eva', '', 'rio-preto-da-eva', '', ''),
(9046, 65, 0, 2, 'Santa Isabel do Rio Negro', '', 'santa-isabel-do-rio-negro', '', ''),
(9047, 65, 0, 2, 'Santo Antônio do Içá', '', 'santo-antonio-do-ica', '', ''),
(9048, 65, 0, 2, 'São Gabriel da Cachoeira', '', 'sao-gabriel-da-cachoeira', '', ''),
(9049, 65, 0, 2, 'São Paulo de Olivença', '', 'sao-paulo-de-olivenca', '', ''),
(9050, 65, 0, 2, 'São Sebastião do Uatumã', '', 'sao-sebastiao-do-uatuma', '', ''),
(9051, 65, 0, 2, 'Silves', '', 'silves', '', ''),
(9052, 65, 0, 2, 'Tabatinga', '', 'tabatinga', '', ''),
(9053, 65, 0, 2, 'Tapauá', '', 'tapaua', '', ''),
(9054, 65, 0, 2, 'Tefé', '', 'tefe', '', ''),
(9055, 65, 0, 2, 'Tonantins', '', 'tonantins', '', ''),
(9056, 65, 0, 2, 'Uarini', '', 'uarini', '', ''),
(9057, 65, 0, 2, 'Urucará', '', 'urucara', '', ''),
(9058, 65, 0, 2, 'Urucurituba', '', 'urucurituba', '', ''),
(9059, 66, 0, 2, 'Abaíra', '', 'abaira', '', ''),
(9060, 66, 0, 2, 'Abaré', '', 'abare', '', ''),
(9061, 66, 0, 2, 'Acajutiba', '', 'acajutiba', '', ''),
(9062, 66, 0, 2, 'Adustina', '', 'adustina', '', ''),
(9063, 66, 0, 2, 'Água Fria', '', 'agua-fria', '', ''),
(9064, 66, 0, 2, 'Aiquara', '', 'aiquara', '', ''),
(9065, 66, 0, 2, 'Alagoinhas', '', 'alagoinhas', '', ''),
(9066, 66, 0, 2, 'Alcobaça', '', 'alcobaca', '', ''),
(9067, 66, 0, 2, 'Almadina', '', 'almadina', '', ''),
(9068, 66, 0, 2, 'Amargosa', '', 'amargosa', '', ''),
(9069, 66, 0, 2, 'Amélia Rodrigues', '', 'amelia-rodrigues', '', ''),
(9070, 66, 0, 2, 'América Dourada', '', 'america-dourada', '', ''),
(9071, 66, 0, 2, 'Anagé', '', 'anage', '', ''),
(9072, 66, 0, 2, 'Andaraí', '', 'andarai', '', ''),
(9073, 66, 0, 2, 'Andorinha', '', 'andorinha', '', ''),
(9074, 66, 0, 2, 'Angical', '', 'angical', '', ''),
(9075, 66, 0, 2, 'Anguera', '', 'anguera', '', ''),
(9076, 66, 0, 2, 'Antas', '', 'antas', '', ''),
(9077, 66, 0, 2, 'Antônio Cardoso', '', 'antonio-cardoso', '', ''),
(9078, 66, 0, 2, 'Antônio Gonçalves', '', 'antonio-goncalves', '', ''),
(9079, 66, 0, 2, 'Aporá', '', 'apora', '', ''),
(9080, 66, 0, 2, 'Apuarema', '', 'apuarema', '', ''),
(9081, 66, 0, 2, 'Araças', '', 'aracas', '', ''),
(9082, 66, 0, 2, 'Aracatu', '', 'aracatu', '', ''),
(9083, 66, 0, 2, 'Araci', '', 'araci', '', ''),
(9084, 66, 0, 2, 'Aramari', '', 'aramari', '', ''),
(9085, 66, 0, 2, 'Arataca', '', 'arataca', '', ''),
(9086, 66, 0, 2, 'Aratuípe', '', 'aratuipe', '', ''),
(9087, 66, 0, 2, 'Aurelino Leal', '', 'aurelino-leal', '', ''),
(9088, 66, 0, 2, 'Baianópolis', '', 'baianopolis', '', ''),
(9089, 66, 0, 2, 'Baixa Grande', '', 'baixa-grande', '', ''),
(9090, 66, 0, 2, 'Banzaê', '', 'banzae', '', ''),
(9091, 66, 0, 2, 'Barra', '', 'barra', '', ''),
(9092, 66, 0, 2, 'Barra da Estiva', '', 'barra-da-estiva', '', ''),
(9093, 66, 0, 2, 'Barra do Choça', '', 'barra-do-choca', '', ''),
(9094, 66, 0, 2, 'Barra do Mendes', '', 'barra-do-mendes', '', ''),
(9095, 66, 0, 2, 'Barra do Rocha', '', 'barra-do-rocha', '', ''),
(9096, 66, 0, 2, 'Barreiras', '', 'barreiras', '', ''),
(9097, 66, 0, 2, 'Barro Alto', '', 'barro-alto', '', ''),
(9098, 66, 0, 2, 'Belmonte', '', 'belmonte', '', ''),
(9099, 66, 0, 2, 'Belo Campo', '', 'belo-campo', '', ''),
(9100, 66, 0, 2, 'Biritinga', '', 'biritinga', '', ''),
(9101, 66, 0, 2, 'Boa Nova', '', 'boa-nova', '', ''),
(9102, 66, 0, 2, 'Boa Vista do Tupim', '', 'boa-vista-do-tupim', '', ''),
(9103, 66, 0, 2, 'Bom Jesus da Lapa', '', 'bom-jesus-da-lapa', '', ''),
(9104, 66, 0, 2, 'Bom Jesus da Serra', '', 'bom-jesus-da-serra', '', ''),
(9105, 66, 0, 2, 'Boninal', '', 'boninal', '', ''),
(9106, 66, 0, 2, 'Bonito', '', 'bonito', '', ''),
(9107, 66, 0, 2, 'Boquira', '', 'boquira', '', ''),
(9108, 66, 0, 2, 'Botuporã', '', 'botupora', '', ''),
(9109, 66, 0, 2, 'Brejões', '', 'brejoes', '', ''),
(9110, 66, 0, 2, 'Brejolândia', '', 'brejolandia', '', ''),
(9111, 66, 0, 2, 'Brotas de Macaúbas', '', 'brotas-de-macaubas', '', ''),
(9112, 66, 0, 2, 'Brumado', '', 'brumado', '', ''),
(9113, 66, 0, 2, 'Buerarema', '', 'buerarema', '', ''),
(9114, 66, 0, 2, 'Buritirama', '', 'buritirama', '', ''),
(9115, 66, 0, 2, 'Caatiba', '', 'caatiba', '', ''),
(9116, 66, 0, 2, 'Cabaceiras do Paraguaçu', '', 'cabaceiras-do-paraguacu', '', ''),
(9117, 66, 0, 2, 'Cachoeira', '', 'cachoeira', '', ''),
(9118, 66, 0, 2, 'Caculé', '', 'cacule', '', ''),
(9119, 66, 0, 2, 'Caém', '', 'caem', '', ''),
(9120, 66, 0, 2, 'Caetanos', '', 'caetanos', '', ''),
(9121, 66, 0, 2, 'Caetité', '', 'caetite', '', ''),
(9122, 66, 0, 2, 'Cafarnaum', '', 'cafarnaum', '', ''),
(9123, 66, 0, 2, 'Cairu', '', 'cairu', '', ''),
(9124, 66, 0, 2, 'Caldeirão Grande', '', 'caldeirao-grande', '', ''),
(9125, 66, 0, 2, 'Camacan', '', 'camacan', '', ''),
(9126, 66, 0, 2, 'Camaçari', '', 'camacari', '', ''),
(9127, 66, 0, 2, 'Camamu', '', 'camamu', '', ''),
(9128, 66, 0, 2, 'Campo Alegre de Lourdes', '', 'campo-alegre-de-lourdes', '', ''),
(9129, 66, 0, 2, 'Campo Formoso', '', 'campo-formoso', '', ''),
(9130, 66, 0, 2, 'Canápolis', '', 'canapolis', '', ''),
(9131, 66, 0, 2, 'Canarana', '', 'canarana', '', ''),
(9132, 66, 0, 2, 'Canavieiras', '', 'canavieiras', '', ''),
(9133, 66, 0, 2, 'Candeal', '', 'candeal', '', ''),
(9134, 66, 0, 2, 'Candeias', '', 'candeias', '', ''),
(9135, 66, 0, 2, 'Candiba', '', 'candiba', '', ''),
(9136, 66, 0, 2, 'Cândido Sales', '', 'candido-sales', '', ''),
(9137, 66, 0, 2, 'Cansanção', '', 'cansancao', '', ''),
(9138, 66, 0, 2, 'Canudos', '', 'canudos', '', ''),
(9139, 66, 0, 2, 'Capela do Alto Alegre', '', 'capela-do-alto-alegre', '', ''),
(9140, 66, 0, 2, 'Capim Grosso', '', 'capim-grosso', '', ''),
(9141, 66, 0, 2, 'Caraíbas', '', 'caraibas', '', ''),
(9142, 66, 0, 2, 'Caravelas', '', 'caravelas', '', ''),
(9143, 66, 0, 2, 'Cardeal da Silva', '', 'cardeal-da-silva', '', ''),
(9144, 66, 0, 2, 'Carinhanha', '', 'carinhanha', '', ''),
(9145, 66, 0, 2, 'Casa Nova', '', 'casa-nova', '', ''),
(9146, 66, 0, 2, 'Castro Alves', '', 'castro-alves', '', ''),
(9147, 66, 0, 2, 'Catolândia', '', 'catolandia', '', ''),
(9148, 66, 0, 2, 'Catu', '', 'catu', '', ''),
(9149, 66, 0, 2, 'Caturama', '', 'caturama', '', ''),
(9150, 66, 0, 2, 'Central', '', 'central', '', ''),
(9151, 66, 0, 2, 'Chorrochó', '', 'chorrocho', '', ''),
(9152, 66, 0, 2, 'Cícero Dantas', '', 'cicero-dantas', '', ''),
(9153, 66, 0, 2, 'Cipó', '', 'cipo', '', ''),
(9154, 66, 0, 2, 'Coaraci', '', 'coaraci', '', ''),
(9155, 66, 0, 2, 'Cocos', '', 'cocos', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(9156, 66, 0, 2, 'Conceição da Feira', '', 'conceicao-da-feira', '', ''),
(9157, 66, 0, 2, 'Conceição do Almeida', '', 'conceicao-do-almeida', '', ''),
(9158, 66, 0, 2, 'Conceição do Coité', '', 'conceicao-do-coite', '', ''),
(9159, 66, 0, 2, 'Conceição do Jacuípe', '', 'conceicao-do-jacuipe', '', ''),
(9160, 66, 0, 2, 'Conde', '', 'conde', '', ''),
(9161, 66, 0, 2, 'Condeúba', '', 'condeuba', '', ''),
(9162, 66, 0, 2, 'Contendas do Sincorá', '', 'contendas-do-sincora', '', ''),
(9163, 66, 0, 2, 'Coração de Maria', '', 'coracao-de-maria', '', ''),
(9164, 66, 0, 2, 'Cordeiros', '', 'cordeiros', '', ''),
(9165, 66, 0, 2, 'Coribe', '', 'coribe', '', ''),
(9166, 66, 0, 2, 'Coronel João Sá', '', 'coronel-joao-sa', '', ''),
(9167, 66, 0, 2, 'Correntina', '', 'correntina', '', ''),
(9168, 66, 0, 2, 'Cotegipe', '', 'cotegipe', '', ''),
(9169, 66, 0, 2, 'Cravolândia', '', 'cravolandia', '', ''),
(9170, 66, 0, 2, 'Crisópolis', '', 'crisopolis', '', ''),
(9171, 66, 0, 2, 'Cristópolis', '', 'cristopolis', '', ''),
(9172, 66, 0, 2, 'Cruz das Almas', '', 'cruz-das-almas', '', ''),
(9173, 66, 0, 2, 'Curaçá', '', 'curaca', '', ''),
(9174, 66, 0, 2, 'Dário Meira', '', 'dario-meira', '', ''),
(9175, 66, 0, 2, 'Dias d`Ávila', '', 'dias-d`avila', '', ''),
(9176, 66, 0, 2, 'Dom Basílio', '', 'dom-basilio', '', ''),
(9177, 66, 0, 2, 'Dom Macedo Costa', '', 'dom-macedo-costa', '', ''),
(9178, 66, 0, 2, 'Elísio Medrado', '', 'elisio-medrado', '', ''),
(9179, 66, 0, 2, 'Encruzilhada', '', 'encruzilhada', '', ''),
(9180, 66, 0, 2, 'Entre Rios', '', 'entre-rios', '', ''),
(9181, 66, 0, 2, 'Érico Cardoso', '', 'erico-cardoso', '', ''),
(9182, 66, 0, 2, 'Esplanada', '', 'esplanada', '', ''),
(9183, 66, 0, 2, 'Euclides da Cunha', '', 'euclides-da-cunha', '', ''),
(9184, 66, 0, 2, 'Eunápolis', '', 'eunapolis', '', ''),
(9185, 66, 0, 2, 'Fátima', '', 'fatima', '', ''),
(9186, 66, 0, 2, 'Feira da Mata', '', 'feira-da-mata', '', ''),
(9187, 66, 0, 2, 'Feira de Santana', '', 'feira-de-santana', '', ''),
(9188, 66, 0, 2, 'Filadélfia', '', 'filadelfia', '', ''),
(9189, 66, 0, 2, 'Firmino Alves', '', 'firmino-alves', '', ''),
(9190, 66, 0, 2, 'Floresta Azul', '', 'floresta-azul', '', ''),
(9191, 66, 0, 2, 'Formosa do Rio Preto', '', 'formosa-do-rio-preto', '', ''),
(9192, 66, 0, 2, 'Gandu', '', 'gandu', '', ''),
(9193, 66, 0, 2, 'Gavião', '', 'gaviao', '', ''),
(9194, 66, 0, 2, 'Gentio do Ouro', '', 'gentio-do-ouro', '', ''),
(9195, 66, 0, 2, 'Glória', '', 'gloria', '', ''),
(9196, 66, 0, 2, 'Gongogi', '', 'gongogi', '', ''),
(9197, 66, 0, 2, 'Governador Lomanto Júnior', '', 'governador-lomanto-junior', '', ''),
(9198, 66, 0, 2, 'Governador Mangabeira', '', 'governador-mangabeira', '', ''),
(9199, 66, 0, 2, 'Guajeru', '', 'guajeru', '', ''),
(9200, 66, 0, 2, 'Guanambi', '', 'guanambi', '', ''),
(9201, 66, 0, 2, 'Guaratinga', '', 'guaratinga', '', ''),
(9202, 66, 0, 2, 'Heliópolis', '', 'heliopolis', '', ''),
(9203, 66, 0, 2, 'Iaçu', '', 'iacu', '', ''),
(9204, 66, 0, 2, 'Ibiassucê', '', 'ibiassuce', '', ''),
(9205, 66, 0, 2, 'Ibicaraí', '', 'ibicarai', '', ''),
(9206, 66, 0, 2, 'Ibicoara', '', 'ibicoara', '', ''),
(9207, 66, 0, 2, 'Ibicuí', '', 'ibicui', '', ''),
(9208, 66, 0, 2, 'Ibipeba', '', 'ibipeba', '', ''),
(9209, 66, 0, 2, 'Ibipitanga', '', 'ibipitanga', '', ''),
(9210, 66, 0, 2, 'Ibiquera', '', 'ibiquera', '', ''),
(9211, 66, 0, 2, 'Ibirapitanga', '', 'ibirapitanga', '', ''),
(9212, 66, 0, 2, 'Ibirapuã', '', 'ibirapua', '', ''),
(9213, 66, 0, 2, 'Ibirataia', '', 'ibirataia', '', ''),
(9214, 66, 0, 2, 'Ibitiara', '', 'ibitiara', '', ''),
(9215, 66, 0, 2, 'Ibititá', '', 'ibitita', '', ''),
(9216, 66, 0, 2, 'Ibotirama', '', 'ibotirama', '', ''),
(9217, 66, 0, 2, 'Ichu', '', 'ichu', '', ''),
(9218, 66, 0, 2, 'Igaporã', '', 'igapora', '', ''),
(9219, 66, 0, 2, 'Igrapiúna', '', 'igrapiuna', '', ''),
(9220, 66, 0, 2, 'Iguaí', '', 'iguai', '', ''),
(9221, 66, 0, 2, 'Ilhéus', '', 'ilheus', '', ''),
(9222, 66, 0, 2, 'Inhambupe', '', 'inhambupe', '', ''),
(9223, 66, 0, 2, 'Ipecaetá', '', 'ipecaeta', '', ''),
(9224, 66, 0, 2, 'Ipiaú', '', 'ipiau', '', ''),
(9225, 66, 0, 2, 'Ipirá', '', 'ipira', '', ''),
(9226, 66, 0, 2, 'Ipupiara', '', 'ipupiara', '', ''),
(9227, 66, 0, 2, 'Irajuba', '', 'irajuba', '', ''),
(9228, 66, 0, 2, 'Iramaia', '', 'iramaia', '', ''),
(9229, 66, 0, 2, 'Iraquara', '', 'iraquara', '', ''),
(9230, 66, 0, 2, 'Irará', '', 'irara', '', ''),
(9231, 66, 0, 2, 'Irecê', '', 'irece', '', ''),
(9232, 66, 0, 2, 'Itabela', '', 'itabela', '', ''),
(9233, 66, 0, 2, 'Itaberaba', '', 'itaberaba', '', ''),
(9234, 66, 0, 2, 'Itabuna', '', 'itabuna', '', ''),
(9235, 66, 0, 2, 'Itacaré', '', 'itacare', '', ''),
(9236, 66, 0, 2, 'Itaeté', '', 'itaete', '', ''),
(9237, 66, 0, 2, 'Itagi', '', 'itagi', '', ''),
(9238, 66, 0, 2, 'Itagibá', '', 'itagiba', '', ''),
(9239, 66, 0, 2, 'Itagimirim', '', 'itagimirim', '', ''),
(9240, 66, 0, 2, 'Itaguaçu da Bahia', '', 'itaguacu-da-bahia', '', ''),
(9241, 66, 0, 2, 'Itaju do Colônia', '', 'itaju-do-colonia', '', ''),
(9242, 66, 0, 2, 'Itajuípe', '', 'itajuipe', '', ''),
(9243, 66, 0, 2, 'Itamaraju', '', 'itamaraju', '', ''),
(9244, 66, 0, 2, 'Itamari', '', 'itamari', '', ''),
(9245, 66, 0, 2, 'Itambé', '', 'itambe', '', ''),
(9246, 66, 0, 2, 'Itanagra', '', 'itanagra', '', ''),
(9247, 66, 0, 2, 'Itanhém', '', 'itanhem', '', ''),
(9248, 66, 0, 2, 'Itaparica', '', 'itaparica', '', ''),
(9249, 66, 0, 2, 'Itapé', '', 'itape', '', ''),
(9250, 66, 0, 2, 'Itapebi', '', 'itapebi', '', ''),
(9251, 66, 0, 2, 'Itapetinga', '', 'itapetinga', '', ''),
(9252, 66, 0, 2, 'Itapicuru', '', 'itapicuru', '', ''),
(9253, 66, 0, 2, 'Itapitanga', '', 'itapitanga', '', ''),
(9254, 66, 0, 2, 'Itaquara', '', 'itaquara', '', ''),
(9255, 66, 0, 2, 'Itarantim', '', 'itarantim', '', ''),
(9256, 66, 0, 2, 'Itatim', '', 'itatim', '', ''),
(9257, 66, 0, 2, 'Itiruçu', '', 'itirucu', '', ''),
(9258, 66, 0, 2, 'Itiúba', '', 'itiuba', '', ''),
(9259, 66, 0, 2, 'Itororó', '', 'itororo', '', ''),
(9260, 66, 0, 2, 'Ituaçu', '', 'ituacu', '', ''),
(9261, 66, 0, 2, 'Ituberá', '', 'itubera', '', ''),
(9262, 66, 0, 2, 'Iuiú', '', 'iuiu', '', ''),
(9263, 66, 0, 2, 'Jaborandi', '', 'jaborandi', '', ''),
(9264, 66, 0, 2, 'Jacaraci', '', 'jacaraci', '', ''),
(9265, 66, 0, 2, 'Jacobina', '', 'jacobina', '', ''),
(9266, 66, 0, 2, 'Jaguaquara', '', 'jaguaquara', '', ''),
(9267, 66, 0, 2, 'Jaguarari', '', 'jaguarari', '', ''),
(9268, 66, 0, 2, 'Jaguaripe', '', 'jaguaripe', '', ''),
(9269, 66, 0, 2, 'Jandaíra', '', 'jandaira', '', ''),
(9270, 66, 0, 2, 'Jequié', '', 'jequie', '', ''),
(9271, 66, 0, 2, 'Jeremoabo', '', 'jeremoabo', '', ''),
(9272, 66, 0, 2, 'Jiquiriçá', '', 'jiquirica', '', ''),
(9273, 66, 0, 2, 'Jitaúna', '', 'jitauna', '', ''),
(9274, 66, 0, 2, 'João Dourado', '', 'joao-dourado', '', ''),
(9275, 66, 0, 2, 'Juazeiro', '', 'juazeiro', '', ''),
(9276, 66, 0, 2, 'Jucuruçu', '', 'jucurucu', '', ''),
(9277, 66, 0, 2, 'Jussara', '', 'jussara', '', ''),
(9278, 66, 0, 2, 'Jussari', '', 'jussari', '', ''),
(9279, 66, 0, 2, 'Jussiape', '', 'jussiape', '', ''),
(9280, 66, 0, 2, 'Lafaiete Coutinho', '', 'lafaiete-coutinho', '', ''),
(9281, 66, 0, 2, 'Lagoa Real', '', 'lagoa-real', '', ''),
(9282, 66, 0, 2, 'Laje', '', 'laje', '', ''),
(9283, 66, 0, 2, 'Lajedão', '', 'lajedao', '', ''),
(9284, 66, 0, 2, 'Lajedinho', '', 'lajedinho', '', ''),
(9285, 66, 0, 2, 'Lajedo do Tabocal', '', 'lajedo-do-tabocal', '', ''),
(9286, 66, 0, 2, 'Lamarão', '', 'lamarao', '', ''),
(9287, 66, 0, 2, 'Lapão', '', 'lapao', '', ''),
(9288, 66, 0, 2, 'Lauro de Freitas', '', 'lauro-de-freitas', '', ''),
(9289, 66, 0, 2, 'Lençóis', '', 'lencois', '', ''),
(9290, 66, 0, 2, 'Licínio de Almeida', '', 'licinio-de-almeida', '', ''),
(9291, 66, 0, 2, 'Livramento de Nossa Senhora', '', 'livramento-de-nossa-senhora', '', ''),
(9292, 66, 0, 2, 'Macajuba', '', 'macajuba', '', ''),
(9293, 66, 0, 2, 'Macarani', '', 'macarani', '', ''),
(9294, 66, 0, 2, 'Macaúbas', '', 'macaubas', '', ''),
(9295, 66, 0, 2, 'Macururé', '', 'macurure', '', ''),
(9296, 66, 0, 2, 'Madre de Deus', '', 'madre-de-deus', '', ''),
(9297, 66, 0, 2, 'Maetinga', '', 'maetinga', '', ''),
(9298, 66, 0, 2, 'Maiquinique', '', 'maiquinique', '', ''),
(9299, 66, 0, 2, 'Mairi', '', 'mairi', '', ''),
(9300, 66, 0, 2, 'Malhada', '', 'malhada', '', ''),
(9301, 66, 0, 2, 'Malhada de Pedras', '', 'malhada-de-pedras', '', ''),
(9302, 66, 0, 2, 'Manoel Vitorino', '', 'manoel-vitorino', '', ''),
(9303, 66, 0, 2, 'Mansidão', '', 'mansidao', '', ''),
(9304, 66, 0, 2, 'Maracás', '', 'maracas', '', ''),
(9305, 66, 0, 2, 'Maragogipe', '', 'maragogipe', '', ''),
(9306, 66, 0, 2, 'Maraú', '', 'marau', '', ''),
(9307, 66, 0, 2, 'Marcionílio Souza', '', 'marcionilio-souza', '', ''),
(9308, 66, 0, 2, 'Mascote', '', 'mascote', '', ''),
(9309, 66, 0, 2, 'Mata de São João', '', 'mata-de-sao-joao', '', ''),
(9310, 66, 0, 2, 'Matina', '', 'matina', '', ''),
(9311, 66, 0, 2, 'Medeiros Neto', '', 'medeiros-neto', '', ''),
(9312, 66, 0, 2, 'Miguel Calmon', '', 'miguel-calmon', '', ''),
(9313, 66, 0, 2, 'Milagres', '', 'milagres', '', ''),
(9314, 66, 0, 2, 'Mirangaba', '', 'mirangaba', '', ''),
(9315, 66, 0, 2, 'Mirante', '', 'mirante', '', ''),
(9316, 66, 0, 2, 'Monte Santo', '', 'monte-santo', '', ''),
(9317, 66, 0, 2, 'Morpará', '', 'morpara', '', ''),
(9318, 66, 0, 2, 'Morro do Chapéu', '', 'morro-do-chapeu', '', ''),
(9319, 66, 0, 2, 'Mortugaba', '', 'mortugaba', '', ''),
(9320, 66, 0, 2, 'Mucugê', '', 'mucuge', '', ''),
(9321, 66, 0, 2, 'Mucuri', '', 'mucuri', '', ''),
(9322, 66, 0, 2, 'Mulungu do Morro', '', 'mulungu-do-morro', '', ''),
(9323, 66, 0, 2, 'Mundo Novo', '', 'mundo-novo', '', ''),
(9324, 66, 0, 2, 'Muniz Ferreira', '', 'muniz-ferreira', '', ''),
(9325, 66, 0, 2, 'Muquém de São Francisco', '', 'muquem-de-sao-francisco', '', ''),
(9326, 66, 0, 2, 'Muritiba', '', 'muritiba', '', ''),
(9327, 66, 0, 2, 'Mutuípe', '', 'mutuipe', '', ''),
(9328, 66, 0, 2, 'Nazaré', '', 'nazare', '', ''),
(9329, 66, 0, 2, 'Nilo Peçanha', '', 'nilo-pecanha', '', ''),
(9330, 66, 0, 2, 'Nordestina', '', 'nordestina', '', ''),
(9331, 66, 0, 2, 'Nova Canaã', '', 'nova-canaa', '', ''),
(9332, 66, 0, 2, 'Nova Fátima', '', 'nova-fatima', '', ''),
(9333, 66, 0, 2, 'Nova Ibiá', '', 'nova-ibia', '', ''),
(9334, 66, 0, 2, 'Nova Itarana', '', 'nova-itarana', '', ''),
(9335, 66, 0, 2, 'Nova Redenção', '', 'nova-redencao', '', ''),
(9336, 66, 0, 2, 'Nova Soure', '', 'nova-soure', '', ''),
(9337, 66, 0, 2, 'Nova Viçosa', '', 'nova-vicosa', '', ''),
(9338, 66, 0, 2, 'Novo Horizonte', '', 'novo-horizonte', '', ''),
(9339, 66, 0, 2, 'Novo Triunfo', '', 'novo-triunfo', '', ''),
(9340, 66, 0, 2, 'Olindina', '', 'olindina', '', ''),
(9341, 66, 0, 2, 'Oliveira dos Brejinhos', '', 'oliveira-dos-brejinhos', '', ''),
(9342, 66, 0, 2, 'Ouriçangas', '', 'ouricangas', '', ''),
(9343, 66, 0, 2, 'Ourolândia', '', 'ourolandia', '', ''),
(9344, 66, 0, 2, 'Palmas de Monte Alto', '', 'palmas-de-monte-alto', '', ''),
(9345, 66, 0, 2, 'Palmeiras', '', 'palmeiras', '', ''),
(9346, 66, 0, 2, 'Paramirim', '', 'paramirim', '', ''),
(9347, 66, 0, 2, 'Paratinga', '', 'paratinga', '', ''),
(9348, 66, 0, 2, 'Paripiranga', '', 'paripiranga', '', ''),
(9349, 66, 0, 2, 'Pau Brasil', '', 'pau-brasil', '', ''),
(9350, 66, 0, 2, 'Paulo Afonso', '', 'paulo-afonso', '', ''),
(9351, 66, 0, 2, 'Pé de Serra', '', 'pe-de-serra', '', ''),
(9352, 66, 0, 2, 'Pedrão', '', 'pedrao', '', ''),
(9353, 66, 0, 2, 'Pedro Alexandre', '', 'pedro-alexandre', '', ''),
(9354, 66, 0, 2, 'Piatã', '', 'piata', '', ''),
(9355, 66, 0, 2, 'Pilão Arcado', '', 'pilao-arcado', '', ''),
(9356, 66, 0, 2, 'Pindaí', '', 'pindai', '', ''),
(9357, 66, 0, 2, 'Pindobaçu', '', 'pindobacu', '', ''),
(9358, 66, 0, 2, 'Pintadas', '', 'pintadas', '', ''),
(9359, 66, 0, 2, 'Piraí do Norte', '', 'pirai-do-norte', '', ''),
(9360, 66, 0, 2, 'Piripá', '', 'piripa', '', ''),
(9361, 66, 0, 2, 'Piritiba', '', 'piritiba', '', ''),
(9362, 66, 0, 2, 'Planaltino', '', 'planaltino', '', ''),
(9363, 66, 0, 2, 'Planalto', '', 'planalto', '', ''),
(9364, 66, 0, 2, 'Poções', '', 'pocoes', '', ''),
(9365, 66, 0, 2, 'Pojuca', '', 'pojuca', '', ''),
(9366, 66, 0, 2, 'Ponto Novo', '', 'ponto-novo', '', ''),
(9367, 66, 0, 2, 'Porto Seguro', '', 'porto-seguro', '', ''),
(9368, 66, 0, 2, 'Potiraguá', '', 'potiragua', '', ''),
(9369, 66, 0, 2, 'Prado', '', 'prado', '', ''),
(9370, 66, 0, 2, 'Presidente Dutra', '', 'presidente-dutra', '', ''),
(9371, 66, 0, 2, 'Presidente Jânio Quadros', '', 'presidente-janio-quadros', '', ''),
(9372, 66, 0, 2, 'Presidente Tancredo Neves', '', 'presidente-tancredo-neves', '', ''),
(9373, 66, 0, 2, 'Queimadas', '', 'queimadas', '', ''),
(9374, 66, 0, 2, 'Quijingue', '', 'quijingue', '', ''),
(9375, 66, 0, 2, 'Quixabeira', '', 'quixabeira', '', ''),
(9376, 66, 0, 2, 'Rafael Jambeiro', '', 'rafael-jambeiro', '', ''),
(9377, 66, 0, 2, 'Remanso', '', 'remanso', '', ''),
(9378, 66, 0, 2, 'Retirolândia', '', 'retirolandia', '', ''),
(9379, 66, 0, 2, 'Riachão das Neves', '', 'riachao-das-neves', '', ''),
(9380, 66, 0, 2, 'Riachão do Jacuípe', '', 'riachao-do-jacuipe', '', ''),
(9381, 66, 0, 2, 'Riacho de Santana', '', 'riacho-de-santana', '', ''),
(9382, 66, 0, 2, 'Ribeira do Amparo', '', 'ribeira-do-amparo', '', ''),
(9383, 66, 0, 2, 'Ribeira do Pombal', '', 'ribeira-do-pombal', '', ''),
(9384, 66, 0, 2, 'Ribeirão do Largo', '', 'ribeirao-do-largo', '', ''),
(9385, 66, 0, 2, 'Rio de Contas', '', 'rio-de-contas', '', ''),
(9386, 66, 0, 2, 'Rio do Antônio', '', 'rio-do-antonio', '', ''),
(9387, 66, 0, 2, 'Rio do Pires', '', 'rio-do-pires', '', ''),
(9388, 66, 0, 2, 'Rio Real', '', 'rio-real', '', ''),
(9389, 66, 0, 2, 'Rodelas', '', 'rodelas', '', ''),
(9390, 66, 0, 2, 'Ruy Barbosa', '', 'ruy-barbosa', '', ''),
(9391, 66, 0, 2, 'Salinas da Margarida', '', 'salinas-da-margarida', '', ''),
(9392, 66, 0, 2, 'Salvador', '', 'salvador', '', ''),
(9393, 66, 0, 2, 'Santa Bárbara', '', 'santa-barbara', '', ''),
(9394, 66, 0, 2, 'Santa Brígida', '', 'santa-brigida', '', ''),
(9395, 66, 0, 2, 'Santa Cruz Cabrália', '', 'santa-cruz-cabralia', '', ''),
(9396, 66, 0, 2, 'Santa Cruz da Vitória', '', 'santa-cruz-da-vitoria', '', ''),
(9397, 66, 0, 2, 'Santa Inês', '', 'santa-ines', '', ''),
(9398, 66, 0, 2, 'Santa Luzia', '', 'santa-luzia', '', ''),
(9399, 66, 0, 2, 'Santa Maria da Vitória', '', 'santa-maria-da-vitoria', '', ''),
(9400, 66, 0, 2, 'Santa Rita de Cássia', '', 'santa-rita-de-cassia', '', ''),
(9401, 66, 0, 2, 'Santa Teresinha', '', 'santa-teresinha', '', ''),
(9402, 66, 0, 2, 'Santaluz', '', 'santaluz', '', ''),
(9403, 66, 0, 2, 'Santana', '', 'santana', '', ''),
(9404, 66, 0, 2, 'Santanópolis', '', 'santanopolis', '', ''),
(9405, 66, 0, 2, 'Santo Amaro', '', 'santo-amaro', '', ''),
(9406, 66, 0, 2, 'Santo Antônio de Jesus', '', 'santo-antonio-de-jesus', '', ''),
(9407, 66, 0, 2, 'Santo Estêvão', '', 'santo-estevao', '', ''),
(9408, 66, 0, 2, 'São Desidério', '', 'sao-desiderio', '', ''),
(9409, 66, 0, 2, 'São Domingos', '', 'sao-domingos', '', ''),
(9410, 66, 0, 2, 'São Felipe', '', 'sao-felipe', '', ''),
(9411, 66, 0, 2, 'São Félix', '', 'sao-felix', '', ''),
(9412, 66, 0, 2, 'São Félix do Coribe', '', 'sao-felix-do-coribe', '', ''),
(9413, 66, 0, 2, 'São Francisco do Conde', '', 'sao-francisco-do-conde', '', ''),
(9414, 66, 0, 2, 'São Gabriel', '', 'sao-gabriel', '', ''),
(9415, 66, 0, 2, 'São Gonçalo dos Campos', '', 'sao-goncalo-dos-campos', '', ''),
(9416, 66, 0, 2, 'São José da Vitória', '', 'sao-jose-da-vitoria', '', ''),
(9417, 66, 0, 2, 'São José do Jacuípe', '', 'sao-jose-do-jacuipe', '', ''),
(9418, 66, 0, 2, 'São Miguel das Matas', '', 'sao-miguel-das-matas', '', ''),
(9419, 66, 0, 2, 'São Sebastião do Passé', '', 'sao-sebastiao-do-passe', '', ''),
(9420, 66, 0, 2, 'Sapeaçu', '', 'sapeacu', '', ''),
(9421, 66, 0, 2, 'Sátiro Dias', '', 'satiro-dias', '', ''),
(9422, 66, 0, 2, 'Saubara', '', 'saubara', '', ''),
(9423, 66, 0, 2, 'Saúde', '', 'saude', '', ''),
(9424, 66, 0, 2, 'Seabra', '', 'seabra', '', ''),
(9425, 66, 0, 2, 'Sebastião Laranjeiras', '', 'sebastiao-laranjeiras', '', ''),
(9426, 66, 0, 2, 'Senhor do Bonfim', '', 'senhor-do-bonfim', '', ''),
(9427, 66, 0, 2, 'Sento Sé', '', 'sento-se', '', ''),
(9428, 66, 0, 2, 'Serra do Ramalho', '', 'serra-do-ramalho', '', ''),
(9429, 66, 0, 2, 'Serra Dourada', '', 'serra-dourada', '', ''),
(9430, 66, 0, 2, 'Serra Preta', '', 'serra-preta', '', ''),
(9431, 66, 0, 2, 'Serrinha', '', 'serrinha', '', ''),
(9432, 66, 0, 2, 'Serrolândia', '', 'serrolandia', '', ''),
(9433, 66, 0, 2, 'Simões Filho', '', 'simoes-filho', '', ''),
(9434, 66, 0, 2, 'Sítio do Mato', '', 'sitio-do-mato', '', ''),
(9435, 66, 0, 2, 'Sítio do Quinto', '', 'sitio-do-quinto', '', ''),
(9436, 66, 0, 2, 'Sobradinho', '', 'sobradinho', '', ''),
(9437, 66, 0, 2, 'Souto Soares', '', 'souto-soares', '', ''),
(9438, 66, 0, 2, 'Tabocas do Brejo Velho', '', 'tabocas-do-brejo-velho', '', ''),
(9439, 66, 0, 2, 'Tanhaçu', '', 'tanhacu', '', ''),
(9440, 66, 0, 2, 'Tanque Novo', '', 'tanque-novo', '', ''),
(9441, 66, 0, 2, 'Tanquinho', '', 'tanquinho', '', ''),
(9442, 66, 0, 2, 'Taperoá', '', 'taperoa', '', ''),
(9443, 66, 0, 2, 'Tapiramutá', '', 'tapiramuta', '', ''),
(9444, 66, 0, 2, 'Teixeira de Freitas', '', 'teixeira-de-freitas', '', ''),
(9445, 66, 0, 2, 'Teodoro Sampaio', '', 'teodoro-sampaio', '', ''),
(9446, 66, 0, 2, 'Teofilândia', '', 'teofilandia', '', ''),
(9447, 66, 0, 2, 'Teolândia', '', 'teolandia', '', ''),
(9448, 66, 0, 2, 'Terra Nova', '', 'terra-nova', '', ''),
(9449, 66, 0, 2, 'Tremedal', '', 'tremedal', '', ''),
(9450, 66, 0, 2, 'Tucano', '', 'tucano', '', ''),
(9451, 66, 0, 2, 'Uauá', '', 'uaua', '', ''),
(9452, 66, 0, 2, 'Ubaíra', '', 'ubaira', '', ''),
(9453, 66, 0, 2, 'Ubaitaba', '', 'ubaitaba', '', ''),
(9454, 66, 0, 2, 'Ubatã', '', 'ubata', '', ''),
(9455, 66, 0, 2, 'Uibaí', '', 'uibai', '', ''),
(9456, 66, 0, 2, 'Umburanas', '', 'umburanas', '', ''),
(9457, 66, 0, 2, 'Una', '', 'una', '', ''),
(9458, 66, 0, 2, 'Urandi', '', 'urandi', '', ''),
(9459, 66, 0, 2, 'Uruçuca', '', 'urucuca', '', ''),
(9460, 66, 0, 2, 'Utinga', '', 'utinga', '', ''),
(9461, 66, 0, 2, 'Valença', '', 'valenca', '', ''),
(9462, 66, 0, 2, 'Valente', '', 'valente', '', ''),
(9463, 66, 0, 2, 'Várzea da Roça', '', 'varzea-da-roca', '', ''),
(9464, 66, 0, 2, 'Várzea do Poço', '', 'varzea-do-poco', '', ''),
(9465, 66, 0, 2, 'Várzea Nova', '', 'varzea-nova', '', ''),
(9466, 66, 0, 2, 'Varzedo', '', 'varzedo', '', ''),
(9467, 66, 0, 2, 'Vera Cruz', '', 'vera-cruz', '', ''),
(9468, 66, 0, 2, 'Vereda', '', 'vereda', '', ''),
(9469, 66, 0, 2, 'Vitória da Conquista', '', 'vitoria-da-conquista', '', ''),
(9470, 66, 0, 2, 'Wagner', '', 'wagner', '', ''),
(9471, 66, 0, 2, 'Wanderley', '', 'wanderley', '', ''),
(9472, 66, 0, 2, 'Wenceslau Guimarães', '', 'wenceslau-guimaraes', '', ''),
(9473, 66, 0, 2, 'Xique-Xique', '', 'xique-xique', '', ''),
(9474, 67, 0, 2, 'Abaiara', '', 'abaiara', '', ''),
(9475, 67, 0, 2, 'Acarapé', '', 'acarape', '', ''),
(9476, 67, 0, 2, 'Acaraú', '', 'acarau', '', ''),
(9477, 67, 0, 2, 'Acopiara', '', 'acopiara', '', ''),
(9478, 67, 0, 2, 'Aiuaba', '', 'aiuaba', '', ''),
(9479, 67, 0, 2, 'Alcântaras', '', 'alcantaras', '', ''),
(9480, 67, 0, 2, 'Altaneira', '', 'altaneira', '', ''),
(9481, 67, 0, 2, 'Alto Santo', '', 'alto-santo', '', ''),
(9482, 67, 0, 2, 'Amontada', '', 'amontada', '', ''),
(9483, 67, 0, 2, 'Antonina do Norte', '', 'antonina-do-norte', '', ''),
(9484, 67, 0, 2, 'Apuiarés', '', 'apuiares', '', ''),
(9485, 67, 0, 2, 'Aquiraz', '', 'aquiraz', '', ''),
(9486, 67, 0, 2, 'Aracati', '', 'aracati', '', ''),
(9487, 67, 0, 2, 'Aracoiaba', '', 'aracoiaba', '', ''),
(9488, 67, 0, 2, 'Ararendá', '', 'ararenda', '', ''),
(9489, 67, 0, 2, 'Araripe', '', 'araripe', '', ''),
(9490, 67, 0, 2, 'Aratuba', '', 'aratuba', '', ''),
(9491, 67, 0, 2, 'Arneiroz', '', 'arneiroz', '', ''),
(9492, 67, 0, 2, 'Assaré', '', 'assare', '', ''),
(9493, 67, 0, 2, 'Aurora', '', 'aurora', '', ''),
(9494, 67, 0, 2, 'Baixio', '', 'baixio', '', ''),
(9495, 67, 0, 2, 'Banabuiú', '', 'banabuiu', '', ''),
(9496, 67, 0, 2, 'Barbalha', '', 'barbalha', '', ''),
(9497, 67, 0, 2, 'Barreira', '', 'barreira', '', ''),
(9498, 67, 0, 2, 'Barro', '', 'barro', '', ''),
(9499, 67, 0, 2, 'Barroquinha', '', 'barroquinha', '', ''),
(9500, 67, 0, 2, 'Baturité', '', 'baturite', '', ''),
(9501, 67, 0, 2, 'Beberibe', '', 'beberibe', '', ''),
(9502, 67, 0, 2, 'Bela Cruz', '', 'bela-cruz', '', ''),
(9503, 67, 0, 2, 'Boa Viagem', '', 'boa-viagem', '', ''),
(9504, 67, 0, 2, 'Brejo Santo', '', 'brejo-santo', '', ''),
(9505, 67, 0, 2, 'Camocim', '', 'camocim', '', ''),
(9506, 67, 0, 2, 'Campos Sales', '', 'campos-sales', '', ''),
(9507, 67, 0, 2, 'Canindé', '', 'caninde', '', ''),
(9508, 67, 0, 2, 'Capistrano', '', 'capistrano', '', ''),
(9509, 67, 0, 2, 'Caridade', '', 'caridade', '', ''),
(9510, 67, 0, 2, 'Cariré', '', 'carire', '', ''),
(9511, 67, 0, 2, 'Caririaçu', '', 'caririacu', '', ''),
(9512, 67, 0, 2, 'Cariús', '', 'carius', '', ''),
(9513, 67, 0, 2, 'Carnaubal', '', 'carnaubal', '', ''),
(9514, 67, 0, 2, 'Cascavel', '', 'cascavel', '', ''),
(9515, 67, 0, 2, 'Catarina', '', 'catarina', '', ''),
(9516, 67, 0, 2, 'Catunda', '', 'catunda', '', ''),
(9517, 67, 0, 2, 'Caucaia', '', 'caucaia', '', ''),
(9518, 67, 0, 2, 'Cedro', '', 'cedro', '', ''),
(9519, 67, 0, 2, 'Chaval', '', 'chaval', '', ''),
(9520, 67, 0, 2, 'Choró', '', 'choro', '', ''),
(9521, 67, 0, 2, 'Chorozinho', '', 'chorozinho', '', ''),
(9522, 67, 0, 2, 'Coreaú', '', 'coreau', '', ''),
(9523, 67, 0, 2, 'Crateús', '', 'crateus', '', ''),
(9524, 67, 0, 2, 'Crato', '', 'crato', '', ''),
(9525, 67, 0, 2, 'Croatá', '', 'croata', '', ''),
(9526, 67, 0, 2, 'Cruz', '', 'cruz', '', ''),
(9527, 67, 0, 2, 'Deputado Irapuan Pinheiro', '', 'deputado-irapuan-pinheiro', '', ''),
(9528, 67, 0, 2, 'Ererê', '', 'erere', '', ''),
(9529, 67, 0, 2, 'Eusébio', '', 'eusebio', '', ''),
(9530, 67, 0, 2, 'Farias Brito', '', 'farias-brito', '', ''),
(9531, 67, 0, 2, 'Forquilha', '', 'forquilha', '', ''),
(9532, 67, 0, 2, 'Fortaleza', '', 'fortaleza', '', ''),
(9533, 67, 0, 2, 'Fortim', '', 'fortim', '', ''),
(9534, 67, 0, 2, 'Frecheirinha', '', 'frecheirinha', '', ''),
(9535, 67, 0, 2, 'General Sampaio', '', 'general-sampaio', '', ''),
(9536, 67, 0, 2, 'Graça', '', 'graca', '', ''),
(9537, 67, 0, 2, 'Granja', '', 'granja', '', ''),
(9538, 67, 0, 2, 'Granjeiro', '', 'granjeiro', '', ''),
(9539, 67, 0, 2, 'Groaíras', '', 'groairas', '', ''),
(9540, 67, 0, 2, 'Guaiúba', '', 'guaiuba', '', ''),
(9541, 67, 0, 2, 'Guaraciaba do Norte', '', 'guaraciaba-do-norte', '', ''),
(9542, 67, 0, 2, 'Guaramiranga', '', 'guaramiranga', '', ''),
(9543, 67, 0, 2, 'Hidrolândia', '', 'hidrolandia', '', ''),
(9544, 67, 0, 2, 'Horizonte', '', 'horizonte', '', ''),
(9545, 67, 0, 2, 'Ibaretama', '', 'ibaretama', '', ''),
(9546, 67, 0, 2, 'Ibiapina', '', 'ibiapina', '', ''),
(9547, 67, 0, 2, 'Ibicuitinga', '', 'ibicuitinga', '', ''),
(9548, 67, 0, 2, 'Icapuí', '', 'icapui', '', ''),
(9549, 67, 0, 2, 'Icó', '', 'ico', '', ''),
(9550, 67, 0, 2, 'Iguatu', '', 'iguatu', '', ''),
(9551, 67, 0, 2, 'Independência', '', 'independencia', '', ''),
(9552, 67, 0, 2, 'Ipaporanga', '', 'ipaporanga', '', ''),
(9553, 67, 0, 2, 'Ipaumirim', '', 'ipaumirim', '', ''),
(9554, 67, 0, 2, 'Ipu', '', 'ipu', '', ''),
(9555, 67, 0, 2, 'Ipueiras', '', 'ipueiras', '', ''),
(9556, 67, 0, 2, 'Iracema', '', 'iracema', '', ''),
(9557, 67, 0, 2, 'Irauçuba', '', 'iraucuba', '', ''),
(9558, 67, 0, 2, 'Itaiçaba', '', 'itaicaba', '', ''),
(9559, 67, 0, 2, 'Itaitinga', '', 'itaitinga', '', ''),
(9560, 67, 0, 2, 'Itapagé', '', 'itapage', '', ''),
(9561, 67, 0, 2, 'Itapipoca', '', 'itapipoca', '', ''),
(9562, 67, 0, 2, 'Itapiúna', '', 'itapiuna', '', ''),
(9563, 67, 0, 2, 'Itarema', '', 'itarema', '', ''),
(9564, 67, 0, 2, 'Itatira', '', 'itatira', '', ''),
(9565, 67, 0, 2, 'Jaguaretama', '', 'jaguaretama', '', ''),
(9566, 67, 0, 2, 'Jaguaribara', '', 'jaguaribara', '', ''),
(9567, 67, 0, 2, 'Jaguaribe', '', 'jaguaribe', '', ''),
(9568, 67, 0, 2, 'Jaguaruana', '', 'jaguaruana', '', ''),
(9569, 67, 0, 2, 'Jardim', '', 'jardim', '', ''),
(9570, 67, 0, 2, 'Jati', '', 'jati', '', ''),
(9571, 67, 0, 2, 'Jijoca de Jericoacoara', '', 'jijoca-de-jericoacoara', '', ''),
(9572, 67, 0, 2, 'Juazeiro do Norte', '', 'juazeiro-do-norte', '', ''),
(9573, 67, 0, 2, 'Jucás', '', 'jucas', '', ''),
(9574, 67, 0, 2, 'Lavras da Mangabeira', '', 'lavras-da-mangabeira', '', ''),
(9575, 67, 0, 2, 'Limoeiro do Norte', '', 'limoeiro-do-norte', '', ''),
(9576, 67, 0, 2, 'Madalena', '', 'madalena', '', ''),
(9577, 67, 0, 2, 'Maracanaú', '', 'maracanau', '', ''),
(9578, 67, 0, 2, 'Maranguape', '', 'maranguape', '', ''),
(9579, 67, 0, 2, 'Marco', '', 'marco', '', ''),
(9580, 67, 0, 2, 'Martinópole', '', 'martinopole', '', ''),
(9581, 67, 0, 2, 'Massapê', '', 'massape', '', ''),
(9582, 67, 0, 2, 'Mauriti', '', 'mauriti', '', ''),
(9583, 67, 0, 2, 'Meruoca', '', 'meruoca', '', ''),
(9584, 67, 0, 2, 'Milagres', '', 'milagres', '', ''),
(9585, 67, 0, 2, 'Milhã', '', 'milha', '', ''),
(9586, 67, 0, 2, 'Miraíma', '', 'miraima', '', ''),
(9587, 67, 0, 2, 'Missão Velha', '', 'missao-velha', '', ''),
(9588, 67, 0, 2, 'Mombaça', '', 'mombaca', '', ''),
(9589, 67, 0, 2, 'Monsenhor Tabosa', '', 'monsenhor-tabosa', '', ''),
(9590, 67, 0, 2, 'Morada Nova', '', 'morada-nova', '', ''),
(9591, 67, 0, 2, 'Moraújo', '', 'moraujo', '', ''),
(9592, 67, 0, 2, 'Morrinhos', '', 'morrinhos', '', ''),
(9593, 67, 0, 2, 'Mucambo', '', 'mucambo', '', ''),
(9594, 67, 0, 2, 'Mulungu', '', 'mulungu', '', ''),
(9595, 67, 0, 2, 'Nova Olinda', '', 'nova-olinda', '', ''),
(9596, 67, 0, 2, 'Nova Russas', '', 'nova-russas', '', ''),
(9597, 67, 0, 2, 'Novo Oriente', '', 'novo-oriente', '', ''),
(9598, 67, 0, 2, 'Ocara', '', 'ocara', '', ''),
(9599, 67, 0, 2, 'Orós', '', 'oros', '', ''),
(9600, 67, 0, 2, 'Pacajus', '', 'pacajus', '', ''),
(9601, 67, 0, 2, 'Pacatuba', '', 'pacatuba', '', ''),
(9602, 67, 0, 2, 'Pacoti', '', 'pacoti', '', ''),
(9603, 67, 0, 2, 'Pacujá', '', 'pacuja', '', ''),
(9604, 67, 0, 2, 'Palhano', '', 'palhano', '', ''),
(9605, 67, 0, 2, 'Palmácia', '', 'palmacia', '', ''),
(9606, 67, 0, 2, 'Paracuru', '', 'paracuru', '', ''),
(9607, 67, 0, 2, 'Paraipaba', '', 'paraipaba', '', ''),
(9608, 67, 0, 2, 'Parambu', '', 'parambu', '', ''),
(9609, 67, 0, 2, 'Paramoti', '', 'paramoti', '', ''),
(9610, 67, 0, 2, 'Pedra Branca', '', 'pedra-branca', '', ''),
(9611, 67, 0, 2, 'Penaforte', '', 'penaforte', '', ''),
(9612, 67, 0, 2, 'Pentecoste', '', 'pentecoste', '', ''),
(9613, 67, 0, 2, 'Pereiro', '', 'pereiro', '', ''),
(9614, 67, 0, 2, 'Pindoretama', '', 'pindoretama', '', ''),
(9615, 67, 0, 2, 'Piquet Carneiro', '', 'piquet-carneiro', '', ''),
(9616, 67, 0, 2, 'Pires Ferreira', '', 'pires-ferreira', '', ''),
(9617, 67, 0, 2, 'Poranga', '', 'poranga', '', ''),
(9618, 67, 0, 2, 'Porteiras', '', 'porteiras', '', ''),
(9619, 67, 0, 2, 'Potengi', '', 'potengi', '', ''),
(9620, 67, 0, 2, 'Potiretama', '', 'potiretama', '', ''),
(9621, 67, 0, 2, 'Quiterianópolis', '', 'quiterianopolis', '', ''),
(9622, 67, 0, 2, 'Quixadá', '', 'quixada', '', ''),
(9623, 67, 0, 2, 'Quixelô', '', 'quixelo', '', ''),
(9624, 67, 0, 2, 'Quixeramobim', '', 'quixeramobim', '', ''),
(9625, 67, 0, 2, 'Quixeré', '', 'quixere', '', ''),
(9626, 67, 0, 2, 'Redenção', '', 'redencao', '', ''),
(9627, 67, 0, 2, 'Reriutaba', '', 'reriutaba', '', ''),
(9628, 67, 0, 2, 'Russas', '', 'russas', '', ''),
(9629, 67, 0, 2, 'Saboeiro', '', 'saboeiro', '', ''),
(9630, 67, 0, 2, 'Salitre', '', 'salitre', '', ''),
(9631, 67, 0, 2, 'Santa Quitéria', '', 'santa-quiteria', '', ''),
(9632, 67, 0, 2, 'Santana do Acaraú', '', 'santana-do-acarau', '', ''),
(9633, 67, 0, 2, 'Santana do Cariri', '', 'santana-do-cariri', '', ''),
(9634, 67, 0, 2, 'São Benedito', '', 'sao-benedito', '', ''),
(9635, 67, 0, 2, 'São Gonçalo do Amarante', '', 'sao-goncalo-do-amarante', '', ''),
(9636, 67, 0, 2, 'São João do Jaguaribe', '', 'sao-joao-do-jaguaribe', '', ''),
(9637, 67, 0, 2, 'São Luís do Curu', '', 'sao-luis-do-curu', '', ''),
(9638, 67, 0, 2, 'Senador Pompeu', '', 'senador-pompeu', '', ''),
(9639, 67, 0, 2, 'Senador Sá', '', 'senador-sa', '', ''),
(9640, 67, 0, 2, 'Sobral', '', 'sobral', '', ''),
(9641, 67, 0, 2, 'Solonópole', '', 'solonopole', '', ''),
(9642, 67, 0, 2, 'Tabuleiro do Norte', '', 'tabuleiro-do-norte', '', ''),
(9643, 67, 0, 2, 'Tamboril', '', 'tamboril', '', ''),
(9644, 67, 0, 2, 'Tarrafas', '', 'tarrafas', '', ''),
(9645, 67, 0, 2, 'Tauá', '', 'taua', '', ''),
(9646, 67, 0, 2, 'Tejuçuoca', '', 'tejucuoca', '', ''),
(9647, 67, 0, 2, 'Tianguá', '', 'tiangua', '', ''),
(9648, 67, 0, 2, 'Trairi', '', 'trairi', '', ''),
(9649, 67, 0, 2, 'Tururu', '', 'tururu', '', ''),
(9650, 67, 0, 2, 'Ubajara', '', 'ubajara', '', ''),
(9651, 67, 0, 2, 'Umari', '', 'umari', '', ''),
(9652, 67, 0, 2, 'Umirim', '', 'umirim', '', ''),
(9653, 67, 0, 2, 'Uruburetama', '', 'uruburetama', '', ''),
(9654, 67, 0, 2, 'Uruoca', '', 'uruoca', '', ''),
(9655, 67, 0, 2, 'Varjota', '', 'varjota', '', ''),
(9656, 67, 0, 2, 'Várzea Alegre', '', 'varzea-alegre', '', ''),
(9657, 67, 0, 2, 'Viçosa do Ceará', '', 'vicosa-do-ceara', '', ''),
(9658, 68, 0, 2, 'Brasília', '', 'brasilia', '', ''),
(9659, 68, 0, 2, 'Taguatinga', '', 'taguatinga', '', ''),
(9660, 69, 0, 2, 'Afonso Cláudio', '', 'afonso-claudio', '', ''),
(9661, 69, 0, 2, 'Água Doce do Norte', '', 'agua-doce-do-norte', '', ''),
(9662, 69, 0, 2, 'Águia Branca', '', 'aguia-branca', '', ''),
(9663, 69, 0, 2, 'Alegre', '', 'alegre', '', ''),
(9664, 69, 0, 2, 'Alfredo Chaves', '', 'alfredo-chaves', '', ''),
(9665, 69, 0, 2, 'Alto Rio Novo', '', 'alto-rio-novo', '', ''),
(9666, 69, 0, 2, 'Anchieta', '', 'anchieta', '', ''),
(9667, 69, 0, 2, 'Apiacá', '', 'apiaca', '', ''),
(9668, 69, 0, 2, 'Aracruz', '', 'aracruz', '', ''),
(9669, 69, 0, 2, 'Atilio Vivacqua', '', 'atilio-vivacqua', '', ''),
(9670, 69, 0, 2, 'Baixo Guandu', '', 'baixo-guandu', '', ''),
(9671, 69, 0, 2, 'Barra de São Francisco', '', 'barra-de-sao-francisco', '', ''),
(9672, 69, 0, 2, 'Boa Esperança', '', 'boa-esperanca', '', ''),
(9673, 69, 0, 2, 'Bom Jesus do Norte', '', 'bom-jesus-do-norte', '', ''),
(9674, 69, 0, 2, 'Brejetuba', '', 'brejetuba', '', ''),
(9675, 69, 0, 2, 'Cachoeiro de Itapemirim', '', 'cachoeiro-de-itapemirim', '', ''),
(9676, 69, 0, 2, 'Cariacica', '', 'cariacica', '', ''),
(9677, 69, 0, 2, 'Castelo', '', 'castelo', '', ''),
(9678, 69, 0, 2, 'Colatina', '', 'colatina', '', ''),
(9679, 69, 0, 2, 'Conceição da Barra', '', 'conceicao-da-barra', '', ''),
(9680, 69, 0, 2, 'Conceição do Castelo', '', 'conceicao-do-castelo', '', ''),
(9681, 69, 0, 2, 'Divino de São Lourenço', '', 'divino-de-sao-lourenco', '', ''),
(9682, 69, 0, 2, 'Domingos Martins', '', 'domingos-martins', '', ''),
(9683, 69, 0, 2, 'Dores do Rio Preto', '', 'dores-do-rio-preto', '', ''),
(9684, 69, 0, 2, 'Ecoporanga', '', 'ecoporanga', '', ''),
(9685, 69, 0, 2, 'Fundão', '', 'fundao', '', ''),
(9686, 69, 0, 2, 'Guaçuí', '', 'guacui', '', ''),
(9687, 69, 0, 2, 'Guarapari', '', 'guarapari', '', ''),
(9688, 69, 0, 2, 'Ibatiba', '', 'ibatiba', '', ''),
(9689, 69, 0, 2, 'Ibiraçu', '', 'ibiracu', '', ''),
(9690, 69, 0, 2, 'Ibitirama', '', 'ibitirama', '', ''),
(9691, 69, 0, 2, 'Iconha', '', 'iconha', '', ''),
(9692, 69, 0, 2, 'Irupi', '', 'irupi', '', ''),
(9693, 69, 0, 2, 'Itaguaçu', '', 'itaguacu', '', ''),
(9694, 69, 0, 2, 'Itapemirim', '', 'itapemirim', '', ''),
(9695, 69, 0, 2, 'Itarana', '', 'itarana', '', ''),
(9696, 69, 0, 2, 'Iúna', '', 'iuna', '', ''),
(9697, 69, 0, 2, 'Jaguaré', '', 'jaguare', '', ''),
(9698, 69, 0, 2, 'Jerônimo Monteiro', '', 'jeronimo-monteiro', '', ''),
(9699, 69, 0, 2, 'João Neiva', '', 'joao-neiva', '', ''),
(9700, 69, 0, 2, 'Laranja da Terra', '', 'laranja-da-terra', '', ''),
(9701, 69, 0, 2, 'Linhares', '', 'linhares', '', ''),
(9702, 69, 0, 2, 'Mantenópolis', '', 'mantenopolis', '', ''),
(9703, 69, 0, 2, 'Marataízes', '', 'marataizes', '', ''),
(9704, 69, 0, 2, 'Marechal Floriano', '', 'marechal-floriano', '', ''),
(9705, 69, 0, 2, 'Marilândia', '', 'marilandia', '', ''),
(9706, 69, 0, 2, 'Mimoso do Sul', '', 'mimoso-do-sul', '', ''),
(9707, 69, 0, 2, 'Montanha', '', 'montanha', '', ''),
(9708, 69, 0, 2, 'Mucurici', '', 'mucurici', '', ''),
(9709, 69, 0, 2, 'Muniz Freire', '', 'muniz-freire', '', ''),
(9710, 69, 0, 2, 'Muqui', '', 'muqui', '', ''),
(9711, 69, 0, 2, 'Nova Venécia', '', 'nova-venecia', '', ''),
(9712, 69, 0, 2, 'Pancas', '', 'pancas', '', ''),
(9713, 69, 0, 2, 'Pedro Canário', '', 'pedro-canario', '', ''),
(9714, 69, 0, 2, 'Pinheiros', '', 'pinheiros', '', ''),
(9715, 69, 0, 2, 'Piúma', '', 'piuma', '', ''),
(9716, 69, 0, 2, 'Ponto Belo', '', 'ponto-belo', '', ''),
(9717, 69, 0, 2, 'Presidente Kennedy', '', 'presidente-kennedy', '', ''),
(9718, 69, 0, 2, 'Rio Bananal', '', 'rio-bananal', '', ''),
(9719, 69, 0, 2, 'Rio Novo do Sul', '', 'rio-novo-do-sul', '', ''),
(9720, 69, 0, 2, 'Santa Leopoldina', '', 'santa-leopoldina', '', ''),
(9721, 69, 0, 2, 'Santa Maria de Jetibá', '', 'santa-maria-de-jetiba', '', ''),
(9722, 69, 0, 2, 'Santa Teresa', '', 'santa-teresa', '', ''),
(9723, 69, 0, 2, 'São Domingos do Norte', '', 'sao-domingos-do-norte', '', ''),
(9724, 69, 0, 2, 'São Gabriel da Palha', '', 'sao-gabriel-da-palha', '', ''),
(9725, 69, 0, 2, 'São José do Calçado', '', 'sao-jose-do-calcado', '', ''),
(9726, 69, 0, 2, 'São Mateus', '', 'sao-mateus', '', ''),
(9727, 69, 0, 2, 'São Roque do Canaã', '', 'sao-roque-do-canaa', '', ''),
(9728, 69, 0, 2, 'Serra', '', 'serra', '', ''),
(9729, 69, 0, 2, 'Sooretama', '', 'sooretama', '', ''),
(9730, 69, 0, 2, 'Vargem Alta', '', 'vargem-alta', '', ''),
(9731, 69, 0, 2, 'Venda Nova do Imigrante', '', 'venda-nova-do-imigrante', '', ''),
(9732, 69, 0, 2, 'Viana', '', 'viana', '', ''),
(9733, 69, 0, 2, 'Vila Pavão', '', 'vila-pavao', '', ''),
(9734, 69, 0, 2, 'Vila Valério', '', 'vila-valerio', '', ''),
(9735, 69, 0, 2, 'Vila Velha', '', 'vila-velha', '', ''),
(9736, 69, 0, 2, 'Vitória', '', 'vitoria', '', ''),
(9737, 70, 0, 2, 'Abadia de Goiás', '', 'abadia-de-goias', '', ''),
(9738, 70, 0, 2, 'Abadiânia', '', 'abadiania', '', ''),
(9739, 70, 0, 2, 'Acreúna', '', 'acreuna', '', ''),
(9740, 70, 0, 2, 'Adelândia', '', 'adelandia', '', ''),
(9741, 70, 0, 2, 'Água Fria de Goiás', '', 'agua-fria-de-goias', '', ''),
(9742, 70, 0, 2, 'Água Limpa', '', 'agua-limpa', '', ''),
(9743, 70, 0, 2, 'Águas Lindas de Goiás', '', 'aguas-lindas-de-goias', '', ''),
(9744, 70, 0, 2, 'Alexânia', '', 'alexania', '', ''),
(9745, 70, 0, 2, 'Aloândia', '', 'aloandia', '', ''),
(9746, 70, 0, 2, 'Alto Horizonte', '', 'alto-horizonte', '', ''),
(9747, 70, 0, 2, 'Alto Paraíso de Goiás', '', 'alto-paraiso-de-goias', '', ''),
(9748, 70, 0, 2, 'Alvorada do Norte', '', 'alvorada-do-norte', '', ''),
(9749, 70, 0, 2, 'Amaralina', '', 'amaralina', '', ''),
(9750, 70, 0, 2, 'Americano do Brasil', '', 'americano-do-brasil', '', ''),
(9751, 70, 0, 2, 'Amorinópolis', '', 'amorinopolis', '', ''),
(9752, 70, 0, 2, 'Anápolis', '', 'anapolis', '', ''),
(9753, 70, 0, 2, 'Anhanguera', '', 'anhanguera', '', ''),
(9754, 70, 0, 2, 'Anicuns', '', 'anicuns', '', ''),
(9755, 70, 0, 2, 'Aparecida de Goiânia', '', 'aparecida-de-goiania', '', ''),
(9756, 70, 0, 2, 'Aparecida do Rio Doce', '', 'aparecida-do-rio-doce', '', ''),
(9757, 70, 0, 2, 'Aporé', '', 'apore', '', ''),
(9758, 70, 0, 2, 'Araçu', '', 'aracu', '', ''),
(9759, 70, 0, 2, 'Aragarças', '', 'aragarcas', '', ''),
(9760, 70, 0, 2, 'Aragoiânia', '', 'aragoiania', '', ''),
(9761, 70, 0, 2, 'Araguapaz', '', 'araguapaz', '', ''),
(9762, 70, 0, 2, 'Arenópolis', '', 'arenopolis', '', ''),
(9763, 70, 0, 2, 'Aruanã', '', 'aruana', '', ''),
(9764, 70, 0, 2, 'Aurilândia', '', 'aurilandia', '', ''),
(9765, 70, 0, 2, 'Avelinópolis', '', 'avelinopolis', '', ''),
(9766, 70, 0, 2, 'Baliza', '', 'baliza', '', ''),
(9767, 70, 0, 2, 'Barro Alto', '', 'barro-alto', '', ''),
(9768, 70, 0, 2, 'Bela Vista de Goiás', '', 'bela-vista-de-goias', '', ''),
(9769, 70, 0, 2, 'Bom Jardim de Goiás', '', 'bom-jardim-de-goias', '', ''),
(9770, 70, 0, 2, 'Bom Jesus de Goiás', '', 'bom-jesus-de-goias', '', ''),
(9771, 70, 0, 2, 'Bonfinópolis', '', 'bonfinopolis', '', ''),
(9772, 70, 0, 2, 'Bonópolis', '', 'bonopolis', '', ''),
(9773, 70, 0, 2, 'Brazabrantes', '', 'brazabrantes', '', ''),
(9774, 70, 0, 2, 'Britânia', '', 'britania', '', ''),
(9775, 70, 0, 2, 'Buriti Alegre', '', 'buriti-alegre', '', ''),
(9776, 70, 0, 2, 'Buriti de Goiás', '', 'buriti-de-goias', '', ''),
(9777, 70, 0, 2, 'Buritinópolis', '', 'buritinopolis', '', ''),
(9778, 70, 0, 2, 'Cabeceiras', '', 'cabeceiras', '', ''),
(9779, 70, 0, 2, 'Cachoeira Alta', '', 'cachoeira-alta', '', ''),
(9780, 70, 0, 2, 'Cachoeira de Goiás', '', 'cachoeira-de-goias', '', ''),
(9781, 70, 0, 2, 'Cachoeira Dourada', '', 'cachoeira-dourada', '', ''),
(9782, 70, 0, 2, 'Caçu', '', 'cacu', '', ''),
(9783, 70, 0, 2, 'Caiapônia', '', 'caiaponia', '', ''),
(9784, 70, 0, 2, 'Caldas Novas', '', 'caldas-novas', '', ''),
(9785, 70, 0, 2, 'Caldazinha', '', 'caldazinha', '', ''),
(9786, 70, 0, 2, 'Campestre de Goiás', '', 'campestre-de-goias', '', ''),
(9787, 70, 0, 2, 'Campinaçu', '', 'campinacu', '', ''),
(9788, 70, 0, 2, 'Campinorte', '', 'campinorte', '', ''),
(9789, 70, 0, 2, 'Campo Alegre de Goiás', '', 'campo-alegre-de-goias', '', ''),
(9790, 70, 0, 2, 'Campos Belos', '', 'campos-belos', '', ''),
(9791, 70, 0, 2, 'Campos Verdes', '', 'campos-verdes', '', ''),
(9792, 70, 0, 2, 'Carmo do Rio Verde', '', 'carmo-do-rio-verde', '', ''),
(9793, 70, 0, 2, 'Castelândia', '', 'castelandia', '', ''),
(9794, 70, 0, 2, 'Catalão', '', 'catalao', '', ''),
(9795, 70, 0, 2, 'Caturaí', '', 'caturai', '', ''),
(9796, 70, 0, 2, 'Cavalcante', '', 'cavalcante', '', ''),
(9797, 70, 0, 2, 'Ceres', '', 'ceres', '', ''),
(9798, 70, 0, 2, 'Cezarina', '', 'cezarina', '', ''),
(9799, 70, 0, 2, 'Chapadão do Céu', '', 'chapadao-do-ceu', '', ''),
(9800, 70, 0, 2, 'Cidade Ocidental', '', 'cidade-ocidental', '', ''),
(9801, 70, 0, 2, 'Cocalzinho de Goiás', '', 'cocalzinho-de-goias', '', ''),
(9802, 70, 0, 2, 'Colinas do Sul', '', 'colinas-do-sul', '', ''),
(9803, 70, 0, 2, 'Córrego do Ouro', '', 'corrego-do-ouro', '', ''),
(9804, 70, 0, 2, 'Corumbá de Goiás', '', 'corumba-de-goias', '', ''),
(9805, 70, 0, 2, 'Corumbaíba', '', 'corumbaiba', '', ''),
(9806, 70, 0, 2, 'Cristalina', '', 'cristalina', '', ''),
(9807, 70, 0, 2, 'Cristianópolis', '', 'cristianopolis', '', ''),
(9808, 70, 0, 2, 'Crixás', '', 'crixas', '', ''),
(9809, 70, 0, 2, 'Cromínia', '', 'crominia', '', ''),
(9810, 70, 0, 2, 'Cumari', '', 'cumari', '', ''),
(9811, 70, 0, 2, 'Damianópolis', '', 'damianopolis', '', ''),
(9812, 70, 0, 2, 'Damolândia', '', 'damolandia', '', ''),
(9813, 70, 0, 2, 'Davinópolis', '', 'davinopolis', '', ''),
(9814, 70, 0, 2, 'Diorama', '', 'diorama', '', ''),
(9815, 70, 0, 2, 'Divinópolis de Goiás', '', 'divinopolis-de-goias', '', ''),
(9816, 70, 0, 2, 'Doverlândia', '', 'doverlandia', '', ''),
(9817, 70, 0, 2, 'Edealina', '', 'edealina', '', ''),
(9818, 70, 0, 2, 'Edéia', '', 'edeia', '', ''),
(9819, 70, 0, 2, 'Estrela do Norte', '', 'estrela-do-norte', '', ''),
(9820, 70, 0, 2, 'Faina', '', 'faina', '', ''),
(9821, 70, 0, 2, 'Fazenda Nova', '', 'fazenda-nova', '', ''),
(9822, 70, 0, 2, 'Firminópolis', '', 'firminopolis', '', ''),
(9823, 70, 0, 2, 'Flores de Goiás', '', 'flores-de-goias', '', ''),
(9824, 70, 0, 2, 'Formosa', '', 'formosa', '', ''),
(9825, 70, 0, 2, 'Formoso', '', 'formoso', '', ''),
(9826, 70, 0, 2, 'Goianápolis', '', 'goianapolis', '', ''),
(9827, 70, 0, 2, 'Goiandira', '', 'goiandira', '', ''),
(9828, 70, 0, 2, 'Goianésia', '', 'goianesia', '', ''),
(9829, 70, 0, 2, 'Goiânia', '', 'goiania', '', ''),
(9830, 70, 0, 2, 'Goianira', '', 'goianira', '', ''),
(9831, 70, 0, 2, 'Goiás', '', 'goias', '', ''),
(9832, 70, 0, 2, 'Goiatuba', '', 'goiatuba', '', ''),
(9833, 70, 0, 2, 'Gouvelândia', '', 'gouvelandia', '', ''),
(9834, 70, 0, 2, 'Guapó', '', 'guapo', '', ''),
(9835, 70, 0, 2, 'Guaraíta', '', 'guaraita', '', ''),
(9836, 70, 0, 2, 'Guarani de Goiás', '', 'guarani-de-goias', '', ''),
(9837, 70, 0, 2, 'Guarinos', '', 'guarinos', '', ''),
(9838, 70, 0, 2, 'Heitoraí', '', 'heitorai', '', ''),
(9839, 70, 0, 2, 'Hidrolândia', '', 'hidrolandia', '', ''),
(9840, 70, 0, 2, 'Hidrolina', '', 'hidrolina', '', ''),
(9841, 70, 0, 2, 'Iaciara', '', 'iaciara', '', ''),
(9842, 70, 0, 2, 'Inaciolândia', '', 'inaciolandia', '', ''),
(9843, 70, 0, 2, 'Indiara', '', 'indiara', '', ''),
(9844, 70, 0, 2, 'Inhumas', '', 'inhumas', '', ''),
(9845, 70, 0, 2, 'Ipameri', '', 'ipameri', '', ''),
(9846, 70, 0, 2, 'Iporá', '', 'ipora', '', ''),
(9847, 70, 0, 2, 'Israelândia', '', 'israelandia', '', ''),
(9848, 70, 0, 2, 'Itaberaí', '', 'itaberai', '', ''),
(9849, 70, 0, 2, 'Itaguari', '', 'itaguari', '', ''),
(9850, 70, 0, 2, 'Itaguaru', '', 'itaguaru', '', ''),
(9851, 70, 0, 2, 'Itajá', '', 'itaja', '', ''),
(9852, 70, 0, 2, 'Itapaci', '', 'itapaci', '', ''),
(9853, 70, 0, 2, 'Itapirapuã', '', 'itapirapua', '', ''),
(9854, 70, 0, 2, 'Itapuranga', '', 'itapuranga', '', ''),
(9855, 70, 0, 2, 'Itarumã', '', 'itaruma', '', ''),
(9856, 70, 0, 2, 'Itauçu', '', 'itaucu', '', ''),
(9857, 70, 0, 2, 'Itumbiara', '', 'itumbiara', '', ''),
(9858, 70, 0, 2, 'Ivolândia', '', 'ivolandia', '', ''),
(9859, 70, 0, 2, 'Jandaia', '', 'jandaia', '', ''),
(9860, 70, 0, 2, 'Jaraguá', '', 'jaragua', '', ''),
(9861, 70, 0, 2, 'Jataí', '', 'jatai', '', ''),
(9862, 70, 0, 2, 'Jaupaci', '', 'jaupaci', '', ''),
(9863, 70, 0, 2, 'Jesúpolis', '', 'jesupolis', '', ''),
(9864, 70, 0, 2, 'Joviânia', '', 'joviania', '', ''),
(9865, 70, 0, 2, 'Jussara', '', 'jussara', '', ''),
(9866, 70, 0, 2, 'Leopoldo de Bulhões', '', 'leopoldo-de-bulhoes', '', ''),
(9867, 70, 0, 2, 'Luziânia', '', 'luziania', '', ''),
(9868, 70, 0, 2, 'Mairipotaba', '', 'mairipotaba', '', ''),
(9869, 70, 0, 2, 'Mambaí', '', 'mambai', '', ''),
(9870, 70, 0, 2, 'Mara Rosa', '', 'mara-rosa', '', ''),
(9871, 70, 0, 2, 'Marzagão', '', 'marzagao', '', ''),
(9872, 70, 0, 2, 'Matrinchã', '', 'matrincha', '', ''),
(9873, 70, 0, 2, 'Maurilândia', '', 'maurilandia', '', ''),
(9874, 70, 0, 2, 'Mimoso de Goiás', '', 'mimoso-de-goias', '', ''),
(9875, 70, 0, 2, 'Minaçu', '', 'minacu', '', ''),
(9876, 70, 0, 2, 'Mineiros', '', 'mineiros', '', ''),
(9877, 70, 0, 2, 'Moiporá', '', 'moipora', '', ''),
(9878, 70, 0, 2, 'Monte Alegre de Goiás', '', 'monte-alegre-de-goias', '', ''),
(9879, 70, 0, 2, 'Montes Claros de Goiás', '', 'montes-claros-de-goias', '', ''),
(9880, 70, 0, 2, 'Montividiu', '', 'montividiu', '', ''),
(9881, 70, 0, 2, 'Montividiu do Norte', '', 'montividiu-do-norte', '', ''),
(9882, 70, 0, 2, 'Morrinhos', '', 'morrinhos', '', ''),
(9883, 70, 0, 2, 'Morro Agudo de Goiás', '', 'morro-agudo-de-goias', '', ''),
(9884, 70, 0, 2, 'Mossâmedes', '', 'mossamedes', '', ''),
(9885, 70, 0, 2, 'Mozarlândia', '', 'mozarlandia', '', ''),
(9886, 70, 0, 2, 'Mundo Novo', '', 'mundo-novo', '', ''),
(9887, 70, 0, 2, 'Mutunópolis', '', 'mutunopolis', '', ''),
(9888, 70, 0, 2, 'Nazário', '', 'nazario', '', ''),
(9889, 70, 0, 2, 'Nerópolis', '', 'neropolis', '', ''),
(9890, 70, 0, 2, 'Niquelândia', '', 'niquelandia', '', ''),
(9891, 70, 0, 2, 'Nova América', '', 'nova-america', '', ''),
(9892, 70, 0, 2, 'Nova Aurora', '', 'nova-aurora', '', ''),
(9893, 70, 0, 2, 'Nova Crixás', '', 'nova-crixas', '', ''),
(9894, 70, 0, 2, 'Nova Glória', '', 'nova-gloria', '', ''),
(9895, 70, 0, 2, 'Nova Iguaçu de Goiás', '', 'nova-iguacu-de-goias', '', ''),
(9896, 70, 0, 2, 'Nova Roma', '', 'nova-roma', '', ''),
(9897, 70, 0, 2, 'Nova Veneza', '', 'nova-veneza', '', ''),
(9898, 70, 0, 2, 'Novo Brasil', '', 'novo-brasil', '', ''),
(9899, 70, 0, 2, 'Novo Gama', '', 'novo-gama', '', ''),
(9900, 70, 0, 2, 'Novo Planalto', '', 'novo-planalto', '', ''),
(9901, 70, 0, 2, 'Orizona', '', 'orizona', '', ''),
(9902, 70, 0, 2, 'Ouro Verde de Goiás', '', 'ouro-verde-de-goias', '', ''),
(9903, 70, 0, 2, 'Ouvidor', '', 'ouvidor', '', ''),
(9904, 70, 0, 2, 'Padre Bernardo', '', 'padre-bernardo', '', ''),
(9905, 70, 0, 2, 'Palestina de Goiás', '', 'palestina-de-goias', '', ''),
(9906, 70, 0, 2, 'Palmeiras de Goiás', '', 'palmeiras-de-goias', '', ''),
(9907, 70, 0, 2, 'Palmelo', '', 'palmelo', '', ''),
(9908, 70, 0, 2, 'Palminópolis', '', 'palminopolis', '', ''),
(9909, 70, 0, 2, 'Panamá', '', 'panama', '', ''),
(9910, 70, 0, 2, 'Paranaiguara', '', 'paranaiguara', '', ''),
(9911, 70, 0, 2, 'Paraúna', '', 'parauna', '', ''),
(9912, 70, 0, 2, 'Perolândia', '', 'perolandia', '', ''),
(9913, 70, 0, 2, 'Petrolina de Goiás', '', 'petrolina-de-goias', '', ''),
(9914, 70, 0, 2, 'Pilar de Goiás', '', 'pilar-de-goias', '', ''),
(9915, 70, 0, 2, 'Piracanjuba', '', 'piracanjuba', '', ''),
(9916, 70, 0, 2, 'Piranhas', '', 'piranhas', '', ''),
(9917, 70, 0, 2, 'Pirenópolis', '', 'pirenopolis', '', ''),
(9918, 70, 0, 2, 'Pires do Rio', '', 'pires-do-rio', '', ''),
(9919, 70, 0, 2, 'Planaltina', '', 'planaltina', '', ''),
(9920, 70, 0, 2, 'Pontalina', '', 'pontalina', '', ''),
(9921, 70, 0, 2, 'Porangatu', '', 'porangatu', '', ''),
(9922, 70, 0, 2, 'Porteirão', '', 'porteirao', '', ''),
(9923, 70, 0, 2, 'Portelândia', '', 'portelandia', '', ''),
(9924, 70, 0, 2, 'Posse', '', 'posse', '', ''),
(9925, 70, 0, 2, 'Professor Jamil', '', 'professor-jamil', '', ''),
(9926, 70, 0, 2, 'Quirinópolis', '', 'quirinopolis', '', ''),
(9927, 70, 0, 2, 'Rialma', '', 'rialma', '', ''),
(9928, 70, 0, 2, 'Rianápolis', '', 'rianapolis', '', ''),
(9929, 70, 0, 2, 'Rio Quente', '', 'rio-quente', '', ''),
(9930, 70, 0, 2, 'Rio Verde', '', 'rio-verde', '', ''),
(9931, 70, 0, 2, 'Rubiataba', '', 'rubiataba', '', ''),
(9932, 70, 0, 2, 'Sanclerlândia', '', 'sanclerlandia', '', ''),
(9933, 70, 0, 2, 'Santa Bárbara de Goiás', '', 'santa-barbara-de-goias', '', ''),
(9934, 70, 0, 2, 'Santa Cruz de Goiás', '', 'santa-cruz-de-goias', '', ''),
(9935, 70, 0, 2, 'Santa Fé de Goiás', '', 'santa-fe-de-goias', '', ''),
(9936, 70, 0, 2, 'Santa Helena de Goiás', '', 'santa-helena-de-goias', '', ''),
(9937, 70, 0, 2, 'Santa Isabel', '', 'santa-isabel', '', ''),
(9938, 70, 0, 2, 'Santa Rita do Araguaia', '', 'santa-rita-do-araguaia', '', ''),
(9939, 70, 0, 2, 'Santa Rita do Novo Destino', '', 'santa-rita-do-novo-destino', '', ''),
(9940, 70, 0, 2, 'Santa Rosa de Goiás', '', 'santa-rosa-de-goias', '', ''),
(9941, 70, 0, 2, 'Santa Tereza de Goiás', '', 'santa-tereza-de-goias', '', ''),
(9942, 70, 0, 2, 'Santa Terezinha de Goiás', '', 'santa-terezinha-de-goias', '', ''),
(9943, 70, 0, 2, 'Santo Antônio da Barra', '', 'santo-antonio-da-barra', '', ''),
(9944, 70, 0, 2, 'Santo Antônio de Goiás', '', 'santo-antonio-de-goias', '', ''),
(9945, 70, 0, 2, 'Santo Antônio do Descoberto', '', 'santo-antonio-do-descoberto', '', ''),
(9946, 70, 0, 2, 'São Domingos', '', 'sao-domingos', '', ''),
(9947, 70, 0, 2, 'São Francisco de Goiás', '', 'sao-francisco-de-goias', '', ''),
(9948, 70, 0, 2, 'São João d`Aliança', '', 'sao-joao-d`alianca', '', ''),
(9949, 70, 0, 2, 'São João da Paraúna', '', 'sao-joao-da-parauna', '', ''),
(9950, 70, 0, 2, 'São Luís de Montes Belos', '', 'sao-luis-de-montes-belos', '', ''),
(9951, 70, 0, 2, 'São Luíz do Norte', '', 'sao-luiz-do-norte', '', ''),
(9952, 70, 0, 2, 'São Miguel do Araguaia', '', 'sao-miguel-do-araguaia', '', ''),
(9953, 70, 0, 2, 'São Miguel do Passa Quatro', '', 'sao-miguel-do-passa-quatro', '', ''),
(9954, 70, 0, 2, 'São Patrício', '', 'sao-patricio', '', ''),
(9955, 70, 0, 2, 'São Simão', '', 'sao-simao', '', ''),
(9956, 70, 0, 2, 'Senador Canedo', '', 'senador-canedo', '', ''),
(9957, 70, 0, 2, 'Serranópolis', '', 'serranopolis', '', ''),
(9958, 70, 0, 2, 'Silvânia', '', 'silvania', '', ''),
(9959, 70, 0, 2, 'Simolândia', '', 'simolandia', '', ''),
(9960, 70, 0, 2, 'Sítio d`Abadia', '', 'sitio-d`abadia', '', ''),
(9961, 70, 0, 2, 'Taquaral de Goiás', '', 'taquaral-de-goias', '', ''),
(9962, 70, 0, 2, 'Teresina de Goiás', '', 'teresina-de-goias', '', ''),
(9963, 70, 0, 2, 'Terezópolis de Goiás', '', 'terezopolis-de-goias', '', ''),
(9964, 70, 0, 2, 'Três Ranchos', '', 'tres-ranchos', '', ''),
(9965, 70, 0, 2, 'Trindade', '', 'trindade', '', ''),
(9966, 70, 0, 2, 'Trombas', '', 'trombas', '', ''),
(9967, 70, 0, 2, 'Turvânia', '', 'turvania', '', ''),
(9968, 70, 0, 2, 'Turvelândia', '', 'turvelandia', '', ''),
(9969, 70, 0, 2, 'Uirapuru', '', 'uirapuru', '', ''),
(9970, 70, 0, 2, 'Uruaçu', '', 'uruacu', '', ''),
(9971, 70, 0, 2, 'Uruana', '', 'uruana', '', ''),
(9972, 70, 0, 2, 'Urutaí', '', 'urutai', '', ''),
(9973, 70, 0, 2, 'Valparaíso de Goiás', '', 'valparaiso-de-goias', '', ''),
(9974, 70, 0, 2, 'Varjão', '', 'varjao', '', ''),
(9975, 70, 0, 2, 'Vianópolis', '', 'vianopolis', '', ''),
(9976, 70, 0, 2, 'Vicentinópolis', '', 'vicentinopolis', '', ''),
(9977, 70, 0, 2, 'Vila Boa', '', 'vila-boa', '', ''),
(9978, 70, 0, 2, 'Vila Propício', '', 'vila-propicio', '', ''),
(9979, 71, 0, 2, 'Acorizal', '', 'acorizal', '', ''),
(9980, 71, 0, 2, 'Água Boa', '', 'agua-boa', '', ''),
(9981, 71, 0, 2, 'Alta Floresta', '', 'alta-floresta', '', ''),
(9982, 71, 0, 2, 'Alto Araguaia', '', 'alto-araguaia', '', ''),
(9983, 71, 0, 2, 'Alto Boa Vista', '', 'alto-boa-vista', '', ''),
(9984, 71, 0, 2, 'Alto Garças', '', 'alto-garcas', '', ''),
(9985, 71, 0, 2, 'Alto Paraguai', '', 'alto-paraguai', '', ''),
(9986, 71, 0, 2, 'Alto Taquari', '', 'alto-taquari', '', ''),
(9987, 71, 0, 2, 'Apiacás', '', 'apiacas', '', ''),
(9988, 71, 0, 2, 'Araguaiana', '', 'araguaiana', '', ''),
(9989, 71, 0, 2, 'Araguainha', '', 'araguainha', '', ''),
(9990, 71, 0, 2, 'Araputanga', '', 'araputanga', '', ''),
(9991, 71, 0, 2, 'Arenápolis', '', 'arenapolis', '', ''),
(9992, 71, 0, 2, 'Aripuanã', '', 'aripuana', '', ''),
(9993, 71, 0, 2, 'Barão de Melgaço', '', 'barao-de-melgaco', '', ''),
(9994, 71, 0, 2, 'Barra do Bugres', '', 'barra-do-bugres', '', ''),
(9995, 71, 0, 2, 'Barra do Garças', '', 'barra-do-garcas', '', ''),
(9996, 71, 0, 2, 'Brasnorte', '', 'brasnorte', '', ''),
(9997, 71, 0, 2, 'Cáceres', '', 'caceres', '', ''),
(9998, 71, 0, 2, 'Campinápolis', '', 'campinapolis', '', ''),
(9999, 71, 0, 2, 'Campo Novo do Parecis', '', 'campo-novo-do-parecis', '', ''),
(10000, 71, 0, 2, 'Campo Verde', '', 'campo-verde', '', ''),
(10001, 71, 0, 2, 'Campos de Júlio', '', 'campos-de-julio', '', ''),
(10002, 71, 0, 2, 'Canabrava do Norte', '', 'canabrava-do-norte', '', ''),
(10003, 71, 0, 2, 'Canarana', '', 'canarana', '', ''),
(10004, 71, 0, 2, 'Carlinda', '', 'carlinda', '', ''),
(10005, 71, 0, 2, 'Castanheira', '', 'castanheira', '', ''),
(10006, 71, 0, 2, 'Chapada dos Guimarães', '', 'chapada-dos-guimaraes', '', ''),
(10007, 71, 0, 2, 'Cláudia', '', 'claudia', '', ''),
(10008, 71, 0, 2, 'Cocalinho', '', 'cocalinho', '', ''),
(10009, 71, 0, 2, 'Colíder', '', 'colider', '', ''),
(10010, 71, 0, 2, 'Comodoro', '', 'comodoro', '', ''),
(10011, 71, 0, 2, 'Confresa', '', 'confresa', '', ''),
(10012, 71, 0, 2, 'Cotriguaçu', '', 'cotriguacu', '', ''),
(10013, 71, 0, 2, 'Cuiabá', '', 'cuiaba', '', ''),
(10014, 71, 0, 2, 'Denise', '', 'denise', '', ''),
(10015, 71, 0, 2, 'Diamantino', '', 'diamantino', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(10016, 71, 0, 2, 'Dom Aquino', '', 'dom-aquino', '', ''),
(10017, 71, 0, 2, 'Feliz Natal', '', 'feliz-natal', '', ''),
(10018, 71, 0, 2, 'Figueirópolis d`Oeste', '', 'figueiropolis-d`oeste', '', ''),
(10019, 71, 0, 2, 'Gaúcha do Norte', '', 'gaucha-do-norte', '', ''),
(10020, 71, 0, 2, 'General Carneiro', '', 'general-carneiro', '', ''),
(10021, 71, 0, 2, 'Glória d`Oeste', '', 'gloria-d`oeste', '', ''),
(10022, 71, 0, 2, 'Guarantã do Norte', '', 'guaranta-do-norte', '', ''),
(10023, 71, 0, 2, 'Guiratinga', '', 'guiratinga', '', ''),
(10024, 71, 0, 2, 'Indiavaí', '', 'indiavai', '', ''),
(10025, 71, 0, 2, 'Itaúba', '', 'itauba', '', ''),
(10026, 71, 0, 2, 'Itiquira', '', 'itiquira', '', ''),
(10027, 71, 0, 2, 'Jaciara', '', 'jaciara', '', ''),
(10028, 71, 0, 2, 'Jangada', '', 'jangada', '', ''),
(10029, 71, 0, 2, 'Jauru', '', 'jauru', '', ''),
(10030, 71, 0, 2, 'Juara', '', 'juara', '', ''),
(10031, 71, 0, 2, 'Juína', '', 'juina', '', ''),
(10032, 71, 0, 2, 'Juruena', '', 'juruena', '', ''),
(10033, 71, 0, 2, 'Juscimeira', '', 'juscimeira', '', ''),
(10034, 71, 0, 2, 'Lambari d`Oeste', '', 'lambari-d`oeste', '', ''),
(10035, 71, 0, 2, 'Lucas do Rio Verde', '', 'lucas-do-rio-verde', '', ''),
(10036, 71, 0, 2, 'Luciára', '', 'luciara', '', ''),
(10037, 71, 0, 2, 'Marcelândia', '', 'marcelandia', '', ''),
(10038, 71, 0, 2, 'Matupá', '', 'matupa', '', ''),
(10039, 71, 0, 2, 'Mirassol d`Oeste', '', 'mirassol-d`oeste', '', ''),
(10040, 71, 0, 2, 'Nobres', '', 'nobres', '', ''),
(10041, 71, 0, 2, 'Nortelândia', '', 'nortelandia', '', ''),
(10042, 71, 0, 2, 'Nossa Senhora do Livramento', '', 'nossa-senhora-do-livramento', '', ''),
(10043, 71, 0, 2, 'Nova Bandeirantes', '', 'nova-bandeirantes', '', ''),
(10044, 71, 0, 2, 'Nova Brasilândia', '', 'nova-brasilandia', '', ''),
(10045, 71, 0, 2, 'Nova Canaã do Norte', '', 'nova-canaa-do-norte', '', ''),
(10046, 71, 0, 2, 'Nova Guarita', '', 'nova-guarita', '', ''),
(10047, 71, 0, 2, 'Nova Lacerda', '', 'nova-lacerda', '', ''),
(10048, 71, 0, 2, 'Nova Marilândia', '', 'nova-marilandia', '', ''),
(10049, 71, 0, 2, 'Nova Maringá', '', 'nova-maringa', '', ''),
(10050, 71, 0, 2, 'Nova Monte Verde', '', 'nova-monte-verde', '', ''),
(10051, 71, 0, 2, 'Nova Mutum', '', 'nova-mutum', '', ''),
(10052, 71, 0, 2, 'Nova Olímpia', '', 'nova-olimpia', '', ''),
(10053, 71, 0, 2, 'Nova Ubiratã', '', 'nova-ubirata', '', ''),
(10054, 71, 0, 2, 'Nova Xavantina', '', 'nova-xavantina', '', ''),
(10055, 71, 0, 2, 'Novo Horizonte do Norte', '', 'novo-horizonte-do-norte', '', ''),
(10056, 71, 0, 2, 'Novo Mundo', '', 'novo-mundo', '', ''),
(10057, 71, 0, 2, 'Novo São Joaquim', '', 'novo-sao-joaquim', '', ''),
(10058, 71, 0, 2, 'Paranaíta', '', 'paranaita', '', ''),
(10059, 71, 0, 2, 'Paranatinga', '', 'paranatinga', '', ''),
(10060, 71, 0, 2, 'Pedra Preta', '', 'pedra-preta', '', ''),
(10061, 71, 0, 2, 'Peixoto de Azevedo', '', 'peixoto-de-azevedo', '', ''),
(10062, 71, 0, 2, 'Planalto da Serra', '', 'planalto-da-serra', '', ''),
(10063, 71, 0, 2, 'Poconé', '', 'pocone', '', ''),
(10064, 71, 0, 2, 'Pontal do Araguaia', '', 'pontal-do-araguaia', '', ''),
(10065, 71, 0, 2, 'Ponte Branca', '', 'ponte-branca', '', ''),
(10066, 71, 0, 2, 'Pontes e Lacerda', '', 'pontes-e-lacerda', '', ''),
(10067, 71, 0, 2, 'Porto Alegre do Norte', '', 'porto-alegre-do-norte', '', ''),
(10068, 71, 0, 2, 'Porto dos Gaúchos', '', 'porto-dos-gauchos', '', ''),
(10069, 71, 0, 2, 'Porto Esperidião', '', 'porto-esperidiao', '', ''),
(10070, 71, 0, 2, 'Porto Estrela', '', 'porto-estrela', '', ''),
(10071, 71, 0, 2, 'Poxoréo', '', 'poxoreo', '', ''),
(10072, 71, 0, 2, 'Primavera do Leste', '', 'primavera-do-leste', '', ''),
(10073, 71, 0, 2, 'Querência', '', 'querencia', '', ''),
(10074, 71, 0, 2, 'Reserva do Cabaçal', '', 'reserva-do-cabacal', '', ''),
(10075, 71, 0, 2, 'Ribeirão Cascalheira', '', 'ribeirao-cascalheira', '', ''),
(10076, 71, 0, 2, 'Ribeirãozinho', '', 'ribeiraozinho', '', ''),
(10077, 71, 0, 2, 'Rio Branco', '', 'rio-branco', '', ''),
(10078, 71, 0, 2, 'Rondonópolis', '', 'rondonopolis', '', ''),
(10079, 71, 0, 2, 'Rosário Oeste', '', 'rosario-oeste', '', ''),
(10080, 71, 0, 2, 'Salto do Céu', '', 'salto-do-ceu', '', ''),
(10081, 71, 0, 2, 'Santa Carmem', '', 'santa-carmem', '', ''),
(10082, 71, 0, 2, 'Santa Terezinha', '', 'santa-terezinha', '', ''),
(10083, 71, 0, 2, 'Santo Afonso', '', 'santo-afonso', '', ''),
(10084, 71, 0, 2, 'Santo Antônio do Leverger', '', 'santo-antonio-do-leverger', '', ''),
(10085, 71, 0, 2, 'São Félix do Araguaia', '', 'sao-felix-do-araguaia', '', ''),
(10086, 71, 0, 2, 'São José do Povo', '', 'sao-jose-do-povo', '', ''),
(10087, 71, 0, 2, 'São José do Rio Claro', '', 'sao-jose-do-rio-claro', '', ''),
(10088, 71, 0, 2, 'São José do Xingu', '', 'sao-jose-do-xingu', '', ''),
(10089, 71, 0, 2, 'São José dos Quatro Marcos', '', 'sao-jose-dos-quatro-marcos', '', ''),
(10090, 71, 0, 2, 'São Pedro da Cipa', '', 'sao-pedro-da-cipa', '', ''),
(10091, 71, 0, 2, 'Sapezal', '', 'sapezal', '', ''),
(10092, 71, 0, 2, 'Sinop', '', 'sinop', '', ''),
(10093, 71, 0, 2, 'Sorriso', '', 'sorriso', '', ''),
(10094, 71, 0, 2, 'Tabaporã', '', 'tabapora', '', ''),
(10095, 71, 0, 2, 'Tangará da Serra', '', 'tangara-da-serra', '', ''),
(10096, 71, 0, 2, 'Tapurah', '', 'tapurah', '', ''),
(10097, 71, 0, 2, 'Terra Nova do Norte', '', 'terra-nova-do-norte', '', ''),
(10098, 71, 0, 2, 'Tesouro', '', 'tesouro', '', ''),
(10099, 71, 0, 2, 'Torixoréu', '', 'torixoreu', '', ''),
(10100, 71, 0, 2, 'União do Sul', '', 'uniao-do-sul', '', ''),
(10101, 71, 0, 2, 'Várzea Grande', '', 'varzea-grande', '', ''),
(10102, 71, 0, 2, 'Vera', '', 'vera', '', ''),
(10103, 71, 0, 2, 'Vila Bela da Santíssima Trindade', '', 'vila-bela-da-santissima-trindade', '', ''),
(10104, 71, 0, 2, 'Vila Rica', '', 'vila-rica', '', ''),
(10105, 72, 0, 2, 'Água Clara', '', 'agua-clara', '', ''),
(10106, 72, 0, 2, 'Alcinópolis', '', 'alcinopolis', '', ''),
(10107, 72, 0, 2, 'Amambaí', '', 'amambai', '', ''),
(10108, 72, 0, 2, 'Anastácio', '', 'anastacio', '', ''),
(10109, 72, 0, 2, 'Anaurilândia', '', 'anaurilandia', '', ''),
(10110, 72, 0, 2, 'Angélica', '', 'angelica', '', ''),
(10111, 72, 0, 2, 'Antônio João', '', 'antonio-joao', '', ''),
(10112, 72, 0, 2, 'Aparecida do Taboado', '', 'aparecida-do-taboado', '', ''),
(10113, 72, 0, 2, 'Aquidauana', '', 'aquidauana', '', ''),
(10114, 72, 0, 2, 'Aral Moreira', '', 'aral-moreira', '', ''),
(10115, 72, 0, 2, 'Bandeirantes', '', 'bandeirantes', '', ''),
(10116, 72, 0, 2, 'Bataguassu', '', 'bataguassu', '', ''),
(10117, 72, 0, 2, 'Bataiporã', '', 'bataipora', '', ''),
(10118, 72, 0, 2, 'Bela Vista', '', 'bela-vista', '', ''),
(10119, 72, 0, 2, 'Bodoquena', '', 'bodoquena', '', ''),
(10120, 72, 0, 2, 'Bonito', '', 'bonito', '', ''),
(10121, 72, 0, 2, 'Brasilândia', '', 'brasilandia', '', ''),
(10122, 72, 0, 2, 'Caarapó', '', 'caarapo', '', ''),
(10123, 72, 0, 2, 'Camapuã', '', 'camapua', '', ''),
(10124, 72, 0, 2, 'Campo Grande', '', 'campo-grande', '', ''),
(10125, 72, 0, 2, 'Caracol', '', 'caracol', '', ''),
(10126, 72, 0, 2, 'Cassilândia', '', 'cassilandia', '', ''),
(10127, 72, 0, 2, 'Chapadão do Sul', '', 'chapadao-do-sul', '', ''),
(10128, 72, 0, 2, 'Corguinho', '', 'corguinho', '', ''),
(10129, 72, 0, 2, 'Coronel Sapucaia', '', 'coronel-sapucaia', '', ''),
(10130, 72, 0, 2, 'Corumbá', '', 'corumba', '', ''),
(10131, 72, 0, 2, 'Costa Rica', '', 'costa-rica', '', ''),
(10132, 72, 0, 2, 'Coxim', '', 'coxim', '', ''),
(10133, 72, 0, 2, 'Deodápolis', '', 'deodapolis', '', ''),
(10134, 72, 0, 2, 'Dois Irmãos do Buriti', '', 'dois-irmaos-do-buriti', '', ''),
(10135, 72, 0, 2, 'Douradina', '', 'douradina', '', ''),
(10136, 72, 0, 2, 'Dourados', '', 'dourados', '', ''),
(10137, 72, 0, 2, 'Eldorado', '', 'eldorado', '', ''),
(10138, 72, 0, 2, 'Fátima do Sul', '', 'fatima-do-sul', '', ''),
(10139, 72, 0, 2, 'Glória de Dourados', '', 'gloria-de-dourados', '', ''),
(10140, 72, 0, 2, 'Guia Lopes da Laguna', '', 'guia-lopes-da-laguna', '', ''),
(10141, 72, 0, 2, 'Iguatemi', '', 'iguatemi', '', ''),
(10142, 72, 0, 2, 'Inocência', '', 'inocencia', '', ''),
(10143, 72, 0, 2, 'Itaporã', '', 'itapora', '', ''),
(10144, 72, 0, 2, 'Itaquiraí', '', 'itaquirai', '', ''),
(10145, 72, 0, 2, 'Ivinhema', '', 'ivinhema', '', ''),
(10146, 72, 0, 2, 'Japorã', '', 'japora', '', ''),
(10147, 72, 0, 2, 'Jaraguari', '', 'jaraguari', '', ''),
(10148, 72, 0, 2, 'Jardim', '', 'jardim', '', ''),
(10149, 72, 0, 2, 'Jateí', '', 'jatei', '', ''),
(10150, 72, 0, 2, 'Juti', '', 'juti', '', ''),
(10151, 72, 0, 2, 'Ladário', '', 'ladario', '', ''),
(10152, 72, 0, 2, 'Laguna Carapã', '', 'laguna-carapa', '', ''),
(10153, 72, 0, 2, 'Maracaju', '', 'maracaju', '', ''),
(10154, 72, 0, 2, 'Miranda', '', 'miranda', '', ''),
(10155, 72, 0, 2, 'Mundo Novo', '', 'mundo-novo', '', ''),
(10156, 72, 0, 2, 'Naviraí', '', 'navirai', '', ''),
(10157, 72, 0, 2, 'Nioaque', '', 'nioaque', '', ''),
(10158, 72, 0, 2, 'Nova Alvorada do Sul', '', 'nova-alvorada-do-sul', '', ''),
(10159, 72, 0, 2, 'Nova Andradina', '', 'nova-andradina', '', ''),
(10160, 72, 0, 2, 'Novo Horizonte do Sul', '', 'novo-horizonte-do-sul', '', ''),
(10161, 72, 0, 2, 'Paranaíba', '', 'paranaiba', '', ''),
(10162, 72, 0, 2, 'Paranhos', '', 'paranhos', '', ''),
(10163, 72, 0, 2, 'Pedro Gomes', '', 'pedro-gomes', '', ''),
(10164, 72, 0, 2, 'Ponta Porã', '', 'ponta-pora', '', ''),
(10165, 72, 0, 2, 'Porto Murtinho', '', 'porto-murtinho', '', ''),
(10166, 72, 0, 2, 'Ribas do Rio Pardo', '', 'ribas-do-rio-pardo', '', ''),
(10167, 72, 0, 2, 'Rio Brilhante', '', 'rio-brilhante', '', ''),
(10168, 72, 0, 2, 'Rio Negro', '', 'rio-negro', '', ''),
(10169, 72, 0, 2, 'Rio Verde de Mato Grosso', '', 'rio-verde-de-mato-grosso', '', ''),
(10170, 72, 0, 2, 'Rochedo', '', 'rochedo', '', ''),
(10171, 72, 0, 2, 'Santa Rita do Pardo', '', 'santa-rita-do-pardo', '', ''),
(10172, 72, 0, 2, 'São Gabriel do Oeste', '', 'sao-gabriel-do-oeste', '', ''),
(10173, 72, 0, 2, 'Selvíria', '', 'selviria', '', ''),
(10174, 72, 0, 2, 'Sete Quedas', '', 'sete-quedas', '', ''),
(10175, 72, 0, 2, 'Sidrolândia', '', 'sidrolandia', '', ''),
(10176, 72, 0, 2, 'Sonora', '', 'sonora', '', ''),
(10177, 72, 0, 2, 'Tacuru', '', 'tacuru', '', ''),
(10178, 72, 0, 2, 'Taquarussu', '', 'taquarussu', '', ''),
(10179, 72, 0, 2, 'Terenos', '', 'terenos', '', ''),
(10180, 72, 0, 2, 'Três Lagoas', '', 'tres-lagoas', '', ''),
(10181, 72, 0, 2, 'Vicentina', '', 'vicentina', '', ''),
(10182, 73, 0, 2, 'Abadia dos Dourados', '', 'abadia-dos-dourados', '', ''),
(10183, 73, 0, 2, 'Abaeté', '', 'abaete', '', ''),
(10184, 73, 0, 2, 'Abre Campo', '', 'abre-campo', '', ''),
(10185, 73, 0, 2, 'Acaiaca', '', 'acaiaca', '', ''),
(10186, 73, 0, 2, 'Açucena', '', 'acucena', '', ''),
(10187, 73, 0, 2, 'Água Boa', '', 'agua-boa', '', ''),
(10188, 73, 0, 2, 'Água Comprida', '', 'agua-comprida', '', ''),
(10189, 73, 0, 2, 'Aguanil', '', 'aguanil', '', ''),
(10190, 73, 0, 2, 'Águas Formosas', '', 'aguas-formosas', '', ''),
(10191, 73, 0, 2, 'Águas Vermelhas', '', 'aguas-vermelhas', '', ''),
(10192, 73, 0, 2, 'Aimorés', '', 'aimores', '', ''),
(10193, 73, 0, 2, 'Aiuruoca', '', 'aiuruoca', '', ''),
(10194, 73, 0, 2, 'Alagoa', '', 'alagoa', '', ''),
(10195, 73, 0, 2, 'Albertina', '', 'albertina', '', ''),
(10196, 73, 0, 2, 'Além Paraíba', '', 'alem-paraiba', '', ''),
(10197, 73, 0, 2, 'Alfenas', '', 'alfenas', '', ''),
(10198, 73, 0, 2, 'Alfredo Vasconcelos', '', 'alfredo-vasconcelos', '', ''),
(10199, 73, 0, 2, 'Almenara', '', 'almenara', '', ''),
(10200, 73, 0, 2, 'Alpercata', '', 'alpercata', '', ''),
(10201, 73, 0, 2, 'Alpinópolis', '', 'alpinopolis', '', ''),
(10202, 73, 0, 2, 'Alterosa', '', 'alterosa', '', ''),
(10203, 73, 0, 2, 'Alto Caparaó', '', 'alto-caparao', '', ''),
(10204, 73, 0, 2, 'Alto Jequitibá', '', 'alto-jequitiba', '', ''),
(10205, 73, 0, 2, 'Alto Rio Doce', '', 'alto-rio-doce', '', ''),
(10206, 73, 0, 2, 'Alvarenga', '', 'alvarenga', '', ''),
(10207, 73, 0, 2, 'Alvinópolis', '', 'alvinopolis', '', ''),
(10208, 73, 0, 2, 'Alvorada de Minas', '', 'alvorada-de-minas', '', ''),
(10209, 73, 0, 2, 'Amparo do Serra', '', 'amparo-do-serra', '', ''),
(10210, 73, 0, 2, 'Andradas', '', 'andradas', '', ''),
(10211, 73, 0, 2, 'Andrelândia', '', 'andrelandia', '', ''),
(10212, 73, 0, 2, 'Angelândia', '', 'angelandia', '', ''),
(10213, 73, 0, 2, 'Antônio Carlos', '', 'antonio-carlos', '', ''),
(10214, 73, 0, 2, 'Antônio Dias', '', 'antonio-dias', '', ''),
(10215, 73, 0, 2, 'Antônio Prado de Minas', '', 'antonio-prado-de-minas', '', ''),
(10216, 73, 0, 2, 'Araçaí', '', 'aracai', '', ''),
(10217, 73, 0, 2, 'Aracitaba', '', 'aracitaba', '', ''),
(10218, 73, 0, 2, 'Araçuaí', '', 'aracuai', '', ''),
(10219, 73, 0, 2, 'Araguari', '', 'araguari', '', ''),
(10220, 73, 0, 2, 'Arantina', '', 'arantina', '', ''),
(10221, 73, 0, 2, 'Araponga', '', 'araponga', '', ''),
(10222, 73, 0, 2, 'Araporã', '', 'arapora', '', ''),
(10223, 73, 0, 2, 'Arapuá', '', 'arapua', '', ''),
(10224, 73, 0, 2, 'Araújos', '', 'araujos', '', ''),
(10225, 73, 0, 2, 'Araxá', '', 'araxa', '', ''),
(10226, 73, 0, 2, 'Arceburgo', '', 'arceburgo', '', ''),
(10227, 73, 0, 2, 'Arcos', '', 'arcos', '', ''),
(10228, 73, 0, 2, 'Areado', '', 'areado', '', ''),
(10229, 73, 0, 2, 'Argirita', '', 'argirita', '', ''),
(10230, 73, 0, 2, 'Aricanduva', '', 'aricanduva', '', ''),
(10231, 73, 0, 2, 'Arinos', '', 'arinos', '', ''),
(10232, 73, 0, 2, 'Astolfo Dutra', '', 'astolfo-dutra', '', ''),
(10233, 73, 0, 2, 'Ataléia', '', 'ataleia', '', ''),
(10234, 73, 0, 2, 'Augusto de Lima', '', 'augusto-de-lima', '', ''),
(10235, 73, 0, 2, 'Baependi', '', 'baependi', '', ''),
(10236, 73, 0, 2, 'Baldim', '', 'baldim', '', ''),
(10237, 73, 0, 2, 'Bambuí', '', 'bambui', '', ''),
(10238, 73, 0, 2, 'Bandeira', '', 'bandeira', '', ''),
(10239, 73, 0, 2, 'Bandeira do Sul', '', 'bandeira-do-sul', '', ''),
(10240, 73, 0, 2, 'Barão de Cocais', '', 'barao-de-cocais', '', ''),
(10241, 73, 0, 2, 'Barão de Monte Alto', '', 'barao-de-monte-alto', '', ''),
(10242, 73, 0, 2, 'Barbacena', '', 'barbacena', '', ''),
(10243, 73, 0, 2, 'Barra Longa', '', 'barra-longa', '', ''),
(10244, 73, 0, 2, 'Barroso', '', 'barroso', '', ''),
(10245, 73, 0, 2, 'Bela Vista de Minas', '', 'bela-vista-de-minas', '', ''),
(10246, 73, 0, 2, 'Belmiro Braga', '', 'belmiro-braga', '', ''),
(10247, 73, 0, 2, 'Belo Horizonte', '', 'belo-horizonte', '', ''),
(10248, 73, 0, 2, 'Belo Oriente', '', 'belo-oriente', '', ''),
(10249, 73, 0, 2, 'Belo Vale', '', 'belo-vale', '', ''),
(10250, 73, 0, 2, 'Berilo', '', 'berilo', '', ''),
(10251, 73, 0, 2, 'Berizal', '', 'berizal', '', ''),
(10252, 73, 0, 2, 'Bertópolis', '', 'bertopolis', '', ''),
(10253, 73, 0, 2, 'Betim', '', 'betim', '', ''),
(10254, 73, 0, 2, 'Bias Fortes', '', 'bias-fortes', '', ''),
(10255, 73, 0, 2, 'Bicas', '', 'bicas', '', ''),
(10256, 73, 0, 2, 'Biquinhas', '', 'biquinhas', '', ''),
(10257, 73, 0, 2, 'Boa Esperança', '', 'boa-esperanca', '', ''),
(10258, 73, 0, 2, 'Bocaina de Minas', '', 'bocaina-de-minas', '', ''),
(10259, 73, 0, 2, 'Bocaiúva', '', 'bocaiuva', '', ''),
(10260, 73, 0, 2, 'Bom Despacho', '', 'bom-despacho', '', ''),
(10261, 73, 0, 2, 'Bom Jardim de Minas', '', 'bom-jardim-de-minas', '', ''),
(10262, 73, 0, 2, 'Bom Jesus da Penha', '', 'bom-jesus-da-penha', '', ''),
(10263, 73, 0, 2, 'Bom Jesus do Amparo', '', 'bom-jesus-do-amparo', '', ''),
(10264, 73, 0, 2, 'Bom Jesus do Galho', '', 'bom-jesus-do-galho', '', ''),
(10265, 73, 0, 2, 'Bom Repouso', '', 'bom-repouso', '', ''),
(10266, 73, 0, 2, 'Bom Sucesso', '', 'bom-sucesso', '', ''),
(10267, 73, 0, 2, 'Bonfim', '', 'bonfim', '', ''),
(10268, 73, 0, 2, 'Bonfinópolis de Minas', '', 'bonfinopolis-de-minas', '', ''),
(10269, 73, 0, 2, 'Bonito de Minas', '', 'bonito-de-minas', '', ''),
(10270, 73, 0, 2, 'Borda da Mata', '', 'borda-da-mata', '', ''),
(10271, 73, 0, 2, 'Botelhos', '', 'botelhos', '', ''),
(10272, 73, 0, 2, 'Botumirim', '', 'botumirim', '', ''),
(10273, 73, 0, 2, 'Brás Pires', '', 'bras-pires', '', ''),
(10274, 73, 0, 2, 'Brasilândia de Minas', '', 'brasilandia-de-minas', '', ''),
(10275, 73, 0, 2, 'Brasília de Minas', '', 'brasilia-de-minas', '', ''),
(10276, 73, 0, 2, 'Brasópolis', '', 'brasopolis', '', ''),
(10277, 73, 0, 2, 'Braúnas', '', 'braunas', '', ''),
(10278, 73, 0, 2, 'Brumadinho', '', 'brumadinho', '', ''),
(10279, 73, 0, 2, 'Bueno Brandão', '', 'bueno-brandao', '', ''),
(10280, 73, 0, 2, 'Buenópolis', '', 'buenopolis', '', ''),
(10281, 73, 0, 2, 'Bugre', '', 'bugre', '', ''),
(10282, 73, 0, 2, 'Buritis', '', 'buritis', '', ''),
(10283, 73, 0, 2, 'Buritizeiro', '', 'buritizeiro', '', ''),
(10284, 73, 0, 2, 'Cabeceira Grande', '', 'cabeceira-grande', '', ''),
(10285, 73, 0, 2, 'Cabo Verde', '', 'cabo-verde', '', ''),
(10286, 73, 0, 2, 'Cachoeira da Prata', '', 'cachoeira-da-prata', '', ''),
(10287, 73, 0, 2, 'Cachoeira de Minas', '', 'cachoeira-de-minas', '', ''),
(10288, 73, 0, 2, 'Cachoeira de Pajeú', '', 'cachoeira-de-pajeu', '', ''),
(10289, 73, 0, 2, 'Cachoeira Dourada', '', 'cachoeira-dourada', '', ''),
(10290, 73, 0, 2, 'Caetanópolis', '', 'caetanopolis', '', ''),
(10291, 73, 0, 2, 'Caeté', '', 'caete', '', ''),
(10292, 73, 0, 2, 'Caiana', '', 'caiana', '', ''),
(10293, 73, 0, 2, 'Cajuri', '', 'cajuri', '', ''),
(10294, 73, 0, 2, 'Caldas', '', 'caldas', '', ''),
(10295, 73, 0, 2, 'Camacho', '', 'camacho', '', ''),
(10296, 73, 0, 2, 'Camanducaia', '', 'camanducaia', '', ''),
(10297, 73, 0, 2, 'Cambuí', '', 'cambui', '', ''),
(10298, 73, 0, 2, 'Cambuquira', '', 'cambuquira', '', ''),
(10299, 73, 0, 2, 'Campanário', '', 'campanario', '', ''),
(10300, 73, 0, 2, 'Campanha', '', 'campanha', '', ''),
(10301, 73, 0, 2, 'Campestre', '', 'campestre', '', ''),
(10302, 73, 0, 2, 'Campina Verde', '', 'campina-verde', '', ''),
(10303, 73, 0, 2, 'Campo Azul', '', 'campo-azul', '', ''),
(10304, 73, 0, 2, 'Campo Belo', '', 'campo-belo', '', ''),
(10305, 73, 0, 2, 'Campo do Meio', '', 'campo-do-meio', '', ''),
(10306, 73, 0, 2, 'Campo Florido', '', 'campo-florido', '', ''),
(10307, 73, 0, 2, 'Campos Altos', '', 'campos-altos', '', ''),
(10308, 73, 0, 2, 'Campos Gerais', '', 'campos-gerais', '', ''),
(10309, 73, 0, 2, 'Cana Verde', '', 'cana-verde', '', ''),
(10310, 73, 0, 2, 'Canaã', '', 'canaa', '', ''),
(10311, 73, 0, 2, 'Canápolis', '', 'canapolis', '', ''),
(10312, 73, 0, 2, 'Candeias', '', 'candeias', '', ''),
(10313, 73, 0, 2, 'Cantagalo', '', 'cantagalo', '', ''),
(10314, 73, 0, 2, 'Caparaó', '', 'caparao', '', ''),
(10315, 73, 0, 2, 'Capela Nova', '', 'capela-nova', '', ''),
(10316, 73, 0, 2, 'Capelinha', '', 'capelinha', '', ''),
(10317, 73, 0, 2, 'Capetinga', '', 'capetinga', '', ''),
(10318, 73, 0, 2, 'Capim Branco', '', 'capim-branco', '', ''),
(10319, 73, 0, 2, 'Capinópolis', '', 'capinopolis', '', ''),
(10320, 73, 0, 2, 'Capitão Andrade', '', 'capitao-andrade', '', ''),
(10321, 73, 0, 2, 'Capitão Enéas', '', 'capitao-eneas', '', ''),
(10322, 73, 0, 2, 'Capitólio', '', 'capitolio', '', ''),
(10323, 73, 0, 2, 'Caputira', '', 'caputira', '', ''),
(10324, 73, 0, 2, 'Caraí', '', 'carai', '', ''),
(10325, 73, 0, 2, 'Caranaíba', '', 'caranaiba', '', ''),
(10326, 73, 0, 2, 'Carandaí', '', 'carandai', '', ''),
(10327, 73, 0, 2, 'Carangola', '', 'carangola', '', ''),
(10328, 73, 0, 2, 'Caratinga', '', 'caratinga', '', ''),
(10329, 73, 0, 2, 'Carbonita', '', 'carbonita', '', ''),
(10330, 73, 0, 2, 'Careaçu', '', 'careacu', '', ''),
(10331, 73, 0, 2, 'Carlos Chagas', '', 'carlos-chagas', '', ''),
(10332, 73, 0, 2, 'Carmésia', '', 'carmesia', '', ''),
(10333, 73, 0, 2, 'Carmo da Cachoeira', '', 'carmo-da-cachoeira', '', ''),
(10334, 73, 0, 2, 'Carmo da Mata', '', 'carmo-da-mata', '', ''),
(10335, 73, 0, 2, 'Carmo de Minas', '', 'carmo-de-minas', '', ''),
(10336, 73, 0, 2, 'Carmo do Cajuru', '', 'carmo-do-cajuru', '', ''),
(10337, 73, 0, 2, 'Carmo do Paranaíba', '', 'carmo-do-paranaiba', '', ''),
(10338, 73, 0, 2, 'Carmo do Rio Claro', '', 'carmo-do-rio-claro', '', ''),
(10339, 73, 0, 2, 'Carmópolis de Minas', '', 'carmopolis-de-minas', '', ''),
(10340, 73, 0, 2, 'Carneirinho', '', 'carneirinho', '', ''),
(10341, 73, 0, 2, 'Carrancas', '', 'carrancas', '', ''),
(10342, 73, 0, 2, 'Carvalhópolis', '', 'carvalhopolis', '', ''),
(10343, 73, 0, 2, 'Carvalhos', '', 'carvalhos', '', ''),
(10344, 73, 0, 2, 'Casa Grande', '', 'casa-grande', '', ''),
(10345, 73, 0, 2, 'Cascalho Rico', '', 'cascalho-rico', '', ''),
(10346, 73, 0, 2, 'Cássia', '', 'cassia', '', ''),
(10347, 73, 0, 2, 'Cataguases', '', 'cataguases', '', ''),
(10348, 73, 0, 2, 'Catas Altas', '', 'catas-altas', '', ''),
(10349, 73, 0, 2, 'Catas Altas da Noruega', '', 'catas-altas-da-noruega', '', ''),
(10350, 73, 0, 2, 'Catuji', '', 'catuji', '', ''),
(10351, 73, 0, 2, 'Catuti', '', 'catuti', '', ''),
(10352, 73, 0, 2, 'Caxambu', '', 'caxambu', '', ''),
(10353, 73, 0, 2, 'Cedro do Abaeté', '', 'cedro-do-abaete', '', ''),
(10354, 73, 0, 2, 'Central de Minas', '', 'central-de-minas', '', ''),
(10355, 73, 0, 2, 'Centralina', '', 'centralina', '', ''),
(10356, 73, 0, 2, 'Chácara', '', 'chacara', '', ''),
(10357, 73, 0, 2, 'Chalé', '', 'chale', '', ''),
(10358, 73, 0, 2, 'Chapada do Norte', '', 'chapada-do-norte', '', ''),
(10359, 73, 0, 2, 'Chapada Gaúcha', '', 'chapada-gaucha', '', ''),
(10360, 73, 0, 2, 'Chiador', '', 'chiador', '', ''),
(10361, 73, 0, 2, 'Cipotânea', '', 'cipotanea', '', ''),
(10362, 73, 0, 2, 'Claraval', '', 'claraval', '', ''),
(10363, 73, 0, 2, 'Claro dos Poções', '', 'claro-dos-pocoes', '', ''),
(10364, 73, 0, 2, 'Cláudio', '', 'claudio', '', ''),
(10365, 73, 0, 2, 'Coimbra', '', 'coimbra', '', ''),
(10366, 73, 0, 2, 'Coluna', '', 'coluna', '', ''),
(10367, 73, 0, 2, 'Comendador Gomes', '', 'comendador-gomes', '', ''),
(10368, 73, 0, 2, 'Comercinho', '', 'comercinho', '', ''),
(10369, 73, 0, 2, 'Conceição da Aparecida', '', 'conceicao-da-aparecida', '', ''),
(10370, 73, 0, 2, 'Conceição da Barra de Minas', '', 'conceicao-da-barra-de-minas', '', ''),
(10371, 73, 0, 2, 'Conceição das Alagoas', '', 'conceicao-das-alagoas', '', ''),
(10372, 73, 0, 2, 'Conceição das Pedras', '', 'conceicao-das-pedras', '', ''),
(10373, 73, 0, 2, 'Conceição de Ipanema', '', 'conceicao-de-ipanema', '', ''),
(10374, 73, 0, 2, 'Conceição do Mato Dentro', '', 'conceicao-do-mato-dentro', '', ''),
(10375, 73, 0, 2, 'Conceição do Pará', '', 'conceicao-do-para', '', ''),
(10376, 73, 0, 2, 'Conceição do Rio Verde', '', 'conceicao-do-rio-verde', '', ''),
(10377, 73, 0, 2, 'Conceição dos Ouros', '', 'conceicao-dos-ouros', '', ''),
(10378, 73, 0, 2, 'Cônego Marinho', '', 'conego-marinho', '', ''),
(10379, 73, 0, 2, 'Confins', '', 'confins', '', ''),
(10380, 73, 0, 2, 'Congonhal', '', 'congonhal', '', ''),
(10381, 73, 0, 2, 'Congonhas', '', 'congonhas', '', ''),
(10382, 73, 0, 2, 'Congonhas do Norte', '', 'congonhas-do-norte', '', ''),
(10383, 73, 0, 2, 'Conquista', '', 'conquista', '', ''),
(10384, 73, 0, 2, 'Conselheiro Lafaiete', '', 'conselheiro-lafaiete', '', ''),
(10385, 73, 0, 2, 'Conselheiro Pena', '', 'conselheiro-pena', '', ''),
(10386, 73, 0, 2, 'Consolação', '', 'consolacao', '', ''),
(10387, 73, 0, 2, 'Contagem', '', 'contagem', '', ''),
(10388, 73, 0, 2, 'Coqueiral', '', 'coqueiral', '', ''),
(10389, 73, 0, 2, 'Coração de Jesus', '', 'coracao-de-jesus', '', ''),
(10390, 73, 0, 2, 'Cordisburgo', '', 'cordisburgo', '', ''),
(10391, 73, 0, 2, 'Cordislândia', '', 'cordislandia', '', ''),
(10392, 73, 0, 2, 'Corinto', '', 'corinto', '', ''),
(10393, 73, 0, 2, 'Coroaci', '', 'coroaci', '', ''),
(10394, 73, 0, 2, 'Coromandel', '', 'coromandel', '', ''),
(10395, 73, 0, 2, 'Coronel Fabriciano', '', 'coronel-fabriciano', '', ''),
(10396, 73, 0, 2, 'Coronel Murta', '', 'coronel-murta', '', ''),
(10397, 73, 0, 2, 'Coronel Pacheco', '', 'coronel-pacheco', '', ''),
(10398, 73, 0, 2, 'Coronel Xavier Chaves', '', 'coronel-xavier-chaves', '', ''),
(10399, 73, 0, 2, 'Córrego Danta', '', 'corrego-danta', '', ''),
(10400, 73, 0, 2, 'Córrego do Bom Jesus', '', 'corrego-do-bom-jesus', '', ''),
(10401, 73, 0, 2, 'Córrego Fundo', '', 'corrego-fundo', '', ''),
(10402, 73, 0, 2, 'Córrego Novo', '', 'corrego-novo', '', ''),
(10403, 73, 0, 2, 'Couto de Magalhães de Minas', '', 'couto-de-magalhaes-de-minas', '', ''),
(10404, 73, 0, 2, 'Crisólita', '', 'crisolita', '', ''),
(10405, 73, 0, 2, 'Cristais', '', 'cristais', '', ''),
(10406, 73, 0, 2, 'Cristália', '', 'cristalia', '', ''),
(10407, 73, 0, 2, 'Cristiano Otoni', '', 'cristiano-otoni', '', ''),
(10408, 73, 0, 2, 'Cristina', '', 'cristina', '', ''),
(10409, 73, 0, 2, 'Crucilândia', '', 'crucilandia', '', ''),
(10410, 73, 0, 2, 'Cruzeiro da Fortaleza', '', 'cruzeiro-da-fortaleza', '', ''),
(10411, 73, 0, 2, 'Cruzília', '', 'cruzilia', '', ''),
(10412, 73, 0, 2, 'Cuparaque', '', 'cuparaque', '', ''),
(10413, 73, 0, 2, 'Curral de Dentro', '', 'curral-de-dentro', '', ''),
(10414, 73, 0, 2, 'Curvelo', '', 'curvelo', '', ''),
(10415, 73, 0, 2, 'Datas', '', 'datas', '', ''),
(10416, 73, 0, 2, 'Delfim Moreira', '', 'delfim-moreira', '', ''),
(10417, 73, 0, 2, 'Delfinópolis', '', 'delfinopolis', '', ''),
(10418, 73, 0, 2, 'Delta', '', 'delta', '', ''),
(10419, 73, 0, 2, 'Descoberto', '', 'descoberto', '', ''),
(10420, 73, 0, 2, 'Desterro de Entre Rios', '', 'desterro-de-entre-rios', '', ''),
(10421, 73, 0, 2, 'Desterro do Melo', '', 'desterro-do-melo', '', ''),
(10422, 73, 0, 2, 'Diamantina', '', 'diamantina', '', ''),
(10423, 73, 0, 2, 'Diogo de Vasconcelos', '', 'diogo-de-vasconcelos', '', ''),
(10424, 73, 0, 2, 'Dionísio', '', 'dionisio', '', ''),
(10425, 73, 0, 2, 'Divinésia', '', 'divinesia', '', ''),
(10426, 73, 0, 2, 'Divino', '', 'divino', '', ''),
(10427, 73, 0, 2, 'Divino das Laranjeiras', '', 'divino-das-laranjeiras', '', ''),
(10428, 73, 0, 2, 'Divinolândia de Minas', '', 'divinolandia-de-minas', '', ''),
(10429, 73, 0, 2, 'Divinópolis', '', 'divinopolis', '', ''),
(10430, 73, 0, 2, 'Divisa Alegre', '', 'divisa-alegre', '', ''),
(10431, 73, 0, 2, 'Divisa Nova', '', 'divisa-nova', '', ''),
(10432, 73, 0, 2, 'Divisópolis', '', 'divisopolis', '', ''),
(10433, 73, 0, 2, 'Dom Bosco', '', 'dom-bosco', '', ''),
(10434, 73, 0, 2, 'Dom Cavati', '', 'dom-cavati', '', ''),
(10435, 73, 0, 2, 'Dom Joaquim', '', 'dom-joaquim', '', ''),
(10436, 73, 0, 2, 'Dom Silvério', '', 'dom-silverio', '', ''),
(10437, 73, 0, 2, 'Dom Viçoso', '', 'dom-vicoso', '', ''),
(10438, 73, 0, 2, 'Dona Eusébia', '', 'dona-eusebia', '', ''),
(10439, 73, 0, 2, 'Dores de Campos', '', 'dores-de-campos', '', ''),
(10440, 73, 0, 2, 'Dores de Guanhães', '', 'dores-de-guanhaes', '', ''),
(10441, 73, 0, 2, 'Dores do Indaiá', '', 'dores-do-indaia', '', ''),
(10442, 73, 0, 2, 'Dores do Turvo', '', 'dores-do-turvo', '', ''),
(10443, 73, 0, 2, 'Doresópolis', '', 'doresopolis', '', ''),
(10444, 73, 0, 2, 'Douradoquara', '', 'douradoquara', '', ''),
(10445, 73, 0, 2, 'Durandé', '', 'durande', '', ''),
(10446, 73, 0, 2, 'Elói Mendes', '', 'eloi-mendes', '', ''),
(10447, 73, 0, 2, 'Engenheiro Caldas', '', 'engenheiro-caldas', '', ''),
(10448, 73, 0, 2, 'Engenheiro Navarro', '', 'engenheiro-navarro', '', ''),
(10449, 73, 0, 2, 'Entre Folhas', '', 'entre-folhas', '', ''),
(10450, 73, 0, 2, 'Entre Rios de Minas', '', 'entre-rios-de-minas', '', ''),
(10451, 73, 0, 2, 'Ervália', '', 'ervalia', '', ''),
(10452, 73, 0, 2, 'Esmeraldas', '', 'esmeraldas', '', ''),
(10453, 73, 0, 2, 'Espera Feliz', '', 'espera-feliz', '', ''),
(10454, 73, 0, 2, 'Espinosa', '', 'espinosa', '', ''),
(10455, 73, 0, 2, 'Espírito Santo do Dourado', '', 'espirito-santo-do-dourado', '', ''),
(10456, 73, 0, 2, 'Estiva', '', 'estiva', '', ''),
(10457, 73, 0, 2, 'Estrela Dalva', '', 'estrela-dalva', '', ''),
(10458, 73, 0, 2, 'Estrela do Indaiá', '', 'estrela-do-indaia', '', ''),
(10459, 73, 0, 2, 'Estrela do Sul', '', 'estrela-do-sul', '', ''),
(10460, 73, 0, 2, 'Eugenópolis', '', 'eugenopolis', '', ''),
(10461, 73, 0, 2, 'Ewbank da Câmara', '', 'ewbank-da-camara', '', ''),
(10462, 73, 0, 2, 'Extrema', '', 'extrema', '', ''),
(10463, 73, 0, 2, 'Fama', '', 'fama', '', ''),
(10464, 73, 0, 2, 'Faria Lemos', '', 'faria-lemos', '', ''),
(10465, 73, 0, 2, 'Felício dos Santos', '', 'felicio-dos-santos', '', ''),
(10466, 73, 0, 2, 'Felisburgo', '', 'felisburgo', '', ''),
(10467, 73, 0, 2, 'Felixlândia', '', 'felixlandia', '', ''),
(10468, 73, 0, 2, 'Fernandes Tourinho', '', 'fernandes-tourinho', '', ''),
(10469, 73, 0, 2, 'Ferros', '', 'ferros', '', ''),
(10470, 73, 0, 2, 'Fervedouro', '', 'fervedouro', '', ''),
(10471, 73, 0, 2, 'Florestal', '', 'florestal', '', ''),
(10472, 73, 0, 2, 'Formiga', '', 'formiga', '', ''),
(10473, 73, 0, 2, 'Formoso', '', 'formoso', '', ''),
(10474, 73, 0, 2, 'Fortaleza de Minas', '', 'fortaleza-de-minas', '', ''),
(10475, 73, 0, 2, 'Fortuna de Minas', '', 'fortuna-de-minas', '', ''),
(10476, 73, 0, 2, 'Francisco Badaró', '', 'francisco-badaro', '', ''),
(10477, 73, 0, 2, 'Francisco Dumont', '', 'francisco-dumont', '', ''),
(10478, 73, 0, 2, 'Francisco Sá', '', 'francisco-sa', '', ''),
(10479, 73, 0, 2, 'Franciscópolis', '', 'franciscopolis', '', ''),
(10480, 73, 0, 2, 'Frei Gaspar', '', 'frei-gaspar', '', ''),
(10481, 73, 0, 2, 'Frei Inocêncio', '', 'frei-inocencio', '', ''),
(10482, 73, 0, 2, 'Frei Lagonegro', '', 'frei-lagonegro', '', ''),
(10483, 73, 0, 2, 'Fronteira', '', 'fronteira', '', ''),
(10484, 73, 0, 2, 'Fronteira dos Vales', '', 'fronteira-dos-vales', '', ''),
(10485, 73, 0, 2, 'Fruta de Leite', '', 'fruta-de-leite', '', ''),
(10486, 73, 0, 2, 'Frutal', '', 'frutal', '', ''),
(10487, 73, 0, 2, 'Funilândia', '', 'funilandia', '', ''),
(10488, 73, 0, 2, 'Galiléia', '', 'galileia', '', ''),
(10489, 73, 0, 2, 'Gameleiras', '', 'gameleiras', '', ''),
(10490, 73, 0, 2, 'Glaucilândia', '', 'glaucilandia', '', ''),
(10491, 73, 0, 2, 'Goiabeira', '', 'goiabeira', '', ''),
(10492, 73, 0, 2, 'Goianá', '', 'goiana', '', ''),
(10493, 73, 0, 2, 'Gonçalves', '', 'goncalves', '', ''),
(10494, 73, 0, 2, 'Gonzaga', '', 'gonzaga', '', ''),
(10495, 73, 0, 2, 'Gouveia', '', 'gouveia', '', ''),
(10496, 73, 0, 2, 'Governador Valadares', '', 'governador-valadares', '', ''),
(10497, 73, 0, 2, 'Grão Mogol', '', 'grao-mogol', '', ''),
(10498, 73, 0, 2, 'Grupiara', '', 'grupiara', '', ''),
(10499, 73, 0, 2, 'Guanhães', '', 'guanhaes', '', ''),
(10500, 73, 0, 2, 'Guapé', '', 'guape', '', ''),
(10501, 73, 0, 2, 'Guaraciaba', '', 'guaraciaba', '', ''),
(10502, 73, 0, 2, 'Guaraciama', '', 'guaraciama', '', ''),
(10503, 73, 0, 2, 'Guaranésia', '', 'guaranesia', '', ''),
(10504, 73, 0, 2, 'Guarani', '', 'guarani', '', ''),
(10505, 73, 0, 2, 'Guarará', '', 'guarara', '', ''),
(10506, 73, 0, 2, 'Guarda-Mor', '', 'guarda-mor', '', ''),
(10507, 73, 0, 2, 'Guaxupé', '', 'guaxupe', '', ''),
(10508, 73, 0, 2, 'Guidoval', '', 'guidoval', '', ''),
(10509, 73, 0, 2, 'Guimarânia', '', 'guimarania', '', ''),
(10510, 73, 0, 2, 'Guiricema', '', 'guiricema', '', ''),
(10511, 73, 0, 2, 'Gurinhatã', '', 'gurinhata', '', ''),
(10512, 73, 0, 2, 'Heliodora', '', 'heliodora', '', ''),
(10513, 73, 0, 2, 'Iapu', '', 'iapu', '', ''),
(10514, 73, 0, 2, 'Ibertioga', '', 'ibertioga', '', ''),
(10515, 73, 0, 2, 'Ibiá', '', 'ibia', '', ''),
(10516, 73, 0, 2, 'Ibiaí', '', 'ibiai', '', ''),
(10517, 73, 0, 2, 'Ibiracatu', '', 'ibiracatu', '', ''),
(10518, 73, 0, 2, 'Ibiraci', '', 'ibiraci', '', ''),
(10519, 73, 0, 2, 'Ibirité', '', 'ibirite', '', ''),
(10520, 73, 0, 2, 'Ibitiúra de Minas', '', 'ibitiura-de-minas', '', ''),
(10521, 73, 0, 2, 'Ibituruna', '', 'ibituruna', '', ''),
(10522, 73, 0, 2, 'Icaraí de Minas', '', 'icarai-de-minas', '', ''),
(10523, 73, 0, 2, 'Igarapé', '', 'igarape', '', ''),
(10524, 73, 0, 2, 'Igaratinga', '', 'igaratinga', '', ''),
(10525, 73, 0, 2, 'Iguatama', '', 'iguatama', '', ''),
(10526, 73, 0, 2, 'Ijaci', '', 'ijaci', '', ''),
(10527, 73, 0, 2, 'Ilicínea', '', 'ilicinea', '', ''),
(10528, 73, 0, 2, 'Imbé de Minas', '', 'imbe-de-minas', '', ''),
(10529, 73, 0, 2, 'Inconfidentes', '', 'inconfidentes', '', ''),
(10530, 73, 0, 2, 'Indaiabira', '', 'indaiabira', '', ''),
(10531, 73, 0, 2, 'Indianópolis', '', 'indianopolis', '', ''),
(10532, 73, 0, 2, 'Ingaí', '', 'ingai', '', ''),
(10533, 73, 0, 2, 'Inhapim', '', 'inhapim', '', ''),
(10534, 73, 0, 2, 'Inhaúma', '', 'inhauma', '', ''),
(10535, 73, 0, 2, 'Inimutaba', '', 'inimutaba', '', ''),
(10536, 73, 0, 2, 'Ipaba', '', 'ipaba', '', ''),
(10537, 73, 0, 2, 'Ipanema', '', 'ipanema', '', ''),
(10538, 73, 0, 2, 'Ipatinga', '', 'ipatinga', '', ''),
(10539, 73, 0, 2, 'Ipiaçu', '', 'ipiacu', '', ''),
(10540, 73, 0, 2, 'Ipuiúna', '', 'ipuiuna', '', ''),
(10541, 73, 0, 2, 'Iraí de Minas', '', 'irai-de-minas', '', ''),
(10542, 73, 0, 2, 'Itabira', '', 'itabira', '', ''),
(10543, 73, 0, 2, 'Itabirinha de Mantena', '', 'itabirinha-de-mantena', '', ''),
(10544, 73, 0, 2, 'Itabirito', '', 'itabirito', '', ''),
(10545, 73, 0, 2, 'Itacambira', '', 'itacambira', '', ''),
(10546, 73, 0, 2, 'Itacarambi', '', 'itacarambi', '', ''),
(10547, 73, 0, 2, 'Itaguara', '', 'itaguara', '', ''),
(10548, 73, 0, 2, 'Itaipé', '', 'itaipe', '', ''),
(10549, 73, 0, 2, 'Itajubá', '', 'itajuba', '', ''),
(10550, 73, 0, 2, 'Itamarandiba', '', 'itamarandiba', '', ''),
(10551, 73, 0, 2, 'Itamarati de Minas', '', 'itamarati-de-minas', '', ''),
(10552, 73, 0, 2, 'Itambacuri', '', 'itambacuri', '', ''),
(10553, 73, 0, 2, 'Itambé do Mato Dentro', '', 'itambe-do-mato-dentro', '', ''),
(10554, 73, 0, 2, 'Itamogi', '', 'itamogi', '', ''),
(10555, 73, 0, 2, 'Itamonte', '', 'itamonte', '', ''),
(10556, 73, 0, 2, 'Itanhandu', '', 'itanhandu', '', ''),
(10557, 73, 0, 2, 'Itanhomi', '', 'itanhomi', '', ''),
(10558, 73, 0, 2, 'Itaobim', '', 'itaobim', '', ''),
(10559, 73, 0, 2, 'Itapagipe', '', 'itapagipe', '', ''),
(10560, 73, 0, 2, 'Itapecerica', '', 'itapecerica', '', ''),
(10561, 73, 0, 2, 'Itapeva', '', 'itapeva', '', ''),
(10562, 73, 0, 2, 'Itatiaiuçu', '', 'itatiaiucu', '', ''),
(10563, 73, 0, 2, 'Itaú de Minas', '', 'itau-de-minas', '', ''),
(10564, 73, 0, 2, 'Itaúna', '', 'itauna', '', ''),
(10565, 73, 0, 2, 'Itaverava', '', 'itaverava', '', ''),
(10566, 73, 0, 2, 'Itinga', '', 'itinga', '', ''),
(10567, 73, 0, 2, 'Itueta', '', 'itueta', '', ''),
(10568, 73, 0, 2, 'Ituiutaba', '', 'ituiutaba', '', ''),
(10569, 73, 0, 2, 'Itumirim', '', 'itumirim', '', ''),
(10570, 73, 0, 2, 'Iturama', '', 'iturama', '', ''),
(10571, 73, 0, 2, 'Itutinga', '', 'itutinga', '', ''),
(10572, 73, 0, 2, 'Jaboticatubas', '', 'jaboticatubas', '', ''),
(10573, 73, 0, 2, 'Jacinto', '', 'jacinto', '', ''),
(10574, 73, 0, 2, 'Jacuí', '', 'jacui', '', ''),
(10575, 73, 0, 2, 'Jacutinga', '', 'jacutinga', '', ''),
(10576, 73, 0, 2, 'Jaguaraçu', '', 'jaguaracu', '', ''),
(10577, 73, 0, 2, 'Jaíba', '', 'jaiba', '', ''),
(10578, 73, 0, 2, 'Jampruca', '', 'jampruca', '', ''),
(10579, 73, 0, 2, 'Janaúba', '', 'janauba', '', ''),
(10580, 73, 0, 2, 'Januária', '', 'januaria', '', ''),
(10581, 73, 0, 2, 'Japaraíba', '', 'japaraiba', '', ''),
(10582, 73, 0, 2, 'Japonvar', '', 'japonvar', '', ''),
(10583, 73, 0, 2, 'Jeceaba', '', 'jeceaba', '', ''),
(10584, 73, 0, 2, 'Jenipapo de Minas', '', 'jenipapo-de-minas', '', ''),
(10585, 73, 0, 2, 'Jequeri', '', 'jequeri', '', ''),
(10586, 73, 0, 2, 'Jequitaí', '', 'jequitai', '', ''),
(10587, 73, 0, 2, 'Jequitibá', '', 'jequitiba', '', ''),
(10588, 73, 0, 2, 'Jequitinhonha', '', 'jequitinhonha', '', ''),
(10589, 73, 0, 2, 'Jesuânia', '', 'jesuania', '', ''),
(10590, 73, 0, 2, 'Joaíma', '', 'joaima', '', ''),
(10591, 73, 0, 2, 'Joanésia', '', 'joanesia', '', ''),
(10592, 73, 0, 2, 'João Monlevade', '', 'joao-monlevade', '', ''),
(10593, 73, 0, 2, 'João Pinheiro', '', 'joao-pinheiro', '', ''),
(10594, 73, 0, 2, 'Joaquim Felício', '', 'joaquim-felicio', '', ''),
(10595, 73, 0, 2, 'Jordânia', '', 'jordania', '', ''),
(10596, 73, 0, 2, 'José Gonçalves de Minas', '', 'jose-goncalves-de-minas', '', ''),
(10597, 73, 0, 2, 'José Raydan', '', 'jose-raydan', '', ''),
(10598, 73, 0, 2, 'Josenópolis', '', 'josenopolis', '', ''),
(10599, 73, 0, 2, 'Juatuba', '', 'juatuba', '', ''),
(10600, 73, 0, 2, 'Juiz de Fora', '', 'juiz-de-fora', '', ''),
(10601, 73, 0, 2, 'Juramento', '', 'juramento', '', ''),
(10602, 73, 0, 2, 'Juruaia', '', 'juruaia', '', ''),
(10603, 73, 0, 2, 'Juvenília', '', 'juvenilia', '', ''),
(10604, 73, 0, 2, 'Ladainha', '', 'ladainha', '', ''),
(10605, 73, 0, 2, 'Lagamar', '', 'lagamar', '', ''),
(10606, 73, 0, 2, 'Lagoa da Prata', '', 'lagoa-da-prata', '', ''),
(10607, 73, 0, 2, 'Lagoa dos Patos', '', 'lagoa-dos-patos', '', ''),
(10608, 73, 0, 2, 'Lagoa Dourada', '', 'lagoa-dourada', '', ''),
(10609, 73, 0, 2, 'Lagoa Formosa', '', 'lagoa-formosa', '', ''),
(10610, 73, 0, 2, 'Lagoa Grande', '', 'lagoa-grande', '', ''),
(10611, 73, 0, 2, 'Lagoa Santa', '', 'lagoa-santa', '', ''),
(10612, 73, 0, 2, 'Lajinha', '', 'lajinha', '', ''),
(10613, 73, 0, 2, 'Lambari', '', 'lambari', '', ''),
(10614, 73, 0, 2, 'Lamim', '', 'lamim', '', ''),
(10615, 73, 0, 2, 'Laranjal', '', 'laranjal', '', ''),
(10616, 73, 0, 2, 'Lassance', '', 'lassance', '', ''),
(10617, 73, 0, 2, 'Lavras', '', 'lavras', '', ''),
(10618, 73, 0, 2, 'Leandro Ferreira', '', 'leandro-ferreira', '', ''),
(10619, 73, 0, 2, 'Leme do Prado', '', 'leme-do-prado', '', ''),
(10620, 73, 0, 2, 'Leopoldina', '', 'leopoldina', '', ''),
(10621, 73, 0, 2, 'Liberdade', '', 'liberdade', '', ''),
(10622, 73, 0, 2, 'Lima Duarte', '', 'lima-duarte', '', ''),
(10623, 73, 0, 2, 'Limeira do Oeste', '', 'limeira-do-oeste', '', ''),
(10624, 73, 0, 2, 'Lontra', '', 'lontra', '', ''),
(10625, 73, 0, 2, 'Luisburgo', '', 'luisburgo', '', ''),
(10626, 73, 0, 2, 'Luislândia', '', 'luislandia', '', ''),
(10627, 73, 0, 2, 'Luminárias', '', 'luminarias', '', ''),
(10628, 73, 0, 2, 'Luz', '', 'luz', '', ''),
(10629, 73, 0, 2, 'Machacalis', '', 'machacalis', '', ''),
(10630, 73, 0, 2, 'Machado', '', 'machado', '', ''),
(10631, 73, 0, 2, 'Madre de Deus de Minas', '', 'madre-de-deus-de-minas', '', ''),
(10632, 73, 0, 2, 'Malacacheta', '', 'malacacheta', '', ''),
(10633, 73, 0, 2, 'Mamonas', '', 'mamonas', '', ''),
(10634, 73, 0, 2, 'Manga', '', 'manga', '', ''),
(10635, 73, 0, 2, 'Manhuaçu', '', 'manhuacu', '', ''),
(10636, 73, 0, 2, 'Manhumirim', '', 'manhumirim', '', ''),
(10637, 73, 0, 2, 'Mantena', '', 'mantena', '', ''),
(10638, 73, 0, 2, 'Mar de Espanha', '', 'mar-de-espanha', '', ''),
(10639, 73, 0, 2, 'Maravilhas', '', 'maravilhas', '', ''),
(10640, 73, 0, 2, 'Maria da Fé', '', 'maria-da-fe', '', ''),
(10641, 73, 0, 2, 'Mariana', '', 'mariana', '', ''),
(10642, 73, 0, 2, 'Marilac', '', 'marilac', '', ''),
(10643, 73, 0, 2, 'Mário Campos', '', 'mario-campos', '', ''),
(10644, 73, 0, 2, 'Maripá de Minas', '', 'maripa-de-minas', '', ''),
(10645, 73, 0, 2, 'Marliéria', '', 'marlieria', '', ''),
(10646, 73, 0, 2, 'Marmelópolis', '', 'marmelopolis', '', ''),
(10647, 73, 0, 2, 'Martinho Campos', '', 'martinho-campos', '', ''),
(10648, 73, 0, 2, 'Martins Soares', '', 'martins-soares', '', ''),
(10649, 73, 0, 2, 'Mata Verde', '', 'mata-verde', '', ''),
(10650, 73, 0, 2, 'Materlândia', '', 'materlandia', '', ''),
(10651, 73, 0, 2, 'Mateus Leme', '', 'mateus-leme', '', ''),
(10652, 73, 0, 2, 'Mathias Lobato', '', 'mathias-lobato', '', ''),
(10653, 73, 0, 2, 'Matias Barbosa', '', 'matias-barbosa', '', ''),
(10654, 73, 0, 2, 'Matias Cardoso', '', 'matias-cardoso', '', ''),
(10655, 73, 0, 2, 'Matipó', '', 'matipo', '', ''),
(10656, 73, 0, 2, 'Mato Verde', '', 'mato-verde', '', ''),
(10657, 73, 0, 2, 'Matozinhos', '', 'matozinhos', '', ''),
(10658, 73, 0, 2, 'Matutina', '', 'matutina', '', ''),
(10659, 73, 0, 2, 'Medeiros', '', 'medeiros', '', ''),
(10660, 73, 0, 2, 'Medina', '', 'medina', '', ''),
(10661, 73, 0, 2, 'Mendes Pimentel', '', 'mendes-pimentel', '', ''),
(10662, 73, 0, 2, 'Mercês', '', 'merces', '', ''),
(10663, 73, 0, 2, 'Mesquita', '', 'mesquita', '', ''),
(10664, 73, 0, 2, 'Minas Novas', '', 'minas-novas', '', ''),
(10665, 73, 0, 2, 'Minduri', '', 'minduri', '', ''),
(10666, 73, 0, 2, 'Mirabela', '', 'mirabela', '', ''),
(10667, 73, 0, 2, 'Miradouro', '', 'miradouro', '', ''),
(10668, 73, 0, 2, 'Miraí', '', 'mirai', '', ''),
(10669, 73, 0, 2, 'Miravânia', '', 'miravania', '', ''),
(10670, 73, 0, 2, 'Moeda', '', 'moeda', '', ''),
(10671, 73, 0, 2, 'Moema', '', 'moema', '', ''),
(10672, 73, 0, 2, 'Monjolos', '', 'monjolos', '', ''),
(10673, 73, 0, 2, 'Monsenhor Paulo', '', 'monsenhor-paulo', '', ''),
(10674, 73, 0, 2, 'Montalvânia', '', 'montalvania', '', ''),
(10675, 73, 0, 2, 'Monte Alegre de Minas', '', 'monte-alegre-de-minas', '', ''),
(10676, 73, 0, 2, 'Monte Azul', '', 'monte-azul', '', ''),
(10677, 73, 0, 2, 'Monte Belo', '', 'monte-belo', '', ''),
(10678, 73, 0, 2, 'Monte Carmelo', '', 'monte-carmelo', '', ''),
(10679, 73, 0, 2, 'Monte Formoso', '', 'monte-formoso', '', ''),
(10680, 73, 0, 2, 'Monte Santo de Minas', '', 'monte-santo-de-minas', '', ''),
(10681, 73, 0, 2, 'Monte Sião', '', 'monte-siao', '', ''),
(10682, 73, 0, 2, 'Montes Claros', '', 'montes-claros', '', ''),
(10683, 73, 0, 2, 'Montezuma', '', 'montezuma', '', ''),
(10684, 73, 0, 2, 'Morada Nova de Minas', '', 'morada-nova-de-minas', '', ''),
(10685, 73, 0, 2, 'Morro da Garça', '', 'morro-da-garca', '', ''),
(10686, 73, 0, 2, 'Morro do Pilar', '', 'morro-do-pilar', '', ''),
(10687, 73, 0, 2, 'Munhoz', '', 'munhoz', '', ''),
(10688, 73, 0, 2, 'Muriaé', '', 'muriae', '', ''),
(10689, 73, 0, 2, 'Mutum', '', 'mutum', '', ''),
(10690, 73, 0, 2, 'Muzambinho', '', 'muzambinho', '', ''),
(10691, 73, 0, 2, 'Nacip Raydan', '', 'nacip-raydan', '', ''),
(10692, 73, 0, 2, 'Nanuque', '', 'nanuque', '', ''),
(10693, 73, 0, 2, 'Naque', '', 'naque', '', ''),
(10694, 73, 0, 2, 'Natalândia', '', 'natalandia', '', ''),
(10695, 73, 0, 2, 'Natércia', '', 'natercia', '', ''),
(10696, 73, 0, 2, 'Nazareno', '', 'nazareno', '', ''),
(10697, 73, 0, 2, 'Nepomuceno', '', 'nepomuceno', '', ''),
(10698, 73, 0, 2, 'Ninheira', '', 'ninheira', '', ''),
(10699, 73, 0, 2, 'Nova Belém', '', 'nova-belem', '', ''),
(10700, 73, 0, 2, 'Nova Era', '', 'nova-era', '', ''),
(10701, 73, 0, 2, 'Nova Lima', '', 'nova-lima', '', ''),
(10702, 73, 0, 2, 'Nova Módica', '', 'nova-modica', '', ''),
(10703, 73, 0, 2, 'Nova Ponte', '', 'nova-ponte', '', ''),
(10704, 73, 0, 2, 'Nova Porteirinha', '', 'nova-porteirinha', '', ''),
(10705, 73, 0, 2, 'Nova Resende', '', 'nova-resende', '', ''),
(10706, 73, 0, 2, 'Nova Serrana', '', 'nova-serrana', '', ''),
(10707, 73, 0, 2, 'Nova União', '', 'nova-uniao', '', ''),
(10708, 73, 0, 2, 'Novo Cruzeiro', '', 'novo-cruzeiro', '', ''),
(10709, 73, 0, 2, 'Novo Oriente de Minas', '', 'novo-oriente-de-minas', '', ''),
(10710, 73, 0, 2, 'Novorizonte', '', 'novorizonte', '', ''),
(10711, 73, 0, 2, 'Olaria', '', 'olaria', '', ''),
(10712, 73, 0, 2, 'Olhos-d`Água', '', 'olhos-d`agua', '', ''),
(10713, 73, 0, 2, 'Olímpio Noronha', '', 'olimpio-noronha', '', ''),
(10714, 73, 0, 2, 'Oliveira', '', 'oliveira', '', ''),
(10715, 73, 0, 2, 'Oliveira Fortes', '', 'oliveira-fortes', '', ''),
(10716, 73, 0, 2, 'Onça de Pitangui', '', 'onca-de-pitangui', '', ''),
(10717, 73, 0, 2, 'Oratórios', '', 'oratorios', '', ''),
(10718, 73, 0, 2, 'Orizânia', '', 'orizania', '', ''),
(10719, 73, 0, 2, 'Ouro Branco', '', 'ouro-branco', '', ''),
(10720, 73, 0, 2, 'Ouro Fino', '', 'ouro-fino', '', ''),
(10721, 73, 0, 2, 'Ouro Preto', '', 'ouro-preto', '', ''),
(10722, 73, 0, 2, 'Ouro Verde de Minas', '', 'ouro-verde-de-minas', '', ''),
(10723, 73, 0, 2, 'Padre Carvalho', '', 'padre-carvalho', '', ''),
(10724, 73, 0, 2, 'Padre Paraíso', '', 'padre-paraiso', '', ''),
(10725, 73, 0, 2, 'Pai Pedro', '', 'pai-pedro', '', ''),
(10726, 73, 0, 2, 'Paineiras', '', 'paineiras', '', ''),
(10727, 73, 0, 2, 'Pains', '', 'pains', '', ''),
(10728, 73, 0, 2, 'Paiva', '', 'paiva', '', ''),
(10729, 73, 0, 2, 'Palma', '', 'palma', '', ''),
(10730, 73, 0, 2, 'Palmópolis', '', 'palmopolis', '', ''),
(10731, 73, 0, 2, 'Papagaios', '', 'papagaios', '', ''),
(10732, 73, 0, 2, 'Pará de Minas', '', 'para-de-minas', '', ''),
(10733, 73, 0, 2, 'Paracatu', '', 'paracatu', '', ''),
(10734, 73, 0, 2, 'Paraguaçu', '', 'paraguacu', '', ''),
(10735, 73, 0, 2, 'Paraisópolis', '', 'paraisopolis', '', ''),
(10736, 73, 0, 2, 'Paraopeba', '', 'paraopeba', '', ''),
(10737, 73, 0, 2, 'Passa Quatro', '', 'passa-quatro', '', ''),
(10738, 73, 0, 2, 'Passa Tempo', '', 'passa-tempo', '', ''),
(10739, 73, 0, 2, 'Passa-Vinte', '', 'passa-vinte', '', ''),
(10740, 73, 0, 2, 'Passabém', '', 'passabem', '', ''),
(10741, 73, 0, 2, 'Passos', '', 'passos', '', ''),
(10742, 73, 0, 2, 'Patis', '', 'patis', '', ''),
(10743, 73, 0, 2, 'Patos de Minas', '', 'patos-de-minas', '', ''),
(10744, 73, 0, 2, 'Patrocínio', '', 'patrocinio', '', ''),
(10745, 73, 0, 2, 'Patrocínio do Muriaé', '', 'patrocinio-do-muriae', '', ''),
(10746, 73, 0, 2, 'Paula Cândido', '', 'paula-candido', '', ''),
(10747, 73, 0, 2, 'Paulistas', '', 'paulistas', '', ''),
(10748, 73, 0, 2, 'Pavão', '', 'pavao', '', ''),
(10749, 73, 0, 2, 'Peçanha', '', 'pecanha', '', ''),
(10750, 73, 0, 2, 'Pedra Azul', '', 'pedra-azul', '', ''),
(10751, 73, 0, 2, 'Pedra Bonita', '', 'pedra-bonita', '', ''),
(10752, 73, 0, 2, 'Pedra do Anta', '', 'pedra-do-anta', '', ''),
(10753, 73, 0, 2, 'Pedra do Indaiá', '', 'pedra-do-indaia', '', ''),
(10754, 73, 0, 2, 'Pedra Dourada', '', 'pedra-dourada', '', ''),
(10755, 73, 0, 2, 'Pedralva', '', 'pedralva', '', ''),
(10756, 73, 0, 2, 'Pedras de Maria da Cruz', '', 'pedras-de-maria-da-cruz', '', ''),
(10757, 73, 0, 2, 'Pedrinópolis', '', 'pedrinopolis', '', ''),
(10758, 73, 0, 2, 'Pedro Leopoldo', '', 'pedro-leopoldo', '', ''),
(10759, 73, 0, 2, 'Pedro Teixeira', '', 'pedro-teixeira', '', ''),
(10760, 73, 0, 2, 'Pequeri', '', 'pequeri', '', ''),
(10761, 73, 0, 2, 'Pequi', '', 'pequi', '', ''),
(10762, 73, 0, 2, 'Perdigão', '', 'perdigao', '', ''),
(10763, 73, 0, 2, 'Perdizes', '', 'perdizes', '', ''),
(10764, 73, 0, 2, 'Perdões', '', 'perdoes', '', ''),
(10765, 73, 0, 2, 'Periquito', '', 'periquito', '', ''),
(10766, 73, 0, 2, 'Pescador', '', 'pescador', '', ''),
(10767, 73, 0, 2, 'Piau', '', 'piau', '', ''),
(10768, 73, 0, 2, 'Piedade de Caratinga', '', 'piedade-de-caratinga', '', ''),
(10769, 73, 0, 2, 'Piedade de Ponte Nova', '', 'piedade-de-ponte-nova', '', ''),
(10770, 73, 0, 2, 'Piedade do Rio Grande', '', 'piedade-do-rio-grande', '', ''),
(10771, 73, 0, 2, 'Piedade dos Gerais', '', 'piedade-dos-gerais', '', ''),
(10772, 73, 0, 2, 'Pimenta', '', 'pimenta', '', ''),
(10773, 73, 0, 2, 'Pingo-d`Água', '', 'pingo-d`agua', '', ''),
(10774, 73, 0, 2, 'Pintópolis', '', 'pintopolis', '', ''),
(10775, 73, 0, 2, 'Piracema', '', 'piracema', '', ''),
(10776, 73, 0, 2, 'Pirajuba', '', 'pirajuba', '', ''),
(10777, 73, 0, 2, 'Piranga', '', 'piranga', '', ''),
(10778, 73, 0, 2, 'Piranguçu', '', 'pirangucu', '', ''),
(10779, 73, 0, 2, 'Piranguinho', '', 'piranguinho', '', ''),
(10780, 73, 0, 2, 'Pirapetinga', '', 'pirapetinga', '', ''),
(10781, 73, 0, 2, 'Pirapora', '', 'pirapora', '', ''),
(10782, 73, 0, 2, 'Piraúba', '', 'pirauba', '', ''),
(10783, 73, 0, 2, 'Pitangui', '', 'pitangui', '', ''),
(10784, 73, 0, 2, 'Piumhi', '', 'piumhi', '', ''),
(10785, 73, 0, 2, 'Planura', '', 'planura', '', ''),
(10786, 73, 0, 2, 'Poço Fundo', '', 'poco-fundo', '', ''),
(10787, 73, 0, 2, 'Poços de Caldas', '', 'pocos-de-caldas', '', ''),
(10788, 73, 0, 2, 'Pocrane', '', 'pocrane', '', ''),
(10789, 73, 0, 2, 'Pompéu', '', 'pompeu', '', ''),
(10790, 73, 0, 2, 'Ponte Nova', '', 'ponte-nova', '', ''),
(10791, 73, 0, 2, 'Ponto Chique', '', 'ponto-chique', '', ''),
(10792, 73, 0, 2, 'Ponto dos Volantes', '', 'ponto-dos-volantes', '', ''),
(10793, 73, 0, 2, 'Porteirinha', '', 'porteirinha', '', ''),
(10794, 73, 0, 2, 'Porto Firme', '', 'porto-firme', '', ''),
(10795, 73, 0, 2, 'Poté', '', 'pote', '', ''),
(10796, 73, 0, 2, 'Pouso Alegre', '', 'pouso-alegre', '', ''),
(10797, 73, 0, 2, 'Pouso Alto', '', 'pouso-alto', '', ''),
(10798, 73, 0, 2, 'Prados', '', 'prados', '', ''),
(10799, 73, 0, 2, 'Prata', '', 'prata', '', ''),
(10800, 73, 0, 2, 'Pratápolis', '', 'pratapolis', '', ''),
(10801, 73, 0, 2, 'Pratinha', '', 'pratinha', '', ''),
(10802, 73, 0, 2, 'Presidente Bernardes', '', 'presidente-bernardes', '', ''),
(10803, 73, 0, 2, 'Presidente Juscelino', '', 'presidente-juscelino', '', ''),
(10804, 73, 0, 2, 'Presidente Kubitschek', '', 'presidente-kubitschek', '', ''),
(10805, 73, 0, 2, 'Presidente Olegário', '', 'presidente-olegario', '', ''),
(10806, 73, 0, 2, 'Prudente de Morais', '', 'prudente-de-morais', '', ''),
(10807, 73, 0, 2, 'Quartel Geral', '', 'quartel-geral', '', ''),
(10808, 73, 0, 2, 'Queluzito', '', 'queluzito', '', ''),
(10809, 73, 0, 2, 'Raposos', '', 'raposos', '', ''),
(10810, 73, 0, 2, 'Raul Soares', '', 'raul-soares', '', ''),
(10811, 73, 0, 2, 'Recreio', '', 'recreio', '', ''),
(10812, 73, 0, 2, 'Reduto', '', 'reduto', '', ''),
(10813, 73, 0, 2, 'Resende Costa', '', 'resende-costa', '', ''),
(10814, 73, 0, 2, 'Resplendor', '', 'resplendor', '', ''),
(10815, 73, 0, 2, 'Ressaquinha', '', 'ressaquinha', '', ''),
(10816, 73, 0, 2, 'Riachinho', '', 'riachinho', '', ''),
(10817, 73, 0, 2, 'Riacho dos Machados', '', 'riacho-dos-machados', '', ''),
(10818, 73, 0, 2, 'Ribeirão das Neves', '', 'ribeirao-das-neves', '', ''),
(10819, 73, 0, 2, 'Ribeirão Vermelho', '', 'ribeirao-vermelho', '', ''),
(10820, 73, 0, 2, 'Rio Acima', '', 'rio-acima', '', ''),
(10821, 73, 0, 2, 'Rio Casca', '', 'rio-casca', '', ''),
(10822, 73, 0, 2, 'Rio do Prado', '', 'rio-do-prado', '', ''),
(10823, 73, 0, 2, 'Rio Doce', '', 'rio-doce', '', ''),
(10824, 73, 0, 2, 'Rio Espera', '', 'rio-espera', '', ''),
(10825, 73, 0, 2, 'Rio Manso', '', 'rio-manso', '', ''),
(10826, 73, 0, 2, 'Rio Novo', '', 'rio-novo', '', ''),
(10827, 73, 0, 2, 'Rio Paranaíba', '', 'rio-paranaiba', '', ''),
(10828, 73, 0, 2, 'Rio Pardo de Minas', '', 'rio-pardo-de-minas', '', ''),
(10829, 73, 0, 2, 'Rio Piracicaba', '', 'rio-piracicaba', '', ''),
(10830, 73, 0, 2, 'Rio Pomba', '', 'rio-pomba', '', ''),
(10831, 73, 0, 2, 'Rio Preto', '', 'rio-preto', '', ''),
(10832, 73, 0, 2, 'Rio Vermelho', '', 'rio-vermelho', '', ''),
(10833, 73, 0, 2, 'Ritápolis', '', 'ritapolis', '', ''),
(10834, 73, 0, 2, 'Rochedo de Minas', '', 'rochedo-de-minas', '', ''),
(10835, 73, 0, 2, 'Rodeiro', '', 'rodeiro', '', ''),
(10836, 73, 0, 2, 'Romaria', '', 'romaria', '', ''),
(10837, 73, 0, 2, 'Rosário da Limeira', '', 'rosario-da-limeira', '', ''),
(10838, 73, 0, 2, 'Rubelita', '', 'rubelita', '', ''),
(10839, 73, 0, 2, 'Rubim', '', 'rubim', '', ''),
(10840, 73, 0, 2, 'Sabará', '', 'sabara', '', ''),
(10841, 73, 0, 2, 'Sabinópolis', '', 'sabinopolis', '', ''),
(10842, 73, 0, 2, 'Sacramento', '', 'sacramento', '', ''),
(10843, 73, 0, 2, 'Salinas', '', 'salinas', '', ''),
(10844, 73, 0, 2, 'Salto da Divisa', '', 'salto-da-divisa', '', ''),
(10845, 73, 0, 2, 'Santa Bárbara', '', 'santa-barbara', '', ''),
(10846, 73, 0, 2, 'Santa Bárbara do Leste', '', 'santa-barbara-do-leste', '', ''),
(10847, 73, 0, 2, 'Santa Bárbara do Monte Verde', '', 'santa-barbara-do-monte-verde', '', ''),
(10848, 73, 0, 2, 'Santa Bárbara do Tugúrio', '', 'santa-barbara-do-tugurio', '', ''),
(10849, 73, 0, 2, 'Santa Cruz de Minas', '', 'santa-cruz-de-minas', '', ''),
(10850, 73, 0, 2, 'Santa Cruz de Salinas', '', 'santa-cruz-de-salinas', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(10851, 73, 0, 2, 'Santa Cruz do Escalvado', '', 'santa-cruz-do-escalvado', '', ''),
(10852, 73, 0, 2, 'Santa Efigênia de Minas', '', 'santa-efigenia-de-minas', '', ''),
(10853, 73, 0, 2, 'Santa Fé de Minas', '', 'santa-fe-de-minas', '', ''),
(10854, 73, 0, 2, 'Santa Helena de Minas', '', 'santa-helena-de-minas', '', ''),
(10855, 73, 0, 2, 'Santa Juliana', '', 'santa-juliana', '', ''),
(10856, 73, 0, 2, 'Santa Luzia', '', 'santa-luzia', '', ''),
(10857, 73, 0, 2, 'Santa Margarida', '', 'santa-margarida', '', ''),
(10858, 73, 0, 2, 'Santa Maria de Itabira', '', 'santa-maria-de-itabira', '', ''),
(10859, 73, 0, 2, 'Santa Maria do Salto', '', 'santa-maria-do-salto', '', ''),
(10860, 73, 0, 2, 'Santa Maria do Suaçuí', '', 'santa-maria-do-suacui', '', ''),
(10861, 73, 0, 2, 'Santa Rita de Caldas', '', 'santa-rita-de-caldas', '', ''),
(10862, 73, 0, 2, 'Santa Rita de Ibitipoca', '', 'santa-rita-de-ibitipoca', '', ''),
(10863, 73, 0, 2, 'Santa Rita de Jacutinga', '', 'santa-rita-de-jacutinga', '', ''),
(10864, 73, 0, 2, 'Santa Rita de Minas', '', 'santa-rita-de-minas', '', ''),
(10865, 73, 0, 2, 'Santa Rita do Itueto', '', 'santa-rita-do-itueto', '', ''),
(10866, 73, 0, 2, 'Santa Rita do Sapucaí', '', 'santa-rita-do-sapucai', '', ''),
(10867, 73, 0, 2, 'Santa Rosa da Serra', '', 'santa-rosa-da-serra', '', ''),
(10868, 73, 0, 2, 'Santa Vitória', '', 'santa-vitoria', '', ''),
(10869, 73, 0, 2, 'Santana da Vargem', '', 'santana-da-vargem', '', ''),
(10870, 73, 0, 2, 'Santana de Cataguases', '', 'santana-de-cataguases', '', ''),
(10871, 73, 0, 2, 'Santana de Pirapama', '', 'santana-de-pirapama', '', ''),
(10872, 73, 0, 2, 'Santana do Deserto', '', 'santana-do-deserto', '', ''),
(10873, 73, 0, 2, 'Santana do Garambéu', '', 'santana-do-garambeu', '', ''),
(10874, 73, 0, 2, 'Santana do Jacaré', '', 'santana-do-jacare', '', ''),
(10875, 73, 0, 2, 'Santana do Manhuaçu', '', 'santana-do-manhuacu', '', ''),
(10876, 73, 0, 2, 'Santana do Paraíso', '', 'santana-do-paraiso', '', ''),
(10877, 73, 0, 2, 'Santana do Riacho', '', 'santana-do-riacho', '', ''),
(10878, 73, 0, 2, 'Santana dos Montes', '', 'santana-dos-montes', '', ''),
(10879, 73, 0, 2, 'Santo Antônio do Amparo', '', 'santo-antonio-do-amparo', '', ''),
(10880, 73, 0, 2, 'Santo Antônio do Aventureiro', '', 'santo-antonio-do-aventureiro', '', ''),
(10881, 73, 0, 2, 'Santo Antônio do Grama', '', 'santo-antonio-do-grama', '', ''),
(10882, 73, 0, 2, 'Santo Antônio do Itambé', '', 'santo-antonio-do-itambe', '', ''),
(10883, 73, 0, 2, 'Santo Antônio do Jacinto', '', 'santo-antonio-do-jacinto', '', ''),
(10884, 73, 0, 2, 'Santo Antônio do Monte', '', 'santo-antonio-do-monte', '', ''),
(10885, 73, 0, 2, 'Santo Antônio do Retiro', '', 'santo-antonio-do-retiro', '', ''),
(10886, 73, 0, 2, 'Santo Antônio do Rio Abaixo', '', 'santo-antonio-do-rio-abaixo', '', ''),
(10887, 73, 0, 2, 'Santo Hipólito', '', 'santo-hipolito', '', ''),
(10888, 73, 0, 2, 'Santos Dumont', '', 'santos-dumont', '', ''),
(10889, 73, 0, 2, 'São Bento Abade', '', 'sao-bento-abade', '', ''),
(10890, 73, 0, 2, 'São Brás do Suaçuí', '', 'sao-bras-do-suacui', '', ''),
(10891, 73, 0, 2, 'São Domingos das Dores', '', 'sao-domingos-das-dores', '', ''),
(10892, 73, 0, 2, 'São Domingos do Prata', '', 'sao-domingos-do-prata', '', ''),
(10893, 73, 0, 2, 'São Félix de Minas', '', 'sao-felix-de-minas', '', ''),
(10894, 73, 0, 2, 'São Francisco', '', 'sao-francisco', '', ''),
(10895, 73, 0, 2, 'São Francisco de Paula', '', 'sao-francisco-de-paula', '', ''),
(10896, 73, 0, 2, 'São Francisco de Sales', '', 'sao-francisco-de-sales', '', ''),
(10897, 73, 0, 2, 'São Francisco do Glória', '', 'sao-francisco-do-gloria', '', ''),
(10898, 73, 0, 2, 'São Geraldo', '', 'sao-geraldo', '', ''),
(10899, 73, 0, 2, 'São Geraldo da Piedade', '', 'sao-geraldo-da-piedade', '', ''),
(10900, 73, 0, 2, 'São Geraldo do Baixio', '', 'sao-geraldo-do-baixio', '', ''),
(10901, 73, 0, 2, 'São Gonçalo do Abaeté', '', 'sao-goncalo-do-abaete', '', ''),
(10902, 73, 0, 2, 'São Gonçalo do Pará', '', 'sao-goncalo-do-para', '', ''),
(10903, 73, 0, 2, 'São Gonçalo do Rio Abaixo', '', 'sao-goncalo-do-rio-abaixo', '', ''),
(10904, 73, 0, 2, 'São Gonçalo do Rio Preto', '', 'sao-goncalo-do-rio-preto', '', ''),
(10905, 73, 0, 2, 'São Gonçalo do Sapucaí', '', 'sao-goncalo-do-sapucai', '', ''),
(10906, 73, 0, 2, 'São Gotardo', '', 'sao-gotardo', '', ''),
(10907, 73, 0, 2, 'São João Batista do Glória', '', 'sao-joao-batista-do-gloria', '', ''),
(10908, 73, 0, 2, 'São João da Lagoa', '', 'sao-joao-da-lagoa', '', ''),
(10909, 73, 0, 2, 'São João da Mata', '', 'sao-joao-da-mata', '', ''),
(10910, 73, 0, 2, 'São João da Ponte', '', 'sao-joao-da-ponte', '', ''),
(10911, 73, 0, 2, 'São João das Missões', '', 'sao-joao-das-missoes', '', ''),
(10912, 73, 0, 2, 'São João del Rei', '', 'sao-joao-del-rei', '', ''),
(10913, 73, 0, 2, 'São João do Manhuaçu', '', 'sao-joao-do-manhuacu', '', ''),
(10914, 73, 0, 2, 'São João do Manteninha', '', 'sao-joao-do-manteninha', '', ''),
(10915, 73, 0, 2, 'São João do Oriente', '', 'sao-joao-do-oriente', '', ''),
(10916, 73, 0, 2, 'São João do Pacuí', '', 'sao-joao-do-pacui', '', ''),
(10917, 73, 0, 2, 'São João do Paraíso', '', 'sao-joao-do-paraiso', '', ''),
(10918, 73, 0, 2, 'São João Evangelista', '', 'sao-joao-evangelista', '', ''),
(10919, 73, 0, 2, 'São João Nepomuceno', '', 'sao-joao-nepomuceno', '', ''),
(10920, 73, 0, 2, 'São Joaquim de Bicas', '', 'sao-joaquim-de-bicas', '', ''),
(10921, 73, 0, 2, 'São José da Barra', '', 'sao-jose-da-barra', '', ''),
(10922, 73, 0, 2, 'São José da Lapa', '', 'sao-jose-da-lapa', '', ''),
(10923, 73, 0, 2, 'São José da Safira', '', 'sao-jose-da-safira', '', ''),
(10924, 73, 0, 2, 'São José da Varginha', '', 'sao-jose-da-varginha', '', ''),
(10925, 73, 0, 2, 'São José do Alegre', '', 'sao-jose-do-alegre', '', ''),
(10926, 73, 0, 2, 'São José do Divino', '', 'sao-jose-do-divino', '', ''),
(10927, 73, 0, 2, 'São José do Goiabal', '', 'sao-jose-do-goiabal', '', ''),
(10928, 73, 0, 2, 'São José do Jacuri', '', 'sao-jose-do-jacuri', '', ''),
(10929, 73, 0, 2, 'São José do Mantimento', '', 'sao-jose-do-mantimento', '', ''),
(10930, 73, 0, 2, 'São Lourenço', '', 'sao-lourenco', '', ''),
(10931, 73, 0, 2, 'São Miguel do Anta', '', 'sao-miguel-do-anta', '', ''),
(10932, 73, 0, 2, 'São Pedro da União', '', 'sao-pedro-da-uniao', '', ''),
(10933, 73, 0, 2, 'São Pedro do Suaçuí', '', 'sao-pedro-do-suacui', '', ''),
(10934, 73, 0, 2, 'São Pedro dos Ferros', '', 'sao-pedro-dos-ferros', '', ''),
(10935, 73, 0, 2, 'São Romão', '', 'sao-romao', '', ''),
(10936, 73, 0, 2, 'São Roque de Minas', '', 'sao-roque-de-minas', '', ''),
(10937, 73, 0, 2, 'São Sebastião da Bela Vista', '', 'sao-sebastiao-da-bela-vista', '', ''),
(10938, 73, 0, 2, 'São Sebastião da Vargem Alegre', '', 'sao-sebastiao-da-vargem-alegre', '', ''),
(10939, 73, 0, 2, 'São Sebastião do Anta', '', 'sao-sebastiao-do-anta', '', ''),
(10940, 73, 0, 2, 'São Sebastião do Maranhão', '', 'sao-sebastiao-do-maranhao', '', ''),
(10941, 73, 0, 2, 'São Sebastião do Oeste', '', 'sao-sebastiao-do-oeste', '', ''),
(10942, 73, 0, 2, 'São Sebastião do Paraíso', '', 'sao-sebastiao-do-paraiso', '', ''),
(10943, 73, 0, 2, 'São Sebastião do Rio Preto', '', 'sao-sebastiao-do-rio-preto', '', ''),
(10944, 73, 0, 2, 'São Sebastião do Rio Verde', '', 'sao-sebastiao-do-rio-verde', '', ''),
(10945, 73, 0, 2, 'São Thomé das Letras', '', 'sao-thome-das-letras', '', ''),
(10946, 73, 0, 2, 'São Tiago', '', 'sao-tiago', '', ''),
(10947, 73, 0, 2, 'São Tomás de Aquino', '', 'sao-tomas-de-aquino', '', ''),
(10948, 73, 0, 2, 'São Vicente de Minas', '', 'sao-vicente-de-minas', '', ''),
(10949, 73, 0, 2, 'Sapucaí-Mirim', '', 'sapucai-mirim', '', ''),
(10950, 73, 0, 2, 'Sardoá', '', 'sardoa', '', ''),
(10951, 73, 0, 2, 'Sarzedo', '', 'sarzedo', '', ''),
(10952, 73, 0, 2, 'Sem-Peixe', '', 'sem-peixe', '', ''),
(10953, 73, 0, 2, 'Senador Amaral', '', 'senador-amaral', '', ''),
(10954, 73, 0, 2, 'Senador Cortes', '', 'senador-cortes', '', ''),
(10955, 73, 0, 2, 'Senador Firmino', '', 'senador-firmino', '', ''),
(10956, 73, 0, 2, 'Senador José Bento', '', 'senador-jose-bento', '', ''),
(10957, 73, 0, 2, 'Senador Modestino Gonçalves', '', 'senador-modestino-goncalves', '', ''),
(10958, 73, 0, 2, 'Senhora de Oliveira', '', 'senhora-de-oliveira', '', ''),
(10959, 73, 0, 2, 'Senhora do Porto', '', 'senhora-do-porto', '', ''),
(10960, 73, 0, 2, 'Senhora dos Remédios', '', 'senhora-dos-remedios', '', ''),
(10961, 73, 0, 2, 'Sericita', '', 'sericita', '', ''),
(10962, 73, 0, 2, 'Seritinga', '', 'seritinga', '', ''),
(10963, 73, 0, 2, 'Serra Azul de Minas', '', 'serra-azul-de-minas', '', ''),
(10964, 73, 0, 2, 'Serra da Saudade', '', 'serra-da-saudade', '', ''),
(10965, 73, 0, 2, 'Serra do Salitre', '', 'serra-do-salitre', '', ''),
(10966, 73, 0, 2, 'Serra dos Aimorés', '', 'serra-dos-aimores', '', ''),
(10967, 73, 0, 2, 'Serrania', '', 'serrania', '', ''),
(10968, 73, 0, 2, 'Serranópolis de Minas', '', 'serranopolis-de-minas', '', ''),
(10969, 73, 0, 2, 'Serranos', '', 'serranos', '', ''),
(10970, 73, 0, 2, 'Serro', '', 'serro', '', ''),
(10971, 73, 0, 2, 'Sete Lagoas', '', 'sete-lagoas', '', ''),
(10972, 73, 0, 2, 'Setubinha', '', 'setubinha', '', ''),
(10973, 73, 0, 2, 'Silveirânia', '', 'silveirania', '', ''),
(10974, 73, 0, 2, 'Silvianópolis', '', 'silvianopolis', '', ''),
(10975, 73, 0, 2, 'Simão Pereira', '', 'simao-pereira', '', ''),
(10976, 73, 0, 2, 'Simonésia', '', 'simonesia', '', ''),
(10977, 73, 0, 2, 'Sobrália', '', 'sobralia', '', ''),
(10978, 73, 0, 2, 'Soledade de Minas', '', 'soledade-de-minas', '', ''),
(10979, 73, 0, 2, 'Tabuleiro', '', 'tabuleiro', '', ''),
(10980, 73, 0, 2, 'Taiobeiras', '', 'taiobeiras', '', ''),
(10981, 73, 0, 2, 'Taparuba', '', 'taparuba', '', ''),
(10982, 73, 0, 2, 'Tapira', '', 'tapira', '', ''),
(10983, 73, 0, 2, 'Tapiraí', '', 'tapirai', '', ''),
(10984, 73, 0, 2, 'Taquaraçu de Minas', '', 'taquaracu-de-minas', '', ''),
(10985, 73, 0, 2, 'Tarumirim', '', 'tarumirim', '', ''),
(10986, 73, 0, 2, 'Teixeiras', '', 'teixeiras', '', ''),
(10987, 73, 0, 2, 'Teófilo Otoni', '', 'teofilo-otoni', '', ''),
(10988, 73, 0, 2, 'Timóteo', '', 'timoteo', '', ''),
(10989, 73, 0, 2, 'Tiradentes', '', 'tiradentes', '', ''),
(10990, 73, 0, 2, 'Tiros', '', 'tiros', '', ''),
(10991, 73, 0, 2, 'Tocantins', '', 'tocantins', '', ''),
(10992, 73, 0, 2, 'Tocos do Moji', '', 'tocos-do-moji', '', ''),
(10993, 73, 0, 2, 'Toledo', '', 'toledo', '', ''),
(10994, 73, 0, 2, 'Tombos', '', 'tombos', '', ''),
(10995, 73, 0, 2, 'Três Corações', '', 'tres-coracoes', '', ''),
(10996, 73, 0, 2, 'Três Marias', '', 'tres-marias', '', ''),
(10997, 73, 0, 2, 'Três Pontas', '', 'tres-pontas', '', ''),
(10998, 73, 0, 2, 'Tumiritinga', '', 'tumiritinga', '', ''),
(10999, 73, 0, 2, 'Tupaciguara', '', 'tupaciguara', '', ''),
(11000, 73, 0, 2, 'Turmalina', '', 'turmalina', '', ''),
(11001, 73, 0, 2, 'Turvolândia', '', 'turvolandia', '', ''),
(11002, 73, 0, 2, 'Ubá', '', 'uba', '', ''),
(11003, 73, 0, 2, 'Ubaí', '', 'ubai', '', ''),
(11004, 73, 0, 2, 'Ubaporanga', '', 'ubaporanga', '', ''),
(11005, 73, 0, 2, 'Uberaba', '', 'uberaba', '', ''),
(11006, 73, 0, 2, 'Uberlândia', '', 'uberlandia', '', ''),
(11007, 73, 0, 2, 'Umburatiba', '', 'umburatiba', '', ''),
(11008, 73, 0, 2, 'Unaí', '', 'unai', '', ''),
(11009, 73, 0, 2, 'União de Minas', '', 'uniao-de-minas', '', ''),
(11010, 73, 0, 2, 'Uruana de Minas', '', 'uruana-de-minas', '', ''),
(11011, 73, 0, 2, 'Urucânia', '', 'urucania', '', ''),
(11012, 73, 0, 2, 'Urucuia', '', 'urucuia', '', ''),
(11013, 73, 0, 2, 'Vargem Alegre', '', 'vargem-alegre', '', ''),
(11014, 73, 0, 2, 'Vargem Bonita', '', 'vargem-bonita', '', ''),
(11015, 73, 0, 2, 'Vargem Grande do Rio Pardo', '', 'vargem-grande-do-rio-pardo', '', ''),
(11016, 73, 0, 2, 'Varginha', '', 'varginha', '', ''),
(11017, 73, 0, 2, 'Varjão de Minas', '', 'varjao-de-minas', '', ''),
(11018, 73, 0, 2, 'Várzea da Palma', '', 'varzea-da-palma', '', ''),
(11019, 73, 0, 2, 'Varzelândia', '', 'varzelandia', '', ''),
(11020, 73, 0, 2, 'Vazante', '', 'vazante', '', ''),
(11021, 73, 0, 2, 'Verdelândia', '', 'verdelandia', '', ''),
(11022, 73, 0, 2, 'Veredinha', '', 'veredinha', '', ''),
(11023, 73, 0, 2, 'Veríssimo', '', 'verissimo', '', ''),
(11024, 73, 0, 2, 'Vermelho Novo', '', 'vermelho-novo', '', ''),
(11025, 73, 0, 2, 'Vespasiano', '', 'vespasiano', '', ''),
(11026, 73, 0, 2, 'Viçosa', '', 'vicosa', '', ''),
(11027, 73, 0, 2, 'Vieiras', '', 'vieiras', '', ''),
(11028, 73, 0, 2, 'Virgem da Lapa', '', 'virgem-da-lapa', '', ''),
(11029, 73, 0, 2, 'Virgínia', '', 'virginia', '', ''),
(11030, 73, 0, 2, 'Virginópolis', '', 'virginopolis', '', ''),
(11031, 73, 0, 2, 'Virgolândia', '', 'virgolandia', '', ''),
(11032, 73, 0, 2, 'Visconde do Rio Branco', '', 'visconde-do-rio-branco', '', ''),
(11033, 73, 0, 2, 'Volta Grande', '', 'volta-grande', '', ''),
(11034, 73, 0, 2, 'Wenceslau Braz', '', 'wenceslau-braz', '', ''),
(11035, 74, 0, 2, 'Abaetetuba', '', 'abaetetuba', '', ''),
(11036, 74, 0, 2, 'Abel Figueiredo', '', 'abel-figueiredo', '', ''),
(11037, 74, 0, 2, 'Acará', '', 'acara', '', ''),
(11038, 74, 0, 2, 'Afuá', '', 'afua', '', ''),
(11039, 74, 0, 2, 'Água Azul do Norte', '', 'agua-azul-do-norte', '', ''),
(11040, 74, 0, 2, 'Alenquer', '', 'alenquer', '', ''),
(11041, 74, 0, 2, 'Almeirim', '', 'almeirim', '', ''),
(11042, 74, 0, 2, 'Altamira', '', 'altamira', '', ''),
(11043, 74, 0, 2, 'Anajás', '', 'anajas', '', ''),
(11044, 74, 0, 2, 'Ananindeua', '', 'ananindeua', '', ''),
(11045, 74, 0, 2, 'Anapu', '', 'anapu', '', ''),
(11046, 74, 0, 2, 'Augusto Corrêa', '', 'augusto-correa', '', ''),
(11047, 74, 0, 2, 'Aurora do Pará', '', 'aurora-do-para', '', ''),
(11048, 74, 0, 2, 'Aveiro', '', 'aveiro', '', ''),
(11049, 74, 0, 2, 'Bagre', '', 'bagre', '', ''),
(11050, 74, 0, 2, 'Baião', '', 'baiao', '', ''),
(11051, 74, 0, 2, 'Bannach', '', 'bannach', '', ''),
(11052, 74, 0, 2, 'Barcarena', '', 'barcarena', '', ''),
(11053, 74, 0, 2, 'Belém', '', 'belem', '', ''),
(11054, 74, 0, 2, 'Belterra', '', 'belterra', '', ''),
(11055, 74, 0, 2, 'Benevides', '', 'benevides', '', ''),
(11056, 74, 0, 2, 'Bom Jesus do Tocantins', '', 'bom-jesus-do-tocantins', '', ''),
(11057, 74, 0, 2, 'Bonito', '', 'bonito', '', ''),
(11058, 74, 0, 2, 'Bragança', '', 'braganca', '', ''),
(11059, 74, 0, 2, 'Brasil Novo', '', 'brasil-novo', '', ''),
(11060, 74, 0, 2, 'Brejo Grande do Araguaia', '', 'brejo-grande-do-araguaia', '', ''),
(11061, 74, 0, 2, 'Breu Branco', '', 'breu-branco', '', ''),
(11062, 74, 0, 2, 'Breves', '', 'breves', '', ''),
(11063, 74, 0, 2, 'Bujaru', '', 'bujaru', '', ''),
(11064, 74, 0, 2, 'Cachoeira do Arari', '', 'cachoeira-do-arari', '', ''),
(11065, 74, 0, 2, 'Cachoeira do Piriá', '', 'cachoeira-do-piria', '', ''),
(11066, 74, 0, 2, 'Cametá', '', 'cameta', '', ''),
(11067, 74, 0, 2, 'Canaã dos Carajás', '', 'canaa-dos-carajas', '', ''),
(11068, 74, 0, 2, 'Capanema', '', 'capanema', '', ''),
(11069, 74, 0, 2, 'Capitão Poço', '', 'capitao-poco', '', ''),
(11070, 74, 0, 2, 'Castanhal', '', 'castanhal', '', ''),
(11071, 74, 0, 2, 'Chaves', '', 'chaves', '', ''),
(11072, 74, 0, 2, 'Colares', '', 'colares', '', ''),
(11073, 74, 0, 2, 'Conceição do Araguaia', '', 'conceicao-do-araguaia', '', ''),
(11074, 74, 0, 2, 'Concórdia do Pará', '', 'concordia-do-para', '', ''),
(11075, 74, 0, 2, 'Cumaru do Norte', '', 'cumaru-do-norte', '', ''),
(11076, 74, 0, 2, 'Curionópolis', '', 'curionopolis', '', ''),
(11077, 74, 0, 2, 'Curralinho', '', 'curralinho', '', ''),
(11078, 74, 0, 2, 'Curuá', '', 'curua', '', ''),
(11079, 74, 0, 2, 'Curuçá', '', 'curuca', '', ''),
(11080, 74, 0, 2, 'Dom Eliseu', '', 'dom-eliseu', '', ''),
(11081, 74, 0, 2, 'Eldorado dos Carajás', '', 'eldorado-dos-carajas', '', ''),
(11082, 74, 0, 2, 'Faro', '', 'faro', '', ''),
(11083, 74, 0, 2, 'Floresta do Araguaia', '', 'floresta-do-araguaia', '', ''),
(11084, 74, 0, 2, 'Garrafão do Norte', '', 'garrafao-do-norte', '', ''),
(11085, 74, 0, 2, 'Goianésia do Pará', '', 'goianesia-do-para', '', ''),
(11086, 74, 0, 2, 'Gurupá', '', 'gurupa', '', ''),
(11087, 74, 0, 2, 'Igarapé-Açu', '', 'igarape-acu', '', ''),
(11088, 74, 0, 2, 'Igarapé-Miri', '', 'igarape-miri', '', ''),
(11089, 74, 0, 2, 'Inhangapi', '', 'inhangapi', '', ''),
(11090, 74, 0, 2, 'Ipixuna do Pará', '', 'ipixuna-do-para', '', ''),
(11091, 74, 0, 2, 'Irituia', '', 'irituia', '', ''),
(11092, 74, 0, 2, 'Itaituba', '', 'itaituba', '', ''),
(11093, 74, 0, 2, 'Itupiranga', '', 'itupiranga', '', ''),
(11094, 74, 0, 2, 'Jacareacanga', '', 'jacareacanga', '', ''),
(11095, 74, 0, 2, 'Jacundá', '', 'jacunda', '', ''),
(11096, 74, 0, 2, 'Juruti', '', 'juruti', '', ''),
(11097, 74, 0, 2, 'Limoeiro do Ajuru', '', 'limoeiro-do-ajuru', '', ''),
(11098, 74, 0, 2, 'Mãe do Rio', '', 'mae-do-rio', '', ''),
(11099, 74, 0, 2, 'Magalhães Barata', '', 'magalhaes-barata', '', ''),
(11100, 74, 0, 2, 'Marabá', '', 'maraba', '', ''),
(11101, 74, 0, 2, 'Maracanã', '', 'maracana', '', ''),
(11102, 74, 0, 2, 'Marapanim', '', 'marapanim', '', ''),
(11103, 74, 0, 2, 'Marituba', '', 'marituba', '', ''),
(11104, 74, 0, 2, 'Medicilândia', '', 'medicilandia', '', ''),
(11105, 74, 0, 2, 'Melgaço', '', 'melgaco', '', ''),
(11106, 74, 0, 2, 'Mocajuba', '', 'mocajuba', '', ''),
(11107, 74, 0, 2, 'Moju', '', 'moju', '', ''),
(11108, 74, 0, 2, 'Monte Alegre', '', 'monte-alegre', '', ''),
(11109, 74, 0, 2, 'Muaná', '', 'muana', '', ''),
(11110, 74, 0, 2, 'Nova Esperança do Piriá', '', 'nova-esperanca-do-piria', '', ''),
(11111, 74, 0, 2, 'Nova Ipixuna', '', 'nova-ipixuna', '', ''),
(11112, 74, 0, 2, 'Nova Timboteua', '', 'nova-timboteua', '', ''),
(11113, 74, 0, 2, 'Novo Progresso', '', 'novo-progresso', '', ''),
(11114, 74, 0, 2, 'Novo Repartimento', '', 'novo-repartimento', '', ''),
(11115, 74, 0, 2, 'Óbidos', '', 'obidos', '', ''),
(11116, 74, 0, 2, 'Oeiras do Pará', '', 'oeiras-do-para', '', ''),
(11117, 74, 0, 2, 'Oriximiná', '', 'oriximina', '', ''),
(11118, 74, 0, 2, 'Ourém', '', 'ourem', '', ''),
(11119, 74, 0, 2, 'Ourilândia do Norte', '', 'ourilandia-do-norte', '', ''),
(11120, 74, 0, 2, 'Pacajá', '', 'pacaja', '', ''),
(11121, 74, 0, 2, 'Palestina do Pará', '', 'palestina-do-para', '', ''),
(11122, 74, 0, 2, 'Paragominas', '', 'paragominas', '', ''),
(11123, 74, 0, 2, 'Parauapebas', '', 'parauapebas', '', ''),
(11124, 74, 0, 2, 'Pau d`Arco', '', 'pau-d`arco', '', ''),
(11125, 74, 0, 2, 'Peixe-Boi', '', 'peixe-boi', '', ''),
(11126, 74, 0, 2, 'Piçarra', '', 'picarra', '', ''),
(11127, 74, 0, 2, 'Placas', '', 'placas', '', ''),
(11128, 74, 0, 2, 'Ponta de Pedras', '', 'ponta-de-pedras', '', ''),
(11129, 74, 0, 2, 'Portel', '', 'portel', '', ''),
(11130, 74, 0, 2, 'Porto de Moz', '', 'porto-de-moz', '', ''),
(11131, 74, 0, 2, 'Prainha', '', 'prainha', '', ''),
(11132, 74, 0, 2, 'Primavera', '', 'primavera', '', ''),
(11133, 74, 0, 2, 'Quatipuru', '', 'quatipuru', '', ''),
(11134, 74, 0, 2, 'Redenção', '', 'redencao', '', ''),
(11135, 74, 0, 2, 'Rio Maria', '', 'rio-maria', '', ''),
(11136, 74, 0, 2, 'Rondon do Pará', '', 'rondon-do-para', '', ''),
(11137, 74, 0, 2, 'Rurópolis', '', 'ruropolis', '', ''),
(11138, 74, 0, 2, 'Salinópolis', '', 'salinopolis', '', ''),
(11139, 74, 0, 2, 'Salvaterra', '', 'salvaterra', '', ''),
(11140, 74, 0, 2, 'Santa Bárbara do Pará', '', 'santa-barbara-do-para', '', ''),
(11141, 74, 0, 2, 'Santa Cruz do Arari', '', 'santa-cruz-do-arari', '', ''),
(11142, 74, 0, 2, 'Santa Isabel do Pará', '', 'santa-isabel-do-para', '', ''),
(11143, 74, 0, 2, 'Santa Luzia do Pará', '', 'santa-luzia-do-para', '', ''),
(11144, 74, 0, 2, 'Santa Maria das Barreiras', '', 'santa-maria-das-barreiras', '', ''),
(11145, 74, 0, 2, 'Santa Maria do Pará', '', 'santa-maria-do-para', '', ''),
(11146, 74, 0, 2, 'Santana do Araguaia', '', 'santana-do-araguaia', '', ''),
(11147, 74, 0, 2, 'Santarém', '', 'santarem', '', ''),
(11148, 74, 0, 2, 'Santarém Novo', '', 'santarem-novo', '', ''),
(11149, 74, 0, 2, 'Santo Antônio do Tauá', '', 'santo-antonio-do-taua', '', ''),
(11150, 74, 0, 2, 'São Caetano de Odivelas', '', 'sao-caetano-de-odivelas', '', ''),
(11151, 74, 0, 2, 'São Domingos do Araguaia', '', 'sao-domingos-do-araguaia', '', ''),
(11152, 74, 0, 2, 'São Domingos do Capim', '', 'sao-domingos-do-capim', '', ''),
(11153, 74, 0, 2, 'São Félix do Xingu', '', 'sao-felix-do-xingu', '', ''),
(11154, 74, 0, 2, 'São Francisco do Pará', '', 'sao-francisco-do-para', '', ''),
(11155, 74, 0, 2, 'São Geraldo do Araguaia', '', 'sao-geraldo-do-araguaia', '', ''),
(11156, 74, 0, 2, 'São João da Ponta', '', 'sao-joao-da-ponta', '', ''),
(11157, 74, 0, 2, 'São João de Pirabas', '', 'sao-joao-de-pirabas', '', ''),
(11158, 74, 0, 2, 'São João do Araguaia', '', 'sao-joao-do-araguaia', '', ''),
(11159, 74, 0, 2, 'São Miguel do Guamá', '', 'sao-miguel-do-guama', '', ''),
(11160, 74, 0, 2, 'São Sebastião da Boa Vista', '', 'sao-sebastiao-da-boa-vista', '', ''),
(11161, 74, 0, 2, 'Sapucaia', '', 'sapucaia', '', ''),
(11162, 74, 0, 2, 'Senador José Porfírio', '', 'senador-jose-porfirio', '', ''),
(11163, 74, 0, 2, 'Soure', '', 'soure', '', ''),
(11164, 74, 0, 2, 'Tailândia', '', 'tailandia', '', ''),
(11165, 74, 0, 2, 'Terra Alta', '', 'terra-alta', '', ''),
(11166, 74, 0, 2, 'Terra Santa', '', 'terra-santa', '', ''),
(11167, 74, 0, 2, 'Tomé-Açu', '', 'tome-acu', '', ''),
(11168, 74, 0, 2, 'Tracuateua', '', 'tracuateua', '', ''),
(11169, 74, 0, 2, 'Trairão', '', 'trairao', '', ''),
(11170, 74, 0, 2, 'Tucumã', '', 'tucuma', '', ''),
(11171, 74, 0, 2, 'Tucuruí', '', 'tucurui', '', ''),
(11172, 74, 0, 2, 'Ulianópolis', '', 'ulianopolis', '', ''),
(11173, 74, 0, 2, 'Uruará', '', 'uruara', '', ''),
(11174, 74, 0, 2, 'Vigia', '', 'vigia', '', ''),
(11175, 74, 0, 2, 'Viseu', '', 'viseu', '', ''),
(11176, 74, 0, 2, 'Vitória do Xingu', '', 'vitoria-do-xingu', '', ''),
(11177, 74, 0, 2, 'Xinguara', '', 'xinguara', '', ''),
(11178, 75, 0, 2, 'Água Branca', '', 'agua-branca', '', ''),
(11179, 75, 0, 2, 'Aguiar', '', 'aguiar', '', ''),
(11180, 75, 0, 2, 'Alagoa Grande', '', 'alagoa-grande', '', ''),
(11181, 75, 0, 2, 'Alagoa Nova', '', 'alagoa-nova', '', ''),
(11182, 75, 0, 2, 'Alagoinha', '', 'alagoinha', '', ''),
(11183, 75, 0, 2, 'Alcantil', '', 'alcantil', '', ''),
(11184, 75, 0, 2, 'Algodão de Jandaíra', '', 'algodao-de-jandaira', '', ''),
(11185, 75, 0, 2, 'Alhandra', '', 'alhandra', '', ''),
(11186, 75, 0, 2, 'Amparo', '', 'amparo', '', ''),
(11187, 75, 0, 2, 'Aparecida', '', 'aparecida', '', ''),
(11188, 75, 0, 2, 'Araçagi', '', 'aracagi', '', ''),
(11189, 75, 0, 2, 'Arara', '', 'arara', '', ''),
(11190, 75, 0, 2, 'Araruna', '', 'araruna', '', ''),
(11191, 75, 0, 2, 'Areia', '', 'areia', '', ''),
(11192, 75, 0, 2, 'Areia de Baraúnas', '', 'areia-de-baraunas', '', ''),
(11193, 75, 0, 2, 'Areial', '', 'areial', '', ''),
(11194, 75, 0, 2, 'Aroeiras', '', 'aroeiras', '', ''),
(11195, 75, 0, 2, 'Assunção', '', 'assuncao', '', ''),
(11196, 75, 0, 2, 'Baía da Traição', '', 'baia-da-traicao', '', ''),
(11197, 75, 0, 2, 'Bananeiras', '', 'bananeiras', '', ''),
(11198, 75, 0, 2, 'Baraúna', '', 'barauna', '', ''),
(11199, 75, 0, 2, 'Barra de Santa Rosa', '', 'barra-de-santa-rosa', '', ''),
(11200, 75, 0, 2, 'Barra de Santana', '', 'barra-de-santana', '', ''),
(11201, 75, 0, 2, 'Barra de São Miguel', '', 'barra-de-sao-miguel', '', ''),
(11202, 75, 0, 2, 'Bayeux', '', 'bayeux', '', ''),
(11203, 75, 0, 2, 'Belém', '', 'belem', '', ''),
(11204, 75, 0, 2, 'Belém do Brejo do Cruz', '', 'belem-do-brejo-do-cruz', '', ''),
(11205, 75, 0, 2, 'Bernardino Batista', '', 'bernardino-batista', '', ''),
(11206, 75, 0, 2, 'Boa Ventura', '', 'boa-ventura', '', ''),
(11207, 75, 0, 2, 'Boa Vista', '', 'boa-vista', '', ''),
(11208, 75, 0, 2, 'Bom Jesus', '', 'bom-jesus', '', ''),
(11209, 75, 0, 2, 'Bom Sucesso', '', 'bom-sucesso', '', ''),
(11210, 75, 0, 2, 'Bonito de Santa Fé', '', 'bonito-de-santa-fe', '', ''),
(11211, 75, 0, 2, 'Boqueirão', '', 'boqueirao', '', ''),
(11212, 75, 0, 2, 'Borborema', '', 'borborema', '', ''),
(11213, 75, 0, 2, 'Brejo do Cruz', '', 'brejo-do-cruz', '', ''),
(11214, 75, 0, 2, 'Brejo dos Santos', '', 'brejo-dos-santos', '', ''),
(11215, 75, 0, 2, 'Caaporã', '', 'caapora', '', ''),
(11216, 75, 0, 2, 'Cabaceiras', '', 'cabaceiras', '', ''),
(11217, 75, 0, 2, 'Cabedelo', '', 'cabedelo', '', ''),
(11218, 75, 0, 2, 'Cachoeira dos Índios', '', 'cachoeira-dos-indios', '', ''),
(11219, 75, 0, 2, 'Cacimba de Areia', '', 'cacimba-de-areia', '', ''),
(11220, 75, 0, 2, 'Cacimba de Dentro', '', 'cacimba-de-dentro', '', ''),
(11221, 75, 0, 2, 'Cacimbas', '', 'cacimbas', '', ''),
(11222, 75, 0, 2, 'Caiçara', '', 'caicara', '', ''),
(11223, 75, 0, 2, 'Cajazeiras', '', 'cajazeiras', '', ''),
(11224, 75, 0, 2, 'Cajazeirinhas', '', 'cajazeirinhas', '', ''),
(11225, 75, 0, 2, 'Caldas Brandão', '', 'caldas-brandao', '', ''),
(11226, 75, 0, 2, 'Camalaú', '', 'camalau', '', ''),
(11227, 75, 0, 2, 'Campina Grande', '', 'campina-grande', '', ''),
(11228, 75, 0, 2, 'Campo de Santana', '', 'campo-de-santana', '', ''),
(11229, 75, 0, 2, 'Capim', '', 'capim', '', ''),
(11230, 75, 0, 2, 'Caraúbas', '', 'caraubas', '', ''),
(11231, 75, 0, 2, 'Carrapateira', '', 'carrapateira', '', ''),
(11232, 75, 0, 2, 'Casserengue', '', 'casserengue', '', ''),
(11233, 75, 0, 2, 'Catingueira', '', 'catingueira', '', ''),
(11234, 75, 0, 2, 'Catolé do Rocha', '', 'catole-do-rocha', '', ''),
(11235, 75, 0, 2, 'Caturité', '', 'caturite', '', ''),
(11236, 75, 0, 2, 'Conceição', '', 'conceicao', '', ''),
(11237, 75, 0, 2, 'Condado', '', 'condado', '', ''),
(11238, 75, 0, 2, 'Conde', '', 'conde', '', ''),
(11239, 75, 0, 2, 'Congo', '', 'congo', '', ''),
(11240, 75, 0, 2, 'Coremas', '', 'coremas', '', ''),
(11241, 75, 0, 2, 'Coxixola', '', 'coxixola', '', ''),
(11242, 75, 0, 2, 'Cruz do Espírito Santo', '', 'cruz-do-espirito-santo', '', ''),
(11243, 75, 0, 2, 'Cubati', '', 'cubati', '', ''),
(11244, 75, 0, 2, 'Cuité', '', 'cuite', '', ''),
(11245, 75, 0, 2, 'Cuité de Mamanguape', '', 'cuite-de-mamanguape', '', ''),
(11246, 75, 0, 2, 'Cuitegi', '', 'cuitegi', '', ''),
(11247, 75, 0, 2, 'Curral de Cima', '', 'curral-de-cima', '', ''),
(11248, 75, 0, 2, 'Curral Velho', '', 'curral-velho', '', ''),
(11249, 75, 0, 2, 'Damião', '', 'damiao', '', ''),
(11250, 75, 0, 2, 'Desterro', '', 'desterro', '', ''),
(11251, 75, 0, 2, 'Diamante', '', 'diamante', '', ''),
(11252, 75, 0, 2, 'Dona Inês', '', 'dona-ines', '', ''),
(11253, 75, 0, 2, 'Duas Estradas', '', 'duas-estradas', '', ''),
(11254, 75, 0, 2, 'Emas', '', 'emas', '', ''),
(11255, 75, 0, 2, 'Esperança', '', 'esperanca', '', ''),
(11256, 75, 0, 2, 'Fagundes', '', 'fagundes', '', ''),
(11257, 75, 0, 2, 'Frei Martinho', '', 'frei-martinho', '', ''),
(11258, 75, 0, 2, 'Gado Bravo', '', 'gado-bravo', '', ''),
(11259, 75, 0, 2, 'Guarabira', '', 'guarabira', '', ''),
(11260, 75, 0, 2, 'Gurinhém', '', 'gurinhem', '', ''),
(11261, 75, 0, 2, 'Gurjão', '', 'gurjao', '', ''),
(11262, 75, 0, 2, 'Ibiara', '', 'ibiara', '', ''),
(11263, 75, 0, 2, 'Igaracy', '', 'igaracy', '', ''),
(11264, 75, 0, 2, 'Imaculada', '', 'imaculada', '', ''),
(11265, 75, 0, 2, 'Ingá', '', 'inga', '', ''),
(11266, 75, 0, 2, 'Itabaiana', '', 'itabaiana', '', ''),
(11267, 75, 0, 2, 'Itaporanga', '', 'itaporanga', '', ''),
(11268, 75, 0, 2, 'Itapororoca', '', 'itapororoca', '', ''),
(11269, 75, 0, 2, 'Itatuba', '', 'itatuba', '', ''),
(11270, 75, 0, 2, 'Jacaraú', '', 'jacarau', '', ''),
(11271, 75, 0, 2, 'Jericó', '', 'jerico', '', ''),
(11272, 75, 0, 2, 'João Pessoa', '', 'joao-pessoa', '', ''),
(11273, 75, 0, 2, 'Juarez Távora', '', 'juarez-tavora', '', ''),
(11274, 75, 0, 2, 'Juazeirinho', '', 'juazeirinho', '', ''),
(11275, 75, 0, 2, 'Junco do Seridó', '', 'junco-do-serido', '', ''),
(11276, 75, 0, 2, 'Juripiranga', '', 'juripiranga', '', ''),
(11277, 75, 0, 2, 'Juru', '', 'juru', '', ''),
(11278, 75, 0, 2, 'Lagoa', '', 'lagoa', '', ''),
(11279, 75, 0, 2, 'Lagoa de Dentro', '', 'lagoa-de-dentro', '', ''),
(11280, 75, 0, 2, 'Lagoa Seca', '', 'lagoa-seca', '', ''),
(11281, 75, 0, 2, 'Lastro', '', 'lastro', '', ''),
(11282, 75, 0, 2, 'Livramento', '', 'livramento', '', ''),
(11283, 75, 0, 2, 'Logradouro', '', 'logradouro', '', ''),
(11284, 75, 0, 2, 'Lucena', '', 'lucena', '', ''),
(11285, 75, 0, 2, 'Mãe d`Água', '', 'mae-d`agua', '', ''),
(11286, 75, 0, 2, 'Malta', '', 'malta', '', ''),
(11287, 75, 0, 2, 'Mamanguape', '', 'mamanguape', '', ''),
(11288, 75, 0, 2, 'Manaíra', '', 'manaira', '', ''),
(11289, 75, 0, 2, 'Marcação', '', 'marcacao', '', ''),
(11290, 75, 0, 2, 'Mari', '', 'mari', '', ''),
(11291, 75, 0, 2, 'Marizópolis', '', 'marizopolis', '', ''),
(11292, 75, 0, 2, 'Massaranduba', '', 'massaranduba', '', ''),
(11293, 75, 0, 2, 'Mataraca', '', 'mataraca', '', ''),
(11294, 75, 0, 2, 'Matinhas', '', 'matinhas', '', ''),
(11295, 75, 0, 2, 'Mato Grosso', '', 'mato-grosso', '', ''),
(11296, 75, 0, 2, 'Maturéia', '', 'matureia', '', ''),
(11297, 75, 0, 2, 'Mogeiro', '', 'mogeiro', '', ''),
(11298, 75, 0, 2, 'Montadas', '', 'montadas', '', ''),
(11299, 75, 0, 2, 'Monte Horebe', '', 'monte-horebe', '', ''),
(11300, 75, 0, 2, 'Monteiro', '', 'monteiro', '', ''),
(11301, 75, 0, 2, 'Mulungu', '', 'mulungu', '', ''),
(11302, 75, 0, 2, 'Natuba', '', 'natuba', '', ''),
(11303, 75, 0, 2, 'Nazarezinho', '', 'nazarezinho', '', ''),
(11304, 75, 0, 2, 'Nova Floresta', '', 'nova-floresta', '', ''),
(11305, 75, 0, 2, 'Nova Olinda', '', 'nova-olinda', '', ''),
(11306, 75, 0, 2, 'Nova Palmeira', '', 'nova-palmeira', '', ''),
(11307, 75, 0, 2, 'Olho d`Água', '', 'olho-d`agua', '', ''),
(11308, 75, 0, 2, 'Olivedos', '', 'olivedos', '', ''),
(11309, 75, 0, 2, 'Ouro Velho', '', 'ouro-velho', '', ''),
(11310, 75, 0, 2, 'Parari', '', 'parari', '', ''),
(11311, 75, 0, 2, 'Passagem', '', 'passagem', '', ''),
(11312, 75, 0, 2, 'Patos', '', 'patos', '', ''),
(11313, 75, 0, 2, 'Paulista', '', 'paulista', '', ''),
(11314, 75, 0, 2, 'Pedra Branca', '', 'pedra-branca', '', ''),
(11315, 75, 0, 2, 'Pedra Lavrada', '', 'pedra-lavrada', '', ''),
(11316, 75, 0, 2, 'Pedras de Fogo', '', 'pedras-de-fogo', '', ''),
(11317, 75, 0, 2, 'Pedro Régis', '', 'pedro-regis', '', ''),
(11318, 75, 0, 2, 'Piancó', '', 'pianco', '', ''),
(11319, 75, 0, 2, 'Picuí', '', 'picui', '', ''),
(11320, 75, 0, 2, 'Pilar', '', 'pilar', '', ''),
(11321, 75, 0, 2, 'Pilões', '', 'piloes', '', ''),
(11322, 75, 0, 2, 'Pilõezinhos', '', 'piloezinhos', '', ''),
(11323, 75, 0, 2, 'Pirpirituba', '', 'pirpirituba', '', ''),
(11324, 75, 0, 2, 'Pitimbu', '', 'pitimbu', '', ''),
(11325, 75, 0, 2, 'Pocinhos', '', 'pocinhos', '', ''),
(11326, 75, 0, 2, 'Poço Dantas', '', 'poco-dantas', '', ''),
(11327, 75, 0, 2, 'Poço de José de Moura', '', 'poco-de-jose-de-moura', '', ''),
(11328, 75, 0, 2, 'Pombal', '', 'pombal', '', ''),
(11329, 75, 0, 2, 'Prata', '', 'prata', '', ''),
(11330, 75, 0, 2, 'Princesa Isabel', '', 'princesa-isabel', '', ''),
(11331, 75, 0, 2, 'Puxinanã', '', 'puxinana', '', ''),
(11332, 75, 0, 2, 'Queimadas', '', 'queimadas', '', ''),
(11333, 75, 0, 2, 'Quixabá', '', 'quixaba', '', ''),
(11334, 75, 0, 2, 'Remígio', '', 'remigio', '', ''),
(11335, 75, 0, 2, 'Riachão', '', 'riachao', '', ''),
(11336, 75, 0, 2, 'Riachão do Bacamarte', '', 'riachao-do-bacamarte', '', ''),
(11337, 75, 0, 2, 'Riachão do Poço', '', 'riachao-do-poco', '', ''),
(11338, 75, 0, 2, 'Riacho de Santo Antônio', '', 'riacho-de-santo-antonio', '', ''),
(11339, 75, 0, 2, 'Riacho dos Cavalos', '', 'riacho-dos-cavalos', '', ''),
(11340, 75, 0, 2, 'Rio Tinto', '', 'rio-tinto', '', ''),
(11341, 75, 0, 2, 'Salgadinho', '', 'salgadinho', '', ''),
(11342, 75, 0, 2, 'Salgado de São Félix', '', 'salgado-de-sao-felix', '', ''),
(11343, 75, 0, 2, 'Santa Cecília', '', 'santa-cecilia', '', ''),
(11344, 75, 0, 2, 'Santa Cruz', '', 'santa-cruz', '', ''),
(11345, 75, 0, 2, 'Santa Helena', '', 'santa-helena', '', ''),
(11346, 75, 0, 2, 'Santa Inês', '', 'santa-ines', '', ''),
(11347, 75, 0, 2, 'Santa Luzia', '', 'santa-luzia', '', ''),
(11348, 75, 0, 2, 'Santa Rita', '', 'santa-rita', '', ''),
(11349, 75, 0, 2, 'Santa Teresinha', '', 'santa-teresinha', '', ''),
(11350, 75, 0, 2, 'Santana de Mangueira', '', 'santana-de-mangueira', '', ''),
(11351, 75, 0, 2, 'Santana dos Garrotes', '', 'santana-dos-garrotes', '', ''),
(11352, 75, 0, 2, 'Santarém', '', 'santarem', '', ''),
(11353, 75, 0, 2, 'Santo André', '', 'santo-andre', '', ''),
(11354, 75, 0, 2, 'São Bentinho', '', 'sao-bentinho', '', ''),
(11355, 75, 0, 2, 'São Bento', '', 'sao-bento', '', ''),
(11356, 75, 0, 2, 'São Domingos de Pombal', '', 'sao-domingos-de-pombal', '', ''),
(11357, 75, 0, 2, 'São Domingos do Cariri', '', 'sao-domingos-do-cariri', '', ''),
(11358, 75, 0, 2, 'São Francisco', '', 'sao-francisco', '', ''),
(11359, 75, 0, 2, 'São João do Cariri', '', 'sao-joao-do-cariri', '', ''),
(11360, 75, 0, 2, 'São João do Rio do Peixe', '', 'sao-joao-do-rio-do-peixe', '', ''),
(11361, 75, 0, 2, 'São João do Tigre', '', 'sao-joao-do-tigre', '', ''),
(11362, 75, 0, 2, 'São José da Lagoa Tapada', '', 'sao-jose-da-lagoa-tapada', '', ''),
(11363, 75, 0, 2, 'São José de Caiana', '', 'sao-jose-de-caiana', '', ''),
(11364, 75, 0, 2, 'São José de Espinharas', '', 'sao-jose-de-espinharas', '', ''),
(11365, 75, 0, 2, 'São José de Piranhas', '', 'sao-jose-de-piranhas', '', ''),
(11366, 75, 0, 2, 'São José de Princesa', '', 'sao-jose-de-princesa', '', ''),
(11367, 75, 0, 2, 'São José do Bonfim', '', 'sao-jose-do-bonfim', '', ''),
(11368, 75, 0, 2, 'São José do Brejo do Cruz', '', 'sao-jose-do-brejo-do-cruz', '', ''),
(11369, 75, 0, 2, 'São José do Sabugi', '', 'sao-jose-do-sabugi', '', ''),
(11370, 75, 0, 2, 'São José dos Cordeiros', '', 'sao-jose-dos-cordeiros', '', ''),
(11371, 75, 0, 2, 'São José dos Ramos', '', 'sao-jose-dos-ramos', '', ''),
(11372, 75, 0, 2, 'São Mamede', '', 'sao-mamede', '', ''),
(11373, 75, 0, 2, 'São Miguel de Taipu', '', 'sao-miguel-de-taipu', '', ''),
(11374, 75, 0, 2, 'São Sebastião de Lagoa de Roça', '', 'sao-sebastiao-de-lagoa-de-roca', '', ''),
(11375, 75, 0, 2, 'São Sebastião do Umbuzeiro', '', 'sao-sebastiao-do-umbuzeiro', '', ''),
(11376, 75, 0, 2, 'Sapé', '', 'sape', '', ''),
(11377, 75, 0, 2, 'Seridó', '', 'serido', '', ''),
(11378, 75, 0, 2, 'Serra Branca', '', 'serra-branca', '', ''),
(11379, 75, 0, 2, 'Serra da Raiz', '', 'serra-da-raiz', '', ''),
(11380, 75, 0, 2, 'Serra Grande', '', 'serra-grande', '', ''),
(11381, 75, 0, 2, 'Serra Redonda', '', 'serra-redonda', '', ''),
(11382, 75, 0, 2, 'Serraria', '', 'serraria', '', ''),
(11383, 75, 0, 2, 'Sertãozinho', '', 'sertaozinho', '', ''),
(11384, 75, 0, 2, 'Sobrado', '', 'sobrado', '', ''),
(11385, 75, 0, 2, 'Solânea', '', 'solanea', '', ''),
(11386, 75, 0, 2, 'Soledade', '', 'soledade', '', ''),
(11387, 75, 0, 2, 'Sossêgo', '', 'sossego', '', ''),
(11388, 75, 0, 2, 'Sousa', '', 'sousa', '', ''),
(11389, 75, 0, 2, 'Sumé', '', 'sume', '', ''),
(11390, 75, 0, 2, 'Taperoá', '', 'taperoa', '', ''),
(11391, 75, 0, 2, 'Tavares', '', 'tavares', '', ''),
(11392, 75, 0, 2, 'Teixeira', '', 'teixeira', '', ''),
(11393, 75, 0, 2, 'Tenório', '', 'tenorio', '', ''),
(11394, 75, 0, 2, 'Triunfo', '', 'triunfo', '', ''),
(11395, 75, 0, 2, 'Uiraúna', '', 'uirauna', '', ''),
(11396, 75, 0, 2, 'Umbuzeiro', '', 'umbuzeiro', '', ''),
(11397, 75, 0, 2, 'Várzea', '', 'varzea', '', ''),
(11398, 75, 0, 2, 'Vieirópolis', '', 'vieiropolis', '', ''),
(11399, 75, 0, 2, 'Vista Serrana', '', 'vista-serrana', '', ''),
(11400, 75, 0, 2, 'Zabelê', '', 'zabele', '', ''),
(11401, 76, 0, 2, 'Abatiá', '', 'abatia', '', ''),
(11402, 76, 0, 2, 'Adrianópolis', '', 'adrianopolis', '', ''),
(11403, 76, 0, 2, 'Agudos do Sul', '', 'agudos-do-sul', '', ''),
(11404, 76, 0, 2, 'Almirante Tamandaré', '', 'almirante-tamandare', '', ''),
(11405, 76, 0, 2, 'Altamira do Paraná', '', 'altamira-do-parana', '', ''),
(11406, 76, 0, 2, 'Alto Paraná', '', 'alto-parana', '', ''),
(11407, 76, 0, 2, 'Alto Piquiri', '', 'alto-piquiri', '', ''),
(11408, 76, 0, 2, 'Altônia', '', 'altonia', '', ''),
(11409, 76, 0, 2, 'Alvorada do Sul', '', 'alvorada-do-sul', '', ''),
(11410, 76, 0, 2, 'Amaporã', '', 'amapora', '', ''),
(11411, 76, 0, 2, 'Ampére', '', 'ampere', '', ''),
(11412, 76, 0, 2, 'Anahy', '', 'anahy', '', ''),
(11413, 76, 0, 2, 'Andirá', '', 'andira', '', ''),
(11414, 76, 0, 2, 'Ângulo', '', 'angulo', '', ''),
(11415, 76, 0, 2, 'Antonina', '', 'antonina', '', ''),
(11416, 76, 0, 2, 'Antônio Olinto', '', 'antonio-olinto', '', ''),
(11417, 76, 0, 2, 'Apucarana', '', 'apucarana', '', ''),
(11418, 76, 0, 2, 'Arapongas', '', 'arapongas', '', ''),
(11419, 76, 0, 2, 'Arapoti', '', 'arapoti', '', ''),
(11420, 76, 0, 2, 'Arapuã', '', 'arapua', '', ''),
(11421, 76, 0, 2, 'Araruna', '', 'araruna', '', ''),
(11422, 76, 0, 2, 'Araucária', '', 'araucaria', '', ''),
(11423, 76, 0, 2, 'Ariranha do Ivaí', '', 'ariranha-do-ivai', '', ''),
(11424, 76, 0, 2, 'Assaí', '', 'assai', '', ''),
(11425, 76, 0, 2, 'Assis Chateaubriand', '', 'assis-chateaubriand', '', ''),
(11426, 76, 0, 2, 'Astorga', '', 'astorga', '', ''),
(11427, 76, 0, 2, 'Atalaia', '', 'atalaia', '', ''),
(11428, 76, 0, 2, 'Balsa Nova', '', 'balsa-nova', '', ''),
(11429, 76, 0, 2, 'Bandeirantes', '', 'bandeirantes', '', ''),
(11430, 76, 0, 2, 'Barbosa Ferraz', '', 'barbosa-ferraz', '', ''),
(11431, 76, 0, 2, 'Barra do Jacaré', '', 'barra-do-jacare', '', ''),
(11432, 76, 0, 2, 'Barracão', '', 'barracao', '', ''),
(11433, 76, 0, 2, 'Bela Vista da Caroba', '', 'bela-vista-da-caroba', '', ''),
(11434, 76, 0, 2, 'Bela Vista do Paraíso', '', 'bela-vista-do-paraiso', '', ''),
(11435, 76, 0, 2, 'Bituruna', '', 'bituruna', '', ''),
(11436, 76, 0, 2, 'Boa Esperança', '', 'boa-esperanca', '', ''),
(11437, 76, 0, 2, 'Boa Esperança do Iguaçu', '', 'boa-esperanca-do-iguacu', '', ''),
(11438, 76, 0, 2, 'Boa Ventura de São Roque', '', 'boa-ventura-de-sao-roque', '', ''),
(11439, 76, 0, 2, 'Boa Vista da Aparecida', '', 'boa-vista-da-aparecida', '', ''),
(11440, 76, 0, 2, 'Bocaiúva do Sul', '', 'bocaiuva-do-sul', '', ''),
(11441, 76, 0, 2, 'Bom Jesus do Sul', '', 'bom-jesus-do-sul', '', ''),
(11442, 76, 0, 2, 'Bom Sucesso', '', 'bom-sucesso', '', ''),
(11443, 76, 0, 2, 'Bom Sucesso do Sul', '', 'bom-sucesso-do-sul', '', ''),
(11444, 76, 0, 2, 'Borrazópolis', '', 'borrazopolis', '', ''),
(11445, 76, 0, 2, 'Braganey', '', 'braganey', '', ''),
(11446, 76, 0, 2, 'Brasilândia do Sul', '', 'brasilandia-do-sul', '', ''),
(11447, 76, 0, 2, 'Cafeara', '', 'cafeara', '', ''),
(11448, 76, 0, 2, 'Cafelândia', '', 'cafelandia', '', ''),
(11449, 76, 0, 2, 'Cafezal do Sul', '', 'cafezal-do-sul', '', ''),
(11450, 76, 0, 2, 'Califórnia', '', 'california', '', ''),
(11451, 76, 0, 2, 'Cambará', '', 'cambara', '', ''),
(11452, 76, 0, 2, 'Cambé', '', 'cambe', '', ''),
(11453, 76, 0, 2, 'Cambira', '', 'cambira', '', ''),
(11454, 76, 0, 2, 'Campina da Lagoa', '', 'campina-da-lagoa', '', ''),
(11455, 76, 0, 2, 'Campina do Simão', '', 'campina-do-simao', '', ''),
(11456, 76, 0, 2, 'Campina Grande do Sul', '', 'campina-grande-do-sul', '', ''),
(11457, 76, 0, 2, 'Campo Bonito', '', 'campo-bonito', '', ''),
(11458, 76, 0, 2, 'Campo do Tenente', '', 'campo-do-tenente', '', ''),
(11459, 76, 0, 2, 'Campo Largo', '', 'campo-largo', '', ''),
(11460, 76, 0, 2, 'Campo Magro', '', 'campo-magro', '', ''),
(11461, 76, 0, 2, 'Campo Mourão', '', 'campo-mourao', '', ''),
(11462, 76, 0, 2, 'Cândido de Abreu', '', 'candido-de-abreu', '', ''),
(11463, 76, 0, 2, 'Candói', '', 'candoi', '', ''),
(11464, 76, 0, 2, 'Cantagalo', '', 'cantagalo', '', ''),
(11465, 76, 0, 2, 'Capanema', '', 'capanema', '', ''),
(11466, 76, 0, 2, 'Capitão Leônidas Marques', '', 'capitao-leonidas-marques', '', ''),
(11467, 76, 0, 2, 'Carambeí', '', 'carambei', '', ''),
(11468, 76, 0, 2, 'Carlópolis', '', 'carlopolis', '', ''),
(11469, 76, 0, 2, 'Cascavel', '', 'cascavel', '', ''),
(11470, 76, 0, 2, 'Castro', '', 'castro', '', ''),
(11471, 76, 0, 2, 'Catanduvas', '', 'catanduvas', '', ''),
(11472, 76, 0, 2, 'Centenário do Sul', '', 'centenario-do-sul', '', ''),
(11473, 76, 0, 2, 'Cerro Azul', '', 'cerro-azul', '', ''),
(11474, 76, 0, 2, 'Céu Azul', '', 'ceu-azul', '', ''),
(11475, 76, 0, 2, 'Chopinzinho', '', 'chopinzinho', '', ''),
(11476, 76, 0, 2, 'Cianorte', '', 'cianorte', '', ''),
(11477, 76, 0, 2, 'Cidade Gaúcha', '', 'cidade-gaucha', '', ''),
(11478, 76, 0, 2, 'Clevelândia', '', 'clevelandia', '', ''),
(11479, 76, 0, 2, 'Colombo', '', 'colombo', '', ''),
(11480, 76, 0, 2, 'Colorado', '', 'colorado', '', ''),
(11481, 76, 0, 2, 'Congonhinhas', '', 'congonhinhas', '', ''),
(11482, 76, 0, 2, 'Conselheiro Mairinck', '', 'conselheiro-mairinck', '', ''),
(11483, 76, 0, 2, 'Contenda', '', 'contenda', '', ''),
(11484, 76, 0, 2, 'Corbélia', '', 'corbelia', '', ''),
(11485, 76, 0, 2, 'Cornélio Procópio', '', 'cornelio-procopio', '', ''),
(11486, 76, 0, 2, 'Coronel Domingos Soares', '', 'coronel-domingos-soares', '', ''),
(11487, 76, 0, 2, 'Coronel Vivida', '', 'coronel-vivida', '', ''),
(11488, 76, 0, 2, 'Corumbataí do Sul', '', 'corumbatai-do-sul', '', ''),
(11489, 76, 0, 2, 'Cruz Machado', '', 'cruz-machado', '', ''),
(11490, 76, 0, 2, 'Cruzeiro do Iguaçu', '', 'cruzeiro-do-iguacu', '', ''),
(11491, 76, 0, 2, 'Cruzeiro do Oeste', '', 'cruzeiro-do-oeste', '', ''),
(11492, 76, 0, 2, 'Cruzeiro do Sul', '', 'cruzeiro-do-sul', '', ''),
(11493, 76, 0, 2, 'Cruzmaltina', '', 'cruzmaltina', '', ''),
(11494, 76, 0, 2, 'Curitiba', '', 'curitiba', '', ''),
(11495, 76, 0, 2, 'Curiúva', '', 'curiuva', '', ''),
(11496, 76, 0, 2, 'Diamante d`Oeste', '', 'diamante-d`oeste', '', ''),
(11497, 76, 0, 2, 'Diamante do Norte', '', 'diamante-do-norte', '', ''),
(11498, 76, 0, 2, 'Diamante do Sul', '', 'diamante-do-sul', '', ''),
(11499, 76, 0, 2, 'Dois Vizinhos', '', 'dois-vizinhos', '', ''),
(11500, 76, 0, 2, 'Douradina', '', 'douradina', '', ''),
(11501, 76, 0, 2, 'Doutor Camargo', '', 'doutor-camargo', '', ''),
(11502, 76, 0, 2, 'Doutor Ulysses', '', 'doutor-ulysses', '', ''),
(11503, 76, 0, 2, 'Enéas Marques', '', 'eneas-marques', '', ''),
(11504, 76, 0, 2, 'Engenheiro Beltrão', '', 'engenheiro-beltrao', '', ''),
(11505, 76, 0, 2, 'Entre Rios do Oeste', '', 'entre-rios-do-oeste', '', ''),
(11506, 76, 0, 2, 'Esperança Nova', '', 'esperanca-nova', '', ''),
(11507, 76, 0, 2, 'Espigão Alto do Iguaçu', '', 'espigao-alto-do-iguacu', '', ''),
(11508, 76, 0, 2, 'Farol', '', 'farol', '', ''),
(11509, 76, 0, 2, 'Faxinal', '', 'faxinal', '', ''),
(11510, 76, 0, 2, 'Fazenda Rio Grande', '', 'fazenda-rio-grande', '', ''),
(11511, 76, 0, 2, 'Fênix', '', 'fenix', '', ''),
(11512, 76, 0, 2, 'Fernandes Pinheiro', '', 'fernandes-pinheiro', '', ''),
(11513, 76, 0, 2, 'Figueira', '', 'figueira', '', ''),
(11514, 76, 0, 2, 'Flor da Serra do Sul', '', 'flor-da-serra-do-sul', '', ''),
(11515, 76, 0, 2, 'Floraí', '', 'florai', '', ''),
(11516, 76, 0, 2, 'Floresta', '', 'floresta', '', ''),
(11517, 76, 0, 2, 'Florestópolis', '', 'florestopolis', '', ''),
(11518, 76, 0, 2, 'Flórida', '', 'florida', '', ''),
(11519, 76, 0, 2, 'Formosa do Oeste', '', 'formosa-do-oeste', '', ''),
(11520, 76, 0, 2, 'Foz do Iguaçu', '', 'foz-do-iguacu', '', ''),
(11521, 76, 0, 2, 'Foz do Jordão', '', 'foz-do-jordao', '', ''),
(11522, 76, 0, 2, 'Francisco Alves', '', 'francisco-alves', '', ''),
(11523, 76, 0, 2, 'Francisco Beltrão', '', 'francisco-beltrao', '', ''),
(11524, 76, 0, 2, 'General Carneiro', '', 'general-carneiro', '', ''),
(11525, 76, 0, 2, 'Godoy Moreira', '', 'godoy-moreira', '', ''),
(11526, 76, 0, 2, 'Goioerê', '', 'goioere', '', ''),
(11527, 76, 0, 2, 'Goioxim', '', 'goioxim', '', ''),
(11528, 76, 0, 2, 'Grandes Rios', '', 'grandes-rios', '', ''),
(11529, 76, 0, 2, 'Guaíra', '', 'guaira', '', ''),
(11530, 76, 0, 2, 'Guairaçá', '', 'guairaca', '', ''),
(11531, 76, 0, 2, 'Guamiranga', '', 'guamiranga', '', ''),
(11532, 76, 0, 2, 'Guapirama', '', 'guapirama', '', ''),
(11533, 76, 0, 2, 'Guaporema', '', 'guaporema', '', ''),
(11534, 76, 0, 2, 'Guaraci', '', 'guaraci', '', ''),
(11535, 76, 0, 2, 'Guaraniaçu', '', 'guaraniacu', '', ''),
(11536, 76, 0, 2, 'Guarapuava', '', 'guarapuava', '', ''),
(11537, 76, 0, 2, 'Guaraqueçaba', '', 'guaraquecaba', '', ''),
(11538, 76, 0, 2, 'Guaratuba', '', 'guaratuba', '', ''),
(11539, 76, 0, 2, 'Honório Serpa', '', 'honorio-serpa', '', ''),
(11540, 76, 0, 2, 'Ibaiti', '', 'ibaiti', '', ''),
(11541, 76, 0, 2, 'Ibema', '', 'ibema', '', ''),
(11542, 76, 0, 2, 'Ibiporã', '', 'ibipora', '', ''),
(11543, 76, 0, 2, 'Icaraíma', '', 'icaraima', '', ''),
(11544, 76, 0, 2, 'Iguaraçu', '', 'iguaracu', '', ''),
(11545, 76, 0, 2, 'Iguatu', '', 'iguatu', '', ''),
(11546, 76, 0, 2, 'Imbaú', '', 'imbau', '', ''),
(11547, 76, 0, 2, 'Imbituva', '', 'imbituva', '', ''),
(11548, 76, 0, 2, 'Inácio Martins', '', 'inacio-martins', '', ''),
(11549, 76, 0, 2, 'Inajá', '', 'inaja', '', ''),
(11550, 76, 0, 2, 'Indianópolis', '', 'indianopolis', '', ''),
(11551, 76, 0, 2, 'Ipiranga', '', 'ipiranga', '', ''),
(11552, 76, 0, 2, 'Iporã', '', 'ipora', '', ''),
(11553, 76, 0, 2, 'Iracema do Oeste', '', 'iracema-do-oeste', '', ''),
(11554, 76, 0, 2, 'Irati', '', 'irati', '', ''),
(11555, 76, 0, 2, 'Iretama', '', 'iretama', '', ''),
(11556, 76, 0, 2, 'Itaguajé', '', 'itaguaje', '', ''),
(11557, 76, 0, 2, 'Itaipulândia', '', 'itaipulandia', '', ''),
(11558, 76, 0, 2, 'Itambaracá', '', 'itambaraca', '', ''),
(11559, 76, 0, 2, 'Itambé', '', 'itambe', '', ''),
(11560, 76, 0, 2, 'Itapejara d`Oeste', '', 'itapejara-d`oeste', '', ''),
(11561, 76, 0, 2, 'Itaperuçu', '', 'itaperucu', '', ''),
(11562, 76, 0, 2, 'Itaúna do Sul', '', 'itauna-do-sul', '', ''),
(11563, 76, 0, 2, 'Ivaí', '', 'ivai', '', ''),
(11564, 76, 0, 2, 'Ivaiporã', '', 'ivaipora', '', ''),
(11565, 76, 0, 2, 'Ivaté', '', 'ivate', '', ''),
(11566, 76, 0, 2, 'Ivatuba', '', 'ivatuba', '', ''),
(11567, 76, 0, 2, 'Jaboti', '', 'jaboti', '', ''),
(11568, 76, 0, 2, 'Jacarezinho', '', 'jacarezinho', '', ''),
(11569, 76, 0, 2, 'Jaguapitã', '', 'jaguapita', '', ''),
(11570, 76, 0, 2, 'Jaguariaíva', '', 'jaguariaiva', '', ''),
(11571, 76, 0, 2, 'Jandaia do Sul', '', 'jandaia-do-sul', '', ''),
(11572, 76, 0, 2, 'Janiópolis', '', 'janiopolis', '', ''),
(11573, 76, 0, 2, 'Japira', '', 'japira', '', ''),
(11574, 76, 0, 2, 'Japurá', '', 'japura', '', ''),
(11575, 76, 0, 2, 'Jardim Alegre', '', 'jardim-alegre', '', ''),
(11576, 76, 0, 2, 'Jardim Olinda', '', 'jardim-olinda', '', ''),
(11577, 76, 0, 2, 'Jataizinho', '', 'jataizinho', '', ''),
(11578, 76, 0, 2, 'Jesuítas', '', 'jesuitas', '', ''),
(11579, 76, 0, 2, 'Joaquim Távora', '', 'joaquim-tavora', '', ''),
(11580, 76, 0, 2, 'Jundiaí do Sul', '', 'jundiai-do-sul', '', ''),
(11581, 76, 0, 2, 'Juranda', '', 'juranda', '', ''),
(11582, 76, 0, 2, 'Jussara', '', 'jussara', '', ''),
(11583, 76, 0, 2, 'Kaloré', '', 'kalore', '', ''),
(11584, 76, 0, 2, 'Lapa', '', 'lapa', '', ''),
(11585, 76, 0, 2, 'Laranjal', '', 'laranjal', '', ''),
(11586, 76, 0, 2, 'Laranjeiras do Sul', '', 'laranjeiras-do-sul', '', ''),
(11587, 76, 0, 2, 'Leópolis', '', 'leopolis', '', ''),
(11588, 76, 0, 2, 'Lidianópolis', '', 'lidianopolis', '', ''),
(11589, 76, 0, 2, 'Lindoeste', '', 'lindoeste', '', ''),
(11590, 76, 0, 2, 'Loanda', '', 'loanda', '', ''),
(11591, 76, 0, 2, 'Lobato', '', 'lobato', '', ''),
(11592, 76, 0, 2, 'Londrina', '', 'londrina', '', ''),
(11593, 76, 0, 2, 'Luiziana', '', 'luiziana', '', ''),
(11594, 76, 0, 2, 'Lunardelli', '', 'lunardelli', '', ''),
(11595, 76, 0, 2, 'Lupionópolis', '', 'lupionopolis', '', ''),
(11596, 76, 0, 2, 'Mallet', '', 'mallet', '', ''),
(11597, 76, 0, 2, 'Mamborê', '', 'mambore', '', ''),
(11598, 76, 0, 2, 'Mandaguaçu', '', 'mandaguacu', '', ''),
(11599, 76, 0, 2, 'Mandaguari', '', 'mandaguari', '', ''),
(11600, 76, 0, 2, 'Mandirituba', '', 'mandirituba', '', ''),
(11601, 76, 0, 2, 'Manfrinópolis', '', 'manfrinopolis', '', ''),
(11602, 76, 0, 2, 'Mangueirinha', '', 'mangueirinha', '', ''),
(11603, 76, 0, 2, 'Manoel Ribas', '', 'manoel-ribas', '', ''),
(11604, 76, 0, 2, 'Marechal Cândido Rondon', '', 'marechal-candido-rondon', '', ''),
(11605, 76, 0, 2, 'Maria Helena', '', 'maria-helena', '', ''),
(11606, 76, 0, 2, 'Marialva', '', 'marialva', '', ''),
(11607, 76, 0, 2, 'Marilândia do Sul', '', 'marilandia-do-sul', '', ''),
(11608, 76, 0, 2, 'Marilena', '', 'marilena', '', ''),
(11609, 76, 0, 2, 'Mariluz', '', 'mariluz', '', ''),
(11610, 76, 0, 2, 'Maringá', '', 'maringa', '', ''),
(11611, 76, 0, 2, 'Mariópolis', '', 'mariopolis', '', ''),
(11612, 76, 0, 2, 'Maripá', '', 'maripa', '', ''),
(11613, 76, 0, 2, 'Marmeleiro', '', 'marmeleiro', '', ''),
(11614, 76, 0, 2, 'Marquinho', '', 'marquinho', '', ''),
(11615, 76, 0, 2, 'Marumbi', '', 'marumbi', '', ''),
(11616, 76, 0, 2, 'Matelândia', '', 'matelandia', '', ''),
(11617, 76, 0, 2, 'Matinhos', '', 'matinhos', '', ''),
(11618, 76, 0, 2, 'Mato Rico', '', 'mato-rico', '', ''),
(11619, 76, 0, 2, 'Mauá da Serra', '', 'maua-da-serra', '', ''),
(11620, 76, 0, 2, 'Medianeira', '', 'medianeira', '', ''),
(11621, 76, 0, 2, 'Mercedes', '', 'mercedes', '', ''),
(11622, 76, 0, 2, 'Mirador', '', 'mirador', '', ''),
(11623, 76, 0, 2, 'Miraselva', '', 'miraselva', '', ''),
(11624, 76, 0, 2, 'Missal', '', 'missal', '', ''),
(11625, 76, 0, 2, 'Moreira Sales', '', 'moreira-sales', '', ''),
(11626, 76, 0, 2, 'Morretes', '', 'morretes', '', ''),
(11627, 76, 0, 2, 'Munhoz de Melo', '', 'munhoz-de-melo', '', ''),
(11628, 76, 0, 2, 'Nossa Senhora das Graças', '', 'nossa-senhora-das-gracas', '', ''),
(11629, 76, 0, 2, 'Nova Aliança do Ivaí', '', 'nova-alianca-do-ivai', '', ''),
(11630, 76, 0, 2, 'Nova América da Colina', '', 'nova-america-da-colina', '', ''),
(11631, 76, 0, 2, 'Nova Aurora', '', 'nova-aurora', '', ''),
(11632, 76, 0, 2, 'Nova Cantu', '', 'nova-cantu', '', ''),
(11633, 76, 0, 2, 'Nova Esperança', '', 'nova-esperanca', '', ''),
(11634, 76, 0, 2, 'Nova Esperança do Sudoeste', '', 'nova-esperanca-do-sudoeste', '', ''),
(11635, 76, 0, 2, 'Nova Fátima', '', 'nova-fatima', '', ''),
(11636, 76, 0, 2, 'Nova Laranjeiras', '', 'nova-laranjeiras', '', ''),
(11637, 76, 0, 2, 'Nova Londrina', '', 'nova-londrina', '', ''),
(11638, 76, 0, 2, 'Nova Olímpia', '', 'nova-olimpia', '', ''),
(11639, 76, 0, 2, 'Nova Prata do Iguaçu', '', 'nova-prata-do-iguacu', '', ''),
(11640, 76, 0, 2, 'Nova Santa Bárbara', '', 'nova-santa-barbara', '', ''),
(11641, 76, 0, 2, 'Nova Santa Rosa', '', 'nova-santa-rosa', '', ''),
(11642, 76, 0, 2, 'Nova Tebas', '', 'nova-tebas', '', ''),
(11643, 76, 0, 2, 'Novo Itacolomi', '', 'novo-itacolomi', '', ''),
(11644, 76, 0, 2, 'Ortigueira', '', 'ortigueira', '', ''),
(11645, 76, 0, 2, 'Ourizona', '', 'ourizona', '', ''),
(11646, 76, 0, 2, 'Ouro Verde do Oeste', '', 'ouro-verde-do-oeste', '', ''),
(11647, 76, 0, 2, 'Paiçandu', '', 'paicandu', '', ''),
(11648, 76, 0, 2, 'Palmas', '', 'palmas', '', ''),
(11649, 76, 0, 2, 'Palmeira', '', 'palmeira', '', ''),
(11650, 76, 0, 2, 'Palmital', '', 'palmital', '', ''),
(11651, 76, 0, 2, 'Palotina', '', 'palotina', '', ''),
(11652, 76, 0, 2, 'Paraíso do Norte', '', 'paraiso-do-norte', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(11653, 76, 0, 2, 'Paranacity', '', 'paranacity', '', ''),
(11654, 76, 0, 2, 'Paranaguá', '', 'paranagua', '', ''),
(11655, 76, 0, 2, 'Paranapoema', '', 'paranapoema', '', ''),
(11656, 76, 0, 2, 'Paranavaí', '', 'paranavai', '', ''),
(11657, 76, 0, 2, 'Pato Bragado', '', 'pato-bragado', '', ''),
(11658, 76, 0, 2, 'Pato Branco', '', 'pato-branco', '', ''),
(11659, 76, 0, 2, 'Paula Freitas', '', 'paula-freitas', '', ''),
(11660, 76, 0, 2, 'Paulo Frontin', '', 'paulo-frontin', '', ''),
(11661, 76, 0, 2, 'Peabiru', '', 'peabiru', '', ''),
(11662, 76, 0, 2, 'Perobal', '', 'perobal', '', ''),
(11663, 76, 0, 2, 'Pérola', '', 'perola', '', ''),
(11664, 76, 0, 2, 'Pérola d`Oeste', '', 'perola-d`oeste', '', ''),
(11665, 76, 0, 2, 'Piên', '', 'pien', '', ''),
(11666, 76, 0, 2, 'Pinhais', '', 'pinhais', '', ''),
(11667, 76, 0, 2, 'Pinhal de São Bento', '', 'pinhal-de-sao-bento', '', ''),
(11668, 76, 0, 2, 'Pinhalão', '', 'pinhalao', '', ''),
(11669, 76, 0, 2, 'Pinhão', '', 'pinhao', '', ''),
(11670, 76, 0, 2, 'Piraí do Sul', '', 'pirai-do-sul', '', ''),
(11671, 76, 0, 2, 'Piraquara', '', 'piraquara', '', ''),
(11672, 76, 0, 2, 'Pitanga', '', 'pitanga', '', ''),
(11673, 76, 0, 2, 'Pitangueiras', '', 'pitangueiras', '', ''),
(11674, 76, 0, 2, 'Planaltina do Paraná', '', 'planaltina-do-parana', '', ''),
(11675, 76, 0, 2, 'Planalto', '', 'planalto', '', ''),
(11676, 76, 0, 2, 'Ponta Grossa', '', 'ponta-grossa', '', ''),
(11677, 76, 0, 2, 'Pontal do Paraná', '', 'pontal-do-parana', '', ''),
(11678, 76, 0, 2, 'Porecatu', '', 'porecatu', '', ''),
(11679, 76, 0, 2, 'Porto Amazonas', '', 'porto-amazonas', '', ''),
(11680, 76, 0, 2, 'Porto Barreiro', '', 'porto-barreiro', '', ''),
(11681, 76, 0, 2, 'Porto Rico', '', 'porto-rico', '', ''),
(11682, 76, 0, 2, 'Porto Vitória', '', 'porto-vitoria', '', ''),
(11683, 76, 0, 2, 'Prado Ferreira', '', 'prado-ferreira', '', ''),
(11684, 76, 0, 2, 'Pranchita', '', 'pranchita', '', ''),
(11685, 76, 0, 2, 'Presidente Castelo Branco', '', 'presidente-castelo-branco', '', ''),
(11686, 76, 0, 2, 'Primeiro de Maio', '', 'primeiro-de-maio', '', ''),
(11687, 76, 0, 2, 'Prudentópolis', '', 'prudentopolis', '', ''),
(11688, 76, 0, 2, 'Quarto Centenário', '', 'quarto-centenario', '', ''),
(11689, 76, 0, 2, 'Quatiguá', '', 'quatigua', '', ''),
(11690, 76, 0, 2, 'Quatro Barras', '', 'quatro-barras', '', ''),
(11691, 76, 0, 2, 'Quatro Pontes', '', 'quatro-pontes', '', ''),
(11692, 76, 0, 2, 'Quedas do Iguaçu', '', 'quedas-do-iguacu', '', ''),
(11693, 76, 0, 2, 'Querência do Norte', '', 'querencia-do-norte', '', ''),
(11694, 76, 0, 2, 'Quinta do Sol', '', 'quinta-do-sol', '', ''),
(11695, 76, 0, 2, 'Quitandinha', '', 'quitandinha', '', ''),
(11696, 76, 0, 2, 'Ramilândia', '', 'ramilandia', '', ''),
(11697, 76, 0, 2, 'Rancho Alegre', '', 'rancho-alegre', '', ''),
(11698, 76, 0, 2, 'Rancho Alegre d`Oeste', '', 'rancho-alegre-d`oeste', '', ''),
(11699, 76, 0, 2, 'Realeza', '', 'realeza', '', ''),
(11700, 76, 0, 2, 'Rebouças', '', 'reboucas', '', ''),
(11701, 76, 0, 2, 'Renascença', '', 'renascenca', '', ''),
(11702, 76, 0, 2, 'Reserva', '', 'reserva', '', ''),
(11703, 76, 0, 2, 'Reserva do Iguaçu', '', 'reserva-do-iguacu', '', ''),
(11704, 76, 0, 2, 'Ribeirão Claro', '', 'ribeirao-claro', '', ''),
(11705, 76, 0, 2, 'Ribeirão do Pinhal', '', 'ribeirao-do-pinhal', '', ''),
(11706, 76, 0, 2, 'Rio Azul', '', 'rio-azul', '', ''),
(11707, 76, 0, 2, 'Rio Bom', '', 'rio-bom', '', ''),
(11708, 76, 0, 2, 'Rio Bonito do Iguaçu', '', 'rio-bonito-do-iguacu', '', ''),
(11709, 76, 0, 2, 'Rio Branco do Ivaí', '', 'rio-branco-do-ivai', '', ''),
(11710, 76, 0, 2, 'Rio Branco do Sul', '', 'rio-branco-do-sul', '', ''),
(11711, 76, 0, 2, 'Rio Negro', '', 'rio-negro', '', ''),
(11712, 76, 0, 2, 'Rolândia', '', 'rolandia', '', ''),
(11713, 76, 0, 2, 'Roncador', '', 'roncador', '', ''),
(11714, 76, 0, 2, 'Rondon', '', 'rondon', '', ''),
(11715, 76, 0, 2, 'Rosário do Ivaí', '', 'rosario-do-ivai', '', ''),
(11716, 76, 0, 2, 'Sabáudia', '', 'sabaudia', '', ''),
(11717, 76, 0, 2, 'Salgado Filho', '', 'salgado-filho', '', ''),
(11718, 76, 0, 2, 'Salto do Itararé', '', 'salto-do-itarare', '', ''),
(11719, 76, 0, 2, 'Salto do Lontra', '', 'salto-do-lontra', '', ''),
(11720, 76, 0, 2, 'Santa Amélia', '', 'santa-amelia', '', ''),
(11721, 76, 0, 2, 'Santa Cecília do Pavão', '', 'santa-cecilia-do-pavao', '', ''),
(11722, 76, 0, 2, 'Santa Cruz de Monte Castelo', '', 'santa-cruz-de-monte-castelo', '', ''),
(11723, 76, 0, 2, 'Santa Fé', '', 'santa-fe', '', ''),
(11724, 76, 0, 2, 'Santa Helena', '', 'santa-helena', '', ''),
(11725, 76, 0, 2, 'Santa Inês', '', 'santa-ines', '', ''),
(11726, 76, 0, 2, 'Santa Isabel do Ivaí', '', 'santa-isabel-do-ivai', '', ''),
(11727, 76, 0, 2, 'Santa Izabel do Oeste', '', 'santa-izabel-do-oeste', '', ''),
(11728, 76, 0, 2, 'Santa Lúcia', '', 'santa-lucia', '', ''),
(11729, 76, 0, 2, 'Santa Maria do Oeste', '', 'santa-maria-do-oeste', '', ''),
(11730, 76, 0, 2, 'Santa Mariana', '', 'santa-mariana', '', ''),
(11731, 76, 0, 2, 'Santa Mônica', '', 'santa-monica', '', ''),
(11732, 76, 0, 2, 'Santa Tereza do Oeste', '', 'santa-tereza-do-oeste', '', ''),
(11733, 76, 0, 2, 'Santa Terezinha de Itaipu', '', 'santa-terezinha-de-itaipu', '', ''),
(11734, 76, 0, 2, 'Santana do Itararé', '', 'santana-do-itarare', '', ''),
(11735, 76, 0, 2, 'Santo Antônio da Platina', '', 'santo-antonio-da-platina', '', ''),
(11736, 76, 0, 2, 'Santo Antônio do Caiuá', '', 'santo-antonio-do-caiua', '', ''),
(11737, 76, 0, 2, 'Santo Antônio do Paraíso', '', 'santo-antonio-do-paraiso', '', ''),
(11738, 76, 0, 2, 'Santo Antônio do Sudoeste', '', 'santo-antonio-do-sudoeste', '', ''),
(11739, 76, 0, 2, 'Santo Inácio', '', 'santo-inacio', '', ''),
(11740, 76, 0, 2, 'São Carlos do Ivaí', '', 'sao-carlos-do-ivai', '', ''),
(11741, 76, 0, 2, 'São Jerônimo da Serra', '', 'sao-jeronimo-da-serra', '', ''),
(11742, 76, 0, 2, 'São João', '', 'sao-joao', '', ''),
(11743, 76, 0, 2, 'São João do Caiuá', '', 'sao-joao-do-caiua', '', ''),
(11744, 76, 0, 2, 'São João do Ivaí', '', 'sao-joao-do-ivai', '', ''),
(11745, 76, 0, 2, 'São João do Triunfo', '', 'sao-joao-do-triunfo', '', ''),
(11746, 76, 0, 2, 'São Jorge d`Oeste', '', 'sao-jorge-d`oeste', '', ''),
(11747, 76, 0, 2, 'São Jorge do Ivaí', '', 'sao-jorge-do-ivai', '', ''),
(11748, 76, 0, 2, 'São Jorge do Patrocínio', '', 'sao-jorge-do-patrocinio', '', ''),
(11749, 76, 0, 2, 'São José da Boa Vista', '', 'sao-jose-da-boa-vista', '', ''),
(11750, 76, 0, 2, 'São José das Palmeiras', '', 'sao-jose-das-palmeiras', '', ''),
(11751, 76, 0, 2, 'São José dos Pinhais', '', 'sao-jose-dos-pinhais', '', ''),
(11752, 76, 0, 2, 'São Manoel do Paraná', '', 'sao-manoel-do-parana', '', ''),
(11753, 76, 0, 2, 'São Mateus do Sul', '', 'sao-mateus-do-sul', '', ''),
(11754, 76, 0, 2, 'São Miguel do Iguaçu', '', 'sao-miguel-do-iguacu', '', ''),
(11755, 76, 0, 2, 'São Pedro do Iguaçu', '', 'sao-pedro-do-iguacu', '', ''),
(11756, 76, 0, 2, 'São Pedro do Ivaí', '', 'sao-pedro-do-ivai', '', ''),
(11757, 76, 0, 2, 'São Pedro do Paraná', '', 'sao-pedro-do-parana', '', ''),
(11758, 76, 0, 2, 'São Sebastião da Amoreira', '', 'sao-sebastiao-da-amoreira', '', ''),
(11759, 76, 0, 2, 'São Tomé', '', 'sao-tome', '', ''),
(11760, 76, 0, 2, 'Sapopema', '', 'sapopema', '', ''),
(11761, 76, 0, 2, 'Sarandi', '', 'sarandi', '', ''),
(11762, 76, 0, 2, 'Saudade do Iguaçu', '', 'saudade-do-iguacu', '', ''),
(11763, 76, 0, 2, 'Sengés', '', 'senges', '', ''),
(11764, 76, 0, 2, 'Serranópolis do Iguaçu', '', 'serranopolis-do-iguacu', '', ''),
(11765, 76, 0, 2, 'Sertaneja', '', 'sertaneja', '', ''),
(11766, 76, 0, 2, 'Sertanópolis', '', 'sertanopolis', '', ''),
(11767, 76, 0, 2, 'Siqueira Campos', '', 'siqueira-campos', '', ''),
(11768, 76, 0, 2, 'Sulina', '', 'sulina', '', ''),
(11769, 76, 0, 2, 'Tamarana', '', 'tamarana', '', ''),
(11770, 76, 0, 2, 'Tamboara', '', 'tamboara', '', ''),
(11771, 76, 0, 2, 'Tapejara', '', 'tapejara', '', ''),
(11772, 76, 0, 2, 'Tapira', '', 'tapira', '', ''),
(11773, 76, 0, 2, 'Teixeira Soares', '', 'teixeira-soares', '', ''),
(11774, 76, 0, 2, 'Telêmaco Borba', '', 'telemaco-borba', '', ''),
(11775, 76, 0, 2, 'Terra Boa', '', 'terra-boa', '', ''),
(11776, 76, 0, 2, 'Terra Rica', '', 'terra-rica', '', ''),
(11777, 76, 0, 2, 'Terra Roxa', '', 'terra-roxa', '', ''),
(11778, 76, 0, 2, 'Tibagi', '', 'tibagi', '', ''),
(11779, 76, 0, 2, 'Tijucas do Sul', '', 'tijucas-do-sul', '', ''),
(11780, 76, 0, 2, 'Toledo', '', 'toledo', '', ''),
(11781, 76, 0, 2, 'Tomazina', '', 'tomazina', '', ''),
(11782, 76, 0, 2, 'Três Barras do Paraná', '', 'tres-barras-do-parana', '', ''),
(11783, 76, 0, 2, 'Tunas do Paraná', '', 'tunas-do-parana', '', ''),
(11784, 76, 0, 2, 'Tuneiras do Oeste', '', 'tuneiras-do-oeste', '', ''),
(11785, 76, 0, 2, 'Tupãssi', '', 'tupassi', '', ''),
(11786, 76, 0, 2, 'Turvo', '', 'turvo', '', ''),
(11787, 76, 0, 2, 'Ubiratã', '', 'ubirata', '', ''),
(11788, 76, 0, 2, 'Umuarama', '', 'umuarama', '', ''),
(11789, 76, 0, 2, 'União da Vitória', '', 'uniao-da-vitoria', '', ''),
(11790, 76, 0, 2, 'Uniflor', '', 'uniflor', '', ''),
(11791, 76, 0, 2, 'Uraí', '', 'urai', '', ''),
(11792, 76, 0, 2, 'Ventania', '', 'ventania', '', ''),
(11793, 76, 0, 2, 'Vera Cruz do Oeste', '', 'vera-cruz-do-oeste', '', ''),
(11794, 76, 0, 2, 'Verê', '', 'vere', '', ''),
(11795, 76, 0, 2, 'Vila Alta', '', 'vila-alta', '', ''),
(11796, 76, 0, 2, 'Virmond', '', 'virmond', '', ''),
(11797, 76, 0, 2, 'Vitorino', '', 'vitorino', '', ''),
(11798, 76, 0, 2, 'Wenceslau Braz', '', 'wenceslau-braz', '', ''),
(11799, 76, 0, 2, 'Xambrê', '', 'xambre', '', ''),
(11800, 77, 0, 2, 'Abreu e Lima', '', 'abreu-e-lima', '', ''),
(11801, 77, 0, 2, 'Afogados da Ingazeira', '', 'afogados-da-ingazeira', '', ''),
(11802, 77, 0, 2, 'Afrânio', '', 'afranio', '', ''),
(11803, 77, 0, 2, 'Agrestina', '', 'agrestina', '', ''),
(11804, 77, 0, 2, 'Água Preta', '', 'agua-preta', '', ''),
(11805, 77, 0, 2, 'Águas Belas', '', 'aguas-belas', '', ''),
(11806, 77, 0, 2, 'Alagoinha', '', 'alagoinha', '', ''),
(11807, 77, 0, 2, 'Aliança', '', 'alianca', '', ''),
(11808, 77, 0, 2, 'Altinho', '', 'altinho', '', ''),
(11809, 77, 0, 2, 'Amaraji', '', 'amaraji', '', ''),
(11810, 77, 0, 2, 'Angelim', '', 'angelim', '', ''),
(11811, 77, 0, 2, 'Araçoiaba', '', 'aracoiaba', '', ''),
(11812, 77, 0, 2, 'Araripina', '', 'araripina', '', ''),
(11813, 77, 0, 2, 'Arcoverde', '', 'arcoverde', '', ''),
(11814, 77, 0, 2, 'Barra de Guabiraba', '', 'barra-de-guabiraba', '', ''),
(11815, 77, 0, 2, 'Barreiros', '', 'barreiros', '', ''),
(11816, 77, 0, 2, 'Belém de Maria', '', 'belem-de-maria', '', ''),
(11817, 77, 0, 2, 'Belém de São Francisco', '', 'belem-de-sao-francisco', '', ''),
(11818, 77, 0, 2, 'Belo Jardim', '', 'belo-jardim', '', ''),
(11819, 77, 0, 2, 'Betânia', '', 'betania', '', ''),
(11820, 77, 0, 2, 'Bezerros', '', 'bezerros', '', ''),
(11821, 77, 0, 2, 'Bodocó', '', 'bodoco', '', ''),
(11822, 77, 0, 2, 'Bom Conselho', '', 'bom-conselho', '', ''),
(11823, 77, 0, 2, 'Bom Jardim', '', 'bom-jardim', '', ''),
(11824, 77, 0, 2, 'Bonito', '', 'bonito', '', ''),
(11825, 77, 0, 2, 'Brejão', '', 'brejao', '', ''),
(11826, 77, 0, 2, 'Brejinho', '', 'brejinho', '', ''),
(11827, 77, 0, 2, 'Brejo da Madre de Deus', '', 'brejo-da-madre-de-deus', '', ''),
(11828, 77, 0, 2, 'Buenos Aires', '', 'buenos-aires', '', ''),
(11829, 77, 0, 2, 'Buíque', '', 'buique', '', ''),
(11830, 77, 0, 2, 'Cabo de Santo Agostinho', '', 'cabo-de-santo-agostinho', '', ''),
(11831, 77, 0, 2, 'Cabrobó', '', 'cabrobo', '', ''),
(11832, 77, 0, 2, 'Cachoeirinha', '', 'cachoeirinha', '', ''),
(11833, 77, 0, 2, 'Caetés', '', 'caetes', '', ''),
(11834, 77, 0, 2, 'Calçado', '', 'calcado', '', ''),
(11835, 77, 0, 2, 'Calumbi', '', 'calumbi', '', ''),
(11836, 77, 0, 2, 'Camaragibe', '', 'camaragibe', '', ''),
(11837, 77, 0, 2, 'Camocim de São Félix', '', 'camocim-de-sao-felix', '', ''),
(11838, 77, 0, 2, 'Camutanga', '', 'camutanga', '', ''),
(11839, 77, 0, 2, 'Canhotinho', '', 'canhotinho', '', ''),
(11840, 77, 0, 2, 'Capoeiras', '', 'capoeiras', '', ''),
(11841, 77, 0, 2, 'Carnaíba', '', 'carnaiba', '', ''),
(11842, 77, 0, 2, 'Carnaubeira da Penha', '', 'carnaubeira-da-penha', '', ''),
(11843, 77, 0, 2, 'Carpina', '', 'carpina', '', ''),
(11844, 77, 0, 2, 'Caruaru', '', 'caruaru', '', ''),
(11845, 77, 0, 2, 'Casinhas', '', 'casinhas', '', ''),
(11846, 77, 0, 2, 'Catende', '', 'catende', '', ''),
(11847, 77, 0, 2, 'Cedro', '', 'cedro', '', ''),
(11848, 77, 0, 2, 'Chã de Alegria', '', 'cha-de-alegria', '', ''),
(11849, 77, 0, 2, 'Chã Grande', '', 'cha-grande', '', ''),
(11850, 77, 0, 2, 'Condado', '', 'condado', '', ''),
(11851, 77, 0, 2, 'Correntes', '', 'correntes', '', ''),
(11852, 77, 0, 2, 'Cortês', '', 'cortes', '', ''),
(11853, 77, 0, 2, 'Cumaru', '', 'cumaru', '', ''),
(11854, 77, 0, 2, 'Cupira', '', 'cupira', '', ''),
(11855, 77, 0, 2, 'Custódia', '', 'custodia', '', ''),
(11856, 77, 0, 2, 'Dormentes', '', 'dormentes', '', ''),
(11857, 77, 0, 2, 'Escada', '', 'escada', '', ''),
(11858, 77, 0, 2, 'Exu', '', 'exu', '', ''),
(11859, 77, 0, 2, 'Feira Nova', '', 'feira-nova', '', ''),
(11860, 77, 0, 2, 'Fernando de Noronha', '', 'fernando-de-noronha', '', ''),
(11861, 77, 0, 2, 'Ferreiros', '', 'ferreiros', '', ''),
(11862, 77, 0, 2, 'Flores', '', 'flores', '', ''),
(11863, 77, 0, 2, 'Floresta', '', 'floresta', '', ''),
(11864, 77, 0, 2, 'Frei Miguelinho', '', 'frei-miguelinho', '', ''),
(11865, 77, 0, 2, 'Gameleira', '', 'gameleira', '', ''),
(11866, 77, 0, 2, 'Garanhuns', '', 'garanhuns', '', ''),
(11867, 77, 0, 2, 'Glória do Goitá', '', 'gloria-do-goita', '', ''),
(11868, 77, 0, 2, 'Goiana', '', 'goiana', '', ''),
(11869, 77, 0, 2, 'Granito', '', 'granito', '', ''),
(11870, 77, 0, 2, 'Gravatá', '', 'gravata', '', ''),
(11871, 77, 0, 2, 'Iati', '', 'iati', '', ''),
(11872, 77, 0, 2, 'Ibimirim', '', 'ibimirim', '', ''),
(11873, 77, 0, 2, 'Ibirajuba', '', 'ibirajuba', '', ''),
(11874, 77, 0, 2, 'Igarassu', '', 'igarassu', '', ''),
(11875, 77, 0, 2, 'Iguaraci', '', 'iguaraci', '', ''),
(11876, 77, 0, 2, 'Inajá', '', 'inaja', '', ''),
(11877, 77, 0, 2, 'Ingazeira', '', 'ingazeira', '', ''),
(11878, 77, 0, 2, 'Ipojuca', '', 'ipojuca', '', ''),
(11879, 77, 0, 2, 'Ipubi', '', 'ipubi', '', ''),
(11880, 77, 0, 2, 'Itacuruba', '', 'itacuruba', '', ''),
(11881, 77, 0, 2, 'Itaíba', '', 'itaiba', '', ''),
(11882, 77, 0, 2, 'Itamaracá', '', 'itamaraca', '', ''),
(11883, 77, 0, 2, 'Itambé', '', 'itambe', '', ''),
(11884, 77, 0, 2, 'Itapetim', '', 'itapetim', '', ''),
(11885, 77, 0, 2, 'Itapissuma', '', 'itapissuma', '', ''),
(11886, 77, 0, 2, 'Itaquitinga', '', 'itaquitinga', '', ''),
(11887, 77, 0, 2, 'Jaboatão dos Guararapes', '', 'jaboatao-dos-guararapes', '', ''),
(11888, 77, 0, 2, 'Jaqueira', '', 'jaqueira', '', ''),
(11889, 77, 0, 2, 'Jataúba', '', 'jatauba', '', ''),
(11890, 77, 0, 2, 'Jatobá', '', 'jatoba', '', ''),
(11891, 77, 0, 2, 'João Alfredo', '', 'joao-alfredo', '', ''),
(11892, 77, 0, 2, 'Joaquim Nabuco', '', 'joaquim-nabuco', '', ''),
(11893, 77, 0, 2, 'Jucati', '', 'jucati', '', ''),
(11894, 77, 0, 2, 'Jupi', '', 'jupi', '', ''),
(11895, 77, 0, 2, 'Jurema', '', 'jurema', '', ''),
(11896, 77, 0, 2, 'Lagoa do Carro', '', 'lagoa-do-carro', '', ''),
(11897, 77, 0, 2, 'Lagoa do Itaenga', '', 'lagoa-do-itaenga', '', ''),
(11898, 77, 0, 2, 'Lagoa do Ouro', '', 'lagoa-do-ouro', '', ''),
(11899, 77, 0, 2, 'Lagoa dos Gatos', '', 'lagoa-dos-gatos', '', ''),
(11900, 77, 0, 2, 'Lagoa Grande', '', 'lagoa-grande', '', ''),
(11901, 77, 0, 2, 'Lajedo', '', 'lajedo', '', ''),
(11902, 77, 0, 2, 'Limoeiro', '', 'limoeiro', '', ''),
(11903, 77, 0, 2, 'Macaparana', '', 'macaparana', '', ''),
(11904, 77, 0, 2, 'Machados', '', 'machados', '', ''),
(11905, 77, 0, 2, 'Manari', '', 'manari', '', ''),
(11906, 77, 0, 2, 'Maraial', '', 'maraial', '', ''),
(11907, 77, 0, 2, 'Mirandiba', '', 'mirandiba', '', ''),
(11908, 77, 0, 2, 'Moreilândia', '', 'moreilandia', '', ''),
(11909, 77, 0, 2, 'Moreno', '', 'moreno', '', ''),
(11910, 77, 0, 2, 'Nazaré da Mata', '', 'nazare-da-mata', '', ''),
(11911, 77, 0, 2, 'Olinda', '', 'olinda', '', ''),
(11912, 77, 0, 2, 'Orobó', '', 'orobo', '', ''),
(11913, 77, 0, 2, 'Orocó', '', 'oroco', '', ''),
(11914, 77, 0, 2, 'Ouricuri', '', 'ouricuri', '', ''),
(11915, 77, 0, 2, 'Palmares', '', 'palmares', '', ''),
(11916, 77, 0, 2, 'Palmeirina', '', 'palmeirina', '', ''),
(11917, 77, 0, 2, 'Panelas', '', 'panelas', '', ''),
(11918, 77, 0, 2, 'Paranatama', '', 'paranatama', '', ''),
(11919, 77, 0, 2, 'Parnamirim', '', 'parnamirim', '', ''),
(11920, 77, 0, 2, 'Passira', '', 'passira', '', ''),
(11921, 77, 0, 2, 'Paudalho', '', 'paudalho', '', ''),
(11922, 77, 0, 2, 'Paulista', '', 'paulista', '', ''),
(11923, 77, 0, 2, 'Pedra', '', 'pedra', '', ''),
(11924, 77, 0, 2, 'Pesqueira', '', 'pesqueira', '', ''),
(11925, 77, 0, 2, 'Petrolândia', '', 'petrolandia', '', ''),
(11926, 77, 0, 2, 'Petrolina', '', 'petrolina', '', ''),
(11927, 77, 0, 2, 'Poção', '', 'pocao', '', ''),
(11928, 77, 0, 2, 'Pombos', '', 'pombos', '', ''),
(11929, 77, 0, 2, 'Primavera', '', 'primavera', '', ''),
(11930, 77, 0, 2, 'Quipapá', '', 'quipapa', '', ''),
(11931, 77, 0, 2, 'Quixaba', '', 'quixaba', '', ''),
(11932, 77, 0, 2, 'Recife', '', 'recife', '', ''),
(11933, 77, 0, 2, 'Riacho das Almas', '', 'riacho-das-almas', '', ''),
(11934, 77, 0, 2, 'Ribeirão', '', 'ribeirao', '', ''),
(11935, 77, 0, 2, 'Rio Formoso', '', 'rio-formoso', '', ''),
(11936, 77, 0, 2, 'Sairé', '', 'saire', '', ''),
(11937, 77, 0, 2, 'Salgadinho', '', 'salgadinho', '', ''),
(11938, 77, 0, 2, 'Salgueiro', '', 'salgueiro', '', ''),
(11939, 77, 0, 2, 'Saloá', '', 'saloa', '', ''),
(11940, 77, 0, 2, 'Sanharó', '', 'sanharo', '', ''),
(11941, 77, 0, 2, 'Santa Cruz', '', 'santa-cruz', '', ''),
(11942, 77, 0, 2, 'Santa Cruz da Baixa Verde', '', 'santa-cruz-da-baixa-verde', '', ''),
(11943, 77, 0, 2, 'Santa Cruz do Capibaribe', '', 'santa-cruz-do-capibaribe', '', ''),
(11944, 77, 0, 2, 'Santa Filomena', '', 'santa-filomena', '', ''),
(11945, 77, 0, 2, 'Santa Maria da Boa Vista', '', 'santa-maria-da-boa-vista', '', ''),
(11946, 77, 0, 2, 'Santa Maria do Cambucá', '', 'santa-maria-do-cambuca', '', ''),
(11947, 77, 0, 2, 'Santa Terezinha', '', 'santa-terezinha', '', ''),
(11948, 77, 0, 2, 'São Benedito do Sul', '', 'sao-benedito-do-sul', '', ''),
(11949, 77, 0, 2, 'São Bento do Una', '', 'sao-bento-do-una', '', ''),
(11950, 77, 0, 2, 'São Caitano', '', 'sao-caitano', '', ''),
(11951, 77, 0, 2, 'São João', '', 'sao-joao', '', ''),
(11952, 77, 0, 2, 'São Joaquim do Monte', '', 'sao-joaquim-do-monte', '', ''),
(11953, 77, 0, 2, 'São José da Coroa Grande', '', 'sao-jose-da-coroa-grande', '', ''),
(11954, 77, 0, 2, 'São José do Belmonte', '', 'sao-jose-do-belmonte', '', ''),
(11955, 77, 0, 2, 'São José do Egito', '', 'sao-jose-do-egito', '', ''),
(11956, 77, 0, 2, 'São Lourenço da Mata', '', 'sao-lourenco-da-mata', '', ''),
(11957, 77, 0, 2, 'São Vicente Ferrer', '', 'sao-vicente-ferrer', '', ''),
(11958, 77, 0, 2, 'Serra Talhada', '', 'serra-talhada', '', ''),
(11959, 77, 0, 2, 'Serrita', '', 'serrita', '', ''),
(11960, 77, 0, 2, 'Sertânia', '', 'sertania', '', ''),
(11961, 77, 0, 2, 'Sirinhaém', '', 'sirinhaem', '', ''),
(11962, 77, 0, 2, 'Solidão', '', 'solidao', '', ''),
(11963, 77, 0, 2, 'Surubim', '', 'surubim', '', ''),
(11964, 77, 0, 2, 'Tabira', '', 'tabira', '', ''),
(11965, 77, 0, 2, 'Tacaimbó', '', 'tacaimbo', '', ''),
(11966, 77, 0, 2, 'Tacaratu', '', 'tacaratu', '', ''),
(11967, 77, 0, 2, 'Tamandaré', '', 'tamandare', '', ''),
(11968, 77, 0, 2, 'Taquaritinga do Norte', '', 'taquaritinga-do-norte', '', ''),
(11969, 77, 0, 2, 'Terezinha', '', 'terezinha', '', ''),
(11970, 77, 0, 2, 'Terra Nova', '', 'terra-nova', '', ''),
(11971, 77, 0, 2, 'Timbaúba', '', 'timbauba', '', ''),
(11972, 77, 0, 2, 'Toritama', '', 'toritama', '', ''),
(11973, 77, 0, 2, 'Tracunhaém', '', 'tracunhaem', '', ''),
(11974, 77, 0, 2, 'Trindade', '', 'trindade', '', ''),
(11975, 77, 0, 2, 'Triunfo', '', 'triunfo', '', ''),
(11976, 77, 0, 2, 'Tupanatinga', '', 'tupanatinga', '', ''),
(11977, 77, 0, 2, 'Tuparetama', '', 'tuparetama', '', ''),
(11978, 77, 0, 2, 'Venturosa', '', 'venturosa', '', ''),
(11979, 77, 0, 2, 'Verdejante', '', 'verdejante', '', ''),
(11980, 77, 0, 2, 'Vertente do Lério', '', 'vertente-do-lerio', '', ''),
(11981, 77, 0, 2, 'Vertentes', '', 'vertentes', '', ''),
(11982, 77, 0, 2, 'Vicência', '', 'vicencia', '', ''),
(11983, 77, 0, 2, 'Vitória de Santo Antão', '', 'vitoria-de-santo-antao', '', ''),
(11984, 77, 0, 2, 'Xexéu', '', 'xexeu', '', ''),
(11985, 78, 0, 2, 'Acauã', '', 'acaua', '', ''),
(11986, 78, 0, 2, 'Agricolândia', '', 'agricolandia', '', ''),
(11987, 78, 0, 2, 'Água Branca', '', 'agua-branca', '', ''),
(11988, 78, 0, 2, 'Alagoinha do Piauí', '', 'alagoinha-do-piaui', '', ''),
(11989, 78, 0, 2, 'Alegrete do Piauí', '', 'alegrete-do-piaui', '', ''),
(11990, 78, 0, 2, 'Alto Longá', '', 'alto-longa', '', ''),
(11991, 78, 0, 2, 'Altos', '', 'altos', '', ''),
(11992, 78, 0, 2, 'Alvorada do Gurguéia', '', 'alvorada-do-gurgueia', '', ''),
(11993, 78, 0, 2, 'Amarante', '', 'amarante', '', ''),
(11994, 78, 0, 2, 'Angical do Piauí', '', 'angical-do-piaui', '', ''),
(11995, 78, 0, 2, 'Anísio de Abreu', '', 'anisio-de-abreu', '', ''),
(11996, 78, 0, 2, 'Antônio Almeida', '', 'antonio-almeida', '', ''),
(11997, 78, 0, 2, 'Aroazes', '', 'aroazes', '', ''),
(11998, 78, 0, 2, 'Arraial', '', 'arraial', '', ''),
(11999, 78, 0, 2, 'Assunção do Piauí', '', 'assuncao-do-piaui', '', ''),
(12000, 78, 0, 2, 'Avelino Lopes', '', 'avelino-lopes', '', ''),
(12001, 78, 0, 2, 'Baixa Grande do Ribeiro', '', 'baixa-grande-do-ribeiro', '', ''),
(12002, 78, 0, 2, 'Barra d`Alcântara', '', 'barra-d`alcantara', '', ''),
(12003, 78, 0, 2, 'Barras', '', 'barras', '', ''),
(12004, 78, 0, 2, 'Barreiras do Piauí', '', 'barreiras-do-piaui', '', ''),
(12005, 78, 0, 2, 'Barro Duro', '', 'barro-duro', '', ''),
(12006, 78, 0, 2, 'Batalha', '', 'batalha', '', ''),
(12007, 78, 0, 2, 'Bela Vista do Piauí', '', 'bela-vista-do-piaui', '', ''),
(12008, 78, 0, 2, 'Belém do Piauí', '', 'belem-do-piaui', '', ''),
(12009, 78, 0, 2, 'Beneditinos', '', 'beneditinos', '', ''),
(12010, 78, 0, 2, 'Bertolínia', '', 'bertolinia', '', ''),
(12011, 78, 0, 2, 'Betânia do Piauí', '', 'betania-do-piaui', '', ''),
(12012, 78, 0, 2, 'Boa Hora', '', 'boa-hora', '', ''),
(12013, 78, 0, 2, 'Bocaina', '', 'bocaina', '', ''),
(12014, 78, 0, 2, 'Bom Jesus', '', 'bom-jesus', '', ''),
(12015, 78, 0, 2, 'Bom Princípio do Piauí', '', 'bom-principio-do-piaui', '', ''),
(12016, 78, 0, 2, 'Bonfim do Piauí', '', 'bonfim-do-piaui', '', ''),
(12017, 78, 0, 2, 'Boqueirão do Piauí', '', 'boqueirao-do-piaui', '', ''),
(12018, 78, 0, 2, 'Brasileira', '', 'brasileira', '', ''),
(12019, 78, 0, 2, 'Brejo do Piauí', '', 'brejo-do-piaui', '', ''),
(12020, 78, 0, 2, 'Buriti dos Lopes', '', 'buriti-dos-lopes', '', ''),
(12021, 78, 0, 2, 'Buriti dos Montes', '', 'buriti-dos-montes', '', ''),
(12022, 78, 0, 2, 'Cabeceiras do Piauí', '', 'cabeceiras-do-piaui', '', ''),
(12023, 78, 0, 2, 'Cajazeiras do Piauí', '', 'cajazeiras-do-piaui', '', ''),
(12024, 78, 0, 2, 'Cajueiro da Praia', '', 'cajueiro-da-praia', '', ''),
(12025, 78, 0, 2, 'Caldeirão Grande do Piauí', '', 'caldeirao-grande-do-piaui', '', ''),
(12026, 78, 0, 2, 'Campinas do Piauí', '', 'campinas-do-piaui', '', ''),
(12027, 78, 0, 2, 'Campo Alegre do Fidalgo', '', 'campo-alegre-do-fidalgo', '', ''),
(12028, 78, 0, 2, 'Campo Grande do Piauí', '', 'campo-grande-do-piaui', '', ''),
(12029, 78, 0, 2, 'Campo Largo do Piauí', '', 'campo-largo-do-piaui', '', ''),
(12030, 78, 0, 2, 'Campo Maior', '', 'campo-maior', '', ''),
(12031, 78, 0, 2, 'Canavieira', '', 'canavieira', '', ''),
(12032, 78, 0, 2, 'Canto do Buriti', '', 'canto-do-buriti', '', ''),
(12033, 78, 0, 2, 'Capitão de Campos', '', 'capitao-de-campos', '', ''),
(12034, 78, 0, 2, 'Capitão Gervásio Oliveira', '', 'capitao-gervasio-oliveira', '', ''),
(12035, 78, 0, 2, 'Caracol', '', 'caracol', '', ''),
(12036, 78, 0, 2, 'Caraúbas do Piauí', '', 'caraubas-do-piaui', '', ''),
(12037, 78, 0, 2, 'Caridade do Piauí', '', 'caridade-do-piaui', '', ''),
(12038, 78, 0, 2, 'Castelo do Piauí', '', 'castelo-do-piaui', '', ''),
(12039, 78, 0, 2, 'Caxingó', '', 'caxingo', '', ''),
(12040, 78, 0, 2, 'Cocal', '', 'cocal', '', ''),
(12041, 78, 0, 2, 'Cocal de Telha', '', 'cocal-de-telha', '', ''),
(12042, 78, 0, 2, 'Cocal dos Alves', '', 'cocal-dos-alves', '', ''),
(12043, 78, 0, 2, 'Coivaras', '', 'coivaras', '', ''),
(12044, 78, 0, 2, 'Colônia do Gurguéia', '', 'colonia-do-gurgueia', '', ''),
(12045, 78, 0, 2, 'Colônia do Piauí', '', 'colonia-do-piaui', '', ''),
(12046, 78, 0, 2, 'Conceição do Canindé', '', 'conceicao-do-caninde', '', ''),
(12047, 78, 0, 2, 'Coronel José Dias', '', 'coronel-jose-dias', '', ''),
(12048, 78, 0, 2, 'Corrente', '', 'corrente', '', ''),
(12049, 78, 0, 2, 'Cristalândia do Piauí', '', 'cristalandia-do-piaui', '', ''),
(12050, 78, 0, 2, 'Cristino Castro', '', 'cristino-castro', '', ''),
(12051, 78, 0, 2, 'Curimatá', '', 'curimata', '', ''),
(12052, 78, 0, 2, 'Currais', '', 'currais', '', ''),
(12053, 78, 0, 2, 'Curral Novo do Piauí', '', 'curral-novo-do-piaui', '', ''),
(12054, 78, 0, 2, 'Curralinhos', '', 'curralinhos', '', ''),
(12055, 78, 0, 2, 'Demerval Lobão', '', 'demerval-lobao', '', ''),
(12056, 78, 0, 2, 'Dirceu Arcoverde', '', 'dirceu-arcoverde', '', ''),
(12057, 78, 0, 2, 'Dom Expedito Lopes', '', 'dom-expedito-lopes', '', ''),
(12058, 78, 0, 2, 'Dom Inocêncio', '', 'dom-inocencio', '', ''),
(12059, 78, 0, 2, 'Domingos Mourão', '', 'domingos-mourao', '', ''),
(12060, 78, 0, 2, 'Elesbão Veloso', '', 'elesbao-veloso', '', ''),
(12061, 78, 0, 2, 'Eliseu Martins', '', 'eliseu-martins', '', ''),
(12062, 78, 0, 2, 'Esperantina', '', 'esperantina', '', ''),
(12063, 78, 0, 2, 'Fartura do Piauí', '', 'fartura-do-piaui', '', ''),
(12064, 78, 0, 2, 'Flores do Piauí', '', 'flores-do-piaui', '', ''),
(12065, 78, 0, 2, 'Floresta do Piauí', '', 'floresta-do-piaui', '', ''),
(12066, 78, 0, 2, 'Floriano', '', 'floriano', '', ''),
(12067, 78, 0, 2, 'Francinópolis', '', 'francinopolis', '', ''),
(12068, 78, 0, 2, 'Francisco Ayres', '', 'francisco-ayres', '', ''),
(12069, 78, 0, 2, 'Francisco Macedo', '', 'francisco-macedo', '', ''),
(12070, 78, 0, 2, 'Francisco Santos', '', 'francisco-santos', '', ''),
(12071, 78, 0, 2, 'Fronteiras', '', 'fronteiras', '', ''),
(12072, 78, 0, 2, 'Geminiano', '', 'geminiano', '', ''),
(12073, 78, 0, 2, 'Gilbués', '', 'gilbues', '', ''),
(12074, 78, 0, 2, 'Guadalupe', '', 'guadalupe', '', ''),
(12075, 78, 0, 2, 'Guaribas', '', 'guaribas', '', ''),
(12076, 78, 0, 2, 'Hugo Napoleão', '', 'hugo-napoleao', '', ''),
(12077, 78, 0, 2, 'Ilha Grande', '', 'ilha-grande', '', ''),
(12078, 78, 0, 2, 'Inhuma', '', 'inhuma', '', ''),
(12079, 78, 0, 2, 'Ipiranga do Piauí', '', 'ipiranga-do-piaui', '', ''),
(12080, 78, 0, 2, 'Isaías Coelho', '', 'isaias-coelho', '', ''),
(12081, 78, 0, 2, 'Itainópolis', '', 'itainopolis', '', ''),
(12082, 78, 0, 2, 'Itaueira', '', 'itaueira', '', ''),
(12083, 78, 0, 2, 'Jacobina do Piauí', '', 'jacobina-do-piaui', '', ''),
(12084, 78, 0, 2, 'Jaicós', '', 'jaicos', '', ''),
(12085, 78, 0, 2, 'Jardim do Mulato', '', 'jardim-do-mulato', '', ''),
(12086, 78, 0, 2, 'Jatobá do Piauí', '', 'jatoba-do-piaui', '', ''),
(12087, 78, 0, 2, 'Jerumenha', '', 'jerumenha', '', ''),
(12088, 78, 0, 2, 'João Costa', '', 'joao-costa', '', ''),
(12089, 78, 0, 2, 'Joaquim Pires', '', 'joaquim-pires', '', ''),
(12090, 78, 0, 2, 'Joca Marques', '', 'joca-marques', '', ''),
(12091, 78, 0, 2, 'José de Freitas', '', 'jose-de-freitas', '', ''),
(12092, 78, 0, 2, 'Juazeiro do Piauí', '', 'juazeiro-do-piaui', '', ''),
(12093, 78, 0, 2, 'Júlio Borges', '', 'julio-borges', '', ''),
(12094, 78, 0, 2, 'Jurema', '', 'jurema', '', ''),
(12095, 78, 0, 2, 'Lagoa Alegre', '', 'lagoa-alegre', '', ''),
(12096, 78, 0, 2, 'Lagoa de São Francisco', '', 'lagoa-de-sao-francisco', '', ''),
(12097, 78, 0, 2, 'Lagoa do Barro do Piauí', '', 'lagoa-do-barro-do-piaui', '', ''),
(12098, 78, 0, 2, 'Lagoa do Piauí', '', 'lagoa-do-piaui', '', ''),
(12099, 78, 0, 2, 'Lagoa do Sítio', '', 'lagoa-do-sitio', '', ''),
(12100, 78, 0, 2, 'Lagoinha do Piauí', '', 'lagoinha-do-piaui', '', ''),
(12101, 78, 0, 2, 'Landri Sales', '', 'landri-sales', '', ''),
(12102, 78, 0, 2, 'Luís Correia', '', 'luis-correia', '', ''),
(12103, 78, 0, 2, 'Luzilândia', '', 'luzilandia', '', ''),
(12104, 78, 0, 2, 'Madeiro', '', 'madeiro', '', ''),
(12105, 78, 0, 2, 'Manoel Emídio', '', 'manoel-emidio', '', ''),
(12106, 78, 0, 2, 'Marcolândia', '', 'marcolandia', '', ''),
(12107, 78, 0, 2, 'Marcos Parente', '', 'marcos-parente', '', ''),
(12108, 78, 0, 2, 'Massapê do Piauí', '', 'massape-do-piaui', '', ''),
(12109, 78, 0, 2, 'Matias Olímpio', '', 'matias-olimpio', '', ''),
(12110, 78, 0, 2, 'Miguel Alves', '', 'miguel-alves', '', ''),
(12111, 78, 0, 2, 'Miguel Leão', '', 'miguel-leao', '', ''),
(12112, 78, 0, 2, 'Milton Brandão', '', 'milton-brandao', '', ''),
(12113, 78, 0, 2, 'Monsenhor Gil', '', 'monsenhor-gil', '', ''),
(12114, 78, 0, 2, 'Monsenhor Hipólito', '', 'monsenhor-hipolito', '', ''),
(12115, 78, 0, 2, 'Monte Alegre do Piauí', '', 'monte-alegre-do-piaui', '', ''),
(12116, 78, 0, 2, 'Morro Cabeça no Tempo', '', 'morro-cabeca-no-tempo', '', ''),
(12117, 78, 0, 2, 'Morro do Chapéu do Piauí', '', 'morro-do-chapeu-do-piaui', '', ''),
(12118, 78, 0, 2, 'Murici dos Portelas', '', 'murici-dos-portelas', '', ''),
(12119, 78, 0, 2, 'Nazaré do Piauí', '', 'nazare-do-piaui', '', ''),
(12120, 78, 0, 2, 'Nossa Senhora de Nazaré', '', 'nossa-senhora-de-nazare', '', ''),
(12121, 78, 0, 2, 'Nossa Senhora dos Remédios', '', 'nossa-senhora-dos-remedios', '', ''),
(12122, 78, 0, 2, 'Nova Santa Rita', '', 'nova-santa-rita', '', ''),
(12123, 78, 0, 2, 'Novo Oriente do Piauí', '', 'novo-oriente-do-piaui', '', ''),
(12124, 78, 0, 2, 'Novo Santo Antônio', '', 'novo-santo-antonio', '', ''),
(12125, 78, 0, 2, 'Oeiras', '', 'oeiras', '', ''),
(12126, 78, 0, 2, 'Olho d`Água do Piauí', '', 'olho-d`agua-do-piaui', '', ''),
(12127, 78, 0, 2, 'Padre Marcos', '', 'padre-marcos', '', ''),
(12128, 78, 0, 2, 'Paes Landim', '', 'paes-landim', '', ''),
(12129, 78, 0, 2, 'Pajeú do Piauí', '', 'pajeu-do-piaui', '', ''),
(12130, 78, 0, 2, 'Palmeira do Piauí', '', 'palmeira-do-piaui', '', ''),
(12131, 78, 0, 2, 'Palmeirais', '', 'palmeirais', '', ''),
(12132, 78, 0, 2, 'Paquetá', '', 'paqueta', '', ''),
(12133, 78, 0, 2, 'Parnaguá', '', 'parnagua', '', ''),
(12134, 78, 0, 2, 'Parnaíba', '', 'parnaiba', '', ''),
(12135, 78, 0, 2, 'Passagem Franca do Piauí', '', 'passagem-franca-do-piaui', '', ''),
(12136, 78, 0, 2, 'Patos do Piauí', '', 'patos-do-piaui', '', ''),
(12137, 78, 0, 2, 'Paulistana', '', 'paulistana', '', ''),
(12138, 78, 0, 2, 'Pavussu', '', 'pavussu', '', ''),
(12139, 78, 0, 2, 'Pedro II', '', 'pedro-ii', '', ''),
(12140, 78, 0, 2, 'Pedro Laurentino', '', 'pedro-laurentino', '', ''),
(12141, 78, 0, 2, 'Picos', '', 'picos', '', ''),
(12142, 78, 0, 2, 'Pimenteiras', '', 'pimenteiras', '', ''),
(12143, 78, 0, 2, 'Pio IX', '', 'pio-ix', '', ''),
(12144, 78, 0, 2, 'Piracuruca', '', 'piracuruca', '', ''),
(12145, 78, 0, 2, 'Piripiri', '', 'piripiri', '', ''),
(12146, 78, 0, 2, 'Porto', '', 'porto', '', ''),
(12147, 78, 0, 2, 'Porto Alegre do Piauí', '', 'porto-alegre-do-piaui', '', ''),
(12148, 78, 0, 2, 'Prata do Piauí', '', 'prata-do-piaui', '', ''),
(12149, 78, 0, 2, 'Queimada Nova', '', 'queimada-nova', '', ''),
(12150, 78, 0, 2, 'Redenção do Gurguéia', '', 'redencao-do-gurgueia', '', ''),
(12151, 78, 0, 2, 'Regeneração', '', 'regeneracao', '', ''),
(12152, 78, 0, 2, 'Riacho Frio', '', 'riacho-frio', '', ''),
(12153, 78, 0, 2, 'Ribeira do Piauí', '', 'ribeira-do-piaui', '', ''),
(12154, 78, 0, 2, 'Ribeiro Gonçalves', '', 'ribeiro-goncalves', '', ''),
(12155, 78, 0, 2, 'Rio Grande do Piauí', '', 'rio-grande-do-piaui', '', ''),
(12156, 78, 0, 2, 'Santa Cruz do Piauí', '', 'santa-cruz-do-piaui', '', ''),
(12157, 78, 0, 2, 'Santa Cruz dos Milagres', '', 'santa-cruz-dos-milagres', '', ''),
(12158, 78, 0, 2, 'Santa Filomena', '', 'santa-filomena', '', ''),
(12159, 78, 0, 2, 'Santa Luz', '', 'santa-luz', '', ''),
(12160, 78, 0, 2, 'Santa Rosa do Piauí', '', 'santa-rosa-do-piaui', '', ''),
(12161, 78, 0, 2, 'Santana do Piauí', '', 'santana-do-piaui', '', ''),
(12162, 78, 0, 2, 'Santo Antônio de Lisboa', '', 'santo-antonio-de-lisboa', '', ''),
(12163, 78, 0, 2, 'Santo Antônio dos Milagres', '', 'santo-antonio-dos-milagres', '', ''),
(12164, 78, 0, 2, 'Santo Inácio do Piauí', '', 'santo-inacio-do-piaui', '', ''),
(12165, 78, 0, 2, 'São Braz do Piauí', '', 'sao-braz-do-piaui', '', ''),
(12166, 78, 0, 2, 'São Félix do Piauí', '', 'sao-felix-do-piaui', '', ''),
(12167, 78, 0, 2, 'São Francisco de Assis do Piauí', '', 'sao-francisco-de-assis-do-piaui', '', ''),
(12168, 78, 0, 2, 'São Francisco do Piauí', '', 'sao-francisco-do-piaui', '', ''),
(12169, 78, 0, 2, 'São Gonçalo do Gurguéia', '', 'sao-goncalo-do-gurgueia', '', ''),
(12170, 78, 0, 2, 'São Gonçalo do Piauí', '', 'sao-goncalo-do-piaui', '', ''),
(12171, 78, 0, 2, 'São João da Canabrava', '', 'sao-joao-da-canabrava', '', ''),
(12172, 78, 0, 2, 'São João da Fronteira', '', 'sao-joao-da-fronteira', '', ''),
(12173, 78, 0, 2, 'São João da Serra', '', 'sao-joao-da-serra', '', ''),
(12174, 78, 0, 2, 'São João da Varjota', '', 'sao-joao-da-varjota', '', ''),
(12175, 78, 0, 2, 'São João do Arraial', '', 'sao-joao-do-arraial', '', ''),
(12176, 78, 0, 2, 'São João do Piauí', '', 'sao-joao-do-piaui', '', ''),
(12177, 78, 0, 2, 'São José do Divino', '', 'sao-jose-do-divino', '', ''),
(12178, 78, 0, 2, 'São José do Peixe', '', 'sao-jose-do-peixe', '', ''),
(12179, 78, 0, 2, 'São José do Piauí', '', 'sao-jose-do-piaui', '', ''),
(12180, 78, 0, 2, 'São Julião', '', 'sao-juliao', '', ''),
(12181, 78, 0, 2, 'São Lourenço do Piauí', '', 'sao-lourenco-do-piaui', '', ''),
(12182, 78, 0, 2, 'São Luis do Piauí', '', 'sao-luis-do-piaui', '', ''),
(12183, 78, 0, 2, 'São Miguel da Baixa Grande', '', 'sao-miguel-da-baixa-grande', '', ''),
(12184, 78, 0, 2, 'São Miguel do Fidalgo', '', 'sao-miguel-do-fidalgo', '', ''),
(12185, 78, 0, 2, 'São Miguel do Tapuio', '', 'sao-miguel-do-tapuio', '', ''),
(12186, 78, 0, 2, 'São Pedro do Piauí', '', 'sao-pedro-do-piaui', '', ''),
(12187, 78, 0, 2, 'São Raimundo Nonato', '', 'sao-raimundo-nonato', '', ''),
(12188, 78, 0, 2, 'Sebastião Barros', '', 'sebastiao-barros', '', ''),
(12189, 78, 0, 2, 'Sebastião Leal', '', 'sebastiao-leal', '', ''),
(12190, 78, 0, 2, 'Sigefredo Pacheco', '', 'sigefredo-pacheco', '', ''),
(12191, 78, 0, 2, 'Simões', '', 'simoes', '', ''),
(12192, 78, 0, 2, 'Simplício Mendes', '', 'simplicio-mendes', '', ''),
(12193, 78, 0, 2, 'Socorro do Piauí', '', 'socorro-do-piaui', '', ''),
(12194, 78, 0, 2, 'Sussuapara', '', 'sussuapara', '', ''),
(12195, 78, 0, 2, 'Tamboril do Piauí', '', 'tamboril-do-piaui', '', ''),
(12196, 78, 0, 2, 'Tanque do Piauí', '', 'tanque-do-piaui', '', ''),
(12197, 78, 0, 2, 'Teresina', '', 'teresina', '', ''),
(12198, 78, 0, 2, 'União', '', 'uniao', '', ''),
(12199, 78, 0, 2, 'Uruçuí', '', 'urucui', '', ''),
(12200, 78, 0, 2, 'Valença do Piauí', '', 'valenca-do-piaui', '', ''),
(12201, 78, 0, 2, 'Várzea Branca', '', 'varzea-branca', '', ''),
(12202, 78, 0, 2, 'Várzea Grande', '', 'varzea-grande', '', ''),
(12203, 78, 0, 2, 'Vera Mendes', '', 'vera-mendes', '', ''),
(12204, 78, 0, 2, 'Vila Nova do Piauí', '', 'vila-nova-do-piaui', '', ''),
(12205, 78, 0, 2, 'Wall Ferraz', '', 'wall-ferraz', '', ''),
(12206, 79, 0, 2, 'Angra dos Reis', '', 'angra-dos-reis', '', ''),
(12207, 79, 0, 2, 'Aperibé', '', 'aperibe', '', ''),
(12208, 79, 0, 2, 'Araruama', '', 'araruama', '', ''),
(12209, 79, 0, 2, 'Areal', '', 'areal', '', ''),
(12210, 79, 0, 2, 'Armação dos Búzios', '', 'armacao-dos-buzios', '', ''),
(12211, 79, 0, 2, 'Arraial do Cabo', '', 'arraial-do-cabo', '', ''),
(12212, 79, 0, 2, 'Barra do Piraí', '', 'barra-do-pirai', '', ''),
(12213, 79, 0, 2, 'Barra Mansa', '', 'barra-mansa', '', ''),
(12214, 79, 0, 2, 'Belford Roxo', '', 'belford-roxo', '', ''),
(12215, 79, 0, 2, 'Bom Jardim', '', 'bom-jardim', '', ''),
(12216, 79, 0, 2, 'Bom Jesus do Itabapoana', '', 'bom-jesus-do-itabapoana', '', ''),
(12217, 79, 0, 2, 'Cabo Frio', '', 'cabo-frio', '', ''),
(12218, 79, 0, 2, 'Cachoeiras de Macacu', '', 'cachoeiras-de-macacu', '', ''),
(12219, 79, 0, 2, 'Cambuci', '', 'cambuci', '', ''),
(12220, 79, 0, 2, 'Campos dos Goytacazes', '', 'campos-dos-goytacazes', '', ''),
(12221, 79, 0, 2, 'Cantagalo', '', 'cantagalo', '', ''),
(12222, 79, 0, 2, 'Carapebus', '', 'carapebus', '', ''),
(12223, 79, 0, 2, 'Cardoso Moreira', '', 'cardoso-moreira', '', ''),
(12224, 79, 0, 2, 'Carmo', '', 'carmo', '', ''),
(12225, 79, 0, 2, 'Casimiro de Abreu', '', 'casimiro-de-abreu', '', ''),
(12226, 79, 0, 2, 'Comendador Levy Gasparian', '', 'comendador-levy-gasparian', '', ''),
(12227, 79, 0, 2, 'Conceição de Macabu', '', 'conceicao-de-macabu', '', ''),
(12228, 79, 0, 2, 'Cordeiro', '', 'cordeiro', '', ''),
(12229, 79, 0, 2, 'Duas Barras', '', 'duas-barras', '', ''),
(12230, 79, 0, 2, 'Duque de Caxias', '', 'duque-de-caxias', '', ''),
(12231, 79, 0, 2, 'Engenheiro Paulo de Frontin', '', 'engenheiro-paulo-de-frontin', '', ''),
(12232, 79, 0, 2, 'Guapimirim', '', 'guapimirim', '', ''),
(12233, 79, 0, 2, 'Iguaba Grande', '', 'iguaba-grande', '', ''),
(12234, 79, 0, 2, 'Itaboraí', '', 'itaborai', '', ''),
(12235, 79, 0, 2, 'Itaguaí', '', 'itaguai', '', ''),
(12236, 79, 0, 2, 'Italva', '', 'italva', '', ''),
(12237, 79, 0, 2, 'Itaocara', '', 'itaocara', '', ''),
(12238, 79, 0, 2, 'Itaperuna', '', 'itaperuna', '', ''),
(12239, 79, 0, 2, 'Itatiaia', '', 'itatiaia', '', ''),
(12240, 79, 0, 2, 'Japeri', '', 'japeri', '', ''),
(12241, 79, 0, 2, 'Laje do Muriaé', '', 'laje-do-muriae', '', ''),
(12242, 79, 0, 2, 'Macaé', '', 'macae', '', ''),
(12243, 79, 0, 2, 'Macuco', '', 'macuco', '', ''),
(12244, 79, 0, 2, 'Magé', '', 'mage', '', ''),
(12245, 79, 0, 2, 'Mangaratiba', '', 'mangaratiba', '', ''),
(12246, 79, 0, 2, 'Maricá', '', 'marica', '', ''),
(12247, 79, 0, 2, 'Mendes', '', 'mendes', '', ''),
(12248, 79, 0, 2, 'Miguel Pereira', '', 'miguel-pereira', '', ''),
(12249, 79, 0, 2, 'Miracema', '', 'miracema', '', ''),
(12250, 79, 0, 2, 'Natividade', '', 'natividade', '', ''),
(12251, 79, 0, 2, 'Nilópolis', '', 'nilopolis', '', ''),
(12252, 79, 0, 2, 'Niterói', '', 'niteroi', '', ''),
(12253, 79, 0, 2, 'Nova Friburgo', '', 'nova-friburgo', '', ''),
(12254, 79, 0, 2, 'Nova Iguaçu', '', 'nova-iguacu', '', ''),
(12255, 79, 0, 2, 'Paracambi', '', 'paracambi', '', ''),
(12256, 79, 0, 2, 'Paraíba do Sul', '', 'paraiba-do-sul', '', ''),
(12257, 79, 0, 2, 'Parati', '', 'parati', '', ''),
(12258, 79, 0, 2, 'Paty do Alferes', '', 'paty-do-alferes', '', ''),
(12259, 79, 0, 2, 'Petrópolis', '', 'petropolis', '', ''),
(12260, 79, 0, 2, 'Pinheiral', '', 'pinheiral', '', ''),
(12261, 79, 0, 2, 'Piraí', '', 'pirai', '', ''),
(12262, 79, 0, 2, 'Porciúncula', '', 'porciuncula', '', ''),
(12263, 79, 0, 2, 'Porto Real', '', 'porto-real', '', ''),
(12264, 79, 0, 2, 'Quatis', '', 'quatis', '', ''),
(12265, 79, 0, 2, 'Queimados', '', 'queimados', '', ''),
(12266, 79, 0, 2, 'Quissamã', '', 'quissama', '', ''),
(12267, 79, 0, 2, 'Resende', '', 'resende', '', ''),
(12268, 79, 0, 2, 'Rio Bonito', '', 'rio-bonito', '', ''),
(12269, 79, 0, 2, 'Rio Claro', '', 'rio-claro', '', ''),
(12270, 79, 0, 2, 'Rio das Flores', '', 'rio-das-flores', '', ''),
(12271, 79, 0, 2, 'Rio das Ostras', '', 'rio-das-ostras', '', ''),
(12272, 79, 0, 2, 'Rio de Janeiro', '', 'rio-de-janeiro', '', ''),
(12273, 79, 0, 2, 'Santa Maria Madalena', '', 'santa-maria-madalena', '', ''),
(12274, 79, 0, 2, 'Santo Antônio de Pádua', '', 'santo-antonio-de-padua', '', ''),
(12275, 79, 0, 2, 'São Fidélis', '', 'sao-fidelis', '', ''),
(12276, 79, 0, 2, 'São Francisco de Itabapoana', '', 'sao-francisco-de-itabapoana', '', ''),
(12277, 79, 0, 2, 'São Gonçalo', '', 'sao-goncalo', '', ''),
(12278, 79, 0, 2, 'São João da Barra', '', 'sao-joao-da-barra', '', ''),
(12279, 79, 0, 2, 'São João de Meriti', '', 'sao-joao-de-meriti', '', ''),
(12280, 79, 0, 2, 'São José de Ubá', '', 'sao-jose-de-uba', '', ''),
(12281, 79, 0, 2, 'São José do Vale do Rio Preto', '', 'sao-jose-do-vale-do-rio-preto', '', ''),
(12282, 79, 0, 2, 'São Pedro da Aldeia', '', 'sao-pedro-da-aldeia', '', ''),
(12283, 79, 0, 2, 'São Sebastião do Alto', '', 'sao-sebastiao-do-alto', '', ''),
(12284, 79, 0, 2, 'Sapucaia', '', 'sapucaia', '', ''),
(12285, 79, 0, 2, 'Saquarema', '', 'saquarema', '', ''),
(12286, 79, 0, 2, 'Seropédica', '', 'seropedica', '', ''),
(12287, 79, 0, 2, 'Silva Jardim', '', 'silva-jardim', '', ''),
(12288, 79, 0, 2, 'Sumidouro', '', 'sumidouro', '', ''),
(12289, 79, 0, 2, 'Tanguá', '', 'tangua', '', ''),
(12290, 79, 0, 2, 'Teresópolis', '', 'teresopolis', '', ''),
(12291, 79, 0, 2, 'Trajano de Morais', '', 'trajano-de-morais', '', ''),
(12292, 79, 0, 2, 'Três Rios', '', 'tres-rios', '', ''),
(12293, 79, 0, 2, 'Valença', '', 'valenca', '', ''),
(12294, 79, 0, 2, 'Varre-Sai', '', 'varre-sai', '', ''),
(12295, 79, 0, 2, 'Vassouras', '', 'vassouras', '', ''),
(12296, 79, 0, 2, 'Volta Redonda', '', 'volta-redonda', '', ''),
(12297, 80, 0, 2, 'Acari', '', 'acari', '', ''),
(12298, 80, 0, 2, 'Açu', '', 'acu', '', ''),
(12299, 80, 0, 2, 'Afonso Bezerra', '', 'afonso-bezerra', '', ''),
(12300, 80, 0, 2, 'Água Nova', '', 'agua-nova', '', ''),
(12301, 80, 0, 2, 'Alexandria', '', 'alexandria', '', ''),
(12302, 80, 0, 2, 'Almino Afonso', '', 'almino-afonso', '', ''),
(12303, 80, 0, 2, 'Alto do Rodrigues', '', 'alto-do-rodrigues', '', ''),
(12304, 80, 0, 2, 'Angicos', '', 'angicos', '', ''),
(12305, 80, 0, 2, 'Antônio Martins', '', 'antonio-martins', '', ''),
(12306, 80, 0, 2, 'Apodi', '', 'apodi', '', ''),
(12307, 80, 0, 2, 'Areia Branca', '', 'areia-branca', '', ''),
(12308, 80, 0, 2, 'Arês', '', 'ares', '', ''),
(12309, 80, 0, 2, 'Augusto Severo', '', 'augusto-severo', '', ''),
(12310, 80, 0, 2, 'Baía Formosa', '', 'baia-formosa', '', ''),
(12311, 80, 0, 2, 'Baraúna', '', 'barauna', '', ''),
(12312, 80, 0, 2, 'Barcelona', '', 'barcelona', '', ''),
(12313, 80, 0, 2, 'Bento Fernandes', '', 'bento-fernandes', '', ''),
(12314, 80, 0, 2, 'Bodó', '', 'bodo', '', ''),
(12315, 80, 0, 2, 'Bom Jesus', '', 'bom-jesus', '', ''),
(12316, 80, 0, 2, 'Brejinho', '', 'brejinho', '', ''),
(12317, 80, 0, 2, 'Caiçara do Norte', '', 'caicara-do-norte', '', ''),
(12318, 80, 0, 2, 'Caiçara do Rio do Vento', '', 'caicara-do-rio-do-vento', '', ''),
(12319, 80, 0, 2, 'Caicó', '', 'caico', '', ''),
(12320, 80, 0, 2, 'Campo Redondo', '', 'campo-redondo', '', ''),
(12321, 80, 0, 2, 'Canguaretama', '', 'canguaretama', '', ''),
(12322, 80, 0, 2, 'Caraúbas', '', 'caraubas', '', ''),
(12323, 80, 0, 2, 'Carnaúba dos Dantas', '', 'carnauba-dos-dantas', '', ''),
(12324, 80, 0, 2, 'Carnaubais', '', 'carnaubais', '', ''),
(12325, 80, 0, 2, 'Ceará-Mirim', '', 'ceara-mirim', '', ''),
(12326, 80, 0, 2, 'Cerro Corá', '', 'cerro-cora', '', ''),
(12327, 80, 0, 2, 'Coronel Ezequiel', '', 'coronel-ezequiel', '', ''),
(12328, 80, 0, 2, 'Coronel João Pessoa', '', 'coronel-joao-pessoa', '', ''),
(12329, 80, 0, 2, 'Cruzeta', '', 'cruzeta', '', ''),
(12330, 80, 0, 2, 'Currais Novos', '', 'currais-novos', '', ''),
(12331, 80, 0, 2, 'Doutor Severiano', '', 'doutor-severiano', '', ''),
(12332, 80, 0, 2, 'Encanto', '', 'encanto', '', ''),
(12333, 80, 0, 2, 'Equador', '', 'equador', '', ''),
(12334, 80, 0, 2, 'Espírito Santo', '', 'espirito-santo', '', ''),
(12335, 80, 0, 2, 'Extremoz', '', 'extremoz', '', ''),
(12336, 80, 0, 2, 'Felipe Guerra', '', 'felipe-guerra', '', ''),
(12337, 80, 0, 2, 'Fernando Pedroza', '', 'fernando-pedroza', '', ''),
(12338, 80, 0, 2, 'Florânia', '', 'florania', '', ''),
(12339, 80, 0, 2, 'Francisco Dantas', '', 'francisco-dantas', '', ''),
(12340, 80, 0, 2, 'Frutuoso Gomes', '', 'frutuoso-gomes', '', ''),
(12341, 80, 0, 2, 'Galinhos', '', 'galinhos', '', ''),
(12342, 80, 0, 2, 'Goianinha', '', 'goianinha', '', ''),
(12343, 80, 0, 2, 'Governador Dix-Sept Rosado', '', 'governador-dix-sept-rosado', '', ''),
(12344, 80, 0, 2, 'Grossos', '', 'grossos', '', ''),
(12345, 80, 0, 2, 'Guamaré', '', 'guamare', '', ''),
(12346, 80, 0, 2, 'Ielmo Marinho', '', 'ielmo-marinho', '', ''),
(12347, 80, 0, 2, 'Ipanguaçu', '', 'ipanguacu', '', ''),
(12348, 80, 0, 2, 'Ipueira', '', 'ipueira', '', ''),
(12349, 80, 0, 2, 'Itajá', '', 'itaja', '', ''),
(12350, 80, 0, 2, 'Itaú', '', 'itau', '', ''),
(12351, 80, 0, 2, 'Jaçanã', '', 'jacana', '', ''),
(12352, 80, 0, 2, 'Jandaíra', '', 'jandaira', '', ''),
(12353, 80, 0, 2, 'Janduís', '', 'janduis', '', ''),
(12354, 80, 0, 2, 'Januário Cicco', '', 'januario-cicco', '', ''),
(12355, 80, 0, 2, 'Japi', '', 'japi', '', ''),
(12356, 80, 0, 2, 'Jardim de Angicos', '', 'jardim-de-angicos', '', ''),
(12357, 80, 0, 2, 'Jardim de Piranhas', '', 'jardim-de-piranhas', '', ''),
(12358, 80, 0, 2, 'Jardim do Seridó', '', 'jardim-do-serido', '', ''),
(12359, 80, 0, 2, 'João Câmara', '', 'joao-camara', '', ''),
(12360, 80, 0, 2, 'João Dias', '', 'joao-dias', '', ''),
(12361, 80, 0, 2, 'José da Penha', '', 'jose-da-penha', '', ''),
(12362, 80, 0, 2, 'Jucurutu', '', 'jucurutu', '', ''),
(12363, 80, 0, 2, 'Lagoa d`Anta', '', 'lagoa-d`anta', '', ''),
(12364, 80, 0, 2, 'Lagoa de Pedras', '', 'lagoa-de-pedras', '', ''),
(12365, 80, 0, 2, 'Lagoa de Velhos', '', 'lagoa-de-velhos', '', ''),
(12366, 80, 0, 2, 'Lagoa Nova', '', 'lagoa-nova', '', ''),
(12367, 80, 0, 2, 'Lagoa Salgada', '', 'lagoa-salgada', '', ''),
(12368, 80, 0, 2, 'Lajes', '', 'lajes', '', ''),
(12369, 80, 0, 2, 'Lajes Pintadas', '', 'lajes-pintadas', '', ''),
(12370, 80, 0, 2, 'Lucrécia', '', 'lucrecia', '', ''),
(12371, 80, 0, 2, 'Luís Gomes', '', 'luis-gomes', '', ''),
(12372, 80, 0, 2, 'Macaíba', '', 'macaiba', '', ''),
(12373, 80, 0, 2, 'Macau', '', 'macau', '', ''),
(12374, 80, 0, 2, 'Major Sales', '', 'major-sales', '', ''),
(12375, 80, 0, 2, 'Marcelino Vieira', '', 'marcelino-vieira', '', ''),
(12376, 80, 0, 2, 'Martins', '', 'martins', '', ''),
(12377, 80, 0, 2, 'Maxaranguape', '', 'maxaranguape', '', ''),
(12378, 80, 0, 2, 'Messias Targino', '', 'messias-targino', '', ''),
(12379, 80, 0, 2, 'Montanhas', '', 'montanhas', '', ''),
(12380, 80, 0, 2, 'Monte Alegre', '', 'monte-alegre', '', ''),
(12381, 80, 0, 2, 'Monte das Gameleiras', '', 'monte-das-gameleiras', '', ''),
(12382, 80, 0, 2, 'Mossoró', '', 'mossoro', '', ''),
(12383, 80, 0, 2, 'Natal', '', 'natal', '', ''),
(12384, 80, 0, 2, 'Nísia Floresta', '', 'nisia-floresta', '', ''),
(12385, 80, 0, 2, 'Nova Cruz', '', 'nova-cruz', '', ''),
(12386, 80, 0, 2, 'Olho-d`Água do Borges', '', 'olho-d`agua-do-borges', '', ''),
(12387, 80, 0, 2, 'Ouro Branco', '', 'ouro-branco', '', ''),
(12388, 80, 0, 2, 'Paraná', '', 'parana', '', ''),
(12389, 80, 0, 2, 'Paraú', '', 'parau', '', ''),
(12390, 80, 0, 2, 'Parazinho', '', 'parazinho', '', ''),
(12391, 80, 0, 2, 'Parelhas', '', 'parelhas', '', ''),
(12392, 80, 0, 2, 'Parnamirim', '', 'parnamirim', '', ''),
(12393, 80, 0, 2, 'Passa e Fica', '', 'passa-e-fica', '', ''),
(12394, 80, 0, 2, 'Passagem', '', 'passagem', '', ''),
(12395, 80, 0, 2, 'Patu', '', 'patu', '', ''),
(12396, 80, 0, 2, 'Pau dos Ferros', '', 'pau-dos-ferros', '', ''),
(12397, 80, 0, 2, 'Pedra Grande', '', 'pedra-grande', '', ''),
(12398, 80, 0, 2, 'Pedra Preta', '', 'pedra-preta', '', ''),
(12399, 80, 0, 2, 'Pedro Avelino', '', 'pedro-avelino', '', ''),
(12400, 80, 0, 2, 'Pedro Velho', '', 'pedro-velho', '', ''),
(12401, 80, 0, 2, 'Pendências', '', 'pendencias', '', ''),
(12402, 80, 0, 2, 'Pilões', '', 'piloes', '', ''),
(12403, 80, 0, 2, 'Poço Branco', '', 'poco-branco', '', ''),
(12404, 80, 0, 2, 'Portalegre', '', 'portalegre', '', ''),
(12405, 80, 0, 2, 'Porto do Mangue', '', 'porto-do-mangue', '', ''),
(12406, 80, 0, 2, 'Presidente Juscelino', '', 'presidente-juscelino', '', ''),
(12407, 80, 0, 2, 'Pureza', '', 'pureza', '', ''),
(12408, 80, 0, 2, 'Rafael Fernandes', '', 'rafael-fernandes', '', ''),
(12409, 80, 0, 2, 'Rafael Godeiro', '', 'rafael-godeiro', '', ''),
(12410, 80, 0, 2, 'Riacho da Cruz', '', 'riacho-da-cruz', '', ''),
(12411, 80, 0, 2, 'Riacho de Santana', '', 'riacho-de-santana', '', ''),
(12412, 80, 0, 2, 'Riachuelo', '', 'riachuelo', '', ''),
(12413, 80, 0, 2, 'Rio do Fogo', '', 'rio-do-fogo', '', ''),
(12414, 80, 0, 2, 'Rodolfo Fernandes', '', 'rodolfo-fernandes', '', ''),
(12415, 80, 0, 2, 'Ruy Barbosa', '', 'ruy-barbosa', '', ''),
(12416, 80, 0, 2, 'Santa Cruz', '', 'santa-cruz', '', ''),
(12417, 80, 0, 2, 'Santa Maria', '', 'santa-maria', '', ''),
(12418, 80, 0, 2, 'Santana do Matos', '', 'santana-do-matos', '', ''),
(12419, 80, 0, 2, 'Santana do Seridó', '', 'santana-do-serido', '', ''),
(12420, 80, 0, 2, 'Santo Antônio', '', 'santo-antonio', '', ''),
(12421, 80, 0, 2, 'São Bento do Norte', '', 'sao-bento-do-norte', '', ''),
(12422, 80, 0, 2, 'São Bento do Trairí', '', 'sao-bento-do-trairi', '', ''),
(12423, 80, 0, 2, 'São Fernando', '', 'sao-fernando', '', ''),
(12424, 80, 0, 2, 'São Francisco do Oeste', '', 'sao-francisco-do-oeste', '', ''),
(12425, 80, 0, 2, 'São Gonçalo do Amarante', '', 'sao-goncalo-do-amarante', '', ''),
(12426, 80, 0, 2, 'São João do Sabugi', '', 'sao-joao-do-sabugi', '', ''),
(12427, 80, 0, 2, 'São José de Mipibu', '', 'sao-jose-de-mipibu', '', ''),
(12428, 80, 0, 2, 'São José do Campestre', '', 'sao-jose-do-campestre', '', ''),
(12429, 80, 0, 2, 'São José do Seridó', '', 'sao-jose-do-serido', '', ''),
(12430, 80, 0, 2, 'São Miguel', '', 'sao-miguel', '', ''),
(12431, 80, 0, 2, 'São Miguel de Touros', '', 'sao-miguel-de-touros', '', ''),
(12432, 80, 0, 2, 'São Paulo do Potengi', '', 'sao-paulo-do-potengi', '', ''),
(12433, 80, 0, 2, 'São Pedro', '', 'sao-pedro', '', ''),
(12434, 80, 0, 2, 'São Rafael', '', 'sao-rafael', '', ''),
(12435, 80, 0, 2, 'São Tomé', '', 'sao-tome', '', ''),
(12436, 80, 0, 2, 'São Vicente', '', 'sao-vicente', '', ''),
(12437, 80, 0, 2, 'Senador Elói de Souza', '', 'senador-eloi-de-souza', '', ''),
(12438, 80, 0, 2, 'Senador Georgino Avelino', '', 'senador-georgino-avelino', '', ''),
(12439, 80, 0, 2, 'Serra de São Bento', '', 'serra-de-sao-bento', '', ''),
(12440, 80, 0, 2, 'Serra do Mel', '', 'serra-do-mel', '', ''),
(12441, 80, 0, 2, 'Serra Negra do Norte', '', 'serra-negra-do-norte', '', ''),
(12442, 80, 0, 2, 'Serrinha', '', 'serrinha', '', ''),
(12443, 80, 0, 2, 'Serrinha dos Pintos', '', 'serrinha-dos-pintos', '', ''),
(12444, 80, 0, 2, 'Severiano Melo', '', 'severiano-melo', '', ''),
(12445, 80, 0, 2, 'Sítio Novo', '', 'sitio-novo', '', ''),
(12446, 80, 0, 2, 'Taboleiro Grande', '', 'taboleiro-grande', '', ''),
(12447, 80, 0, 2, 'Taipu', '', 'taipu', '', ''),
(12448, 80, 0, 2, 'Tangará', '', 'tangara', '', ''),
(12449, 80, 0, 2, 'Tenente Ananias', '', 'tenente-ananias', '', ''),
(12450, 80, 0, 2, 'Tenente Laurentino Cruz', '', 'tenente-laurentino-cruz', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keywords) VALUES
(12451, 80, 0, 2, 'Tibau', '', 'tibau', '', ''),
(12452, 80, 0, 2, 'Tibau do Sul', '', 'tibau-do-sul', '', ''),
(12453, 80, 0, 2, 'Timbaúba dos Batistas', '', 'timbauba-dos-batistas', '', ''),
(12454, 80, 0, 2, 'Touros', '', 'touros', '', ''),
(12455, 80, 0, 2, 'Triunfo Potiguar', '', 'triunfo-potiguar', '', ''),
(12456, 80, 0, 2, 'Umarizal', '', 'umarizal', '', ''),
(12457, 80, 0, 2, 'Upanema', '', 'upanema', '', ''),
(12458, 80, 0, 2, 'Várzea', '', 'varzea', '', ''),
(12459, 80, 0, 2, 'Venha-Ver', '', 'venha-ver', '', ''),
(12460, 80, 0, 2, 'Vera Cruz', '', 'vera-cruz', '', ''),
(12461, 80, 0, 2, 'Viçosa', '', 'vicosa', '', ''),
(12462, 80, 0, 2, 'Vila Flor', '', 'vila-flor', '', ''),
(12463, 81, 0, 2, 'Água Santa', '', 'agua-santa', '', ''),
(12464, 81, 0, 2, 'Agudo', '', 'agudo', '', ''),
(12465, 81, 0, 2, 'Ajuricaba', '', 'ajuricaba', '', ''),
(12466, 81, 0, 2, 'Alecrim', '', 'alecrim', '', ''),
(12467, 81, 0, 2, 'Alegrete', '', 'alegrete', '', ''),
(12468, 81, 0, 2, 'Alegria', '', 'alegria', '', ''),
(12469, 81, 0, 2, 'Alpestre', '', 'alpestre', '', ''),
(12470, 81, 0, 2, 'Alto Alegre', '', 'alto-alegre', '', ''),
(12471, 81, 0, 2, 'Alto Feliz', '', 'alto-feliz', '', ''),
(12472, 81, 0, 2, 'Alvorada', '', 'alvorada', '', ''),
(12473, 81, 0, 2, 'Amaral Ferrador', '', 'amaral-ferrador', '', ''),
(12474, 81, 0, 2, 'Ametista do Sul', '', 'ametista-do-sul', '', ''),
(12475, 81, 0, 2, 'André da Rocha', '', 'andre-da-rocha', '', ''),
(12476, 81, 0, 2, 'Anta Gorda', '', 'anta-gorda', '', ''),
(12477, 81, 0, 2, 'Antônio Prado', '', 'antonio-prado', '', ''),
(12478, 81, 0, 2, 'Arambaré', '', 'arambare', '', ''),
(12479, 81, 0, 2, 'Araricá', '', 'ararica', '', ''),
(12480, 81, 0, 2, 'Aratiba', '', 'aratiba', '', ''),
(12481, 81, 0, 2, 'Arroio do Meio', '', 'arroio-do-meio', '', ''),
(12482, 81, 0, 2, 'Arroio do Sal', '', 'arroio-do-sal', '', ''),
(12483, 81, 0, 2, 'Arroio do Tigre', '', 'arroio-do-tigre', '', ''),
(12484, 81, 0, 2, 'Arroio dos Ratos', '', 'arroio-dos-ratos', '', ''),
(12485, 81, 0, 2, 'Arroio Grande', '', 'arroio-grande', '', ''),
(12486, 81, 0, 2, 'Arvorezinha', '', 'arvorezinha', '', ''),
(12487, 81, 0, 2, 'Augusto Pestana', '', 'augusto-pestana', '', ''),
(12488, 81, 0, 2, 'Áurea', '', 'aurea', '', ''),
(12489, 81, 0, 2, 'Bagé', '', 'bage', '', ''),
(12490, 81, 0, 2, 'Balneário Pinhal', '', 'balneario-pinhal', '', ''),
(12491, 81, 0, 2, 'Barão', '', 'barao', '', ''),
(12492, 81, 0, 2, 'Barão de Cotegipe', '', 'barao-de-cotegipe', '', ''),
(12493, 81, 0, 2, 'Barão do Triunfo', '', 'barao-do-triunfo', '', ''),
(12494, 81, 0, 2, 'Barra do Guarita', '', 'barra-do-guarita', '', ''),
(12495, 81, 0, 2, 'Barra do Quaraí', '', 'barra-do-quarai', '', ''),
(12496, 81, 0, 2, 'Barra do Ribeiro', '', 'barra-do-ribeiro', '', ''),
(12497, 81, 0, 2, 'Barra do Rio Azul', '', 'barra-do-rio-azul', '', ''),
(12498, 81, 0, 2, 'Barra Funda', '', 'barra-funda', '', ''),
(12499, 81, 0, 2, 'Barracão', '', 'barracao', '', ''),
(12500, 81, 0, 2, 'Barros Cassal', '', 'barros-cassal', '', ''),
(12501, 81, 0, 2, 'Benjamin Constant do Sul', '', 'benjamin-constant-do-sul', '', ''),
(12502, 81, 0, 2, 'Bento Gonçalves', '', 'bento-goncalves', '', ''),
(12503, 81, 0, 2, 'Boa Vista das Missões', '', 'boa-vista-das-missoes', '', ''),
(12504, 81, 0, 2, 'Boa Vista do Buricá', '', 'boa-vista-do-burica', '', ''),
(12505, 81, 0, 2, 'Boa Vista do Sul', '', 'boa-vista-do-sul', '', ''),
(12506, 81, 0, 2, 'Bom Jesus', '', 'bom-jesus', '', ''),
(12507, 81, 0, 2, 'Bom Princípio', '', 'bom-principio', '', ''),
(12508, 81, 0, 2, 'Bom Progresso', '', 'bom-progresso', '', ''),
(12509, 81, 0, 2, 'Bom Retiro do Sul', '', 'bom-retiro-do-sul', '', ''),
(12510, 81, 0, 2, 'Boqueirão do Leão', '', 'boqueirao-do-leao', '', ''),
(12511, 81, 0, 2, 'Bossoroca', '', 'bossoroca', '', ''),
(12512, 81, 0, 2, 'Braga', '', 'braga', '', ''),
(12513, 81, 0, 2, 'Brochier', '', 'brochier', '', ''),
(12514, 81, 0, 2, 'Butiá', '', 'butia', '', ''),
(12515, 81, 0, 2, 'Caçapava do Sul', '', 'cacapava-do-sul', '', ''),
(12516, 81, 0, 2, 'Cacequi', '', 'cacequi', '', ''),
(12517, 81, 0, 2, 'Cachoeira do Sul', '', 'cachoeira-do-sul', '', ''),
(12518, 81, 0, 2, 'Cachoeirinha', '', 'cachoeirinha', '', ''),
(12519, 81, 0, 2, 'Cacique Doble', '', 'cacique-doble', '', ''),
(12520, 81, 0, 2, 'Caibaté', '', 'caibate', '', ''),
(12521, 81, 0, 2, 'Caiçara', '', 'caicara', '', ''),
(12522, 81, 0, 2, 'Camaquã', '', 'camaqua', '', ''),
(12523, 81, 0, 2, 'Camargo', '', 'camargo', '', ''),
(12524, 81, 0, 2, 'Cambará do Sul', '', 'cambara-do-sul', '', ''),
(12525, 81, 0, 2, 'Campestre da Serra', '', 'campestre-da-serra', '', ''),
(12526, 81, 0, 2, 'Campina das Missões', '', 'campina-das-missoes', '', ''),
(12527, 81, 0, 2, 'Campinas do Sul', '', 'campinas-do-sul', '', ''),
(12528, 81, 0, 2, 'Campo Bom', '', 'campo-bom', '', ''),
(12529, 81, 0, 2, 'Campo Novo', '', 'campo-novo', '', ''),
(12530, 81, 0, 2, 'Campos Borges', '', 'campos-borges', '', ''),
(12531, 81, 0, 2, 'Candelária', '', 'candelaria', '', ''),
(12532, 81, 0, 2, 'Cândido Godói', '', 'candido-godoi', '', ''),
(12533, 81, 0, 2, 'Candiota', '', 'candiota', '', ''),
(12534, 81, 0, 2, 'Canela', '', 'canela', '', ''),
(12535, 81, 0, 2, 'Canguçu', '', 'cangucu', '', ''),
(12536, 81, 0, 2, 'Canoas', '', 'canoas', '', ''),
(12537, 81, 0, 2, 'Capão da Canoa', '', 'capao-da-canoa', '', ''),
(12538, 81, 0, 2, 'Capão do Leão', '', 'capao-do-leao', '', ''),
(12539, 81, 0, 2, 'Capela de Santana', '', 'capela-de-santana', '', ''),
(12540, 81, 0, 2, 'Capitão', '', 'capitao', '', ''),
(12541, 81, 0, 2, 'Capivari do Sul', '', 'capivari-do-sul', '', ''),
(12542, 81, 0, 2, 'Caraá', '', 'caraa', '', ''),
(12543, 81, 0, 2, 'Carazinho', '', 'carazinho', '', ''),
(12544, 81, 0, 2, 'Carlos Barbosa', '', 'carlos-barbosa', '', ''),
(12545, 81, 0, 2, 'Carlos Gomes', '', 'carlos-gomes', '', ''),
(12546, 81, 0, 2, 'Casca', '', 'casca', '', ''),
(12547, 81, 0, 2, 'Caseiros', '', 'caseiros', '', ''),
(12548, 81, 0, 2, 'Catuípe', '', 'catuipe', '', ''),
(12549, 81, 0, 2, 'Caxias do Sul', '', 'caxias-do-sul', '', ''),
(12550, 81, 0, 2, 'Centenário', '', 'centenario', '', ''),
(12551, 81, 0, 2, 'Cerrito', '', 'cerrito', '', ''),
(12552, 81, 0, 2, 'Cerro Branco', '', 'cerro-branco', '', ''),
(12553, 81, 0, 2, 'Cerro Grande', '', 'cerro-grande', '', ''),
(12554, 81, 0, 2, 'Cerro Grande do Sul', '', 'cerro-grande-do-sul', '', ''),
(12555, 81, 0, 2, 'Cerro Largo', '', 'cerro-largo', '', ''),
(12556, 81, 0, 2, 'Chapada', '', 'chapada', '', ''),
(12557, 81, 0, 2, 'Charqueadas', '', 'charqueadas', '', ''),
(12558, 81, 0, 2, 'Charrua', '', 'charrua', '', ''),
(12559, 81, 0, 2, 'Chiapeta', '', 'chiapeta', '', ''),
(12560, 81, 0, 2, 'Chuí', '', 'chui', '', ''),
(12561, 81, 0, 2, 'Chuvisca', '', 'chuvisca', '', ''),
(12562, 81, 0, 2, 'Cidreira', '', 'cidreira', '', ''),
(12563, 81, 0, 2, 'Ciríaco', '', 'ciriaco', '', ''),
(12564, 81, 0, 2, 'Colinas', '', 'colinas', '', ''),
(12565, 81, 0, 2, 'Colorado', '', 'colorado', '', ''),
(12566, 81, 0, 2, 'Condor', '', 'condor', '', ''),
(12567, 81, 0, 2, 'Constantina', '', 'constantina', '', ''),
(12568, 81, 0, 2, 'Coqueiros do Sul', '', 'coqueiros-do-sul', '', ''),
(12569, 81, 0, 2, 'Coronel Barros', '', 'coronel-barros', '', ''),
(12570, 81, 0, 2, 'Coronel Bicaco', '', 'coronel-bicaco', '', ''),
(12571, 81, 0, 2, 'Cotiporã', '', 'cotipora', '', ''),
(12572, 81, 0, 2, 'Coxilha', '', 'coxilha', '', ''),
(12573, 81, 0, 2, 'Crissiumal', '', 'crissiumal', '', ''),
(12574, 81, 0, 2, 'Cristal', '', 'cristal', '', ''),
(12575, 81, 0, 2, 'Cristal do Sul', '', 'cristal-do-sul', '', ''),
(12576, 81, 0, 2, 'Cruz Alta', '', 'cruz-alta', '', ''),
(12577, 81, 0, 2, 'Cruzeiro do Sul', '', 'cruzeiro-do-sul', '', ''),
(12578, 81, 0, 2, 'David Canabarro', '', 'david-canabarro', '', ''),
(12579, 81, 0, 2, 'Derrubadas', '', 'derrubadas', '', ''),
(12580, 81, 0, 2, 'Dezesseis de Novembro', '', 'dezesseis-de-novembro', '', ''),
(12581, 81, 0, 2, 'Dilermando de Aguiar', '', 'dilermando-de-aguiar', '', ''),
(12582, 81, 0, 2, 'Dois Irmãos', '', 'dois-irmaos', '', ''),
(12583, 81, 0, 2, 'Dois Irmãos das Missões', '', 'dois-irmaos-das-missoes', '', ''),
(12584, 81, 0, 2, 'Dois Lajeados', '', 'dois-lajeados', '', ''),
(12585, 81, 0, 2, 'Dom Feliciano', '', 'dom-feliciano', '', ''),
(12586, 81, 0, 2, 'Dom Pedrito', '', 'dom-pedrito', '', ''),
(12587, 81, 0, 2, 'Dom Pedro de Alcântara', '', 'dom-pedro-de-alcantara', '', ''),
(12588, 81, 0, 2, 'Dona Francisca', '', 'dona-francisca', '', ''),
(12589, 81, 0, 2, 'Doutor Maurício Cardoso', '', 'doutor-mauricio-cardoso', '', ''),
(12590, 81, 0, 2, 'Doutor Ricardo', '', 'doutor-ricardo', '', ''),
(12591, 81, 0, 2, 'Eldorado do Sul', '', 'eldorado-do-sul', '', ''),
(12592, 81, 0, 2, 'Encantado', '', 'encantado', '', ''),
(12593, 81, 0, 2, 'Encruzilhada do Sul', '', 'encruzilhada-do-sul', '', ''),
(12594, 81, 0, 2, 'Engenho Velho', '', 'engenho-velho', '', ''),
(12595, 81, 0, 2, 'Entre Rios do Sul', '', 'entre-rios-do-sul', '', ''),
(12596, 81, 0, 2, 'Entre-Ijuís', '', 'entre-ijuis', '', ''),
(12597, 81, 0, 2, 'Erebango', '', 'erebango', '', ''),
(12598, 81, 0, 2, 'Erechim', '', 'erechim', '', ''),
(12599, 81, 0, 2, 'Ernestina', '', 'ernestina', '', ''),
(12600, 81, 0, 2, 'Erval Grande', '', 'erval-grande', '', ''),
(12601, 81, 0, 2, 'Erval Seco', '', 'erval-seco', '', ''),
(12602, 81, 0, 2, 'Esmeralda', '', 'esmeralda', '', ''),
(12603, 81, 0, 2, 'Esperança do Sul', '', 'esperanca-do-sul', '', ''),
(12604, 81, 0, 2, 'Espumoso', '', 'espumoso', '', ''),
(12605, 81, 0, 2, 'Estação', '', 'estacao', '', ''),
(12606, 81, 0, 2, 'Estância Velha', '', 'estancia-velha', '', ''),
(12607, 81, 0, 2, 'Esteio', '', 'esteio', '', ''),
(12608, 81, 0, 2, 'Estrela', '', 'estrela', '', ''),
(12609, 81, 0, 2, 'Estrela Velha', '', 'estrela-velha', '', ''),
(12610, 81, 0, 2, 'Eugênio de Castro', '', 'eugenio-de-castro', '', ''),
(12611, 81, 0, 2, 'Fagundes Varela', '', 'fagundes-varela', '', ''),
(12612, 81, 0, 2, 'Farroupilha', '', 'farroupilha', '', ''),
(12613, 81, 0, 2, 'Faxinal do Soturno', '', 'faxinal-do-soturno', '', ''),
(12614, 81, 0, 2, 'Faxinalzinho', '', 'faxinalzinho', '', ''),
(12615, 81, 0, 2, 'Fazenda Vilanova', '', 'fazenda-vilanova', '', ''),
(12616, 81, 0, 2, 'Feliz', '', 'feliz', '', ''),
(12617, 81, 0, 2, 'Flores da Cunha', '', 'flores-da-cunha', '', ''),
(12618, 81, 0, 2, 'Floriano Peixoto', '', 'floriano-peixoto', '', ''),
(12619, 81, 0, 2, 'Fontoura Xavier', '', 'fontoura-xavier', '', ''),
(12620, 81, 0, 2, 'Formigueiro', '', 'formigueiro', '', ''),
(12621, 81, 0, 2, 'Fortaleza dos Valos', '', 'fortaleza-dos-valos', '', ''),
(12622, 81, 0, 2, 'Frederico Westphalen', '', 'frederico-westphalen', '', ''),
(12623, 81, 0, 2, 'Garibaldi', '', 'garibaldi', '', ''),
(12624, 81, 0, 2, 'Garruchos', '', 'garruchos', '', ''),
(12625, 81, 0, 2, 'Gaurama', '', 'gaurama', '', ''),
(12626, 81, 0, 2, 'General Câmara', '', 'general-camara', '', ''),
(12627, 81, 0, 2, 'Gentil', '', 'gentil', '', ''),
(12628, 81, 0, 2, 'Getúlio Vargas', '', 'getulio-vargas', '', ''),
(12629, 81, 0, 2, 'Giruá', '', 'girua', '', ''),
(12630, 81, 0, 2, 'Glorinha', '', 'glorinha', '', ''),
(12631, 81, 0, 2, 'Gramado', '', 'gramado', '', ''),
(12632, 81, 0, 2, 'Gramado dos Loureiros', '', 'gramado-dos-loureiros', '', ''),
(12633, 81, 0, 2, 'Gramado Xavier', '', 'gramado-xavier', '', ''),
(12634, 81, 0, 2, 'Gravataí', '', 'gravatai', '', ''),
(12635, 81, 0, 2, 'Guabiju', '', 'guabiju', '', ''),
(12636, 81, 0, 2, 'Guaíba', '', 'guaiba', '', ''),
(12637, 81, 0, 2, 'Guaporé', '', 'guapore', '', ''),
(12638, 81, 0, 2, 'Guarani das Missões', '', 'guarani-das-missoes', '', ''),
(12639, 81, 0, 2, 'Harmonia', '', 'harmonia', '', ''),
(12640, 81, 0, 2, 'Herval', '', 'herval', '', ''),
(12641, 81, 0, 2, 'Herveiras', '', 'herveiras', '', ''),
(12642, 81, 0, 2, 'Horizontina', '', 'horizontina', '', ''),
(12643, 81, 0, 2, 'Hulha Negra', '', 'hulha-negra', '', ''),
(12644, 81, 0, 2, 'Humaitá', '', 'humaita', '', ''),
(12645, 81, 0, 2, 'Ibarama', '', 'ibarama', '', ''),
(12646, 81, 0, 2, 'Ibiaçá', '', 'ibiaca', '', ''),
(12647, 81, 0, 2, 'Ibiraiaras', '', 'ibiraiaras', '', ''),
(12648, 81, 0, 2, 'Ibirapuitã', '', 'ibirapuita', '', ''),
(12649, 81, 0, 2, 'Ibirubá', '', 'ibiruba', '', ''),
(12650, 81, 0, 2, 'Igrejinha', '', 'igrejinha', '', ''),
(12651, 81, 0, 2, 'Ijuí', '', 'ijui', '', ''),
(12652, 81, 0, 2, 'Ilópolis', '', 'ilopolis', '', ''),
(12653, 81, 0, 2, 'Imbé', '', 'imbe', '', ''),
(12654, 81, 0, 2, 'Imigrante', '', 'imigrante', '', ''),
(12655, 81, 0, 2, 'Independência', '', 'independencia', '', ''),
(12656, 81, 0, 2, 'Inhacorá', '', 'inhacora', '', ''),
(12657, 81, 0, 2, 'Ipê', '', 'ipe', '', ''),
(12658, 81, 0, 2, 'Ipiranga do Sul', '', 'ipiranga-do-sul', '', ''),
(12659, 81, 0, 2, 'Iraí', '', 'irai', '', ''),
(12660, 81, 0, 2, 'Itaara', '', 'itaara', '', ''),
(12661, 81, 0, 2, 'Itacurubi', '', 'itacurubi', '', ''),
(12662, 81, 0, 2, 'Itapuca', '', 'itapuca', '', ''),
(12663, 81, 0, 2, 'Itaqui', '', 'itaqui', '', ''),
(12664, 81, 0, 2, 'Itatiba do Sul', '', 'itatiba-do-sul', '', ''),
(12665, 81, 0, 2, 'Ivorá', '', 'ivora', '', ''),
(12666, 81, 0, 2, 'Ivoti', '', 'ivoti', '', ''),
(12667, 81, 0, 2, 'Jaboticaba', '', 'jaboticaba', '', ''),
(12668, 81, 0, 2, 'Jacutinga', '', 'jacutinga', '', ''),
(12669, 81, 0, 2, 'Jaguarão', '', 'jaguarao', '', ''),
(12670, 81, 0, 2, 'Jaguari', '', 'jaguari', '', ''),
(12671, 81, 0, 2, 'Jaquirana', '', 'jaquirana', '', ''),
(12672, 81, 0, 2, 'Jari', '', 'jari', '', ''),
(12673, 81, 0, 2, 'Jóia', '', 'joia', '', ''),
(12674, 81, 0, 2, 'Júlio de Castilhos', '', 'julio-de-castilhos', '', ''),
(12675, 81, 0, 2, 'Lagoa dos Três Cantos', '', 'lagoa-dos-tres-cantos', '', ''),
(12676, 81, 0, 2, 'Lagoa Vermelha', '', 'lagoa-vermelha', '', ''),
(12677, 81, 0, 2, 'Lagoão', '', 'lagoao', '', ''),
(12678, 81, 0, 2, 'Lajeado', '', 'lajeado', '', ''),
(12679, 81, 0, 2, 'Lajeado do Bugre', '', 'lajeado-do-bugre', '', ''),
(12680, 81, 0, 2, 'Lavras do Sul', '', 'lavras-do-sul', '', ''),
(12681, 81, 0, 2, 'Liberato Salzano', '', 'liberato-salzano', '', ''),
(12682, 81, 0, 2, 'Lindolfo Collor', '', 'lindolfo-collor', '', ''),
(12683, 81, 0, 2, 'Linha Nova', '', 'linha-nova', '', ''),
(12684, 81, 0, 2, 'Maçambara', '', 'macambara', '', ''),
(12685, 81, 0, 2, 'Machadinho', '', 'machadinho', '', ''),
(12686, 81, 0, 2, 'Mampituba', '', 'mampituba', '', ''),
(12687, 81, 0, 2, 'Manoel Viana', '', 'manoel-viana', '', ''),
(12688, 81, 0, 2, 'Maquiné', '', 'maquine', '', ''),
(12689, 81, 0, 2, 'Maratá', '', 'marata', '', ''),
(12690, 81, 0, 2, 'Marau', '', 'marau', '', ''),
(12691, 81, 0, 2, 'Marcelino Ramos', '', 'marcelino-ramos', '', ''),
(12692, 81, 0, 2, 'Mariana Pimentel', '', 'mariana-pimentel', '', ''),
(12693, 81, 0, 2, 'Mariano Moro', '', 'mariano-moro', '', ''),
(12694, 81, 0, 2, 'Marques de Souza', '', 'marques-de-souza', '', ''),
(12695, 81, 0, 2, 'Mata', '', 'mata', '', ''),
(12696, 81, 0, 2, 'Mato Castelhano', '', 'mato-castelhano', '', ''),
(12697, 81, 0, 2, 'Mato Leitão', '', 'mato-leitao', '', ''),
(12698, 81, 0, 2, 'Maximiliano de Almeida', '', 'maximiliano-de-almeida', '', ''),
(12699, 81, 0, 2, 'Minas do Leão', '', 'minas-do-leao', '', ''),
(12700, 81, 0, 2, 'Miraguaí', '', 'miraguai', '', ''),
(12701, 81, 0, 2, 'Montauri', '', 'montauri', '', ''),
(12702, 81, 0, 2, 'Monte Alegre dos Campos', '', 'monte-alegre-dos-campos', '', ''),
(12703, 81, 0, 2, 'Monte Belo do Sul', '', 'monte-belo-do-sul', '', ''),
(12704, 81, 0, 2, 'Montenegro', '', 'montenegro', '', ''),
(12705, 81, 0, 2, 'Mormaço', '', 'mormaco', '', ''),
(12706, 81, 0, 2, 'Morrinhos do Sul', '', 'morrinhos-do-sul', '', ''),
(12707, 81, 0, 2, 'Morro Redondo', '', 'morro-redondo', '', ''),
(12708, 81, 0, 2, 'Morro Reuter', '', 'morro-reuter', '', ''),
(12709, 81, 0, 2, 'Mostardas', '', 'mostardas', '', ''),
(12710, 81, 0, 2, 'Muçum', '', 'mucum', '', ''),
(12711, 81, 0, 2, 'Muitos Capões', '', 'muitos-capoes', '', ''),
(12712, 81, 0, 2, 'Muliterno', '', 'muliterno', '', ''),
(12713, 81, 0, 2, 'Não-Me-Toque', '', 'nao-me-toque', '', ''),
(12714, 81, 0, 2, 'Nicolau Vergueiro', '', 'nicolau-vergueiro', '', ''),
(12715, 81, 0, 2, 'Nonoai', '', 'nonoai', '', ''),
(12716, 81, 0, 2, 'Nova Alvorada', '', 'nova-alvorada', '', ''),
(12717, 81, 0, 2, 'Nova Araçá', '', 'nova-araca', '', ''),
(12718, 81, 0, 2, 'Nova Bassano', '', 'nova-bassano', '', ''),
(12719, 81, 0, 2, 'Nova Boa Vista', '', 'nova-boa-vista', '', ''),
(12720, 81, 0, 2, 'Nova Bréscia', '', 'nova-brescia', '', ''),
(12721, 81, 0, 2, 'Nova Candelária', '', 'nova-candelaria', '', ''),
(12722, 81, 0, 2, 'Nova Esperança do Sul', '', 'nova-esperanca-do-sul', '', ''),
(12723, 81, 0, 2, 'Nova Hartz', '', 'nova-hartz', '', ''),
(12724, 81, 0, 2, 'Nova Pádua', '', 'nova-padua', '', ''),
(12725, 81, 0, 2, 'Nova Palma', '', 'nova-palma', '', ''),
(12726, 81, 0, 2, 'Nova Petrópolis', '', 'nova-petropolis', '', ''),
(12727, 81, 0, 2, 'Nova Prata', '', 'nova-prata', '', ''),
(12728, 81, 0, 2, 'Nova Ramada', '', 'nova-ramada', '', ''),
(12729, 81, 0, 2, 'Nova Roma do Sul', '', 'nova-roma-do-sul', '', ''),
(12730, 81, 0, 2, 'Nova Santa Rita', '', 'nova-santa-rita', '', ''),
(12731, 81, 0, 2, 'Novo Barreiro', '', 'novo-barreiro', '', ''),
(12732, 81, 0, 2, 'Novo Cabrais', '', 'novo-cabrais', '', ''),
(12733, 81, 0, 2, 'Novo Hamburgo', '', 'novo-hamburgo', '', ''),
(12734, 81, 0, 2, 'Novo Machado', '', 'novo-machado', '', ''),
(12735, 81, 0, 2, 'Novo Tiradentes', '', 'novo-tiradentes', '', ''),
(12736, 81, 0, 2, 'Osório', '', 'osorio', '', ''),
(12737, 81, 0, 2, 'Paim Filho', '', 'paim-filho', '', ''),
(12738, 81, 0, 2, 'Palmares do Sul', '', 'palmares-do-sul', '', ''),
(12739, 81, 0, 2, 'Palmeira das Missões', '', 'palmeira-das-missoes', '', ''),
(12740, 81, 0, 2, 'Palmitinho', '', 'palmitinho', '', ''),
(12741, 81, 0, 2, 'Panambi', '', 'panambi', '', ''),
(12742, 81, 0, 2, 'Pantano Grande', '', 'pantano-grande', '', ''),
(12743, 81, 0, 2, 'Paraí', '', 'parai', '', ''),
(12744, 81, 0, 2, 'Paraíso do Sul', '', 'paraiso-do-sul', '', ''),
(12745, 81, 0, 2, 'Pareci Novo', '', 'pareci-novo', '', ''),
(12746, 81, 0, 2, 'Parobé', '', 'parobe', '', ''),
(12747, 81, 0, 2, 'Passa Sete', '', 'passa-sete', '', ''),
(12748, 81, 0, 2, 'Passo do Sobrado', '', 'passo-do-sobrado', '', ''),
(12749, 81, 0, 2, 'Passo Fundo', '', 'passo-fundo', '', ''),
(12750, 81, 0, 2, 'Paverama', '', 'paverama', '', ''),
(12751, 81, 0, 2, 'Pedro Osório', '', 'pedro-osorio', '', ''),
(12752, 81, 0, 2, 'Pejuçara', '', 'pejucara', '', ''),
(12753, 81, 0, 2, 'Pelotas', '', 'pelotas', '', ''),
(12754, 81, 0, 2, 'Picada Café', '', 'picada-cafe', '', ''),
(12755, 81, 0, 2, 'Pinhal', '', 'pinhal', '', ''),
(12756, 81, 0, 2, 'Pinhal Grande', '', 'pinhal-grande', '', ''),
(12757, 81, 0, 2, 'Pinheirinho do Vale', '', 'pinheirinho-do-vale', '', ''),
(12758, 81, 0, 2, 'Pinheiro Machado', '', 'pinheiro-machado', '', ''),
(12759, 81, 0, 2, 'Pirapó', '', 'pirapo', '', ''),
(12760, 81, 0, 2, 'Piratini', '', 'piratini', '', ''),
(12761, 81, 0, 2, 'Planalto', '', 'planalto', '', ''),
(12762, 81, 0, 2, 'Poço das Antas', '', 'poco-das-antas', '', ''),
(12763, 81, 0, 2, 'Pontão', '', 'pontao', '', ''),
(12764, 81, 0, 2, 'Ponte Preta', '', 'ponte-preta', '', ''),
(12765, 81, 0, 2, 'Portão', '', 'portao', '', ''),
(12766, 81, 0, 2, 'Porto Alegre', '', 'porto-alegre', '', ''),
(12767, 81, 0, 2, 'Porto Lucena', '', 'porto-lucena', '', ''),
(12768, 81, 0, 2, 'Porto Mauá', '', 'porto-maua', '', ''),
(12769, 81, 0, 2, 'Porto Vera Cruz', '', 'porto-vera-cruz', '', ''),
(12770, 81, 0, 2, 'Porto Xavier', '', 'porto-xavier', '', ''),
(12771, 81, 0, 2, 'Pouso Novo', '', 'pouso-novo', '', ''),
(12772, 81, 0, 2, 'Presidente Lucena', '', 'presidente-lucena', '', ''),
(12773, 81, 0, 2, 'Progresso', '', 'progresso', '', ''),
(12774, 81, 0, 2, 'Protásio Alves', '', 'protasio-alves', '', ''),
(12775, 81, 0, 2, 'Putinga', '', 'putinga', '', ''),
(12776, 81, 0, 2, 'Quaraí', '', 'quarai', '', ''),
(12777, 81, 0, 2, 'Quevedos', '', 'quevedos', '', ''),
(12778, 81, 0, 2, 'Quinze de Novembro', '', 'quinze-de-novembro', '', ''),
(12779, 81, 0, 2, 'Redentora', '', 'redentora', '', ''),
(12780, 81, 0, 2, 'Relvado', '', 'relvado', '', ''),
(12781, 81, 0, 2, 'Restinga Seca', '', 'restinga-seca', '', ''),
(12782, 81, 0, 2, 'Rio dos Índios', '', 'rio-dos-indios', '', ''),
(12783, 81, 0, 2, 'Rio Grande', '', 'rio-grande', '', ''),
(12784, 81, 0, 2, 'Rio Pardo', '', 'rio-pardo', '', ''),
(12785, 81, 0, 2, 'Riozinho', '', 'riozinho', '', ''),
(12786, 81, 0, 2, 'Roca Sales', '', 'roca-sales', '', ''),
(12787, 81, 0, 2, 'Rodeio Bonito', '', 'rodeio-bonito', '', ''),
(12788, 81, 0, 2, 'Rolante', '', 'rolante', '', ''),
(12789, 81, 0, 2, 'Ronda Alta', '', 'ronda-alta', '', ''),
(12790, 81, 0, 2, 'Rondinha', '', 'rondinha', '', ''),
(12791, 81, 0, 2, 'Roque Gonzales', '', 'roque-gonzales', '', ''),
(12792, 81, 0, 2, 'Rosário do Sul', '', 'rosario-do-sul', '', ''),
(12793, 81, 0, 2, 'Sagrada Família', '', 'sagrada-familia', '', ''),
(12794, 81, 0, 2, 'Saldanha Marinho', '', 'saldanha-marinho', '', ''),
(12795, 81, 0, 2, 'Salto do Jacuí', '', 'salto-do-jacui', '', ''),
(12796, 81, 0, 2, 'Salvador das Missões', '', 'salvador-das-missoes', '', ''),
(12797, 81, 0, 2, 'Salvador do Sul', '', 'salvador-do-sul', '', ''),
(12798, 81, 0, 2, 'Sananduva', '', 'sananduva', '', ''),
(12799, 81, 0, 2, 'Santa Bárbara do Sul', '', 'santa-barbara-do-sul', '', ''),
(12800, 81, 0, 2, 'Santa Clara do Sul', '', 'santa-clara-do-sul', '', ''),
(12801, 81, 0, 2, 'Santa Cruz do Sul', '', 'santa-cruz-do-sul', '', ''),
(12802, 81, 0, 2, 'Santa Maria', '', 'santa-maria', '', ''),
(12803, 81, 0, 2, 'Santa Maria do Herval', '', 'santa-maria-do-herval', '', ''),
(12804, 81, 0, 2, 'Santa Rosa', '', 'santa-rosa', '', ''),
(12805, 81, 0, 2, 'Santa Tereza', '', 'santa-tereza', '', ''),
(12806, 81, 0, 2, 'Santa Vitória do Palmar', '', 'santa-vitoria-do-palmar', '', ''),
(12807, 81, 0, 2, 'Santana da Boa Vista', '', 'santana-da-boa-vista', '', ''),
(12808, 81, 0, 2, 'Santana do Livramento', '', 'santana-do-livramento', '', ''),
(12809, 81, 0, 2, 'Santiago', '', 'santiago', '', ''),
(12810, 81, 0, 2, 'Santo Ângelo', '', 'santo-angelo', '', ''),
(12811, 81, 0, 2, 'Santo Antônio da Patrulha', '', 'santo-antonio-da-patrulha', '', ''),
(12812, 81, 0, 2, 'Santo Antônio das Missões', '', 'santo-antonio-das-missoes', '', ''),
(12813, 81, 0, 2, 'Santo Antônio do Palma', '', 'santo-antonio-do-palma', '', ''),
(12814, 81, 0, 2, 'Santo Antônio do Planalto', '', 'santo-antonio-do-planalto', '', ''),
(12815, 81, 0, 2, 'Santo Augusto', '', 'santo-augusto', '', ''),
(12816, 81, 0, 2, 'Santo Cristo', '', 'santo-cristo', '', ''),
(12817, 81, 0, 2, 'Santo Expedito do Sul', '', 'santo-expedito-do-sul', '', ''),
(12818, 81, 0, 2, 'São Borja', '', 'sao-borja', '', ''),
(12819, 81, 0, 2, 'São Domingos do Sul', '', 'sao-domingos-do-sul', '', ''),
(12820, 81, 0, 2, 'São Francisco de Assis', '', 'sao-francisco-de-assis', '', ''),
(12821, 81, 0, 2, 'São Francisco de Paula', '', 'sao-francisco-de-paula', '', ''),
(12822, 81, 0, 2, 'São Gabriel', '', 'sao-gabriel', '', ''),
(12823, 81, 0, 2, 'São Jerônimo', '', 'sao-jeronimo', '', ''),
(12824, 81, 0, 2, 'São João da Urtiga', '', 'sao-joao-da-urtiga', '', ''),
(12825, 81, 0, 2, 'São João do Polêsine', '', 'sao-joao-do-polesine', '', ''),
(12826, 81, 0, 2, 'São Jorge', '', 'sao-jorge', '', ''),
(12827, 81, 0, 2, 'São José das Missões', '', 'sao-jose-das-missoes', '', ''),
(12828, 81, 0, 2, 'São José do Herval', '', 'sao-jose-do-herval', '', ''),
(12829, 81, 0, 2, 'São José do Hortêncio', '', 'sao-jose-do-hortencio', '', ''),
(12830, 81, 0, 2, 'São José do Inhacorá', '', 'sao-jose-do-inhacora', '', ''),
(12831, 81, 0, 2, 'São José do Norte', '', 'sao-jose-do-norte', '', ''),
(12832, 81, 0, 2, 'São José do Ouro', '', 'sao-jose-do-ouro', '', ''),
(12833, 81, 0, 2, 'São José dos Ausentes', '', 'sao-jose-dos-ausentes', '', ''),
(12834, 81, 0, 2, 'São Leopoldo', '', 'sao-leopoldo', '', ''),
(12835, 81, 0, 2, 'São Lourenço do Sul', '', 'sao-lourenco-do-sul', '', ''),
(12836, 81, 0, 2, 'São Luiz Gonzaga', '', 'sao-luiz-gonzaga', '', ''),
(12837, 81, 0, 2, 'São Marcos', '', 'sao-marcos', '', ''),
(12838, 81, 0, 2, 'São Martinho', '', 'sao-martinho', '', ''),
(12839, 81, 0, 2, 'São Martinho da Serra', '', 'sao-martinho-da-serra', '', ''),
(12840, 81, 0, 2, 'São Miguel das Missões', '', 'sao-miguel-das-missoes', '', ''),
(12841, 81, 0, 2, 'São Nicolau', '', 'sao-nicolau', '', ''),
(12842, 81, 0, 2, 'São Paulo das Missões', '', 'sao-paulo-das-missoes', '', ''),
(12843, 81, 0, 2, 'São Pedro da Serra', '', 'sao-pedro-da-serra', '', ''),
(12844, 81, 0, 2, 'São Pedro do Butiá', '', 'sao-pedro-do-butia', '', ''),
(12845, 81, 0, 2, 'São Pedro do Sul', '', 'sao-pedro-do-sul', '', ''),
(12846, 81, 0, 2, 'São Sebastião do Caí', '', 'sao-sebastiao-do-cai', '', ''),
(12847, 81, 0, 2, 'São Sepé', '', 'sao-sepe', '', ''),
(12848, 81, 0, 2, 'São Valentim', '', 'sao-valentim', '', ''),
(12849, 81, 0, 2, 'São Valentim do Sul', '', 'sao-valentim-do-sul', '', ''),
(12850, 81, 0, 2, 'São Valério do Sul', '', 'sao-valerio-do-sul', '', ''),
(12851, 81, 0, 2, 'São Vendelino', '', 'sao-vendelino', '', ''),
(12852, 81, 0, 2, 'São Vicente do Sul', '', 'sao-vicente-do-sul', '', ''),
(12853, 81, 0, 2, 'Sapiranga', '', 'sapiranga', '', ''),
(12854, 81, 0, 2, 'Sapucaia do Sul', '', 'sapucaia-do-sul', '', ''),
(12855, 81, 0, 2, 'Sarandi', '', 'sarandi', '', ''),
(12856, 81, 0, 2, 'Seberi', '', 'seberi', '', ''),
(12857, 81, 0, 2, 'Sede Nova', '', 'sede-nova', '', ''),
(12858, 81, 0, 2, 'Segredo', '', 'segredo', '', ''),
(12859, 81, 0, 2, 'Selbach', '', 'selbach', '', ''),
(12860, 81, 0, 2, 'Senador Salgado Filho', '', 'senador-salgado-filho', '', ''),
(12861, 81, 0, 2, 'Sentinela do Sul', '', 'sentinela-do-sul', '', ''),
(12862, 81, 0, 2, 'Serafina Corrêa', '', 'serafina-correa', '', ''),
(12863, 81, 0, 2, 'Sério', '', 'serio', '', ''),
(12864, 81, 0, 2, 'Sertão', '', 'sertao', '', ''),
(12865, 81, 0, 2, 'Sertão Santana', '', 'sertao-santana', '', ''),
(12866, 81, 0, 2, 'Sete de Setembro', '', 'sete-de-setembro', '', ''),
(12867, 81, 0, 2, 'Severiano de Almeida', '', 'severiano-de-almeida', '', ''),
(12868, 81, 0, 2, 'Silveira Martins', '', 'silveira-martins', '', ''),
(12869, 81, 0, 2, 'Sinimbu', '', 'sinimbu', '', ''),
(12870, 81, 0, 2, 'Sobradinho', '', 'sobradinho', '', ''),
(12871, 81, 0, 2, 'Soledade', '', 'soledade', '', ''),
(12872, 81, 0, 2, 'Tabaí', '', 'tabai', '', ''),
(12873, 81, 0, 2, 'Tapejara', '', 'tapejara', '', ''),
(12874, 81, 0, 2, 'Tapera', '', 'tapera', '', ''),
(12875, 81, 0, 2, 'Tapes', '', 'tapes', '', ''),
(12876, 81, 0, 2, 'Taquara', '', 'taquara', '', ''),
(12877, 81, 0, 2, 'Taquari', '', 'taquari', '', ''),
(12878, 81, 0, 2, 'Taquaruçu do Sul', '', 'taquarucu-do-sul', '', ''),
(12879, 81, 0, 2, 'Tavares', '', 'tavares', '', ''),
(12880, 81, 0, 2, 'Tenente Portela', '', 'tenente-portela', '', ''),
(12881, 81, 0, 2, 'Terra de Areia', '', 'terra-de-areia', '', ''),
(12882, 81, 0, 2, 'Teutônia', '', 'teutonia', '', ''),
(12883, 81, 0, 2, 'Tiradentes do Sul', '', 'tiradentes-do-sul', '', ''),
(12884, 81, 0, 2, 'Toropi', '', 'toropi', '', ''),
(12885, 81, 0, 2, 'Torres', '', 'torres', '', ''),
(12886, 81, 0, 2, 'Tramandaí', '', 'tramandai', '', ''),
(12887, 81, 0, 2, 'Travesseiro', '', 'travesseiro', '', ''),
(12888, 81, 0, 2, 'Três Arroios', '', 'tres-arroios', '', ''),
(12889, 81, 0, 2, 'Três Cachoeiras', '', 'tres-cachoeiras', '', ''),
(12890, 81, 0, 2, 'Três Coroas', '', 'tres-coroas', '', ''),
(12891, 81, 0, 2, 'Três de Maio', '', 'tres-de-maio', '', ''),
(12892, 81, 0, 2, 'Três Forquilhas', '', 'tres-forquilhas', '', ''),
(12893, 81, 0, 2, 'Três Palmeiras', '', 'tres-palmeiras', '', ''),
(12894, 81, 0, 2, 'Três Passos', '', 'tres-passos', '', ''),
(12895, 81, 0, 2, 'Trindade do Sul', '', 'trindade-do-sul', '', ''),
(12896, 81, 0, 2, 'Triunfo', '', 'triunfo', '', ''),
(12897, 81, 0, 2, 'Tucunduva', '', 'tucunduva', '', ''),
(12898, 81, 0, 2, 'Tunas', '', 'tunas', '', ''),
(12899, 81, 0, 2, 'Tupanci do Sul', '', 'tupanci-do-sul', '', ''),
(12900, 81, 0, 2, 'Tupanciretã', '', 'tupancireta', '', ''),
(12901, 81, 0, 2, 'Tupandi', '', 'tupandi', '', ''),
(12902, 81, 0, 2, 'Tuparendi', '', 'tuparendi', '', ''),
(12903, 81, 0, 2, 'Turuçu', '', 'turucu', '', ''),
(12904, 81, 0, 2, 'Ubiretama', '', 'ubiretama', '', ''),
(12905, 81, 0, 2, 'União da Serra', '', 'uniao-da-serra', '', ''),
(12906, 81, 0, 2, 'Unistalda', '', 'unistalda', '', ''),
(12907, 81, 0, 2, 'Uruguaiana', '', 'uruguaiana', '', ''),
(12908, 81, 0, 2, 'Vacaria', '', 'vacaria', '', ''),
(12909, 81, 0, 2, 'Vale do Sol', '', 'vale-do-sol', '', ''),
(12910, 81, 0, 2, 'Vale Real', '', 'vale-real', '', ''),
(12911, 81, 0, 2, 'Vale Verde', '', 'vale-verde', '', ''),
(12912, 81, 0, 2, 'Vanini', '', 'vanini', '', ''),
(12913, 81, 0, 2, 'Venâncio Aires', '', 'venancio-aires', '', ''),
(12914, 81, 0, 2, 'Vera Cruz', '', 'vera-cruz', '', ''),
(12915, 81, 0, 2, 'Veranópolis', '', 'veranopolis', '', ''),
(12916, 81, 0, 2, 'Vespasiano Correa', '', 'vespasiano-correa', '', ''),
(12917, 81, 0, 2, 'Viadutos', '', 'viadutos', '', ''),
(12918, 81, 0, 2, 'Viamão', '', 'viamao', '', ''),
(12919, 81, 0, 2, 'Vicente Dutra', '', 'vicente-dutra', '', ''),
(12920, 81, 0, 2, 'Victor Graeff', '', 'victor-graeff', '', ''),
(12921, 81, 0, 2, 'Vila Flores', '', 'vila-flores', '', ''),
(12922, 81, 0, 2, 'Vila Lângaro', '', 'vila-langaro', '', ''),
(12923, 81, 0, 2, 'Vila Maria', '', 'vila-maria', '', ''),
(12924, 81, 0, 2, 'Vila Nova do Sul', '', 'vila-nova-do-sul', '', ''),
(12925, 81, 0, 2, 'Vista Alegre', '', 'vista-alegre', '', ''),
(12926, 81, 0, 2, 'Vista Alegre do Prata', '', 'vista-alegre-do-prata', '', ''),
(12927, 81, 0, 2, 'Vista Gaúcha', '', 'vista-gaucha', '', ''),
(12928, 81, 0, 2, 'Vitória das Missões', '', 'vitoria-das-missoes', '', ''),
(12929, 81, 0, 2, 'Xangri-lá', '', 'xangri-la', '', ''),
(12930, 82, 0, 2, 'Alta Floresta d`Oeste', '', 'alta-floresta-d`oeste', '', ''),
(12931, 82, 0, 2, 'Alto Alegre dos Parecis', '', 'alto-alegre-dos-parecis', '', ''),
(12932, 82, 0, 2, 'Alto Paraíso', '', 'alto-paraiso', '', ''),
(12933, 82, 0, 2, 'Alvorada d`Oeste', '', 'alvorada-d`oeste', '', ''),
(12934, 82, 0, 2, 'Ariquemes', '', 'ariquemes', '', ''),
(12935, 82, 0, 2, 'Buritis', '', 'buritis', '', ''),
(12936, 82, 0, 2, 'Cabixi', '', 'cabixi', '', ''),
(12937, 82, 0, 2, 'Cacaulândia', '', 'cacaulandia', '', ''),
(12938, 82, 0, 2, 'Cacoal', '', 'cacoal', '', ''),
(12939, 82, 0, 2, 'Campo Novo de Rondônia', '', 'campo-novo-de-rondonia', '', ''),
(12940, 82, 0, 2, 'Candeias do Jamari', '', 'candeias-do-jamari', '', ''),
(12941, 82, 0, 2, 'Castanheiras', '', 'castanheiras', '', ''),
(12942, 82, 0, 2, 'Cerejeiras', '', 'cerejeiras', '', ''),
(12943, 82, 0, 2, 'Chupinguaia', '', 'chupinguaia', '', ''),
(12944, 82, 0, 2, 'Colorado do Oeste', '', 'colorado-do-oeste', '', ''),
(12945, 82, 0, 2, 'Corumbiara', '', 'corumbiara', '', ''),
(12946, 82, 0, 2, 'Costa Marques', '', 'costa-marques', '', ''),
(12947, 82, 0, 2, 'Cujubim', '', 'cujubim', '', ''),
(12948, 82, 0, 2, 'Espigão d`Oeste', '', 'espigao-d`oeste', '', ''),
(12949, 82, 0, 2, 'Governador Jorge Teixeira', '', 'governador-jorge-teixeira', '', ''),
(12950, 82, 0, 2, 'Guajará-Mirim', '', 'guajara-mirim', '', ''),
(12951, 82, 0, 2, 'Itapuã do Oeste', '', 'itapua-do-oeste', '', ''),
(12952, 82, 0, 2, 'Jaru', '', 'jaru', '', ''),
(12953, 82, 0, 2, 'Ji-Paraná', '', 'ji-parana', '', ''),
(12954, 82, 0, 2, 'Machadinho d`Oeste', '', 'machadinho-d`oeste', '', ''),
(12955, 82, 0, 2, 'Ministro Andreazza', '', 'ministro-andreazza', '', ''),
(12956, 82, 0, 2, 'Mirante da Serra', '', 'mirante-da-serra', '', ''),
(12957, 82, 0, 2, 'Monte Negro', '', 'monte-negro', '', ''),
(12958, 82, 0, 2, 'Nova Brasilândia d`Oeste', '', 'nova-brasilandia-d`oeste', '', ''),
(12959, 82, 0, 2, 'Nova Mamoré', '', 'nova-mamore', '', ''),
(12960, 82, 0, 2, 'Nova União', '', 'nova-uniao', '', ''),
(12961, 82, 0, 2, 'Novo Horizonte do Oeste', '', 'novo-horizonte-do-oeste', '', ''),
(12962, 82, 0, 2, 'Ouro Preto do Oeste', '', 'ouro-preto-do-oeste', '', ''),
(12963, 82, 0, 2, 'Parecis', '', 'parecis', '', ''),
(12964, 82, 0, 2, 'Pimenta Bueno', '', 'pimenta-bueno', '', ''),
(12965, 82, 0, 2, 'Pimenteiras do Oeste', '', 'pimenteiras-do-oeste', '', ''),
(12966, 82, 0, 2, 'Porto Velho', '', 'porto-velho', '', ''),
(12967, 82, 0, 2, 'Presidente Médici', '', 'presidente-medici', '', ''),
(12968, 82, 0, 2, 'Primavera de Rondônia', '', 'primavera-de-rondonia', '', ''),
(12969, 82, 0, 2, 'Rio Crespo', '', 'rio-crespo', '', ''),
(12970, 82, 0, 2, 'Rolim de Moura', '', 'rolim-de-moura', '', ''),
(12971, 82, 0, 2, 'Santa Luzia d`Oeste', '', 'santa-luzia-d`oeste', '', ''),
(12972, 82, 0, 2, 'São Felipe d`Oeste', '', 'sao-felipe-d`oeste', '', ''),
(12973, 82, 0, 2, 'São Francisco do Guaporé', '', 'sao-francisco-do-guapore', '', ''),
(12974, 82, 0, 2, 'São Miguel do Guaporé', '', 'sao-miguel-do-guapore', '', ''),
(12975, 82, 0, 2, 'Seringueiras', '', 'seringueiras', '', ''),
(12976, 82, 0, 2, 'Teixeirópolis', '', 'teixeiropolis', '', ''),
(12977, 82, 0, 2, 'Theobroma', '', 'theobroma', '', ''),
(12978, 82, 0, 2, 'Urupá', '', 'urupa', '', ''),
(12979, 82, 0, 2, 'Vale do Anari', '', 'vale-do-anari', '', ''),
(12980, 82, 0, 2, 'Vale do Paraíso', '', 'vale-do-paraiso', '', ''),
(12981, 82, 0, 2, 'Vilhena', '', 'vilhena', '', ''),
(12982, 83, 0, 2, 'Alto Alegre', '', 'alto-alegre', '', ''),
(12983, 83, 0, 2, 'Amajari', '', 'amajari', '', ''),
(12984, 83, 0, 2, 'Boa Vista', '', 'boa-vista', '', ''),
(12985, 83, 0, 2, 'Bonfim', '', 'bonfim', '', ''),
(12986, 83, 0, 2, 'Cantá', '', 'canta', '', ''),
(12987, 83, 0, 2, 'Caracaraí', '', 'caracarai', '', ''),
(12988, 83, 0, 2, 'Caroebe', '', 'caroebe', '', ''),
(12989, 83, 0, 2, 'Iracema', '', 'iracema', '', ''),
(12990, 83, 0, 2, 'Mucajaí', '', 'mucajai', '', ''),
(12991, 83, 0, 2, 'Normandia', '', 'normandia', '', ''),
(12992, 83, 0, 2, 'Pacaraima', '', 'pacaraima', '', ''),
(12993, 83, 0, 2, 'Rorainópolis', '', 'rorainopolis', '', ''),
(12994, 83, 0, 2, 'São João da Baliza', '', 'sao-joao-da-baliza', '', ''),
(12995, 83, 0, 2, 'São Luiz', '', 'sao-luiz', '', ''),
(12996, 83, 0, 2, 'Uiramutã', '', 'uiramuta', '', ''),
(12997, 84, 0, 2, 'Abdon Batista', '', 'abdon-batista', '', ''),
(12998, 84, 0, 2, 'Abelardo Luz', '', 'abelardo-luz', '', ''),
(12999, 84, 0, 2, 'Agrolândia', '', 'agrolandia', '', ''),
(13000, 84, 0, 2, 'Agronômica', '', 'agronomica', '', ''),
(13001, 84, 0, 2, 'Água Doce', '', 'agua-doce', '', ''),
(13002, 84, 0, 2, 'Águas de Chapecó', '', 'aguas-de-chapeco', '', ''),
(13003, 84, 0, 2, 'Águas Frias', '', 'aguas-frias', '', ''),
(13004, 84, 0, 2, 'Águas Mornas', '', 'aguas-mornas', '', ''),
(13005, 84, 0, 2, 'Alfredo Wagner', '', 'alfredo-wagner', '', ''),
(13006, 84, 0, 2, 'Alto Bela Vista', '', 'alto-bela-vista', '', ''),
(13007, 84, 0, 2, 'Anchieta', '', 'anchieta', '', ''),
(13008, 84, 0, 2, 'Angelina', '', 'angelina', '', ''),
(13009, 84, 0, 2, 'Anita Garibaldi', '', 'anita-garibaldi', '', ''),
(13010, 84, 0, 2, 'Anitápolis', '', 'anitapolis', '', ''),
(13011, 84, 0, 2, 'Antônio Carlos', '', 'antonio-carlos', '', ''),
(13012, 84, 0, 2, 'Apiúna', '', 'apiuna', '', ''),
(13013, 84, 0, 2, 'Arabutã', '', 'arabuta', '', ''),
(13014, 84, 0, 2, 'Araquari', '', 'araquari', '', ''),
(13015, 84, 0, 2, 'Araranguá', '', 'ararangua', '', ''),
(13016, 84, 0, 2, 'Armazém', '', 'armazem', '', ''),
(13017, 84, 0, 2, 'Arroio Trinta', '', 'arroio-trinta', '', ''),
(13018, 84, 0, 2, 'Arvoredo', '', 'arvoredo', '', ''),
(13019, 84, 0, 2, 'Ascurra', '', 'ascurra', '', ''),
(13020, 84, 0, 2, 'Atalanta', '', 'atalanta', '', ''),
(13021, 84, 0, 2, 'Aurora', '', 'aurora', '', ''),
(13022, 84, 0, 2, 'Balneário Arroio do Silva', '', 'balneario-arroio-do-silva', '', ''),
(13023, 84, 0, 2, 'Balneário Barra do Sul', '', 'balneario-barra-do-sul', '', ''),
(13024, 84, 0, 2, 'Balneário Camboriú', '', 'balneario-camboriu', '', ''),
(13025, 84, 0, 2, 'Balneário Gaivota', '', 'balneario-gaivota', '', ''),
(13026, 84, 0, 2, 'Bandeirante', '', 'bandeirante', '', ''),
(13027, 84, 0, 2, 'Barra Bonita', '', 'barra-bonita', '', ''),
(13028, 84, 0, 2, 'Barra Velha', '', 'barra-velha', '', ''),
(13029, 84, 0, 2, 'Bela Vista do Toldo', '', 'bela-vista-do-toldo', '', ''),
(13030, 84, 0, 2, 'Belmonte', '', 'belmonte', '', ''),
(13031, 84, 0, 2, 'Benedito Novo', '', 'benedito-novo', '', ''),
(13032, 84, 0, 2, 'Biguaçu', '', 'biguacu', '', ''),
(13033, 84, 0, 2, 'Blumenau', '', 'blumenau', '', ''),
(13034, 84, 0, 2, 'Bocaina do Sul', '', 'bocaina-do-sul', '', ''),
(13035, 84, 0, 2, 'Bom Jardim da Serra', '', 'bom-jardim-da-serra', '', ''),
(13036, 84, 0, 2, 'Bom Jesus', '', 'bom-jesus', '', ''),
(13037, 84, 0, 2, 'Bom Jesus do Oeste', '', 'bom-jesus-do-oeste', '', ''),
(13038, 84, 0, 2, 'Bom Retiro', '', 'bom-retiro', '', ''),
(13039, 84, 0, 2, 'Bombinhas', '', 'bombinhas', '', ''),
(13040, 84, 0, 2, 'Botuverá', '', 'botuvera', '', ''),
(13041, 84, 0, 2, 'Braço do Norte', '', 'braco-do-norte', '', ''),
(13042, 84, 0, 2, 'Braço do Trombudo', '', 'braco-do-trombudo', '', ''),
(13043, 84, 0, 2, 'Brunópolis', '', 'brunopolis', '', ''),
(13044, 84, 0, 2, 'Brusque', '', 'brusque', '', ''),
(13045, 84, 0, 2, 'Caçador', '', 'cacador', '', ''),
(13046, 84, 0, 2, 'Caibi', '', 'caibi', '', ''),
(13047, 84, 0, 2, 'Calmon', '', 'calmon', '', ''),
(13048, 84, 0, 2, 'Camboriú', '', 'camboriu', '', ''),
(13049, 84, 0, 2, 'Campo Alegre', '', 'campo-alegre', '', ''),
(13050, 84, 0, 2, 'Campo Belo do Sul', '', 'campo-belo-do-sul', '', ''),
(13051, 84, 0, 2, 'Campo Erê', '', 'campo-ere', '', ''),
(13052, 84, 0, 2, 'Campos Novos', '', 'campos-novos', '', ''),
(13053, 84, 0, 2, 'Canelinha', '', 'canelinha', '', ''),
(13054, 84, 0, 2, 'Canoinhas', '', 'canoinhas', '', ''),
(13055, 84, 0, 2, 'Capão Alto', '', 'capao-alto', '', ''),
(13056, 84, 0, 2, 'Capinzal', '', 'capinzal', '', ''),
(13057, 84, 0, 2, 'Capivari de Baixo', '', 'capivari-de-baixo', '', ''),
(13058, 84, 0, 2, 'Catanduvas', '', 'catanduvas', '', ''),
(13059, 84, 0, 2, 'Caxambu do Sul', '', 'caxambu-do-sul', '', ''),
(13060, 84, 0, 2, 'Celso Ramos', '', 'celso-ramos', '', ''),
(13061, 84, 0, 2, 'Cerro Negro', '', 'cerro-negro', '', ''),
(13062, 84, 0, 2, 'Chapadão do Lageado', '', 'chapadao-do-lageado', '', ''),
(13063, 84, 0, 2, 'Chapecó', '', 'chapeco', '', ''),
(13064, 84, 0, 2, 'Cocal do Sul', '', 'cocal-do-sul', '', ''),
(13065, 84, 0, 2, 'Concórdia', '', 'concordia', '', ''),
(13066, 84, 0, 2, 'Cordilheira Alta', '', 'cordilheira-alta', '', ''),
(13067, 84, 0, 2, 'Coronel Freitas', '', 'coronel-freitas', '', ''),
(13068, 84, 0, 2, 'Coronel Martins', '', 'coronel-martins', '', ''),
(13069, 84, 0, 2, 'Correia Pinto', '', 'correia-pinto', '', ''),
(13070, 84, 0, 2, 'Corupá', '', 'corupa', '', ''),
(13071, 84, 0, 2, 'Criciúma', '', 'criciuma', '', ''),
(13072, 84, 0, 2, 'Cunha Porã', '', 'cunha-pora', '', ''),
(13073, 84, 0, 2, 'Cunhataí', '', 'cunhatai', '', ''),
(13074, 84, 0, 2, 'Curitibanos', '', 'curitibanos', '', ''),
(13075, 84, 0, 2, 'Descanso', '', 'descanso', '', ''),
(13076, 84, 0, 2, 'Dionísio Cerqueira', '', 'dionisio-cerqueira', '', ''),
(13077, 84, 0, 2, 'Dona Emma', '', 'dona-emma', '', ''),
(13078, 84, 0, 2, 'Doutor Pedrinho', '', 'doutor-pedrinho', '', ''),
(13079, 84, 0, 2, 'Entre Rios', '', 'entre-rios', '', ''),
(13080, 84, 0, 2, 'Ermo', '', 'ermo', '', ''),
(13081, 84, 0, 2, 'Erval Velho', '', 'erval-velho', '', ''),
(13082, 84, 0, 2, 'Faxinal dos Guedes', '', 'faxinal-dos-guedes', '', ''),
(13083, 84, 0, 2, 'Flor do Sertão', '', 'flor-do-sertao', '', ''),
(13084, 84, 0, 2, 'Florianópolis', '', 'florianopolis', '', ''),
(13085, 84, 0, 2, 'Formosa do Sul', '', 'formosa-do-sul', '', ''),
(13086, 84, 0, 2, 'Forquilhinha', '', 'forquilhinha', '', ''),
(13087, 84, 0, 2, 'Fraiburgo', '', 'fraiburgo', '', ''),
(13088, 84, 0, 2, 'Frei Rogério', '', 'frei-rogerio', '', ''),
(13089, 84, 0, 2, 'Galvão', '', 'galvao', '', ''),
(13090, 84, 0, 2, 'Garopaba', '', 'garopaba', '', ''),
(13091, 84, 0, 2, 'Garuva', '', 'garuva', '', ''),
(13092, 84, 0, 2, 'Gaspar', '', 'gaspar', '', ''),
(13093, 84, 0, 2, 'Governador Celso Ramos', '', 'governador-celso-ramos', '', ''),
(13094, 84, 0, 2, 'Grão Pará', '', 'grao-para', '', ''),
(13095, 84, 0, 2, 'Gravatal', '', 'gravatal', '', ''),
(13096, 84, 0, 2, 'Guabiruba', '', 'guabiruba', '', ''),
(13097, 84, 0, 2, 'Guaraciaba', '', 'guaraciaba', '', ''),
(13098, 84, 0, 2, 'Guaramirim', '', 'guaramirim', '', ''),
(13099, 84, 0, 2, 'Guarujá do Sul', '', 'guaruja-do-sul', '', ''),
(13100, 84, 0, 2, 'Guatambú', '', 'guatambu', '', ''),
(13101, 84, 0, 2, 'Herval d`Oeste', '', 'herval-d`oeste', '', ''),
(13102, 84, 0, 2, 'Ibiam', '', 'ibiam', '', ''),
(13103, 84, 0, 2, 'Ibicaré', '', 'ibicare', '', ''),
(13104, 84, 0, 2, 'Ibirama', '', 'ibirama', '', ''),
(13105, 84, 0, 2, 'Içara', '', 'icara', '', ''),
(13106, 84, 0, 2, 'Ilhota', '', 'ilhota', '', ''),
(13107, 84, 0, 2, 'Imaruí', '', 'imarui', '', ''),
(13108, 84, 0, 2, 'Imbituba', '', 'imbituba', '', ''),
(13109, 84, 0, 2, 'Imbuia', '', 'imbuia', '', ''),
(13110, 84, 0, 2, 'Indaial', '', 'indaial', '', ''),
(13111, 84, 0, 2, 'Iomerê', '', 'iomere', '', ''),
(13112, 84, 0, 2, 'Ipira', '', 'ipira', '', ''),
(13113, 84, 0, 2, 'Iporã do Oeste', '', 'ipora-do-oeste', '', ''),
(13114, 84, 0, 2, 'Ipuaçu', '', 'ipuacu', '', ''),
(13115, 84, 0, 2, 'Ipumirim', '', 'ipumirim', '', ''),
(13116, 84, 0, 2, 'Iraceminha', '', 'iraceminha', '', ''),
(13117, 84, 0, 2, 'Irani', '', 'irani', '', ''),
(13118, 84, 0, 2, 'Irati', '', 'irati', '', ''),
(13119, 84, 0, 2, 'Irineópolis', '', 'irineopolis', '', ''),
(13120, 84, 0, 2, 'Itá', '', 'ita', '', ''),
(13121, 84, 0, 2, 'Itaiópolis', '', 'itaiopolis', '', ''),
(13122, 84, 0, 2, 'Itajaí', '', 'itajai', '', ''),
(13123, 84, 0, 2, 'Itapema', '', 'itapema', '', ''),
(13124, 84, 0, 2, 'Itapiranga', '', 'itapiranga', '', ''),
(13125, 84, 0, 2, 'Itapoá', '', 'itapoa', '', ''),
(13126, 84, 0, 2, 'Ituporanga', '', 'ituporanga', '', ''),
(13127, 84, 0, 2, 'Jaborá', '', 'jabora', '', ''),
(13128, 84, 0, 2, 'Jacinto Machado', '', 'jacinto-machado', '', ''),
(13129, 84, 0, 2, 'Jaguaruna', '', 'jaguaruna', '', ''),
(13130, 84, 0, 2, 'Jaraguá do Sul', '', 'jaragua-do-sul', '', ''),
(13131, 84, 0, 2, 'Jardinópolis', '', 'jardinopolis', '', ''),
(13132, 84, 0, 2, 'Joaçaba', '', 'joacaba', '', ''),
(13133, 84, 0, 2, 'Joinville', '', 'joinville', '', ''),
(13134, 84, 0, 2, 'José Boiteux', '', 'jose-boiteux', '', ''),
(13135, 84, 0, 2, 'Jupiá', '', 'jupia', '', ''),
(13136, 84, 0, 2, 'Lacerdópolis', '', 'lacerdopolis', '', ''),
(13137, 84, 0, 2, 'Lages', '', 'lages', '', ''),
(13138, 84, 0, 2, 'Laguna', '', 'laguna', '', ''),
(13139, 84, 0, 2, 'Lajeado Grande', '', 'lajeado-grande', '', ''),
(13140, 84, 0, 2, 'Laurentino', '', 'laurentino', '', ''),
(13141, 84, 0, 2, 'Lauro Muller', '', 'lauro-muller', '', ''),
(13142, 84, 0, 2, 'Lebon Régis', '', 'lebon-regis', '', ''),
(13143, 84, 0, 2, 'Leoberto Leal', '', 'leoberto-leal', '', ''),
(13144, 84, 0, 2, 'Lindóia do Sul', '', 'lindoia-do-sul', '', ''),
(13145, 84, 0, 2, 'Lontras', '', 'lontras', '', ''),
(13146, 84, 0, 2, 'Luiz Alves', '', 'luiz-alves', '', ''),
(13147, 84, 0, 2, 'Luzerna', '', 'luzerna', '', ''),
(13148, 84, 0, 2, 'Macieira', '', 'macieira', '', ''),
(13149, 84, 0, 2, 'Mafra', '', 'mafra', '', ''),
(13150, 84, 0, 2, 'Major Gercino', '', 'major-gercino', '', ''),
(13151, 84, 0, 2, 'Major Vieira', '', 'major-vieira', '', ''),
(13152, 84, 0, 2, 'Maracajá', '', 'maracaja', '', ''),
(13153, 84, 0, 2, 'Maravilha', '', 'maravilha', '', ''),
(13154, 84, 0, 2, 'Marema', '', 'marema', '', ''),
(13155, 84, 0, 2, 'Massaranduba', '', 'massaranduba', '', ''),
(13156, 84, 0, 2, 'Matos Costa', '', 'matos-costa', '', ''),
(13157, 84, 0, 2, 'Meleiro', '', 'meleiro', '', ''),
(13158, 84, 0, 2, 'Mirim Doce', '', 'mirim-doce', '', ''),
(13159, 84, 0, 2, 'Modelo', '', 'modelo', '', ''),
(13160, 84, 0, 2, 'Mondaí', '', 'mondai', '', ''),
(13161, 84, 0, 2, 'Monte Carlo', '', 'monte-carlo', '', ''),
(13162, 84, 0, 2, 'Monte Castelo', '', 'monte-castelo', '', ''),
(13163, 84, 0, 2, 'Morro da Fumaça', '', 'morro-da-fumaca', '', ''),
(13164, 84, 0, 2, 'Morro Grande', '', 'morro-grande', '', ''),
(13165, 84, 0, 2, 'Navegantes', '', 'navegantes', '', ''),
(13166, 84, 0, 2, 'Nova Erechim', '', 'nova-erechim', '', ''),
(13167, 84, 0, 2, 'Nova Itaberaba', '', 'nova-itaberaba', '', ''),
(13168, 84, 0, 2, 'Nova Trento', '', 'nova-trento', '', ''),
(13169, 84, 0, 2, 'Nova Veneza', '', 'nova-veneza', '', ''),
(13170, 84, 0, 2, 'Novo Horizonte', '', 'novo-horizonte', '', ''),
(13171, 84, 0, 2, 'Orleans', '', 'orleans', '', ''),
(13172, 84, 0, 2, 'Otacílio Costa', '', 'otacilio-costa', '', ''),
(13173, 84, 0, 2, 'Ouro', '', 'ouro', '', ''),
(13174, 84, 0, 2, 'Ouro Verde', '', 'ouro-verde', '', ''),
(13175, 84, 0, 2, 'Paial', '', 'paial', '', ''),
(13176, 84, 0, 2, 'Painel', '', 'painel', '', ''),
(13177, 84, 0, 2, 'Palhoça', '', 'palhoca', '', ''),
(13178, 84, 0, 2, 'Palma Sola', '', 'palma-sola', '', ''),
(13179, 84, 0, 2, 'Palmeira', '', 'palmeira', '', ''),
(13180, 84, 0, 2, 'Palmitos', '', 'palmitos', '', ''),
(13181, 84, 0, 2, 'Papanduva', '', 'papanduva', '', ''),
(13182, 84, 0, 2, 'Paraíso', '', 'paraiso', '', ''),
(13183, 84, 0, 2, 'Passo de Torres', '', 'passo-de-torres', '', ''),
(13184, 84, 0, 2, 'Passos Maia', '', 'passos-maia', '', ''),
(13185, 84, 0, 2, 'Paulo Lopes', '', 'paulo-lopes', '', ''),
(13186, 84, 0, 2, 'Pedras Grandes', '', 'pedras-grandes', '', ''),
(13187, 84, 0, 2, 'Penha', '', 'penha', '', ''),
(13188, 84, 0, 2, 'Peritiba', '', 'peritiba', '', ''),
(13189, 84, 0, 2, 'Petrolândia', '', 'petrolandia', '', ''),
(13190, 84, 0, 2, 'Piçarras', '', 'picarras', '', ''),
(13191, 84, 0, 2, 'Pinhalzinho', '', 'pinhalzinho', '', ''),
(13192, 84, 0, 2, 'Pinheiro Preto', '', 'pinheiro-preto', '', ''),
(13193, 84, 0, 2, 'Piratuba', '', 'piratuba', '', ''),
(13194, 84, 0, 2, 'Planalto Alegre', '', 'planalto-alegre', '', ''),
(13195, 84, 0, 2, 'Pomerode', '', 'pomerode', '', ''),
(13196, 84, 0, 2, 'Ponte Alta', '', 'ponte-alta', '', ''),
(13197, 84, 0, 2, 'Ponte Alta do Norte', '', 'ponte-alta-do-norte', '', ''),
(13198, 84, 0, 2, 'Ponte Serrada', '', 'ponte-serrada', '', ''),
(13199, 84, 0, 2, 'Porto Belo', '', 'porto-belo', '', ''),
(13200, 84, 0, 2, 'Porto União', '', 'porto-uniao', '', ''),
(13201, 84, 0, 2, 'Pouso Redondo', '', 'pouso-redondo', '', ''),
(13202, 84, 0, 2, 'Praia Grande', '', 'praia-grande', '', ''),
(13203, 84, 0, 2, 'Presidente Castelo Branco', '', 'presidente-castelo-branco', '', ''),
(13204, 84, 0, 2, 'Presidente Getúlio', '', 'presidente-getulio', '', ''),
(13205, 84, 0, 2, 'Presidente Nereu', '', 'presidente-nereu', '', ''),
(13206, 84, 0, 2, 'Princesa', '', 'princesa', '', ''),
(13207, 84, 0, 2, 'Quilombo', '', 'quilombo', '', ''),
(13208, 84, 0, 2, 'Rancho Queimado', '', 'rancho-queimado', '', ''),
(13209, 84, 0, 2, 'Rio das Antas', '', 'rio-das-antas', '', ''),
(13210, 84, 0, 2, 'Rio do Campo', '', 'rio-do-campo', '', ''),
(13211, 84, 0, 2, 'Rio do Oeste', '', 'rio-do-oeste', '', ''),
(13212, 84, 0, 2, 'Rio do Sul', '', 'rio-do-sul', '', ''),
(13213, 84, 0, 2, 'Rio dos Cedros', '', 'rio-dos-cedros', '', ''),
(13214, 84, 0, 2, 'Rio Fortuna', '', 'rio-fortuna', '', ''),
(13215, 84, 0, 2, 'Rio Negrinho', '', 'rio-negrinho', '', ''),
(13216, 84, 0, 2, 'Rio Rufino', '', 'rio-rufino', '', ''),
(13217, 84, 0, 2, 'Riqueza', '', 'riqueza', '', ''),
(13218, 84, 0, 2, 'Rodeio', '', 'rodeio', '', ''),
(13219, 84, 0, 2, 'Romelândia', '', 'romelandia', '', ''),
(13220, 84, 0, 2, 'Salete', '', 'salete', '', ''),
(13221, 84, 0, 2, 'Saltinho', '', 'saltinho', '', ''),
(13222, 84, 0, 2, 'Salto Veloso', '', 'salto-veloso', '', ''),
(13223, 84, 0, 2, 'Sangão', '', 'sangao', '', ''),
(13224, 84, 0, 2, 'Santa Cecília', '', 'santa-cecilia', '', ''),
(13225, 84, 0, 2, 'Santa Helena', '', 'santa-helena', '', ''),
(13226, 84, 0, 2, 'Santa Rosa de Lima', '', 'santa-rosa-de-lima', '', ''),
(13227, 84, 0, 2, 'Santa Rosa do Sul', '', 'santa-rosa-do-sul', '', ''),
(13228, 84, 0, 2, 'Santa Terezinha', '', 'santa-terezinha', '', ''),
(13229, 84, 0, 2, 'Santa Terezinha do Progresso', '', 'santa-terezinha-do-progresso', '', ''),
(13230, 84, 0, 2, 'Santiago do Sul', '', 'santiago-do-sul', '', ''),
(13231, 84, 0, 2, 'Santo Amaro da Imperatriz', '', 'santo-amaro-da-imperatriz', '', ''),
(13232, 84, 0, 2, 'São Bento do Sul', '', 'sao-bento-do-sul', '', ''),
(13233, 84, 0, 2, 'São Bernardino', '', 'sao-bernardino', '', ''),
(13234, 84, 0, 2, 'São Bonifácio', '', 'sao-bonifacio', '', ''),
(13235, 84, 0, 2, 'São Carlos', '', 'sao-carlos', '', ''),
(13236, 84, 0, 2, 'São Cristovão do Sul', '', 'sao-cristovao-do-sul', '', ''),
(13237, 84, 0, 2, 'São Domingos', '', 'sao-domingos', '', ''),
(13238, 84, 0, 2, 'São Francisco do Sul', '', 'sao-francisco-do-sul', '', ''),
(13239, 84, 0, 2, 'São João Batista', '', 'sao-joao-batista', '', ''),
(13240, 84, 0, 2, 'São João do Itaperiú', '', 'sao-joao-do-itaperiu', '', ''),
(13241, 84, 0, 2, 'São João do Oeste', '', 'sao-joao-do-oeste', '', ''),
(13242, 84, 0, 2, 'São João do Sul', '', 'sao-joao-do-sul', '', ''),
(13243, 84, 0, 2, 'São Joaquim', '', 'sao-joaquim', '', ''),
(13244, 84, 0, 2, 'São José', '', 'sao-jose', '', ''),
(13245, 84, 0, 2, 'São José do Cedro', '', 'sao-jose-do-cedro', '', ''),
(13246, 84, 0, 2, 'São José do Cerrito', '', 'sao-jose-do-cerrito', '', ''),
(13247, 84, 0, 2, 'São Lourenço do Oeste', '', 'sao-lourenco-do-oeste', '', ''),
(13248, 84, 0, 2, 'São Ludgero', '', 'sao-ludgero', '', ''),
(13249, 84, 0, 2, 'São Martinho', '', 'sao-martinho', '', ''),
(13250, 84, 0, 2, 'São Miguel da Boa Vista', '', 'sao-miguel-da-boa-vista', '', ''),
(13251, 84, 0, 2, 'São Miguel do Oeste', '', 'sao-miguel-do-oeste', '', ''),
(13252, 84, 0, 2, 'São Pedro de Alcântara', '', 'sao-pedro-de-alcantara', '', ''),
(13253, 84, 0, 2, 'Saudades', '', 'saudades', '', ''),
(13254, 84, 0, 2, 'Schroeder', '', 'schroeder', '', ''),
(13255, 84, 0, 2, 'Seara', '', 'seara', '', ''),
(13256, 84, 0, 2, 'Serra Alta', '', 'serra-alta', '', ''),
(13257, 84, 0, 2, 'Siderópolis', '', 'sideropolis', '', ''),
(13258, 84, 0, 2, 'Sombrio', '', 'sombrio', '', ''),
(13259, 84, 0, 2, 'Sul Brasil', '', 'sul-brasil', '', ''),
(13260, 84, 0, 2, 'Taió', '', 'taio', '', ''),
(13261, 84, 0, 2, 'Tangará', '', 'tangara', '', ''),
(13262, 84, 0, 2, 'Tigrinhos', '', 'tigrinhos', '', ''),
(13263, 84, 0, 2, 'Tijucas', '', 'tijucas', '', ''),
(13264, 84, 0, 2, 'Timbé do Sul', '', 'timbe-do-sul', '', ''),
(13265, 84, 0, 2, 'Timbó', '', 'timbo', '', ''),
(13266, 84, 0, 2, 'Timbó Grande', '', 'timbo-grande', '', ''),
(13267, 84, 0, 2, 'Três Barras', '', 'tres-barras', '', ''),
(13268, 84, 0, 2, 'Treviso', '', 'treviso', '', ''),
(13269, 84, 0, 2, 'Treze de Maio', '', 'treze-de-maio', '', ''),
(13270, 84, 0, 2, 'Treze Tílias', '', 'treze-tilias', '', ''),
(13271, 84, 0, 2, 'Trombudo Central', '', 'trombudo-central', '', ''),
(13272, 84, 0, 2, 'Tubarão', '', 'tubarao', '', '');
INSERT INTO Location_4 (id, location_3, location_2, location_1, name, abbreviation, friendly_url, seo_description, seo_keyword