<?php
function get_domain($url)
{
  $pieces = parse_url($url);
  $domain = isset($pieces['host']) ? $pieces['host'] : '';
  if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)) {
    return $regs['domain'];
  }
  return false;
}
function create_config($post_details)
{
	$fp = fopen('../conf/my_config.php', 'w');
	
	if ($fp)
	{
		$content = "<?php \n".
			" \n".
			"/* Database info */ \n".
		
			" define('_DIRECTORYDB_HOST',  '" . $post_details['db_host'] . "'); \n".
			" \n".
			
			" define('_DIRECTORYDB_USER',  '" . $post_details['db_username'] . "'); \n".
			" \n".
			
			" define('_DIRECTORYDB_PASS',  '" . $post_details['db_password'] . "'); \n".
			" \n".
			
			" define('_DIRECTORYDB_NAME',  '" . $post_details['db_name'] . "'); \n".
			" \n".
			
						
			" define('EDIRECTORY_FOLDER',  '" . $post_details['subfolder'] . "'); \n".
			" \n".
			
			
			"?>";

		fputs($fp, $content); 
		fclose($fp); 
		
		$output['display'] = '<div class="msg-win">The configuration file was created successfully.</div>';
		$output['result'] = true;
	}
	else 
	{
		$output['display'] = '<div class="msg-error"><b>Error: Could not create the configuration file.</b><br> '.
			'Please make sure the <b>includes</b> folder has writing permissions and the <b>conf/config.php</b> file doesn\'t already exist.</div>';
		$output['result'] = false;		
	}
	
	return $output;

}

	
function create_domain_file($url)
{
	$fp = fopen('../custom/domain/domain.inc.php', 'w');

	if ($fp)
	{
		$content = "<?php \n".
		
		'$domainInfo["' . $url . '"] = 1; '.
			" \n".
			
			"?>";

		fputs($fp, $content); 
		fclose($fp); 
		
		$output['display'] = '<div class="msg-win">The domain file was created successfully.</div>';
		$output['result'] = true;
	}
	else 
	{
		$output['display'] = '<div class="msg-error"><b>Error: Could not create the domain file.</b><br> '.
			'Please make sure the <b>includes</b> folder has writing permissions and the <b>custom/domain/domain.inc.php</b> file doesn\'t already exist.</div>';
		$output['result'] = false;		
	}
	
	return $output;

}

function create_lic($key)
{
	$fp = fopen('../conf/qaidi_lic.php', 'w');

	if ($fp)
	{
		$content = "<?php \n".
		
			" define('QAIDI_LICENSE',  '" . $key['qaidi_key'] . "'); \n".

			
			"?>";

		fputs($fp, $content); 
		fclose($fp); 
		
		$output['display'] = '<div class="msg-win">license key file created</div>';
		$output['result'] = true;
	}
	else 
	{
		$output['display'] = '<div class="msg-error"><b>Error: Could not create the license file.</b><br> '.
			'Please make sure the <b>includes</b> folder has writing permissions and the <b>conf/qaidi_lic</b> file doesn\'t already exist.</div>';
		$output['result'] = false;		
	}
	
	return $output;

}

// Function For Run Multiple Query From .SQL File
function MultiQuery($sqlfile, $sqldelimiter = ';') {
set_time_limit(0);

if (is_file($sqlfile) === true) {
$sqlfile = fopen($sqlfile, 'r');

if (is_resource($sqlfile) === true) {
$query = array();

while (feof($sqlfile) === false) {
$query[] = fgets($sqlfile);

if (preg_match('~' . preg_quote($sqldelimiter, '~') . '\s*$~iS', end($query)) === 1) {
$query = trim(implode('', $query));

if (mysql_query($query) === false) {
} else {
if(preg_match_all('/((CREATE TABLE IF NOT EXISTS) `(.*)`)/', $query, $matches)) {
    $tables = array_unique($matches[3]);
	    $query=$tables[0];
		echo '<div class="msg-win"><b>' . $query . '</b>  Table successfully Created  </div>';


}
}

while (ob_get_level() ) {
ob_end_flush();
}

flush();
}

if (is_string($query) === true) {
$query = array();
}
}

return fclose($sqlfile);
}
}

return false;
}

	
		function db_formatString($string, $default = "", $import = false, $simpleQuotes = true) {
        if ($import){
            if (!$string){
               $string = "'".$string."'"; 
            } elseif (is_string($string)) {
                if ((string_strpos($string,"\'") !== false) || (string_strpos($string,"\\") !== false) || (string_strpos($string,"\\\"") !== false) || !get_magic_quotes_gpc()){
                    $string = stripslashes($string);
                }
                $string  = addslashes($string);
                $string = "'".$string."'";
            } elseif (is_numeric($string)) {
                return $string;
            } else {
                $string = "'".$string."'";
            }
            return $string;
            
        } else {
            
            if (empty($string) && $string != "0") {
                $string = $default;
            }
            if (($string[0]=="'" && $string[string_strlen($string)-1]=="'") || ($string[0]=='"' && $string[string_strlen($string)-1]=='"')) {
                $string = string_substr($string, 1, string_strlen($string)-2);
            }
            if (db_stringNeedsAddslashes($string)) {
                $string = addslashes($string);
            }
            if ($simpleQuotes){
                return "'".$string."'";
            } else {
                return $string;
            }
        }
		
	}
	function db_stringNeedsAddslashes($str) {
		if (($qp = string_strpos($str,"'")) !== false || ($qp = string_strpos($str,"\"")) !== false) {
		if ($str[$qp-1] != "\\")
			return true;
		else
			return db_stringNeedsAddslashes(string_substr($str,$qp+1,string_strlen($str)));
		}
		return false;
	}
	
		function string_strpos($haystack, $needle, $offset = 0, $charset = EDIR_CHARSET) {
		if (isset($haystack) && isset($needle) || (is_numeric($haystack) && is_numeric($needle))) {
			if (is_array($haystack)) $haystack = implode(",", $haystack);
			if (function_exists('mb_strpos')) {
				$position = mb_strpos($haystack, $needle, $offset, $charset);
			} else {
				$position = strpos($haystack, $needle, $offset);
			}
		} else {
			$position = false;
		}
		return $position;
	}
	
	
	
	function setup_header(){
	global $site_url ;
  $put= '
<!doctype html> 
<html prefix="og: http://ogp.me/ns#"> 
 <html dir="ltr" lang="en-US">  
<head>  
<meta http-equiv="content-type" content="text/html;charset=UTF-8">
<title>eDirectory v.10.0.00b Installer By Mr Qaidi</title>
<meta charset="UTF-8">  
<link rel="stylesheet" type="text/css" href="'.$site_url.ADMINCP.'/css/style.css" media="screen" />
<link href="'.$site_url.ADMINCP.'/css/bootstrap.min.css" rel="stylesheet" />
<link rel="stylesheet" href="'.$site_url.ADMINCP.'/css/plugins.css"/>
<link rel="stylesheet" href="'.$site_url.ADMINCP.'/css/font-awesome.css"/>
    <link href=\'http://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800\' rel=\'stylesheet\' type=\'text/css\'>
    <!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
	<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
	 <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.imagesloaded.min.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.tipsy.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/bootstrap.min.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.validation.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.validationEngine-en.js"></script> 	
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.uniform.min.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.tagsinput.min.js"></script>	
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.select2.min.js"></script>	
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.listbox.js"></script>	
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.inputmask.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.inputlimiter.min.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.autosize.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.slimscroll.min.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/jquery.form.js"></script>
<script type="text/javascript" src="'.$site_url.ADMINCP.'/js/scripts.js"></script>
</head><body style="padding:4%;"><div id="" class="ns-row"><span ="menu-title">eDirectory  v.10.0.00b Installer By Mr Qaidi</span></div><div id="wrapper" class="container-fluid"><div id="content"><div class="row-fluid">';
return $put;
    }
	
	
?>