<?php

	/*==================================================================*\
	######################################################################
	#                                                                    #
	# Copyright 2005 Arca Solutions, Inc. All Rights Reserved.           #
	#                                                                    #
	# This file may not be redistributed in whole or part.               #
	# eDirectory is licensed on a per-domain basis.                      #
	#                                                                    #
	# ---------------- eDirectory IS NOT FREE SOFTWARE ----------------- #
	#                                                                    #
	# http://www.edirectory.com | http://www.edirectory.com/license.html #
	######################################################################
	\*==================================================================*/

	# ----------------------------------------------------------------------------------------------------
	# * FILE: /sitemgr/listingtemplate/view.php
	# ----------------------------------------------------------------------------------------------------

	# ----------------------------------------------------------------------------------------------------
	# LOAD CONFIG
	# ----------------------------------------------------------------------------------------------------
	include("../../conf/loadconfig.inc.php");

	# ----------------------------------------------------------------------------------------------------
	# VALIDATE FEATURE
	# ----------------------------------------------------------------------------------------------------
	if (LISTINGTEMPLATE_FEATURE != "on" || USING_THEME_TEMPLATE || CUSTOM_LISTINGTEMPLATE_FEATURE != "on") { exit; }

	# ----------------------------------------------------------------------------------------------------
	# SESSION
	# ----------------------------------------------------------------------------------------------------
	sess_validateSMSession();
	permission_hasSMPerm();

	extract($_POST);
	extract($_GET);

	$url_search_params = system_getURLSearchParams((($_POST)?($_POST):($_GET)));

	# ----------------------------------------------------------------------------------------------------
	# AUX
	# ----------------------------------------------------------------------------------------------------
	if ($id) {
		$listingTemplate = new ListingTemplate($id);
        if ($listingTemplate->getString("editable") == "n"){
            header("Location: ".DEFAULT_URL."/".SITEMGR_ALIAS."/listingtemplate/".(($search_page) ? "search.php" : "index.php")."?message=".urlencode($message)."&screen=$screen&letter=$letter".(($url_search_params) ? "&$url_search_params" : "")."");
            exit;
        }
	} else {
		header("Location: ".DEFAULT_URL."/".SITEMGR_ALIAS."/listingtemplate/".(($search_page) ? "search.php" : "index.php")."?message=".urlencode($message)."&screen=$screen&letter=$letter".(($url_search_params) ? "&$url_search_params" : "")."");
		exit;
	}

	# ----------------------------------------------------------------------------------------------------
	# HEADER
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/header.php");

	# ----------------------------------------------------------------------------------------------------
	# NAVBAR
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/navbar.php");

?>

<div id="main-right">
	<div id="top-content">
		<div id="header-content">
			<h1><?=string_ucwords(system_showText(LANG_SITEMGR_LISTINGTEMPLATE))?> <?=string_ucwords(system_showText(LANG_SITEMGR_DETAIL))?></h1>
		</div>
	</div>
	<div id="content-content">
		<div class="default-margin">


			<?
			unset($domainObj);
			$domainObj = new Domain(SELECTED_DOMAIN_ID);

			$registeredDomain = $domainObj->getString("url");
			$registeredDomainID = SELECTED_DOMAIN_ID;
			// Decoded and Nulled By Ayman Qaidi
			// website : www.qaidi.info
			// email : mrqaidi@gmail.com
			$mrqaidi="ok";
		   	if ($mrqaidi =="ok") {
				if ($mrqaidi =="ok") {
					?>

					<? if($listingTemplate->getString("id") == 0){ ?>
						<p class="warning"> <?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_ITMIGHTBEDELETED)?></p>
					<? } else { ?>

						<? include(INCLUDES_DIR."/tables/table_listingtemplate_submenu.php"); ?>
						<br>
						<div id="header-view">
							<?=system_showText(LANG_SITEMGR_MANAGE)?> <?=string_ucwords(system_showText(LANG_SITEMGR_LISTINGTEMPLATE))?> - <?=$listingTemplate->getString("title")?>
						</div>
						<ul class="list-view columnListView">
							<li>
								<a href="<?=DEFAULT_URL?>/<?=SITEMGR_ALIAS?>/listingtemplate/template.php?id=<?=$listingTemplate->getNumber("id")?>&screen=<?=$screen?>&letter=<?=$letter?><?=(($url_search_params) ? "&$url_search_params" : "")?>" class="link-view"><?=system_showText(LANG_SITEMGR_EDIT)?> <?=string_ucwords(system_showText(LANG_SITEMGR_LISTINGTEMPLATE))?></a>
							</li>
							<li>
								<a href="<?=DEFAULT_URL?>/<?=SITEMGR_ALIAS?>/listingtemplate/delete.php?id=<?=$listingTemplate->getNumber("id")?>&screen=<?=$screen?>&letter=<?=$letter?><?=(($url_search_params) ? "&$url_search_params" : "")?>" class="link-view"><?=system_showText(LANG_SITEMGR_DELETE)?> <?=string_ucwords(system_showText(LANG_SITEMGR_LISTINGTEMPLATE))?></a>
							</li>
						</ul>

						<ul class="list-view columnListView secondaryListView">
							<li><strong><?=system_showText(LANG_SITEMGR_LASTUPDATED)?>:</strong> <span class="label-field-account"><?=format_date($listingTemplate->getNumber("updated"),DEFAULT_DATE_FORMAT, "datetime")." - ".format_getTimeString($listingTemplate->getNumber("updated"))?></span></li>
							<li><strong><?=system_showText(LANG_SITEMGR_DATECREATED)?>:</strong> <span class="label-field-account"><?=format_date($listingTemplate->getNumber("entered"),DEFAULT_DATE_FORMAT, "datetime")." - ".format_getTimeString($listingTemplate->getNumber("entered"))?></span></li>
						</ul>

						<br class="clear" />
					
						<? include(INCLUDES_DIR."/views/view_listingtemplate.php"); ?>

					<? } ?>

					<?
				} else {
					?><p class="warning"><?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_ACTIVATIONISREQUIRED)?></p><?
				}
			} else {
				?><p class="warning"><?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_ACTIVATIONISREQUIRED)?></p><?
			}
			?>

		</div>
	</div>
	<div id="bottom-content"> </div>
</div>

<?
	# ----------------------------------------------------------------------------------------------------
	# FOOTER
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/footer.php");

?>
